# coding: utf-8

"""
    Taxonomy API

    Use the Taxonomy API to discover the most appropriate eBay categories under which sellers can offer inventory items for sale, and the most likely categories under which buyers can browse or search for items to purchase. In addition, the Taxonomy API provides metadata about the required and recommended category aspects to include in listings, and also has two operations to retrieve parts compatibility information.  # noqa: E501

    OpenAPI spec version: v1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class Aspect(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'aspect_constraint': 'AspectConstraint',
        'aspect_values': 'list[AspectValue]',
        'localized_aspect_name': 'str',
        'relevance_indicator': 'RelevanceIndicator'
    }

    attribute_map = {
        'aspect_constraint': 'aspectConstraint',
        'aspect_values': 'aspectValues',
        'localized_aspect_name': 'localizedAspectName',
        'relevance_indicator': 'relevanceIndicator'
    }

    def __init__(self, aspect_constraint=None, aspect_values=None, localized_aspect_name=None, relevance_indicator=None):  # noqa: E501
        """Aspect - a model defined in Swagger"""  # noqa: E501
        self._aspect_constraint = None
        self._aspect_values = None
        self._localized_aspect_name = None
        self._relevance_indicator = None
        self.discriminator = None
        if aspect_constraint is not None:
            self.aspect_constraint = aspect_constraint
        if aspect_values is not None:
            self.aspect_values = aspect_values
        if localized_aspect_name is not None:
            self.localized_aspect_name = localized_aspect_name
        if relevance_indicator is not None:
            self.relevance_indicator = relevance_indicator

    @property
    def aspect_constraint(self):
        """Gets the aspect_constraint of this Aspect.  # noqa: E501


        :return: The aspect_constraint of this Aspect.  # noqa: E501
        :rtype: AspectConstraint
        """
        return self._aspect_constraint

    @aspect_constraint.setter
    def aspect_constraint(self, aspect_constraint):
        """Sets the aspect_constraint of this Aspect.


        :param aspect_constraint: The aspect_constraint of this Aspect.  # noqa: E501
        :type: AspectConstraint
        """

        self._aspect_constraint = aspect_constraint

    @property
    def aspect_values(self):
        """Gets the aspect_values of this Aspect.  # noqa: E501

        A list of valid values for this aspect (for example: Red, Green, and Blue), along with any constraints on those values.  # noqa: E501

        :return: The aspect_values of this Aspect.  # noqa: E501
        :rtype: list[AspectValue]
        """
        return self._aspect_values

    @aspect_values.setter
    def aspect_values(self, aspect_values):
        """Sets the aspect_values of this Aspect.

        A list of valid values for this aspect (for example: Red, Green, and Blue), along with any constraints on those values.  # noqa: E501

        :param aspect_values: The aspect_values of this Aspect.  # noqa: E501
        :type: list[AspectValue]
        """

        self._aspect_values = aspect_values

    @property
    def localized_aspect_name(self):
        """Gets the localized_aspect_name of this Aspect.  # noqa: E501

        The localized name of this aspect (for example: Colour on the eBay UK site). Note: This name is always localized for the specified marketplace.  # noqa: E501

        :return: The localized_aspect_name of this Aspect.  # noqa: E501
        :rtype: str
        """
        return self._localized_aspect_name

    @localized_aspect_name.setter
    def localized_aspect_name(self, localized_aspect_name):
        """Sets the localized_aspect_name of this Aspect.

        The localized name of this aspect (for example: Colour on the eBay UK site). Note: This name is always localized for the specified marketplace.  # noqa: E501

        :param localized_aspect_name: The localized_aspect_name of this Aspect.  # noqa: E501
        :type: str
        """

        self._localized_aspect_name = localized_aspect_name

    @property
    def relevance_indicator(self):
        """Gets the relevance_indicator of this Aspect.  # noqa: E501


        :return: The relevance_indicator of this Aspect.  # noqa: E501
        :rtype: RelevanceIndicator
        """
        return self._relevance_indicator

    @relevance_indicator.setter
    def relevance_indicator(self, relevance_indicator):
        """Sets the relevance_indicator of this Aspect.


        :param relevance_indicator: The relevance_indicator of this Aspect.  # noqa: E501
        :type: RelevanceIndicator
        """

        self._relevance_indicator = relevance_indicator

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Aspect, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Aspect):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
