# coding: utf-8

"""
    Taxonomy API

    Use the Taxonomy API to discover the most appropriate eBay categories under which sellers can offer inventory items for sale, and the most likely categories under which buyers can browse or search for items to purchase. In addition, the Taxonomy API provides metadata about the required and recommended category aspects to include in listings, and also has two operations to retrieve parts compatibility information.  # noqa: E501

    OpenAPI spec version: v1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class CategoryAspect(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'category': 'Category',
        'aspects': 'list[Aspect]'
    }

    attribute_map = {
        'category': 'category',
        'aspects': 'aspects'
    }

    def __init__(self, category=None, aspects=None):  # noqa: E501
        """CategoryAspect - a model defined in Swagger"""  # noqa: E501
        self._category = None
        self._aspects = None
        self.discriminator = None
        if category is not None:
            self.category = category
        if aspects is not None:
            self.aspects = aspects

    @property
    def category(self):
        """Gets the category of this CategoryAspect.  # noqa: E501


        :return: The category of this CategoryAspect.  # noqa: E501
        :rtype: Category
        """
        return self._category

    @category.setter
    def category(self, category):
        """Sets the category of this CategoryAspect.


        :param category: The category of this CategoryAspect.  # noqa: E501
        :type: Category
        """

        self._category = category

    @property
    def aspects(self):
        """Gets the aspects of this CategoryAspect.  # noqa: E501

        A list of aspect metadata that is used to describe the items in a particular leaf category.  # noqa: E501

        :return: The aspects of this CategoryAspect.  # noqa: E501
        :rtype: list[Aspect]
        """
        return self._aspects

    @aspects.setter
    def aspects(self, aspects):
        """Sets the aspects of this CategoryAspect.

        A list of aspect metadata that is used to describe the items in a particular leaf category.  # noqa: E501

        :param aspects: The aspects of this CategoryAspect.  # noqa: E501
        :type: list[Aspect]
        """

        self._aspects = aspects

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(CategoryAspect, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CategoryAspect):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
