# coding: utf-8

"""
    Taxonomy API

    Use the Taxonomy API to discover the most appropriate eBay categories under which sellers can offer inventory items for sale, and the most likely categories under which buyers can browse or search for items to purchase. In addition, the Taxonomy API provides metadata about the required and recommended category aspects to include in listings, and also has two operations to retrieve parts compatibility information.  # noqa: E501

    OpenAPI spec version: v1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class CategorySuggestionResponse(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'category_suggestions': 'list[CategorySuggestion]',
        'category_tree_id': 'str',
        'category_tree_version': 'str'
    }

    attribute_map = {
        'category_suggestions': 'categorySuggestions',
        'category_tree_id': 'categoryTreeId',
        'category_tree_version': 'categoryTreeVersion'
    }

    def __init__(self, category_suggestions=None, category_tree_id=None, category_tree_version=None):  # noqa: E501
        """CategorySuggestionResponse - a model defined in Swagger"""  # noqa: E501
        self._category_suggestions = None
        self._category_tree_id = None
        self._category_tree_version = None
        self.discriminator = None
        if category_suggestions is not None:
            self.category_suggestions = category_suggestions
        if category_tree_id is not None:
            self.category_tree_id = category_tree_id
        if category_tree_version is not None:
            self.category_tree_version = category_tree_version

    @property
    def category_suggestions(self):
        """Gets the category_suggestions of this CategorySuggestionResponse.  # noqa: E501

        Contains details about one or more suggested categories that correspond to the provided keywords. The array of suggested categories is sorted in order of eBay's confidence of the relevance of each category (the first category is the most relevant). Important: This call is not supported in the Sandbox environment. It will return a response payload in which the categoryName fields contain random or boilerplate text regardless of the query submitted.  # noqa: E501

        :return: The category_suggestions of this CategorySuggestionResponse.  # noqa: E501
        :rtype: list[CategorySuggestion]
        """
        return self._category_suggestions

    @category_suggestions.setter
    def category_suggestions(self, category_suggestions):
        """Sets the category_suggestions of this CategorySuggestionResponse.

        Contains details about one or more suggested categories that correspond to the provided keywords. The array of suggested categories is sorted in order of eBay's confidence of the relevance of each category (the first category is the most relevant). Important: This call is not supported in the Sandbox environment. It will return a response payload in which the categoryName fields contain random or boilerplate text regardless of the query submitted.  # noqa: E501

        :param category_suggestions: The category_suggestions of this CategorySuggestionResponse.  # noqa: E501
        :type: list[CategorySuggestion]
        """

        self._category_suggestions = category_suggestions

    @property
    def category_tree_id(self):
        """Gets the category_tree_id of this CategorySuggestionResponse.  # noqa: E501

        The unique identifier of the eBay category tree from which suggestions are returned.  # noqa: E501

        :return: The category_tree_id of this CategorySuggestionResponse.  # noqa: E501
        :rtype: str
        """
        return self._category_tree_id

    @category_tree_id.setter
    def category_tree_id(self, category_tree_id):
        """Sets the category_tree_id of this CategorySuggestionResponse.

        The unique identifier of the eBay category tree from which suggestions are returned.  # noqa: E501

        :param category_tree_id: The category_tree_id of this CategorySuggestionResponse.  # noqa: E501
        :type: str
        """

        self._category_tree_id = category_tree_id

    @property
    def category_tree_version(self):
        """Gets the category_tree_version of this CategorySuggestionResponse.  # noqa: E501

        The version of the category tree identified by categoryTreeId. It's a good idea to cache this value for comparison so you can determine if this category tree has been modified in subsequent calls.  # noqa: E501

        :return: The category_tree_version of this CategorySuggestionResponse.  # noqa: E501
        :rtype: str
        """
        return self._category_tree_version

    @category_tree_version.setter
    def category_tree_version(self, category_tree_version):
        """Sets the category_tree_version of this CategorySuggestionResponse.

        The version of the category tree identified by categoryTreeId. It's a good idea to cache this value for comparison so you can determine if this category tree has been modified in subsequent calls.  # noqa: E501

        :param category_tree_version: The category_tree_version of this CategorySuggestionResponse.  # noqa: E501
        :type: str
        """

        self._category_tree_version = category_tree_version

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(CategorySuggestionResponse, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CategorySuggestionResponse):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
