# coding: utf-8

"""
    Taxonomy API

    Use the Taxonomy API to discover the most appropriate eBay categories under which sellers can offer inventory items for sale, and the most likely categories under which buyers can browse or search for items to purchase. In addition, the Taxonomy API provides metadata about the required and recommended category aspects to include in listings, and also has two operations to retrieve parts compatibility information.  # noqa: E501

    OpenAPI spec version: v1.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class CategoryTreeNode(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'category': 'Category',
        'category_tree_node_level': 'int',
        'child_category_tree_nodes': 'list[CategoryTreeNode]',
        'leaf_category_tree_node': 'bool',
        'parent_category_tree_node_href': 'str'
    }

    attribute_map = {
        'category': 'category',
        'category_tree_node_level': 'categoryTreeNodeLevel',
        'child_category_tree_nodes': 'childCategoryTreeNodes',
        'leaf_category_tree_node': 'leafCategoryTreeNode',
        'parent_category_tree_node_href': 'parentCategoryTreeNodeHref'
    }

    def __init__(self, category=None, category_tree_node_level=None, child_category_tree_nodes=None, leaf_category_tree_node=None, parent_category_tree_node_href=None):  # noqa: E501
        """CategoryTreeNode - a model defined in Swagger"""  # noqa: E501
        self._category = None
        self._category_tree_node_level = None
        self._child_category_tree_nodes = None
        self._leaf_category_tree_node = None
        self._parent_category_tree_node_href = None
        self.discriminator = None
        if category is not None:
            self.category = category
        if category_tree_node_level is not None:
            self.category_tree_node_level = category_tree_node_level
        if child_category_tree_nodes is not None:
            self.child_category_tree_nodes = child_category_tree_nodes
        if leaf_category_tree_node is not None:
            self.leaf_category_tree_node = leaf_category_tree_node
        if parent_category_tree_node_href is not None:
            self.parent_category_tree_node_href = parent_category_tree_node_href

    @property
    def category(self):
        """Gets the category of this CategoryTreeNode.  # noqa: E501


        :return: The category of this CategoryTreeNode.  # noqa: E501
        :rtype: Category
        """
        return self._category

    @category.setter
    def category(self, category):
        """Sets the category of this CategoryTreeNode.


        :param category: The category of this CategoryTreeNode.  # noqa: E501
        :type: Category
        """

        self._category = category

    @property
    def category_tree_node_level(self):
        """Gets the category_tree_node_level of this CategoryTreeNode.  # noqa: E501

        The absolute level of the current category tree node in the hierarchy of its category tree. Note: The root node of any full category tree is always at level 0.  # noqa: E501

        :return: The category_tree_node_level of this CategoryTreeNode.  # noqa: E501
        :rtype: int
        """
        return self._category_tree_node_level

    @category_tree_node_level.setter
    def category_tree_node_level(self, category_tree_node_level):
        """Sets the category_tree_node_level of this CategoryTreeNode.

        The absolute level of the current category tree node in the hierarchy of its category tree. Note: The root node of any full category tree is always at level 0.  # noqa: E501

        :param category_tree_node_level: The category_tree_node_level of this CategoryTreeNode.  # noqa: E501
        :type: int
        """

        self._category_tree_node_level = category_tree_node_level

    @property
    def child_category_tree_nodes(self):
        """Gets the child_category_tree_nodes of this CategoryTreeNode.  # noqa: E501

        An array of one or more category tree nodes that are the immediate children of the current category tree node, as well as their children, recursively down to the leaf nodes. Returned only if the current category tree node is not a leaf node (the value of leafCategoryTreeNode is false).  # noqa: E501

        :return: The child_category_tree_nodes of this CategoryTreeNode.  # noqa: E501
        :rtype: list[CategoryTreeNode]
        """
        return self._child_category_tree_nodes

    @child_category_tree_nodes.setter
    def child_category_tree_nodes(self, child_category_tree_nodes):
        """Sets the child_category_tree_nodes of this CategoryTreeNode.

        An array of one or more category tree nodes that are the immediate children of the current category tree node, as well as their children, recursively down to the leaf nodes. Returned only if the current category tree node is not a leaf node (the value of leafCategoryTreeNode is false).  # noqa: E501

        :param child_category_tree_nodes: The child_category_tree_nodes of this CategoryTreeNode.  # noqa: E501
        :type: list[CategoryTreeNode]
        """

        self._child_category_tree_nodes = child_category_tree_nodes

    @property
    def leaf_category_tree_node(self):
        """Gets the leaf_category_tree_node of this CategoryTreeNode.  # noqa: E501

        A value of true indicates that the current category tree node is a leaf node (it has no child nodes). A value of false indicates that the current node has one or more child nodes, which are identified by the childCategoryTreeNodes array. Returned only if the value of this field is true.  # noqa: E501

        :return: The leaf_category_tree_node of this CategoryTreeNode.  # noqa: E501
        :rtype: bool
        """
        return self._leaf_category_tree_node

    @leaf_category_tree_node.setter
    def leaf_category_tree_node(self, leaf_category_tree_node):
        """Sets the leaf_category_tree_node of this CategoryTreeNode.

        A value of true indicates that the current category tree node is a leaf node (it has no child nodes). A value of false indicates that the current node has one or more child nodes, which are identified by the childCategoryTreeNodes array. Returned only if the value of this field is true.  # noqa: E501

        :param leaf_category_tree_node: The leaf_category_tree_node of this CategoryTreeNode.  # noqa: E501
        :type: bool
        """

        self._leaf_category_tree_node = leaf_category_tree_node

    @property
    def parent_category_tree_node_href(self):
        """Gets the parent_category_tree_node_href of this CategoryTreeNode.  # noqa: E501

        The href portion of the getCategorySubtree call that retrieves the subtree below the parent of this category tree node. Not returned if the current category tree node is the root node of its tree.  # noqa: E501

        :return: The parent_category_tree_node_href of this CategoryTreeNode.  # noqa: E501
        :rtype: str
        """
        return self._parent_category_tree_node_href

    @parent_category_tree_node_href.setter
    def parent_category_tree_node_href(self, parent_category_tree_node_href):
        """Sets the parent_category_tree_node_href of this CategoryTreeNode.

        The href portion of the getCategorySubtree call that retrieves the subtree below the parent of this category tree node. Not returned if the current category tree node is the root node of its tree.  # noqa: E501

        :param parent_category_tree_node_href: The parent_category_tree_node_href of this CategoryTreeNode.  # noqa: E501
        :type: str
        """

        self._parent_category_tree_node_href = parent_category_tree_node_href

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(CategoryTreeNode, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CategoryTreeNode):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
