# coding: utf-8

"""
    Compliance API

    Service for providing information to sellers about their listings being non-compliant, or at risk for becoming non-compliant, against eBay listing policies.  # noqa: E501

    OpenAPI spec version: 1.4.1
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class AspectRecommendations(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'localized_aspect_name': 'str',
        'suggested_values': 'list[str]'
    }

    attribute_map = {
        'localized_aspect_name': 'localizedAspectName',
        'suggested_values': 'suggestedValues'
    }

    def __init__(self, localized_aspect_name=None, suggested_values=None):  # noqa: E501
        """AspectRecommendations - a model defined in Swagger"""  # noqa: E501
        self._localized_aspect_name = None
        self._suggested_values = None
        self.discriminator = None
        if localized_aspect_name is not None:
            self.localized_aspect_name = localized_aspect_name
        if suggested_values is not None:
            self.suggested_values = suggested_values

    @property
    def localized_aspect_name(self):
        """Gets the localized_aspect_name of this AspectRecommendations.  # noqa: E501

        The name of the item aspect for which eBay has a recommendation. In many cases, the same item aspect(s) that are returned under the violationData array for ASPECTS_ADOPTION listing violations are also returned here Note: This name is always localized for the specified marketplace.  # noqa: E501

        :return: The localized_aspect_name of this AspectRecommendations.  # noqa: E501
        :rtype: str
        """
        return self._localized_aspect_name

    @localized_aspect_name.setter
    def localized_aspect_name(self, localized_aspect_name):
        """Sets the localized_aspect_name of this AspectRecommendations.

        The name of the item aspect for which eBay has a recommendation. In many cases, the same item aspect(s) that are returned under the violationData array for ASPECTS_ADOPTION listing violations are also returned here Note: This name is always localized for the specified marketplace.  # noqa: E501

        :param localized_aspect_name: The localized_aspect_name of this AspectRecommendations.  # noqa: E501
        :type: str
        """

        self._localized_aspect_name = localized_aspect_name

    @property
    def suggested_values(self):
        """Gets the suggested_values of this AspectRecommendations.  # noqa: E501

        One or more valid values for the corresponding item aspect (in localizedAspectName) are returned here. These suggested values for the item aspect depend on the listing category and on the information specified in the listing. Sellers should confirm accuracy of the values before applying them to the listing. Please use getItemAspectsForCategory in the Taxonomy API or GetCategorySpecifics in the Trading API to get a comprehensive list of required and recommended aspects for a given category and a list of supported aspect values for each.  # noqa: E501

        :return: The suggested_values of this AspectRecommendations.  # noqa: E501
        :rtype: list[str]
        """
        return self._suggested_values

    @suggested_values.setter
    def suggested_values(self, suggested_values):
        """Sets the suggested_values of this AspectRecommendations.

        One or more valid values for the corresponding item aspect (in localizedAspectName) are returned here. These suggested values for the item aspect depend on the listing category and on the information specified in the listing. Sellers should confirm accuracy of the values before applying them to the listing. Please use getItemAspectsForCategory in the Taxonomy API or GetCategorySpecifics in the Trading API to get a comprehensive list of required and recommended aspects for a given category and a list of supported aspect values for each.  # noqa: E501

        :param suggested_values: The suggested_values of this AspectRecommendations.  # noqa: E501
        :type: list[str]
        """

        self._suggested_values = suggested_values

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(AspectRecommendations, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AspectRecommendations):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
