# coding: utf-8

"""
    eBay Finances API

    This API is used to retrieve seller payouts and monetary transaction details related to those payouts.  # noqa: E501

    OpenAPI spec version: 1.8.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class TransactionSummaryResponse(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'adjustment_amount': 'Amount',
        'adjustment_booking_entry': 'str',
        'adjustment_count': 'int',
        'balance_transfer_amount': 'Amount',
        'balance_transfer_booking_entry': 'str',
        'balance_transfer_count': 'int',
        'credit_amount': 'Amount',
        'credit_booking_entry': 'str',
        'credit_count': 'int',
        'dispute_amount': 'Amount',
        'dispute_booking_entry': 'str',
        'dispute_count': 'int',
        'non_sale_charge_amount': 'Amount',
        'non_sale_charge_booking_entry': 'str',
        'non_sale_charge_count': 'int',
        'on_hold_amount': 'Amount',
        'on_hold_booking_entry': 'str',
        'on_hold_count': 'int',
        'refund_amount': 'Amount',
        'refund_booking_entry': 'str',
        'refund_count': 'int',
        'shipping_label_amount': 'Amount',
        'shipping_label_booking_entry': 'str',
        'shipping_label_count': 'int',
        'transfer_amount': 'Amount',
        'transfer_booking_entry': 'str',
        'transfer_count': 'int'
    }

    attribute_map = {
        'adjustment_amount': 'adjustmentAmount',
        'adjustment_booking_entry': 'adjustmentBookingEntry',
        'adjustment_count': 'adjustmentCount',
        'balance_transfer_amount': 'balanceTransferAmount',
        'balance_transfer_booking_entry': 'balanceTransferBookingEntry',
        'balance_transfer_count': 'balanceTransferCount',
        'credit_amount': 'creditAmount',
        'credit_booking_entry': 'creditBookingEntry',
        'credit_count': 'creditCount',
        'dispute_amount': 'disputeAmount',
        'dispute_booking_entry': 'disputeBookingEntry',
        'dispute_count': 'disputeCount',
        'non_sale_charge_amount': 'nonSaleChargeAmount',
        'non_sale_charge_booking_entry': 'nonSaleChargeBookingEntry',
        'non_sale_charge_count': 'nonSaleChargeCount',
        'on_hold_amount': 'onHoldAmount',
        'on_hold_booking_entry': 'onHoldBookingEntry',
        'on_hold_count': 'onHoldCount',
        'refund_amount': 'refundAmount',
        'refund_booking_entry': 'refundBookingEntry',
        'refund_count': 'refundCount',
        'shipping_label_amount': 'shippingLabelAmount',
        'shipping_label_booking_entry': 'shippingLabelBookingEntry',
        'shipping_label_count': 'shippingLabelCount',
        'transfer_amount': 'transferAmount',
        'transfer_booking_entry': 'transferBookingEntry',
        'transfer_count': 'transferCount'
    }

    def __init__(self, adjustment_amount=None, adjustment_booking_entry=None, adjustment_count=None, balance_transfer_amount=None, balance_transfer_booking_entry=None, balance_transfer_count=None, credit_amount=None, credit_booking_entry=None, credit_count=None, dispute_amount=None, dispute_booking_entry=None, dispute_count=None, non_sale_charge_amount=None, non_sale_charge_booking_entry=None, non_sale_charge_count=None, on_hold_amount=None, on_hold_booking_entry=None, on_hold_count=None, refund_amount=None, refund_booking_entry=None, refund_count=None, shipping_label_amount=None, shipping_label_booking_entry=None, shipping_label_count=None, transfer_amount=None, transfer_booking_entry=None, transfer_count=None):  # noqa: E501
        """TransactionSummaryResponse - a model defined in Swagger"""  # noqa: E501
        self._adjustment_amount = None
        self._adjustment_booking_entry = None
        self._adjustment_count = None
        self._balance_transfer_amount = None
        self._balance_transfer_booking_entry = None
        self._balance_transfer_count = None
        self._credit_amount = None
        self._credit_booking_entry = None
        self._credit_count = None
        self._dispute_amount = None
        self._dispute_booking_entry = None
        self._dispute_count = None
        self._non_sale_charge_amount = None
        self._non_sale_charge_booking_entry = None
        self._non_sale_charge_count = None
        self._on_hold_amount = None
        self._on_hold_booking_entry = None
        self._on_hold_count = None
        self._refund_amount = None
        self._refund_booking_entry = None
        self._refund_count = None
        self._shipping_label_amount = None
        self._shipping_label_booking_entry = None
        self._shipping_label_count = None
        self._transfer_amount = None
        self._transfer_booking_entry = None
        self._transfer_count = None
        self.discriminator = None
        if adjustment_amount is not None:
            self.adjustment_amount = adjustment_amount
        if adjustment_booking_entry is not None:
            self.adjustment_booking_entry = adjustment_booking_entry
        if adjustment_count is not None:
            self.adjustment_count = adjustment_count
        if balance_transfer_amount is not None:
            self.balance_transfer_amount = balance_transfer_amount
        if balance_transfer_booking_entry is not None:
            self.balance_transfer_booking_entry = balance_transfer_booking_entry
        if balance_transfer_count is not None:
            self.balance_transfer_count = balance_transfer_count
        if credit_amount is not None:
            self.credit_amount = credit_amount
        if credit_booking_entry is not None:
            self.credit_booking_entry = credit_booking_entry
        if credit_count is not None:
            self.credit_count = credit_count
        if dispute_amount is not None:
            self.dispute_amount = dispute_amount
        if dispute_booking_entry is not None:
            self.dispute_booking_entry = dispute_booking_entry
        if dispute_count is not None:
            self.dispute_count = dispute_count
        if non_sale_charge_amount is not None:
            self.non_sale_charge_amount = non_sale_charge_amount
        if non_sale_charge_booking_entry is not None:
            self.non_sale_charge_booking_entry = non_sale_charge_booking_entry
        if non_sale_charge_count is not None:
            self.non_sale_charge_count = non_sale_charge_count
        if on_hold_amount is not None:
            self.on_hold_amount = on_hold_amount
        if on_hold_booking_entry is not None:
            self.on_hold_booking_entry = on_hold_booking_entry
        if on_hold_count is not None:
            self.on_hold_count = on_hold_count
        if refund_amount is not None:
            self.refund_amount = refund_amount
        if refund_booking_entry is not None:
            self.refund_booking_entry = refund_booking_entry
        if refund_count is not None:
            self.refund_count = refund_count
        if shipping_label_amount is not None:
            self.shipping_label_amount = shipping_label_amount
        if shipping_label_booking_entry is not None:
            self.shipping_label_booking_entry = shipping_label_booking_entry
        if shipping_label_count is not None:
            self.shipping_label_count = shipping_label_count
        if transfer_amount is not None:
            self.transfer_amount = transfer_amount
        if transfer_booking_entry is not None:
            self.transfer_booking_entry = transfer_booking_entry
        if transfer_count is not None:
            self.transfer_count = transfer_count

    @property
    def adjustment_amount(self):
        """Gets the adjustment_amount of this TransactionSummaryResponse.  # noqa: E501


        :return: The adjustment_amount of this TransactionSummaryResponse.  # noqa: E501
        :rtype: Amount
        """
        return self._adjustment_amount

    @adjustment_amount.setter
    def adjustment_amount(self, adjustment_amount):
        """Sets the adjustment_amount of this TransactionSummaryResponse.


        :param adjustment_amount: The adjustment_amount of this TransactionSummaryResponse.  # noqa: E501
        :type: Amount
        """

        self._adjustment_amount = adjustment_amount

    @property
    def adjustment_booking_entry(self):
        """Gets the adjustment_booking_entry of this TransactionSummaryResponse.  # noqa: E501

        The credit debit sign indicator for adjustment. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/finances/types/pay:BookingEntryEnum'>eBay API documentation</a>  # noqa: E501

        :return: The adjustment_booking_entry of this TransactionSummaryResponse.  # noqa: E501
        :rtype: str
        """
        return self._adjustment_booking_entry

    @adjustment_booking_entry.setter
    def adjustment_booking_entry(self, adjustment_booking_entry):
        """Sets the adjustment_booking_entry of this TransactionSummaryResponse.

        The credit debit sign indicator for adjustment. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/finances/types/pay:BookingEntryEnum'>eBay API documentation</a>  # noqa: E501

        :param adjustment_booking_entry: The adjustment_booking_entry of this TransactionSummaryResponse.  # noqa: E501
        :type: str
        """

        self._adjustment_booking_entry = adjustment_booking_entry

    @property
    def adjustment_count(self):
        """Gets the adjustment_count of this TransactionSummaryResponse.  # noqa: E501

        Total adjustment count for given payee within a specified period.  # noqa: E501

        :return: The adjustment_count of this TransactionSummaryResponse.  # noqa: E501
        :rtype: int
        """
        return self._adjustment_count

    @adjustment_count.setter
    def adjustment_count(self, adjustment_count):
        """Sets the adjustment_count of this TransactionSummaryResponse.

        Total adjustment count for given payee within a specified period.  # noqa: E501

        :param adjustment_count: The adjustment_count of this TransactionSummaryResponse.  # noqa: E501
        :type: int
        """

        self._adjustment_count = adjustment_count

    @property
    def balance_transfer_amount(self):
        """Gets the balance_transfer_amount of this TransactionSummaryResponse.  # noqa: E501


        :return: The balance_transfer_amount of this TransactionSummaryResponse.  # noqa: E501
        :rtype: Amount
        """
        return self._balance_transfer_amount

    @balance_transfer_amount.setter
    def balance_transfer_amount(self, balance_transfer_amount):
        """Sets the balance_transfer_amount of this TransactionSummaryResponse.


        :param balance_transfer_amount: The balance_transfer_amount of this TransactionSummaryResponse.  # noqa: E501
        :type: Amount
        """

        self._balance_transfer_amount = balance_transfer_amount

    @property
    def balance_transfer_booking_entry(self):
        """Gets the balance_transfer_booking_entry of this TransactionSummaryResponse.  # noqa: E501

        The credit debit sign indicator for the balance transfer. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/finances/types/pay:BookingEntryEnum'>eBay API documentation</a>  # noqa: E501

        :return: The balance_transfer_booking_entry of this TransactionSummaryResponse.  # noqa: E501
        :rtype: str
        """
        return self._balance_transfer_booking_entry

    @balance_transfer_booking_entry.setter
    def balance_transfer_booking_entry(self, balance_transfer_booking_entry):
        """Sets the balance_transfer_booking_entry of this TransactionSummaryResponse.

        The credit debit sign indicator for the balance transfer. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/finances/types/pay:BookingEntryEnum'>eBay API documentation</a>  # noqa: E501

        :param balance_transfer_booking_entry: The balance_transfer_booking_entry of this TransactionSummaryResponse.  # noqa: E501
        :type: str
        """

        self._balance_transfer_booking_entry = balance_transfer_booking_entry

    @property
    def balance_transfer_count(self):
        """Gets the balance_transfer_count of this TransactionSummaryResponse.  # noqa: E501

        The total balance transfer count for given payee within the specified period.  # noqa: E501

        :return: The balance_transfer_count of this TransactionSummaryResponse.  # noqa: E501
        :rtype: int
        """
        return self._balance_transfer_count

    @balance_transfer_count.setter
    def balance_transfer_count(self, balance_transfer_count):
        """Sets the balance_transfer_count of this TransactionSummaryResponse.

        The total balance transfer count for given payee within the specified period.  # noqa: E501

        :param balance_transfer_count: The balance_transfer_count of this TransactionSummaryResponse.  # noqa: E501
        :type: int
        """

        self._balance_transfer_count = balance_transfer_count

    @property
    def credit_amount(self):
        """Gets the credit_amount of this TransactionSummaryResponse.  # noqa: E501


        :return: The credit_amount of this TransactionSummaryResponse.  # noqa: E501
        :rtype: Amount
        """
        return self._credit_amount

    @credit_amount.setter
    def credit_amount(self, credit_amount):
        """Sets the credit_amount of this TransactionSummaryResponse.


        :param credit_amount: The credit_amount of this TransactionSummaryResponse.  # noqa: E501
        :type: Amount
        """

        self._credit_amount = credit_amount

    @property
    def credit_booking_entry(self):
        """Gets the credit_booking_entry of this TransactionSummaryResponse.  # noqa: E501

        The enumeration value indicates whether the dollar amount in the creditAmount field is a charge (debit) to the seller or a credit. Typically, the enumeration value returned here will be CREDIT. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/finances/types/pay:BookingEntryEnum'>eBay API documentation</a>  # noqa: E501

        :return: The credit_booking_entry of this TransactionSummaryResponse.  # noqa: E501
        :rtype: str
        """
        return self._credit_booking_entry

    @credit_booking_entry.setter
    def credit_booking_entry(self, credit_booking_entry):
        """Sets the credit_booking_entry of this TransactionSummaryResponse.

        The enumeration value indicates whether the dollar amount in the creditAmount field is a charge (debit) to the seller or a credit. Typically, the enumeration value returned here will be CREDIT. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/finances/types/pay:BookingEntryEnum'>eBay API documentation</a>  # noqa: E501

        :param credit_booking_entry: The credit_booking_entry of this TransactionSummaryResponse.  # noqa: E501
        :type: str
        """

        self._credit_booking_entry = credit_booking_entry

    @property
    def credit_count(self):
        """Gets the credit_count of this TransactionSummaryResponse.  # noqa: E501

        This integer value indicates the total number of the seller's sales and/or credits that match the input criteria. Note: Unless the transactionType filter is used in the request to retrieve a specific type of monetary transaction (sale, buyer refund, or seller credit), the creditCount and creditAmount fields account for both order sales and seller credits (the count and value is not distinguished between the two monetary transaction types). This field is generally returned, even if 0, but it will not be returned if a transactionType filter is used, and its value is set to either REFUND, DISPUTE, or SHIPPING_LABEL.  # noqa: E501

        :return: The credit_count of this TransactionSummaryResponse.  # noqa: E501
        :rtype: int
        """
        return self._credit_count

    @credit_count.setter
    def credit_count(self, credit_count):
        """Sets the credit_count of this TransactionSummaryResponse.

        This integer value indicates the total number of the seller's sales and/or credits that match the input criteria. Note: Unless the transactionType filter is used in the request to retrieve a specific type of monetary transaction (sale, buyer refund, or seller credit), the creditCount and creditAmount fields account for both order sales and seller credits (the count and value is not distinguished between the two monetary transaction types). This field is generally returned, even if 0, but it will not be returned if a transactionType filter is used, and its value is set to either REFUND, DISPUTE, or SHIPPING_LABEL.  # noqa: E501

        :param credit_count: The credit_count of this TransactionSummaryResponse.  # noqa: E501
        :type: int
        """

        self._credit_count = credit_count

    @property
    def dispute_amount(self):
        """Gets the dispute_amount of this TransactionSummaryResponse.  # noqa: E501


        :return: The dispute_amount of this TransactionSummaryResponse.  # noqa: E501
        :rtype: Amount
        """
        return self._dispute_amount

    @dispute_amount.setter
    def dispute_amount(self, dispute_amount):
        """Sets the dispute_amount of this TransactionSummaryResponse.


        :param dispute_amount: The dispute_amount of this TransactionSummaryResponse.  # noqa: E501
        :type: Amount
        """

        self._dispute_amount = dispute_amount

    @property
    def dispute_booking_entry(self):
        """Gets the dispute_booking_entry of this TransactionSummaryResponse.  # noqa: E501

        The enumeration value indicates whether the dollar amount in the disputeAmount field is a charge (debit) to the seller or a credit. Typically, the enumeration value returned here will be DEBIT, but its possible that CREDIT could be returned if the seller contested one or more payment disputes and won the dispute. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/finances/types/pay:BookingEntryEnum'>eBay API documentation</a>  # noqa: E501

        :return: The dispute_booking_entry of this TransactionSummaryResponse.  # noqa: E501
        :rtype: str
        """
        return self._dispute_booking_entry

    @dispute_booking_entry.setter
    def dispute_booking_entry(self, dispute_booking_entry):
        """Sets the dispute_booking_entry of this TransactionSummaryResponse.

        The enumeration value indicates whether the dollar amount in the disputeAmount field is a charge (debit) to the seller or a credit. Typically, the enumeration value returned here will be DEBIT, but its possible that CREDIT could be returned if the seller contested one or more payment disputes and won the dispute. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/finances/types/pay:BookingEntryEnum'>eBay API documentation</a>  # noqa: E501

        :param dispute_booking_entry: The dispute_booking_entry of this TransactionSummaryResponse.  # noqa: E501
        :type: str
        """

        self._dispute_booking_entry = dispute_booking_entry

    @property
    def dispute_count(self):
        """Gets the dispute_count of this TransactionSummaryResponse.  # noqa: E501

        This integer value indicates the total number of payment disputes that have been initiated by one or more buyers. Only the orders that match the input criteria are considered. The Payment Disputes methods in the Fulfillment API can be used by the seller to retrieve more information about any payment disputes. This field is generally returned, even if 0, but it will not be returned if a transactionType filter is used, and its value is set to any value other than DISPUTE.  # noqa: E501

        :return: The dispute_count of this TransactionSummaryResponse.  # noqa: E501
        :rtype: int
        """
        return self._dispute_count

    @dispute_count.setter
    def dispute_count(self, dispute_count):
        """Sets the dispute_count of this TransactionSummaryResponse.

        This integer value indicates the total number of payment disputes that have been initiated by one or more buyers. Only the orders that match the input criteria are considered. The Payment Disputes methods in the Fulfillment API can be used by the seller to retrieve more information about any payment disputes. This field is generally returned, even if 0, but it will not be returned if a transactionType filter is used, and its value is set to any value other than DISPUTE.  # noqa: E501

        :param dispute_count: The dispute_count of this TransactionSummaryResponse.  # noqa: E501
        :type: int
        """

        self._dispute_count = dispute_count

    @property
    def non_sale_charge_amount(self):
        """Gets the non_sale_charge_amount of this TransactionSummaryResponse.  # noqa: E501


        :return: The non_sale_charge_amount of this TransactionSummaryResponse.  # noqa: E501
        :rtype: Amount
        """
        return self._non_sale_charge_amount

    @non_sale_charge_amount.setter
    def non_sale_charge_amount(self, non_sale_charge_amount):
        """Sets the non_sale_charge_amount of this TransactionSummaryResponse.


        :param non_sale_charge_amount: The non_sale_charge_amount of this TransactionSummaryResponse.  # noqa: E501
        :type: Amount
        """

        self._non_sale_charge_amount = non_sale_charge_amount

    @property
    def non_sale_charge_booking_entry(self):
        """Gets the non_sale_charge_booking_entry of this TransactionSummaryResponse.  # noqa: E501

        The credit/debit sign indicator for the non-sale charge. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/finances/types/pay:BookingEntryEnum'>eBay API documentation</a>  # noqa: E501

        :return: The non_sale_charge_booking_entry of this TransactionSummaryResponse.  # noqa: E501
        :rtype: str
        """
        return self._non_sale_charge_booking_entry

    @non_sale_charge_booking_entry.setter
    def non_sale_charge_booking_entry(self, non_sale_charge_booking_entry):
        """Sets the non_sale_charge_booking_entry of this TransactionSummaryResponse.

        The credit/debit sign indicator for the non-sale charge. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/finances/types/pay:BookingEntryEnum'>eBay API documentation</a>  # noqa: E501

        :param non_sale_charge_booking_entry: The non_sale_charge_booking_entry of this TransactionSummaryResponse.  # noqa: E501
        :type: str
        """

        self._non_sale_charge_booking_entry = non_sale_charge_booking_entry

    @property
    def non_sale_charge_count(self):
        """Gets the non_sale_charge_count of this TransactionSummaryResponse.  # noqa: E501

        The total non-sale charge count for given payee within a specified period.  # noqa: E501

        :return: The non_sale_charge_count of this TransactionSummaryResponse.  # noqa: E501
        :rtype: int
        """
        return self._non_sale_charge_count

    @non_sale_charge_count.setter
    def non_sale_charge_count(self, non_sale_charge_count):
        """Sets the non_sale_charge_count of this TransactionSummaryResponse.

        The total non-sale charge count for given payee within a specified period.  # noqa: E501

        :param non_sale_charge_count: The non_sale_charge_count of this TransactionSummaryResponse.  # noqa: E501
        :type: int
        """

        self._non_sale_charge_count = non_sale_charge_count

    @property
    def on_hold_amount(self):
        """Gets the on_hold_amount of this TransactionSummaryResponse.  # noqa: E501


        :return: The on_hold_amount of this TransactionSummaryResponse.  # noqa: E501
        :rtype: Amount
        """
        return self._on_hold_amount

    @on_hold_amount.setter
    def on_hold_amount(self, on_hold_amount):
        """Sets the on_hold_amount of this TransactionSummaryResponse.


        :param on_hold_amount: The on_hold_amount of this TransactionSummaryResponse.  # noqa: E501
        :type: Amount
        """

        self._on_hold_amount = on_hold_amount

    @property
    def on_hold_booking_entry(self):
        """Gets the on_hold_booking_entry of this TransactionSummaryResponse.  # noqa: E501

        The enumeration value indicates whether the dollar amount in the onHoldAmount field is a charge (debit) to the seller or a credit. Typically, the enumeration value returned here will be CREDIT, since on-hold funds should eventually be released as part of a payout to the seller once the hold is cleared. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/finances/types/pay:BookingEntryEnum'>eBay API documentation</a>  # noqa: E501

        :return: The on_hold_booking_entry of this TransactionSummaryResponse.  # noqa: E501
        :rtype: str
        """
        return self._on_hold_booking_entry

    @on_hold_booking_entry.setter
    def on_hold_booking_entry(self, on_hold_booking_entry):
        """Sets the on_hold_booking_entry of this TransactionSummaryResponse.

        The enumeration value indicates whether the dollar amount in the onHoldAmount field is a charge (debit) to the seller or a credit. Typically, the enumeration value returned here will be CREDIT, since on-hold funds should eventually be released as part of a payout to the seller once the hold is cleared. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/finances/types/pay:BookingEntryEnum'>eBay API documentation</a>  # noqa: E501

        :param on_hold_booking_entry: The on_hold_booking_entry of this TransactionSummaryResponse.  # noqa: E501
        :type: str
        """

        self._on_hold_booking_entry = on_hold_booking_entry

    @property
    def on_hold_count(self):
        """Gets the on_hold_count of this TransactionSummaryResponse.  # noqa: E501

        This integer value indicates the total number of order sales where the associated funds are on hold. Only the orders that match the input criteria are considered. This field is generally returned, even if 0, but it will not be returned if a transactionStatus filter is used, and its value is set to any value other than FUNDS_ON_HOLD.  # noqa: E501

        :return: The on_hold_count of this TransactionSummaryResponse.  # noqa: E501
        :rtype: int
        """
        return self._on_hold_count

    @on_hold_count.setter
    def on_hold_count(self, on_hold_count):
        """Sets the on_hold_count of this TransactionSummaryResponse.

        This integer value indicates the total number of order sales where the associated funds are on hold. Only the orders that match the input criteria are considered. This field is generally returned, even if 0, but it will not be returned if a transactionStatus filter is used, and its value is set to any value other than FUNDS_ON_HOLD.  # noqa: E501

        :param on_hold_count: The on_hold_count of this TransactionSummaryResponse.  # noqa: E501
        :type: int
        """

        self._on_hold_count = on_hold_count

    @property
    def refund_amount(self):
        """Gets the refund_amount of this TransactionSummaryResponse.  # noqa: E501


        :return: The refund_amount of this TransactionSummaryResponse.  # noqa: E501
        :rtype: Amount
        """
        return self._refund_amount

    @refund_amount.setter
    def refund_amount(self, refund_amount):
        """Sets the refund_amount of this TransactionSummaryResponse.


        :param refund_amount: The refund_amount of this TransactionSummaryResponse.  # noqa: E501
        :type: Amount
        """

        self._refund_amount = refund_amount

    @property
    def refund_booking_entry(self):
        """Gets the refund_booking_entry of this TransactionSummaryResponse.  # noqa: E501

        The enumeration value indicates whether the dollar amount in the refundAmount field is a charge (debit) to the seller or a credit. Typically, the enumeration value returned here will be DEBIT since this a refund from the seller to the buyer. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/finances/types/pay:BookingEntryEnum'>eBay API documentation</a>  # noqa: E501

        :return: The refund_booking_entry of this TransactionSummaryResponse.  # noqa: E501
        :rtype: str
        """
        return self._refund_booking_entry

    @refund_booking_entry.setter
    def refund_booking_entry(self, refund_booking_entry):
        """Sets the refund_booking_entry of this TransactionSummaryResponse.

        The enumeration value indicates whether the dollar amount in the refundAmount field is a charge (debit) to the seller or a credit. Typically, the enumeration value returned here will be DEBIT since this a refund from the seller to the buyer. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/finances/types/pay:BookingEntryEnum'>eBay API documentation</a>  # noqa: E501

        :param refund_booking_entry: The refund_booking_entry of this TransactionSummaryResponse.  # noqa: E501
        :type: str
        """

        self._refund_booking_entry = refund_booking_entry

    @property
    def refund_count(self):
        """Gets the refund_count of this TransactionSummaryResponse.  # noqa: E501

        This integer value indicates the total number of buyer refunds that match the input criteria. This field is generally returned, even if 0, but it will not be returned if a transactionType filter is used, and its value is set to any value other than REFUND.  # noqa: E501

        :return: The refund_count of this TransactionSummaryResponse.  # noqa: E501
        :rtype: int
        """
        return self._refund_count

    @refund_count.setter
    def refund_count(self, refund_count):
        """Sets the refund_count of this TransactionSummaryResponse.

        This integer value indicates the total number of buyer refunds that match the input criteria. This field is generally returned, even if 0, but it will not be returned if a transactionType filter is used, and its value is set to any value other than REFUND.  # noqa: E501

        :param refund_count: The refund_count of this TransactionSummaryResponse.  # noqa: E501
        :type: int
        """

        self._refund_count = refund_count

    @property
    def shipping_label_amount(self):
        """Gets the shipping_label_amount of this TransactionSummaryResponse.  # noqa: E501


        :return: The shipping_label_amount of this TransactionSummaryResponse.  # noqa: E501
        :rtype: Amount
        """
        return self._shipping_label_amount

    @shipping_label_amount.setter
    def shipping_label_amount(self, shipping_label_amount):
        """Sets the shipping_label_amount of this TransactionSummaryResponse.


        :param shipping_label_amount: The shipping_label_amount of this TransactionSummaryResponse.  # noqa: E501
        :type: Amount
        """

        self._shipping_label_amount = shipping_label_amount

    @property
    def shipping_label_booking_entry(self):
        """Gets the shipping_label_booking_entry of this TransactionSummaryResponse.  # noqa: E501

        The enumeration value indicates whether the dollar amount in the shippingLabelAmount field is a charge (debit) to the seller or a credit. Typically, the enumeration value returned here will be DEBIT, as eBay will charge the seller when eBay shipping labels are purchased, but it can be CREDIT if the seller was refunded for a shipping label or was possibly overcharged for a shipping label. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/finances/types/pay:BookingEntryEnum'>eBay API documentation</a>  # noqa: E501

        :return: The shipping_label_booking_entry of this TransactionSummaryResponse.  # noqa: E501
        :rtype: str
        """
        return self._shipping_label_booking_entry

    @shipping_label_booking_entry.setter
    def shipping_label_booking_entry(self, shipping_label_booking_entry):
        """Sets the shipping_label_booking_entry of this TransactionSummaryResponse.

        The enumeration value indicates whether the dollar amount in the shippingLabelAmount field is a charge (debit) to the seller or a credit. Typically, the enumeration value returned here will be DEBIT, as eBay will charge the seller when eBay shipping labels are purchased, but it can be CREDIT if the seller was refunded for a shipping label or was possibly overcharged for a shipping label. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/finances/types/pay:BookingEntryEnum'>eBay API documentation</a>  # noqa: E501

        :param shipping_label_booking_entry: The shipping_label_booking_entry of this TransactionSummaryResponse.  # noqa: E501
        :type: str
        """

        self._shipping_label_booking_entry = shipping_label_booking_entry

    @property
    def shipping_label_count(self):
        """Gets the shipping_label_count of this TransactionSummaryResponse.  # noqa: E501

        This is the total number of eBay shipping labels purchased by the seller. The count returned here may depend on the specified input criteria.  # noqa: E501

        :return: The shipping_label_count of this TransactionSummaryResponse.  # noqa: E501
        :rtype: int
        """
        return self._shipping_label_count

    @shipping_label_count.setter
    def shipping_label_count(self, shipping_label_count):
        """Sets the shipping_label_count of this TransactionSummaryResponse.

        This is the total number of eBay shipping labels purchased by the seller. The count returned here may depend on the specified input criteria.  # noqa: E501

        :param shipping_label_count: The shipping_label_count of this TransactionSummaryResponse.  # noqa: E501
        :type: int
        """

        self._shipping_label_count = shipping_label_count

    @property
    def transfer_amount(self):
        """Gets the transfer_amount of this TransactionSummaryResponse.  # noqa: E501


        :return: The transfer_amount of this TransactionSummaryResponse.  # noqa: E501
        :rtype: Amount
        """
        return self._transfer_amount

    @transfer_amount.setter
    def transfer_amount(self, transfer_amount):
        """Sets the transfer_amount of this TransactionSummaryResponse.


        :param transfer_amount: The transfer_amount of this TransactionSummaryResponse.  # noqa: E501
        :type: Amount
        """

        self._transfer_amount = transfer_amount

    @property
    def transfer_booking_entry(self):
        """Gets the transfer_booking_entry of this TransactionSummaryResponse.  # noqa: E501

        The enumeration value indicates whether the dollar amount in the transferAmount field is a charge (debit) to the seller or a credit. Typically, the enumeration value returned here will be DEBIT since this a seller reimbursement to eBay for buyer refunds. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/finances/types/pay:BookingEntryEnum'>eBay API documentation</a>  # noqa: E501

        :return: The transfer_booking_entry of this TransactionSummaryResponse.  # noqa: E501
        :rtype: str
        """
        return self._transfer_booking_entry

    @transfer_booking_entry.setter
    def transfer_booking_entry(self, transfer_booking_entry):
        """Sets the transfer_booking_entry of this TransactionSummaryResponse.

        The enumeration value indicates whether the dollar amount in the transferAmount field is a charge (debit) to the seller or a credit. Typically, the enumeration value returned here will be DEBIT since this a seller reimbursement to eBay for buyer refunds. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/finances/types/pay:BookingEntryEnum'>eBay API documentation</a>  # noqa: E501

        :param transfer_booking_entry: The transfer_booking_entry of this TransactionSummaryResponse.  # noqa: E501
        :type: str
        """

        self._transfer_booking_entry = transfer_booking_entry

    @property
    def transfer_count(self):
        """Gets the transfer_count of this TransactionSummaryResponse.  # noqa: E501

        This integer value indicates the total number of buyer refund transfers that match the input criteria. This field is generally returned, even if 0, but it will not be returned if a transactionType filter is used, and its value is set to any value other than TRANSFER.  # noqa: E501

        :return: The transfer_count of this TransactionSummaryResponse.  # noqa: E501
        :rtype: int
        """
        return self._transfer_count

    @transfer_count.setter
    def transfer_count(self, transfer_count):
        """Sets the transfer_count of this TransactionSummaryResponse.

        This integer value indicates the total number of buyer refund transfers that match the input criteria. This field is generally returned, even if 0, but it will not be returned if a transactionType filter is used, and its value is set to any value other than TRANSFER.  # noqa: E501

        :param transfer_count: The transfer_count of this TransactionSummaryResponse.  # noqa: E501
        :type: int
        """

        self._transfer_count = transfer_count

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(TransactionSummaryResponse, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TransactionSummaryResponse):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
