# coding: utf-8

"""
    Fulfillment API

    Use the Fulfillment API to complete the process of packaging, addressing, handling, and shipping each order on behalf of the seller, in accordance with the payment method and timing specified at checkout.  # noqa: E501

    OpenAPI spec version: v1.19.3
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ShippingFulfillment(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'fulfillment_id': 'str',
        'line_items': 'list[LineItemReference]',
        'shipment_tracking_number': 'str',
        'shipped_date': 'str',
        'shipping_carrier_code': 'str'
    }

    attribute_map = {
        'fulfillment_id': 'fulfillmentId',
        'line_items': 'lineItems',
        'shipment_tracking_number': 'shipmentTrackingNumber',
        'shipped_date': 'shippedDate',
        'shipping_carrier_code': 'shippingCarrierCode'
    }

    def __init__(self, fulfillment_id=None, line_items=None, shipment_tracking_number=None, shipped_date=None, shipping_carrier_code=None):  # noqa: E501
        """ShippingFulfillment - a model defined in Swagger"""  # noqa: E501
        self._fulfillment_id = None
        self._line_items = None
        self._shipment_tracking_number = None
        self._shipped_date = None
        self._shipping_carrier_code = None
        self.discriminator = None
        if fulfillment_id is not None:
            self.fulfillment_id = fulfillment_id
        if line_items is not None:
            self.line_items = line_items
        if shipment_tracking_number is not None:
            self.shipment_tracking_number = shipment_tracking_number
        if shipped_date is not None:
            self.shipped_date = shipped_date
        if shipping_carrier_code is not None:
            self.shipping_carrier_code = shipping_carrier_code

    @property
    def fulfillment_id(self):
        """Gets the fulfillment_id of this ShippingFulfillment.  # noqa: E501

        The unique identifier of the fulfillment; for example, 9405509699937003457459. This eBay-generated value is created with a successful createShippingFulfillment call.  # noqa: E501

        :return: The fulfillment_id of this ShippingFulfillment.  # noqa: E501
        :rtype: str
        """
        return self._fulfillment_id

    @fulfillment_id.setter
    def fulfillment_id(self, fulfillment_id):
        """Sets the fulfillment_id of this ShippingFulfillment.

        The unique identifier of the fulfillment; for example, 9405509699937003457459. This eBay-generated value is created with a successful createShippingFulfillment call.  # noqa: E501

        :param fulfillment_id: The fulfillment_id of this ShippingFulfillment.  # noqa: E501
        :type: str
        """

        self._fulfillment_id = fulfillment_id

    @property
    def line_items(self):
        """Gets the line_items of this ShippingFulfillment.  # noqa: E501

        This array contains a list of one or more line items (and purchased quantity) to which the fulfillment applies.  # noqa: E501

        :return: The line_items of this ShippingFulfillment.  # noqa: E501
        :rtype: list[LineItemReference]
        """
        return self._line_items

    @line_items.setter
    def line_items(self, line_items):
        """Sets the line_items of this ShippingFulfillment.

        This array contains a list of one or more line items (and purchased quantity) to which the fulfillment applies.  # noqa: E501

        :param line_items: The line_items of this ShippingFulfillment.  # noqa: E501
        :type: list[LineItemReference]
        """

        self._line_items = line_items

    @property
    def shipment_tracking_number(self):
        """Gets the shipment_tracking_number of this ShippingFulfillment.  # noqa: E501

        The tracking number provided by the shipping carrier for the package shipped in this fulfillment. This field is returned if available.  # noqa: E501

        :return: The shipment_tracking_number of this ShippingFulfillment.  # noqa: E501
        :rtype: str
        """
        return self._shipment_tracking_number

    @shipment_tracking_number.setter
    def shipment_tracking_number(self, shipment_tracking_number):
        """Sets the shipment_tracking_number of this ShippingFulfillment.

        The tracking number provided by the shipping carrier for the package shipped in this fulfillment. This field is returned if available.  # noqa: E501

        :param shipment_tracking_number: The shipment_tracking_number of this ShippingFulfillment.  # noqa: E501
        :type: str
        """

        self._shipment_tracking_number = shipment_tracking_number

    @property
    def shipped_date(self):
        """Gets the shipped_date of this ShippingFulfillment.  # noqa: E501

        The date and time that the fulfillment package was shipped. This timestamp is in ISO 8601 format, which uses the 24-hour Universal Coordinated Time (UTC) clock. This field should only be returned if the package has been shipped. Format: [YYYY]-[MM]-[DD]T[hh]:[mm]:[ss].[sss]Z Example: 2015-08-04T19:09:02.768Z  # noqa: E501

        :return: The shipped_date of this ShippingFulfillment.  # noqa: E501
        :rtype: str
        """
        return self._shipped_date

    @shipped_date.setter
    def shipped_date(self, shipped_date):
        """Sets the shipped_date of this ShippingFulfillment.

        The date and time that the fulfillment package was shipped. This timestamp is in ISO 8601 format, which uses the 24-hour Universal Coordinated Time (UTC) clock. This field should only be returned if the package has been shipped. Format: [YYYY]-[MM]-[DD]T[hh]:[mm]:[ss].[sss]Z Example: 2015-08-04T19:09:02.768Z  # noqa: E501

        :param shipped_date: The shipped_date of this ShippingFulfillment.  # noqa: E501
        :type: str
        """

        self._shipped_date = shipped_date

    @property
    def shipping_carrier_code(self):
        """Gets the shipping_carrier_code of this ShippingFulfillment.  # noqa: E501

        The eBay code identifying the shipping carrier for this fulfillment. This field is returned if available. Note: The Trading API's ShippingCarrierCodeType enumeration type contains the most current list of eBay shipping carrier codes and the countries served by each carrier. See ShippingCarrierCodeType.  # noqa: E501

        :return: The shipping_carrier_code of this ShippingFulfillment.  # noqa: E501
        :rtype: str
        """
        return self._shipping_carrier_code

    @shipping_carrier_code.setter
    def shipping_carrier_code(self, shipping_carrier_code):
        """Sets the shipping_carrier_code of this ShippingFulfillment.

        The eBay code identifying the shipping carrier for this fulfillment. This field is returned if available. Note: The Trading API's ShippingCarrierCodeType enumeration type contains the most current list of eBay shipping carrier codes and the countries served by each carrier. See ShippingCarrierCodeType.  # noqa: E501

        :param shipping_carrier_code: The shipping_carrier_code of this ShippingFulfillment.  # noqa: E501
        :type: str
        """

        self._shipping_carrier_code = shipping_carrier_code

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ShippingFulfillment, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ShippingFulfillment):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
