# coding: utf-8

"""
    Inventory API

    The Inventory API is used to create and manage inventory, and then to publish and manage this inventory on an eBay marketplace. There are also methods in this API that will convert eligible, active eBay listings into the Inventory API model.  # noqa: E501

    OpenAPI spec version: 1.13.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class EbayOfferDetailsWithAll(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'available_quantity': 'int',
        'category_id': 'str',
        'charity': 'Charity',
        'format': 'str',
        'hide_buyer_details': 'bool',
        'include_catalog_product_details': 'bool',
        'listing': 'ListingDetails',
        'listing_description': 'str',
        'listing_duration': 'str',
        'listing_policies': 'ListingPolicies',
        'listing_start_date': 'str',
        'lot_size': 'int',
        'marketplace_id': 'str',
        'merchant_location_key': 'str',
        'offer_id': 'str',
        'pricing_summary': 'PricingSummary',
        'quantity_limit_per_buyer': 'int',
        'secondary_category_id': 'str',
        'sku': 'str',
        'status': 'str',
        'store_category_names': 'list[str]',
        'tax': 'Tax'
    }

    attribute_map = {
        'available_quantity': 'availableQuantity',
        'category_id': 'categoryId',
        'charity': 'charity',
        'format': 'format',
        'hide_buyer_details': 'hideBuyerDetails',
        'include_catalog_product_details': 'includeCatalogProductDetails',
        'listing': 'listing',
        'listing_description': 'listingDescription',
        'listing_duration': 'listingDuration',
        'listing_policies': 'listingPolicies',
        'listing_start_date': 'listingStartDate',
        'lot_size': 'lotSize',
        'marketplace_id': 'marketplaceId',
        'merchant_location_key': 'merchantLocationKey',
        'offer_id': 'offerId',
        'pricing_summary': 'pricingSummary',
        'quantity_limit_per_buyer': 'quantityLimitPerBuyer',
        'secondary_category_id': 'secondaryCategoryId',
        'sku': 'sku',
        'status': 'status',
        'store_category_names': 'storeCategoryNames',
        'tax': 'tax'
    }

    def __init__(self, available_quantity=None, category_id=None, charity=None, format=None, hide_buyer_details=None, include_catalog_product_details=None, listing=None, listing_description=None, listing_duration=None, listing_policies=None, listing_start_date=None, lot_size=None, marketplace_id=None, merchant_location_key=None, offer_id=None, pricing_summary=None, quantity_limit_per_buyer=None, secondary_category_id=None, sku=None, status=None, store_category_names=None, tax=None):  # noqa: E501
        """EbayOfferDetailsWithAll - a model defined in Swagger"""  # noqa: E501
        self._available_quantity = None
        self._category_id = None
        self._charity = None
        self._format = None
        self._hide_buyer_details = None
        self._include_catalog_product_details = None
        self._listing = None
        self._listing_description = None
        self._listing_duration = None
        self._listing_policies = None
        self._listing_start_date = None
        self._lot_size = None
        self._marketplace_id = None
        self._merchant_location_key = None
        self._offer_id = None
        self._pricing_summary = None
        self._quantity_limit_per_buyer = None
        self._secondary_category_id = None
        self._sku = None
        self._status = None
        self._store_category_names = None
        self._tax = None
        self.discriminator = None
        if available_quantity is not None:
            self.available_quantity = available_quantity
        if category_id is not None:
            self.category_id = category_id
        if charity is not None:
            self.charity = charity
        if format is not None:
            self.format = format
        if hide_buyer_details is not None:
            self.hide_buyer_details = hide_buyer_details
        if include_catalog_product_details is not None:
            self.include_catalog_product_details = include_catalog_product_details
        if listing is not None:
            self.listing = listing
        if listing_description is not None:
            self.listing_description = listing_description
        if listing_duration is not None:
            self.listing_duration = listing_duration
        if listing_policies is not None:
            self.listing_policies = listing_policies
        if listing_start_date is not None:
            self.listing_start_date = listing_start_date
        if lot_size is not None:
            self.lot_size = lot_size
        if marketplace_id is not None:
            self.marketplace_id = marketplace_id
        if merchant_location_key is not None:
            self.merchant_location_key = merchant_location_key
        if offer_id is not None:
            self.offer_id = offer_id
        if pricing_summary is not None:
            self.pricing_summary = pricing_summary
        if quantity_limit_per_buyer is not None:
            self.quantity_limit_per_buyer = quantity_limit_per_buyer
        if secondary_category_id is not None:
            self.secondary_category_id = secondary_category_id
        if sku is not None:
            self.sku = sku
        if status is not None:
            self.status = status
        if store_category_names is not None:
            self.store_category_names = store_category_names
        if tax is not None:
            self.tax = tax

    @property
    def available_quantity(self):
        """Gets the available_quantity of this EbayOfferDetailsWithAll.  # noqa: E501

        This integer value indicates the quantity of the inventory item (specified by the sku value) that will be available for purchase by buyers shopping on the eBay site specified in the marketplaceId field. For unpublished offers where the available quantity has yet to be set, the availableQuantity value is set to 0.  # noqa: E501

        :return: The available_quantity of this EbayOfferDetailsWithAll.  # noqa: E501
        :rtype: int
        """
        return self._available_quantity

    @available_quantity.setter
    def available_quantity(self, available_quantity):
        """Sets the available_quantity of this EbayOfferDetailsWithAll.

        This integer value indicates the quantity of the inventory item (specified by the sku value) that will be available for purchase by buyers shopping on the eBay site specified in the marketplaceId field. For unpublished offers where the available quantity has yet to be set, the availableQuantity value is set to 0.  # noqa: E501

        :param available_quantity: The available_quantity of this EbayOfferDetailsWithAll.  # noqa: E501
        :type: int
        """

        self._available_quantity = available_quantity

    @property
    def category_id(self):
        """Gets the category_id of this EbayOfferDetailsWithAll.  # noqa: E501

        The unique identifier of the primary eBay category that the inventory item is listed under. This field is always returned for published offers, but is only returned if set for unpublished offers.  # noqa: E501

        :return: The category_id of this EbayOfferDetailsWithAll.  # noqa: E501
        :rtype: str
        """
        return self._category_id

    @category_id.setter
    def category_id(self, category_id):
        """Sets the category_id of this EbayOfferDetailsWithAll.

        The unique identifier of the primary eBay category that the inventory item is listed under. This field is always returned for published offers, but is only returned if set for unpublished offers.  # noqa: E501

        :param category_id: The category_id of this EbayOfferDetailsWithAll.  # noqa: E501
        :type: str
        """

        self._category_id = category_id

    @property
    def charity(self):
        """Gets the charity of this EbayOfferDetailsWithAll.  # noqa: E501


        :return: The charity of this EbayOfferDetailsWithAll.  # noqa: E501
        :rtype: Charity
        """
        return self._charity

    @charity.setter
    def charity(self, charity):
        """Sets the charity of this EbayOfferDetailsWithAll.


        :param charity: The charity of this EbayOfferDetailsWithAll.  # noqa: E501
        :type: Charity
        """

        self._charity = charity

    @property
    def format(self):
        """Gets the format of this EbayOfferDetailsWithAll.  # noqa: E501

        This enumerated value indicates the listing format of the offer. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/inventory/types/slr:FormatTypeEnum'>eBay API documentation</a>  # noqa: E501

        :return: The format of this EbayOfferDetailsWithAll.  # noqa: E501
        :rtype: str
        """
        return self._format

    @format.setter
    def format(self, format):
        """Sets the format of this EbayOfferDetailsWithAll.

        This enumerated value indicates the listing format of the offer. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/inventory/types/slr:FormatTypeEnum'>eBay API documentation</a>  # noqa: E501

        :param format: The format of this EbayOfferDetailsWithAll.  # noqa: E501
        :type: str
        """

        self._format = format

    @property
    def hide_buyer_details(self):
        """Gets the hide_buyer_details of this EbayOfferDetailsWithAll.  # noqa: E501

        This field is returned as true if the private listing feature has been enabled for the offer. Sellers may want to use this feature when they believe that a listing's potential bidders/buyers would not want their obfuscated user IDs (and feedback scores) exposed to other users. This field is always returned even if not explicitly set in the offer. It defaults to false, so will get returned as false if seller does not set this feature with a 'Create' or 'Update' offer method.  # noqa: E501

        :return: The hide_buyer_details of this EbayOfferDetailsWithAll.  # noqa: E501
        :rtype: bool
        """
        return self._hide_buyer_details

    @hide_buyer_details.setter
    def hide_buyer_details(self, hide_buyer_details):
        """Sets the hide_buyer_details of this EbayOfferDetailsWithAll.

        This field is returned as true if the private listing feature has been enabled for the offer. Sellers may want to use this feature when they believe that a listing's potential bidders/buyers would not want their obfuscated user IDs (and feedback scores) exposed to other users. This field is always returned even if not explicitly set in the offer. It defaults to false, so will get returned as false if seller does not set this feature with a 'Create' or 'Update' offer method.  # noqa: E501

        :param hide_buyer_details: The hide_buyer_details of this EbayOfferDetailsWithAll.  # noqa: E501
        :type: bool
        """

        self._hide_buyer_details = hide_buyer_details

    @property
    def include_catalog_product_details(self):
        """Gets the include_catalog_product_details of this EbayOfferDetailsWithAll.  # noqa: E501

        This field indicates whether or not eBay product catalog details are applied to a listing. A value of true indicates the listing corresponds to the eBay product associated with the provided product identifier. The product identifier is provided in createOrReplaceInventoryItem. Note: Though the includeCatalogProductDetails parameter is not required to be submitted in the request, the parameter defaults to 'true' if omitted.  # noqa: E501

        :return: The include_catalog_product_details of this EbayOfferDetailsWithAll.  # noqa: E501
        :rtype: bool
        """
        return self._include_catalog_product_details

    @include_catalog_product_details.setter
    def include_catalog_product_details(self, include_catalog_product_details):
        """Sets the include_catalog_product_details of this EbayOfferDetailsWithAll.

        This field indicates whether or not eBay product catalog details are applied to a listing. A value of true indicates the listing corresponds to the eBay product associated with the provided product identifier. The product identifier is provided in createOrReplaceInventoryItem. Note: Though the includeCatalogProductDetails parameter is not required to be submitted in the request, the parameter defaults to 'true' if omitted.  # noqa: E501

        :param include_catalog_product_details: The include_catalog_product_details of this EbayOfferDetailsWithAll.  # noqa: E501
        :type: bool
        """

        self._include_catalog_product_details = include_catalog_product_details

    @property
    def listing(self):
        """Gets the listing of this EbayOfferDetailsWithAll.  # noqa: E501


        :return: The listing of this EbayOfferDetailsWithAll.  # noqa: E501
        :rtype: ListingDetails
        """
        return self._listing

    @listing.setter
    def listing(self, listing):
        """Sets the listing of this EbayOfferDetailsWithAll.


        :param listing: The listing of this EbayOfferDetailsWithAll.  # noqa: E501
        :type: ListingDetails
        """

        self._listing = listing

    @property
    def listing_description(self):
        """Gets the listing_description of this EbayOfferDetailsWithAll.  # noqa: E501

        The description of the eBay listing that is part of the unpublished or published offer. This field is always returned for published offers, but is only returned if set for unpublished offers. Max Length: 500000 (which includes HTML markup/tags)  # noqa: E501

        :return: The listing_description of this EbayOfferDetailsWithAll.  # noqa: E501
        :rtype: str
        """
        return self._listing_description

    @listing_description.setter
    def listing_description(self, listing_description):
        """Sets the listing_description of this EbayOfferDetailsWithAll.

        The description of the eBay listing that is part of the unpublished or published offer. This field is always returned for published offers, but is only returned if set for unpublished offers. Max Length: 500000 (which includes HTML markup/tags)  # noqa: E501

        :param listing_description: The listing_description of this EbayOfferDetailsWithAll.  # noqa: E501
        :type: str
        """

        self._listing_description = listing_description

    @property
    def listing_duration(self):
        """Gets the listing_duration of this EbayOfferDetailsWithAll.  # noqa: E501

        This field indicates the number of days that the listing will be active. This field is returned for both auction and fixed-price listings; however, the value returned for fixed-price listings will always be GTC. The GTC (Good 'Til Cancelled) listings are automatically renewed each calendar month until the seller decides to end the listing. Note: If the listing duration expires for an auction offer, the listing then becomes available as a fixed-price offer and will be GTC. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/inventory/types/slr:ListingDurationEnum'>eBay API documentation</a>  # noqa: E501

        :return: The listing_duration of this EbayOfferDetailsWithAll.  # noqa: E501
        :rtype: str
        """
        return self._listing_duration

    @listing_duration.setter
    def listing_duration(self, listing_duration):
        """Sets the listing_duration of this EbayOfferDetailsWithAll.

        This field indicates the number of days that the listing will be active. This field is returned for both auction and fixed-price listings; however, the value returned for fixed-price listings will always be GTC. The GTC (Good 'Til Cancelled) listings are automatically renewed each calendar month until the seller decides to end the listing. Note: If the listing duration expires for an auction offer, the listing then becomes available as a fixed-price offer and will be GTC. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/inventory/types/slr:ListingDurationEnum'>eBay API documentation</a>  # noqa: E501

        :param listing_duration: The listing_duration of this EbayOfferDetailsWithAll.  # noqa: E501
        :type: str
        """

        self._listing_duration = listing_duration

    @property
    def listing_policies(self):
        """Gets the listing_policies of this EbayOfferDetailsWithAll.  # noqa: E501


        :return: The listing_policies of this EbayOfferDetailsWithAll.  # noqa: E501
        :rtype: ListingPolicies
        """
        return self._listing_policies

    @listing_policies.setter
    def listing_policies(self, listing_policies):
        """Sets the listing_policies of this EbayOfferDetailsWithAll.


        :param listing_policies: The listing_policies of this EbayOfferDetailsWithAll.  # noqa: E501
        :type: ListingPolicies
        """

        self._listing_policies = listing_policies

    @property
    def listing_start_date(self):
        """Gets the listing_start_date of this EbayOfferDetailsWithAll.  # noqa: E501

        This timestamp is the date/time that the seller set for the scheduled listing. With the scheduled listing feature, the seller can set a time in the future that the listing will become active, instead of the listing becoming active immediately after a publishOffer call. Scheduled listings do not always start at the exact date/time specified by the seller, but the date/time of the timestamp returned in getOffer/getOffers will be the same as the timestamp passed into a 'Create' or 'Update' offer call. This field is returned if set for an offer.  # noqa: E501

        :return: The listing_start_date of this EbayOfferDetailsWithAll.  # noqa: E501
        :rtype: str
        """
        return self._listing_start_date

    @listing_start_date.setter
    def listing_start_date(self, listing_start_date):
        """Sets the listing_start_date of this EbayOfferDetailsWithAll.

        This timestamp is the date/time that the seller set for the scheduled listing. With the scheduled listing feature, the seller can set a time in the future that the listing will become active, instead of the listing becoming active immediately after a publishOffer call. Scheduled listings do not always start at the exact date/time specified by the seller, but the date/time of the timestamp returned in getOffer/getOffers will be the same as the timestamp passed into a 'Create' or 'Update' offer call. This field is returned if set for an offer.  # noqa: E501

        :param listing_start_date: The listing_start_date of this EbayOfferDetailsWithAll.  # noqa: E501
        :type: str
        """

        self._listing_start_date = listing_start_date

    @property
    def lot_size(self):
        """Gets the lot_size of this EbayOfferDetailsWithAll.  # noqa: E501

        This field is only applicable and returned if the listing is a lot listing. A lot listing is a listing that has multiple quantity of the same product. An example would be a set of four identical car tires. The integer value in this field is the number of identical items being sold through the lot listing.  # noqa: E501

        :return: The lot_size of this EbayOfferDetailsWithAll.  # noqa: E501
        :rtype: int
        """
        return self._lot_size

    @lot_size.setter
    def lot_size(self, lot_size):
        """Sets the lot_size of this EbayOfferDetailsWithAll.

        This field is only applicable and returned if the listing is a lot listing. A lot listing is a listing that has multiple quantity of the same product. An example would be a set of four identical car tires. The integer value in this field is the number of identical items being sold through the lot listing.  # noqa: E501

        :param lot_size: The lot_size of this EbayOfferDetailsWithAll.  # noqa: E501
        :type: int
        """

        self._lot_size = lot_size

    @property
    def marketplace_id(self):
        """Gets the marketplace_id of this EbayOfferDetailsWithAll.  # noqa: E501

        This enumeration value is the unique identifier of the eBay site on which the offer is available, or will be made available. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/inventory/types/slr:MarketplaceEnum'>eBay API documentation</a>  # noqa: E501

        :return: The marketplace_id of this EbayOfferDetailsWithAll.  # noqa: E501
        :rtype: str
        """
        return self._marketplace_id

    @marketplace_id.setter
    def marketplace_id(self, marketplace_id):
        """Sets the marketplace_id of this EbayOfferDetailsWithAll.

        This enumeration value is the unique identifier of the eBay site on which the offer is available, or will be made available. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/inventory/types/slr:MarketplaceEnum'>eBay API documentation</a>  # noqa: E501

        :param marketplace_id: The marketplace_id of this EbayOfferDetailsWithAll.  # noqa: E501
        :type: str
        """

        self._marketplace_id = marketplace_id

    @property
    def merchant_location_key(self):
        """Gets the merchant_location_key of this EbayOfferDetailsWithAll.  # noqa: E501

        The unique identifier of the inventory location. This identifier is set up by the merchant when the inventory location is first created with the createInventoryLocation call. Once this value is set for an inventory location, it can not be modified. To get more information about this inventory location, the getInventoryLocation call can be used, passing in this value at the end of the call URI. This field is always returned for published offers, but is only returned if set for unpublished offers. Max length: 36  # noqa: E501

        :return: The merchant_location_key of this EbayOfferDetailsWithAll.  # noqa: E501
        :rtype: str
        """
        return self._merchant_location_key

    @merchant_location_key.setter
    def merchant_location_key(self, merchant_location_key):
        """Sets the merchant_location_key of this EbayOfferDetailsWithAll.

        The unique identifier of the inventory location. This identifier is set up by the merchant when the inventory location is first created with the createInventoryLocation call. Once this value is set for an inventory location, it can not be modified. To get more information about this inventory location, the getInventoryLocation call can be used, passing in this value at the end of the call URI. This field is always returned for published offers, but is only returned if set for unpublished offers. Max length: 36  # noqa: E501

        :param merchant_location_key: The merchant_location_key of this EbayOfferDetailsWithAll.  # noqa: E501
        :type: str
        """

        self._merchant_location_key = merchant_location_key

    @property
    def offer_id(self):
        """Gets the offer_id of this EbayOfferDetailsWithAll.  # noqa: E501

        The unique identifier of the offer. This identifier is used in many offer-related calls, and it is also used in the bulkUpdatePriceQuantity call.  # noqa: E501

        :return: The offer_id of this EbayOfferDetailsWithAll.  # noqa: E501
        :rtype: str
        """
        return self._offer_id

    @offer_id.setter
    def offer_id(self, offer_id):
        """Sets the offer_id of this EbayOfferDetailsWithAll.

        The unique identifier of the offer. This identifier is used in many offer-related calls, and it is also used in the bulkUpdatePriceQuantity call.  # noqa: E501

        :param offer_id: The offer_id of this EbayOfferDetailsWithAll.  # noqa: E501
        :type: str
        """

        self._offer_id = offer_id

    @property
    def pricing_summary(self):
        """Gets the pricing_summary of this EbayOfferDetailsWithAll.  # noqa: E501


        :return: The pricing_summary of this EbayOfferDetailsWithAll.  # noqa: E501
        :rtype: PricingSummary
        """
        return self._pricing_summary

    @pricing_summary.setter
    def pricing_summary(self, pricing_summary):
        """Sets the pricing_summary of this EbayOfferDetailsWithAll.


        :param pricing_summary: The pricing_summary of this EbayOfferDetailsWithAll.  # noqa: E501
        :type: PricingSummary
        """

        self._pricing_summary = pricing_summary

    @property
    def quantity_limit_per_buyer(self):
        """Gets the quantity_limit_per_buyer of this EbayOfferDetailsWithAll.  # noqa: E501

        This field is only applicable and set if the seller wishes to set a restriction on the purchase quantity of an inventory item per seller. If this field is set by the seller for the offer, then each distinct buyer may purchase up to, but not exceed the quantity in this field. So, if this field's value is 5, each buyer may purchase a quantity of the inventory item between one and five, and the purchases can occur in one multiple-quantity purchase, or over multiple transactions. If a buyer attempts to purchase one or more of these products, and the cumulative quantity will take the buyer beyond the quantity limit, that buyer will be blocked from that purchase.  # noqa: E501

        :return: The quantity_limit_per_buyer of this EbayOfferDetailsWithAll.  # noqa: E501
        :rtype: int
        """
        return self._quantity_limit_per_buyer

    @quantity_limit_per_buyer.setter
    def quantity_limit_per_buyer(self, quantity_limit_per_buyer):
        """Sets the quantity_limit_per_buyer of this EbayOfferDetailsWithAll.

        This field is only applicable and set if the seller wishes to set a restriction on the purchase quantity of an inventory item per seller. If this field is set by the seller for the offer, then each distinct buyer may purchase up to, but not exceed the quantity in this field. So, if this field's value is 5, each buyer may purchase a quantity of the inventory item between one and five, and the purchases can occur in one multiple-quantity purchase, or over multiple transactions. If a buyer attempts to purchase one or more of these products, and the cumulative quantity will take the buyer beyond the quantity limit, that buyer will be blocked from that purchase.  # noqa: E501

        :param quantity_limit_per_buyer: The quantity_limit_per_buyer of this EbayOfferDetailsWithAll.  # noqa: E501
        :type: int
        """

        self._quantity_limit_per_buyer = quantity_limit_per_buyer

    @property
    def secondary_category_id(self):
        """Gets the secondary_category_id of this EbayOfferDetailsWithAll.  # noqa: E501

        The unique identifier for a secondary category. This field is applicable if the seller decides to list the item under two categories. Sellers can use the getCategorySuggestions method of the Taxonomy API to retrieve suggested category ID values. A fee may be charged when adding a secondary category to a listing. Note: You cannot list US eBay Motors vehicles in two categories. However, you can list Parts &amp; Accessories in two categories.  # noqa: E501

        :return: The secondary_category_id of this EbayOfferDetailsWithAll.  # noqa: E501
        :rtype: str
        """
        return self._secondary_category_id

    @secondary_category_id.setter
    def secondary_category_id(self, secondary_category_id):
        """Sets the secondary_category_id of this EbayOfferDetailsWithAll.

        The unique identifier for a secondary category. This field is applicable if the seller decides to list the item under two categories. Sellers can use the getCategorySuggestions method of the Taxonomy API to retrieve suggested category ID values. A fee may be charged when adding a secondary category to a listing. Note: You cannot list US eBay Motors vehicles in two categories. However, you can list Parts &amp; Accessories in two categories.  # noqa: E501

        :param secondary_category_id: The secondary_category_id of this EbayOfferDetailsWithAll.  # noqa: E501
        :type: str
        """

        self._secondary_category_id = secondary_category_id

    @property
    def sku(self):
        """Gets the sku of this EbayOfferDetailsWithAll.  # noqa: E501

        This is the seller-defined SKU value of the product in the offer. Max Length: 50  # noqa: E501

        :return: The sku of this EbayOfferDetailsWithAll.  # noqa: E501
        :rtype: str
        """
        return self._sku

    @sku.setter
    def sku(self, sku):
        """Sets the sku of this EbayOfferDetailsWithAll.

        This is the seller-defined SKU value of the product in the offer. Max Length: 50  # noqa: E501

        :param sku: The sku of this EbayOfferDetailsWithAll.  # noqa: E501
        :type: str
        """

        self._sku = sku

    @property
    def status(self):
        """Gets the status of this EbayOfferDetailsWithAll.  # noqa: E501

        The enumeration value in this field specifies the status of the offer - either PUBLISHED or UNPUBLISHED. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/inventory/types/slr:OfferStatusEnum'>eBay API documentation</a>  # noqa: E501

        :return: The status of this EbayOfferDetailsWithAll.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this EbayOfferDetailsWithAll.

        The enumeration value in this field specifies the status of the offer - either PUBLISHED or UNPUBLISHED. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/inventory/types/slr:OfferStatusEnum'>eBay API documentation</a>  # noqa: E501

        :param status: The status of this EbayOfferDetailsWithAll.  # noqa: E501
        :type: str
        """

        self._status = status

    @property
    def store_category_names(self):
        """Gets the store_category_names of this EbayOfferDetailsWithAll.  # noqa: E501

        This container is returned if the seller chose to place the inventory item into one or two eBay store categories that the seller has set up for their eBay store. The string value(s) in this container will be the full path(s) to the eBay store categories, as shown below: &quot;storeCategoryNames&quot;: [  &quot;/Fashion/Men/Shirts&quot;,  &quot;/Fashion/Men/Accessories&quot; ],  # noqa: E501

        :return: The store_category_names of this EbayOfferDetailsWithAll.  # noqa: E501
        :rtype: list[str]
        """
        return self._store_category_names

    @store_category_names.setter
    def store_category_names(self, store_category_names):
        """Sets the store_category_names of this EbayOfferDetailsWithAll.

        This container is returned if the seller chose to place the inventory item into one or two eBay store categories that the seller has set up for their eBay store. The string value(s) in this container will be the full path(s) to the eBay store categories, as shown below: &quot;storeCategoryNames&quot;: [  &quot;/Fashion/Men/Shirts&quot;,  &quot;/Fashion/Men/Accessories&quot; ],  # noqa: E501

        :param store_category_names: The store_category_names of this EbayOfferDetailsWithAll.  # noqa: E501
        :type: list[str]
        """

        self._store_category_names = store_category_names

    @property
    def tax(self):
        """Gets the tax of this EbayOfferDetailsWithAll.  # noqa: E501


        :return: The tax of this EbayOfferDetailsWithAll.  # noqa: E501
        :rtype: Tax
        """
        return self._tax

    @tax.setter
    def tax(self, tax):
        """Sets the tax of this EbayOfferDetailsWithAll.


        :param tax: The tax of this EbayOfferDetailsWithAll.  # noqa: E501
        :type: Tax
        """

        self._tax = tax

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(EbayOfferDetailsWithAll, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EbayOfferDetailsWithAll):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
