# coding: utf-8

"""
    Inventory API

    The Inventory API is used to create and manage inventory, and then to publish and manage this inventory on an eBay marketplace. There are also methods in this API that will convert eligible, active eBay listings into the Inventory API model.  # noqa: E501

    OpenAPI spec version: 1.13.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class EbayOfferDetailsWithId(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'available_quantity': 'int',
        'category_id': 'str',
        'charity': 'Charity',
        'hide_buyer_details': 'bool',
        'include_catalog_product_details': 'bool',
        'listing_description': 'str',
        'listing_duration': 'str',
        'listing_policies': 'ListingPolicies',
        'listing_start_date': 'str',
        'lot_size': 'int',
        'merchant_location_key': 'str',
        'pricing_summary': 'PricingSummary',
        'quantity_limit_per_buyer': 'int',
        'secondary_category_id': 'str',
        'store_category_names': 'list[str]',
        'tax': 'Tax'
    }

    attribute_map = {
        'available_quantity': 'availableQuantity',
        'category_id': 'categoryId',
        'charity': 'charity',
        'hide_buyer_details': 'hideBuyerDetails',
        'include_catalog_product_details': 'includeCatalogProductDetails',
        'listing_description': 'listingDescription',
        'listing_duration': 'listingDuration',
        'listing_policies': 'listingPolicies',
        'listing_start_date': 'listingStartDate',
        'lot_size': 'lotSize',
        'merchant_location_key': 'merchantLocationKey',
        'pricing_summary': 'pricingSummary',
        'quantity_limit_per_buyer': 'quantityLimitPerBuyer',
        'secondary_category_id': 'secondaryCategoryId',
        'store_category_names': 'storeCategoryNames',
        'tax': 'tax'
    }

    def __init__(self, available_quantity=None, category_id=None, charity=None, hide_buyer_details=None, include_catalog_product_details=None, listing_description=None, listing_duration=None, listing_policies=None, listing_start_date=None, lot_size=None, merchant_location_key=None, pricing_summary=None, quantity_limit_per_buyer=None, secondary_category_id=None, store_category_names=None, tax=None):  # noqa: E501
        """EbayOfferDetailsWithId - a model defined in Swagger"""  # noqa: E501
        self._available_quantity = None
        self._category_id = None
        self._charity = None
        self._hide_buyer_details = None
        self._include_catalog_product_details = None
        self._listing_description = None
        self._listing_duration = None
        self._listing_policies = None
        self._listing_start_date = None
        self._lot_size = None
        self._merchant_location_key = None
        self._pricing_summary = None
        self._quantity_limit_per_buyer = None
        self._secondary_category_id = None
        self._store_category_names = None
        self._tax = None
        self.discriminator = None
        if available_quantity is not None:
            self.available_quantity = available_quantity
        if category_id is not None:
            self.category_id = category_id
        if charity is not None:
            self.charity = charity
        if hide_buyer_details is not None:
            self.hide_buyer_details = hide_buyer_details
        if include_catalog_product_details is not None:
            self.include_catalog_product_details = include_catalog_product_details
        if listing_description is not None:
            self.listing_description = listing_description
        if listing_duration is not None:
            self.listing_duration = listing_duration
        if listing_policies is not None:
            self.listing_policies = listing_policies
        if listing_start_date is not None:
            self.listing_start_date = listing_start_date
        if lot_size is not None:
            self.lot_size = lot_size
        if merchant_location_key is not None:
            self.merchant_location_key = merchant_location_key
        if pricing_summary is not None:
            self.pricing_summary = pricing_summary
        if quantity_limit_per_buyer is not None:
            self.quantity_limit_per_buyer = quantity_limit_per_buyer
        if secondary_category_id is not None:
            self.secondary_category_id = secondary_category_id
        if store_category_names is not None:
            self.store_category_names = store_category_names
        if tax is not None:
            self.tax = tax

    @property
    def available_quantity(self):
        """Gets the available_quantity of this EbayOfferDetailsWithId.  # noqa: E501

        This integer value sets the quantity of the inventory item that will be available through the offer. Quantity must be set to 1 or more in order for the inventory item to be purchasable. This value should not be more than the quantity that is specified for the inventory item record. For auction listings, this value must be 1. If this field exists for the current unpublished or published offer, it should be provided again in the updateOffer call, even if the value is not changing. If this particular field is omitted in an updateOffer call, the general available quantity set for the inventory item record may be used instead, and this may not be accurate if the inventory item is being sold across multiple marketplaces.  # noqa: E501

        :return: The available_quantity of this EbayOfferDetailsWithId.  # noqa: E501
        :rtype: int
        """
        return self._available_quantity

    @available_quantity.setter
    def available_quantity(self, available_quantity):
        """Sets the available_quantity of this EbayOfferDetailsWithId.

        This integer value sets the quantity of the inventory item that will be available through the offer. Quantity must be set to 1 or more in order for the inventory item to be purchasable. This value should not be more than the quantity that is specified for the inventory item record. For auction listings, this value must be 1. If this field exists for the current unpublished or published offer, it should be provided again in the updateOffer call, even if the value is not changing. If this particular field is omitted in an updateOffer call, the general available quantity set for the inventory item record may be used instead, and this may not be accurate if the inventory item is being sold across multiple marketplaces.  # noqa: E501

        :param available_quantity: The available_quantity of this EbayOfferDetailsWithId.  # noqa: E501
        :type: int
        """

        self._available_quantity = available_quantity

    @property
    def category_id(self):
        """Gets the category_id of this EbayOfferDetailsWithId.  # noqa: E501

        The unique identifier of the eBay category that the inventory item is/will be listed under. This field is not immediately required for an unpublished offer, but will be required before publishing the offer. Sellers can use the getCategorySuggestions method of the Taxonomy API to retrieve suggested category ID values. The seller passes in a query string like &quot;iPhone 6&quot;, and category ID values for suggested categories are returned in the response. If this field exists for the current unpublished offer, it should be provided again in the updateOffer call, even if the eBay category is not changing. For a published offer (aka active eBay listing), this field must be provided or an error may occur. The eBay category of an active eBay listing cannot be changed once the listing has one or more sales, or if the listing is scheduled to end in less than 12 hours.  # noqa: E501

        :return: The category_id of this EbayOfferDetailsWithId.  # noqa: E501
        :rtype: str
        """
        return self._category_id

    @category_id.setter
    def category_id(self, category_id):
        """Sets the category_id of this EbayOfferDetailsWithId.

        The unique identifier of the eBay category that the inventory item is/will be listed under. This field is not immediately required for an unpublished offer, but will be required before publishing the offer. Sellers can use the getCategorySuggestions method of the Taxonomy API to retrieve suggested category ID values. The seller passes in a query string like &quot;iPhone 6&quot;, and category ID values for suggested categories are returned in the response. If this field exists for the current unpublished offer, it should be provided again in the updateOffer call, even if the eBay category is not changing. For a published offer (aka active eBay listing), this field must be provided or an error may occur. The eBay category of an active eBay listing cannot be changed once the listing has one or more sales, or if the listing is scheduled to end in less than 12 hours.  # noqa: E501

        :param category_id: The category_id of this EbayOfferDetailsWithId.  # noqa: E501
        :type: str
        """

        self._category_id = category_id

    @property
    def charity(self):
        """Gets the charity of this EbayOfferDetailsWithId.  # noqa: E501


        :return: The charity of this EbayOfferDetailsWithId.  # noqa: E501
        :rtype: Charity
        """
        return self._charity

    @charity.setter
    def charity(self, charity):
        """Sets the charity of this EbayOfferDetailsWithId.


        :param charity: The charity of this EbayOfferDetailsWithId.  # noqa: E501
        :type: Charity
        """

        self._charity = charity

    @property
    def hide_buyer_details(self):
        """Gets the hide_buyer_details of this EbayOfferDetailsWithId.  # noqa: E501

        This field is included and set to true if the seller wishes to update a published or unpublished offer with the private listing feature. Alternatively, the seller could also remove the private listing feature (if already set for a published or unpublished offer) by including this field and setting it to false. Sellers may want to use this option when they believe that a listing's potential bidders/buyers would not want their obfuscated user IDs (and feedback scores) exposed to other users.  # noqa: E501

        :return: The hide_buyer_details of this EbayOfferDetailsWithId.  # noqa: E501
        :rtype: bool
        """
        return self._hide_buyer_details

    @hide_buyer_details.setter
    def hide_buyer_details(self, hide_buyer_details):
        """Sets the hide_buyer_details of this EbayOfferDetailsWithId.

        This field is included and set to true if the seller wishes to update a published or unpublished offer with the private listing feature. Alternatively, the seller could also remove the private listing feature (if already set for a published or unpublished offer) by including this field and setting it to false. Sellers may want to use this option when they believe that a listing's potential bidders/buyers would not want their obfuscated user IDs (and feedback scores) exposed to other users.  # noqa: E501

        :param hide_buyer_details: The hide_buyer_details of this EbayOfferDetailsWithId.  # noqa: E501
        :type: bool
        """

        self._hide_buyer_details = hide_buyer_details

    @property
    def include_catalog_product_details(self):
        """Gets the include_catalog_product_details of this EbayOfferDetailsWithId.  # noqa: E501

        This field indicates whether or not eBay product catalog details are applied to a listing. A value of true indicates the listing corresponds to the eBay product associated with the provided product identifier. The product identifier is provided in createOrReplaceInventoryItem. Note: Though the includeCatalogProductDetails parameter is not required to be submitted in the request, the parameter defaults to 'true' if omitted.  # noqa: E501

        :return: The include_catalog_product_details of this EbayOfferDetailsWithId.  # noqa: E501
        :rtype: bool
        """
        return self._include_catalog_product_details

    @include_catalog_product_details.setter
    def include_catalog_product_details(self, include_catalog_product_details):
        """Sets the include_catalog_product_details of this EbayOfferDetailsWithId.

        This field indicates whether or not eBay product catalog details are applied to a listing. A value of true indicates the listing corresponds to the eBay product associated with the provided product identifier. The product identifier is provided in createOrReplaceInventoryItem. Note: Though the includeCatalogProductDetails parameter is not required to be submitted in the request, the parameter defaults to 'true' if omitted.  # noqa: E501

        :param include_catalog_product_details: The include_catalog_product_details of this EbayOfferDetailsWithId.  # noqa: E501
        :type: bool
        """

        self._include_catalog_product_details = include_catalog_product_details

    @property
    def listing_description(self):
        """Gets the listing_description of this EbayOfferDetailsWithId.  # noqa: E501

        The text in this field is (published offers), or will become (unpublished offers) the description of the eBay listing. This field is not immediately required for an unpublished offer, but will be required before publishing the offer. Note that if the listingDescription field was omitted in the createOffer call for the offer, the offer entity should have picked up the text provided in the product.description field of the inventory item record, or if the inventory item is part of a group, the offer entity should have picked up the text provided in the description field of the inventory item group record. HTML tags and markup can be used in listing descriptions, but each character counts toward the max length limit. Note: To ensure that their short listing description is optimized when viewed on mobile devices, sellers should strongly consider using eBay's View Item description summary feature when listing their items. Keep in mind that the 'short' listing description is what prospective buyers first see when they view the listing on a mobile device. The 'full' listing description is also available to mobile users when they click on the short listing description, but the full description is not automatically optimized for viewing in mobile devices, and many users won't even drill down to the full description. Using HTML div and span tag attributes, this feature allows sellers to customize and fully control the short listing description that is displayed to prospective buyers when viewing the listing on a mobile device. The short listing description on mobile devices is limited to 800 characters, and whenever the full listing description (provided in this field, in UI, or seller tool) exceeds this limit, eBay uses a special algorithm to derive the best possible short listing description within the 800-character limit. However, due to some short listing description content being removed, it is definitely not ideal for the seller, and could lead to a bad buyer experience and possibly to a Significantly not as described (SNAD) case, since the buyer may not get complete details on the item when viewing the short listing description. See the eBay help page for more details on using the HTML div and span tags. If this field exists for the current unpublished offer, it should be provided again in the updateOffer call, even if the text is not changing. For a published offer (aka active eBay listing), this field must be provided or an error may occur. Max length: 500000 (which includes HTML markup/tags)  # noqa: E501

        :return: The listing_description of this EbayOfferDetailsWithId.  # noqa: E501
        :rtype: str
        """
        return self._listing_description

    @listing_description.setter
    def listing_description(self, listing_description):
        """Sets the listing_description of this EbayOfferDetailsWithId.

        The text in this field is (published offers), or will become (unpublished offers) the description of the eBay listing. This field is not immediately required for an unpublished offer, but will be required before publishing the offer. Note that if the listingDescription field was omitted in the createOffer call for the offer, the offer entity should have picked up the text provided in the product.description field of the inventory item record, or if the inventory item is part of a group, the offer entity should have picked up the text provided in the description field of the inventory item group record. HTML tags and markup can be used in listing descriptions, but each character counts toward the max length limit. Note: To ensure that their short listing description is optimized when viewed on mobile devices, sellers should strongly consider using eBay's View Item description summary feature when listing their items. Keep in mind that the 'short' listing description is what prospective buyers first see when they view the listing on a mobile device. The 'full' listing description is also available to mobile users when they click on the short listing description, but the full description is not automatically optimized for viewing in mobile devices, and many users won't even drill down to the full description. Using HTML div and span tag attributes, this feature allows sellers to customize and fully control the short listing description that is displayed to prospective buyers when viewing the listing on a mobile device. The short listing description on mobile devices is limited to 800 characters, and whenever the full listing description (provided in this field, in UI, or seller tool) exceeds this limit, eBay uses a special algorithm to derive the best possible short listing description within the 800-character limit. However, due to some short listing description content being removed, it is definitely not ideal for the seller, and could lead to a bad buyer experience and possibly to a Significantly not as described (SNAD) case, since the buyer may not get complete details on the item when viewing the short listing description. See the eBay help page for more details on using the HTML div and span tags. If this field exists for the current unpublished offer, it should be provided again in the updateOffer call, even if the text is not changing. For a published offer (aka active eBay listing), this field must be provided or an error may occur. Max length: 500000 (which includes HTML markup/tags)  # noqa: E501

        :param listing_description: The listing_description of this EbayOfferDetailsWithId.  # noqa: E501
        :type: str
        """

        self._listing_description = listing_description

    @property
    def listing_duration(self):
        """Gets the listing_duration of this EbayOfferDetailsWithId.  # noqa: E501

        This field indicates the number of days that the listing will be active. For fixed-price listings, this value must be set to GTC, but auction listings support different listing durations. The GTC (Good 'Til Cancelled) listings are automatically renewed each calendar month until the seller decides to end the listing. Note: If the listing duration expires for an auction offer without a winning bidder, the listing then becomes available as a fixed-price offer and listing duration will be GTC. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/inventory/types/slr:ListingDurationEnum'>eBay API documentation</a>  # noqa: E501

        :return: The listing_duration of this EbayOfferDetailsWithId.  # noqa: E501
        :rtype: str
        """
        return self._listing_duration

    @listing_duration.setter
    def listing_duration(self, listing_duration):
        """Sets the listing_duration of this EbayOfferDetailsWithId.

        This field indicates the number of days that the listing will be active. For fixed-price listings, this value must be set to GTC, but auction listings support different listing durations. The GTC (Good 'Til Cancelled) listings are automatically renewed each calendar month until the seller decides to end the listing. Note: If the listing duration expires for an auction offer without a winning bidder, the listing then becomes available as a fixed-price offer and listing duration will be GTC. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/inventory/types/slr:ListingDurationEnum'>eBay API documentation</a>  # noqa: E501

        :param listing_duration: The listing_duration of this EbayOfferDetailsWithId.  # noqa: E501
        :type: str
        """

        self._listing_duration = listing_duration

    @property
    def listing_policies(self):
        """Gets the listing_policies of this EbayOfferDetailsWithId.  # noqa: E501


        :return: The listing_policies of this EbayOfferDetailsWithId.  # noqa: E501
        :rtype: ListingPolicies
        """
        return self._listing_policies

    @listing_policies.setter
    def listing_policies(self, listing_policies):
        """Sets the listing_policies of this EbayOfferDetailsWithId.


        :param listing_policies: The listing_policies of this EbayOfferDetailsWithId.  # noqa: E501
        :type: ListingPolicies
        """

        self._listing_policies = listing_policies

    @property
    def listing_start_date(self):
        """Gets the listing_start_date of this EbayOfferDetailsWithId.  # noqa: E501

        This field can be used with an unpublished offer if the seller wants to specify a time in the future that the listing will become active on eBay. The timestamp supplied in this field should be in UTC format, and it should be far enough in the future so that the seller will have enough time to publish the listing with the publishOffer method. This field is optional, and it doesn't apply to offers where the corresponding listing is already active. If this field is not provided, the listing starts immediately after a successful publishOffer method.  # noqa: E501

        :return: The listing_start_date of this EbayOfferDetailsWithId.  # noqa: E501
        :rtype: str
        """
        return self._listing_start_date

    @listing_start_date.setter
    def listing_start_date(self, listing_start_date):
        """Sets the listing_start_date of this EbayOfferDetailsWithId.

        This field can be used with an unpublished offer if the seller wants to specify a time in the future that the listing will become active on eBay. The timestamp supplied in this field should be in UTC format, and it should be far enough in the future so that the seller will have enough time to publish the listing with the publishOffer method. This field is optional, and it doesn't apply to offers where the corresponding listing is already active. If this field is not provided, the listing starts immediately after a successful publishOffer method.  # noqa: E501

        :param listing_start_date: The listing_start_date of this EbayOfferDetailsWithId.  # noqa: E501
        :type: str
        """

        self._listing_start_date = listing_start_date

    @property
    def lot_size(self):
        """Gets the lot_size of this EbayOfferDetailsWithId.  # noqa: E501

        This field is only applicable if the listing is a lot listing. A lot listing is a listing that has multiple quantity of the same item, such as four identical tires being sold as a single offer, or it can be a mixed lot of similar items, such as used clothing items or an assortment of baseball cards. Whether the lot listing involved identical items or a mixed lot, the integer value passed into this field is the total number of items in the lot. Lots can be used for auction and fixed-price listings.  # noqa: E501

        :return: The lot_size of this EbayOfferDetailsWithId.  # noqa: E501
        :rtype: int
        """
        return self._lot_size

    @lot_size.setter
    def lot_size(self, lot_size):
        """Sets the lot_size of this EbayOfferDetailsWithId.

        This field is only applicable if the listing is a lot listing. A lot listing is a listing that has multiple quantity of the same item, such as four identical tires being sold as a single offer, or it can be a mixed lot of similar items, such as used clothing items or an assortment of baseball cards. Whether the lot listing involved identical items or a mixed lot, the integer value passed into this field is the total number of items in the lot. Lots can be used for auction and fixed-price listings.  # noqa: E501

        :param lot_size: The lot_size of this EbayOfferDetailsWithId.  # noqa: E501
        :type: int
        """

        self._lot_size = lot_size

    @property
    def merchant_location_key(self):
        """Gets the merchant_location_key of this EbayOfferDetailsWithId.  # noqa: E501

        The unique identifier of a merchant's inventory location (where the inventory item in the offer is located). A merchantLocationKey value is established when the merchant creates an inventory location using the createInventoryLocation call. To get more information about inventory locations, the getInventoryLocation call can be used. This field is not initially required upon first creating an offer, but will become required before an offer can be published. Max length: 36  # noqa: E501

        :return: The merchant_location_key of this EbayOfferDetailsWithId.  # noqa: E501
        :rtype: str
        """
        return self._merchant_location_key

    @merchant_location_key.setter
    def merchant_location_key(self, merchant_location_key):
        """Sets the merchant_location_key of this EbayOfferDetailsWithId.

        The unique identifier of a merchant's inventory location (where the inventory item in the offer is located). A merchantLocationKey value is established when the merchant creates an inventory location using the createInventoryLocation call. To get more information about inventory locations, the getInventoryLocation call can be used. This field is not initially required upon first creating an offer, but will become required before an offer can be published. Max length: 36  # noqa: E501

        :param merchant_location_key: The merchant_location_key of this EbayOfferDetailsWithId.  # noqa: E501
        :type: str
        """

        self._merchant_location_key = merchant_location_key

    @property
    def pricing_summary(self):
        """Gets the pricing_summary of this EbayOfferDetailsWithId.  # noqa: E501


        :return: The pricing_summary of this EbayOfferDetailsWithId.  # noqa: E501
        :rtype: PricingSummary
        """
        return self._pricing_summary

    @pricing_summary.setter
    def pricing_summary(self, pricing_summary):
        """Sets the pricing_summary of this EbayOfferDetailsWithId.


        :param pricing_summary: The pricing_summary of this EbayOfferDetailsWithId.  # noqa: E501
        :type: PricingSummary
        """

        self._pricing_summary = pricing_summary

    @property
    def quantity_limit_per_buyer(self):
        """Gets the quantity_limit_per_buyer of this EbayOfferDetailsWithId.  # noqa: E501

        This field is only applicable and set if the seller wishes to set a restriction on the purchase quantity per seller. If this field is set by the seller for the offer, then each distinct buyer may purchase up to, but not exceeding the quantity specified for this field. So, if this field's value is 5, each buyer may purchase between one to five of these products, and the purchases can occur in one multiple-quantity purchase, or over multiple transactions. If a buyer attempts to purchase one or more of these products, and the cumulative quantity will take the buyer beyond the quantity limit, that buyer will be blocked from that purchase. If this field currently exists for an unpublished or published offer, it should be provided again in an updateOffer call, even if the value is not changing.  # noqa: E501

        :return: The quantity_limit_per_buyer of this EbayOfferDetailsWithId.  # noqa: E501
        :rtype: int
        """
        return self._quantity_limit_per_buyer

    @quantity_limit_per_buyer.setter
    def quantity_limit_per_buyer(self, quantity_limit_per_buyer):
        """Sets the quantity_limit_per_buyer of this EbayOfferDetailsWithId.

        This field is only applicable and set if the seller wishes to set a restriction on the purchase quantity per seller. If this field is set by the seller for the offer, then each distinct buyer may purchase up to, but not exceeding the quantity specified for this field. So, if this field's value is 5, each buyer may purchase between one to five of these products, and the purchases can occur in one multiple-quantity purchase, or over multiple transactions. If a buyer attempts to purchase one or more of these products, and the cumulative quantity will take the buyer beyond the quantity limit, that buyer will be blocked from that purchase. If this field currently exists for an unpublished or published offer, it should be provided again in an updateOffer call, even if the value is not changing.  # noqa: E501

        :param quantity_limit_per_buyer: The quantity_limit_per_buyer of this EbayOfferDetailsWithId.  # noqa: E501
        :type: int
        """

        self._quantity_limit_per_buyer = quantity_limit_per_buyer

    @property
    def secondary_category_id(self):
        """Gets the secondary_category_id of this EbayOfferDetailsWithId.  # noqa: E501

        The unique identifier for a secondary category. This field is applicable if the seller decides to list the item under two categories. Sellers can use the getCategorySuggestions method of the Taxonomy API to retrieve suggested category ID values. A fee may be charged when adding a secondary category to a listing. Note: You cannot list US eBay Motors vehicles in two categories. However, you can list Parts &amp; Accessories in two categories.  # noqa: E501

        :return: The secondary_category_id of this EbayOfferDetailsWithId.  # noqa: E501
        :rtype: str
        """
        return self._secondary_category_id

    @secondary_category_id.setter
    def secondary_category_id(self, secondary_category_id):
        """Sets the secondary_category_id of this EbayOfferDetailsWithId.

        The unique identifier for a secondary category. This field is applicable if the seller decides to list the item under two categories. Sellers can use the getCategorySuggestions method of the Taxonomy API to retrieve suggested category ID values. A fee may be charged when adding a secondary category to a listing. Note: You cannot list US eBay Motors vehicles in two categories. However, you can list Parts &amp; Accessories in two categories.  # noqa: E501

        :param secondary_category_id: The secondary_category_id of this EbayOfferDetailsWithId.  # noqa: E501
        :type: str
        """

        self._secondary_category_id = secondary_category_id

    @property
    def store_category_names(self):
        """Gets the store_category_names of this EbayOfferDetailsWithId.  # noqa: E501

        This container is used if the seller would like to place the inventory item into one or two store categories that the seller has set up for their eBay store. The string value(s) passed in to this container will be the full path(s) to the store categories, as shown below: &quot;storeCategoryNames&quot;: [  &quot;/Fashion/Men/Shirts&quot;,  &quot;/Fashion/Men/Accessories&quot; ], If this field currently exists for an unpublished or published offer, it should be provided again in an updateOffer call, even if the eBay categories are not changing.  # noqa: E501

        :return: The store_category_names of this EbayOfferDetailsWithId.  # noqa: E501
        :rtype: list[str]
        """
        return self._store_category_names

    @store_category_names.setter
    def store_category_names(self, store_category_names):
        """Sets the store_category_names of this EbayOfferDetailsWithId.

        This container is used if the seller would like to place the inventory item into one or two store categories that the seller has set up for their eBay store. The string value(s) passed in to this container will be the full path(s) to the store categories, as shown below: &quot;storeCategoryNames&quot;: [  &quot;/Fashion/Men/Shirts&quot;,  &quot;/Fashion/Men/Accessories&quot; ], If this field currently exists for an unpublished or published offer, it should be provided again in an updateOffer call, even if the eBay categories are not changing.  # noqa: E501

        :param store_category_names: The store_category_names of this EbayOfferDetailsWithId.  # noqa: E501
        :type: list[str]
        """

        self._store_category_names = store_category_names

    @property
    def tax(self):
        """Gets the tax of this EbayOfferDetailsWithId.  # noqa: E501


        :return: The tax of this EbayOfferDetailsWithId.  # noqa: E501
        :rtype: Tax
        """
        return self._tax

    @tax.setter
    def tax(self, tax):
        """Sets the tax of this EbayOfferDetailsWithId.


        :param tax: The tax of this EbayOfferDetailsWithId.  # noqa: E501
        :type: Tax
        """

        self._tax = tax

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(EbayOfferDetailsWithId, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, EbayOfferDetailsWithId):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
