# coding: utf-8

"""
    Inventory API

    The Inventory API is used to create and manage inventory, and then to publish and manage this inventory on an eBay marketplace. There are also methods in this API that will convert eligible, active eBay listings into the Inventory API model.  # noqa: E501

    OpenAPI spec version: 1.13.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class Interval(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'close': 'str',
        'open': 'str'
    }

    attribute_map = {
        'close': 'close',
        'open': 'open'
    }

    def __init__(self, close=None, open=None):  # noqa: E501
        """Interval - a model defined in Swagger"""  # noqa: E501
        self._close = None
        self._open = None
        self.discriminator = None
        if close is not None:
            self.close = close
        if open is not None:
            self.open = open

    @property
    def close(self):
        """Gets the close of this Interval.  # noqa: E501

        The close value is actually the time that the store closes. Local time (in Military format) is used. So, if a store closed at 8 PM local time, the close time would look like the following: 20:00:00. This field is conditionally required if the intervals container is used to specify working hours or special hours for a store. This field is returned if set for the store location.  # noqa: E501

        :return: The close of this Interval.  # noqa: E501
        :rtype: str
        """
        return self._close

    @close.setter
    def close(self, close):
        """Sets the close of this Interval.

        The close value is actually the time that the store closes. Local time (in Military format) is used. So, if a store closed at 8 PM local time, the close time would look like the following: 20:00:00. This field is conditionally required if the intervals container is used to specify working hours or special hours for a store. This field is returned if set for the store location.  # noqa: E501

        :param close: The close of this Interval.  # noqa: E501
        :type: str
        """

        self._close = close

    @property
    def open(self):
        """Gets the open of this Interval.  # noqa: E501

        The open value is actually the time that the store opens. Local time (in Military format) is used. So, if a store opens at 9 AM local time, the close time would look like the following: 09:00:00. This field is conditionally required if the intervals container is used to specify working hours or special hours for a store. This field is returned if set for the store location.  # noqa: E501

        :return: The open of this Interval.  # noqa: E501
        :rtype: str
        """
        return self._open

    @open.setter
    def open(self, open):
        """Sets the open of this Interval.

        The open value is actually the time that the store opens. Local time (in Military format) is used. So, if a store opens at 9 AM local time, the close time would look like the following: 09:00:00. This field is conditionally required if the intervals container is used to specify working hours or special hours for a store. This field is returned if set for the store location.  # noqa: E501

        :param open: The open of this Interval.  # noqa: E501
        :type: str
        """

        self._open = open

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Interval, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Interval):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
