# coding: utf-8

"""
    Inventory API

    The Inventory API is used to create and manage inventory, and then to publish and manage this inventory on an eBay marketplace. There are also methods in this API that will convert eligible, active eBay listings into the Inventory API model.  # noqa: E501

    OpenAPI spec version: 1.13.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class MigrateListingResponse(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'errors': 'list[Error]',
        'inventory_item_group_key': 'str',
        'inventory_items': 'list[InventoryItemListing]',
        'listing_id': 'str',
        'marketplace_id': 'str',
        'status_code': 'int',
        'warnings': 'list[Error]'
    }

    attribute_map = {
        'errors': 'errors',
        'inventory_item_group_key': 'inventoryItemGroupKey',
        'inventory_items': 'inventoryItems',
        'listing_id': 'listingId',
        'marketplace_id': 'marketplaceId',
        'status_code': 'statusCode',
        'warnings': 'warnings'
    }

    def __init__(self, errors=None, inventory_item_group_key=None, inventory_items=None, listing_id=None, marketplace_id=None, status_code=None, warnings=None):  # noqa: E501
        """MigrateListingResponse - a model defined in Swagger"""  # noqa: E501
        self._errors = None
        self._inventory_item_group_key = None
        self._inventory_items = None
        self._listing_id = None
        self._marketplace_id = None
        self._status_code = None
        self._warnings = None
        self.discriminator = None
        if errors is not None:
            self.errors = errors
        if inventory_item_group_key is not None:
            self.inventory_item_group_key = inventory_item_group_key
        if inventory_items is not None:
            self.inventory_items = inventory_items
        if listing_id is not None:
            self.listing_id = listing_id
        if marketplace_id is not None:
            self.marketplace_id = marketplace_id
        if status_code is not None:
            self.status_code = status_code
        if warnings is not None:
            self.warnings = warnings

    @property
    def errors(self):
        """Gets the errors of this MigrateListingResponse.  # noqa: E501

        If one or more errors occur with the attempt to migrate the listing, this container will be returned with detailed information on each error.  # noqa: E501

        :return: The errors of this MigrateListingResponse.  # noqa: E501
        :rtype: list[Error]
        """
        return self._errors

    @errors.setter
    def errors(self, errors):
        """Sets the errors of this MigrateListingResponse.

        If one or more errors occur with the attempt to migrate the listing, this container will be returned with detailed information on each error.  # noqa: E501

        :param errors: The errors of this MigrateListingResponse.  # noqa: E501
        :type: list[Error]
        """

        self._errors = errors

    @property
    def inventory_item_group_key(self):
        """Gets the inventory_item_group_key of this MigrateListingResponse.  # noqa: E501

        This field will only be returned for a multiple-variation listing that the seller attempted to migrate. Its value is auto-generated by eBay. For a multiple-variation listing that is successfully migrated to the new Inventory model, eBay automatically creates an inventory item group object for the listing, and the seller will be able to retrieve and manage that new inventory item group object by using the value in this field.  # noqa: E501

        :return: The inventory_item_group_key of this MigrateListingResponse.  # noqa: E501
        :rtype: str
        """
        return self._inventory_item_group_key

    @inventory_item_group_key.setter
    def inventory_item_group_key(self, inventory_item_group_key):
        """Sets the inventory_item_group_key of this MigrateListingResponse.

        This field will only be returned for a multiple-variation listing that the seller attempted to migrate. Its value is auto-generated by eBay. For a multiple-variation listing that is successfully migrated to the new Inventory model, eBay automatically creates an inventory item group object for the listing, and the seller will be able to retrieve and manage that new inventory item group object by using the value in this field.  # noqa: E501

        :param inventory_item_group_key: The inventory_item_group_key of this MigrateListingResponse.  # noqa: E501
        :type: str
        """

        self._inventory_item_group_key = inventory_item_group_key

    @property
    def inventory_items(self):
        """Gets the inventory_items of this MigrateListingResponse.  # noqa: E501

        This container exists of an array of SKU values and offer IDs. For single-variation listings, this will only be one SKU value and one offer ID (if listing was successfully migrated), but multiple SKU values and offer IDs will be returned for multiple-variation listings.  # noqa: E501

        :return: The inventory_items of this MigrateListingResponse.  # noqa: E501
        :rtype: list[InventoryItemListing]
        """
        return self._inventory_items

    @inventory_items.setter
    def inventory_items(self, inventory_items):
        """Sets the inventory_items of this MigrateListingResponse.

        This container exists of an array of SKU values and offer IDs. For single-variation listings, this will only be one SKU value and one offer ID (if listing was successfully migrated), but multiple SKU values and offer IDs will be returned for multiple-variation listings.  # noqa: E501

        :param inventory_items: The inventory_items of this MigrateListingResponse.  # noqa: E501
        :type: list[InventoryItemListing]
        """

        self._inventory_items = inventory_items

    @property
    def listing_id(self):
        """Gets the listing_id of this MigrateListingResponse.  # noqa: E501

        The unique identifier of the eBay listing that the seller attempted to migrate.  # noqa: E501

        :return: The listing_id of this MigrateListingResponse.  # noqa: E501
        :rtype: str
        """
        return self._listing_id

    @listing_id.setter
    def listing_id(self, listing_id):
        """Sets the listing_id of this MigrateListingResponse.

        The unique identifier of the eBay listing that the seller attempted to migrate.  # noqa: E501

        :param listing_id: The listing_id of this MigrateListingResponse.  # noqa: E501
        :type: str
        """

        self._listing_id = listing_id

    @property
    def marketplace_id(self):
        """Gets the marketplace_id of this MigrateListingResponse.  # noqa: E501

        This is the unique identifier of the eBay Marketplace where the listing resides. The value fo the eBay US site will be EBAY_US. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/inventory/types/slr:MarketplaceEnum'>eBay API documentation</a>  # noqa: E501

        :return: The marketplace_id of this MigrateListingResponse.  # noqa: E501
        :rtype: str
        """
        return self._marketplace_id

    @marketplace_id.setter
    def marketplace_id(self, marketplace_id):
        """Sets the marketplace_id of this MigrateListingResponse.

        This is the unique identifier of the eBay Marketplace where the listing resides. The value fo the eBay US site will be EBAY_US. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/inventory/types/slr:MarketplaceEnum'>eBay API documentation</a>  # noqa: E501

        :param marketplace_id: The marketplace_id of this MigrateListingResponse.  # noqa: E501
        :type: str
        """

        self._marketplace_id = marketplace_id

    @property
    def status_code(self):
        """Gets the status_code of this MigrateListingResponse.  # noqa: E501

        This field is returned for each listing that the seller attempted to migrate. See the HTTP status codes table to see which each status code indicates.  # noqa: E501

        :return: The status_code of this MigrateListingResponse.  # noqa: E501
        :rtype: int
        """
        return self._status_code

    @status_code.setter
    def status_code(self, status_code):
        """Sets the status_code of this MigrateListingResponse.

        This field is returned for each listing that the seller attempted to migrate. See the HTTP status codes table to see which each status code indicates.  # noqa: E501

        :param status_code: The status_code of this MigrateListingResponse.  # noqa: E501
        :type: int
        """

        self._status_code = status_code

    @property
    def warnings(self):
        """Gets the warnings of this MigrateListingResponse.  # noqa: E501

        If one or more warnings occur with the attempt to migrate the listing, this container will be returned with detailed information on each warning. It is possible that a listing can be successfully migrated even if a warning occurs.  # noqa: E501

        :return: The warnings of this MigrateListingResponse.  # noqa: E501
        :rtype: list[Error]
        """
        return self._warnings

    @warnings.setter
    def warnings(self, warnings):
        """Sets the warnings of this MigrateListingResponse.

        If one or more warnings occur with the attempt to migrate the listing, this container will be returned with detailed information on each warning. It is possible that a listing can be successfully migrated even if a warning occurs.  # noqa: E501

        :param warnings: The warnings of this MigrateListingResponse.  # noqa: E501
        :type: list[Error]
        """

        self._warnings = warnings

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(MigrateListingResponse, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, MigrateListingResponse):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
