# coding: utf-8

"""
    Inventory API

    The Inventory API is used to create and manage inventory, and then to publish and manage this inventory on an eBay marketplace. There are also methods in this API that will convert eligible, active eBay listings into the Inventory API model.  # noqa: E501

    OpenAPI spec version: 1.13.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class OfferKeysWithId(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'offers': 'list[OfferKeyWithId]'
    }

    attribute_map = {
        'offers': 'offers'
    }

    def __init__(self, offers=None):  # noqa: E501
        """OfferKeysWithId - a model defined in Swagger"""  # noqa: E501
        self._offers = None
        self.discriminator = None
        if offers is not None:
            self.offers = offers

    @property
    def offers(self):
        """Gets the offers of this OfferKeysWithId.  # noqa: E501

        This container is used to identify one or more (up to 250)unpublished offers for which expected listing fees will be retrieved. The user passes one or more offerId values (maximum of 250) in to this container to identify the unpublished offers in which to retrieve expected listing fees. This call is only applicable for offers in the unpublished state. The call response gives aggregate fee amounts per eBay marketplace, and does not give fee information at the individual offer level.  # noqa: E501

        :return: The offers of this OfferKeysWithId.  # noqa: E501
        :rtype: list[OfferKeyWithId]
        """
        return self._offers

    @offers.setter
    def offers(self, offers):
        """Sets the offers of this OfferKeysWithId.

        This container is used to identify one or more (up to 250)unpublished offers for which expected listing fees will be retrieved. The user passes one or more offerId values (maximum of 250) in to this container to identify the unpublished offers in which to retrieve expected listing fees. This call is only applicable for offers in the unpublished state. The call response gives aggregate fee amounts per eBay marketplace, and does not give fee information at the individual offer level.  # noqa: E501

        :param offers: The offers of this OfferKeysWithId.  # noqa: E501
        :type: list[OfferKeyWithId]
        """

        self._offers = offers

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(OfferKeysWithId, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, OfferKeysWithId):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
