# coding: utf-8

"""
    Listing API

    Enables a seller adding an ad or item on a Partner's site to automatically create an eBay listing draft using the item details from the Partner's site.  # noqa: E501

    OpenAPI spec version: v1_beta.3.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ItemDraft(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'category_id': 'str',
        'condition': 'str',
        'format': 'str',
        'pricing_summary': 'PricingSummary',
        'product': 'Product',
        'charity': 'Charity'
    }

    attribute_map = {
        'category_id': 'categoryId',
        'condition': 'condition',
        'format': 'format',
        'pricing_summary': 'pricingSummary',
        'product': 'product',
        'charity': 'charity'
    }

    def __init__(self, category_id=None, condition=None, format=None, pricing_summary=None, product=None, charity=None):  # noqa: E501
        """ItemDraft - a model defined in Swagger"""  # noqa: E501
        self._category_id = None
        self._condition = None
        self._format = None
        self._pricing_summary = None
        self._product = None
        self._charity = None
        self.discriminator = None
        if category_id is not None:
            self.category_id = category_id
        if condition is not None:
            self.condition = condition
        if format is not None:
            self.format = format
        if pricing_summary is not None:
            self.pricing_summary = pricing_summary
        if product is not None:
            self.product = product
        if charity is not None:
            self.charity = charity

    @property
    def category_id(self):
        """Gets the category_id of this ItemDraft.  # noqa: E501

        The ID of the leaf category associated with this item. A leaf category is the lowest level in that category and has no children. Note: If you submit both a category ID and an EPID, eBay determines the best category based on the EPID and uses that. The category ID will be ignored.  # noqa: E501

        :return: The category_id of this ItemDraft.  # noqa: E501
        :rtype: str
        """
        return self._category_id

    @category_id.setter
    def category_id(self, category_id):
        """Sets the category_id of this ItemDraft.

        The ID of the leaf category associated with this item. A leaf category is the lowest level in that category and has no children. Note: If you submit both a category ID and an EPID, eBay determines the best category based on the EPID and uses that. The category ID will be ignored.  # noqa: E501

        :param category_id: The category_id of this ItemDraft.  # noqa: E501
        :type: str
        """

        self._category_id = category_id

    @property
    def condition(self):
        """Gets the condition of this ItemDraft.  # noqa: E501

        The enumeration value passed in here sets the condition of the item, such as NEW or USED_EXCELLENT. See ConditionEnum for the full list of supported values. Supported item conditions can vary by eBay category. To see which item conditions are supported for a category, you can use the getItemConditionPolicies method of the Metadata API. Note: The 'Manufacturer Refurbished' item condition is no longer a valid item condition in any eBay marketplace, and to reflect this change, the pre-existing MANUFACTURER_REFURBISHED enumeration value has been replaced by the CERTIFIED_REFURBISHED enumeration value. CR-eligible sellers should make a note to start using CERTIFIED_REFURBISHED from this point forward. To list an item as 'Certified Refurbished', a seller must be pre-qualified by eBay for this feature. Any seller who is not eligible for this feature will be blocked if they try to create a new listing or revise an existing listing with this item condition. Any seller that is interested in eligibility requirements to list with 'Certified Refurbished' should see the Certified refurbished program page in Seller Center. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/listing/types/api:ConditionEnum'>eBay API documentation</a>  # noqa: E501

        :return: The condition of this ItemDraft.  # noqa: E501
        :rtype: str
        """
        return self._condition

    @condition.setter
    def condition(self, condition):
        """Sets the condition of this ItemDraft.

        The enumeration value passed in here sets the condition of the item, such as NEW or USED_EXCELLENT. See ConditionEnum for the full list of supported values. Supported item conditions can vary by eBay category. To see which item conditions are supported for a category, you can use the getItemConditionPolicies method of the Metadata API. Note: The 'Manufacturer Refurbished' item condition is no longer a valid item condition in any eBay marketplace, and to reflect this change, the pre-existing MANUFACTURER_REFURBISHED enumeration value has been replaced by the CERTIFIED_REFURBISHED enumeration value. CR-eligible sellers should make a note to start using CERTIFIED_REFURBISHED from this point forward. To list an item as 'Certified Refurbished', a seller must be pre-qualified by eBay for this feature. Any seller who is not eligible for this feature will be blocked if they try to create a new listing or revise an existing listing with this item condition. Any seller that is interested in eligibility requirements to list with 'Certified Refurbished' should see the Certified refurbished program page in Seller Center. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/listing/types/api:ConditionEnum'>eBay API documentation</a>  # noqa: E501

        :param condition: The condition of this ItemDraft.  # noqa: E501
        :type: str
        """

        self._condition = condition

    @property
    def format(self):
        """Gets the format of this ItemDraft.  # noqa: E501

        The format of the listing. Valid Values: FIXED_PRICE and AUCTION For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/listing/types/api:ListingFormatEnum'>eBay API documentation</a>  # noqa: E501

        :return: The format of this ItemDraft.  # noqa: E501
        :rtype: str
        """
        return self._format

    @format.setter
    def format(self, format):
        """Sets the format of this ItemDraft.

        The format of the listing. Valid Values: FIXED_PRICE and AUCTION For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/listing/types/api:ListingFormatEnum'>eBay API documentation</a>  # noqa: E501

        :param format: The format of this ItemDraft.  # noqa: E501
        :type: str
        """

        self._format = format

    @property
    def pricing_summary(self):
        """Gets the pricing_summary of this ItemDraft.  # noqa: E501


        :return: The pricing_summary of this ItemDraft.  # noqa: E501
        :rtype: PricingSummary
        """
        return self._pricing_summary

    @pricing_summary.setter
    def pricing_summary(self, pricing_summary):
        """Sets the pricing_summary of this ItemDraft.


        :param pricing_summary: The pricing_summary of this ItemDraft.  # noqa: E501
        :type: PricingSummary
        """

        self._pricing_summary = pricing_summary

    @property
    def product(self):
        """Gets the product of this ItemDraft.  # noqa: E501


        :return: The product of this ItemDraft.  # noqa: E501
        :rtype: Product
        """
        return self._product

    @product.setter
    def product(self, product):
        """Sets the product of this ItemDraft.


        :param product: The product of this ItemDraft.  # noqa: E501
        :type: Product
        """

        self._product = product

    @property
    def charity(self):
        """Gets the charity of this ItemDraft.  # noqa: E501


        :return: The charity of this ItemDraft.  # noqa: E501
        :rtype: Charity
        """
        return self._charity

    @charity.setter
    def charity(self, charity):
        """Sets the charity of this ItemDraft.


        :param charity: The charity of this ItemDraft.  # noqa: E501
        :type: Charity
        """

        self._charity = charity

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ItemDraft, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ItemDraft):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
