# coding: utf-8

"""
    Listing API

    Enables a seller adding an ad or item on a Partner's site to automatically create an eBay listing draft using the item details from the Partner's site.  # noqa: E501

    OpenAPI spec version: v1_beta.3.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class Product(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'aspects': 'list[Aspect]',
        'brand': 'str',
        'description': 'str',
        'epid': 'str',
        'image_urls': 'list[str]',
        'title': 'str'
    }

    attribute_map = {
        'aspects': 'aspects',
        'brand': 'brand',
        'description': 'description',
        'epid': 'epid',
        'image_urls': 'imageUrls',
        'title': 'title'
    }

    def __init__(self, aspects=None, brand=None, description=None, epid=None, image_urls=None, title=None):  # noqa: E501
        """Product - a model defined in Swagger"""  # noqa: E501
        self._aspects = None
        self._brand = None
        self._description = None
        self._epid = None
        self._image_urls = None
        self._title = None
        self.discriminator = None
        if aspects is not None:
            self.aspects = aspects
        if brand is not None:
            self.brand = brand
        if description is not None:
            self.description = description
        if epid is not None:
            self.epid = epid
        if image_urls is not None:
            self.image_urls = image_urls
        if title is not None:
            self.title = title

    @property
    def aspects(self):
        """Gets the aspects of this Product.  # noqa: E501

        The list of item aspects that describe the item (such as size, color, capacity, model, brand, etc.)  # noqa: E501

        :return: The aspects of this Product.  # noqa: E501
        :rtype: list[Aspect]
        """
        return self._aspects

    @aspects.setter
    def aspects(self, aspects):
        """Sets the aspects of this Product.

        The list of item aspects that describe the item (such as size, color, capacity, model, brand, etc.)  # noqa: E501

        :param aspects: The aspects of this Product.  # noqa: E501
        :type: list[Aspect]
        """

        self._aspects = aspects

    @property
    def brand(self):
        """Gets the brand of this Product.  # noqa: E501

        The name brand of the item, such as Nike, Apple, etc.  # noqa: E501

        :return: The brand of this Product.  # noqa: E501
        :rtype: str
        """
        return self._brand

    @brand.setter
    def brand(self, brand):
        """Sets the brand of this Product.

        The name brand of the item, such as Nike, Apple, etc.  # noqa: E501

        :param brand: The brand of this Product.  # noqa: E501
        :type: str
        """

        self._brand = brand

    @property
    def description(self):
        """Gets the description of this Product.  # noqa: E501

        The description of the item that was created by the seller. This field supports plain text or rich content within HTML tags. Note: Active content is not supported. Active content includes animation or video via JavaScript, Flash, plug-ins, or form actions. Max Length: 500,000  # noqa: E501

        :return: The description of this Product.  # noqa: E501
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """Sets the description of this Product.

        The description of the item that was created by the seller. This field supports plain text or rich content within HTML tags. Note: Active content is not supported. Active content includes animation or video via JavaScript, Flash, plug-ins, or form actions. Max Length: 500,000  # noqa: E501

        :param description: The description of this Product.  # noqa: E501
        :type: str
        """

        self._description = description

    @property
    def epid(self):
        """Gets the epid of this Product.  # noqa: E501

        An EPID is the eBay product identifier of a product from the eBay product catalog. Note: If you submit both a category ID and an EPID, eBay determines the best category based on the EPID and uses that. The category ID will be ignored.  # noqa: E501

        :return: The epid of this Product.  # noqa: E501
        :rtype: str
        """
        return self._epid

    @epid.setter
    def epid(self, epid):
        """Sets the epid of this Product.

        An EPID is the eBay product identifier of a product from the eBay product catalog. Note: If you submit both a category ID and an EPID, eBay determines the best category based on the EPID and uses that. The category ID will be ignored.  # noqa: E501

        :param epid: The epid of this Product.  # noqa: E501
        :type: str
        """

        self._epid = epid

    @property
    def image_urls(self):
        """Gets the image_urls of this Product.  # noqa: E501

        The image URLs of the item. The first URL will be the primary image, which appears on the View Item page in the eBay listing. The URL can be from the following: The eBay Picture Services (images previously uploaded). A server outside of eBay (self-hosted). For more details, see PictureURL and Introduction to Pictures in Listings. Maximum: 12 URLs (for most categories and marketplaces) Restrictions: You cannot mix self-hosted and EPS-hosted URLs in the same listing. All image URLs must be 'https'.  # noqa: E501

        :return: The image_urls of this Product.  # noqa: E501
        :rtype: list[str]
        """
        return self._image_urls

    @image_urls.setter
    def image_urls(self, image_urls):
        """Sets the image_urls of this Product.

        The image URLs of the item. The first URL will be the primary image, which appears on the View Item page in the eBay listing. The URL can be from the following: The eBay Picture Services (images previously uploaded). A server outside of eBay (self-hosted). For more details, see PictureURL and Introduction to Pictures in Listings. Maximum: 12 URLs (for most categories and marketplaces) Restrictions: You cannot mix self-hosted and EPS-hosted URLs in the same listing. All image URLs must be 'https'.  # noqa: E501

        :param image_urls: The image_urls of this Product.  # noqa: E501
        :type: list[str]
        """

        self._image_urls = image_urls

    @property
    def title(self):
        """Gets the title of this Product.  # noqa: E501

        The seller-created title of the item. This should include unique characteristics of the item, such as brand, model, color, size, capacity, etc. For example: Levi's 501 size 10 black jeans  # noqa: E501

        :return: The title of this Product.  # noqa: E501
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title):
        """Sets the title of this Product.

        The seller-created title of the item. This should include unique characteristics of the item, such as brand, model, color, size, capacity, etc. For example: Levi's 501 size 10 black jeans  # noqa: E501

        :param title: The title of this Product.  # noqa: E501
        :type: str
        """

        self._title = title

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(Product, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Product):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
