# coding: utf-8

# flake8: noqa

"""
    Logistics API

    The <b>Logistics API</b> resources offer the following capabilities: <ul><li><b>shipping_quote</b> &ndash; Consolidates into a list a set of live shipping rates, or quotes, from which you can select a rate to ship a package.</li> <li><b>shipment</b> &ndash; Creates a \"shipment\" for the selected shipping rate.</li></ul> Call <b>createShippingQuote</b> to get a list of live shipping rates. The rates returned are all valid for a specific time window and all quoted prices are at eBay-negotiated rates. <br><br>Select one of the live rates and using its associated <b>rateId</b>, create a \"shipment\" for the package by calling <b>createFromShippingQuote</b>. Creating a shipment completes an agreement, and the cost of the base service and any added shipping options are summed into the returned <b>totalShippingCost</b> value. This action also generates a shipping label that you can use to ship the package.  The total cost of the shipment is incurred when the package is shipped using the supplied shipping label.  <p class=\"tablenote\"><b>Important!</b> Sellers must set up a payment method via their eBay account before they can use the methods in this API to create a shipment and the associated shipping label.</p>  # noqa: E501

    OpenAPI spec version: v1_beta.0.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

# import apis into sdk package
from ..sell_logistics.api.shipment_api import ShipmentApi
from ..sell_logistics.api.shipping_quote_api import ShippingQuoteApi
# import ApiClient
from ..sell_logistics.api_client import ApiClient
from ..sell_logistics.configuration import Configuration
# import models into sdk package
from ..sell_logistics.models.additional_option import AdditionalOption
from ..sell_logistics.models.amount import Amount
from ..sell_logistics.models.contact import Contact
from ..sell_logistics.models.contact_address import ContactAddress
from ..sell_logistics.models.create_shipment_from_quote_request import CreateShipmentFromQuoteRequest
from ..sell_logistics.models.dimensions import Dimensions
from ..sell_logistics.models.error import Error
from ..sell_logistics.models.error_parameter import ErrorParameter
from ..sell_logistics.models.order import Order
from ..sell_logistics.models.package_specification import PackageSpecification
from ..sell_logistics.models.phone_number import PhoneNumber
from ..sell_logistics.models.pickup_slot import PickupSlot
from ..sell_logistics.models.purchased_rate import PurchasedRate
from ..sell_logistics.models.rate import Rate
from ..sell_logistics.models.shipment import Shipment
from ..sell_logistics.models.shipment_cancellation import ShipmentCancellation
from ..sell_logistics.models.shipping_quote import ShippingQuote
from ..sell_logistics.models.shipping_quote_request import ShippingQuoteRequest
from ..sell_logistics.models.weight import Weight
