# coding: utf-8

"""
    Marketing API

    <p>The <i>Marketing API </i> offers two platforms that sellers can use to promote and advertise their products:</p> <ul><li><b>Promoted Listings</b> is an eBay ad service that lets sellers set up <i>ad campaigns </i> for the products they want to promote. eBay displays the ads in search results and in other marketing modules as <b>SPONSORED</b> listings. If an item in a Promoted Listings campaign sells, the seller is assessed a Promoted Listings fee, which is a seller-specified percentage applied to the sales price. For complete details, see <a href=\"/api-docs/sell/static/marketing/promoted-listings.html\">Promoted Listings</a>.</li>  <li><b>Promotions Manager</b> gives sellers a way to offer discounts on specific items as a way to attract buyers to their inventory. Sellers can set up discounts (such as \"20% off\" and other types of offers) on specific items or on an entire customer order. To further attract buyers, eBay prominently displays promotion <i>teasers</i> throughout buyer flows. For complete details, see <a href=\"/api-docs/sell/static/marketing/promotions-manager.html\">Promotions Manager</a>.</li></ul>  <p><b>Marketing reports</b>, on both the Promoted Listings and Promotions Manager platforms, give sellers information that shows the effectiveness of their marketing strategies. The data gives sellers the ability to review and fine tune their marketing efforts.</p> <p class=\"tablenote\"><b>Important!</b> Sellers must have an active eBay Store subscription, and they must accept the <b>Terms and Conditions</b> before they can make requests to these APIs in the Production environment. There are also site-specific listings requirements and restrictions associated with these marketing tools, as listed in the \"requirements and restrictions\" sections for <a href=\"/api-docs/sell/marketing/static/overview.html#PL-requirements\">Promoted Listings</a> and <a href=\"/api-docs/sell/marketing/static/overview.html#PM-requirements\">Promotions Manager</a>.</p> <p>The table below lists all the Marketing API calls grouped by resource.</p>  # noqa: E501

    OpenAPI spec version: v1.8.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class CreateReportTask(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'campaign_ids': 'list[str]',
        'date_from': 'str',
        'date_to': 'str',
        'dimensions': 'list[Dimension]',
        'inventory_references': 'list[InventoryReference]',
        'listing_ids': 'list[str]',
        'marketplace_id': 'str',
        'metric_keys': 'list[str]',
        'report_format': 'str',
        'report_type': 'str'
    }

    attribute_map = {
        'campaign_ids': 'campaignIds',
        'date_from': 'dateFrom',
        'date_to': 'dateTo',
        'dimensions': 'dimensions',
        'inventory_references': 'inventoryReferences',
        'listing_ids': 'listingIds',
        'marketplace_id': 'marketplaceId',
        'metric_keys': 'metricKeys',
        'report_format': 'reportFormat',
        'report_type': 'reportType'
    }

    def __init__(self, campaign_ids=None, date_from=None, date_to=None, dimensions=None, inventory_references=None, listing_ids=None, marketplace_id=None, metric_keys=None, report_format=None, report_type=None):  # noqa: E501
        """CreateReportTask - a model defined in Swagger"""  # noqa: E501
        self._campaign_ids = None
        self._date_from = None
        self._date_to = None
        self._dimensions = None
        self._inventory_references = None
        self._listing_ids = None
        self._marketplace_id = None
        self._metric_keys = None
        self._report_format = None
        self._report_type = None
        self.discriminator = None
        if campaign_ids is not None:
            self.campaign_ids = campaign_ids
        if date_from is not None:
            self.date_from = date_from
        if date_to is not None:
            self.date_to = date_to
        if dimensions is not None:
            self.dimensions = dimensions
        if inventory_references is not None:
            self.inventory_references = inventory_references
        if listing_ids is not None:
            self.listing_ids = listing_ids
        if marketplace_id is not None:
            self.marketplace_id = marketplace_id
        if metric_keys is not None:
            self.metric_keys = metric_keys
        if report_format is not None:
            self.report_format = report_format
        if report_type is not None:
            self.report_type = report_type

    @property
    def campaign_ids(self):
        """Gets the campaign_ids of this CreateReportTask.  # noqa: E501

        A list of campaign IDs to be included in the report task. Call getCampaigns to get a list of the current campaign IDs for a seller. Note: The API currently supports only a single campaign ID per report task. Maximum: 1 Required if reportType is set to CAMPAIGN_PERFORMANCE_REPORT or CAMPAIGN_PERFORMANCE_SUMMARY_REPORT.  # noqa: E501

        :return: The campaign_ids of this CreateReportTask.  # noqa: E501
        :rtype: list[str]
        """
        return self._campaign_ids

    @campaign_ids.setter
    def campaign_ids(self, campaign_ids):
        """Sets the campaign_ids of this CreateReportTask.

        A list of campaign IDs to be included in the report task. Call getCampaigns to get a list of the current campaign IDs for a seller. Note: The API currently supports only a single campaign ID per report task. Maximum: 1 Required if reportType is set to CAMPAIGN_PERFORMANCE_REPORT or CAMPAIGN_PERFORMANCE_SUMMARY_REPORT.  # noqa: E501

        :param campaign_ids: The campaign_ids of this CreateReportTask.  # noqa: E501
        :type: list[str]
        """

        self._campaign_ids = campaign_ids

    @property
    def date_from(self):
        """Gets the date_from of this CreateReportTask.  # noqa: E501

        The date defining the start of the timespan covered by the report. Format the timestamp as an ISO 8601 string, which is based on the 24-hour Coordinated Universal Time (UTC) clock. Promoted Listings reports are aggregated on a daily basis where each day begins and ends at midnight, Mountain Standard Time (MST). This time is calculated by subtracting seven hours from the Coordinated Universal Time (UTC). Because all reports are aggregated on a daily basis, only the date values in the supplied UTC string are considered (all time values are ignored). Format: [YYYY]-[MM]-[DD]T[hh]:[mm]:[ss].[sss]Z Example: 2020-08-20T00:00:00.000Z  # noqa: E501

        :return: The date_from of this CreateReportTask.  # noqa: E501
        :rtype: str
        """
        return self._date_from

    @date_from.setter
    def date_from(self, date_from):
        """Sets the date_from of this CreateReportTask.

        The date defining the start of the timespan covered by the report. Format the timestamp as an ISO 8601 string, which is based on the 24-hour Coordinated Universal Time (UTC) clock. Promoted Listings reports are aggregated on a daily basis where each day begins and ends at midnight, Mountain Standard Time (MST). This time is calculated by subtracting seven hours from the Coordinated Universal Time (UTC). Because all reports are aggregated on a daily basis, only the date values in the supplied UTC string are considered (all time values are ignored). Format: [YYYY]-[MM]-[DD]T[hh]:[mm]:[ss].[sss]Z Example: 2020-08-20T00:00:00.000Z  # noqa: E501

        :param date_from: The date_from of this CreateReportTask.  # noqa: E501
        :type: str
        """

        self._date_from = date_from

    @property
    def date_to(self):
        """Gets the date_to of this CreateReportTask.  # noqa: E501

        The date defining the end of the timespan covered by the report, formatted as an ISO 8601 string. Promoted Listings reports are aggregated on a daily basis and each day begins and ends at midnight, Mountain Standard Time (MST). Like the dateFrom field, you need to specify only date values in the string you pass in this field; all time values are ignored.  # noqa: E501

        :return: The date_to of this CreateReportTask.  # noqa: E501
        :rtype: str
        """
        return self._date_to

    @date_to.setter
    def date_to(self, date_to):
        """Sets the date_to of this CreateReportTask.

        The date defining the end of the timespan covered by the report, formatted as an ISO 8601 string. Promoted Listings reports are aggregated on a daily basis and each day begins and ends at midnight, Mountain Standard Time (MST). Like the dateFrom field, you need to specify only date values in the string you pass in this field; all time values are ignored.  # noqa: E501

        :param date_to: The date_to of this CreateReportTask.  # noqa: E501
        :type: str
        """

        self._date_to = date_to

    @property
    def dimensions(self):
        """Gets the dimensions of this CreateReportTask.  # noqa: E501

        The list of the dimensions applied to the report. A dimension is an attribute to which the report data applies. For example, if you set dimensionKey to campaign_id in a Campaign Performance Report, the data will apply to the entire ad campaign. For information on the dimensions and how to specify them, see Reading Promoted Listings reports.  # noqa: E501

        :return: The dimensions of this CreateReportTask.  # noqa: E501
        :rtype: list[Dimension]
        """
        return self._dimensions

    @dimensions.setter
    def dimensions(self, dimensions):
        """Sets the dimensions of this CreateReportTask.

        The list of the dimensions applied to the report. A dimension is an attribute to which the report data applies. For example, if you set dimensionKey to campaign_id in a Campaign Performance Report, the data will apply to the entire ad campaign. For information on the dimensions and how to specify them, see Reading Promoted Listings reports.  # noqa: E501

        :param dimensions: The dimensions of this CreateReportTask.  # noqa: E501
        :type: list[Dimension]
        """

        self._dimensions = dimensions

    @property
    def inventory_references(self):
        """Gets the inventory_references of this CreateReportTask.  # noqa: E501

        You can use this field to supply an array of items to include in the report if you manage your inventory with the Inventory API. This field is mutually exclusive with the listingIds field; if you populate this field, do not populate the listingIds field. An inventory reference identifies an item in your inventory using a pair of values, where the inventoryReferenceId can be either a seller-defined SKU value or an inventoryItemGroupKey, where an inventoryItemGroupKey is seller-defined ID for an inventory item group (a multiple-variation listing). Couple the inventoryReferenceId with an inventoryReferenceType identifier to fully identify an item in your inventory. Maximum: 500 items Required if you do not supply an array of listingId values or if you set reportType to INVENTORY_PERFORMANCE_REPORT.  # noqa: E501

        :return: The inventory_references of this CreateReportTask.  # noqa: E501
        :rtype: list[InventoryReference]
        """
        return self._inventory_references

    @inventory_references.setter
    def inventory_references(self, inventory_references):
        """Sets the inventory_references of this CreateReportTask.

        You can use this field to supply an array of items to include in the report if you manage your inventory with the Inventory API. This field is mutually exclusive with the listingIds field; if you populate this field, do not populate the listingIds field. An inventory reference identifies an item in your inventory using a pair of values, where the inventoryReferenceId can be either a seller-defined SKU value or an inventoryItemGroupKey, where an inventoryItemGroupKey is seller-defined ID for an inventory item group (a multiple-variation listing). Couple the inventoryReferenceId with an inventoryReferenceType identifier to fully identify an item in your inventory. Maximum: 500 items Required if you do not supply an array of listingId values or if you set reportType to INVENTORY_PERFORMANCE_REPORT.  # noqa: E501

        :param inventory_references: The inventory_references of this CreateReportTask.  # noqa: E501
        :type: list[InventoryReference]
        """

        self._inventory_references = inventory_references

    @property
    def listing_ids(self):
        """Gets the listing_ids of this CreateReportTask.  # noqa: E501

        Use this field to supply a array of the listing ID you want to include in the report. This field is mutually exclusive with the inventoryReferences field; if you populate this field, do not populate the inventoryReferences field. A listing ID is the eBay listing identifier that's generated when the listing is created. Note: This field accepts listingId values generated with both the Inventory API and the eBay Traditional APIs, such as the Trading and Finding APIs. Maximum: 500 listings Required if you do not supply an array of inventoryReferences values or if you set reportType to LISTING_PERFORMANCE_REPORT.  # noqa: E501

        :return: The listing_ids of this CreateReportTask.  # noqa: E501
        :rtype: list[str]
        """
        return self._listing_ids

    @listing_ids.setter
    def listing_ids(self, listing_ids):
        """Sets the listing_ids of this CreateReportTask.

        Use this field to supply a array of the listing ID you want to include in the report. This field is mutually exclusive with the inventoryReferences field; if you populate this field, do not populate the inventoryReferences field. A listing ID is the eBay listing identifier that's generated when the listing is created. Note: This field accepts listingId values generated with both the Inventory API and the eBay Traditional APIs, such as the Trading and Finding APIs. Maximum: 500 listings Required if you do not supply an array of inventoryReferences values or if you set reportType to LISTING_PERFORMANCE_REPORT.  # noqa: E501

        :param listing_ids: The listing_ids of this CreateReportTask.  # noqa: E501
        :type: list[str]
        """

        self._listing_ids = listing_ids

    @property
    def marketplace_id(self):
        """Gets the marketplace_id of this CreateReportTask.  # noqa: E501

        The ID for the eBay marketplace on which the report is based. Maximum: 1 Required if reportType is set to ACCOUNT_PERFORMANCE_REPORT or INVENTORY_PERFORMANCE_REPORT. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/marketing/types/ba:MarketplaceIdEnum'>eBay API documentation</a>  # noqa: E501

        :return: The marketplace_id of this CreateReportTask.  # noqa: E501
        :rtype: str
        """
        return self._marketplace_id

    @marketplace_id.setter
    def marketplace_id(self, marketplace_id):
        """Sets the marketplace_id of this CreateReportTask.

        The ID for the eBay marketplace on which the report is based. Maximum: 1 Required if reportType is set to ACCOUNT_PERFORMANCE_REPORT or INVENTORY_PERFORMANCE_REPORT. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/marketing/types/ba:MarketplaceIdEnum'>eBay API documentation</a>  # noqa: E501

        :param marketplace_id: The marketplace_id of this CreateReportTask.  # noqa: E501
        :type: str
        """

        self._marketplace_id = marketplace_id

    @property
    def metric_keys(self):
        """Gets the metric_keys of this CreateReportTask.  # noqa: E501

        The list of metrics to be included in the report. Metrics are the quantitative measurements compiled into the report and the data returned is based on the specified dimension of the report. For example, if the dimension is campaign, the metrics for number of sales would be the number of sales in the campaign. However, if the dimension is listing, the number of sales represents the number of items sold in that listing. For information on metric keys and how to set them, see Reading Promoted Listings reports.Minimum: 1  # noqa: E501

        :return: The metric_keys of this CreateReportTask.  # noqa: E501
        :rtype: list[str]
        """
        return self._metric_keys

    @metric_keys.setter
    def metric_keys(self, metric_keys):
        """Sets the metric_keys of this CreateReportTask.

        The list of metrics to be included in the report. Metrics are the quantitative measurements compiled into the report and the data returned is based on the specified dimension of the report. For example, if the dimension is campaign, the metrics for number of sales would be the number of sales in the campaign. However, if the dimension is listing, the number of sales represents the number of items sold in that listing. For information on metric keys and how to set them, see Reading Promoted Listings reports.Minimum: 1  # noqa: E501

        :param metric_keys: The metric_keys of this CreateReportTask.  # noqa: E501
        :type: list[str]
        """

        self._metric_keys = metric_keys

    @property
    def report_format(self):
        """Gets the report_format of this CreateReportTask.  # noqa: E501

        The file format of the report. Currently, the only supported format is TSV_GZIP, which is a gzip file with tab separated values. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/marketing/types/plr:ReportFormatEnum'>eBay API documentation</a>  # noqa: E501

        :return: The report_format of this CreateReportTask.  # noqa: E501
        :rtype: str
        """
        return self._report_format

    @report_format.setter
    def report_format(self, report_format):
        """Sets the report_format of this CreateReportTask.

        The file format of the report. Currently, the only supported format is TSV_GZIP, which is a gzip file with tab separated values. For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/marketing/types/plr:ReportFormatEnum'>eBay API documentation</a>  # noqa: E501

        :param report_format: The report_format of this CreateReportTask.  # noqa: E501
        :type: str
        """

        self._report_format = report_format

    @property
    def report_type(self):
        """Gets the report_type of this CreateReportTask.  # noqa: E501

        The type of report to be generated, such as ACCOUNT_PERFORMANCE_REPORT, CAMPAIGN_PERFORMANCE_REPORT, and so on. Maximum: 1 For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/marketing/types/plr:ReportTypeEnum'>eBay API documentation</a>  # noqa: E501

        :return: The report_type of this CreateReportTask.  # noqa: E501
        :rtype: str
        """
        return self._report_type

    @report_type.setter
    def report_type(self, report_type):
        """Sets the report_type of this CreateReportTask.

        The type of report to be generated, such as ACCOUNT_PERFORMANCE_REPORT, CAMPAIGN_PERFORMANCE_REPORT, and so on. Maximum: 1 For implementation help, refer to <a href='https://developer.ebay.com/api-docs/sell/marketing/types/plr:ReportTypeEnum'>eBay API documentation</a>  # noqa: E501

        :param report_type: The report_type of this CreateReportTask.  # noqa: E501
        :type: str
        """

        self._report_type = report_type

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(CreateReportTask, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CreateReportTask):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
