# coding: utf-8

"""
    Metadata API

    The Metadata API has operations that retrieve configuration details pertaining to the different eBay marketplaces. In addition to marketplace information, the API also has operations that get information that helps sellers list items on eBay.  # noqa: E501

    OpenAPI spec version: v1.4.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ListingStructurePolicy(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'category_id': 'str',
        'category_tree_id': 'str',
        'variations_supported': 'bool'
    }

    attribute_map = {
        'category_id': 'categoryId',
        'category_tree_id': 'categoryTreeId',
        'variations_supported': 'variationsSupported'
    }

    def __init__(self, category_id=None, category_tree_id=None, variations_supported=None):  # noqa: E501
        """ListingStructurePolicy - a model defined in Swagger"""  # noqa: E501
        self._category_id = None
        self._category_tree_id = None
        self._variations_supported = None
        self.discriminator = None
        if category_id is not None:
            self.category_id = category_id
        if category_tree_id is not None:
            self.category_tree_id = category_tree_id
        if variations_supported is not None:
            self.variations_supported = variations_supported

    @property
    def category_id(self):
        """Gets the category_id of this ListingStructurePolicy.  # noqa: E501

        The category ID to which the listing-structure policy applies.  # noqa: E501

        :return: The category_id of this ListingStructurePolicy.  # noqa: E501
        :rtype: str
        """
        return self._category_id

    @category_id.setter
    def category_id(self, category_id):
        """Sets the category_id of this ListingStructurePolicy.

        The category ID to which the listing-structure policy applies.  # noqa: E501

        :param category_id: The category_id of this ListingStructurePolicy.  # noqa: E501
        :type: str
        """

        self._category_id = category_id

    @property
    def category_tree_id(self):
        """Gets the category_tree_id of this ListingStructurePolicy.  # noqa: E501

        A value that indicates the root node of the category tree used for the response set. Each marketplace is based on a category tree whose root node is indicated by this unique category ID value. All category policy information returned by this call pertains to the categories included below this root node of the tree. A category tree is a hierarchical framework of eBay categories that begins at the root node of the tree and extends to include all the child nodes in the tree. Each child node in the tree is an eBay category that is represented by a unique categoryId value. Within a category tree, the root node has no parent node and leaf nodes are nodes that have no child nodes.  # noqa: E501

        :return: The category_tree_id of this ListingStructurePolicy.  # noqa: E501
        :rtype: str
        """
        return self._category_tree_id

    @category_tree_id.setter
    def category_tree_id(self, category_tree_id):
        """Sets the category_tree_id of this ListingStructurePolicy.

        A value that indicates the root node of the category tree used for the response set. Each marketplace is based on a category tree whose root node is indicated by this unique category ID value. All category policy information returned by this call pertains to the categories included below this root node of the tree. A category tree is a hierarchical framework of eBay categories that begins at the root node of the tree and extends to include all the child nodes in the tree. Each child node in the tree is an eBay category that is represented by a unique categoryId value. Within a category tree, the root node has no parent node and leaf nodes are nodes that have no child nodes.  # noqa: E501

        :param category_tree_id: The category_tree_id of this ListingStructurePolicy.  # noqa: E501
        :type: str
        """

        self._category_tree_id = category_tree_id

    @property
    def variations_supported(self):
        """Gets the variations_supported of this ListingStructurePolicy.  # noqa: E501

        This flag denotes whether or not the associated category supports listings with item variations. If set to true, the category does support item variations.  # noqa: E501

        :return: The variations_supported of this ListingStructurePolicy.  # noqa: E501
        :rtype: bool
        """
        return self._variations_supported

    @variations_supported.setter
    def variations_supported(self, variations_supported):
        """Sets the variations_supported of this ListingStructurePolicy.

        This flag denotes whether or not the associated category supports listings with item variations. If set to true, the category does support item variations.  # noqa: E501

        :param variations_supported: The variations_supported of this ListingStructurePolicy.  # noqa: E501
        :type: bool
        """

        self._variations_supported = variations_supported

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ListingStructurePolicy, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ListingStructurePolicy):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
