# coding: utf-8

"""
    Metadata API

    The Metadata API has operations that retrieve configuration details pertaining to the different eBay marketplaces. In addition to marketplace information, the API also has operations that get information that helps sellers list items on eBay.  # noqa: E501

    OpenAPI spec version: v1.4.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class NegotiatedPricePolicy(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'best_offer_auto_accept_enabled': 'bool',
        'best_offer_auto_decline_enabled': 'bool',
        'best_offer_counter_enabled': 'bool',
        'category_id': 'str',
        'category_tree_id': 'str'
    }

    attribute_map = {
        'best_offer_auto_accept_enabled': 'bestOfferAutoAcceptEnabled',
        'best_offer_auto_decline_enabled': 'bestOfferAutoDeclineEnabled',
        'best_offer_counter_enabled': 'bestOfferCounterEnabled',
        'category_id': 'categoryId',
        'category_tree_id': 'categoryTreeId'
    }

    def __init__(self, best_offer_auto_accept_enabled=None, best_offer_auto_decline_enabled=None, best_offer_counter_enabled=None, category_id=None, category_tree_id=None):  # noqa: E501
        """NegotiatedPricePolicy - a model defined in Swagger"""  # noqa: E501
        self._best_offer_auto_accept_enabled = None
        self._best_offer_auto_decline_enabled = None
        self._best_offer_counter_enabled = None
        self._category_id = None
        self._category_tree_id = None
        self.discriminator = None
        if best_offer_auto_accept_enabled is not None:
            self.best_offer_auto_accept_enabled = best_offer_auto_accept_enabled
        if best_offer_auto_decline_enabled is not None:
            self.best_offer_auto_decline_enabled = best_offer_auto_decline_enabled
        if best_offer_counter_enabled is not None:
            self.best_offer_counter_enabled = best_offer_counter_enabled
        if category_id is not None:
            self.category_id = category_id
        if category_tree_id is not None:
            self.category_tree_id = category_tree_id

    @property
    def best_offer_auto_accept_enabled(self):
        """Gets the best_offer_auto_accept_enabled of this NegotiatedPricePolicy.  # noqa: E501

        This flag denotes whether or not the category supports the setting of a price at which best offers are automatically accepted. If set to true, the category does support the setting of an automatic price for best-offers.  # noqa: E501

        :return: The best_offer_auto_accept_enabled of this NegotiatedPricePolicy.  # noqa: E501
        :rtype: bool
        """
        return self._best_offer_auto_accept_enabled

    @best_offer_auto_accept_enabled.setter
    def best_offer_auto_accept_enabled(self, best_offer_auto_accept_enabled):
        """Sets the best_offer_auto_accept_enabled of this NegotiatedPricePolicy.

        This flag denotes whether or not the category supports the setting of a price at which best offers are automatically accepted. If set to true, the category does support the setting of an automatic price for best-offers.  # noqa: E501

        :param best_offer_auto_accept_enabled: The best_offer_auto_accept_enabled of this NegotiatedPricePolicy.  # noqa: E501
        :type: bool
        """

        self._best_offer_auto_accept_enabled = best_offer_auto_accept_enabled

    @property
    def best_offer_auto_decline_enabled(self):
        """Gets the best_offer_auto_decline_enabled of this NegotiatedPricePolicy.  # noqa: E501

        This flag denotes whether or not the category supports the setting of an auto-decline price for best offers. If set to true, the category does support the setting of an automatic-decline price for best-offers.  # noqa: E501

        :return: The best_offer_auto_decline_enabled of this NegotiatedPricePolicy.  # noqa: E501
        :rtype: bool
        """
        return self._best_offer_auto_decline_enabled

    @best_offer_auto_decline_enabled.setter
    def best_offer_auto_decline_enabled(self, best_offer_auto_decline_enabled):
        """Sets the best_offer_auto_decline_enabled of this NegotiatedPricePolicy.

        This flag denotes whether or not the category supports the setting of an auto-decline price for best offers. If set to true, the category does support the setting of an automatic-decline price for best-offers.  # noqa: E501

        :param best_offer_auto_decline_enabled: The best_offer_auto_decline_enabled of this NegotiatedPricePolicy.  # noqa: E501
        :type: bool
        """

        self._best_offer_auto_decline_enabled = best_offer_auto_decline_enabled

    @property
    def best_offer_counter_enabled(self):
        """Gets the best_offer_counter_enabled of this NegotiatedPricePolicy.  # noqa: E501

        This flag denotes whether or not the category supports the setting for an automatic counter-offer on best offers. If set to true, the category does support the setting of an automatic counter-offer price for best-offers.  # noqa: E501

        :return: The best_offer_counter_enabled of this NegotiatedPricePolicy.  # noqa: E501
        :rtype: bool
        """
        return self._best_offer_counter_enabled

    @best_offer_counter_enabled.setter
    def best_offer_counter_enabled(self, best_offer_counter_enabled):
        """Sets the best_offer_counter_enabled of this NegotiatedPricePolicy.

        This flag denotes whether or not the category supports the setting for an automatic counter-offer on best offers. If set to true, the category does support the setting of an automatic counter-offer price for best-offers.  # noqa: E501

        :param best_offer_counter_enabled: The best_offer_counter_enabled of this NegotiatedPricePolicy.  # noqa: E501
        :type: bool
        """

        self._best_offer_counter_enabled = best_offer_counter_enabled

    @property
    def category_id(self):
        """Gets the category_id of this NegotiatedPricePolicy.  # noqa: E501

        The category ID to which the negotiated-price policies apply.  # noqa: E501

        :return: The category_id of this NegotiatedPricePolicy.  # noqa: E501
        :rtype: str
        """
        return self._category_id

    @category_id.setter
    def category_id(self, category_id):
        """Sets the category_id of this NegotiatedPricePolicy.

        The category ID to which the negotiated-price policies apply.  # noqa: E501

        :param category_id: The category_id of this NegotiatedPricePolicy.  # noqa: E501
        :type: str
        """

        self._category_id = category_id

    @property
    def category_tree_id(self):
        """Gets the category_tree_id of this NegotiatedPricePolicy.  # noqa: E501

        A value that indicates the root node of the category tree used for the response set. Each marketplace is based on a category tree whose root node is indicated by this unique category ID value. All category policy information returned by this call pertains to the categories included below this root node of the tree. A category tree is a hierarchical framework of eBay categories that begins at the root node of the tree and extends to include all the child nodes in the tree. Each child node in the tree is an eBay category that is represented by a unique categoryId value. Within a category tree, the root node has no parent node and leaf nodes are nodes that have no child nodes.  # noqa: E501

        :return: The category_tree_id of this NegotiatedPricePolicy.  # noqa: E501
        :rtype: str
        """
        return self._category_tree_id

    @category_tree_id.setter
    def category_tree_id(self, category_tree_id):
        """Sets the category_tree_id of this NegotiatedPricePolicy.

        A value that indicates the root node of the category tree used for the response set. Each marketplace is based on a category tree whose root node is indicated by this unique category ID value. All category policy information returned by this call pertains to the categories included below this root node of the tree. A category tree is a hierarchical framework of eBay categories that begins at the root node of the tree and extends to include all the child nodes in the tree. Each child node in the tree is an eBay category that is represented by a unique categoryId value. Within a category tree, the root node has no parent node and leaf nodes are nodes that have no child nodes.  # noqa: E501

        :param category_tree_id: The category_tree_id of this NegotiatedPricePolicy.  # noqa: E501
        :type: str
        """

        self._category_tree_id = category_tree_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(NegotiatedPricePolicy, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NegotiatedPricePolicy):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
