# coding: utf-8

"""
    Recommendation API

    The <b>Recommendation API</b> returns information that sellers can use to optimize the configuration of their listings on eBay. <br><br>Currently, the API contains a single method, <b>findListingRecommendations</b>. This method provides information that sellers can use to configure Promoted Listings ad campaigns to maximize the visibility of their items in the eBay marketplace.  # noqa: E501

    OpenAPI spec version: 1.1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class ListingRecommendation(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'listing_id': 'str',
        'marketing': 'MarketingRecommendation'
    }

    attribute_map = {
        'listing_id': 'listingId',
        'marketing': 'marketing'
    }

    def __init__(self, listing_id=None, marketing=None):  # noqa: E501
        """ListingRecommendation - a model defined in Swagger"""  # noqa: E501
        self._listing_id = None
        self._marketing = None
        self.discriminator = None
        if listing_id is not None:
            self.listing_id = listing_id
        if marketing is not None:
            self.marketing = marketing

    @property
    def listing_id(self):
        """Gets the listing_id of this ListingRecommendation.  # noqa: E501

        An ID that identifies the active listing associated with the eBay recommendations.  # noqa: E501

        :return: The listing_id of this ListingRecommendation.  # noqa: E501
        :rtype: str
        """
        return self._listing_id

    @listing_id.setter
    def listing_id(self, listing_id):
        """Sets the listing_id of this ListingRecommendation.

        An ID that identifies the active listing associated with the eBay recommendations.  # noqa: E501

        :param listing_id: The listing_id of this ListingRecommendation.  # noqa: E501
        :type: str
        """

        self._listing_id = listing_id

    @property
    def marketing(self):
        """Gets the marketing of this ListingRecommendation.  # noqa: E501


        :return: The marketing of this ListingRecommendation.  # noqa: E501
        :rtype: MarketingRecommendation
        """
        return self._marketing

    @marketing.setter
    def marketing(self, marketing):
        """Sets the marketing of this ListingRecommendation.


        :param marketing: The marketing of this ListingRecommendation.  # noqa: E501
        :type: MarketingRecommendation
        """

        self._marketing = marketing

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(ListingRecommendation, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ListingRecommendation):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
