export interface ScanProps {
    /**
     * The name of the project being scanned.
     */
    readonly projectName?: string;
    /**
     * Basedir
     *
     * @default `.`
     */
    readonly basedir?: string;
    /**
     * The path to scan.
     */
    readonly paths: string[];
    /**
     * The path patterns to exclude from the scan
     */
    readonly excludes?: string[];
    /**
     * If the score set between 0 and 10 the exit code from dependency-check will indicate if a vulnerability with a CVSS score equal to or higher was identified.
     *
     * @default 0
     */
    readonly failOnCVSS?: number;
    /**
     * Enable the experimental analyzers. If not set the analyzers marked as experimental will not be loaded or used.
     *
     * @default false
     */
    readonly enableExperimental?: boolean;
    /**
     * Disables the automatic updating of the CPE data.
     *
     * @default false
     */
    readonly noUpdate?: boolean;
    /**
     * The file paths to the suppression XML files; used to suppress false positives.
     */
    readonly suppressions?: string[];
}
export declare class Cli {
    private readonly command;
    constructor(command?: string);
    scan(props: ScanProps): string;
    update(): string;
    version(): string;
}
