# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['AppArgs', 'App']

@pulumi.input_type
class AppArgs:
    def __init__(__self__, *,
                 spec: Optional[pulumi.Input['AppSpecArgs']] = None):
        """
        The set of arguments for constructing a App resource.
        :param pulumi.Input['AppSpecArgs'] spec: A DigitalOcean App spec describing the app.
        """
        if spec is not None:
            pulumi.set(__self__, "spec", spec)

    @property
    @pulumi.getter
    def spec(self) -> Optional[pulumi.Input['AppSpecArgs']]:
        """
        A DigitalOcean App spec describing the app.
        """
        return pulumi.get(self, "spec")

    @spec.setter
    def spec(self, value: Optional[pulumi.Input['AppSpecArgs']]):
        pulumi.set(self, "spec", value)


class App(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 spec: Optional[pulumi.Input[pulumi.InputType['AppSpecArgs']]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Provides a DigitalOcean App resource.

        ## Example Usage

        To create an app, provide a [DigitalOcean app spec](https://www.digitalocean.com/docs/app-platform/references/app-specification-reference/) specifying the app's components.
        ### Basic Example

        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        golang_sample = digitalocean.App("golang-sample", spec=digitalocean.AppSpecArgs(
            name="golang-sample",
            region="ams",
            services=[digitalocean.AppSpecServiceArgs(
                environment_slug="go",
                git=digitalocean.AppSpecServiceGitArgs(
                    branch="main",
                    repo_clone_url="https://github.com/digitalocean/sample-golang.git",
                ),
                instance_count=1,
                instance_size_slug="professional-xs",
                name="go-service",
            )],
        ))
        ```
        ### Static Site Example

        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        static_ste_example = digitalocean.App("static-ste-example", spec=digitalocean.AppSpecArgs(
            name="static-ste-example",
            region="ams",
            static_sites=[digitalocean.AppSpecStaticSiteArgs(
                build_command="bundle exec jekyll build -d ./public",
                git=digitalocean.AppSpecStaticSiteGitArgs(
                    branch="main",
                    repo_clone_url="https://github.com/digitalocean/sample-jekyll.git",
                ),
                name="sample-jekyll",
                output_dir="/public",
            )],
        ))
        ```
        ### Multiple Components Example

        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        mono_repo_example = digitalocean.App("mono-repo-example", spec=digitalocean.AppSpecArgs(
            databases=[digitalocean.AppSpecDatabaseArgs(
                engine="PG",
                name="starter-db",
                production=False,
            )],
            domains=[{
                "name": "foo.example.com",
            }],
            name="mono-repo-example",
            region="ams",
            services=[digitalocean.AppSpecServiceArgs(
                environment_slug="go",
                github=digitalocean.AppSpecServiceGithubArgs(
                    branch="main",
                    deploy_on_push=True,
                    repo="username/repo",
                ),
                http_port=3000,
                instance_count=2,
                instance_size_slug="professional-xs",
                name="api",
                routes=[digitalocean.AppSpecServiceRouteArgs(
                    path="/api",
                )],
                run_command="bin/api",
                source_dir="api/",
            )],
            static_sites=[digitalocean.AppSpecStaticSiteArgs(
                build_command="npm run build",
                github=digitalocean.AppSpecStaticSiteGithubArgs(
                    branch="main",
                    deploy_on_push=True,
                    repo="username/repo",
                ),
                name="web",
                routes=[digitalocean.AppSpecStaticSiteRouteArgs(
                    path="/",
                )],
            )],
        ))
        ```

        ## Import

        An app can be imported using its `id`, e.g.

        ```sh
         $ pulumi import digitalocean:index/app:App myapp fb06ad00-351f-45c8-b5eb-13523c438661
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['AppSpecArgs']] spec: A DigitalOcean App spec describing the app.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[AppArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a DigitalOcean App resource.

        ## Example Usage

        To create an app, provide a [DigitalOcean app spec](https://www.digitalocean.com/docs/app-platform/references/app-specification-reference/) specifying the app's components.
        ### Basic Example

        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        golang_sample = digitalocean.App("golang-sample", spec=digitalocean.AppSpecArgs(
            name="golang-sample",
            region="ams",
            services=[digitalocean.AppSpecServiceArgs(
                environment_slug="go",
                git=digitalocean.AppSpecServiceGitArgs(
                    branch="main",
                    repo_clone_url="https://github.com/digitalocean/sample-golang.git",
                ),
                instance_count=1,
                instance_size_slug="professional-xs",
                name="go-service",
            )],
        ))
        ```
        ### Static Site Example

        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        static_ste_example = digitalocean.App("static-ste-example", spec=digitalocean.AppSpecArgs(
            name="static-ste-example",
            region="ams",
            static_sites=[digitalocean.AppSpecStaticSiteArgs(
                build_command="bundle exec jekyll build -d ./public",
                git=digitalocean.AppSpecStaticSiteGitArgs(
                    branch="main",
                    repo_clone_url="https://github.com/digitalocean/sample-jekyll.git",
                ),
                name="sample-jekyll",
                output_dir="/public",
            )],
        ))
        ```
        ### Multiple Components Example

        ```python
        import pulumi
        import pulumi_digitalocean as digitalocean

        mono_repo_example = digitalocean.App("mono-repo-example", spec=digitalocean.AppSpecArgs(
            databases=[digitalocean.AppSpecDatabaseArgs(
                engine="PG",
                name="starter-db",
                production=False,
            )],
            domains=[{
                "name": "foo.example.com",
            }],
            name="mono-repo-example",
            region="ams",
            services=[digitalocean.AppSpecServiceArgs(
                environment_slug="go",
                github=digitalocean.AppSpecServiceGithubArgs(
                    branch="main",
                    deploy_on_push=True,
                    repo="username/repo",
                ),
                http_port=3000,
                instance_count=2,
                instance_size_slug="professional-xs",
                name="api",
                routes=[digitalocean.AppSpecServiceRouteArgs(
                    path="/api",
                )],
                run_command="bin/api",
                source_dir="api/",
            )],
            static_sites=[digitalocean.AppSpecStaticSiteArgs(
                build_command="npm run build",
                github=digitalocean.AppSpecStaticSiteGithubArgs(
                    branch="main",
                    deploy_on_push=True,
                    repo="username/repo",
                ),
                name="web",
                routes=[digitalocean.AppSpecStaticSiteRouteArgs(
                    path="/",
                )],
            )],
        ))
        ```

        ## Import

        An app can be imported using its `id`, e.g.

        ```sh
         $ pulumi import digitalocean:index/app:App myapp fb06ad00-351f-45c8-b5eb-13523c438661
        ```

        :param str resource_name: The name of the resource.
        :param AppArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 spec: Optional[pulumi.Input[pulumi.InputType['AppSpecArgs']]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['spec'] = spec
            __props__['active_deployment_id'] = None
            __props__['created_at'] = None
            __props__['default_ingress'] = None
            __props__['live_url'] = None
            __props__['updated_at'] = None
        super(App, __self__).__init__(
            'digitalocean:index/app:App',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            active_deployment_id: Optional[pulumi.Input[str]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            default_ingress: Optional[pulumi.Input[str]] = None,
            live_url: Optional[pulumi.Input[str]] = None,
            spec: Optional[pulumi.Input[pulumi.InputType['AppSpecArgs']]] = None,
            updated_at: Optional[pulumi.Input[str]] = None) -> 'App':
        """
        Get an existing App resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] active_deployment_id: The ID the app's currently active deployment.
        :param pulumi.Input[str] created_at: The date and time of when the app was created.
        :param pulumi.Input[str] default_ingress: The default URL to access the app.
        :param pulumi.Input[str] live_url: The live URL of the app.
        :param pulumi.Input[pulumi.InputType['AppSpecArgs']] spec: A DigitalOcean App spec describing the app.
        :param pulumi.Input[str] updated_at: The date and time of when the app was last updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["active_deployment_id"] = active_deployment_id
        __props__["created_at"] = created_at
        __props__["default_ingress"] = default_ingress
        __props__["live_url"] = live_url
        __props__["spec"] = spec
        __props__["updated_at"] = updated_at
        return App(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="activeDeploymentId")
    def active_deployment_id(self) -> pulumi.Output[str]:
        """
        The ID the app's currently active deployment.
        """
        return pulumi.get(self, "active_deployment_id")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        The date and time of when the app was created.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter(name="defaultIngress")
    def default_ingress(self) -> pulumi.Output[str]:
        """
        The default URL to access the app.
        """
        return pulumi.get(self, "default_ingress")

    @property
    @pulumi.getter(name="liveUrl")
    def live_url(self) -> pulumi.Output[str]:
        """
        The live URL of the app.
        """
        return pulumi.get(self, "live_url")

    @property
    @pulumi.getter
    def spec(self) -> pulumi.Output[Optional['outputs.AppSpec']]:
        """
        A DigitalOcean App spec describing the app.
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[str]:
        """
        The date and time of when the app was last updated.
        """
        return pulumi.get(self, "updated_at")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

