# BNumMet
- Title: BNumMet
- Author: Fernando Bellido Pazos [fbellidopazos@gmail.com](fbellidopazos@gmail.com)
- Date: 2022
- Version: 1.0.0
- License: GNU Affero General Public License v3.0 (AGPL-3.0)
- Description: A Scholar implementation of Numerical Methods in Python enhanced with interactive widgets
- Tags: 
- URL: [Python_BNumMet](https://github.com/fbpazos/Trabajo-Fin-Master/tree/main/Python_BNumMet)

## Table of Contents
- [BNumMet](#bnummet)
  - [Table of Contents](#table-of-contents)
  - [Introduction](#introduction)
  - [Installation](#installation)
  - [Usage](#usage)
  - [Examples](#examples)
  - [Tests or development](#tests-or-development)
    - [Linux](#linux)
    - [Windows](#windows)
    - [Python Side](#python-side)
  - [BNumMet - Structure](#bnummet---structure)
  - [SonarQube](#sonarqube)


## Introduction
[Insert introduction here]

## Installation
In order to install the package, you can use the following command:

```bash
pip install BNumMet
```


## Usage
[Insert usage instructions here]


## Examples
[Insert code examples here]



## Tests or development
We recommend using a virtual environment to install the package. To do so, you can use the following commands:

### Linux 
-------
```bash
python3 -m venv venv # Create a virtual environment
source venv/bin/activate # Activate the virtual environment
```
### Windows
-------
```cmd
python -m venv venv # Create a virtual environment
venv\Scripts\activate # Activate the virtual environment
```
### Python Side
-------

After downloading the repository, you can install the package and run the tests using the following commands:


```bash
pip install -r requirements_dev.txt # Install development dependencies (test libraries)
pip install -e . # Installs the package in editable mode (so you can modify the code and test it)
pytest # Run tests
```
Or, alternatively, you can use the \_\_init\_\_.py file to run the tests.

```bash
pip install requirements_dev.txt # Install development dependencies (test libraries)
pip install -e . # Installs the package in editable mode
python tests/__init__.py # Run tests

# It will generate a coverage report in the Tests/coverage folder in different formats (html, xml, lcov). 
# It will also format the code using the Black Library (I Might've forgottent to do so :) )
```

## BNumMet - Structure
----
```bash
.
├── Demos # Contains the Jupyter Notebooks with the demos
│   ├── Interpolation.ipynb
│   ├── LinearSystems.ipynb
│   ├── NonLinear.ipynb
│   ├── Packages Show.ipynb
│   ├── Randomness.ipynb
│   └── Timings # Contains the Jupyter Notebooks with the timings results
│       ├── Interpolation Timings.py
│       ├── Interpolation_Timings_Analysis.ipynb
│       ├── LU_Timings_Analysis.ipynb
│       ├── Linear Systems Timings.py
│       ├── NonLinear Timings.py
│       ├── NonLinear_Iterations.ipynb
│       └── Results
├── LICENSE
├── MANIFEST.in
├── Readme.md
├── Utilities # Contains the utilities to run the tests and the SonarQube analysis
│   ├── ReportGenerator.jar
│   ├── SonarScanner.bat
│   ├── SonarScanner.sh
│   ├── ngrok.exe
│   └── sonarqubeRemote.bat
├── VERSION
├── pyproject.toml
├── requirements.txt
├── requirements_dev.txt
├── setup.cfg
├── setup.py
├── src
│   └── BNumMet # Contains the source code of the package
│       ├── Interpolation.py
│       ├── LinearSystems.py
│       ├── NonLinear.py
│       ├── Random.py
│       ├── Visualizers # Contains the visualizers of the package
│       │   ├── InterpolationVisualizer.py
│       │   ├── LUVisualizer.py
│       │   ├── LeastSquaresVisualizer.py
│       │   ├── NonLinearVisualizer.py
│       │   └── RandomVisualizer.py
│       ├── __init__.py
│       └── module.py
├── tests # Contains the tests of the package
│   ├── Reports # Contains the reports generated by the tests
│   │   └── testsReport.xml
│   ├── __init__.py
│   ├── test_General.py
│   ├── test_Interpolation.py
│   ├── test_LeastSquares.py
│   ├── test_LinealSystems.py
│   ├── test_NonLinear.py
│   ├── test_Random.py
│   └── test_module.py
└── tox.ini
```

----

## SonarQube
In order to run the SonarQube analysis, you can use the following command:

### Start the SonarQube server (Docker Version)

```bash
docker run -d --name sonarqube -p 9000:9000 sonarqube
```
Since its running locally, you can access the server at http://localhost:9000, and the default credentials are admin/admin. 
Additionally, for simplicity with login go to Administration -> Security -> Disable "Force User Authentication". (This is not recommended for production environments)


### Run the analysis

Remeber the credentials here are admin/1234 but you can change them in the sonarqube server.

Linux 
```bash
docker run --rm -ti -v "$(pwd)":/usr/src \
--link sonarqube newtmitch/sonar-scanner sonar-scanner \
-Dsonar.login="admin" \
-Dsonar.password="1234" \
-Dsonar.projectName="BNumMet" \
-Dsonar.projectKey="BNumMet" \
-Dsonar.sources="src/BNumMet/" \
-Dsonar.python.version=3 \
-Dsonar.python.xunit.reportPath="tests/Reports/testsReport.xml" \
-Dsonar.python.coverage.reportPaths="tests/Reports/Coverage/xml/coverage.xml" \
-Dsonar.scm.disabled=true \
-Dsonar.tests="tests" \
-Dsonar.test.inclusions="tests/**" \
-Dsonar.test.exclusions="tests/Reports/Coverage/**"

```

Windows - just replace "$(pwd)" with "%cd%" 

```cmd
docker run --rm -ti -v "%cd%":"/usr/src" \
--link sonarqube newtmitch/sonar-scanner sonar-scanner \
-Dsonar.login="admin" \
-Dsonar.password="1234" \
-Dsonar.projectName="BNumMet" \
-Dsonar.projectKey="BNumMet" \
-Dsonar.sources="src/BNumMet/" \
-Dsonar.python.version=3 \
-Dsonar.python.xunit.reportPath="tests/Reports/testsReport.xml" \
-Dsonar.python.coverage.reportPaths="tests/Reports/Coverage/xml/coverage.xml" \
-Dsonar.scm.disabled=true \
-Dsonar.tests="tests" \
-Dsonar.test.inclusions="tests/**" \
-Dsonar.test.exclusions="tests/Reports/Coverage/**"
```




 

