from typing import Any

from django.contrib.gis.db import models
from django.contrib.gis.db.backends.base.models import SpatialRefSysMixin

class OracleGeometryColumns(models.Model):
    table_name: Any
    column_name: Any
    srid: Any

    class Meta:
        app_label: str
        db_table: str
        managed: bool
    @classmethod
    def table_name_col(cls) -> Any: ...
    @classmethod
    def geom_col_name(cls) -> Any: ...

class OracleSpatialRefSys(models.Model, SpatialRefSysMixin):
    cs_name: Any
    srid: Any
    auth_srid: Any
    auth_name: Any
    wktext: Any
    cs_bounds: Any

    class Meta:
        app_label: str
        db_table: str
        managed: bool
    @property
    def wkt(self) -> Any: ...
