# Stubs for pyspark.conf (Python 3.5)
#

from typing import overload
from typing import Any, List, Optional, Tuple

from py4j.java_gateway import JVMView, JavaObject  # type: ignore[import]

class SparkConf:
    def __init__(
        self,
        loadDefaults: bool = ...,
        _jvm: Optional[JVMView] = ...,
        _jconf: Optional[JavaObject] = ...,
    ) -> None: ...
    def set(self, key: str, value: str) -> SparkConf: ...
    def setIfMissing(self, key: str, value: str) -> SparkConf: ...
    def setMaster(self, value: str) -> SparkConf: ...
    def setAppName(self, value: str) -> SparkConf: ...
    def setSparkHome(self, value: str) -> SparkConf: ...
    @overload
    def setExecutorEnv(self, key: str, value: str) -> SparkConf: ...
    @overload
    def setExecutorEnv(self, *, pairs: List[Tuple[str, str]]) -> SparkConf: ...
    def setAll(self, pairs: List[Tuple[str, str]]) -> SparkConf: ...
    def get(self, key: str, defaultValue: Optional[str] = ...) -> str: ...
    def getAll(self) -> List[Tuple[str, str]]: ...
    def contains(self, key: str) -> bool: ...
    def toDebugString(self) -> str: ...
