# Stubs for pyspark.ml.recommendation (Python 3)
#

from typing import Any, Optional

from pyspark.ml.util import *
from pyspark.ml.wrapper import JavaEstimator, JavaModel
from pyspark.ml.param.shared import *
from pyspark.sql.dataframe import DataFrame

class ALS(
    JavaEstimator[ALSModel],
    HasCheckpointInterval,
    HasMaxIter,
    HasPredictionCol,
    HasRegParam,
    HasSeed,
    JavaMLWritable,
    JavaMLReadable[ALS],
):
    rank: Param[int]
    numUserBlocks: Param[int]
    numItemBlocks: Param[int]
    implicitPrefs: Param[bool]
    alpha: Param[float]
    userCol: Param[str]
    itemCol: Param[str]
    ratingCol: Param[str]
    nonnegative: Param[bool]
    intermediateStorageLevel: Param[str]
    finalStorageLevel: Param[str]
    coldStartStrategy: Param[str]
    def __init__(
        self,
        *,
        rank: int = ...,
        maxIter: int = ...,
        regParam: float = ...,
        numUserBlocks: int = ...,
        numItemBlocks: int = ...,
        implicitPrefs: bool = ...,
        alpha: float = ...,
        userCol: str = ...,
        itemCol: str = ...,
        seed: Optional[int] = ...,
        ratingCol: str = ...,
        nonnegative: bool = ...,
        checkpointInterval: int = ...,
        intermediateStorageLevel: str = ...,
        finalStorageLevel: str = ...,
        coldStartStrategy: str = ...
    ) -> None: ...
    def setParams(
        self,
        *,
        rank: int = ...,
        maxIter: int = ...,
        regParam: float = ...,
        numUserBlocks: int = ...,
        numItemBlocks: int = ...,
        implicitPrefs: bool = ...,
        alpha: float = ...,
        userCol: str = ...,
        itemCol: str = ...,
        seed: Optional[int] = ...,
        ratingCol: str = ...,
        nonnegative: bool = ...,
        checkpointInterval: int = ...,
        intermediateStorageLevel: str = ...,
        finalStorageLevel: str = ...,
        coldStartStrategy: str = ...
    ) -> ALS: ...
    def setRank(self, value: int) -> ALS: ...
    def getRank(self) -> int: ...
    def setNumUserBlocks(self, value: int) -> ALS: ...
    def getNumUserBlocks(self) -> int: ...
    def setNumItemBlocks(self, value: int) -> ALS: ...
    def getNumItemBlocks(self) -> int: ...
    def setNumBlocks(self, value: int) -> ALS: ...
    def setImplicitPrefs(self, value: bool) -> ALS: ...
    def getImplicitPrefs(self) -> bool: ...
    def setAlpha(self, value: float) -> ALS: ...
    def getAlpha(self) -> float: ...
    def setUserCol(self, value: str) -> ALS: ...
    def getUserCol(self) -> str: ...
    def setItemCol(self, value: str) -> ALS: ...
    def getItemCol(self) -> str: ...
    def setRatingCol(self, value: str) -> ALS: ...
    def getRatingCol(self) -> str: ...
    def setNonnegative(self, value: bool) -> ALS: ...
    def getNonnegative(self) -> bool: ...
    def setIntermediateStorageLevel(self, value: str) -> ALS: ...
    def getIntermediateStorageLevel(self) -> str: ...
    def setFinalStorageLevel(self, value: str) -> ALS: ...
    def getFinalStorageLevel(self) -> str: ...
    def setColdStartStrategy(self, value: str) -> ALS: ...
    def getColdStartStrategy(self) -> str: ...

class ALSModel(JavaModel, JavaMLWritable, JavaMLReadable[ALSModel]):
    @property
    def rank(self) -> int: ...
    @property
    def userFactors(self) -> DataFrame: ...
    @property
    def itemFactors(self) -> DataFrame: ...
    def recommendForAllUsers(self, numItems: int) -> DataFrame: ...
    def recommendForAllItems(self, numUsers: int) -> DataFrame: ...
    def recommendForUserSubset(
        self, dataset: DataFrame, numItems: int
    ) -> DataFrame: ...
    def recommendForItemSubset(
        self, dataset: DataFrame, numUsers: int
    ) -> DataFrame: ...
