# 项目描述

异步的 MongoDB ORM 。

# 作者信息

昵称：lcctoor.com

[主页](https://lcctoor.github.io/arts/) \| [微信](https://lcctoor.github.io/arts/arts/static/static-files/WeChatQRC.jpg) \| [Github](https://github.com/lcctoor) \| [PyPi](https://pypi.org/user/lcctoor) \| [Python交流群](https://lcctoor.github.io/arts/arts/static/static-files/PythonWeChatGroupQRC.jpg) \| [邮箱](mailto:lcctoor@outlook.com) \| [域名](http://lcctoor.com) \| [捐赠](https://lcctoor.github.io/arts/arts/static/static-files/DonationQRC-0rmb.jpg)

# Bug提交、功能提议

您可以通过 [Github-Issues](https://github.com/lcctoor/arts/issues)、[微信](https://lcctoor.github.io/arts/arts/static/static-files/WeChatQRC.jpg) 与我联系。

# 安装

```
pip install asymongo
```

# 教程 ([查看美化版](https://lcctoor.github.io/arts/?pk=asymongo)👈)

本文将以最简洁的方式向你介绍核心知识，而不会让你被繁琐的术语所淹没。

## 导入

```python
from motor.motor_asyncio import AsyncIOMotorClient as MongoClient
import asymongo as mg
from asymongo import mc, mup
```

## 创建ORM

```python
mkconn = lambda: MongoClient(host='localhost', port=27017)

orm = mg.ORM(mkconn)  # 账户ORM
db = orm['泉州市']  # 库ORM
sheet = db['希望小学']  # 表ORM
```

## 新增数据

```python
line1 = {'姓名': '小一', '年龄':11, '幸运数字':[1, 2, 3], '成绩':{'语文':81, '数学':82}}
line2 = {'姓名': '小二', '年龄':12, '幸运数字':[2, 3, 4], '成绩':{'语文':82, '数学':83}}
line3 = {'姓名': '小三', '年龄':13, '幸运数字':[3, 4, 5], '成绩':{'语文':83, '数学':84}}
line4 = {'姓名': '小四', '年龄':14, '幸运数字':[4, 5, 6], '成绩':{'语文':84, '数学':85}}
line5 = {'姓名': '小五', '年龄':15, '幸运数字':[5, 6, 7], '成绩':{'语文':85, '数学':86}}
line6 = {'姓名': '小六', '年龄':16, '幸运数字':[6, 7, 8], '成绩':{'语文':86, '数学':87}}

r1 = await sheet.insert(line1)  # 添加1条数据
r2 = await sheet.insert([ line2, line3, line4, line5, line6 ])  # 批量添加
```

查看分配到的主键：

方法1：添加数据成功后，line1~line6 已各自多了一个叫‘_id’的键，该键的值即分配到的主键。

方法2：

```python
r1.inserted_id
r2.inserted_ids
```

## 查询示例

```python
await sheet[:]  # 查询所有数据

await sheet[3]  # 查询第3条数据

await sheet[mc.成绩.语文 == 85][:]  # 查询语文成绩为85分的数据

await sheet[mc.年龄>13][mc.姓名=='小五'][1]  # 查询年龄大于13、且姓名叫'小五'的第1条数据
```

注：后文有关于查询的详细教程。

## 修改示例

```python
data = {
    '视力': 5.0,
    '性别': '男',
    '爱好': ['足球','篮球','画画','跳绳'],
    '幸运数字': mup.push(15,16,17),  # 添加到列表
    '年龄': mup.inc(2)  # 自增
}

await sheet.update(data)[2:5]
```

注：后文有关于修改的详细教程。

## 删除

```python
# 删除年龄>=15的数据
r1 = await sheet[mc.年龄>=15].delete()[:]

# 删除年龄大于10、且姓名包含'小'的第2条数据
r2 = await sheet[mc.年龄>10][mc.姓名 == mg.re('小')].delete()[2]

# 删除所有数据
r3 = await sheet.delete()[:]

# 查看删除详情
r1.raw_result
r2.raw_result
r3.raw_result
```

## 切片

1、切片格式为  [start: stop: step]  ，start 表示从哪条开始，stop 表示到哪条停止，step 表示步长。

2、start 和 stop

* 当为正值时，表示正序第 x 条，例如：1 表示第 1 条、2 表示第 2 条。
* 当为负值时，表示倒数第 x 条，例如：-1 表示倒数第 1 条、-2 表示倒数第 2 条。
* 不可为 0 。

3、step

* 须为正整数。
* 当 step >= 2  时表示间隔式切片。
* 当 step = 1 时可省略 `: step` ，即：[start: stop] 等价于 [start: stop: 1] 。

4、与 Python 切片风格对比

此 ORM 的切片风格比 Python 切片风格更人性化。具体区别为：

|                                        | **Python**                                                | **asymongo**                                              |
| -------------------------------------- | --------------------------------------------------------------- | --------------------------------------------------------------- |
| **索引**                         | 从 0 开始，例如：<br />[0] 表示第 1 个元素、[1] 表示第 2 个元素 | 从 1 开始，例如：<br />[1] 表示第 1 个元素、[2] 表示第 2 个元素 |
| **切片**                         | 左闭右开区间，例如：<br />[3: 5] 表示第 4~5 这 2 个元素         | 双闭区间，例如：<br />[3: 5] 表示第 3~5 这 3 个元素             |
| **从右往**<br />**左切片** | step 为负值，例如：<br />[9: 1: -1] 表示第 9~3 这 7 个元素     | step 为正值，例如：<br />[9: 1: 1] 表示第 9~1 这 9 个元素       |

### 示例

```python
await sheet[过滤器]...[过滤器][:]  # 查询符合条件的全部数据
await sheet[过滤器]...[过滤器][:] = None  # 删除符合条件的全部数据
await sheet[过滤器]...[过滤器][:] = {'年级':'初一'}  # 修改符合条件的全部数据

await sheet[过滤器]...[过滤器][1]  # 查询符合条件的第1条
await sheet[过滤器]...[过滤器][1] = None  # 删除符合条件的第1条
await sheet[过滤器]...[过滤器][1] = {'年级':'初一'}  # 修改符合条件的第1条

await sheet[过滤器]...[过滤器][3:7]  # 查询符合条件的第3~7条
await sheet[过滤器]...[过滤器][3:7] = None  # 删除符合条件的第3~7条
await sheet[过滤器]...[过滤器][3:7] = {'年级':'初一'}  # 修改符合条件的第3~7条

await sheet[过滤器]...[过滤器][3:7:2]  # 查询符合条件的第3、5、7条
await sheet[过滤器]...[过滤器][3:7:2] = None  # 删除符合条件的第3、5、7条
await sheet[过滤器]...[过滤器][3:7:2] = {'年级':'初一'}  # 修改符合条件的第3、5、7条
```

值得注意的地方：  [3: 8: 2]  操作第  3、5、7  条，而  [8: 3: 2]  操作第  8、6、4  条。

更多示例：

```python
[:]           # 所有数据
[1:-1]        # 所有数据
[-1:1]        # 所有数据（逆序）
[1:]          # 所有数据
[:1000]       # 第1条 ~ 第1000条
[:-1000]      # 第1条 ~ 倒数第1000条
[100:200]     # 第100条 ~ 第200条
[200:100]     # 第200条 ~ 第100条
[-300:-2]     # 倒数第300条 ~ 倒数第2条
[50:-2]       # 第50条 ~ 倒数第2条
[250:]        # 第250条 ~ 最后1条
[-250:]       # 倒数第250条 ~ 最后1条
[1]           # 第1条
[-1]          # 最后1条
[::3]         # 以3为间距, 间隔操作所有数据
[100:200:4]   # 以4为间距, 间隔操作第100条 ~ 第200条
```

## 过滤器

过滤器的结构为 `mc.<字段名称><运算符><值>` ，例如 `mc.年龄 > 18` 。

### 比较运算

| **代码** |
| -------------- |
| mc.年龄 > 10   |
| mc.年龄 >= 10  |
| mc.年龄 < 10   |
| mc.年龄 <= 10  |
| mc.年龄 == 10  |
| mc.年龄 != 10  |

### 成员运算

| **代码**                           | **解释**                          |
| ---------------------------------------- | --------------------------------------- |
| mc.年级 == mg.isin('初三', '高二')       | 若字段值是传入值的成员，则符合          |
| mc.年龄 == mg.notin(10, 30, 45)          | 若字段值不是传入值的成员，则符合        |
| mc.爱好 == mg.containAll('画画', '足球') | 若字段值包含传入值的所有元素，则符合    |
| mc.爱好 == mg.containAny('画画', '足球') | 若字段值包含传入值的至少1个元素，则符合 |
| mc.爱好 == mg.containNo('画画', '足球')  | 若字段值不包含传入值的任何元素，则符合  |

注：

1、isin、notin与containAll、containAny、containNo的区别：前者判断字段值是否传入值的成员，后者判断传入值是否字段值的成员。

2、isin、notin、containAll、containAny、containNo 的传入值都不必是同类型的数据，以isin为例：可以这样使用：  mc.tag == mg.isin(3, 3.5, '学生', None)  ，传入值含有int型、float型、str型、None。

3、成员运算符未传入任何值时的处理方式：

| **代码**              | **处理方式** |
| --------------------------- | ------------------ |
| mc.年级 == mg.isin( )       | 所有数据都 不符合  |
| mc.年级 == mg.notin( )      | 所有数据都 符合    |
| mc.爱好 == mg.containAll( ) | 所有数据都 符合    |
| mc.爱好 == mg.containAny( ) | 所有数据都 不符合  |
| mc.爱好 == mg.containNo( )  | 所有数据都 符合    |

### 正则运算

| **代码**         |
| ---------------------- |
| mc.姓名 == mg.re('小') |

### 过滤器的集合运算

| **代码**                                                       | **解释** |
| -------------------------------------------------------------------- | -------------- |
| [ mc.年龄>3 ][ mc.年龄<100 ]                                         | 交集           |
| [ (mc.年龄<30)\| (mc.年龄>30) \| (mc.年龄==30) \| (mc.年龄==None) ] | 并集           |
| [ (mc.年龄>3) - (mc.年龄>100) ]                                      | 差集           |
| [ ~(mc.年龄>100) ]                                                   | 补集           |

注：四种集合运算可以相互嵌套，且可以无限嵌套。

### 根据子元素过滤

可使用  mc.xxx.xxx.xxx  的形式来表示子孙元素。

查询语文成绩>80的数据：

```python
await sheet[mc.成绩.语文 > 80][:]
```

### 特殊字段名的表示方法

MongoDB支持各种特殊的字段名，如：数字、符号、emoji表情，这些字符在Python中不是合法变量名，使用  mc.1、mc.+  等格式会报错，可用  mc['1']、mc['+']  这种格式代替。

### 字段提示

变量 mc 无字段提示功能，输入‘mc.’后，编辑器不会提示可选字段。后文有关于如何设置字段提示的内容。

## 查询

### 限定返回字段

只返回姓名、年龄这2个字段：

```python
await sheet[mc.年级=='高一']['姓名','年龄'][:]
```

注：

1、字段限定器可放在sheet与[:]之间的任意位置。以下3行代码的返回结果相同：

```python
await sheet[mc.年龄>11][mc.年龄<30]['姓名', '年龄'][:]
await sheet[mc.年龄>11]['姓名', '年龄'][mc.年龄<30][:]
await sheet['姓名', '年龄'][mc.年龄>11][mc.年龄<30][:]
```

2、可反复限定字段，查询时是根据最后1次指定的字段提取数据。以下代码返回结果中只有‘年龄’字段：

```python
await sheet[mc.年级=='高一']['姓名']['年龄'][:]
```

3、若想恢复提取全部字段，则限定字段为mg.allColumns，mg.allColumns即代表“全部字段”。

```python
await sheet[mc.年级=='高一']['姓名'][mg.allColumns][:]
```

（为什么有时候要先限定字段，然后再取消限定，而不是一开始就不限定字段？这是因为在某些场景中这样做可以使代码整体上更优雅。参见后文 [ 如何写出优雅的代码 ](#如何写出优雅的代码) ）

### 1个复杂的查询示例

```python
_ = sheet
_ = _[mc.年龄>=12]  # 比较
_ = _[mc.姓名 == mg.isin('小三','小四')]  # 被包含
_ = _[mc.姓名 == mg.notin('十三','十四')]  # 不被包含
_ = _[(mc.年龄==15) | (mc.年龄>15) | (mc.年龄<15)]  # 并集
_ = _[mc.年龄>=3][mc.年龄<100]  # 交集
_ = _[(mc.年龄>=3) - (mc.年龄>100)]  # 差集
_ = _[~ (mc.年龄>100)]  # 补集
_ = _[mc.姓名 == mg.re('小')]  # 正则表达式
_ = _[mc.幸运数字 == mg.containAll(4, 5, 6)]  # 包含所有值
_ = _[mc.幸运数字 == mg.containAny(4, 5, 6)]  # 包含至少1个值
_ = _[mc.幸运数字 == mg.containNo(1, 2, 3)]  # 1个都不包含
await _[:]  # 切片
```

注：无论过滤器多复杂，ORM都不会访问数据库，只有在最后切片时，ORM才会访问数据库。

## 排序

对所有年龄>12的数据，优先按年龄降序，其次按姓名升序，排序后返回第2\~4条数据：

```python
await sheet[mc.年级=='高一'].order(年龄=False, 姓名=True)[2:4]
```

有趣的，以下两行代码的返回结果相同：

```python
await sheet[mc.年级=='高一'].order(年龄=True)[1:-1]

await sheet[mc.年级=='高一'].order(年龄=False)[-1:1]
```

解释：order(年龄=False)表示按年龄降序，[-1:1]表示逆序切片，产生了类似‘负负得正’的效果。

注：

1、排序器可放在sheet与[:]之间的任意位置。以下3行代码的返回结果相同：

```python
await sheet[mc.年级=='高一'][mc.视力>4.8].order(年龄=False)[2:4]
await sheet[mc.年级=='高一'].order(年龄=False)[mc.视力>4.8][2:4]
await sheet.order(年龄=False)[mc.年级=='高一'][mc.视力>4.8][2:4]
```

2、可反复排序，查询\|修改\|删除 时是根据最后1次指定的顺序提取数据。以下代码最终是按年龄降序后提取数据：

```python
await sheet.order(年龄=True, 姓名=False).order(年龄=False)[:]
```

3、若想取消排序，则再次调用order方法，但不传入任何值。

```python
await sheet.order(年龄=True, 姓名=False).order()[:]
```

（为什么有时候要先排序，然后再取消排序，而不是一开始就不排序？这是因为在某些场景中这样做可以使代码整体上更优雅。参见后文 [ 如何写出优雅的代码 ](#如何写出优雅的代码) ）

## 修改

### 修改

```python
r = await sheet.update({'性别':'女'})[2:5]

r.raw_result  # 查看修改详情
```

### 特殊操作

执行以下代码后，年龄>10的数据中，第6、2条的年龄字段会增加1.5：

```python
data = {'年龄':mup.inc(1.5)}

await sheet[mc.年龄>10].update(data)[6:1:4]
```

特殊操作清单：

| **语法**       | **含义**                                     |
| -------------------- | -------------------------------------------------- |
| mup.inc(1)           | 自增1                                              |
| mup.inc(-1)          | 自减1                                              |
| mup.add(1, 2, 3)     | 向列表字段添加元素，仅当被添加的元素不存在时才添加 |
| mup.push(1, 2, 3)    | 向列表字段添加元素，无论被添加的元素是否存在都添加 |
| mup.pull(15)         | 从列表字段删除1个等于15的值                        |
| mup.popfirst         | 从列表字段删除第1个元素                            |
| mup.poplast          | 从列表字段删除最后1个元素                          |
| mup.rename('新名称') | 重命名字段                                         |
| mup.unset            | 删除字段                                           |
| mup.delete           | 删除字段（与mup.unset等价）                        |

对所有姓名为‘小六’的数据，姓名改为‘xiaoliu’，年龄自增6，幸运数字添加666，视力字段名改为‘眼力’，删除籍贯字段，语文成绩改为60分，数学成绩减10分：

```python
data = {
    '姓名': 'xiaoliu',
    '年龄': mup.inc(6),
    '幸运数字': mup.push(666),
    '视力': mup.rename('眼力'),
    '籍贯': mup.delete,
    '成绩.语文': 60,
    '成绩.数学': mup.inc(-10)
}

await sheet[mc.姓名=='小六'].update(data)[:]
```

## 统计

| **项目**            | **语法**                 |
| ------------------------- | ------------------------------ |
| 某张表的数据总量          | await sheet.len( )             |
| 某张表中，年龄>10的数据量 | await sheet[mc.年龄>10].len( ) |
| 库的数量                  | await orm.len( )               |
| 某个库中，表的数量        | await db.len( )                |

## 字段提示

变量 mc 无字段提示功能，输入‘mc.’后，编辑器不会提示可选字段。

为了获得字段提示功能，可自建一个‘mc2’：

```python
class mc2(mc):
    姓名 = 年龄 = 幸运数字 = None
    class 成绩:
        语文 = 数学 = None

await sheet[mc2.年龄 > 10][:]
await sheet[mc2.成绩.语文 > 80][:]
```

注：

1、mc2 与 mc 用法完全一致，可混用。

2、mc2 与 mc 设置字段提示后，仅具备提示效果，而不产生任何实际约束。

## 表ORM的独立性

### 表ORM的独立性

先看一条查询示例：

```python
await sheet[mc.年龄 > 5]['姓名','年龄'][mc.姓名 == mg.re('小')].order(_id=False)[:]
```

以上示例代码可改为如下（两者效果相同）：

```python
d1 = sheet
d2 = d1[mc.年龄 > 5]
d3 = d2['姓名','年龄']
d4 = d3[mc.姓名 == mg.re('小')]
d5 = d4.order(_id=False)
await d5[:]
```

以上代码中，d1\~d5是5个不同的表ORM，它们具有独立的数据空间（存放着过滤条件、字段限定、排序等信息），且互不干扰。d2\~d5每个都拷贝了前一个ORM的表空间，并增加了自身的新信息。

### 如何写出优雅的代码

利用表ORM的独立性，可以在一些复杂的场景中写出优雅简洁的代码。

不优雅的示范：

```python
def GetName():
    return requests.get('https://...').text

def output(datas):
    ...

while True:
    datas = await sheet[过滤器1][过滤器2]...[过滤器9][mc.name == GetName()][:]
    output(datas)
```

优雅的示范：

```python
def GetName():
    return requests.get('https://...').text

def output(datas):
    ...

baseSheet = sheet[过滤器1][过滤器2]...[过滤器9]
while True:
    datas = await baseSheet[mc.name == GetName()][:]
    output(datas)
```
