"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const application_1 = require("@jupyterlab/application");
const apputils_1 = require("@jupyterlab/apputils");
const mainmenu_1 = require("@jupyterlab/mainmenu");
const settingregistry_1 = require("@jupyterlab/settingregistry");
const gator_common_1 = require("@mamba-org/gator-common");
const jupyterlab_toastify_1 = require("jupyterlab_toastify");
const tour_1 = require("./tour");
const validator_1 = require("./validator");
const CONDAENVID = '@mamba-org/gator-lab:plugin';
const TOUR_DELAY = 1000;
const TOUR_TIMEOUT = 5 * TOUR_DELAY + 1;
function activateCondaEnv(app, settingsRegistry, palette, menu, restorer) {
    var _a;
    return __awaiter(this, void 0, void 0, function* () {
        let tour;
        const { commands, shell } = app;
        const pluginNamespace = 'conda-env';
        const command = 'jupyter_conda:open-ui';
        const settings = yield ((_a = settingsRegistry) === null || _a === void 0 ? void 0 : _a.load(CONDAENVID));
        const model = new gator_common_1.CondaEnvironments(settings);
        // Request listing available package as quickly as possible
        Private.loadPackages(model);
        // Track and restore the widget state
        const tracker = new apputils_1.WidgetTracker({
            namespace: pluginNamespace
        });
        let content;
        commands.addCommand(command, {
            label: 'Conda Packages Manager',
            execute: () => {
                app.restored.then(() => {
                    let timeout = 0;
                    const delayTour = () => {
                        setTimeout(() => {
                            timeout += TOUR_DELAY;
                            if (content.isVisible && tour) {
                                commands.execute('jupyterlab-tour:launch', {
                                    id: tour.id,
                                    force: false
                                });
                            }
                            else if (timeout < TOUR_TIMEOUT) {
                                delayTour();
                            }
                        }, 1000);
                    };
                    if (commands.hasCommand('jupyterlab-tour:add')) {
                        if (!tour) {
                            commands
                                .execute('jupyterlab-tour:add', {
                                tour: tour_1.managerTour
                            })
                                .then(result => {
                                tour = result;
                            });
                        }
                        delayTour();
                    }
                });
                if (tracker.currentWidget) {
                    shell.activateById(tracker.currentWidget.id);
                    return;
                }
                content = new gator_common_1.CondaEnvWidget(model);
                content.addClass(gator_common_1.CONDA_WIDGET_CLASS);
                content.id = pluginNamespace;
                content.title.label = 'Packages';
                content.title.caption = 'Conda Packages Manager';
                content.title.icon = gator_common_1.condaIcon;
                const widget = new apputils_1.MainAreaWidget({ content });
                void tracker.add(widget);
                shell.add(widget, 'main');
            }
        });
        // Add command to command palette
        if (palette) {
            palette.addItem({ command, category: 'Settings' });
        }
        // Handle state restoration.
        if (restorer) {
            restorer.restore(tracker, {
                command,
                name: () => pluginNamespace
            });
        }
        // Add command to settings menu
        if (menu) {
            menu.settingsMenu.addGroup([{ command: command }], 999);
        }
        return model;
    });
}
function activateCompanions(app, envManager, settingsRegistry, palette) {
    return __awaiter(this, void 0, void 0, function* () {
        const { commands, serviceManager } = app;
        const command = 'jupyter_conda:companions';
        const settings = yield settingsRegistry.load(CONDAENVID);
        const validator = new validator_1.CompanionValidator(serviceManager.kernelspecs, envManager, settings);
        commands.addCommand(command, {
            label: 'Validate kernels compatibility',
            execute: () => {
                validator.validate(serviceManager.kernelspecs.specs);
            }
        });
        // Add command to command palette
        if (palette) {
            palette.addItem({ command, category: 'Troubleshooting' });
        }
        return validator;
    });
}
/**
 * Initialization data for the @mamba-org/gator-lab extension.
 */
const condaManager = {
    id: CONDAENVID,
    autoStart: true,
    activate: activateCondaEnv,
    optional: [settingregistry_1.ISettingRegistry, apputils_1.ICommandPalette, mainmenu_1.IMainMenu, application_1.ILayoutRestorer],
    provides: gator_common_1.IEnvironmentManager
};
/**
 * Initialization data for the jupyterlab_kernel_companions extension.
 */
const companions = {
    id: validator_1.companionID,
    autoStart: true,
    activate: activateCompanions,
    requires: [gator_common_1.IEnvironmentManager, settingregistry_1.ISettingRegistry],
    optional: [apputils_1.ICommandPalette],
    provides: validator_1.ICompanionValidator
};
const extensions = [condaManager, companions];
exports.default = extensions;
/* eslint-disable no-inner-declarations */
var Private;
(function (Private) {
    function loadPackages(model) {
        let packageFound = false;
        let toastId;
        const messages = [
            'I know you want to give up, but wait a bit longer...',
            'Why is conda so popular, still loading that gigantic packages list...',
            'Take a break, available packages list are still loading...',
            'Available packages list still loading...'
        ];
        function displayMessage(message) {
            setTimeout(() => {
                if (!packageFound) {
                    jupyterlab_toastify_1.INotification.update({
                        message,
                        toastId
                    });
                    if (messages.length > 0) {
                        displayMessage(messages.pop());
                    }
                }
            }, 60000);
        }
        model
            .getPackageManager()
            .refreshAvailablePackages(false)
            .then(() => {
            packageFound = true;
            if (toastId) {
                jupyterlab_toastify_1.INotification.dismiss(toastId);
            }
        })
            .catch((reason) => {
            console.debug('Fail to cache available packages list.', reason);
            if (toastId) {
                jupyterlab_toastify_1.INotification.dismiss(toastId);
            }
        });
        // Tell the user after a minute than the extension if still trying to get
        // the available packages list
        setTimeout(() => {
            if (!packageFound) {
                jupyterlab_toastify_1.INotification.inProgress('Loading the available packages list in background...').then(id => {
                    toastId = id;
                });
                displayMessage(messages.pop());
            }
        }, 60000);
    }
    Private.loadPackages = loadPackages;
})(Private || (Private = {}));
/* eslint-enable no-inner-declarations */
//# sourceMappingURL=index.js.map