"use strict";
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (Object.hasOwnProperty.call(mod, k)) result[k] = mod[k];
    result["default"] = mod;
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const gator_common_1 = require("@mamba-org/gator-common");
const React = __importStar(require("react"));
exports.managerTour = {
    id: 'jupyterlab-conda:tour',
    label: 'Conda Packages Manager Tour',
    hasHelpEntry: true,
    steps: [
        {
            content: (React.createElement("p", null,
                "Thanks for installing ",
                React.createElement("em", null, "Gator"),
                ".",
                React.createElement("br", null),
                "Let's have a tour of the UI.")),
            placement: 'center',
            target: `.${gator_common_1.CONDA_WIDGET_CLASS}`,
            title: 'Conda Packages Manager'
        },
        {
            content: (React.createElement("p", null,
                "Your conda environment are listed here.",
                React.createElement("br", null),
                "Click on it to manage its packages.")),
            placement: 'right',
            target: `#${gator_common_1.CONDA_ENVIRONMENT_PANEL_ID}`
        },
        {
            content: (React.createElement("p", null, "This toolbar contains environment actions like creation, deletion, exportation,...")),
            placement: 'bottom',
            target: `.${gator_common_1.CONDA_ENVIRONMENT_TOOLBAR_CLASS}`
        },
        {
            content: (React.createElement("p", null, "This table lists all available conda packages and their status within the selected environment (i.e. installed, updatable or available).")),
            target: `#${gator_common_1.CONDA_PACKAGES_PANEL_ID}`
        },
        {
            content: (React.createElement("p", null, "A package can be installed, removed or updated by selecting a status in these selectors.")),
            placement: 'bottom',
            target: `.${gator_common_1.CONDA_PACKAGE_SELECT_CLASS}`
        },
        {
            content: (React.createElement("p", null, "The package list can be filtered by packages status and with a search term.")),
            placement: 'bottom-start',
            target: `.${gator_common_1.CONDA_PACKAGES_TOOLBAR_CLASS}`
        },
        {
            content: React.createElement("p", null, "Execute package changes with the cart button."),
            placement: 'bottom',
            target: `.${gator_common_1.CONDA_PACKAGES_TOOLBAR_CLASS} .fa-cart-arrow-down`
        }
    ]
};
//# sourceMappingURL=tour.js.map