import { KernelSpecAPI, KernelSpecManager } from '@jupyterlab/services';
import { ISettingRegistry } from '@jupyterlab/settingregistry';
import { Token } from '@lumino/coreutils';
import { IDisposable } from '@lumino/disposable';
import { IEnvironmentManager } from '@mamba-org/gator-common';
export declare const companionID = "@mamba-org/gator-lab:companion";
export declare const ICompanionValidator: Token<ICompanionValidator>;
/**
 * Validates that conda packages installed in kernels respect
 * kernel companions version specification.
 *
 * The use case is a JupyterLab version served with pre-installed
 * extensions and not manage possible by the end user. In that case
 * especially for libraries with widgets, the conda package version
 * must be coherent with the labextension pre-installed. Otherwise
 * the model in the kernel will not match the one in the frontend.
 */
export interface ICompanionValidator extends IDisposable {
    /**
     * Validate the kernelSpec models
     *
     * @param specs Available kernelSpec models
     */
    validate(specs: KernelSpecAPI.ISpecModels): void;
}
/**
 * Validates that conda packages installed in kernels respect
 * kernel companions version specification.
 *
 * The use case is a JupyterLab version served with pre-installed
 * extensions and not manage possible by the end user. In that case
 * especially for libraries with widgets, the conda package version
 * must be coherent with the labextension pre-installed. Otherwise
 * the model in the kernel will not match the one in the frontend.
 *
 */
export declare class CompanionValidator implements ICompanionValidator {
    constructor(kernelManager: KernelSpecManager, envManager: IEnvironmentManager, settings: ISettingRegistry.ISettings);
    /**
     * Test whether the validator is disposed.
     */
    get isDisposed(): boolean;
    /**
     * Dispose of the resources used by the validator.
     */
    dispose(): void;
    /**
     * Load the user settings
     *
     * @param settings Plugin user settings
     */
    private _updateCompanions;
    /**
     * Convert a kernel name in conda environment name.
     * This follows nb_conda_kernels naming convention.
     *
     * @param name Conda normalized environment name
     * @returns null if this is not a valid conda environment otherwise the name
     */
    static kernelNameToEnvironment(name: string): string | null;
    /**
     * Convert semver specification in conda package specification
     *
     * @param range semver version string
     */
    private static _semverToPython;
    /**
     * Check the available kernels
     *
     * @param manager A service manager
     * @param specs Available kernelSpec models
     */
    private _validateSpecs;
    /**
     * Validate the kernelSpec models
     *
     * @param kernelSpecs Available kernelSpec models
     */
    validate(kernelSpecs: KernelSpecAPI.ISpecModels): void;
    private _isDisposed;
    private _envManager;
    private _companions;
    private _clean;
}
//# sourceMappingURL=validator.d.ts.map