"""
Copyright (c) 2023, Florian GARDIN
All rights reserved.

This source code is licensed under the BSD-style license found in the
LICENSE file in the root directory of this source tree.
"""

INSTRUMENTS_DICT = {
    "piano": 0,
    "pizzicato": 45,
    "bright_piano": 1,
    "electric_piano": 2,
    "honky_tonk": 3,
    "electric_piano_1": 4,
    "electric_piano_2": 5,
    "harpsichord": 6,
    "clavi": 7,
    "celesta": 8,
    "glockenspiel": 9,
    "music_box": 10,
    "vibraphone": 11,
    "marimba": 12,
    "xylophone": 13,
    "tubular_bells": 14,
    "dulcimer": 15,
    "drawbar_organ": 16,
    "percussive_organ": 17,
    "rock_organ": 18,
    "church_organ": 19,
    "reed_organ": 20,
    "accordion": 21,
    "harmonica": 22,
    "tango_accordion": 23,
    "acoustic_guitar": 24,
    "steel_guitar": 25,
    "jazz_guitar": 26,
    "clean_guitar": 27,
    "overdriven_guitar": 29,
    "distortion_guitar": 30,
    "harmonic_guitar": 31,
    "acoustic_bass": 32,
    "electric_bass_finger": 33,
    "electric_bass_pick": 34,
    "fretless_bass": 35,
    "slap_bass_1": 36,
    "slap_bass_2": 37,
    "synth_bass_1": 38,
    "synth_bass_2": 39,
    "violin": 40,
    "viola": 41,
    "cello": 42,
    "contrabass": 43,
    "tremolo_string": 44,
    "harp": 46,
    "timpani": 47,
    "string_ensemble_1": 48,
    "string_ensemble_2": 49,
    "synth_string_1": 50,
    "synth_string_2": 51,
    "choir_aahs": 52,
    "choir_oohs": 53,
    "synth_choir": 54,
    "orchestra_hit": 55,
    "trumpet": 56,
    "trombone": 57,
    "tuba": 58,
    "muted_trumpet": 59,
    "french_horn": 60,
    "brass_section": 61,
    "synth_brass_1": 62,
    "synth_brass_2": 63,
    "soprano_sax": 64,
    "alto_sax": 65,
    "tenor_sax": 66,
    "baritone_sax": 67,
    "oboe": 68,
    "english_horn": 69,
    "bassoon": 70,
    "clarinet": 71,
    "piccolo": 72,
    "flute": 73,
    "recorder": 74,
    "pan_flute": 75,
    "blown_bottle": 76,
    "shakuhachi": 77,
    "whistle": 78,
    "ocarina": 79,
    "square_lead": 80,
    "sawtooth_lead": 81,
    "calliope_lead": 82,
    "chiff_lead": 83,
    "charang_lead": 84,
    "voice_lead": 85,
    "fifths_lead": 86,
    "bass_lead": 87,
    "pad_new_age": 88,
    "pad_warm": 89,
    "pad_polysynth": 90,
    "pad_choir": 91,
    "pad_bowed": 92,
    "pad_metallic": 93,
    "pad_halo": 94,
    "pad_sweep": 95,
    "fx_rain": 96,
    "fx_soundtrack": 97,
    "fx_crystal": 98,
    "fx_atmosphere": 99,
    "fx_brightness": 100,
    "fx_globlins": 101,
    "fx_echoes": 102,
    "fx_sci_fi": 103,
    "sitar": 104,
    "banjo": 105,
    "shamisen": 106,
    "koto": 107,
    "kalimba": 108,
    "bagpipe": 109,
    "fiddle": 110,
    "shanai": 111,
    "tinkle_bell": 112,
    "agogo": 113,
    "steel_drums": 114,
    "woodblock": 115,
    "taiko_drum": 116,
    "melodic_tom": 117,
    "synth_drum": 118,
    "reverse_cymbal": 119,
    "guitar_fret_noise": 120,
    "breath_noise": 121,
    "seashore": 122,
    "bird_tweet": 123,
    "telephone_ring": 124,
    "helicopter": 125,
    "applause": 126,
    "gunshot": 127
}

REVERSE_INSTRUMENT_DICT = {
    val: key for key, val in INSTRUMENTS_DICT.items()
}

OCTAVES = {
    INSTRUMENTS_DICT['piccolo']: 1,
    INSTRUMENTS_DICT['flute']: 1,
    INSTRUMENTS_DICT['oboe']: 0,
    INSTRUMENTS_DICT['english_horn']: 0,
    INSTRUMENTS_DICT['clarinet']: 0,
    INSTRUMENTS_DICT['bassoon']: -1,
    INSTRUMENTS_DICT['french_horn']: -1,
    INSTRUMENTS_DICT['trumpet']: -1,
    INSTRUMENTS_DICT['trombone']: -2,
    INSTRUMENTS_DICT['tuba']: -2,
    INSTRUMENTS_DICT['piano']: -1,
    INSTRUMENTS_DICT['violin']: 0,
    INSTRUMENTS_DICT['viola']: 0,
    INSTRUMENTS_DICT['cello']: -2,
    INSTRUMENTS_DICT['contrabass']: -2,
    INSTRUMENTS_DICT['harp']: -1,
    INSTRUMENTS_DICT['acoustic_guitar']: -1,
    INSTRUMENTS_DICT['timpani']: -2
}

OCTAVES = {key: 0 for key in OCTAVES.keys()}