"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MockIntegration = void 0;
const jsiiDeprecationWarnings = require("../../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const integration_1 = require("../integration");
/**
 * This type of integration lets API Gateway return a response without sending
 * the request further to the backend. This is useful for API testing because it
 * can be used to test the integration set up without incurring charges for
 * using the backend and to enable collaborative development of an API. In
 * collaborative development, a team can isolate their development effort by
 * setting up simulations of API components owned by other teams by using the
 * MOCK integrations. It is also used to return CORS-related headers to ensure
 * that the API method permits CORS access. In fact, the API Gateway console
 * integrates the OPTIONS method to support CORS with a mock integration.
 * Gateway responses are other examples of mock integrations.
 */
class MockIntegration extends integration_1.Integration {
    constructor(options) {
        super({
            type: integration_1.IntegrationType.MOCK,
            options,
        });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_apigateway_IntegrationOptions(options);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
    }
}
exports.MockIntegration = MockIntegration;
_a = JSII_RTTI_SYMBOL_1;
MockIntegration[_a] = { fqn: "@aws-cdk/aws-apigateway.MockIntegration", version: "1.154.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibW9jay5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIm1vY2sudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7O0FBQUEsZ0RBQWtGO0FBRWxGOzs7Ozs7Ozs7OztHQVdHO0FBQ0gsTUFBYSxlQUFnQixTQUFRLHlCQUFXO0lBQzlDLFlBQVksT0FBNEI7UUFDdEMsS0FBSyxDQUFDO1lBQ0osSUFBSSxFQUFFLDZCQUFlLENBQUMsSUFBSTtZQUMxQixPQUFPO1NBQ1IsQ0FBQyxDQUFDOzs7Ozs7Ozs7O0tBQ0o7O0FBTkgsMENBT0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBJbnRlZ3JhdGlvbiwgSW50ZWdyYXRpb25PcHRpb25zLCBJbnRlZ3JhdGlvblR5cGUgfSBmcm9tICcuLi9pbnRlZ3JhdGlvbic7XG5cbi8qKlxuICogVGhpcyB0eXBlIG9mIGludGVncmF0aW9uIGxldHMgQVBJIEdhdGV3YXkgcmV0dXJuIGEgcmVzcG9uc2Ugd2l0aG91dCBzZW5kaW5nXG4gKiB0aGUgcmVxdWVzdCBmdXJ0aGVyIHRvIHRoZSBiYWNrZW5kLiBUaGlzIGlzIHVzZWZ1bCBmb3IgQVBJIHRlc3RpbmcgYmVjYXVzZSBpdFxuICogY2FuIGJlIHVzZWQgdG8gdGVzdCB0aGUgaW50ZWdyYXRpb24gc2V0IHVwIHdpdGhvdXQgaW5jdXJyaW5nIGNoYXJnZXMgZm9yXG4gKiB1c2luZyB0aGUgYmFja2VuZCBhbmQgdG8gZW5hYmxlIGNvbGxhYm9yYXRpdmUgZGV2ZWxvcG1lbnQgb2YgYW4gQVBJLiBJblxuICogY29sbGFib3JhdGl2ZSBkZXZlbG9wbWVudCwgYSB0ZWFtIGNhbiBpc29sYXRlIHRoZWlyIGRldmVsb3BtZW50IGVmZm9ydCBieVxuICogc2V0dGluZyB1cCBzaW11bGF0aW9ucyBvZiBBUEkgY29tcG9uZW50cyBvd25lZCBieSBvdGhlciB0ZWFtcyBieSB1c2luZyB0aGVcbiAqIE1PQ0sgaW50ZWdyYXRpb25zLiBJdCBpcyBhbHNvIHVzZWQgdG8gcmV0dXJuIENPUlMtcmVsYXRlZCBoZWFkZXJzIHRvIGVuc3VyZVxuICogdGhhdCB0aGUgQVBJIG1ldGhvZCBwZXJtaXRzIENPUlMgYWNjZXNzLiBJbiBmYWN0LCB0aGUgQVBJIEdhdGV3YXkgY29uc29sZVxuICogaW50ZWdyYXRlcyB0aGUgT1BUSU9OUyBtZXRob2QgdG8gc3VwcG9ydCBDT1JTIHdpdGggYSBtb2NrIGludGVncmF0aW9uLlxuICogR2F0ZXdheSByZXNwb25zZXMgYXJlIG90aGVyIGV4YW1wbGVzIG9mIG1vY2sgaW50ZWdyYXRpb25zLlxuICovXG5leHBvcnQgY2xhc3MgTW9ja0ludGVncmF0aW9uIGV4dGVuZHMgSW50ZWdyYXRpb24ge1xuICBjb25zdHJ1Y3RvcihvcHRpb25zPzogSW50ZWdyYXRpb25PcHRpb25zKSB7XG4gICAgc3VwZXIoe1xuICAgICAgdHlwZTogSW50ZWdyYXRpb25UeXBlLk1PQ0ssXG4gICAgICBvcHRpb25zLFxuICAgIH0pO1xuICB9XG59XG4iXX0=