"""
Kodexa is a Python framework to enable flexible data engineering with semi-structured and unstructured documents and
data.


.. include:: ./documentation.md
"""
from .assistant import Assistant, AssistantContext, AssistantResponse
from .cloud import KodexaPlatform, RemoteAction, RemotePipeline, RemoteSession
from .connectors import FileHandleConnector, FolderConnector, UrlConnector, add_connector, get_connector, \
    get_connectors, get_source, registered_connectors
from .model import ContentEvent, ContentFeature, ContentNode, Document, DocumentActor, DocumentFamily, DocumentMetadata, \
    DocumentStore, DocumentTransition, RemoteStore, SourceMetadata, TransitionType
from .pipeline import Pipeline, PipelineContext, PipelineStatistics
from .sinks import FolderSink, InMemoryDocumentSink
from .steps import NodeTagCopy, NodeTagger, RollupTransformer, TagsToKeyValuePairExtractor, TextParser
from .stores import DataStoreHelper, LocalDocumentStore, LocalModelStore, RemoteDocumentStore, \
    RemoteModelStore, RemoteTableDataStore, TableDataStore
from .taxonomy import RemoteTaxonomy, Taxon, Taxonomy
