"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MessagingAppInstance = exports.AppInstanceDataType = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk = require("aws-cdk-lib");
const constructs_1 = require("constructs");
const appInstanceValidator_1 = require("./appInstanceValidator");
const messagingCustomResources_1 = require("./messagingCustomResources");
var AppInstanceDataType;
(function (AppInstanceDataType) {
    AppInstanceDataType["CHANNEL"] = "Channel";
    AppInstanceDataType["CHANNELMESSAGE"] = "ChannelMessage";
})(AppInstanceDataType = exports.AppInstanceDataType || (exports.AppInstanceDataType = {}));
class MessagingAppInstance extends constructs_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const uid = cdk.Names.uniqueId(this);
        const { name, metadata, clientRequestToken } = props;
        appInstanceValidator_1.appInstanceValidator(props);
        const appInstanceRequest = new messagingCustomResources_1.MessagingResources(this, 'MessagingAppInstance', {
            resourceType: 'AppInstance',
            uid: uid,
            properties: {
                name: name || uid,
                metadata: metadata,
                clientRequestToken: clientRequestToken,
            },
        });
        this.appInstanceArn =
            appInstanceRequest.messagingCustomResource.getAttString('appInstanceArn');
    }
    streaming(streamingConfigs) {
        const uid = cdk.Names.uniqueId(this);
        const result = new messagingCustomResources_1.MessagingResources(this, 'AppInstanceStreamingConfiguration', {
            resourceType: 'StreamingConfig',
            uid: uid,
            properties: {
                streamingConfigs: streamingConfigs,
                appInstanceArn: this.appInstanceArn,
            },
        });
        return result;
    }
    retention(days) {
        const uid = cdk.Names.uniqueId(this);
        const result = new messagingCustomResources_1.MessagingResources(this, 'AppInstanceDataRetentionConfig', {
            resourceType: 'DataRetention',
            uid: uid,
            properties: {
                dataRetention: days,
                appInstanceArn: this.appInstanceArn,
            },
        });
        return result;
    }
}
exports.MessagingAppInstance = MessagingAppInstance;
_a = JSII_RTTI_SYMBOL_1;
MessagingAppInstance[_a] = { fqn: "cdk-amazon-chime-resources.MessagingAppInstance", version: "0.1.120" };
//# sourceMappingURL=data:application/json;base64,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