# AUTOGENERATED - modify shared_anyscale_util in root directory to make changes
import os


TEST_MODE = os.environ.get("TEST_MODE") == "1"

ANYSCALE_ENDPOINTS = {
    "development": "https://console.anyscale-dev.dev",
    "staging": "https://console.anyscale-staging.com",
    "production": "https://console.anyscale.com",
    "test": "",
    "integration_test": "localhost",
}

ANYSCALE_EXTERNAL_API_ENDPOINTS = {
    "development": "https://anyscale-dev.dev/ext",
    "staging": "https://api.anyscale-staging.com",
    "production": "https://api.anyscale.com",
    "test": "",
    "integration_test": "localhost",
}


if (
    "ANYSCALE_HOST" in os.environ
    and os.environ.get("ANYSCALE_HOST") not in ANYSCALE_ENDPOINTS.values()
):
    anyscale_env_default = "test"
else:
    anyscale_env_default = "production"

ANYSCALE_ENV = os.environ.get("DEPLOY_ENVIRONMENT", anyscale_env_default)
ANYSCALE_HOST = os.environ.get("ANYSCALE_HOST", ANYSCALE_ENDPOINTS[ANYSCALE_ENV])
ANYSCALE_API_HOST = ANYSCALE_EXTERNAL_API_ENDPOINTS[ANYSCALE_ENV]

RAY_STATIC_GCS_PORT = 9031

# The name of the default Anyscale shared k8s cloud.
ANYSCALE_K8S_CLOUD_NAME = "anyscale_k8s_cloud"
ANYSCALE_K8S_CLOUD_ID = "cld_41THJUKS3PBYvwIynRggIb"
ANYSCALE_K8S_GCP_CLOUD_NAME = "anyscale_k8s_gcp_cloud"
ANYSCALE_K8S_GCP_CLOUD_ID = "cld_k8WcxPgjUtSE8RVmfZpTLuKM"
AIOA_AWS_K8S_CLOUD_ID = "cld_HSrCZdMCYDe1NmMCJhYRgQ4p"

ANYSCALE_AWS_SECURITY_GROUP_NAME = "anyscale-security-group"

# env variable used to pass the AnyscaleBackgroundContext for background mode
ANYSCALE_BACKGROUND_JOB_CONTEXT = "ANYSCALE_BACKGROUND_JOB_CONTEXT"

# outer job name for background mode
OUTER_JOB_NAME = "_as_bg_job"

# The name of the BackgroundJobRunner actor
BACKGROUND_ACTOR_NAME = "_as_bg_actor"
