# -*- coding: utf-8 -*-
# Generated by Django 1.11.2 on 2018-10-25 15:43


from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('basemodels', '0001_initial'),
        ('pages', '0001_initial'),
        ('socials', '0001_initial'),
        ('filefields', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Slider',
            fields=[
                ('basemodel_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='basemodels.BaseModel')),
                ('name', models.CharField(blank=True, max_length=50, null=True, verbose_name='Name')),
                ('is_active', models.BooleanField(default=True, verbose_name='Is Active')),
            ],
            options={
                'verbose_name': 'Slide Show',
                'verbose_name_plural': 'Slide Shows',
            },
            bases=('basemodels.basemodel',),
        ),
        migrations.CreateModel(
            name='SliderBaseModel',
            fields=[
                ('slider_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='sliders.Slider')),
                ('model', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='basemodels.BaseModel', verbose_name='Model')),
            ],
            options={
                'verbose_name': 'Model Slider',
                'verbose_name_plural': 'Model Sliders',
            },
            bases=('sliders.slider',),
        ),
        migrations.CreateModel(
            name='SliderLink',
            fields=[
                ('slider_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='sliders.Slider')),
                ('link', models.URLField(verbose_name='Link')),
            ],
            options={
                'verbose_name': 'Link Slider',
                'verbose_name_plural': 'Link Sliders',
            },
            bases=('sliders.slider',),
        ),
        migrations.CreateModel(
            name='SliderSocialNetwork',
            fields=[
                ('slider_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='sliders.Slider')),
                ('social', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='socials.SocialNetwork', verbose_name='Social')),
            ],
            options={
                'verbose_name': 'Social Network Slider',
                'verbose_name_plural': 'Social Network Sliders',
            },
            bases=('sliders.slider',),
        ),
        migrations.CreateModel(
            name='SliderVideo',
            fields=[
                ('slider_ptr', models.OneToOneField(auto_created=True, on_delete=django.db.models.deletion.CASCADE, parent_link=True, primary_key=True, serialize=False, to='sliders.Slider')),
                ('video', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='filefields.FileField', verbose_name='Video')),
            ],
            options={
                'verbose_name': 'Video Slider',
                'verbose_name_plural': 'Video Sliders',
            },
            bases=('sliders.slider',),
        ),
        migrations.AddField(
            model_name='slider',
            name='image',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='filefields.FileField', verbose_name='Image'),
        ),
        migrations.AddField(
            model_name='slider',
            name='pages',
            field=models.ManyToManyField(blank=True, to='pages.Page', verbose_name='Page'),
        ),
    ]
