import setuptools

with open("README.md", "r") as fh:
    long_description = fh.read()


setuptools.setup(
    name='naver-core',
    version='0.0.3-6',
    packages=setuptools.find_packages(),
    author="Jose Cuevas",
    author_email="jose.cuevas.cv@gmail.com",
    description="A Core Ancestor Library",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/jacr6/naver-core",
    classifiers=[
         "Programming Language :: Python :: 3",
         "License :: OSI Approved :: MIT License",
         "Operating System :: OS Independent",
    ], install_requires=[
        'naver-config',
        'naver-db',
        'naver-net',
        'naver-web',
        'autopep8',
        'aniso8601',
        'attrs',
        'bandit',
        'cachetools',
        'certifi',
        'charset-normalizer',
        'click',
        'docx',
        'docx2pdf',
        'docxcompose',
        'Flask',
        'Flask-Cors',
        'flask-restx',
        'Flask-SQLAlchemy',
        'gitdb',
        'GitPython',
        'google-api-core',
        'google-api-python-client',
        'google-auth',
        'google-auth-httplib2',
        'google-auth-oauthlib',
        'googleapis-common-protos',
        'greenlet',
        'httplib2',
        'idna',
        'importlib-metadata',
        'importlib-resources',
        'itsdangerous',
        'Jinja2',
        'jsonschema',
        'lxml',
        'MarkupSafe',
        'naver-config',
        'naver-core',
        'naver-db',
        'naver-net',
        'numpy',
        'oauth2client',
        'oauthlib',
        'openpyxl',
        'pandas',
        'pathlib',
        'pbr',
        'Pillow',
        'protobuf',
        'psycopg2',
        'pyasn1',
        'pyasn1-modules',
        'pyparsing',
        'pyrsistent',
        'python-consul',
        'python-dateutil',
        'python-decouple',
        'python-docx',
        'python-dotenv',
        'pytz',
        'PyYAML',
        'requests',
        'requests-oauthlib',
        'rsa',
        'six',
        'smmap',
        'SQLAlchemy',
        'stevedore',
        'tqdm',
        'uritemplate',
        'urllib3',
        'waitress',
        'Werkzeug',
        'WTForms',
        'zipp',
    ],
)
