# -*- coding: utf-8 -*-
# This file is auto-generated, don't edit it. Thanks.
from typing import Dict
from Tea.core import TeaCore

from alibabacloud_tea_openapi.client import Client as OpenApiClient
from alibabacloud_tea_openapi import models as open_api_models
from alibabacloud_tea_util.client import Client as UtilClient
from alibabacloud_endpoint_util.client import Client as EndpointUtilClient
from alibabacloud_cloudfw20171207 import models as cloudfw_20171207_models
from alibabacloud_tea_util import models as util_models
from alibabacloud_openapi_util.client import Client as OpenApiUtilClient


class Client(OpenApiClient):
    """
    *\
    """
    def __init__(
        self, 
        config: open_api_models.Config,
    ):
        super().__init__(config)
        self._endpoint_rule = 'central'
        self._endpoint_map = {
            'ap-southeast-1': 'cloudfw.ap-southeast-1.aliyuncs.com',
            'cn-hangzhou': 'cloudfw.cn-hangzhou.aliyuncs.com'
        }
        self.check_config(config)
        self._endpoint = self.get_endpoint('cloudfw', self._region_id, self._endpoint_rule, self._network, self._suffix, self._endpoint_map, self._endpoint)

    def get_endpoint(
        self,
        product_id: str,
        region_id: str,
        endpoint_rule: str,
        network: str,
        suffix: str,
        endpoint_map: Dict[str, str],
        endpoint: str,
    ) -> str:
        if not UtilClient.empty(endpoint):
            return endpoint
        if not UtilClient.is_unset(endpoint_map) and not UtilClient.empty(endpoint_map.get(region_id)):
            return endpoint_map.get(region_id)
        return EndpointUtilClient.get_endpoint_rules(product_id, region_id, endpoint_rule, network, suffix)

    def add_acl_backup_data_with_options(
        self,
        request: cloudfw_20171207_models.AddAclBackupDataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.AddAclBackupDataResponse:
        """
        @summary 备份ACL
        
        @param request: AddAclBackupDataRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddAclBackupDataResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.back_up_time):
            query['BackUpTime'] = request.back_up_time
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddAclBackupData',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.AddAclBackupDataResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_acl_backup_data_with_options_async(
        self,
        request: cloudfw_20171207_models.AddAclBackupDataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.AddAclBackupDataResponse:
        """
        @summary 备份ACL
        
        @param request: AddAclBackupDataRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddAclBackupDataResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.back_up_time):
            query['BackUpTime'] = request.back_up_time
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddAclBackupData',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.AddAclBackupDataResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_acl_backup_data(
        self,
        request: cloudfw_20171207_models.AddAclBackupDataRequest,
    ) -> cloudfw_20171207_models.AddAclBackupDataResponse:
        """
        @summary 备份ACL
        
        @param request: AddAclBackupDataRequest
        @return: AddAclBackupDataResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_acl_backup_data_with_options(request, runtime)

    async def add_acl_backup_data_async(
        self,
        request: cloudfw_20171207_models.AddAclBackupDataRequest,
    ) -> cloudfw_20171207_models.AddAclBackupDataResponse:
        """
        @summary 备份ACL
        
        @param request: AddAclBackupDataRequest
        @return: AddAclBackupDataResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_acl_backup_data_with_options_async(request, runtime)

    def add_address_book_with_options(
        self,
        request: cloudfw_20171207_models.AddAddressBookRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.AddAddressBookResponse:
        """
        @summary Creates an address book for access control. Supported address book types are IP address books, Elastic Compute Service (ECS) tag-based address books, port address books, and domain address books. An ECS tag-based address book includes the public IP addresses of the ECS instances that have specific tags.
        
        @description You can call the AddAddressBook operation to create an address book for access control. The address book can be an IP address book, an ECS tag-based address book, a port address book, or a domain address book.
        ## [](#qps)Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: AddAddressBookRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddAddressBookResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ack_cluster_connector_id):
            query['AckClusterConnectorId'] = request.ack_cluster_connector_id
        if not UtilClient.is_unset(request.ack_labels):
            query['AckLabels'] = request.ack_labels
        if not UtilClient.is_unset(request.ack_namespaces):
            query['AckNamespaces'] = request.ack_namespaces
        if not UtilClient.is_unset(request.address_list):
            query['AddressList'] = request.address_list
        if not UtilClient.is_unset(request.auto_add_tag_ecs):
            query['AutoAddTagEcs'] = request.auto_add_tag_ecs
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        if not UtilClient.is_unset(request.group_type):
            query['GroupType'] = request.group_type
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.tag_list):
            query['TagList'] = request.tag_list
        if not UtilClient.is_unset(request.tag_relation):
            query['TagRelation'] = request.tag_relation
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddAddressBook',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.AddAddressBookResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_address_book_with_options_async(
        self,
        request: cloudfw_20171207_models.AddAddressBookRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.AddAddressBookResponse:
        """
        @summary Creates an address book for access control. Supported address book types are IP address books, Elastic Compute Service (ECS) tag-based address books, port address books, and domain address books. An ECS tag-based address book includes the public IP addresses of the ECS instances that have specific tags.
        
        @description You can call the AddAddressBook operation to create an address book for access control. The address book can be an IP address book, an ECS tag-based address book, a port address book, or a domain address book.
        ## [](#qps)Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: AddAddressBookRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddAddressBookResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ack_cluster_connector_id):
            query['AckClusterConnectorId'] = request.ack_cluster_connector_id
        if not UtilClient.is_unset(request.ack_labels):
            query['AckLabels'] = request.ack_labels
        if not UtilClient.is_unset(request.ack_namespaces):
            query['AckNamespaces'] = request.ack_namespaces
        if not UtilClient.is_unset(request.address_list):
            query['AddressList'] = request.address_list
        if not UtilClient.is_unset(request.auto_add_tag_ecs):
            query['AutoAddTagEcs'] = request.auto_add_tag_ecs
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        if not UtilClient.is_unset(request.group_type):
            query['GroupType'] = request.group_type
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.tag_list):
            query['TagList'] = request.tag_list
        if not UtilClient.is_unset(request.tag_relation):
            query['TagRelation'] = request.tag_relation
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddAddressBook',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.AddAddressBookResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_address_book(
        self,
        request: cloudfw_20171207_models.AddAddressBookRequest,
    ) -> cloudfw_20171207_models.AddAddressBookResponse:
        """
        @summary Creates an address book for access control. Supported address book types are IP address books, Elastic Compute Service (ECS) tag-based address books, port address books, and domain address books. An ECS tag-based address book includes the public IP addresses of the ECS instances that have specific tags.
        
        @description You can call the AddAddressBook operation to create an address book for access control. The address book can be an IP address book, an ECS tag-based address book, a port address book, or a domain address book.
        ## [](#qps)Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: AddAddressBookRequest
        @return: AddAddressBookResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_address_book_with_options(request, runtime)

    async def add_address_book_async(
        self,
        request: cloudfw_20171207_models.AddAddressBookRequest,
    ) -> cloudfw_20171207_models.AddAddressBookResponse:
        """
        @summary Creates an address book for access control. Supported address book types are IP address books, Elastic Compute Service (ECS) tag-based address books, port address books, and domain address books. An ECS tag-based address book includes the public IP addresses of the ECS instances that have specific tags.
        
        @description You can call the AddAddressBook operation to create an address book for access control. The address book can be an IP address book, an ECS tag-based address book, a port address book, or a domain address book.
        ## [](#qps)Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: AddAddressBookRequest
        @return: AddAddressBookResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_address_book_with_options_async(request, runtime)

    def add_control_policy_with_options(
        self,
        request: cloudfw_20171207_models.AddControlPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.AddControlPolicyResponse:
        """
        @summary Creates an access control policy.
        
        @description You can call the AddControlPolicy operation to create an access control policy to allow, block, or monitor traffic that reaches Cloud Firewall.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: AddControlPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddControlPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_action):
            query['AclAction'] = request.acl_action
        if not UtilClient.is_unset(request.application_name):
            query['ApplicationName'] = request.application_name
        if not UtilClient.is_unset(request.application_name_list):
            query['ApplicationNameList'] = request.application_name_list
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.dest_port):
            query['DestPort'] = request.dest_port
        if not UtilClient.is_unset(request.dest_port_group):
            query['DestPortGroup'] = request.dest_port_group
        if not UtilClient.is_unset(request.dest_port_type):
            query['DestPortType'] = request.dest_port_type
        if not UtilClient.is_unset(request.destination):
            query['Destination'] = request.destination
        if not UtilClient.is_unset(request.destination_type):
            query['DestinationType'] = request.destination_type
        if not UtilClient.is_unset(request.direction):
            query['Direction'] = request.direction
        if not UtilClient.is_unset(request.domain_resolve_type):
            query['DomainResolveType'] = request.domain_resolve_type
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.ip_version):
            query['IpVersion'] = request.ip_version
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.new_order):
            query['NewOrder'] = request.new_order
        if not UtilClient.is_unset(request.proto):
            query['Proto'] = request.proto
        if not UtilClient.is_unset(request.release):
            query['Release'] = request.release
        if not UtilClient.is_unset(request.repeat_days):
            query['RepeatDays'] = request.repeat_days
        if not UtilClient.is_unset(request.repeat_end_time):
            query['RepeatEndTime'] = request.repeat_end_time
        if not UtilClient.is_unset(request.repeat_start_time):
            query['RepeatStartTime'] = request.repeat_start_time
        if not UtilClient.is_unset(request.repeat_type):
            query['RepeatType'] = request.repeat_type
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.source_type):
            query['SourceType'] = request.source_type
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddControlPolicy',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.AddControlPolicyResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_control_policy_with_options_async(
        self,
        request: cloudfw_20171207_models.AddControlPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.AddControlPolicyResponse:
        """
        @summary Creates an access control policy.
        
        @description You can call the AddControlPolicy operation to create an access control policy to allow, block, or monitor traffic that reaches Cloud Firewall.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: AddControlPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddControlPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_action):
            query['AclAction'] = request.acl_action
        if not UtilClient.is_unset(request.application_name):
            query['ApplicationName'] = request.application_name
        if not UtilClient.is_unset(request.application_name_list):
            query['ApplicationNameList'] = request.application_name_list
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.dest_port):
            query['DestPort'] = request.dest_port
        if not UtilClient.is_unset(request.dest_port_group):
            query['DestPortGroup'] = request.dest_port_group
        if not UtilClient.is_unset(request.dest_port_type):
            query['DestPortType'] = request.dest_port_type
        if not UtilClient.is_unset(request.destination):
            query['Destination'] = request.destination
        if not UtilClient.is_unset(request.destination_type):
            query['DestinationType'] = request.destination_type
        if not UtilClient.is_unset(request.direction):
            query['Direction'] = request.direction
        if not UtilClient.is_unset(request.domain_resolve_type):
            query['DomainResolveType'] = request.domain_resolve_type
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.ip_version):
            query['IpVersion'] = request.ip_version
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.new_order):
            query['NewOrder'] = request.new_order
        if not UtilClient.is_unset(request.proto):
            query['Proto'] = request.proto
        if not UtilClient.is_unset(request.release):
            query['Release'] = request.release
        if not UtilClient.is_unset(request.repeat_days):
            query['RepeatDays'] = request.repeat_days
        if not UtilClient.is_unset(request.repeat_end_time):
            query['RepeatEndTime'] = request.repeat_end_time
        if not UtilClient.is_unset(request.repeat_start_time):
            query['RepeatStartTime'] = request.repeat_start_time
        if not UtilClient.is_unset(request.repeat_type):
            query['RepeatType'] = request.repeat_type
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.source_type):
            query['SourceType'] = request.source_type
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddControlPolicy',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.AddControlPolicyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_control_policy(
        self,
        request: cloudfw_20171207_models.AddControlPolicyRequest,
    ) -> cloudfw_20171207_models.AddControlPolicyResponse:
        """
        @summary Creates an access control policy.
        
        @description You can call the AddControlPolicy operation to create an access control policy to allow, block, or monitor traffic that reaches Cloud Firewall.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: AddControlPolicyRequest
        @return: AddControlPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_control_policy_with_options(request, runtime)

    async def add_control_policy_async(
        self,
        request: cloudfw_20171207_models.AddControlPolicyRequest,
    ) -> cloudfw_20171207_models.AddControlPolicyResponse:
        """
        @summary Creates an access control policy.
        
        @description You can call the AddControlPolicy operation to create an access control policy to allow, block, or monitor traffic that reaches Cloud Firewall.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: AddControlPolicyRequest
        @return: AddControlPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_control_policy_with_options_async(request, runtime)

    def add_dns_firewall_policy_with_options(
        self,
        request: cloudfw_20171207_models.AddDnsFirewallPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.AddDnsFirewallPolicyResponse:
        """
        @summary 添加DNS防火墙ACL
        
        @param request: AddDnsFirewallPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddDnsFirewallPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_action):
            query['AclAction'] = request.acl_action
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.destination):
            query['Destination'] = request.destination
        if not UtilClient.is_unset(request.destination_type):
            query['DestinationType'] = request.destination_type
        if not UtilClient.is_unset(request.direction):
            query['Direction'] = request.direction
        if not UtilClient.is_unset(request.ip_version):
            query['IpVersion'] = request.ip_version
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.priority):
            query['Priority'] = request.priority
        if not UtilClient.is_unset(request.release):
            query['Release'] = request.release
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.source_type):
            query['SourceType'] = request.source_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddDnsFirewallPolicy',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.AddDnsFirewallPolicyResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_dns_firewall_policy_with_options_async(
        self,
        request: cloudfw_20171207_models.AddDnsFirewallPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.AddDnsFirewallPolicyResponse:
        """
        @summary 添加DNS防火墙ACL
        
        @param request: AddDnsFirewallPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddDnsFirewallPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_action):
            query['AclAction'] = request.acl_action
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.destination):
            query['Destination'] = request.destination
        if not UtilClient.is_unset(request.destination_type):
            query['DestinationType'] = request.destination_type
        if not UtilClient.is_unset(request.direction):
            query['Direction'] = request.direction
        if not UtilClient.is_unset(request.ip_version):
            query['IpVersion'] = request.ip_version
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.priority):
            query['Priority'] = request.priority
        if not UtilClient.is_unset(request.release):
            query['Release'] = request.release
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.source_type):
            query['SourceType'] = request.source_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddDnsFirewallPolicy',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.AddDnsFirewallPolicyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_dns_firewall_policy(
        self,
        request: cloudfw_20171207_models.AddDnsFirewallPolicyRequest,
    ) -> cloudfw_20171207_models.AddDnsFirewallPolicyResponse:
        """
        @summary 添加DNS防火墙ACL
        
        @param request: AddDnsFirewallPolicyRequest
        @return: AddDnsFirewallPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_dns_firewall_policy_with_options(request, runtime)

    async def add_dns_firewall_policy_async(
        self,
        request: cloudfw_20171207_models.AddDnsFirewallPolicyRequest,
    ) -> cloudfw_20171207_models.AddDnsFirewallPolicyResponse:
        """
        @summary 添加DNS防火墙ACL
        
        @param request: AddDnsFirewallPolicyRequest
        @return: AddDnsFirewallPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_dns_firewall_policy_with_options_async(request, runtime)

    def add_domain_resolve_realtime_task_with_options(
        self,
        request: cloudfw_20171207_models.AddDomainResolveRealtimeTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.AddDomainResolveRealtimeTaskResponse:
        """
        @summary 新增域名解析实时任务
        
        @param request: AddDomainResolveRealtimeTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddDomainResolveRealtimeTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.firewall_type):
            query['FirewallType'] = request.firewall_type
        if not UtilClient.is_unset(request.region_no):
            query['RegionNo'] = request.region_no
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddDomainResolveRealtimeTask',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.AddDomainResolveRealtimeTaskResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_domain_resolve_realtime_task_with_options_async(
        self,
        request: cloudfw_20171207_models.AddDomainResolveRealtimeTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.AddDomainResolveRealtimeTaskResponse:
        """
        @summary 新增域名解析实时任务
        
        @param request: AddDomainResolveRealtimeTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddDomainResolveRealtimeTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.firewall_type):
            query['FirewallType'] = request.firewall_type
        if not UtilClient.is_unset(request.region_no):
            query['RegionNo'] = request.region_no
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddDomainResolveRealtimeTask',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.AddDomainResolveRealtimeTaskResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_domain_resolve_realtime_task(
        self,
        request: cloudfw_20171207_models.AddDomainResolveRealtimeTaskRequest,
    ) -> cloudfw_20171207_models.AddDomainResolveRealtimeTaskResponse:
        """
        @summary 新增域名解析实时任务
        
        @param request: AddDomainResolveRealtimeTaskRequest
        @return: AddDomainResolveRealtimeTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_domain_resolve_realtime_task_with_options(request, runtime)

    async def add_domain_resolve_realtime_task_async(
        self,
        request: cloudfw_20171207_models.AddDomainResolveRealtimeTaskRequest,
    ) -> cloudfw_20171207_models.AddDomainResolveRealtimeTaskResponse:
        """
        @summary 新增域名解析实时任务
        
        @param request: AddDomainResolveRealtimeTaskRequest
        @return: AddDomainResolveRealtimeTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_domain_resolve_realtime_task_with_options_async(request, runtime)

    def add_instance_members_with_options(
        self,
        request: cloudfw_20171207_models.AddInstanceMembersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.AddInstanceMembersResponse:
        """
        @summary Adds members to Cloud Firewall.
        
        @description You can call this operation to add members to Cloud Firewall.
        ## [](#qps-)Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: AddInstanceMembersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddInstanceMembersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.members):
            query['Members'] = request.members
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddInstanceMembers',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.AddInstanceMembersResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_instance_members_with_options_async(
        self,
        request: cloudfw_20171207_models.AddInstanceMembersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.AddInstanceMembersResponse:
        """
        @summary Adds members to Cloud Firewall.
        
        @description You can call this operation to add members to Cloud Firewall.
        ## [](#qps-)Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: AddInstanceMembersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddInstanceMembersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.members):
            query['Members'] = request.members
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddInstanceMembers',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.AddInstanceMembersResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_instance_members(
        self,
        request: cloudfw_20171207_models.AddInstanceMembersRequest,
    ) -> cloudfw_20171207_models.AddInstanceMembersResponse:
        """
        @summary Adds members to Cloud Firewall.
        
        @description You can call this operation to add members to Cloud Firewall.
        ## [](#qps-)Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: AddInstanceMembersRequest
        @return: AddInstanceMembersResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_instance_members_with_options(request, runtime)

    async def add_instance_members_async(
        self,
        request: cloudfw_20171207_models.AddInstanceMembersRequest,
    ) -> cloudfw_20171207_models.AddInstanceMembersResponse:
        """
        @summary Adds members to Cloud Firewall.
        
        @description You can call this operation to add members to Cloud Firewall.
        ## [](#qps-)Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: AddInstanceMembersRequest
        @return: AddInstanceMembersResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_instance_members_with_options_async(request, runtime)

    def add_private_dns_domain_name_with_options(
        self,
        request: cloudfw_20171207_models.AddPrivateDnsDomainNameRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.AddPrivateDnsDomainNameResponse:
        """
        @summary 添加私网DNS域名
        
        @param request: AddPrivateDnsDomainNameRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddPrivateDnsDomainNameResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_instance_id):
            query['AccessInstanceId'] = request.access_instance_id
        if not UtilClient.is_unset(request.domain_name_list):
            query['DomainNameList'] = request.domain_name_list
        if not UtilClient.is_unset(request.region_no):
            query['RegionNo'] = request.region_no
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddPrivateDnsDomainName',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.AddPrivateDnsDomainNameResponse(),
            self.call_api(params, req, runtime)
        )

    async def add_private_dns_domain_name_with_options_async(
        self,
        request: cloudfw_20171207_models.AddPrivateDnsDomainNameRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.AddPrivateDnsDomainNameResponse:
        """
        @summary 添加私网DNS域名
        
        @param request: AddPrivateDnsDomainNameRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: AddPrivateDnsDomainNameResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_instance_id):
            query['AccessInstanceId'] = request.access_instance_id
        if not UtilClient.is_unset(request.domain_name_list):
            query['DomainNameList'] = request.domain_name_list
        if not UtilClient.is_unset(request.region_no):
            query['RegionNo'] = request.region_no
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='AddPrivateDnsDomainName',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.AddPrivateDnsDomainNameResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def add_private_dns_domain_name(
        self,
        request: cloudfw_20171207_models.AddPrivateDnsDomainNameRequest,
    ) -> cloudfw_20171207_models.AddPrivateDnsDomainNameResponse:
        """
        @summary 添加私网DNS域名
        
        @param request: AddPrivateDnsDomainNameRequest
        @return: AddPrivateDnsDomainNameResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.add_private_dns_domain_name_with_options(request, runtime)

    async def add_private_dns_domain_name_async(
        self,
        request: cloudfw_20171207_models.AddPrivateDnsDomainNameRequest,
    ) -> cloudfw_20171207_models.AddPrivateDnsDomainNameResponse:
        """
        @summary 添加私网DNS域名
        
        @param request: AddPrivateDnsDomainNameRequest
        @return: AddPrivateDnsDomainNameResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.add_private_dns_domain_name_with_options_async(request, runtime)

    def batch_copy_vpc_firewall_control_policy_with_options(
        self,
        request: cloudfw_20171207_models.BatchCopyVpcFirewallControlPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.BatchCopyVpcFirewallControlPolicyResponse:
        """
        @deprecated OpenAPI BatchCopyVpcFirewallControlPolicy is deprecated
        
        @summary Copies all access control policies from a policy group of a source virtual private cloud (VPC) firewall to a policy group of a destination VPC firewall.
        
        @description You can call the BatchCopyVpcFirewallControlPolicy operation to copy all access control policies from a policy group of a source VPC firewall to a policy group of a destination VPC firewall.
        Before you call this operation, we recommend that you back up access control policies. For more information about how to back up an access control policy, see [Back up an access control policy](https://www.alibabacloud.com/help/en/cloud-firewall/latest/back-up-and-roll-back-an-access-control-policy).
        After you call this operation, all the access control policies in the policy group of the destination VPC firewall are replaced.
        The policy groups of the source VPC firewall and the destination VPC firewall must belong to the same Alibaba Cloud account.
        ## Limits
        You can call this operation up to 10 times per second per account. When the number of calls to this operation per second exceeds the limit, throttling is triggered. Throttling may affect your business. We recommend that you take note of the limit on this operation.
        
        @param request: BatchCopyVpcFirewallControlPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: BatchCopyVpcFirewallControlPolicyResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.source_vpc_firewall_id):
            query['SourceVpcFirewallId'] = request.source_vpc_firewall_id
        if not UtilClient.is_unset(request.target_vpc_firewall_id):
            query['TargetVpcFirewallId'] = request.target_vpc_firewall_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='BatchCopyVpcFirewallControlPolicy',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.BatchCopyVpcFirewallControlPolicyResponse(),
            self.call_api(params, req, runtime)
        )

    async def batch_copy_vpc_firewall_control_policy_with_options_async(
        self,
        request: cloudfw_20171207_models.BatchCopyVpcFirewallControlPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.BatchCopyVpcFirewallControlPolicyResponse:
        """
        @deprecated OpenAPI BatchCopyVpcFirewallControlPolicy is deprecated
        
        @summary Copies all access control policies from a policy group of a source virtual private cloud (VPC) firewall to a policy group of a destination VPC firewall.
        
        @description You can call the BatchCopyVpcFirewallControlPolicy operation to copy all access control policies from a policy group of a source VPC firewall to a policy group of a destination VPC firewall.
        Before you call this operation, we recommend that you back up access control policies. For more information about how to back up an access control policy, see [Back up an access control policy](https://www.alibabacloud.com/help/en/cloud-firewall/latest/back-up-and-roll-back-an-access-control-policy).
        After you call this operation, all the access control policies in the policy group of the destination VPC firewall are replaced.
        The policy groups of the source VPC firewall and the destination VPC firewall must belong to the same Alibaba Cloud account.
        ## Limits
        You can call this operation up to 10 times per second per account. When the number of calls to this operation per second exceeds the limit, throttling is triggered. Throttling may affect your business. We recommend that you take note of the limit on this operation.
        
        @param request: BatchCopyVpcFirewallControlPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: BatchCopyVpcFirewallControlPolicyResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.source_vpc_firewall_id):
            query['SourceVpcFirewallId'] = request.source_vpc_firewall_id
        if not UtilClient.is_unset(request.target_vpc_firewall_id):
            query['TargetVpcFirewallId'] = request.target_vpc_firewall_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='BatchCopyVpcFirewallControlPolicy',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.BatchCopyVpcFirewallControlPolicyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def batch_copy_vpc_firewall_control_policy(
        self,
        request: cloudfw_20171207_models.BatchCopyVpcFirewallControlPolicyRequest,
    ) -> cloudfw_20171207_models.BatchCopyVpcFirewallControlPolicyResponse:
        """
        @deprecated OpenAPI BatchCopyVpcFirewallControlPolicy is deprecated
        
        @summary Copies all access control policies from a policy group of a source virtual private cloud (VPC) firewall to a policy group of a destination VPC firewall.
        
        @description You can call the BatchCopyVpcFirewallControlPolicy operation to copy all access control policies from a policy group of a source VPC firewall to a policy group of a destination VPC firewall.
        Before you call this operation, we recommend that you back up access control policies. For more information about how to back up an access control policy, see [Back up an access control policy](https://www.alibabacloud.com/help/en/cloud-firewall/latest/back-up-and-roll-back-an-access-control-policy).
        After you call this operation, all the access control policies in the policy group of the destination VPC firewall are replaced.
        The policy groups of the source VPC firewall and the destination VPC firewall must belong to the same Alibaba Cloud account.
        ## Limits
        You can call this operation up to 10 times per second per account. When the number of calls to this operation per second exceeds the limit, throttling is triggered. Throttling may affect your business. We recommend that you take note of the limit on this operation.
        
        @param request: BatchCopyVpcFirewallControlPolicyRequest
        @return: BatchCopyVpcFirewallControlPolicyResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.batch_copy_vpc_firewall_control_policy_with_options(request, runtime)

    async def batch_copy_vpc_firewall_control_policy_async(
        self,
        request: cloudfw_20171207_models.BatchCopyVpcFirewallControlPolicyRequest,
    ) -> cloudfw_20171207_models.BatchCopyVpcFirewallControlPolicyResponse:
        """
        @deprecated OpenAPI BatchCopyVpcFirewallControlPolicy is deprecated
        
        @summary Copies all access control policies from a policy group of a source virtual private cloud (VPC) firewall to a policy group of a destination VPC firewall.
        
        @description You can call the BatchCopyVpcFirewallControlPolicy operation to copy all access control policies from a policy group of a source VPC firewall to a policy group of a destination VPC firewall.
        Before you call this operation, we recommend that you back up access control policies. For more information about how to back up an access control policy, see [Back up an access control policy](https://www.alibabacloud.com/help/en/cloud-firewall/latest/back-up-and-roll-back-an-access-control-policy).
        After you call this operation, all the access control policies in the policy group of the destination VPC firewall are replaced.
        The policy groups of the source VPC firewall and the destination VPC firewall must belong to the same Alibaba Cloud account.
        ## Limits
        You can call this operation up to 10 times per second per account. When the number of calls to this operation per second exceeds the limit, throttling is triggered. Throttling may affect your business. We recommend that you take note of the limit on this operation.
        
        @param request: BatchCopyVpcFirewallControlPolicyRequest
        @return: BatchCopyVpcFirewallControlPolicyResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.batch_copy_vpc_firewall_control_policy_with_options_async(request, runtime)

    def batch_delete_vpc_firewall_control_policy_with_options(
        self,
        request: cloudfw_20171207_models.BatchDeleteVpcFirewallControlPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.BatchDeleteVpcFirewallControlPolicyResponse:
        """
        @summary Deletes multiple access control policies for a virtual private cloud (VPC) firewall at a time.
        
        @param request: BatchDeleteVpcFirewallControlPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: BatchDeleteVpcFirewallControlPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_uuid_list):
            query['AclUuidList'] = request.acl_uuid_list
        if not UtilClient.is_unset(request.vpc_firewall_id):
            query['VpcFirewallId'] = request.vpc_firewall_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='BatchDeleteVpcFirewallControlPolicy',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.BatchDeleteVpcFirewallControlPolicyResponse(),
            self.call_api(params, req, runtime)
        )

    async def batch_delete_vpc_firewall_control_policy_with_options_async(
        self,
        request: cloudfw_20171207_models.BatchDeleteVpcFirewallControlPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.BatchDeleteVpcFirewallControlPolicyResponse:
        """
        @summary Deletes multiple access control policies for a virtual private cloud (VPC) firewall at a time.
        
        @param request: BatchDeleteVpcFirewallControlPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: BatchDeleteVpcFirewallControlPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_uuid_list):
            query['AclUuidList'] = request.acl_uuid_list
        if not UtilClient.is_unset(request.vpc_firewall_id):
            query['VpcFirewallId'] = request.vpc_firewall_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='BatchDeleteVpcFirewallControlPolicy',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.BatchDeleteVpcFirewallControlPolicyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def batch_delete_vpc_firewall_control_policy(
        self,
        request: cloudfw_20171207_models.BatchDeleteVpcFirewallControlPolicyRequest,
    ) -> cloudfw_20171207_models.BatchDeleteVpcFirewallControlPolicyResponse:
        """
        @summary Deletes multiple access control policies for a virtual private cloud (VPC) firewall at a time.
        
        @param request: BatchDeleteVpcFirewallControlPolicyRequest
        @return: BatchDeleteVpcFirewallControlPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.batch_delete_vpc_firewall_control_policy_with_options(request, runtime)

    async def batch_delete_vpc_firewall_control_policy_async(
        self,
        request: cloudfw_20171207_models.BatchDeleteVpcFirewallControlPolicyRequest,
    ) -> cloudfw_20171207_models.BatchDeleteVpcFirewallControlPolicyResponse:
        """
        @summary Deletes multiple access control policies for a virtual private cloud (VPC) firewall at a time.
        
        @param request: BatchDeleteVpcFirewallControlPolicyRequest
        @return: BatchDeleteVpcFirewallControlPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.batch_delete_vpc_firewall_control_policy_with_options_async(request, runtime)

    def clear_log_store_storage_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.ClearLogStoreStorageResponse:
        """
        @summary 清空防火墙日志
        
        @param request: ClearLogStoreStorageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ClearLogStoreStorageResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='ClearLogStoreStorage',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.ClearLogStoreStorageResponse(),
            self.call_api(params, req, runtime)
        )

    async def clear_log_store_storage_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.ClearLogStoreStorageResponse:
        """
        @summary 清空防火墙日志
        
        @param request: ClearLogStoreStorageRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: ClearLogStoreStorageResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='ClearLogStoreStorage',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.ClearLogStoreStorageResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def clear_log_store_storage(self) -> cloudfw_20171207_models.ClearLogStoreStorageResponse:
        """
        @summary 清空防火墙日志
        
        @return: ClearLogStoreStorageResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.clear_log_store_storage_with_options(runtime)

    async def clear_log_store_storage_async(self) -> cloudfw_20171207_models.ClearLogStoreStorageResponse:
        """
        @summary 清空防火墙日志
        
        @return: ClearLogStoreStorageResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.clear_log_store_storage_with_options_async(runtime)

    def create_ack_cluster_connector_with_options(
        self,
        request: cloudfw_20171207_models.CreateAckClusterConnectorRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.CreateAckClusterConnectorResponse:
        """
        @summary 创建ACK集群连接器
        
        @param request: CreateAckClusterConnectorRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateAckClusterConnectorResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.connector_name):
            query['ConnectorName'] = request.connector_name
        if not UtilClient.is_unset(request.member_uid):
            query['MemberUid'] = request.member_uid
        if not UtilClient.is_unset(request.primary_vswitch_id):
            query['PrimaryVswitchId'] = request.primary_vswitch_id
        if not UtilClient.is_unset(request.primary_vswitch_ip):
            query['PrimaryVswitchIp'] = request.primary_vswitch_ip
        if not UtilClient.is_unset(request.region_no):
            query['RegionNo'] = request.region_no
        if not UtilClient.is_unset(request.standby_vswitch_id):
            query['StandbyVswitchId'] = request.standby_vswitch_id
        if not UtilClient.is_unset(request.standby_vswitch_ip):
            query['StandbyVswitchIp'] = request.standby_vswitch_ip
        if not UtilClient.is_unset(request.ttl):
            query['Ttl'] = request.ttl
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateAckClusterConnector',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.CreateAckClusterConnectorResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_ack_cluster_connector_with_options_async(
        self,
        request: cloudfw_20171207_models.CreateAckClusterConnectorRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.CreateAckClusterConnectorResponse:
        """
        @summary 创建ACK集群连接器
        
        @param request: CreateAckClusterConnectorRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateAckClusterConnectorResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.connector_name):
            query['ConnectorName'] = request.connector_name
        if not UtilClient.is_unset(request.member_uid):
            query['MemberUid'] = request.member_uid
        if not UtilClient.is_unset(request.primary_vswitch_id):
            query['PrimaryVswitchId'] = request.primary_vswitch_id
        if not UtilClient.is_unset(request.primary_vswitch_ip):
            query['PrimaryVswitchIp'] = request.primary_vswitch_ip
        if not UtilClient.is_unset(request.region_no):
            query['RegionNo'] = request.region_no
        if not UtilClient.is_unset(request.standby_vswitch_id):
            query['StandbyVswitchId'] = request.standby_vswitch_id
        if not UtilClient.is_unset(request.standby_vswitch_ip):
            query['StandbyVswitchIp'] = request.standby_vswitch_ip
        if not UtilClient.is_unset(request.ttl):
            query['Ttl'] = request.ttl
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateAckClusterConnector',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.CreateAckClusterConnectorResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_ack_cluster_connector(
        self,
        request: cloudfw_20171207_models.CreateAckClusterConnectorRequest,
    ) -> cloudfw_20171207_models.CreateAckClusterConnectorResponse:
        """
        @summary 创建ACK集群连接器
        
        @param request: CreateAckClusterConnectorRequest
        @return: CreateAckClusterConnectorResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_ack_cluster_connector_with_options(request, runtime)

    async def create_ack_cluster_connector_async(
        self,
        request: cloudfw_20171207_models.CreateAckClusterConnectorRequest,
    ) -> cloudfw_20171207_models.CreateAckClusterConnectorResponse:
        """
        @summary 创建ACK集群连接器
        
        @param request: CreateAckClusterConnectorRequest
        @return: CreateAckClusterConnectorResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_ack_cluster_connector_with_options_async(request, runtime)

    def create_acl_check_with_options(
        self,
        request: cloudfw_20171207_models.CreateAclCheckRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.CreateAclCheckResponse:
        """
        @summary 创建ACL检查
        
        @param request: CreateAclCheckRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateAclCheckResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_type):
            query['AclType'] = request.acl_type
        if not UtilClient.is_unset(request.check_names):
            query['CheckNames'] = request.check_names
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateAclCheck',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.CreateAclCheckResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_acl_check_with_options_async(
        self,
        request: cloudfw_20171207_models.CreateAclCheckRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.CreateAclCheckResponse:
        """
        @summary 创建ACL检查
        
        @param request: CreateAclCheckRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateAclCheckResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_type):
            query['AclType'] = request.acl_type
        if not UtilClient.is_unset(request.check_names):
            query['CheckNames'] = request.check_names
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateAclCheck',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.CreateAclCheckResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_acl_check(
        self,
        request: cloudfw_20171207_models.CreateAclCheckRequest,
    ) -> cloudfw_20171207_models.CreateAclCheckResponse:
        """
        @summary 创建ACL检查
        
        @param request: CreateAclCheckRequest
        @return: CreateAclCheckResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_acl_check_with_options(request, runtime)

    async def create_acl_check_async(
        self,
        request: cloudfw_20171207_models.CreateAclCheckRequest,
    ) -> cloudfw_20171207_models.CreateAclCheckResponse:
        """
        @summary 创建ACL检查
        
        @param request: CreateAclCheckRequest
        @return: CreateAclCheckResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_acl_check_with_options_async(request, runtime)

    def create_download_task_with_options(
        self,
        request: cloudfw_20171207_models.CreateDownloadTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.CreateDownloadTaskResponse:
        """
        @summary Creates a file download task.
        
        @param request: CreateDownloadTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDownloadTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.task_data):
            query['TaskData'] = request.task_data
        if not UtilClient.is_unset(request.task_type):
            query['TaskType'] = request.task_type
        if not UtilClient.is_unset(request.time_zone):
            query['TimeZone'] = request.time_zone
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDownloadTask',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.CreateDownloadTaskResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_download_task_with_options_async(
        self,
        request: cloudfw_20171207_models.CreateDownloadTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.CreateDownloadTaskResponse:
        """
        @summary Creates a file download task.
        
        @param request: CreateDownloadTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateDownloadTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.task_data):
            query['TaskData'] = request.task_data
        if not UtilClient.is_unset(request.task_type):
            query['TaskType'] = request.task_type
        if not UtilClient.is_unset(request.time_zone):
            query['TimeZone'] = request.time_zone
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateDownloadTask',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.CreateDownloadTaskResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_download_task(
        self,
        request: cloudfw_20171207_models.CreateDownloadTaskRequest,
    ) -> cloudfw_20171207_models.CreateDownloadTaskResponse:
        """
        @summary Creates a file download task.
        
        @param request: CreateDownloadTaskRequest
        @return: CreateDownloadTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_download_task_with_options(request, runtime)

    async def create_download_task_async(
        self,
        request: cloudfw_20171207_models.CreateDownloadTaskRequest,
    ) -> cloudfw_20171207_models.CreateDownloadTaskResponse:
        """
        @summary Creates a file download task.
        
        @param request: CreateDownloadTaskRequest
        @return: CreateDownloadTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_download_task_with_options_async(request, runtime)

    def create_instance_sync_task_with_options(
        self,
        request: cloudfw_20171207_models.CreateInstanceSyncTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.CreateInstanceSyncTaskResponse:
        """
        @summary 创建实例资产同步任务
        
        @param request: CreateInstanceSyncTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateInstanceSyncTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateInstanceSyncTask',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.CreateInstanceSyncTaskResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_instance_sync_task_with_options_async(
        self,
        request: cloudfw_20171207_models.CreateInstanceSyncTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.CreateInstanceSyncTaskResponse:
        """
        @summary 创建实例资产同步任务
        
        @param request: CreateInstanceSyncTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateInstanceSyncTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateInstanceSyncTask',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.CreateInstanceSyncTaskResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_instance_sync_task(
        self,
        request: cloudfw_20171207_models.CreateInstanceSyncTaskRequest,
    ) -> cloudfw_20171207_models.CreateInstanceSyncTaskResponse:
        """
        @summary 创建实例资产同步任务
        
        @param request: CreateInstanceSyncTaskRequest
        @return: CreateInstanceSyncTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_instance_sync_task_with_options(request, runtime)

    async def create_instance_sync_task_async(
        self,
        request: cloudfw_20171207_models.CreateInstanceSyncTaskRequest,
    ) -> cloudfw_20171207_models.CreateInstanceSyncTaskResponse:
        """
        @summary 创建实例资产同步任务
        
        @param request: CreateInstanceSyncTaskRequest
        @return: CreateInstanceSyncTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_instance_sync_task_with_options_async(request, runtime)

    def create_ips_private_assoc_with_options(
        self,
        request: cloudfw_20171207_models.CreateIpsPrivateAssocRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.CreateIpsPrivateAssocResponse:
        """
        @summary 创建IPS私网关联信息
        
        @param request: CreateIpsPrivateAssocRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateIpsPrivateAssocResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.resource_id):
            query['ResourceId'] = request.resource_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateIpsPrivateAssoc',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.CreateIpsPrivateAssocResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_ips_private_assoc_with_options_async(
        self,
        request: cloudfw_20171207_models.CreateIpsPrivateAssocRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.CreateIpsPrivateAssocResponse:
        """
        @summary 创建IPS私网关联信息
        
        @param request: CreateIpsPrivateAssocRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateIpsPrivateAssocResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.resource_id):
            query['ResourceId'] = request.resource_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateIpsPrivateAssoc',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.CreateIpsPrivateAssocResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_ips_private_assoc(
        self,
        request: cloudfw_20171207_models.CreateIpsPrivateAssocRequest,
    ) -> cloudfw_20171207_models.CreateIpsPrivateAssocResponse:
        """
        @summary 创建IPS私网关联信息
        
        @param request: CreateIpsPrivateAssocRequest
        @return: CreateIpsPrivateAssocResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_ips_private_assoc_with_options(request, runtime)

    async def create_ips_private_assoc_async(
        self,
        request: cloudfw_20171207_models.CreateIpsPrivateAssocRequest,
    ) -> cloudfw_20171207_models.CreateIpsPrivateAssocResponse:
        """
        @summary 创建IPS私网关联信息
        
        @param request: CreateIpsPrivateAssocRequest
        @return: CreateIpsPrivateAssocResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_ips_private_assoc_with_options_async(request, runtime)

    def create_nat_firewall_control_policy_with_options(
        self,
        request: cloudfw_20171207_models.CreateNatFirewallControlPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.CreateNatFirewallControlPolicyResponse:
        """
        @summary Creates an access control policy for a NAT firewall.
        
        @description You can call this operation to create a policy that allows, denies, or monitors the traffic that passes through the NAT firewall.
        
        @param request: CreateNatFirewallControlPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateNatFirewallControlPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_action):
            query['AclAction'] = request.acl_action
        if not UtilClient.is_unset(request.application_name_list):
            query['ApplicationNameList'] = request.application_name_list
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.dest_port):
            query['DestPort'] = request.dest_port
        if not UtilClient.is_unset(request.dest_port_group):
            query['DestPortGroup'] = request.dest_port_group
        if not UtilClient.is_unset(request.dest_port_type):
            query['DestPortType'] = request.dest_port_type
        if not UtilClient.is_unset(request.destination):
            query['Destination'] = request.destination
        if not UtilClient.is_unset(request.destination_type):
            query['DestinationType'] = request.destination_type
        if not UtilClient.is_unset(request.direction):
            query['Direction'] = request.direction
        if not UtilClient.is_unset(request.domain_resolve_type):
            query['DomainResolveType'] = request.domain_resolve_type
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.ip_version):
            query['IpVersion'] = request.ip_version
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.new_order):
            query['NewOrder'] = request.new_order
        if not UtilClient.is_unset(request.proto):
            query['Proto'] = request.proto
        if not UtilClient.is_unset(request.release):
            query['Release'] = request.release
        if not UtilClient.is_unset(request.repeat_days):
            query['RepeatDays'] = request.repeat_days
        if not UtilClient.is_unset(request.repeat_end_time):
            query['RepeatEndTime'] = request.repeat_end_time
        if not UtilClient.is_unset(request.repeat_start_time):
            query['RepeatStartTime'] = request.repeat_start_time
        if not UtilClient.is_unset(request.repeat_type):
            query['RepeatType'] = request.repeat_type
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        if not UtilClient.is_unset(request.source_type):
            query['SourceType'] = request.source_type
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateNatFirewallControlPolicy',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.CreateNatFirewallControlPolicyResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_nat_firewall_control_policy_with_options_async(
        self,
        request: cloudfw_20171207_models.CreateNatFirewallControlPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.CreateNatFirewallControlPolicyResponse:
        """
        @summary Creates an access control policy for a NAT firewall.
        
        @description You can call this operation to create a policy that allows, denies, or monitors the traffic that passes through the NAT firewall.
        
        @param request: CreateNatFirewallControlPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateNatFirewallControlPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_action):
            query['AclAction'] = request.acl_action
        if not UtilClient.is_unset(request.application_name_list):
            query['ApplicationNameList'] = request.application_name_list
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.dest_port):
            query['DestPort'] = request.dest_port
        if not UtilClient.is_unset(request.dest_port_group):
            query['DestPortGroup'] = request.dest_port_group
        if not UtilClient.is_unset(request.dest_port_type):
            query['DestPortType'] = request.dest_port_type
        if not UtilClient.is_unset(request.destination):
            query['Destination'] = request.destination
        if not UtilClient.is_unset(request.destination_type):
            query['DestinationType'] = request.destination_type
        if not UtilClient.is_unset(request.direction):
            query['Direction'] = request.direction
        if not UtilClient.is_unset(request.domain_resolve_type):
            query['DomainResolveType'] = request.domain_resolve_type
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.ip_version):
            query['IpVersion'] = request.ip_version
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.new_order):
            query['NewOrder'] = request.new_order
        if not UtilClient.is_unset(request.proto):
            query['Proto'] = request.proto
        if not UtilClient.is_unset(request.release):
            query['Release'] = request.release
        if not UtilClient.is_unset(request.repeat_days):
            query['RepeatDays'] = request.repeat_days
        if not UtilClient.is_unset(request.repeat_end_time):
            query['RepeatEndTime'] = request.repeat_end_time
        if not UtilClient.is_unset(request.repeat_start_time):
            query['RepeatStartTime'] = request.repeat_start_time
        if not UtilClient.is_unset(request.repeat_type):
            query['RepeatType'] = request.repeat_type
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        if not UtilClient.is_unset(request.source_type):
            query['SourceType'] = request.source_type
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateNatFirewallControlPolicy',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.CreateNatFirewallControlPolicyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_nat_firewall_control_policy(
        self,
        request: cloudfw_20171207_models.CreateNatFirewallControlPolicyRequest,
    ) -> cloudfw_20171207_models.CreateNatFirewallControlPolicyResponse:
        """
        @summary Creates an access control policy for a NAT firewall.
        
        @description You can call this operation to create a policy that allows, denies, or monitors the traffic that passes through the NAT firewall.
        
        @param request: CreateNatFirewallControlPolicyRequest
        @return: CreateNatFirewallControlPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_nat_firewall_control_policy_with_options(request, runtime)

    async def create_nat_firewall_control_policy_async(
        self,
        request: cloudfw_20171207_models.CreateNatFirewallControlPolicyRequest,
    ) -> cloudfw_20171207_models.CreateNatFirewallControlPolicyResponse:
        """
        @summary Creates an access control policy for a NAT firewall.
        
        @description You can call this operation to create a policy that allows, denies, or monitors the traffic that passes through the NAT firewall.
        
        @param request: CreateNatFirewallControlPolicyRequest
        @return: CreateNatFirewallControlPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_nat_firewall_control_policy_with_options_async(request, runtime)

    def create_nat_firewall_pre_check_with_options(
        self,
        request: cloudfw_20171207_models.CreateNatFirewallPreCheckRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.CreateNatFirewallPreCheckResponse:
        """
        @summary 创建NAT防火墙预检查
        
        @param request: CreateNatFirewallPreCheckRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateNatFirewallPreCheckResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        body = {}
        if not UtilClient.is_unset(request.nat_gateway_id):
            body['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.region_no):
            body['RegionNo'] = request.region_no
        if not UtilClient.is_unset(request.vpc_id):
            body['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateNatFirewallPreCheck',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.CreateNatFirewallPreCheckResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_nat_firewall_pre_check_with_options_async(
        self,
        request: cloudfw_20171207_models.CreateNatFirewallPreCheckRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.CreateNatFirewallPreCheckResponse:
        """
        @summary 创建NAT防火墙预检查
        
        @param request: CreateNatFirewallPreCheckRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateNatFirewallPreCheckResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        body = {}
        if not UtilClient.is_unset(request.nat_gateway_id):
            body['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.region_no):
            body['RegionNo'] = request.region_no
        if not UtilClient.is_unset(request.vpc_id):
            body['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query),
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateNatFirewallPreCheck',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.CreateNatFirewallPreCheckResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_nat_firewall_pre_check(
        self,
        request: cloudfw_20171207_models.CreateNatFirewallPreCheckRequest,
    ) -> cloudfw_20171207_models.CreateNatFirewallPreCheckResponse:
        """
        @summary 创建NAT防火墙预检查
        
        @param request: CreateNatFirewallPreCheckRequest
        @return: CreateNatFirewallPreCheckResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_nat_firewall_pre_check_with_options(request, runtime)

    async def create_nat_firewall_pre_check_async(
        self,
        request: cloudfw_20171207_models.CreateNatFirewallPreCheckRequest,
    ) -> cloudfw_20171207_models.CreateNatFirewallPreCheckResponse:
        """
        @summary 创建NAT防火墙预检查
        
        @param request: CreateNatFirewallPreCheckRequest
        @return: CreateNatFirewallPreCheckResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_nat_firewall_pre_check_with_options_async(request, runtime)

    def create_nat_firewall_sync_task_with_options(
        self,
        request: cloudfw_20171207_models.CreateNatFirewallSyncTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.CreateNatFirewallSyncTaskResponse:
        """
        @summary 创建NAT防火墙资产同步任务
        
        @param request: CreateNatFirewallSyncTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateNatFirewallSyncTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateNatFirewallSyncTask',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.CreateNatFirewallSyncTaskResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_nat_firewall_sync_task_with_options_async(
        self,
        request: cloudfw_20171207_models.CreateNatFirewallSyncTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.CreateNatFirewallSyncTaskResponse:
        """
        @summary 创建NAT防火墙资产同步任务
        
        @param request: CreateNatFirewallSyncTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateNatFirewallSyncTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateNatFirewallSyncTask',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.CreateNatFirewallSyncTaskResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_nat_firewall_sync_task(
        self,
        request: cloudfw_20171207_models.CreateNatFirewallSyncTaskRequest,
    ) -> cloudfw_20171207_models.CreateNatFirewallSyncTaskResponse:
        """
        @summary 创建NAT防火墙资产同步任务
        
        @param request: CreateNatFirewallSyncTaskRequest
        @return: CreateNatFirewallSyncTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_nat_firewall_sync_task_with_options(request, runtime)

    async def create_nat_firewall_sync_task_async(
        self,
        request: cloudfw_20171207_models.CreateNatFirewallSyncTaskRequest,
    ) -> cloudfw_20171207_models.CreateNatFirewallSyncTaskResponse:
        """
        @summary 创建NAT防火墙资产同步任务
        
        @param request: CreateNatFirewallSyncTaskRequest
        @return: CreateNatFirewallSyncTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_nat_firewall_sync_task_with_options_async(request, runtime)

    def create_private_dns_endpoint_with_options(
        self,
        request: cloudfw_20171207_models.CreatePrivateDnsEndpointRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.CreatePrivateDnsEndpointResponse:
        """
        @summary 创建私网DNS终端节点
        
        @param request: CreatePrivateDnsEndpointRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreatePrivateDnsEndpointResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_instance_name):
            query['AccessInstanceName'] = request.access_instance_name
        if not UtilClient.is_unset(request.firewall_type):
            query['FirewallType'] = request.firewall_type
        if not UtilClient.is_unset(request.ip_protocol):
            query['IpProtocol'] = request.ip_protocol
        if not UtilClient.is_unset(request.member_uid):
            query['MemberUid'] = request.member_uid
        if not UtilClient.is_unset(request.port):
            query['Port'] = request.port
        if not UtilClient.is_unset(request.primary_dns):
            query['PrimaryDns'] = request.primary_dns
        if not UtilClient.is_unset(request.primary_vswitch_id):
            query['PrimaryVSwitchId'] = request.primary_vswitch_id
        if not UtilClient.is_unset(request.primary_vswitch_ip):
            query['PrimaryVSwitchIp'] = request.primary_vswitch_ip
        if not UtilClient.is_unset(request.private_dns_type):
            query['PrivateDnsType'] = request.private_dns_type
        if not UtilClient.is_unset(request.region_no):
            query['RegionNo'] = request.region_no
        if not UtilClient.is_unset(request.standby_dns):
            query['StandbyDns'] = request.standby_dns
        if not UtilClient.is_unset(request.standby_vswitch_id):
            query['StandbyVSwitchId'] = request.standby_vswitch_id
        if not UtilClient.is_unset(request.standby_vswitch_ip):
            query['StandbyVSwitchIp'] = request.standby_vswitch_ip
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreatePrivateDnsEndpoint',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.CreatePrivateDnsEndpointResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_private_dns_endpoint_with_options_async(
        self,
        request: cloudfw_20171207_models.CreatePrivateDnsEndpointRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.CreatePrivateDnsEndpointResponse:
        """
        @summary 创建私网DNS终端节点
        
        @param request: CreatePrivateDnsEndpointRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreatePrivateDnsEndpointResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_instance_name):
            query['AccessInstanceName'] = request.access_instance_name
        if not UtilClient.is_unset(request.firewall_type):
            query['FirewallType'] = request.firewall_type
        if not UtilClient.is_unset(request.ip_protocol):
            query['IpProtocol'] = request.ip_protocol
        if not UtilClient.is_unset(request.member_uid):
            query['MemberUid'] = request.member_uid
        if not UtilClient.is_unset(request.port):
            query['Port'] = request.port
        if not UtilClient.is_unset(request.primary_dns):
            query['PrimaryDns'] = request.primary_dns
        if not UtilClient.is_unset(request.primary_vswitch_id):
            query['PrimaryVSwitchId'] = request.primary_vswitch_id
        if not UtilClient.is_unset(request.primary_vswitch_ip):
            query['PrimaryVSwitchIp'] = request.primary_vswitch_ip
        if not UtilClient.is_unset(request.private_dns_type):
            query['PrivateDnsType'] = request.private_dns_type
        if not UtilClient.is_unset(request.region_no):
            query['RegionNo'] = request.region_no
        if not UtilClient.is_unset(request.standby_dns):
            query['StandbyDns'] = request.standby_dns
        if not UtilClient.is_unset(request.standby_vswitch_id):
            query['StandbyVSwitchId'] = request.standby_vswitch_id
        if not UtilClient.is_unset(request.standby_vswitch_ip):
            query['StandbyVSwitchIp'] = request.standby_vswitch_ip
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreatePrivateDnsEndpoint',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.CreatePrivateDnsEndpointResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_private_dns_endpoint(
        self,
        request: cloudfw_20171207_models.CreatePrivateDnsEndpointRequest,
    ) -> cloudfw_20171207_models.CreatePrivateDnsEndpointResponse:
        """
        @summary 创建私网DNS终端节点
        
        @param request: CreatePrivateDnsEndpointRequest
        @return: CreatePrivateDnsEndpointResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_private_dns_endpoint_with_options(request, runtime)

    async def create_private_dns_endpoint_async(
        self,
        request: cloudfw_20171207_models.CreatePrivateDnsEndpointRequest,
    ) -> cloudfw_20171207_models.CreatePrivateDnsEndpointResponse:
        """
        @summary 创建私网DNS终端节点
        
        @param request: CreatePrivateDnsEndpointRequest
        @return: CreatePrivateDnsEndpointResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_private_dns_endpoint_with_options_async(request, runtime)

    def create_security_proxy_with_options(
        self,
        request: cloudfw_20171207_models.CreateSecurityProxyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.CreateSecurityProxyResponse:
        """
        @summary Creates a NAT firewall.
        
        @param request: CreateSecurityProxyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSecurityProxyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.firewall_switch):
            query['FirewallSwitch'] = request.firewall_switch
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.nat_route_entry_list):
            query['NatRouteEntryList'] = request.nat_route_entry_list
        if not UtilClient.is_unset(request.proxy_name):
            query['ProxyName'] = request.proxy_name
        if not UtilClient.is_unset(request.region_no):
            query['RegionNo'] = request.region_no
        if not UtilClient.is_unset(request.strict_mode):
            query['StrictMode'] = request.strict_mode
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        if not UtilClient.is_unset(request.vswitch_auto):
            query['VswitchAuto'] = request.vswitch_auto
        if not UtilClient.is_unset(request.vswitch_cidr):
            query['VswitchCidr'] = request.vswitch_cidr
        if not UtilClient.is_unset(request.vswitch_id):
            query['VswitchId'] = request.vswitch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSecurityProxy',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.CreateSecurityProxyResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_security_proxy_with_options_async(
        self,
        request: cloudfw_20171207_models.CreateSecurityProxyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.CreateSecurityProxyResponse:
        """
        @summary Creates a NAT firewall.
        
        @param request: CreateSecurityProxyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSecurityProxyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.firewall_switch):
            query['FirewallSwitch'] = request.firewall_switch
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.nat_route_entry_list):
            query['NatRouteEntryList'] = request.nat_route_entry_list
        if not UtilClient.is_unset(request.proxy_name):
            query['ProxyName'] = request.proxy_name
        if not UtilClient.is_unset(request.region_no):
            query['RegionNo'] = request.region_no
        if not UtilClient.is_unset(request.strict_mode):
            query['StrictMode'] = request.strict_mode
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        if not UtilClient.is_unset(request.vswitch_auto):
            query['VswitchAuto'] = request.vswitch_auto
        if not UtilClient.is_unset(request.vswitch_cidr):
            query['VswitchCidr'] = request.vswitch_cidr
        if not UtilClient.is_unset(request.vswitch_id):
            query['VswitchId'] = request.vswitch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateSecurityProxy',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.CreateSecurityProxyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_security_proxy(
        self,
        request: cloudfw_20171207_models.CreateSecurityProxyRequest,
    ) -> cloudfw_20171207_models.CreateSecurityProxyResponse:
        """
        @summary Creates a NAT firewall.
        
        @param request: CreateSecurityProxyRequest
        @return: CreateSecurityProxyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_security_proxy_with_options(request, runtime)

    async def create_security_proxy_async(
        self,
        request: cloudfw_20171207_models.CreateSecurityProxyRequest,
    ) -> cloudfw_20171207_models.CreateSecurityProxyResponse:
        """
        @summary Creates a NAT firewall.
        
        @param request: CreateSecurityProxyRequest
        @return: CreateSecurityProxyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_security_proxy_with_options_async(request, runtime)

    def create_sls_log_dispatch_with_options(
        self,
        request: cloudfw_20171207_models.CreateSlsLogDispatchRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.CreateSlsLogDispatchResponse:
        """
        @summary Create Cloud Firewall SLS Log Delivery
        
        @param request: CreateSlsLogDispatchRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSlsLogDispatchResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.sls_region_id):
            body['SlsRegionId'] = request.sls_region_id
        if not UtilClient.is_unset(request.ttl):
            body['Ttl'] = request.ttl
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateSlsLogDispatch',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.CreateSlsLogDispatchResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_sls_log_dispatch_with_options_async(
        self,
        request: cloudfw_20171207_models.CreateSlsLogDispatchRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.CreateSlsLogDispatchResponse:
        """
        @summary Create Cloud Firewall SLS Log Delivery
        
        @param request: CreateSlsLogDispatchRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateSlsLogDispatchResponse
        """
        UtilClient.validate_model(request)
        body = {}
        if not UtilClient.is_unset(request.sls_region_id):
            body['SlsRegionId'] = request.sls_region_id
        if not UtilClient.is_unset(request.ttl):
            body['Ttl'] = request.ttl
        req = open_api_models.OpenApiRequest(
            body=OpenApiUtilClient.parse_to_map(body)
        )
        params = open_api_models.Params(
            action='CreateSlsLogDispatch',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.CreateSlsLogDispatchResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_sls_log_dispatch(
        self,
        request: cloudfw_20171207_models.CreateSlsLogDispatchRequest,
    ) -> cloudfw_20171207_models.CreateSlsLogDispatchResponse:
        """
        @summary Create Cloud Firewall SLS Log Delivery
        
        @param request: CreateSlsLogDispatchRequest
        @return: CreateSlsLogDispatchResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_sls_log_dispatch_with_options(request, runtime)

    async def create_sls_log_dispatch_async(
        self,
        request: cloudfw_20171207_models.CreateSlsLogDispatchRequest,
    ) -> cloudfw_20171207_models.CreateSlsLogDispatchResponse:
        """
        @summary Create Cloud Firewall SLS Log Delivery
        
        @param request: CreateSlsLogDispatchRequest
        @return: CreateSlsLogDispatchResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_sls_log_dispatch_with_options_async(request, runtime)

    def create_tr_firewall_v2with_options(
        self,
        request: cloudfw_20171207_models.CreateTrFirewallV2Request,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.CreateTrFirewallV2Response:
        """
        @summary Creates a virtual private cloud (VPC) firewall for a transit router.
        
        @param request: CreateTrFirewallV2Request
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateTrFirewallV2Response
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cen_id):
            query['CenId'] = request.cen_id
        if not UtilClient.is_unset(request.firewall_description):
            query['FirewallDescription'] = request.firewall_description
        if not UtilClient.is_unset(request.firewall_name):
            query['FirewallName'] = request.firewall_name
        if not UtilClient.is_unset(request.firewall_subnet_cidr):
            query['FirewallSubnetCidr'] = request.firewall_subnet_cidr
        if not UtilClient.is_unset(request.firewall_vpc_cidr):
            query['FirewallVpcCidr'] = request.firewall_vpc_cidr
        if not UtilClient.is_unset(request.firewall_vpc_id):
            query['FirewallVpcId'] = request.firewall_vpc_id
        if not UtilClient.is_unset(request.firewall_vswitch_id):
            query['FirewallVswitchId'] = request.firewall_vswitch_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.region_no):
            query['RegionNo'] = request.region_no
        if not UtilClient.is_unset(request.route_mode):
            query['RouteMode'] = request.route_mode
        if not UtilClient.is_unset(request.tr_attachment_master_cidr):
            query['TrAttachmentMasterCidr'] = request.tr_attachment_master_cidr
        if not UtilClient.is_unset(request.tr_attachment_master_zone):
            query['TrAttachmentMasterZone'] = request.tr_attachment_master_zone
        if not UtilClient.is_unset(request.tr_attachment_slave_cidr):
            query['TrAttachmentSlaveCidr'] = request.tr_attachment_slave_cidr
        if not UtilClient.is_unset(request.tr_attachment_slave_zone):
            query['TrAttachmentSlaveZone'] = request.tr_attachment_slave_zone
        if not UtilClient.is_unset(request.transit_router_id):
            query['TransitRouterId'] = request.transit_router_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateTrFirewallV2',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.CreateTrFirewallV2Response(),
            self.call_api(params, req, runtime)
        )

    async def create_tr_firewall_v2with_options_async(
        self,
        request: cloudfw_20171207_models.CreateTrFirewallV2Request,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.CreateTrFirewallV2Response:
        """
        @summary Creates a virtual private cloud (VPC) firewall for a transit router.
        
        @param request: CreateTrFirewallV2Request
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateTrFirewallV2Response
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cen_id):
            query['CenId'] = request.cen_id
        if not UtilClient.is_unset(request.firewall_description):
            query['FirewallDescription'] = request.firewall_description
        if not UtilClient.is_unset(request.firewall_name):
            query['FirewallName'] = request.firewall_name
        if not UtilClient.is_unset(request.firewall_subnet_cidr):
            query['FirewallSubnetCidr'] = request.firewall_subnet_cidr
        if not UtilClient.is_unset(request.firewall_vpc_cidr):
            query['FirewallVpcCidr'] = request.firewall_vpc_cidr
        if not UtilClient.is_unset(request.firewall_vpc_id):
            query['FirewallVpcId'] = request.firewall_vpc_id
        if not UtilClient.is_unset(request.firewall_vswitch_id):
            query['FirewallVswitchId'] = request.firewall_vswitch_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.region_no):
            query['RegionNo'] = request.region_no
        if not UtilClient.is_unset(request.route_mode):
            query['RouteMode'] = request.route_mode
        if not UtilClient.is_unset(request.tr_attachment_master_cidr):
            query['TrAttachmentMasterCidr'] = request.tr_attachment_master_cidr
        if not UtilClient.is_unset(request.tr_attachment_master_zone):
            query['TrAttachmentMasterZone'] = request.tr_attachment_master_zone
        if not UtilClient.is_unset(request.tr_attachment_slave_cidr):
            query['TrAttachmentSlaveCidr'] = request.tr_attachment_slave_cidr
        if not UtilClient.is_unset(request.tr_attachment_slave_zone):
            query['TrAttachmentSlaveZone'] = request.tr_attachment_slave_zone
        if not UtilClient.is_unset(request.transit_router_id):
            query['TransitRouterId'] = request.transit_router_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateTrFirewallV2',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.CreateTrFirewallV2Response(),
            await self.call_api_async(params, req, runtime)
        )

    def create_tr_firewall_v2(
        self,
        request: cloudfw_20171207_models.CreateTrFirewallV2Request,
    ) -> cloudfw_20171207_models.CreateTrFirewallV2Response:
        """
        @summary Creates a virtual private cloud (VPC) firewall for a transit router.
        
        @param request: CreateTrFirewallV2Request
        @return: CreateTrFirewallV2Response
        """
        runtime = util_models.RuntimeOptions()
        return self.create_tr_firewall_v2with_options(request, runtime)

    async def create_tr_firewall_v2_async(
        self,
        request: cloudfw_20171207_models.CreateTrFirewallV2Request,
    ) -> cloudfw_20171207_models.CreateTrFirewallV2Response:
        """
        @summary Creates a virtual private cloud (VPC) firewall for a transit router.
        
        @param request: CreateTrFirewallV2Request
        @return: CreateTrFirewallV2Response
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_tr_firewall_v2with_options_async(request, runtime)

    def create_tr_firewall_v2route_policy_with_options(
        self,
        tmp_req: cloudfw_20171207_models.CreateTrFirewallV2RoutePolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.CreateTrFirewallV2RoutePolicyResponse:
        """
        @summary Creates a routing policy for a VPC firewall of a transit router.
        
        @param tmp_req: CreateTrFirewallV2RoutePolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateTrFirewallV2RoutePolicyResponse
        """
        UtilClient.validate_model(tmp_req)
        request = cloudfw_20171207_models.CreateTrFirewallV2RoutePolicyShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.dest_candidate_list):
            request.dest_candidate_list_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.dest_candidate_list, 'DestCandidateList', 'json')
        if not UtilClient.is_unset(tmp_req.src_candidate_list):
            request.src_candidate_list_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.src_candidate_list, 'SrcCandidateList', 'json')
        query = {}
        if not UtilClient.is_unset(request.dest_candidate_list_shrink):
            query['DestCandidateList'] = request.dest_candidate_list_shrink
        if not UtilClient.is_unset(request.firewall_id):
            query['FirewallId'] = request.firewall_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.policy_description):
            query['PolicyDescription'] = request.policy_description
        if not UtilClient.is_unset(request.policy_name):
            query['PolicyName'] = request.policy_name
        if not UtilClient.is_unset(request.policy_type):
            query['PolicyType'] = request.policy_type
        if not UtilClient.is_unset(request.src_candidate_list_shrink):
            query['SrcCandidateList'] = request.src_candidate_list_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateTrFirewallV2RoutePolicy',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.CreateTrFirewallV2RoutePolicyResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_tr_firewall_v2route_policy_with_options_async(
        self,
        tmp_req: cloudfw_20171207_models.CreateTrFirewallV2RoutePolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.CreateTrFirewallV2RoutePolicyResponse:
        """
        @summary Creates a routing policy for a VPC firewall of a transit router.
        
        @param tmp_req: CreateTrFirewallV2RoutePolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateTrFirewallV2RoutePolicyResponse
        """
        UtilClient.validate_model(tmp_req)
        request = cloudfw_20171207_models.CreateTrFirewallV2RoutePolicyShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.dest_candidate_list):
            request.dest_candidate_list_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.dest_candidate_list, 'DestCandidateList', 'json')
        if not UtilClient.is_unset(tmp_req.src_candidate_list):
            request.src_candidate_list_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.src_candidate_list, 'SrcCandidateList', 'json')
        query = {}
        if not UtilClient.is_unset(request.dest_candidate_list_shrink):
            query['DestCandidateList'] = request.dest_candidate_list_shrink
        if not UtilClient.is_unset(request.firewall_id):
            query['FirewallId'] = request.firewall_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.policy_description):
            query['PolicyDescription'] = request.policy_description
        if not UtilClient.is_unset(request.policy_name):
            query['PolicyName'] = request.policy_name
        if not UtilClient.is_unset(request.policy_type):
            query['PolicyType'] = request.policy_type
        if not UtilClient.is_unset(request.src_candidate_list_shrink):
            query['SrcCandidateList'] = request.src_candidate_list_shrink
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateTrFirewallV2RoutePolicy',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.CreateTrFirewallV2RoutePolicyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_tr_firewall_v2route_policy(
        self,
        request: cloudfw_20171207_models.CreateTrFirewallV2RoutePolicyRequest,
    ) -> cloudfw_20171207_models.CreateTrFirewallV2RoutePolicyResponse:
        """
        @summary Creates a routing policy for a VPC firewall of a transit router.
        
        @param request: CreateTrFirewallV2RoutePolicyRequest
        @return: CreateTrFirewallV2RoutePolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_tr_firewall_v2route_policy_with_options(request, runtime)

    async def create_tr_firewall_v2route_policy_async(
        self,
        request: cloudfw_20171207_models.CreateTrFirewallV2RoutePolicyRequest,
    ) -> cloudfw_20171207_models.CreateTrFirewallV2RoutePolicyResponse:
        """
        @summary Creates a routing policy for a VPC firewall of a transit router.
        
        @param request: CreateTrFirewallV2RoutePolicyRequest
        @return: CreateTrFirewallV2RoutePolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_tr_firewall_v2route_policy_with_options_async(request, runtime)

    def create_vpc_firewall_cen_configure_with_options(
        self,
        request: cloudfw_20171207_models.CreateVpcFirewallCenConfigureRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.CreateVpcFirewallCenConfigureResponse:
        """
        @summary Creates a virtual private cloud (VPC) firewall to protect traffic between a specified VPC and a network instance that is attached to a Cloud Enterprise Network (CEN) instance.
        
        @description You can call the CreateVpcFirewallCenConfigure operation to create a VPC firewall. The VPC firewall protects mutual access traffic between a specified VPC and a network instance that is attached to a CEN instance. The network instance can be a VPC, a virtual border router (VBR), or a Cloud Connect Network (CCN) instance. The VPC firewall cannot protect mutual access traffic between VBRs, between CCN instances, or between VBRs and CCN instances. For more information, see [VPC firewall limits](https://help.aliyun.com/document_detail/172295.html).
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: CreateVpcFirewallCenConfigureRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVpcFirewallCenConfigureResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cen_id):
            query['CenId'] = request.cen_id
        if not UtilClient.is_unset(request.firewall_switch):
            query['FirewallSwitch'] = request.firewall_switch
        if not UtilClient.is_unset(request.firewall_vswitch_cidr_block):
            query['FirewallVSwitchCidrBlock'] = request.firewall_vswitch_cidr_block
        if not UtilClient.is_unset(request.firewall_vpc_cidr_block):
            query['FirewallVpcCidrBlock'] = request.firewall_vpc_cidr_block
        if not UtilClient.is_unset(request.firewall_vpc_standby_zone_id):
            query['FirewallVpcStandbyZoneId'] = request.firewall_vpc_standby_zone_id
        if not UtilClient.is_unset(request.firewall_vpc_zone_id):
            query['FirewallVpcZoneId'] = request.firewall_vpc_zone_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.member_uid):
            query['MemberUid'] = request.member_uid
        if not UtilClient.is_unset(request.network_instance_id):
            query['NetworkInstanceId'] = request.network_instance_id
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        if not UtilClient.is_unset(request.vpc_firewall_name):
            query['VpcFirewallName'] = request.vpc_firewall_name
        if not UtilClient.is_unset(request.vpc_region):
            query['VpcRegion'] = request.vpc_region
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVpcFirewallCenConfigure',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.CreateVpcFirewallCenConfigureResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_vpc_firewall_cen_configure_with_options_async(
        self,
        request: cloudfw_20171207_models.CreateVpcFirewallCenConfigureRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.CreateVpcFirewallCenConfigureResponse:
        """
        @summary Creates a virtual private cloud (VPC) firewall to protect traffic between a specified VPC and a network instance that is attached to a Cloud Enterprise Network (CEN) instance.
        
        @description You can call the CreateVpcFirewallCenConfigure operation to create a VPC firewall. The VPC firewall protects mutual access traffic between a specified VPC and a network instance that is attached to a CEN instance. The network instance can be a VPC, a virtual border router (VBR), or a Cloud Connect Network (CCN) instance. The VPC firewall cannot protect mutual access traffic between VBRs, between CCN instances, or between VBRs and CCN instances. For more information, see [VPC firewall limits](https://help.aliyun.com/document_detail/172295.html).
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: CreateVpcFirewallCenConfigureRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVpcFirewallCenConfigureResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cen_id):
            query['CenId'] = request.cen_id
        if not UtilClient.is_unset(request.firewall_switch):
            query['FirewallSwitch'] = request.firewall_switch
        if not UtilClient.is_unset(request.firewall_vswitch_cidr_block):
            query['FirewallVSwitchCidrBlock'] = request.firewall_vswitch_cidr_block
        if not UtilClient.is_unset(request.firewall_vpc_cidr_block):
            query['FirewallVpcCidrBlock'] = request.firewall_vpc_cidr_block
        if not UtilClient.is_unset(request.firewall_vpc_standby_zone_id):
            query['FirewallVpcStandbyZoneId'] = request.firewall_vpc_standby_zone_id
        if not UtilClient.is_unset(request.firewall_vpc_zone_id):
            query['FirewallVpcZoneId'] = request.firewall_vpc_zone_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.member_uid):
            query['MemberUid'] = request.member_uid
        if not UtilClient.is_unset(request.network_instance_id):
            query['NetworkInstanceId'] = request.network_instance_id
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        if not UtilClient.is_unset(request.vpc_firewall_name):
            query['VpcFirewallName'] = request.vpc_firewall_name
        if not UtilClient.is_unset(request.vpc_region):
            query['VpcRegion'] = request.vpc_region
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVpcFirewallCenConfigure',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.CreateVpcFirewallCenConfigureResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_vpc_firewall_cen_configure(
        self,
        request: cloudfw_20171207_models.CreateVpcFirewallCenConfigureRequest,
    ) -> cloudfw_20171207_models.CreateVpcFirewallCenConfigureResponse:
        """
        @summary Creates a virtual private cloud (VPC) firewall to protect traffic between a specified VPC and a network instance that is attached to a Cloud Enterprise Network (CEN) instance.
        
        @description You can call the CreateVpcFirewallCenConfigure operation to create a VPC firewall. The VPC firewall protects mutual access traffic between a specified VPC and a network instance that is attached to a CEN instance. The network instance can be a VPC, a virtual border router (VBR), or a Cloud Connect Network (CCN) instance. The VPC firewall cannot protect mutual access traffic between VBRs, between CCN instances, or between VBRs and CCN instances. For more information, see [VPC firewall limits](https://help.aliyun.com/document_detail/172295.html).
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: CreateVpcFirewallCenConfigureRequest
        @return: CreateVpcFirewallCenConfigureResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_vpc_firewall_cen_configure_with_options(request, runtime)

    async def create_vpc_firewall_cen_configure_async(
        self,
        request: cloudfw_20171207_models.CreateVpcFirewallCenConfigureRequest,
    ) -> cloudfw_20171207_models.CreateVpcFirewallCenConfigureResponse:
        """
        @summary Creates a virtual private cloud (VPC) firewall to protect traffic between a specified VPC and a network instance that is attached to a Cloud Enterprise Network (CEN) instance.
        
        @description You can call the CreateVpcFirewallCenConfigure operation to create a VPC firewall. The VPC firewall protects mutual access traffic between a specified VPC and a network instance that is attached to a CEN instance. The network instance can be a VPC, a virtual border router (VBR), or a Cloud Connect Network (CCN) instance. The VPC firewall cannot protect mutual access traffic between VBRs, between CCN instances, or between VBRs and CCN instances. For more information, see [VPC firewall limits](https://help.aliyun.com/document_detail/172295.html).
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: CreateVpcFirewallCenConfigureRequest
        @return: CreateVpcFirewallCenConfigureResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_vpc_firewall_cen_configure_with_options_async(request, runtime)

    def create_vpc_firewall_cen_manual_configure_with_options(
        self,
        request: cloudfw_20171207_models.CreateVpcFirewallCenManualConfigureRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.CreateVpcFirewallCenManualConfigureResponse:
        """
        @deprecated OpenAPI CreateVpcFirewallCenManualConfigure is deprecated
        
        @summary 创建VPC防火墙手动配置
        
        @param request: CreateVpcFirewallCenManualConfigureRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVpcFirewallCenManualConfigureResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cen_id):
            query['CenId'] = request.cen_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.member_uid):
            query['MemberUid'] = request.member_uid
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        if not UtilClient.is_unset(request.vpc_firewall_name):
            query['VpcFirewallName'] = request.vpc_firewall_name
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVpcFirewallCenManualConfigure',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.CreateVpcFirewallCenManualConfigureResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_vpc_firewall_cen_manual_configure_with_options_async(
        self,
        request: cloudfw_20171207_models.CreateVpcFirewallCenManualConfigureRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.CreateVpcFirewallCenManualConfigureResponse:
        """
        @deprecated OpenAPI CreateVpcFirewallCenManualConfigure is deprecated
        
        @summary 创建VPC防火墙手动配置
        
        @param request: CreateVpcFirewallCenManualConfigureRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVpcFirewallCenManualConfigureResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cen_id):
            query['CenId'] = request.cen_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.member_uid):
            query['MemberUid'] = request.member_uid
        if not UtilClient.is_unset(request.v_switch_id):
            query['VSwitchId'] = request.v_switch_id
        if not UtilClient.is_unset(request.vpc_firewall_name):
            query['VpcFirewallName'] = request.vpc_firewall_name
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVpcFirewallCenManualConfigure',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.CreateVpcFirewallCenManualConfigureResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_vpc_firewall_cen_manual_configure(
        self,
        request: cloudfw_20171207_models.CreateVpcFirewallCenManualConfigureRequest,
    ) -> cloudfw_20171207_models.CreateVpcFirewallCenManualConfigureResponse:
        """
        @deprecated OpenAPI CreateVpcFirewallCenManualConfigure is deprecated
        
        @summary 创建VPC防火墙手动配置
        
        @param request: CreateVpcFirewallCenManualConfigureRequest
        @return: CreateVpcFirewallCenManualConfigureResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.create_vpc_firewall_cen_manual_configure_with_options(request, runtime)

    async def create_vpc_firewall_cen_manual_configure_async(
        self,
        request: cloudfw_20171207_models.CreateVpcFirewallCenManualConfigureRequest,
    ) -> cloudfw_20171207_models.CreateVpcFirewallCenManualConfigureResponse:
        """
        @deprecated OpenAPI CreateVpcFirewallCenManualConfigure is deprecated
        
        @summary 创建VPC防火墙手动配置
        
        @param request: CreateVpcFirewallCenManualConfigureRequest
        @return: CreateVpcFirewallCenManualConfigureResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_vpc_firewall_cen_manual_configure_with_options_async(request, runtime)

    def create_vpc_firewall_configure_with_options(
        self,
        request: cloudfw_20171207_models.CreateVpcFirewallConfigureRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.CreateVpcFirewallConfigureResponse:
        """
        @summary Creates a Virtual Private Cloud (VPC) firewall to protect traffic between two VPCs that are connected by using an Express Connect.
        
        @description You can call this operation to create a VPC firewall. The VPC firewall controls traffic between two VPCs that are connected by using an Express Connect circuit. The VPC firewall does not control the mutual access traffic between VPCs that reside in different regions or belong to different Alibaba Cloud accounts. The firewall also does not control the mutual access traffic between VPCs and virtual border routers (VBRs). For more information, see [VPC firewall limits](https://help.aliyun.com/document_detail/172295.html).
        ### [](#qps)QPS limit
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: CreateVpcFirewallConfigureRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVpcFirewallConfigureResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.firewall_switch):
            query['FirewallSwitch'] = request.firewall_switch
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.local_vpc_cidr_table_list):
            query['LocalVpcCidrTableList'] = request.local_vpc_cidr_table_list
        if not UtilClient.is_unset(request.local_vpc_id):
            query['LocalVpcId'] = request.local_vpc_id
        if not UtilClient.is_unset(request.local_vpc_region):
            query['LocalVpcRegion'] = request.local_vpc_region
        if not UtilClient.is_unset(request.member_uid):
            query['MemberUid'] = request.member_uid
        if not UtilClient.is_unset(request.peer_vpc_cidr_table_list):
            query['PeerVpcCidrTableList'] = request.peer_vpc_cidr_table_list
        if not UtilClient.is_unset(request.peer_vpc_id):
            query['PeerVpcId'] = request.peer_vpc_id
        if not UtilClient.is_unset(request.peer_vpc_region):
            query['PeerVpcRegion'] = request.peer_vpc_region
        if not UtilClient.is_unset(request.vpc_firewall_name):
            query['VpcFirewallName'] = request.vpc_firewall_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVpcFirewallConfigure',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.CreateVpcFirewallConfigureResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_vpc_firewall_configure_with_options_async(
        self,
        request: cloudfw_20171207_models.CreateVpcFirewallConfigureRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.CreateVpcFirewallConfigureResponse:
        """
        @summary Creates a Virtual Private Cloud (VPC) firewall to protect traffic between two VPCs that are connected by using an Express Connect.
        
        @description You can call this operation to create a VPC firewall. The VPC firewall controls traffic between two VPCs that are connected by using an Express Connect circuit. The VPC firewall does not control the mutual access traffic between VPCs that reside in different regions or belong to different Alibaba Cloud accounts. The firewall also does not control the mutual access traffic between VPCs and virtual border routers (VBRs). For more information, see [VPC firewall limits](https://help.aliyun.com/document_detail/172295.html).
        ### [](#qps)QPS limit
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: CreateVpcFirewallConfigureRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVpcFirewallConfigureResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.firewall_switch):
            query['FirewallSwitch'] = request.firewall_switch
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.local_vpc_cidr_table_list):
            query['LocalVpcCidrTableList'] = request.local_vpc_cidr_table_list
        if not UtilClient.is_unset(request.local_vpc_id):
            query['LocalVpcId'] = request.local_vpc_id
        if not UtilClient.is_unset(request.local_vpc_region):
            query['LocalVpcRegion'] = request.local_vpc_region
        if not UtilClient.is_unset(request.member_uid):
            query['MemberUid'] = request.member_uid
        if not UtilClient.is_unset(request.peer_vpc_cidr_table_list):
            query['PeerVpcCidrTableList'] = request.peer_vpc_cidr_table_list
        if not UtilClient.is_unset(request.peer_vpc_id):
            query['PeerVpcId'] = request.peer_vpc_id
        if not UtilClient.is_unset(request.peer_vpc_region):
            query['PeerVpcRegion'] = request.peer_vpc_region
        if not UtilClient.is_unset(request.vpc_firewall_name):
            query['VpcFirewallName'] = request.vpc_firewall_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVpcFirewallConfigure',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.CreateVpcFirewallConfigureResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_vpc_firewall_configure(
        self,
        request: cloudfw_20171207_models.CreateVpcFirewallConfigureRequest,
    ) -> cloudfw_20171207_models.CreateVpcFirewallConfigureResponse:
        """
        @summary Creates a Virtual Private Cloud (VPC) firewall to protect traffic between two VPCs that are connected by using an Express Connect.
        
        @description You can call this operation to create a VPC firewall. The VPC firewall controls traffic between two VPCs that are connected by using an Express Connect circuit. The VPC firewall does not control the mutual access traffic between VPCs that reside in different regions or belong to different Alibaba Cloud accounts. The firewall also does not control the mutual access traffic between VPCs and virtual border routers (VBRs). For more information, see [VPC firewall limits](https://help.aliyun.com/document_detail/172295.html).
        ### [](#qps)QPS limit
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: CreateVpcFirewallConfigureRequest
        @return: CreateVpcFirewallConfigureResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_vpc_firewall_configure_with_options(request, runtime)

    async def create_vpc_firewall_configure_async(
        self,
        request: cloudfw_20171207_models.CreateVpcFirewallConfigureRequest,
    ) -> cloudfw_20171207_models.CreateVpcFirewallConfigureResponse:
        """
        @summary Creates a Virtual Private Cloud (VPC) firewall to protect traffic between two VPCs that are connected by using an Express Connect.
        
        @description You can call this operation to create a VPC firewall. The VPC firewall controls traffic between two VPCs that are connected by using an Express Connect circuit. The VPC firewall does not control the mutual access traffic between VPCs that reside in different regions or belong to different Alibaba Cloud accounts. The firewall also does not control the mutual access traffic between VPCs and virtual border routers (VBRs). For more information, see [VPC firewall limits](https://help.aliyun.com/document_detail/172295.html).
        ### [](#qps)QPS limit
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: CreateVpcFirewallConfigureRequest
        @return: CreateVpcFirewallConfigureResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_vpc_firewall_configure_with_options_async(request, runtime)

    def create_vpc_firewall_control_policy_with_options(
        self,
        request: cloudfw_20171207_models.CreateVpcFirewallControlPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.CreateVpcFirewallControlPolicyResponse:
        """
        @summary Creates an access control policy in a specified policy group for a virtual private cloud (VPC) firewall.
        
        @description You can call the CreateVpcFirewallControlPolicy operation to create an access control policy in a specified policy group for a VPC firewall. Different access control policies are used when a VPC firewall is used to protect traffic between two VPCs that are connected by using a Cloud Enterprise Network (CEN) instance or an Express Connect circuit.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: CreateVpcFirewallControlPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVpcFirewallControlPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_action):
            query['AclAction'] = request.acl_action
        if not UtilClient.is_unset(request.application_name):
            query['ApplicationName'] = request.application_name
        if not UtilClient.is_unset(request.application_name_list):
            query['ApplicationNameList'] = request.application_name_list
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.dest_port):
            query['DestPort'] = request.dest_port
        if not UtilClient.is_unset(request.dest_port_group):
            query['DestPortGroup'] = request.dest_port_group
        if not UtilClient.is_unset(request.dest_port_type):
            query['DestPortType'] = request.dest_port_type
        if not UtilClient.is_unset(request.destination):
            query['Destination'] = request.destination
        if not UtilClient.is_unset(request.destination_type):
            query['DestinationType'] = request.destination_type
        if not UtilClient.is_unset(request.domain_resolve_type):
            query['DomainResolveType'] = request.domain_resolve_type
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.member_uid):
            query['MemberUid'] = request.member_uid
        if not UtilClient.is_unset(request.new_order):
            query['NewOrder'] = request.new_order
        if not UtilClient.is_unset(request.proto):
            query['Proto'] = request.proto
        if not UtilClient.is_unset(request.release):
            query['Release'] = request.release
        if not UtilClient.is_unset(request.repeat_days):
            query['RepeatDays'] = request.repeat_days
        if not UtilClient.is_unset(request.repeat_end_time):
            query['RepeatEndTime'] = request.repeat_end_time
        if not UtilClient.is_unset(request.repeat_start_time):
            query['RepeatStartTime'] = request.repeat_start_time
        if not UtilClient.is_unset(request.repeat_type):
            query['RepeatType'] = request.repeat_type
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        if not UtilClient.is_unset(request.source_type):
            query['SourceType'] = request.source_type
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.vpc_firewall_id):
            query['VpcFirewallId'] = request.vpc_firewall_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVpcFirewallControlPolicy',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.CreateVpcFirewallControlPolicyResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_vpc_firewall_control_policy_with_options_async(
        self,
        request: cloudfw_20171207_models.CreateVpcFirewallControlPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.CreateVpcFirewallControlPolicyResponse:
        """
        @summary Creates an access control policy in a specified policy group for a virtual private cloud (VPC) firewall.
        
        @description You can call the CreateVpcFirewallControlPolicy operation to create an access control policy in a specified policy group for a VPC firewall. Different access control policies are used when a VPC firewall is used to protect traffic between two VPCs that are connected by using a Cloud Enterprise Network (CEN) instance or an Express Connect circuit.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: CreateVpcFirewallControlPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVpcFirewallControlPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_action):
            query['AclAction'] = request.acl_action
        if not UtilClient.is_unset(request.application_name):
            query['ApplicationName'] = request.application_name
        if not UtilClient.is_unset(request.application_name_list):
            query['ApplicationNameList'] = request.application_name_list
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.dest_port):
            query['DestPort'] = request.dest_port
        if not UtilClient.is_unset(request.dest_port_group):
            query['DestPortGroup'] = request.dest_port_group
        if not UtilClient.is_unset(request.dest_port_type):
            query['DestPortType'] = request.dest_port_type
        if not UtilClient.is_unset(request.destination):
            query['Destination'] = request.destination
        if not UtilClient.is_unset(request.destination_type):
            query['DestinationType'] = request.destination_type
        if not UtilClient.is_unset(request.domain_resolve_type):
            query['DomainResolveType'] = request.domain_resolve_type
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.member_uid):
            query['MemberUid'] = request.member_uid
        if not UtilClient.is_unset(request.new_order):
            query['NewOrder'] = request.new_order
        if not UtilClient.is_unset(request.proto):
            query['Proto'] = request.proto
        if not UtilClient.is_unset(request.release):
            query['Release'] = request.release
        if not UtilClient.is_unset(request.repeat_days):
            query['RepeatDays'] = request.repeat_days
        if not UtilClient.is_unset(request.repeat_end_time):
            query['RepeatEndTime'] = request.repeat_end_time
        if not UtilClient.is_unset(request.repeat_start_time):
            query['RepeatStartTime'] = request.repeat_start_time
        if not UtilClient.is_unset(request.repeat_type):
            query['RepeatType'] = request.repeat_type
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        if not UtilClient.is_unset(request.source_type):
            query['SourceType'] = request.source_type
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.vpc_firewall_id):
            query['VpcFirewallId'] = request.vpc_firewall_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVpcFirewallControlPolicy',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.CreateVpcFirewallControlPolicyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_vpc_firewall_control_policy(
        self,
        request: cloudfw_20171207_models.CreateVpcFirewallControlPolicyRequest,
    ) -> cloudfw_20171207_models.CreateVpcFirewallControlPolicyResponse:
        """
        @summary Creates an access control policy in a specified policy group for a virtual private cloud (VPC) firewall.
        
        @description You can call the CreateVpcFirewallControlPolicy operation to create an access control policy in a specified policy group for a VPC firewall. Different access control policies are used when a VPC firewall is used to protect traffic between two VPCs that are connected by using a Cloud Enterprise Network (CEN) instance or an Express Connect circuit.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: CreateVpcFirewallControlPolicyRequest
        @return: CreateVpcFirewallControlPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_vpc_firewall_control_policy_with_options(request, runtime)

    async def create_vpc_firewall_control_policy_async(
        self,
        request: cloudfw_20171207_models.CreateVpcFirewallControlPolicyRequest,
    ) -> cloudfw_20171207_models.CreateVpcFirewallControlPolicyResponse:
        """
        @summary Creates an access control policy in a specified policy group for a virtual private cloud (VPC) firewall.
        
        @description You can call the CreateVpcFirewallControlPolicy operation to create an access control policy in a specified policy group for a VPC firewall. Different access control policies are used when a VPC firewall is used to protect traffic between two VPCs that are connected by using a Cloud Enterprise Network (CEN) instance or an Express Connect circuit.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: CreateVpcFirewallControlPolicyRequest
        @return: CreateVpcFirewallControlPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_vpc_firewall_control_policy_with_options_async(request, runtime)

    def create_vpc_firewall_precheck_with_options(
        self,
        request: cloudfw_20171207_models.CreateVpcFirewallPrecheckRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.CreateVpcFirewallPrecheckResponse:
        """
        @summary 创建VPC防火墙开墙前置任务
        
        @param request: CreateVpcFirewallPrecheckRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVpcFirewallPrecheckResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cen_id):
            query['CenId'] = request.cen_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.member_uid):
            query['MemberUid'] = request.member_uid
        if not UtilClient.is_unset(request.network_instance_type):
            query['NetworkInstanceType'] = request.network_instance_type
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.transit_router_id):
            query['TransitRouterId'] = request.transit_router_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVpcFirewallPrecheck',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.CreateVpcFirewallPrecheckResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_vpc_firewall_precheck_with_options_async(
        self,
        request: cloudfw_20171207_models.CreateVpcFirewallPrecheckRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.CreateVpcFirewallPrecheckResponse:
        """
        @summary 创建VPC防火墙开墙前置任务
        
        @param request: CreateVpcFirewallPrecheckRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVpcFirewallPrecheckResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cen_id):
            query['CenId'] = request.cen_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.member_uid):
            query['MemberUid'] = request.member_uid
        if not UtilClient.is_unset(request.network_instance_type):
            query['NetworkInstanceType'] = request.network_instance_type
        if not UtilClient.is_unset(request.region):
            query['Region'] = request.region
        if not UtilClient.is_unset(request.transit_router_id):
            query['TransitRouterId'] = request.transit_router_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVpcFirewallPrecheck',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.CreateVpcFirewallPrecheckResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_vpc_firewall_precheck(
        self,
        request: cloudfw_20171207_models.CreateVpcFirewallPrecheckRequest,
    ) -> cloudfw_20171207_models.CreateVpcFirewallPrecheckResponse:
        """
        @summary 创建VPC防火墙开墙前置任务
        
        @param request: CreateVpcFirewallPrecheckRequest
        @return: CreateVpcFirewallPrecheckResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_vpc_firewall_precheck_with_options(request, runtime)

    async def create_vpc_firewall_precheck_async(
        self,
        request: cloudfw_20171207_models.CreateVpcFirewallPrecheckRequest,
    ) -> cloudfw_20171207_models.CreateVpcFirewallPrecheckResponse:
        """
        @summary 创建VPC防火墙开墙前置任务
        
        @param request: CreateVpcFirewallPrecheckRequest
        @return: CreateVpcFirewallPrecheckResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_vpc_firewall_precheck_with_options_async(request, runtime)

    def create_vpc_firewall_task_with_options(
        self,
        request: cloudfw_20171207_models.CreateVpcFirewallTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.CreateVpcFirewallTaskResponse:
        """
        @summary 创建VPC防火墙资产同步任务
        
        @param request: CreateVpcFirewallTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVpcFirewallTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.content):
            query['Content'] = request.content
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.priority):
            query['Priority'] = request.priority
        if not UtilClient.is_unset(request.task_action):
            query['TaskAction'] = request.task_action
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVpcFirewallTask',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.CreateVpcFirewallTaskResponse(),
            self.call_api(params, req, runtime)
        )

    async def create_vpc_firewall_task_with_options_async(
        self,
        request: cloudfw_20171207_models.CreateVpcFirewallTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.CreateVpcFirewallTaskResponse:
        """
        @summary 创建VPC防火墙资产同步任务
        
        @param request: CreateVpcFirewallTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: CreateVpcFirewallTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.content):
            query['Content'] = request.content
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.priority):
            query['Priority'] = request.priority
        if not UtilClient.is_unset(request.task_action):
            query['TaskAction'] = request.task_action
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='CreateVpcFirewallTask',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.CreateVpcFirewallTaskResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def create_vpc_firewall_task(
        self,
        request: cloudfw_20171207_models.CreateVpcFirewallTaskRequest,
    ) -> cloudfw_20171207_models.CreateVpcFirewallTaskResponse:
        """
        @summary 创建VPC防火墙资产同步任务
        
        @param request: CreateVpcFirewallTaskRequest
        @return: CreateVpcFirewallTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.create_vpc_firewall_task_with_options(request, runtime)

    async def create_vpc_firewall_task_async(
        self,
        request: cloudfw_20171207_models.CreateVpcFirewallTaskRequest,
    ) -> cloudfw_20171207_models.CreateVpcFirewallTaskResponse:
        """
        @summary 创建VPC防火墙资产同步任务
        
        @param request: CreateVpcFirewallTaskRequest
        @return: CreateVpcFirewallTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.create_vpc_firewall_task_with_options_async(request, runtime)

    def delete_ack_cluster_connector_with_options(
        self,
        request: cloudfw_20171207_models.DeleteAckClusterConnectorRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DeleteAckClusterConnectorResponse:
        """
        @summary 删除ACK集群连接器
        
        @param request: DeleteAckClusterConnectorRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteAckClusterConnectorResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.connector_id):
            query['ConnectorId'] = request.connector_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteAckClusterConnector',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DeleteAckClusterConnectorResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_ack_cluster_connector_with_options_async(
        self,
        request: cloudfw_20171207_models.DeleteAckClusterConnectorRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DeleteAckClusterConnectorResponse:
        """
        @summary 删除ACK集群连接器
        
        @param request: DeleteAckClusterConnectorRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteAckClusterConnectorResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.connector_id):
            query['ConnectorId'] = request.connector_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteAckClusterConnector',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DeleteAckClusterConnectorResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_ack_cluster_connector(
        self,
        request: cloudfw_20171207_models.DeleteAckClusterConnectorRequest,
    ) -> cloudfw_20171207_models.DeleteAckClusterConnectorResponse:
        """
        @summary 删除ACK集群连接器
        
        @param request: DeleteAckClusterConnectorRequest
        @return: DeleteAckClusterConnectorResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_ack_cluster_connector_with_options(request, runtime)

    async def delete_ack_cluster_connector_async(
        self,
        request: cloudfw_20171207_models.DeleteAckClusterConnectorRequest,
    ) -> cloudfw_20171207_models.DeleteAckClusterConnectorResponse:
        """
        @summary 删除ACK集群连接器
        
        @param request: DeleteAckClusterConnectorRequest
        @return: DeleteAckClusterConnectorResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_ack_cluster_connector_with_options_async(request, runtime)

    def delete_acl_backup_data_with_options(
        self,
        request: cloudfw_20171207_models.DeleteAclBackupDataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DeleteAclBackupDataResponse:
        """
        @summary 删除ACL备份
        
        @param request: DeleteAclBackupDataRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteAclBackupDataResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.back_up_time):
            query['BackUpTime'] = request.back_up_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteAclBackupData',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DeleteAclBackupDataResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_acl_backup_data_with_options_async(
        self,
        request: cloudfw_20171207_models.DeleteAclBackupDataRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DeleteAclBackupDataResponse:
        """
        @summary 删除ACL备份
        
        @param request: DeleteAclBackupDataRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteAclBackupDataResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.back_up_time):
            query['BackUpTime'] = request.back_up_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteAclBackupData',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DeleteAclBackupDataResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_acl_backup_data(
        self,
        request: cloudfw_20171207_models.DeleteAclBackupDataRequest,
    ) -> cloudfw_20171207_models.DeleteAclBackupDataResponse:
        """
        @summary 删除ACL备份
        
        @param request: DeleteAclBackupDataRequest
        @return: DeleteAclBackupDataResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_acl_backup_data_with_options(request, runtime)

    async def delete_acl_backup_data_async(
        self,
        request: cloudfw_20171207_models.DeleteAclBackupDataRequest,
    ) -> cloudfw_20171207_models.DeleteAclBackupDataResponse:
        """
        @summary 删除ACL备份
        
        @param request: DeleteAclBackupDataRequest
        @return: DeleteAclBackupDataResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_acl_backup_data_with_options_async(request, runtime)

    def delete_address_book_with_options(
        self,
        request: cloudfw_20171207_models.DeleteAddressBookRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DeleteAddressBookResponse:
        """
        @summary Deletes an address book for access control.
        
        @description You can call the DeleteAddressBook operation to delete an address book for access control.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DeleteAddressBookRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteAddressBookResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.group_uuid):
            query['GroupUuid'] = request.group_uuid
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteAddressBook',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DeleteAddressBookResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_address_book_with_options_async(
        self,
        request: cloudfw_20171207_models.DeleteAddressBookRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DeleteAddressBookResponse:
        """
        @summary Deletes an address book for access control.
        
        @description You can call the DeleteAddressBook operation to delete an address book for access control.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DeleteAddressBookRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteAddressBookResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.group_uuid):
            query['GroupUuid'] = request.group_uuid
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteAddressBook',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DeleteAddressBookResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_address_book(
        self,
        request: cloudfw_20171207_models.DeleteAddressBookRequest,
    ) -> cloudfw_20171207_models.DeleteAddressBookResponse:
        """
        @summary Deletes an address book for access control.
        
        @description You can call the DeleteAddressBook operation to delete an address book for access control.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DeleteAddressBookRequest
        @return: DeleteAddressBookResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_address_book_with_options(request, runtime)

    async def delete_address_book_async(
        self,
        request: cloudfw_20171207_models.DeleteAddressBookRequest,
    ) -> cloudfw_20171207_models.DeleteAddressBookResponse:
        """
        @summary Deletes an address book for access control.
        
        @description You can call the DeleteAddressBook operation to delete an address book for access control.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DeleteAddressBookRequest
        @return: DeleteAddressBookResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_address_book_with_options_async(request, runtime)

    def delete_control_policy_with_options(
        self,
        request: cloudfw_20171207_models.DeleteControlPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DeleteControlPolicyResponse:
        """
        @summary Deletes an access control policy.
        
        @description You can call the DeleteControlPolicy operation to delete an access control policy that applies to inbound or outbound traffic.
        ## [](#qps-)Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DeleteControlPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteControlPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_uuid):
            query['AclUuid'] = request.acl_uuid
        if not UtilClient.is_unset(request.direction):
            query['Direction'] = request.direction
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteControlPolicy',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DeleteControlPolicyResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_control_policy_with_options_async(
        self,
        request: cloudfw_20171207_models.DeleteControlPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DeleteControlPolicyResponse:
        """
        @summary Deletes an access control policy.
        
        @description You can call the DeleteControlPolicy operation to delete an access control policy that applies to inbound or outbound traffic.
        ## [](#qps-)Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DeleteControlPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteControlPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_uuid):
            query['AclUuid'] = request.acl_uuid
        if not UtilClient.is_unset(request.direction):
            query['Direction'] = request.direction
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteControlPolicy',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DeleteControlPolicyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_control_policy(
        self,
        request: cloudfw_20171207_models.DeleteControlPolicyRequest,
    ) -> cloudfw_20171207_models.DeleteControlPolicyResponse:
        """
        @summary Deletes an access control policy.
        
        @description You can call the DeleteControlPolicy operation to delete an access control policy that applies to inbound or outbound traffic.
        ## [](#qps-)Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DeleteControlPolicyRequest
        @return: DeleteControlPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_control_policy_with_options(request, runtime)

    async def delete_control_policy_async(
        self,
        request: cloudfw_20171207_models.DeleteControlPolicyRequest,
    ) -> cloudfw_20171207_models.DeleteControlPolicyResponse:
        """
        @summary Deletes an access control policy.
        
        @description You can call the DeleteControlPolicy operation to delete an access control policy that applies to inbound or outbound traffic.
        ## [](#qps-)Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DeleteControlPolicyRequest
        @return: DeleteControlPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_control_policy_with_options_async(request, runtime)

    def delete_control_policy_template_with_options(
        self,
        request: cloudfw_20171207_models.DeleteControlPolicyTemplateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DeleteControlPolicyTemplateResponse:
        """
        @summary Deletes an access control policy template.
        
        @param request: DeleteControlPolicyTemplateRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteControlPolicyTemplateResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.template_id):
            query['TemplateId'] = request.template_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteControlPolicyTemplate',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DeleteControlPolicyTemplateResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_control_policy_template_with_options_async(
        self,
        request: cloudfw_20171207_models.DeleteControlPolicyTemplateRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DeleteControlPolicyTemplateResponse:
        """
        @summary Deletes an access control policy template.
        
        @param request: DeleteControlPolicyTemplateRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteControlPolicyTemplateResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.template_id):
            query['TemplateId'] = request.template_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteControlPolicyTemplate',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DeleteControlPolicyTemplateResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_control_policy_template(
        self,
        request: cloudfw_20171207_models.DeleteControlPolicyTemplateRequest,
    ) -> cloudfw_20171207_models.DeleteControlPolicyTemplateResponse:
        """
        @summary Deletes an access control policy template.
        
        @param request: DeleteControlPolicyTemplateRequest
        @return: DeleteControlPolicyTemplateResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_control_policy_template_with_options(request, runtime)

    async def delete_control_policy_template_async(
        self,
        request: cloudfw_20171207_models.DeleteControlPolicyTemplateRequest,
    ) -> cloudfw_20171207_models.DeleteControlPolicyTemplateResponse:
        """
        @summary Deletes an access control policy template.
        
        @param request: DeleteControlPolicyTemplateRequest
        @return: DeleteControlPolicyTemplateResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_control_policy_template_with_options_async(request, runtime)

    def delete_dns_firewall_policy_with_options(
        self,
        request: cloudfw_20171207_models.DeleteDnsFirewallPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DeleteDnsFirewallPolicyResponse:
        """
        @summary 删除DNS防火墙规则
        
        @param request: DeleteDnsFirewallPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDnsFirewallPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_uuid):
            query['AclUuid'] = request.acl_uuid
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDnsFirewallPolicy',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DeleteDnsFirewallPolicyResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_dns_firewall_policy_with_options_async(
        self,
        request: cloudfw_20171207_models.DeleteDnsFirewallPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DeleteDnsFirewallPolicyResponse:
        """
        @summary 删除DNS防火墙规则
        
        @param request: DeleteDnsFirewallPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDnsFirewallPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_uuid):
            query['AclUuid'] = request.acl_uuid
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDnsFirewallPolicy',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DeleteDnsFirewallPolicyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_dns_firewall_policy(
        self,
        request: cloudfw_20171207_models.DeleteDnsFirewallPolicyRequest,
    ) -> cloudfw_20171207_models.DeleteDnsFirewallPolicyResponse:
        """
        @summary 删除DNS防火墙规则
        
        @param request: DeleteDnsFirewallPolicyRequest
        @return: DeleteDnsFirewallPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_dns_firewall_policy_with_options(request, runtime)

    async def delete_dns_firewall_policy_async(
        self,
        request: cloudfw_20171207_models.DeleteDnsFirewallPolicyRequest,
    ) -> cloudfw_20171207_models.DeleteDnsFirewallPolicyResponse:
        """
        @summary 删除DNS防火墙规则
        
        @param request: DeleteDnsFirewallPolicyRequest
        @return: DeleteDnsFirewallPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_dns_firewall_policy_with_options_async(request, runtime)

    def delete_download_task_with_options(
        self,
        request: cloudfw_20171207_models.DeleteDownloadTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DeleteDownloadTaskResponse:
        """
        @summary Deletes file download tasks.
        
        @description You can call this operation to delete file download tasks and delete the files.
        *\
        *Warning** Both tasks and involved files are deleted. You can no longer download the involved files by using the download links. This operation is irreversible. Proceed with caution.
        
        @param request: DeleteDownloadTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDownloadTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.task_id):
            query['TaskId'] = request.task_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDownloadTask',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DeleteDownloadTaskResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_download_task_with_options_async(
        self,
        request: cloudfw_20171207_models.DeleteDownloadTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DeleteDownloadTaskResponse:
        """
        @summary Deletes file download tasks.
        
        @description You can call this operation to delete file download tasks and delete the files.
        *\
        *Warning** Both tasks and involved files are deleted. You can no longer download the involved files by using the download links. This operation is irreversible. Proceed with caution.
        
        @param request: DeleteDownloadTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteDownloadTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.task_id):
            query['TaskId'] = request.task_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteDownloadTask',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DeleteDownloadTaskResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_download_task(
        self,
        request: cloudfw_20171207_models.DeleteDownloadTaskRequest,
    ) -> cloudfw_20171207_models.DeleteDownloadTaskResponse:
        """
        @summary Deletes file download tasks.
        
        @description You can call this operation to delete file download tasks and delete the files.
        *\
        *Warning** Both tasks and involved files are deleted. You can no longer download the involved files by using the download links. This operation is irreversible. Proceed with caution.
        
        @param request: DeleteDownloadTaskRequest
        @return: DeleteDownloadTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_download_task_with_options(request, runtime)

    async def delete_download_task_async(
        self,
        request: cloudfw_20171207_models.DeleteDownloadTaskRequest,
    ) -> cloudfw_20171207_models.DeleteDownloadTaskResponse:
        """
        @summary Deletes file download tasks.
        
        @description You can call this operation to delete file download tasks and delete the files.
        *\
        *Warning** Both tasks and involved files are deleted. You can no longer download the involved files by using the download links. This operation is irreversible. Proceed with caution.
        
        @param request: DeleteDownloadTaskRequest
        @return: DeleteDownloadTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_download_task_with_options_async(request, runtime)

    def delete_firewall_v2route_policies_with_options(
        self,
        request: cloudfw_20171207_models.DeleteFirewallV2RoutePoliciesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DeleteFirewallV2RoutePoliciesResponse:
        """
        @summary Deletes routing policies for a virtual private cloud (VPC) firewall of a transit router.
        
        @param request: DeleteFirewallV2RoutePoliciesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteFirewallV2RoutePoliciesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.firewall_id):
            query['FirewallId'] = request.firewall_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.tr_firewall_route_policy_id):
            query['TrFirewallRoutePolicyId'] = request.tr_firewall_route_policy_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteFirewallV2RoutePolicies',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DeleteFirewallV2RoutePoliciesResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_firewall_v2route_policies_with_options_async(
        self,
        request: cloudfw_20171207_models.DeleteFirewallV2RoutePoliciesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DeleteFirewallV2RoutePoliciesResponse:
        """
        @summary Deletes routing policies for a virtual private cloud (VPC) firewall of a transit router.
        
        @param request: DeleteFirewallV2RoutePoliciesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteFirewallV2RoutePoliciesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.firewall_id):
            query['FirewallId'] = request.firewall_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.tr_firewall_route_policy_id):
            query['TrFirewallRoutePolicyId'] = request.tr_firewall_route_policy_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteFirewallV2RoutePolicies',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DeleteFirewallV2RoutePoliciesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_firewall_v2route_policies(
        self,
        request: cloudfw_20171207_models.DeleteFirewallV2RoutePoliciesRequest,
    ) -> cloudfw_20171207_models.DeleteFirewallV2RoutePoliciesResponse:
        """
        @summary Deletes routing policies for a virtual private cloud (VPC) firewall of a transit router.
        
        @param request: DeleteFirewallV2RoutePoliciesRequest
        @return: DeleteFirewallV2RoutePoliciesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_firewall_v2route_policies_with_options(request, runtime)

    async def delete_firewall_v2route_policies_async(
        self,
        request: cloudfw_20171207_models.DeleteFirewallV2RoutePoliciesRequest,
    ) -> cloudfw_20171207_models.DeleteFirewallV2RoutePoliciesResponse:
        """
        @summary Deletes routing policies for a virtual private cloud (VPC) firewall of a transit router.
        
        @param request: DeleteFirewallV2RoutePoliciesRequest
        @return: DeleteFirewallV2RoutePoliciesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_firewall_v2route_policies_with_options_async(request, runtime)

    def delete_instance_members_with_options(
        self,
        request: cloudfw_20171207_models.DeleteInstanceMembersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DeleteInstanceMembersResponse:
        """
        @summary Removes members from Cloud Firewall.
        
        @description You can call this operation to remove up to 20 members from Cloud Firewall at a time. Separate multiple members with commas (,). After a member is removed, Cloud Firewall can no longer access the cloud resources of the member. Proceed with caution. Before you call this operation, call the [DescribeInstanceMembers](https://help.aliyun.com/document_detail/271704.html) operation to obtain the information about the members that are added to Cloud Firewall.
        ## [](#qps-)Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DeleteInstanceMembersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteInstanceMembersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.member_uids):
            query['MemberUids'] = request.member_uids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteInstanceMembers',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DeleteInstanceMembersResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_instance_members_with_options_async(
        self,
        request: cloudfw_20171207_models.DeleteInstanceMembersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DeleteInstanceMembersResponse:
        """
        @summary Removes members from Cloud Firewall.
        
        @description You can call this operation to remove up to 20 members from Cloud Firewall at a time. Separate multiple members with commas (,). After a member is removed, Cloud Firewall can no longer access the cloud resources of the member. Proceed with caution. Before you call this operation, call the [DescribeInstanceMembers](https://help.aliyun.com/document_detail/271704.html) operation to obtain the information about the members that are added to Cloud Firewall.
        ## [](#qps-)Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DeleteInstanceMembersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteInstanceMembersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.member_uids):
            query['MemberUids'] = request.member_uids
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteInstanceMembers',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DeleteInstanceMembersResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_instance_members(
        self,
        request: cloudfw_20171207_models.DeleteInstanceMembersRequest,
    ) -> cloudfw_20171207_models.DeleteInstanceMembersResponse:
        """
        @summary Removes members from Cloud Firewall.
        
        @description You can call this operation to remove up to 20 members from Cloud Firewall at a time. Separate multiple members with commas (,). After a member is removed, Cloud Firewall can no longer access the cloud resources of the member. Proceed with caution. Before you call this operation, call the [DescribeInstanceMembers](https://help.aliyun.com/document_detail/271704.html) operation to obtain the information about the members that are added to Cloud Firewall.
        ## [](#qps-)Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DeleteInstanceMembersRequest
        @return: DeleteInstanceMembersResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_instance_members_with_options(request, runtime)

    async def delete_instance_members_async(
        self,
        request: cloudfw_20171207_models.DeleteInstanceMembersRequest,
    ) -> cloudfw_20171207_models.DeleteInstanceMembersResponse:
        """
        @summary Removes members from Cloud Firewall.
        
        @description You can call this operation to remove up to 20 members from Cloud Firewall at a time. Separate multiple members with commas (,). After a member is removed, Cloud Firewall can no longer access the cloud resources of the member. Proceed with caution. Before you call this operation, call the [DescribeInstanceMembers](https://help.aliyun.com/document_detail/271704.html) operation to obtain the information about the members that are added to Cloud Firewall.
        ## [](#qps-)Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DeleteInstanceMembersRequest
        @return: DeleteInstanceMembersResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_instance_members_with_options_async(request, runtime)

    def delete_ips_private_assoc_with_options(
        self,
        request: cloudfw_20171207_models.DeleteIpsPrivateAssocRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DeleteIpsPrivateAssocResponse:
        """
        @summary 创建IPS私网关联信息
        
        @param request: DeleteIpsPrivateAssocRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteIpsPrivateAssocResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.resource_id):
            query['ResourceId'] = request.resource_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteIpsPrivateAssoc',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DeleteIpsPrivateAssocResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_ips_private_assoc_with_options_async(
        self,
        request: cloudfw_20171207_models.DeleteIpsPrivateAssocRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DeleteIpsPrivateAssocResponse:
        """
        @summary 创建IPS私网关联信息
        
        @param request: DeleteIpsPrivateAssocRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteIpsPrivateAssocResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.resource_id):
            query['ResourceId'] = request.resource_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteIpsPrivateAssoc',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DeleteIpsPrivateAssocResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_ips_private_assoc(
        self,
        request: cloudfw_20171207_models.DeleteIpsPrivateAssocRequest,
    ) -> cloudfw_20171207_models.DeleteIpsPrivateAssocResponse:
        """
        @summary 创建IPS私网关联信息
        
        @param request: DeleteIpsPrivateAssocRequest
        @return: DeleteIpsPrivateAssocResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_ips_private_assoc_with_options(request, runtime)

    async def delete_ips_private_assoc_async(
        self,
        request: cloudfw_20171207_models.DeleteIpsPrivateAssocRequest,
    ) -> cloudfw_20171207_models.DeleteIpsPrivateAssocResponse:
        """
        @summary 创建IPS私网关联信息
        
        @param request: DeleteIpsPrivateAssocRequest
        @return: DeleteIpsPrivateAssocResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_ips_private_assoc_with_options_async(request, runtime)

    def delete_nat_firewall_control_policy_with_options(
        self,
        request: cloudfw_20171207_models.DeleteNatFirewallControlPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DeleteNatFirewallControlPolicyResponse:
        """
        @summary Deletes an access control policy that is created for a NAT firewall.
        
        @description You can use this operation to delete an outbound access control policy that is created for a NAT firewall.
        
        @param request: DeleteNatFirewallControlPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteNatFirewallControlPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_uuid):
            query['AclUuid'] = request.acl_uuid
        if not UtilClient.is_unset(request.direction):
            query['Direction'] = request.direction
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNatFirewallControlPolicy',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DeleteNatFirewallControlPolicyResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_nat_firewall_control_policy_with_options_async(
        self,
        request: cloudfw_20171207_models.DeleteNatFirewallControlPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DeleteNatFirewallControlPolicyResponse:
        """
        @summary Deletes an access control policy that is created for a NAT firewall.
        
        @description You can use this operation to delete an outbound access control policy that is created for a NAT firewall.
        
        @param request: DeleteNatFirewallControlPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteNatFirewallControlPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_uuid):
            query['AclUuid'] = request.acl_uuid
        if not UtilClient.is_unset(request.direction):
            query['Direction'] = request.direction
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNatFirewallControlPolicy',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DeleteNatFirewallControlPolicyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_nat_firewall_control_policy(
        self,
        request: cloudfw_20171207_models.DeleteNatFirewallControlPolicyRequest,
    ) -> cloudfw_20171207_models.DeleteNatFirewallControlPolicyResponse:
        """
        @summary Deletes an access control policy that is created for a NAT firewall.
        
        @description You can use this operation to delete an outbound access control policy that is created for a NAT firewall.
        
        @param request: DeleteNatFirewallControlPolicyRequest
        @return: DeleteNatFirewallControlPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_nat_firewall_control_policy_with_options(request, runtime)

    async def delete_nat_firewall_control_policy_async(
        self,
        request: cloudfw_20171207_models.DeleteNatFirewallControlPolicyRequest,
    ) -> cloudfw_20171207_models.DeleteNatFirewallControlPolicyResponse:
        """
        @summary Deletes an access control policy that is created for a NAT firewall.
        
        @description You can use this operation to delete an outbound access control policy that is created for a NAT firewall.
        
        @param request: DeleteNatFirewallControlPolicyRequest
        @return: DeleteNatFirewallControlPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_nat_firewall_control_policy_with_options_async(request, runtime)

    def delete_nat_firewall_control_policy_batch_with_options(
        self,
        request: cloudfw_20171207_models.DeleteNatFirewallControlPolicyBatchRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DeleteNatFirewallControlPolicyBatchResponse:
        """
        @summary Deletes access control policies that are created for a NAT firewall at a time.
        
        @param request: DeleteNatFirewallControlPolicyBatchRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteNatFirewallControlPolicyBatchResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_uuid_list):
            query['AclUuidList'] = request.acl_uuid_list
        if not UtilClient.is_unset(request.direction):
            query['Direction'] = request.direction
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNatFirewallControlPolicyBatch',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DeleteNatFirewallControlPolicyBatchResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_nat_firewall_control_policy_batch_with_options_async(
        self,
        request: cloudfw_20171207_models.DeleteNatFirewallControlPolicyBatchRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DeleteNatFirewallControlPolicyBatchResponse:
        """
        @summary Deletes access control policies that are created for a NAT firewall at a time.
        
        @param request: DeleteNatFirewallControlPolicyBatchRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteNatFirewallControlPolicyBatchResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_uuid_list):
            query['AclUuidList'] = request.acl_uuid_list
        if not UtilClient.is_unset(request.direction):
            query['Direction'] = request.direction
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteNatFirewallControlPolicyBatch',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DeleteNatFirewallControlPolicyBatchResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_nat_firewall_control_policy_batch(
        self,
        request: cloudfw_20171207_models.DeleteNatFirewallControlPolicyBatchRequest,
    ) -> cloudfw_20171207_models.DeleteNatFirewallControlPolicyBatchResponse:
        """
        @summary Deletes access control policies that are created for a NAT firewall at a time.
        
        @param request: DeleteNatFirewallControlPolicyBatchRequest
        @return: DeleteNatFirewallControlPolicyBatchResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_nat_firewall_control_policy_batch_with_options(request, runtime)

    async def delete_nat_firewall_control_policy_batch_async(
        self,
        request: cloudfw_20171207_models.DeleteNatFirewallControlPolicyBatchRequest,
    ) -> cloudfw_20171207_models.DeleteNatFirewallControlPolicyBatchResponse:
        """
        @summary Deletes access control policies that are created for a NAT firewall at a time.
        
        @param request: DeleteNatFirewallControlPolicyBatchRequest
        @return: DeleteNatFirewallControlPolicyBatchResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_nat_firewall_control_policy_batch_with_options_async(request, runtime)

    def delete_private_dns_all_domain_name_with_options(
        self,
        request: cloudfw_20171207_models.DeletePrivateDnsAllDomainNameRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DeletePrivateDnsAllDomainNameResponse:
        """
        @summary 清空私网DNS域名
        
        @param request: DeletePrivateDnsAllDomainNameRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeletePrivateDnsAllDomainNameResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_instance_id):
            query['AccessInstanceId'] = request.access_instance_id
        if not UtilClient.is_unset(request.region_no):
            query['RegionNo'] = request.region_no
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeletePrivateDnsAllDomainName',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DeletePrivateDnsAllDomainNameResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_private_dns_all_domain_name_with_options_async(
        self,
        request: cloudfw_20171207_models.DeletePrivateDnsAllDomainNameRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DeletePrivateDnsAllDomainNameResponse:
        """
        @summary 清空私网DNS域名
        
        @param request: DeletePrivateDnsAllDomainNameRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeletePrivateDnsAllDomainNameResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_instance_id):
            query['AccessInstanceId'] = request.access_instance_id
        if not UtilClient.is_unset(request.region_no):
            query['RegionNo'] = request.region_no
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeletePrivateDnsAllDomainName',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DeletePrivateDnsAllDomainNameResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_private_dns_all_domain_name(
        self,
        request: cloudfw_20171207_models.DeletePrivateDnsAllDomainNameRequest,
    ) -> cloudfw_20171207_models.DeletePrivateDnsAllDomainNameResponse:
        """
        @summary 清空私网DNS域名
        
        @param request: DeletePrivateDnsAllDomainNameRequest
        @return: DeletePrivateDnsAllDomainNameResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_private_dns_all_domain_name_with_options(request, runtime)

    async def delete_private_dns_all_domain_name_async(
        self,
        request: cloudfw_20171207_models.DeletePrivateDnsAllDomainNameRequest,
    ) -> cloudfw_20171207_models.DeletePrivateDnsAllDomainNameResponse:
        """
        @summary 清空私网DNS域名
        
        @param request: DeletePrivateDnsAllDomainNameRequest
        @return: DeletePrivateDnsAllDomainNameResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_private_dns_all_domain_name_with_options_async(request, runtime)

    def delete_private_dns_domain_name_with_options(
        self,
        request: cloudfw_20171207_models.DeletePrivateDnsDomainNameRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DeletePrivateDnsDomainNameResponse:
        """
        @summary 删除私网DNS域名
        
        @param request: DeletePrivateDnsDomainNameRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeletePrivateDnsDomainNameResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_instance_id):
            query['AccessInstanceId'] = request.access_instance_id
        if not UtilClient.is_unset(request.domain_name_list):
            query['DomainNameList'] = request.domain_name_list
        if not UtilClient.is_unset(request.region_no):
            query['RegionNo'] = request.region_no
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeletePrivateDnsDomainName',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DeletePrivateDnsDomainNameResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_private_dns_domain_name_with_options_async(
        self,
        request: cloudfw_20171207_models.DeletePrivateDnsDomainNameRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DeletePrivateDnsDomainNameResponse:
        """
        @summary 删除私网DNS域名
        
        @param request: DeletePrivateDnsDomainNameRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeletePrivateDnsDomainNameResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_instance_id):
            query['AccessInstanceId'] = request.access_instance_id
        if not UtilClient.is_unset(request.domain_name_list):
            query['DomainNameList'] = request.domain_name_list
        if not UtilClient.is_unset(request.region_no):
            query['RegionNo'] = request.region_no
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeletePrivateDnsDomainName',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DeletePrivateDnsDomainNameResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_private_dns_domain_name(
        self,
        request: cloudfw_20171207_models.DeletePrivateDnsDomainNameRequest,
    ) -> cloudfw_20171207_models.DeletePrivateDnsDomainNameResponse:
        """
        @summary 删除私网DNS域名
        
        @param request: DeletePrivateDnsDomainNameRequest
        @return: DeletePrivateDnsDomainNameResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_private_dns_domain_name_with_options(request, runtime)

    async def delete_private_dns_domain_name_async(
        self,
        request: cloudfw_20171207_models.DeletePrivateDnsDomainNameRequest,
    ) -> cloudfw_20171207_models.DeletePrivateDnsDomainNameResponse:
        """
        @summary 删除私网DNS域名
        
        @param request: DeletePrivateDnsDomainNameRequest
        @return: DeletePrivateDnsDomainNameResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_private_dns_domain_name_with_options_async(request, runtime)

    def delete_private_dns_endpoint_with_options(
        self,
        request: cloudfw_20171207_models.DeletePrivateDnsEndpointRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DeletePrivateDnsEndpointResponse:
        """
        @summary 删除私网DNS终端节点
        
        @param request: DeletePrivateDnsEndpointRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeletePrivateDnsEndpointResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_instance_id):
            query['AccessInstanceId'] = request.access_instance_id
        if not UtilClient.is_unset(request.region_no):
            query['RegionNo'] = request.region_no
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeletePrivateDnsEndpoint',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DeletePrivateDnsEndpointResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_private_dns_endpoint_with_options_async(
        self,
        request: cloudfw_20171207_models.DeletePrivateDnsEndpointRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DeletePrivateDnsEndpointResponse:
        """
        @summary 删除私网DNS终端节点
        
        @param request: DeletePrivateDnsEndpointRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeletePrivateDnsEndpointResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.access_instance_id):
            query['AccessInstanceId'] = request.access_instance_id
        if not UtilClient.is_unset(request.region_no):
            query['RegionNo'] = request.region_no
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeletePrivateDnsEndpoint',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DeletePrivateDnsEndpointResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_private_dns_endpoint(
        self,
        request: cloudfw_20171207_models.DeletePrivateDnsEndpointRequest,
    ) -> cloudfw_20171207_models.DeletePrivateDnsEndpointResponse:
        """
        @summary 删除私网DNS终端节点
        
        @param request: DeletePrivateDnsEndpointRequest
        @return: DeletePrivateDnsEndpointResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_private_dns_endpoint_with_options(request, runtime)

    async def delete_private_dns_endpoint_async(
        self,
        request: cloudfw_20171207_models.DeletePrivateDnsEndpointRequest,
    ) -> cloudfw_20171207_models.DeletePrivateDnsEndpointResponse:
        """
        @summary 删除私网DNS终端节点
        
        @param request: DeletePrivateDnsEndpointRequest
        @return: DeletePrivateDnsEndpointResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_private_dns_endpoint_with_options_async(request, runtime)

    def delete_security_proxy_with_options(
        self,
        request: cloudfw_20171207_models.DeleteSecurityProxyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DeleteSecurityProxyResponse:
        """
        @summary Deletes a NAT firewall.
        
        @param request: DeleteSecurityProxyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSecurityProxyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.proxy_id):
            query['ProxyId'] = request.proxy_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSecurityProxy',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DeleteSecurityProxyResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_security_proxy_with_options_async(
        self,
        request: cloudfw_20171207_models.DeleteSecurityProxyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DeleteSecurityProxyResponse:
        """
        @summary Deletes a NAT firewall.
        
        @param request: DeleteSecurityProxyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteSecurityProxyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.proxy_id):
            query['ProxyId'] = request.proxy_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteSecurityProxy',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DeleteSecurityProxyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_security_proxy(
        self,
        request: cloudfw_20171207_models.DeleteSecurityProxyRequest,
    ) -> cloudfw_20171207_models.DeleteSecurityProxyResponse:
        """
        @summary Deletes a NAT firewall.
        
        @param request: DeleteSecurityProxyRequest
        @return: DeleteSecurityProxyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_security_proxy_with_options(request, runtime)

    async def delete_security_proxy_async(
        self,
        request: cloudfw_20171207_models.DeleteSecurityProxyRequest,
    ) -> cloudfw_20171207_models.DeleteSecurityProxyResponse:
        """
        @summary Deletes a NAT firewall.
        
        @param request: DeleteSecurityProxyRequest
        @return: DeleteSecurityProxyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_security_proxy_with_options_async(request, runtime)

    def delete_tr_firewall_v2with_options(
        self,
        request: cloudfw_20171207_models.DeleteTrFirewallV2Request,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DeleteTrFirewallV2Response:
        """
        @summary Deletes a virtual private cloud (VPC) firewall that is created for a transit router.
        
        @param request: DeleteTrFirewallV2Request
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteTrFirewallV2Response
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.firewall_id):
            query['FirewallId'] = request.firewall_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteTrFirewallV2',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DeleteTrFirewallV2Response(),
            self.call_api(params, req, runtime)
        )

    async def delete_tr_firewall_v2with_options_async(
        self,
        request: cloudfw_20171207_models.DeleteTrFirewallV2Request,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DeleteTrFirewallV2Response:
        """
        @summary Deletes a virtual private cloud (VPC) firewall that is created for a transit router.
        
        @param request: DeleteTrFirewallV2Request
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteTrFirewallV2Response
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.firewall_id):
            query['FirewallId'] = request.firewall_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteTrFirewallV2',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DeleteTrFirewallV2Response(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_tr_firewall_v2(
        self,
        request: cloudfw_20171207_models.DeleteTrFirewallV2Request,
    ) -> cloudfw_20171207_models.DeleteTrFirewallV2Response:
        """
        @summary Deletes a virtual private cloud (VPC) firewall that is created for a transit router.
        
        @param request: DeleteTrFirewallV2Request
        @return: DeleteTrFirewallV2Response
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_tr_firewall_v2with_options(request, runtime)

    async def delete_tr_firewall_v2_async(
        self,
        request: cloudfw_20171207_models.DeleteTrFirewallV2Request,
    ) -> cloudfw_20171207_models.DeleteTrFirewallV2Response:
        """
        @summary Deletes a virtual private cloud (VPC) firewall that is created for a transit router.
        
        @param request: DeleteTrFirewallV2Request
        @return: DeleteTrFirewallV2Response
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_tr_firewall_v2with_options_async(request, runtime)

    def delete_vpc_firewall_cen_configure_with_options(
        self,
        request: cloudfw_20171207_models.DeleteVpcFirewallCenConfigureRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DeleteVpcFirewallCenConfigureResponse:
        """
        @summary Deletes a virtual private cloud (VPC) firewall. The VPC firewall protects mutual access traffic between a VPC and a specified network instance that is attached to a Cloud Enterprise Network (CEN) instance.
        
        @description You can call the DeleteVpcFirewallCenConfigure operation to delete a VPC firewall. The VPC firewall protects mutual access traffic between a VPC and a specified network instance that is attached to a CEN instance. The network instance can be a VPC, a virtual border router (VBR), or a Cloud Connect Network (CCN) instance. Before you call this operation, make sure that you have created a VPC firewall by calling the [CreateVpcFirewallCenConfigure](https://help.aliyun.com/document_detail/345772.html) operation.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DeleteVpcFirewallCenConfigureRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteVpcFirewallCenConfigureResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.member_uid):
            query['MemberUid'] = request.member_uid
        if not UtilClient.is_unset(request.vpc_firewall_id_list):
            query['VpcFirewallIdList'] = request.vpc_firewall_id_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVpcFirewallCenConfigure',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DeleteVpcFirewallCenConfigureResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_vpc_firewall_cen_configure_with_options_async(
        self,
        request: cloudfw_20171207_models.DeleteVpcFirewallCenConfigureRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DeleteVpcFirewallCenConfigureResponse:
        """
        @summary Deletes a virtual private cloud (VPC) firewall. The VPC firewall protects mutual access traffic between a VPC and a specified network instance that is attached to a Cloud Enterprise Network (CEN) instance.
        
        @description You can call the DeleteVpcFirewallCenConfigure operation to delete a VPC firewall. The VPC firewall protects mutual access traffic between a VPC and a specified network instance that is attached to a CEN instance. The network instance can be a VPC, a virtual border router (VBR), or a Cloud Connect Network (CCN) instance. Before you call this operation, make sure that you have created a VPC firewall by calling the [CreateVpcFirewallCenConfigure](https://help.aliyun.com/document_detail/345772.html) operation.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DeleteVpcFirewallCenConfigureRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteVpcFirewallCenConfigureResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.member_uid):
            query['MemberUid'] = request.member_uid
        if not UtilClient.is_unset(request.vpc_firewall_id_list):
            query['VpcFirewallIdList'] = request.vpc_firewall_id_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVpcFirewallCenConfigure',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DeleteVpcFirewallCenConfigureResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_vpc_firewall_cen_configure(
        self,
        request: cloudfw_20171207_models.DeleteVpcFirewallCenConfigureRequest,
    ) -> cloudfw_20171207_models.DeleteVpcFirewallCenConfigureResponse:
        """
        @summary Deletes a virtual private cloud (VPC) firewall. The VPC firewall protects mutual access traffic between a VPC and a specified network instance that is attached to a Cloud Enterprise Network (CEN) instance.
        
        @description You can call the DeleteVpcFirewallCenConfigure operation to delete a VPC firewall. The VPC firewall protects mutual access traffic between a VPC and a specified network instance that is attached to a CEN instance. The network instance can be a VPC, a virtual border router (VBR), or a Cloud Connect Network (CCN) instance. Before you call this operation, make sure that you have created a VPC firewall by calling the [CreateVpcFirewallCenConfigure](https://help.aliyun.com/document_detail/345772.html) operation.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DeleteVpcFirewallCenConfigureRequest
        @return: DeleteVpcFirewallCenConfigureResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_vpc_firewall_cen_configure_with_options(request, runtime)

    async def delete_vpc_firewall_cen_configure_async(
        self,
        request: cloudfw_20171207_models.DeleteVpcFirewallCenConfigureRequest,
    ) -> cloudfw_20171207_models.DeleteVpcFirewallCenConfigureResponse:
        """
        @summary Deletes a virtual private cloud (VPC) firewall. The VPC firewall protects mutual access traffic between a VPC and a specified network instance that is attached to a Cloud Enterprise Network (CEN) instance.
        
        @description You can call the DeleteVpcFirewallCenConfigure operation to delete a VPC firewall. The VPC firewall protects mutual access traffic between a VPC and a specified network instance that is attached to a CEN instance. The network instance can be a VPC, a virtual border router (VBR), or a Cloud Connect Network (CCN) instance. Before you call this operation, make sure that you have created a VPC firewall by calling the [CreateVpcFirewallCenConfigure](https://help.aliyun.com/document_detail/345772.html) operation.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DeleteVpcFirewallCenConfigureRequest
        @return: DeleteVpcFirewallCenConfigureResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_vpc_firewall_cen_configure_with_options_async(request, runtime)

    def delete_vpc_firewall_configure_with_options(
        self,
        request: cloudfw_20171207_models.DeleteVpcFirewallConfigureRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DeleteVpcFirewallConfigureResponse:
        """
        @summary Deletes a virtual private cloud (VPC) firewall that controls traffic between two VPCs. The VPCs are connected by using an Express Connect circuit.
        
        @description You can call the DeleteVpcFirewallConfigure operation to delete a VPC firewall. The VPC firewall controls traffic between two VPCs that are connected by using an Express Connect circuit. Before you call the operation, make sure that you created a VPC firewall by calling the [CreateVpcFirewallConfigure](https://help.aliyun.com/document_detail/342893.html) operation.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DeleteVpcFirewallConfigureRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteVpcFirewallConfigureResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.member_uid):
            query['MemberUid'] = request.member_uid
        if not UtilClient.is_unset(request.vpc_firewall_id_list):
            query['VpcFirewallIdList'] = request.vpc_firewall_id_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVpcFirewallConfigure',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DeleteVpcFirewallConfigureResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_vpc_firewall_configure_with_options_async(
        self,
        request: cloudfw_20171207_models.DeleteVpcFirewallConfigureRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DeleteVpcFirewallConfigureResponse:
        """
        @summary Deletes a virtual private cloud (VPC) firewall that controls traffic between two VPCs. The VPCs are connected by using an Express Connect circuit.
        
        @description You can call the DeleteVpcFirewallConfigure operation to delete a VPC firewall. The VPC firewall controls traffic between two VPCs that are connected by using an Express Connect circuit. Before you call the operation, make sure that you created a VPC firewall by calling the [CreateVpcFirewallConfigure](https://help.aliyun.com/document_detail/342893.html) operation.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DeleteVpcFirewallConfigureRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteVpcFirewallConfigureResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.member_uid):
            query['MemberUid'] = request.member_uid
        if not UtilClient.is_unset(request.vpc_firewall_id_list):
            query['VpcFirewallIdList'] = request.vpc_firewall_id_list
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVpcFirewallConfigure',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DeleteVpcFirewallConfigureResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_vpc_firewall_configure(
        self,
        request: cloudfw_20171207_models.DeleteVpcFirewallConfigureRequest,
    ) -> cloudfw_20171207_models.DeleteVpcFirewallConfigureResponse:
        """
        @summary Deletes a virtual private cloud (VPC) firewall that controls traffic between two VPCs. The VPCs are connected by using an Express Connect circuit.
        
        @description You can call the DeleteVpcFirewallConfigure operation to delete a VPC firewall. The VPC firewall controls traffic between two VPCs that are connected by using an Express Connect circuit. Before you call the operation, make sure that you created a VPC firewall by calling the [CreateVpcFirewallConfigure](https://help.aliyun.com/document_detail/342893.html) operation.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DeleteVpcFirewallConfigureRequest
        @return: DeleteVpcFirewallConfigureResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_vpc_firewall_configure_with_options(request, runtime)

    async def delete_vpc_firewall_configure_async(
        self,
        request: cloudfw_20171207_models.DeleteVpcFirewallConfigureRequest,
    ) -> cloudfw_20171207_models.DeleteVpcFirewallConfigureResponse:
        """
        @summary Deletes a virtual private cloud (VPC) firewall that controls traffic between two VPCs. The VPCs are connected by using an Express Connect circuit.
        
        @description You can call the DeleteVpcFirewallConfigure operation to delete a VPC firewall. The VPC firewall controls traffic between two VPCs that are connected by using an Express Connect circuit. Before you call the operation, make sure that you created a VPC firewall by calling the [CreateVpcFirewallConfigure](https://help.aliyun.com/document_detail/342893.html) operation.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DeleteVpcFirewallConfigureRequest
        @return: DeleteVpcFirewallConfigureResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_vpc_firewall_configure_with_options_async(request, runtime)

    def delete_vpc_firewall_control_policy_with_options(
        self,
        request: cloudfw_20171207_models.DeleteVpcFirewallControlPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DeleteVpcFirewallControlPolicyResponse:
        """
        @summary Deletes an access control policy from a specific policy group for a virtual private cloud (VPC) firewall.
        
        @description You can call the DeleteVpcFirewallControlPolicy operation to delete an access control policy from a specific policy group for a VPC firewall. Different access control policies are used for the VPC firewall that is used to protect each Cloud Enterprise Network (CEN) instance and the VPC firewall that is used to protect each Express Connect circuit.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DeleteVpcFirewallControlPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteVpcFirewallControlPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_uuid):
            query['AclUuid'] = request.acl_uuid
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.vpc_firewall_id):
            query['VpcFirewallId'] = request.vpc_firewall_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVpcFirewallControlPolicy',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DeleteVpcFirewallControlPolicyResponse(),
            self.call_api(params, req, runtime)
        )

    async def delete_vpc_firewall_control_policy_with_options_async(
        self,
        request: cloudfw_20171207_models.DeleteVpcFirewallControlPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DeleteVpcFirewallControlPolicyResponse:
        """
        @summary Deletes an access control policy from a specific policy group for a virtual private cloud (VPC) firewall.
        
        @description You can call the DeleteVpcFirewallControlPolicy operation to delete an access control policy from a specific policy group for a VPC firewall. Different access control policies are used for the VPC firewall that is used to protect each Cloud Enterprise Network (CEN) instance and the VPC firewall that is used to protect each Express Connect circuit.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DeleteVpcFirewallControlPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DeleteVpcFirewallControlPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_uuid):
            query['AclUuid'] = request.acl_uuid
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.vpc_firewall_id):
            query['VpcFirewallId'] = request.vpc_firewall_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DeleteVpcFirewallControlPolicy',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DeleteVpcFirewallControlPolicyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def delete_vpc_firewall_control_policy(
        self,
        request: cloudfw_20171207_models.DeleteVpcFirewallControlPolicyRequest,
    ) -> cloudfw_20171207_models.DeleteVpcFirewallControlPolicyResponse:
        """
        @summary Deletes an access control policy from a specific policy group for a virtual private cloud (VPC) firewall.
        
        @description You can call the DeleteVpcFirewallControlPolicy operation to delete an access control policy from a specific policy group for a VPC firewall. Different access control policies are used for the VPC firewall that is used to protect each Cloud Enterprise Network (CEN) instance and the VPC firewall that is used to protect each Express Connect circuit.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DeleteVpcFirewallControlPolicyRequest
        @return: DeleteVpcFirewallControlPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.delete_vpc_firewall_control_policy_with_options(request, runtime)

    async def delete_vpc_firewall_control_policy_async(
        self,
        request: cloudfw_20171207_models.DeleteVpcFirewallControlPolicyRequest,
    ) -> cloudfw_20171207_models.DeleteVpcFirewallControlPolicyResponse:
        """
        @summary Deletes an access control policy from a specific policy group for a virtual private cloud (VPC) firewall.
        
        @description You can call the DeleteVpcFirewallControlPolicy operation to delete an access control policy from a specific policy group for a VPC firewall. Different access control policies are used for the VPC firewall that is used to protect each Cloud Enterprise Network (CEN) instance and the VPC firewall that is used to protect each Express Connect circuit.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DeleteVpcFirewallControlPolicyRequest
        @return: DeleteVpcFirewallControlPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.delete_vpc_firewall_control_policy_with_options_async(request, runtime)

    def describe_aclprotect_trend_with_options(
        self,
        request: cloudfw_20171207_models.DescribeACLProtectTrendRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeACLProtectTrendResponse:
        """
        @summary Queries the statistics on the requests that are blocked by the access control list (ACL) feature.
        
        @param request: DescribeACLProtectTrendRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeACLProtectTrendResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeACLProtectTrend',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeACLProtectTrendResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_aclprotect_trend_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeACLProtectTrendRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeACLProtectTrendResponse:
        """
        @summary Queries the statistics on the requests that are blocked by the access control list (ACL) feature.
        
        @param request: DescribeACLProtectTrendRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeACLProtectTrendResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeACLProtectTrend',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeACLProtectTrendResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_aclprotect_trend(
        self,
        request: cloudfw_20171207_models.DescribeACLProtectTrendRequest,
    ) -> cloudfw_20171207_models.DescribeACLProtectTrendResponse:
        """
        @summary Queries the statistics on the requests that are blocked by the access control list (ACL) feature.
        
        @param request: DescribeACLProtectTrendRequest
        @return: DescribeACLProtectTrendResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_aclprotect_trend_with_options(request, runtime)

    async def describe_aclprotect_trend_async(
        self,
        request: cloudfw_20171207_models.DescribeACLProtectTrendRequest,
    ) -> cloudfw_20171207_models.DescribeACLProtectTrendResponse:
        """
        @summary Queries the statistics on the requests that are blocked by the access control list (ACL) feature.
        
        @param request: DescribeACLProtectTrendRequest
        @return: DescribeACLProtectTrendResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_aclprotect_trend_with_options_async(request, runtime)

    def describe_aitraffic_analysis_status_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeAITrafficAnalysisStatusResponse:
        """
        @summary 查询AI流量分析开启状态
        
        @param request: DescribeAITrafficAnalysisStatusRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAITrafficAnalysisStatusResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeAITrafficAnalysisStatus',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeAITrafficAnalysisStatusResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_aitraffic_analysis_status_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeAITrafficAnalysisStatusResponse:
        """
        @summary 查询AI流量分析开启状态
        
        @param request: DescribeAITrafficAnalysisStatusRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAITrafficAnalysisStatusResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeAITrafficAnalysisStatus',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeAITrafficAnalysisStatusResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_aitraffic_analysis_status(self) -> cloudfw_20171207_models.DescribeAITrafficAnalysisStatusResponse:
        """
        @summary 查询AI流量分析开启状态
        
        @return: DescribeAITrafficAnalysisStatusResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_aitraffic_analysis_status_with_options(runtime)

    async def describe_aitraffic_analysis_status_async(self) -> cloudfw_20171207_models.DescribeAITrafficAnalysisStatusResponse:
        """
        @summary 查询AI流量分析开启状态
        
        @return: DescribeAITrafficAnalysisStatusResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_aitraffic_analysis_status_with_options_async(runtime)

    def describe_access_instance_region_list_with_options(
        self,
        request: cloudfw_20171207_models.DescribeAccessInstanceRegionListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeAccessInstanceRegionListResponse:
        """
        @summary 查询接入实例地域列表
        
        @param request: DescribeAccessInstanceRegionListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAccessInstanceRegionListResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAccessInstanceRegionList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeAccessInstanceRegionListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_access_instance_region_list_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeAccessInstanceRegionListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeAccessInstanceRegionListResponse:
        """
        @summary 查询接入实例地域列表
        
        @param request: DescribeAccessInstanceRegionListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAccessInstanceRegionListResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAccessInstanceRegionList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeAccessInstanceRegionListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_access_instance_region_list(
        self,
        request: cloudfw_20171207_models.DescribeAccessInstanceRegionListRequest,
    ) -> cloudfw_20171207_models.DescribeAccessInstanceRegionListResponse:
        """
        @summary 查询接入实例地域列表
        
        @param request: DescribeAccessInstanceRegionListRequest
        @return: DescribeAccessInstanceRegionListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_access_instance_region_list_with_options(request, runtime)

    async def describe_access_instance_region_list_async(
        self,
        request: cloudfw_20171207_models.DescribeAccessInstanceRegionListRequest,
    ) -> cloudfw_20171207_models.DescribeAccessInstanceRegionListResponse:
        """
        @summary 查询接入实例地域列表
        
        @param request: DescribeAccessInstanceRegionListRequest
        @return: DescribeAccessInstanceRegionListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_access_instance_region_list_with_options_async(request, runtime)

    def describe_access_instance_task_with_options(
        self,
        request: cloudfw_20171207_models.DescribeAccessInstanceTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeAccessInstanceTaskResponse:
        """
        @summary 查询接入实例任务
        
        @param request: DescribeAccessInstanceTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAccessInstanceTaskResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAccessInstanceTask',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeAccessInstanceTaskResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_access_instance_task_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeAccessInstanceTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeAccessInstanceTaskResponse:
        """
        @summary 查询接入实例任务
        
        @param request: DescribeAccessInstanceTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAccessInstanceTaskResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAccessInstanceTask',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeAccessInstanceTaskResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_access_instance_task(
        self,
        request: cloudfw_20171207_models.DescribeAccessInstanceTaskRequest,
    ) -> cloudfw_20171207_models.DescribeAccessInstanceTaskResponse:
        """
        @summary 查询接入实例任务
        
        @param request: DescribeAccessInstanceTaskRequest
        @return: DescribeAccessInstanceTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_access_instance_task_with_options(request, runtime)

    async def describe_access_instance_task_async(
        self,
        request: cloudfw_20171207_models.DescribeAccessInstanceTaskRequest,
    ) -> cloudfw_20171207_models.DescribeAccessInstanceTaskResponse:
        """
        @summary 查询接入实例任务
        
        @param request: DescribeAccessInstanceTaskRequest
        @return: DescribeAccessInstanceTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_access_instance_task_with_options_async(request, runtime)

    def describe_access_instance_vswitch_list_with_options(
        self,
        request: cloudfw_20171207_models.DescribeAccessInstanceVSwitchListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeAccessInstanceVSwitchListResponse:
        """
        @summary 查询接入实例的交换机列表
        
        @param request: DescribeAccessInstanceVSwitchListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAccessInstanceVSwitchListResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAccessInstanceVSwitchList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeAccessInstanceVSwitchListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_access_instance_vswitch_list_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeAccessInstanceVSwitchListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeAccessInstanceVSwitchListResponse:
        """
        @summary 查询接入实例的交换机列表
        
        @param request: DescribeAccessInstanceVSwitchListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAccessInstanceVSwitchListResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAccessInstanceVSwitchList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeAccessInstanceVSwitchListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_access_instance_vswitch_list(
        self,
        request: cloudfw_20171207_models.DescribeAccessInstanceVSwitchListRequest,
    ) -> cloudfw_20171207_models.DescribeAccessInstanceVSwitchListResponse:
        """
        @summary 查询接入实例的交换机列表
        
        @param request: DescribeAccessInstanceVSwitchListRequest
        @return: DescribeAccessInstanceVSwitchListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_access_instance_vswitch_list_with_options(request, runtime)

    async def describe_access_instance_vswitch_list_async(
        self,
        request: cloudfw_20171207_models.DescribeAccessInstanceVSwitchListRequest,
    ) -> cloudfw_20171207_models.DescribeAccessInstanceVSwitchListResponse:
        """
        @summary 查询接入实例的交换机列表
        
        @param request: DescribeAccessInstanceVSwitchListRequest
        @return: DescribeAccessInstanceVSwitchListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_access_instance_vswitch_list_with_options_async(request, runtime)

    def describe_access_instance_vpc_list_with_options(
        self,
        request: cloudfw_20171207_models.DescribeAccessInstanceVpcListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeAccessInstanceVpcListResponse:
        """
        @summary 查询接入实例VPC列表
        
        @param request: DescribeAccessInstanceVpcListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAccessInstanceVpcListResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAccessInstanceVpcList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeAccessInstanceVpcListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_access_instance_vpc_list_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeAccessInstanceVpcListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeAccessInstanceVpcListResponse:
        """
        @summary 查询接入实例VPC列表
        
        @param request: DescribeAccessInstanceVpcListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAccessInstanceVpcListResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAccessInstanceVpcList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeAccessInstanceVpcListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_access_instance_vpc_list(
        self,
        request: cloudfw_20171207_models.DescribeAccessInstanceVpcListRequest,
    ) -> cloudfw_20171207_models.DescribeAccessInstanceVpcListResponse:
        """
        @summary 查询接入实例VPC列表
        
        @param request: DescribeAccessInstanceVpcListRequest
        @return: DescribeAccessInstanceVpcListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_access_instance_vpc_list_with_options(request, runtime)

    async def describe_access_instance_vpc_list_async(
        self,
        request: cloudfw_20171207_models.DescribeAccessInstanceVpcListRequest,
    ) -> cloudfw_20171207_models.DescribeAccessInstanceVpcListResponse:
        """
        @summary 查询接入实例VPC列表
        
        @param request: DescribeAccessInstanceVpcListRequest
        @return: DescribeAccessInstanceVpcListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_access_instance_vpc_list_with_options_async(request, runtime)

    def describe_access_instance_zone_list_with_options(
        self,
        request: cloudfw_20171207_models.DescribeAccessInstanceZoneListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeAccessInstanceZoneListResponse:
        """
        @summary 查询接入实例支持的可用区列表
        
        @param request: DescribeAccessInstanceZoneListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAccessInstanceZoneListResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAccessInstanceZoneList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeAccessInstanceZoneListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_access_instance_zone_list_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeAccessInstanceZoneListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeAccessInstanceZoneListResponse:
        """
        @summary 查询接入实例支持的可用区列表
        
        @param request: DescribeAccessInstanceZoneListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAccessInstanceZoneListResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAccessInstanceZoneList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeAccessInstanceZoneListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_access_instance_zone_list(
        self,
        request: cloudfw_20171207_models.DescribeAccessInstanceZoneListRequest,
    ) -> cloudfw_20171207_models.DescribeAccessInstanceZoneListResponse:
        """
        @summary 查询接入实例支持的可用区列表
        
        @param request: DescribeAccessInstanceZoneListRequest
        @return: DescribeAccessInstanceZoneListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_access_instance_zone_list_with_options(request, runtime)

    async def describe_access_instance_zone_list_async(
        self,
        request: cloudfw_20171207_models.DescribeAccessInstanceZoneListRequest,
    ) -> cloudfw_20171207_models.DescribeAccessInstanceZoneListResponse:
        """
        @summary 查询接入实例支持的可用区列表
        
        @param request: DescribeAccessInstanceZoneListRequest
        @return: DescribeAccessInstanceZoneListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_access_instance_zone_list_with_options_async(request, runtime)

    def describe_ack_cluster_connector_with_options(
        self,
        request: cloudfw_20171207_models.DescribeAckClusterConnectorRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeAckClusterConnectorResponse:
        """
        @summary 查询指定ACK集群连接器
        
        @param request: DescribeAckClusterConnectorRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAckClusterConnectorResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.connector_id):
            query['ConnectorId'] = request.connector_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAckClusterConnector',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeAckClusterConnectorResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_ack_cluster_connector_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeAckClusterConnectorRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeAckClusterConnectorResponse:
        """
        @summary 查询指定ACK集群连接器
        
        @param request: DescribeAckClusterConnectorRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAckClusterConnectorResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.connector_id):
            query['ConnectorId'] = request.connector_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAckClusterConnector',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeAckClusterConnectorResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_ack_cluster_connector(
        self,
        request: cloudfw_20171207_models.DescribeAckClusterConnectorRequest,
    ) -> cloudfw_20171207_models.DescribeAckClusterConnectorResponse:
        """
        @summary 查询指定ACK集群连接器
        
        @param request: DescribeAckClusterConnectorRequest
        @return: DescribeAckClusterConnectorResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_ack_cluster_connector_with_options(request, runtime)

    async def describe_ack_cluster_connector_async(
        self,
        request: cloudfw_20171207_models.DescribeAckClusterConnectorRequest,
    ) -> cloudfw_20171207_models.DescribeAckClusterConnectorResponse:
        """
        @summary 查询指定ACK集群连接器
        
        @param request: DescribeAckClusterConnectorRequest
        @return: DescribeAckClusterConnectorResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_ack_cluster_connector_with_options_async(request, runtime)

    def describe_ack_cluster_connectors_with_options(
        self,
        request: cloudfw_20171207_models.DescribeAckClusterConnectorsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeAckClusterConnectorsResponse:
        """
        @summary 批量查询ACK集群连接器列表
        
        @param request: DescribeAckClusterConnectorsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAckClusterConnectorsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.connector_name):
            query['ConnectorName'] = request.connector_name
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.member_uid):
            query['MemberUid'] = request.member_uid
        if not UtilClient.is_unset(request.page_no):
            query['PageNo'] = request.page_no
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_no):
            query['RegionNo'] = request.region_no
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAckClusterConnectors',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeAckClusterConnectorsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_ack_cluster_connectors_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeAckClusterConnectorsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeAckClusterConnectorsResponse:
        """
        @summary 批量查询ACK集群连接器列表
        
        @param request: DescribeAckClusterConnectorsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAckClusterConnectorsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.connector_name):
            query['ConnectorName'] = request.connector_name
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.member_uid):
            query['MemberUid'] = request.member_uid
        if not UtilClient.is_unset(request.page_no):
            query['PageNo'] = request.page_no
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_no):
            query['RegionNo'] = request.region_no
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAckClusterConnectors',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeAckClusterConnectorsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_ack_cluster_connectors(
        self,
        request: cloudfw_20171207_models.DescribeAckClusterConnectorsRequest,
    ) -> cloudfw_20171207_models.DescribeAckClusterConnectorsResponse:
        """
        @summary 批量查询ACK集群连接器列表
        
        @param request: DescribeAckClusterConnectorsRequest
        @return: DescribeAckClusterConnectorsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_ack_cluster_connectors_with_options(request, runtime)

    async def describe_ack_cluster_connectors_async(
        self,
        request: cloudfw_20171207_models.DescribeAckClusterConnectorsRequest,
    ) -> cloudfw_20171207_models.DescribeAckClusterConnectorsResponse:
        """
        @summary 批量查询ACK集群连接器列表
        
        @param request: DescribeAckClusterConnectorsRequest
        @return: DescribeAckClusterConnectorsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_ack_cluster_connectors_with_options_async(request, runtime)

    def describe_ack_cluster_namespaces_with_options(
        self,
        request: cloudfw_20171207_models.DescribeAckClusterNamespacesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeAckClusterNamespacesResponse:
        """
        @summary 查询阿里云K8S容器服务（ACK）集群命名空间
        
        @param request: DescribeAckClusterNamespacesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAckClusterNamespacesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.connector_id):
            query['ConnectorId'] = request.connector_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAckClusterNamespaces',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeAckClusterNamespacesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_ack_cluster_namespaces_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeAckClusterNamespacesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeAckClusterNamespacesResponse:
        """
        @summary 查询阿里云K8S容器服务（ACK）集群命名空间
        
        @param request: DescribeAckClusterNamespacesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAckClusterNamespacesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.connector_id):
            query['ConnectorId'] = request.connector_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAckClusterNamespaces',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeAckClusterNamespacesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_ack_cluster_namespaces(
        self,
        request: cloudfw_20171207_models.DescribeAckClusterNamespacesRequest,
    ) -> cloudfw_20171207_models.DescribeAckClusterNamespacesResponse:
        """
        @summary 查询阿里云K8S容器服务（ACK）集群命名空间
        
        @param request: DescribeAckClusterNamespacesRequest
        @return: DescribeAckClusterNamespacesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_ack_cluster_namespaces_with_options(request, runtime)

    async def describe_ack_cluster_namespaces_async(
        self,
        request: cloudfw_20171207_models.DescribeAckClusterNamespacesRequest,
    ) -> cloudfw_20171207_models.DescribeAckClusterNamespacesResponse:
        """
        @summary 查询阿里云K8S容器服务（ACK）集群命名空间
        
        @param request: DescribeAckClusterNamespacesRequest
        @return: DescribeAckClusterNamespacesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_ack_cluster_namespaces_with_options_async(request, runtime)

    def describe_ack_cluster_pod_labels_with_options(
        self,
        request: cloudfw_20171207_models.DescribeAckClusterPodLabelsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeAckClusterPodLabelsResponse:
        """
        @summary 查询阿里云K8S容器服务（ACK）集群标签
        
        @param request: DescribeAckClusterPodLabelsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAckClusterPodLabelsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.connector_id):
            query['ConnectorId'] = request.connector_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAckClusterPodLabels',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeAckClusterPodLabelsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_ack_cluster_pod_labels_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeAckClusterPodLabelsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeAckClusterPodLabelsResponse:
        """
        @summary 查询阿里云K8S容器服务（ACK）集群标签
        
        @param request: DescribeAckClusterPodLabelsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAckClusterPodLabelsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.connector_id):
            query['ConnectorId'] = request.connector_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAckClusterPodLabels',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeAckClusterPodLabelsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_ack_cluster_pod_labels(
        self,
        request: cloudfw_20171207_models.DescribeAckClusterPodLabelsRequest,
    ) -> cloudfw_20171207_models.DescribeAckClusterPodLabelsResponse:
        """
        @summary 查询阿里云K8S容器服务（ACK）集群标签
        
        @param request: DescribeAckClusterPodLabelsRequest
        @return: DescribeAckClusterPodLabelsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_ack_cluster_pod_labels_with_options(request, runtime)

    async def describe_ack_cluster_pod_labels_async(
        self,
        request: cloudfw_20171207_models.DescribeAckClusterPodLabelsRequest,
    ) -> cloudfw_20171207_models.DescribeAckClusterPodLabelsResponse:
        """
        @summary 查询阿里云K8S容器服务（ACK）集群标签
        
        @param request: DescribeAckClusterPodLabelsRequest
        @return: DescribeAckClusterPodLabelsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_ack_cluster_pod_labels_with_options_async(request, runtime)

    def describe_ack_clusters_with_options(
        self,
        request: cloudfw_20171207_models.DescribeAckClustersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeAckClustersResponse:
        """
        @summary 查询阿里云K8S容器服务（ACK）集群，查询符合条件的ACK集群（例如指定集群类型、集群规格）列表信息
        
        @param request: DescribeAckClustersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAckClustersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.cluster_name):
            query['ClusterName'] = request.cluster_name
        if not UtilClient.is_unset(request.cluster_spec):
            query['ClusterSpec'] = request.cluster_spec
        if not UtilClient.is_unset(request.connector_status):
            query['ConnectorStatus'] = request.connector_status
        if not UtilClient.is_unset(request.member_uid):
            query['MemberUid'] = request.member_uid
        if not UtilClient.is_unset(request.page_no):
            query['PageNo'] = request.page_no
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_no):
            query['RegionNo'] = request.region_no
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAckClusters',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeAckClustersResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_ack_clusters_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeAckClustersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeAckClustersResponse:
        """
        @summary 查询阿里云K8S容器服务（ACK）集群，查询符合条件的ACK集群（例如指定集群类型、集群规格）列表信息
        
        @param request: DescribeAckClustersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAckClustersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cluster_id):
            query['ClusterId'] = request.cluster_id
        if not UtilClient.is_unset(request.cluster_name):
            query['ClusterName'] = request.cluster_name
        if not UtilClient.is_unset(request.cluster_spec):
            query['ClusterSpec'] = request.cluster_spec
        if not UtilClient.is_unset(request.connector_status):
            query['ConnectorStatus'] = request.connector_status
        if not UtilClient.is_unset(request.member_uid):
            query['MemberUid'] = request.member_uid
        if not UtilClient.is_unset(request.page_no):
            query['PageNo'] = request.page_no
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_no):
            query['RegionNo'] = request.region_no
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAckClusters',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeAckClustersResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_ack_clusters(
        self,
        request: cloudfw_20171207_models.DescribeAckClustersRequest,
    ) -> cloudfw_20171207_models.DescribeAckClustersResponse:
        """
        @summary 查询阿里云K8S容器服务（ACK）集群，查询符合条件的ACK集群（例如指定集群类型、集群规格）列表信息
        
        @param request: DescribeAckClustersRequest
        @return: DescribeAckClustersResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_ack_clusters_with_options(request, runtime)

    async def describe_ack_clusters_async(
        self,
        request: cloudfw_20171207_models.DescribeAckClustersRequest,
    ) -> cloudfw_20171207_models.DescribeAckClustersResponse:
        """
        @summary 查询阿里云K8S容器服务（ACK）集群，查询符合条件的ACK集群（例如指定集群类型、集群规格）列表信息
        
        @param request: DescribeAckClustersRequest
        @return: DescribeAckClustersResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_ack_clusters_with_options_async(request, runtime)

    def describe_acl_apps_with_options(
        self,
        request: cloudfw_20171207_models.DescribeAclAppsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeAclAppsResponse:
        """
        @summary 批量查询访问控制应用
        
        @param request: DescribeAclAppsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAclAppsResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAclApps',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeAclAppsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_acl_apps_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeAclAppsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeAclAppsResponse:
        """
        @summary 批量查询访问控制应用
        
        @param request: DescribeAclAppsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAclAppsResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAclApps',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeAclAppsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_acl_apps(
        self,
        request: cloudfw_20171207_models.DescribeAclAppsRequest,
    ) -> cloudfw_20171207_models.DescribeAclAppsResponse:
        """
        @summary 批量查询访问控制应用
        
        @param request: DescribeAclAppsRequest
        @return: DescribeAclAppsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_acl_apps_with_options(request, runtime)

    async def describe_acl_apps_async(
        self,
        request: cloudfw_20171207_models.DescribeAclAppsRequest,
    ) -> cloudfw_20171207_models.DescribeAclAppsResponse:
        """
        @summary 批量查询访问控制应用
        
        @param request: DescribeAclAppsRequest
        @return: DescribeAclAppsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_acl_apps_with_options_async(request, runtime)

    def describe_acl_backup_list_with_options(
        self,
        request: cloudfw_20171207_models.DescribeAclBackupListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeAclBackupListResponse:
        """
        @summary 获取ACL备份列表
        
        @param request: DescribeAclBackupListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAclBackupListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAclBackupList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeAclBackupListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_acl_backup_list_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeAclBackupListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeAclBackupListResponse:
        """
        @summary 获取ACL备份列表
        
        @param request: DescribeAclBackupListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAclBackupListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAclBackupList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeAclBackupListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_acl_backup_list(
        self,
        request: cloudfw_20171207_models.DescribeAclBackupListRequest,
    ) -> cloudfw_20171207_models.DescribeAclBackupListResponse:
        """
        @summary 获取ACL备份列表
        
        @param request: DescribeAclBackupListRequest
        @return: DescribeAclBackupListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_acl_backup_list_with_options(request, runtime)

    async def describe_acl_backup_list_async(
        self,
        request: cloudfw_20171207_models.DescribeAclBackupListRequest,
    ) -> cloudfw_20171207_models.DescribeAclBackupListResponse:
        """
        @summary 获取ACL备份列表
        
        @param request: DescribeAclBackupListRequest
        @return: DescribeAclBackupListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_acl_backup_list_with_options_async(request, runtime)

    def describe_acl_check_with_options(
        self,
        request: cloudfw_20171207_models.DescribeAclCheckRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeAclCheckResponse:
        """
        @summary 查询ACL检查详情
        
        @param request: DescribeAclCheckRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAclCheckResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAclCheck',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeAclCheckResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_acl_check_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeAclCheckRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeAclCheckResponse:
        """
        @summary 查询ACL检查详情
        
        @param request: DescribeAclCheckRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAclCheckResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAclCheck',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeAclCheckResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_acl_check(
        self,
        request: cloudfw_20171207_models.DescribeAclCheckRequest,
    ) -> cloudfw_20171207_models.DescribeAclCheckResponse:
        """
        @summary 查询ACL检查详情
        
        @param request: DescribeAclCheckRequest
        @return: DescribeAclCheckResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_acl_check_with_options(request, runtime)

    async def describe_acl_check_async(
        self,
        request: cloudfw_20171207_models.DescribeAclCheckRequest,
    ) -> cloudfw_20171207_models.DescribeAclCheckResponse:
        """
        @summary 查询ACL检查详情
        
        @param request: DescribeAclCheckRequest
        @return: DescribeAclCheckResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_acl_check_with_options_async(request, runtime)

    def describe_acl_check_quota_with_options(
        self,
        request: cloudfw_20171207_models.DescribeAclCheckQuotaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeAclCheckQuotaResponse:
        """
        @summary 查询NAT防火墙预检查结果
        
        @param request: DescribeAclCheckQuotaRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAclCheckQuotaResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAclCheckQuota',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeAclCheckQuotaResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_acl_check_quota_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeAclCheckQuotaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeAclCheckQuotaResponse:
        """
        @summary 查询NAT防火墙预检查结果
        
        @param request: DescribeAclCheckQuotaRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAclCheckQuotaResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAclCheckQuota',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeAclCheckQuotaResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_acl_check_quota(
        self,
        request: cloudfw_20171207_models.DescribeAclCheckQuotaRequest,
    ) -> cloudfw_20171207_models.DescribeAclCheckQuotaResponse:
        """
        @summary 查询NAT防火墙预检查结果
        
        @param request: DescribeAclCheckQuotaRequest
        @return: DescribeAclCheckQuotaResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_acl_check_quota_with_options(request, runtime)

    async def describe_acl_check_quota_async(
        self,
        request: cloudfw_20171207_models.DescribeAclCheckQuotaRequest,
    ) -> cloudfw_20171207_models.DescribeAclCheckQuotaResponse:
        """
        @summary 查询NAT防火墙预检查结果
        
        @param request: DescribeAclCheckQuotaRequest
        @return: DescribeAclCheckQuotaResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_acl_check_quota_with_options_async(request, runtime)

    def describe_acl_checks_with_options(
        self,
        request: cloudfw_20171207_models.DescribeAclChecksRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeAclChecksResponse:
        """
        @summary 批量查询ACL检查条目
        
        @param request: DescribeAclChecksRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAclChecksResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAclChecks',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeAclChecksResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_acl_checks_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeAclChecksRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeAclChecksResponse:
        """
        @summary 批量查询ACL检查条目
        
        @param request: DescribeAclChecksRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAclChecksResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAclChecks',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeAclChecksResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_acl_checks(
        self,
        request: cloudfw_20171207_models.DescribeAclChecksRequest,
    ) -> cloudfw_20171207_models.DescribeAclChecksResponse:
        """
        @summary 批量查询ACL检查条目
        
        @param request: DescribeAclChecksRequest
        @return: DescribeAclChecksResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_acl_checks_with_options(request, runtime)

    async def describe_acl_checks_async(
        self,
        request: cloudfw_20171207_models.DescribeAclChecksRequest,
    ) -> cloudfw_20171207_models.DescribeAclChecksResponse:
        """
        @summary 批量查询ACL检查条目
        
        @param request: DescribeAclChecksRequest
        @return: DescribeAclChecksResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_acl_checks_with_options_async(request, runtime)

    def describe_acl_rule_count_with_options(
        self,
        request: cloudfw_20171207_models.DescribeAclRuleCountRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeAclRuleCountResponse:
        """
        @summary 获取总ACL配置数
        
        @param request: DescribeAclRuleCountRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAclRuleCountResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAclRuleCount',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeAclRuleCountResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_acl_rule_count_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeAclRuleCountRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeAclRuleCountResponse:
        """
        @summary 获取总ACL配置数
        
        @param request: DescribeAclRuleCountRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAclRuleCountResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAclRuleCount',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeAclRuleCountResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_acl_rule_count(
        self,
        request: cloudfw_20171207_models.DescribeAclRuleCountRequest,
    ) -> cloudfw_20171207_models.DescribeAclRuleCountResponse:
        """
        @summary 获取总ACL配置数
        
        @param request: DescribeAclRuleCountRequest
        @return: DescribeAclRuleCountResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_acl_rule_count_with_options(request, runtime)

    async def describe_acl_rule_count_async(
        self,
        request: cloudfw_20171207_models.DescribeAclRuleCountRequest,
    ) -> cloudfw_20171207_models.DescribeAclRuleCountResponse:
        """
        @summary 获取总ACL配置数
        
        @param request: DescribeAclRuleCountRequest
        @return: DescribeAclRuleCountResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_acl_rule_count_with_options_async(request, runtime)

    def describe_acl_whitelist_with_options(
        self,
        request: cloudfw_20171207_models.DescribeAclWhitelistRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeAclWhitelistResponse:
        """
        @summary 获取ACL白名单
        
        @param request: DescribeAclWhitelistRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAclWhitelistResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAclWhitelist',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeAclWhitelistResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_acl_whitelist_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeAclWhitelistRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeAclWhitelistResponse:
        """
        @summary 获取ACL白名单
        
        @param request: DescribeAclWhitelistRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAclWhitelistResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAclWhitelist',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeAclWhitelistResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_acl_whitelist(
        self,
        request: cloudfw_20171207_models.DescribeAclWhitelistRequest,
    ) -> cloudfw_20171207_models.DescribeAclWhitelistResponse:
        """
        @summary 获取ACL白名单
        
        @param request: DescribeAclWhitelistRequest
        @return: DescribeAclWhitelistResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_acl_whitelist_with_options(request, runtime)

    async def describe_acl_whitelist_async(
        self,
        request: cloudfw_20171207_models.DescribeAclWhitelistRequest,
    ) -> cloudfw_20171207_models.DescribeAclWhitelistResponse:
        """
        @summary 获取ACL白名单
        
        @param request: DescribeAclWhitelistRequest
        @return: DescribeAclWhitelistResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_acl_whitelist_with_options_async(request, runtime)

    def describe_address_book_with_options(
        self,
        request: cloudfw_20171207_models.DescribeAddressBookRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeAddressBookResponse:
        """
        @summary Queries the details about an address book for an access control policy.
        
        @description You can call this operation to query the details about an address book for an access control policy.
        ## [](#qps)Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeAddressBookRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAddressBookResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.contain_port):
            query['ContainPort'] = request.contain_port
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.group_type):
            query['GroupType'] = request.group_type
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.query):
            query['Query'] = request.query
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAddressBook',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeAddressBookResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_address_book_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeAddressBookRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeAddressBookResponse:
        """
        @summary Queries the details about an address book for an access control policy.
        
        @description You can call this operation to query the details about an address book for an access control policy.
        ## [](#qps)Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeAddressBookRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAddressBookResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.contain_port):
            query['ContainPort'] = request.contain_port
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.group_type):
            query['GroupType'] = request.group_type
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.query):
            query['Query'] = request.query
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAddressBook',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeAddressBookResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_address_book(
        self,
        request: cloudfw_20171207_models.DescribeAddressBookRequest,
    ) -> cloudfw_20171207_models.DescribeAddressBookResponse:
        """
        @summary Queries the details about an address book for an access control policy.
        
        @description You can call this operation to query the details about an address book for an access control policy.
        ## [](#qps)Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeAddressBookRequest
        @return: DescribeAddressBookResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_address_book_with_options(request, runtime)

    async def describe_address_book_async(
        self,
        request: cloudfw_20171207_models.DescribeAddressBookRequest,
    ) -> cloudfw_20171207_models.DescribeAddressBookResponse:
        """
        @summary Queries the details about an address book for an access control policy.
        
        @description You can call this operation to query the details about an address book for an access control policy.
        ## [](#qps)Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeAddressBookRequest
        @return: DescribeAddressBookResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_address_book_with_options_async(request, runtime)

    def describe_asset_list_with_options(
        self,
        request: cloudfw_20171207_models.DescribeAssetListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeAssetListResponse:
        """
        @summary Queries the assets that are protected by Cloud Firewall.
        
        @description You can call the DescribeAssetList operation to query the assets that are protected by Cloud Firewall.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeAssetListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAssetListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.ip_version):
            query['IpVersion'] = request.ip_version
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.member_uid):
            query['MemberUid'] = request.member_uid
        if not UtilClient.is_unset(request.new_resource_tag):
            query['NewResourceTag'] = request.new_resource_tag
        if not UtilClient.is_unset(request.out_statistic):
            query['OutStatistic'] = request.out_statistic
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_no):
            query['RegionNo'] = request.region_no
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        if not UtilClient.is_unset(request.search_item):
            query['SearchItem'] = request.search_item
        if not UtilClient.is_unset(request.sensitive_status):
            query['SensitiveStatus'] = request.sensitive_status
        if not UtilClient.is_unset(request.sg_status):
            query['SgStatus'] = request.sg_status
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.user_type):
            query['UserType'] = request.user_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAssetList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeAssetListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_asset_list_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeAssetListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeAssetListResponse:
        """
        @summary Queries the assets that are protected by Cloud Firewall.
        
        @description You can call the DescribeAssetList operation to query the assets that are protected by Cloud Firewall.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeAssetListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAssetListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.ip_version):
            query['IpVersion'] = request.ip_version
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.member_uid):
            query['MemberUid'] = request.member_uid
        if not UtilClient.is_unset(request.new_resource_tag):
            query['NewResourceTag'] = request.new_resource_tag
        if not UtilClient.is_unset(request.out_statistic):
            query['OutStatistic'] = request.out_statistic
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_no):
            query['RegionNo'] = request.region_no
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        if not UtilClient.is_unset(request.search_item):
            query['SearchItem'] = request.search_item
        if not UtilClient.is_unset(request.sensitive_status):
            query['SensitiveStatus'] = request.sensitive_status
        if not UtilClient.is_unset(request.sg_status):
            query['SgStatus'] = request.sg_status
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.type):
            query['Type'] = request.type
        if not UtilClient.is_unset(request.user_type):
            query['UserType'] = request.user_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAssetList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeAssetListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_asset_list(
        self,
        request: cloudfw_20171207_models.DescribeAssetListRequest,
    ) -> cloudfw_20171207_models.DescribeAssetListResponse:
        """
        @summary Queries the assets that are protected by Cloud Firewall.
        
        @description You can call the DescribeAssetList operation to query the assets that are protected by Cloud Firewall.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeAssetListRequest
        @return: DescribeAssetListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_asset_list_with_options(request, runtime)

    async def describe_asset_list_async(
        self,
        request: cloudfw_20171207_models.DescribeAssetListRequest,
    ) -> cloudfw_20171207_models.DescribeAssetListResponse:
        """
        @summary Queries the assets that are protected by Cloud Firewall.
        
        @description You can call the DescribeAssetList operation to query the assets that are protected by Cloud Firewall.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeAssetListRequest
        @return: DescribeAssetListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_asset_list_with_options_async(request, runtime)

    def describe_asset_risk_list_with_options(
        self,
        request: cloudfw_20171207_models.DescribeAssetRiskListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeAssetRiskListResponse:
        """
        @summary Queries the risk levels of assets.
        
        @param request: DescribeAssetRiskListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAssetRiskListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ip_addr_list):
            query['IpAddrList'] = request.ip_addr_list
        if not UtilClient.is_unset(request.ip_version):
            query['IpVersion'] = request.ip_version
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAssetRiskList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeAssetRiskListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_asset_risk_list_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeAssetRiskListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeAssetRiskListResponse:
        """
        @summary Queries the risk levels of assets.
        
        @param request: DescribeAssetRiskListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAssetRiskListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.ip_addr_list):
            query['IpAddrList'] = request.ip_addr_list
        if not UtilClient.is_unset(request.ip_version):
            query['IpVersion'] = request.ip_version
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAssetRiskList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeAssetRiskListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_asset_risk_list(
        self,
        request: cloudfw_20171207_models.DescribeAssetRiskListRequest,
    ) -> cloudfw_20171207_models.DescribeAssetRiskListResponse:
        """
        @summary Queries the risk levels of assets.
        
        @param request: DescribeAssetRiskListRequest
        @return: DescribeAssetRiskListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_asset_risk_list_with_options(request, runtime)

    async def describe_asset_risk_list_async(
        self,
        request: cloudfw_20171207_models.DescribeAssetRiskListRequest,
    ) -> cloudfw_20171207_models.DescribeAssetRiskListResponse:
        """
        @summary Queries the risk levels of assets.
        
        @param request: DescribeAssetRiskListRequest
        @return: DescribeAssetRiskListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_asset_risk_list_with_options_async(request, runtime)

    def describe_asset_statistic_with_options(
        self,
        request: cloudfw_20171207_models.DescribeAssetStatisticRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeAssetStatisticResponse:
        """
        @summary Queries statistics on the assets that are protected by Cloud Firewall.
        
        @param request: DescribeAssetStatisticRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAssetStatisticResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAssetStatistic',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeAssetStatisticResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_asset_statistic_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeAssetStatisticRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeAssetStatisticResponse:
        """
        @summary Queries statistics on the assets that are protected by Cloud Firewall.
        
        @param request: DescribeAssetStatisticRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAssetStatisticResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAssetStatistic',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeAssetStatisticResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_asset_statistic(
        self,
        request: cloudfw_20171207_models.DescribeAssetStatisticRequest,
    ) -> cloudfw_20171207_models.DescribeAssetStatisticResponse:
        """
        @summary Queries statistics on the assets that are protected by Cloud Firewall.
        
        @param request: DescribeAssetStatisticRequest
        @return: DescribeAssetStatisticResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_asset_statistic_with_options(request, runtime)

    async def describe_asset_statistic_async(
        self,
        request: cloudfw_20171207_models.DescribeAssetStatisticRequest,
    ) -> cloudfw_20171207_models.DescribeAssetStatisticResponse:
        """
        @summary Queries statistics on the assets that are protected by Cloud Firewall.
        
        @param request: DescribeAssetStatisticRequest
        @return: DescribeAssetStatisticResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_asset_statistic_with_options_async(request, runtime)

    def describe_attack_app_category_with_options(
        self,
        request: cloudfw_20171207_models.DescribeAttackAppCategoryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeAttackAppCategoryResponse:
        """
        @summary 获取敏感数据类别开关
        
        @param request: DescribeAttackAppCategoryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAttackAppCategoryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAttackAppCategory',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeAttackAppCategoryResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_attack_app_category_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeAttackAppCategoryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeAttackAppCategoryResponse:
        """
        @summary 获取敏感数据类别开关
        
        @param request: DescribeAttackAppCategoryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeAttackAppCategoryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeAttackAppCategory',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeAttackAppCategoryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_attack_app_category(
        self,
        request: cloudfw_20171207_models.DescribeAttackAppCategoryRequest,
    ) -> cloudfw_20171207_models.DescribeAttackAppCategoryResponse:
        """
        @summary 获取敏感数据类别开关
        
        @param request: DescribeAttackAppCategoryRequest
        @return: DescribeAttackAppCategoryResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_attack_app_category_with_options(request, runtime)

    async def describe_attack_app_category_async(
        self,
        request: cloudfw_20171207_models.DescribeAttackAppCategoryRequest,
    ) -> cloudfw_20171207_models.DescribeAttackAppCategoryResponse:
        """
        @summary 获取敏感数据类别开关
        
        @param request: DescribeAttackAppCategoryRequest
        @return: DescribeAttackAppCategoryResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_attack_app_category_with_options_async(request, runtime)

    def describe_batch_sls_dispatch_status_with_options(
        self,
        request: cloudfw_20171207_models.DescribeBatchSlsDispatchStatusRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeBatchSlsDispatchStatusResponse:
        """
        @summary 获取日志分发状态
        
        @param request: DescribeBatchSlsDispatchStatusRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeBatchSlsDispatchStatusResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBatchSlsDispatchStatus',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeBatchSlsDispatchStatusResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_batch_sls_dispatch_status_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeBatchSlsDispatchStatusRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeBatchSlsDispatchStatusResponse:
        """
        @summary 获取日志分发状态
        
        @param request: DescribeBatchSlsDispatchStatusRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeBatchSlsDispatchStatusResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeBatchSlsDispatchStatus',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeBatchSlsDispatchStatusResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_batch_sls_dispatch_status(
        self,
        request: cloudfw_20171207_models.DescribeBatchSlsDispatchStatusRequest,
    ) -> cloudfw_20171207_models.DescribeBatchSlsDispatchStatusResponse:
        """
        @summary 获取日志分发状态
        
        @param request: DescribeBatchSlsDispatchStatusRequest
        @return: DescribeBatchSlsDispatchStatusResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_batch_sls_dispatch_status_with_options(request, runtime)

    async def describe_batch_sls_dispatch_status_async(
        self,
        request: cloudfw_20171207_models.DescribeBatchSlsDispatchStatusRequest,
    ) -> cloudfw_20171207_models.DescribeBatchSlsDispatchStatusResponse:
        """
        @summary 获取日志分发状态
        
        @param request: DescribeBatchSlsDispatchStatusRequest
        @return: DescribeBatchSlsDispatchStatusResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_batch_sls_dispatch_status_with_options_async(request, runtime)

    def describe_cfw_risk_level_summary_with_options(
        self,
        request: cloudfw_20171207_models.DescribeCfwRiskLevelSummaryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeCfwRiskLevelSummaryResponse:
        """
        @deprecated OpenAPI DescribeCfwRiskLevelSummary is deprecated
        
        @summary Queries the firewall risk level.
        
        @param request: DescribeCfwRiskLevelSummaryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCfwRiskLevelSummaryResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCfwRiskLevelSummary',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeCfwRiskLevelSummaryResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_cfw_risk_level_summary_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeCfwRiskLevelSummaryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeCfwRiskLevelSummaryResponse:
        """
        @deprecated OpenAPI DescribeCfwRiskLevelSummary is deprecated
        
        @summary Queries the firewall risk level.
        
        @param request: DescribeCfwRiskLevelSummaryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCfwRiskLevelSummaryResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_type):
            query['InstanceType'] = request.instance_type
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCfwRiskLevelSummary',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeCfwRiskLevelSummaryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_cfw_risk_level_summary(
        self,
        request: cloudfw_20171207_models.DescribeCfwRiskLevelSummaryRequest,
    ) -> cloudfw_20171207_models.DescribeCfwRiskLevelSummaryResponse:
        """
        @deprecated OpenAPI DescribeCfwRiskLevelSummary is deprecated
        
        @summary Queries the firewall risk level.
        
        @param request: DescribeCfwRiskLevelSummaryRequest
        @return: DescribeCfwRiskLevelSummaryResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_cfw_risk_level_summary_with_options(request, runtime)

    async def describe_cfw_risk_level_summary_async(
        self,
        request: cloudfw_20171207_models.DescribeCfwRiskLevelSummaryRequest,
    ) -> cloudfw_20171207_models.DescribeCfwRiskLevelSummaryResponse:
        """
        @deprecated OpenAPI DescribeCfwRiskLevelSummary is deprecated
        
        @summary Queries the firewall risk level.
        
        @param request: DescribeCfwRiskLevelSummaryRequest
        @return: DescribeCfwRiskLevelSummaryResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_cfw_risk_level_summary_with_options_async(request, runtime)

    def describe_clear_auth_info_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeClearAuthInfoResponse:
        """
        @summary 获取清空授权信息
        
        @param request: DescribeClearAuthInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeClearAuthInfoResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeClearAuthInfo',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeClearAuthInfoResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_clear_auth_info_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeClearAuthInfoResponse:
        """
        @summary 获取清空授权信息
        
        @param request: DescribeClearAuthInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeClearAuthInfoResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeClearAuthInfo',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeClearAuthInfoResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_clear_auth_info(self) -> cloudfw_20171207_models.DescribeClearAuthInfoResponse:
        """
        @summary 获取清空授权信息
        
        @return: DescribeClearAuthInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_clear_auth_info_with_options(runtime)

    async def describe_clear_auth_info_async(self) -> cloudfw_20171207_models.DescribeClearAuthInfoResponse:
        """
        @summary 获取清空授权信息
        
        @return: DescribeClearAuthInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_clear_auth_info_with_options_async(runtime)

    def describe_configured_destination_ipwith_options(
        self,
        request: cloudfw_20171207_models.DescribeConfiguredDestinationIPRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeConfiguredDestinationIPResponse:
        """
        @summary 获取已配置的目的IP
        
        @param request: DescribeConfiguredDestinationIPRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeConfiguredDestinationIPResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.destination_ip):
            query['DestinationIP'] = request.destination_ip
        if not UtilClient.is_unset(request.destination_isp):
            query['DestinationISP'] = request.destination_isp
        if not UtilClient.is_unset(request.destination_region):
            query['DestinationRegion'] = request.destination_region
        if not UtilClient.is_unset(request.direction):
            query['Direction'] = request.direction
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.source_code):
            query['SourceCode'] = request.source_code
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeConfiguredDestinationIP',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeConfiguredDestinationIPResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_configured_destination_ipwith_options_async(
        self,
        request: cloudfw_20171207_models.DescribeConfiguredDestinationIPRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeConfiguredDestinationIPResponse:
        """
        @summary 获取已配置的目的IP
        
        @param request: DescribeConfiguredDestinationIPRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeConfiguredDestinationIPResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.destination_ip):
            query['DestinationIP'] = request.destination_ip
        if not UtilClient.is_unset(request.destination_isp):
            query['DestinationISP'] = request.destination_isp
        if not UtilClient.is_unset(request.destination_region):
            query['DestinationRegion'] = request.destination_region
        if not UtilClient.is_unset(request.direction):
            query['Direction'] = request.direction
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.source_code):
            query['SourceCode'] = request.source_code
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeConfiguredDestinationIP',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeConfiguredDestinationIPResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_configured_destination_ip(
        self,
        request: cloudfw_20171207_models.DescribeConfiguredDestinationIPRequest,
    ) -> cloudfw_20171207_models.DescribeConfiguredDestinationIPResponse:
        """
        @summary 获取已配置的目的IP
        
        @param request: DescribeConfiguredDestinationIPRequest
        @return: DescribeConfiguredDestinationIPResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_configured_destination_ipwith_options(request, runtime)

    async def describe_configured_destination_ip_async(
        self,
        request: cloudfw_20171207_models.DescribeConfiguredDestinationIPRequest,
    ) -> cloudfw_20171207_models.DescribeConfiguredDestinationIPResponse:
        """
        @summary 获取已配置的目的IP
        
        @param request: DescribeConfiguredDestinationIPRequest
        @return: DescribeConfiguredDestinationIPResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_configured_destination_ipwith_options_async(request, runtime)

    def describe_configured_domain_names_with_options(
        self,
        request: cloudfw_20171207_models.DescribeConfiguredDomainNamesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeConfiguredDomainNamesResponse:
        """
        @summary 获取已配置的域名
        
        @param request: DescribeConfiguredDomainNamesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeConfiguredDomainNamesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.direction):
            query['Direction'] = request.direction
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.source_code):
            query['SourceCode'] = request.source_code
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeConfiguredDomainNames',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeConfiguredDomainNamesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_configured_domain_names_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeConfiguredDomainNamesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeConfiguredDomainNamesResponse:
        """
        @summary 获取已配置的域名
        
        @param request: DescribeConfiguredDomainNamesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeConfiguredDomainNamesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.direction):
            query['Direction'] = request.direction
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.source_code):
            query['SourceCode'] = request.source_code
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeConfiguredDomainNames',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeConfiguredDomainNamesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_configured_domain_names(
        self,
        request: cloudfw_20171207_models.DescribeConfiguredDomainNamesRequest,
    ) -> cloudfw_20171207_models.DescribeConfiguredDomainNamesResponse:
        """
        @summary 获取已配置的域名
        
        @param request: DescribeConfiguredDomainNamesRequest
        @return: DescribeConfiguredDomainNamesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_configured_domain_names_with_options(request, runtime)

    async def describe_configured_domain_names_async(
        self,
        request: cloudfw_20171207_models.DescribeConfiguredDomainNamesRequest,
    ) -> cloudfw_20171207_models.DescribeConfiguredDomainNamesResponse:
        """
        @summary 获取已配置的域名
        
        @param request: DescribeConfiguredDomainNamesRequest
        @return: DescribeConfiguredDomainNamesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_configured_domain_names_with_options_async(request, runtime)

    def describe_control_policy_with_options(
        self,
        request: cloudfw_20171207_models.DescribeControlPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeControlPolicyResponse:
        """
        @summary Queries the details about all access control policies.
        
        @description You can call the DescribeControlPolicy operation to query the details about access control policies by page.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeControlPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeControlPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_action):
            query['AclAction'] = request.acl_action
        if not UtilClient.is_unset(request.acl_uuid):
            query['AclUuid'] = request.acl_uuid
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.destination):
            query['Destination'] = request.destination
        if not UtilClient.is_unset(request.direction):
            query['Direction'] = request.direction
        if not UtilClient.is_unset(request.ip_version):
            query['IpVersion'] = request.ip_version
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.proto):
            query['Proto'] = request.proto
        if not UtilClient.is_unset(request.release):
            query['Release'] = request.release
        if not UtilClient.is_unset(request.repeat_type):
            query['RepeatType'] = request.repeat_type
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeControlPolicy',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeControlPolicyResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_control_policy_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeControlPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeControlPolicyResponse:
        """
        @summary Queries the details about all access control policies.
        
        @description You can call the DescribeControlPolicy operation to query the details about access control policies by page.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeControlPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeControlPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_action):
            query['AclAction'] = request.acl_action
        if not UtilClient.is_unset(request.acl_uuid):
            query['AclUuid'] = request.acl_uuid
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.destination):
            query['Destination'] = request.destination
        if not UtilClient.is_unset(request.direction):
            query['Direction'] = request.direction
        if not UtilClient.is_unset(request.ip_version):
            query['IpVersion'] = request.ip_version
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.proto):
            query['Proto'] = request.proto
        if not UtilClient.is_unset(request.release):
            query['Release'] = request.release
        if not UtilClient.is_unset(request.repeat_type):
            query['RepeatType'] = request.repeat_type
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeControlPolicy',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeControlPolicyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_control_policy(
        self,
        request: cloudfw_20171207_models.DescribeControlPolicyRequest,
    ) -> cloudfw_20171207_models.DescribeControlPolicyResponse:
        """
        @summary Queries the details about all access control policies.
        
        @description You can call the DescribeControlPolicy operation to query the details about access control policies by page.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeControlPolicyRequest
        @return: DescribeControlPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_control_policy_with_options(request, runtime)

    async def describe_control_policy_async(
        self,
        request: cloudfw_20171207_models.DescribeControlPolicyRequest,
    ) -> cloudfw_20171207_models.DescribeControlPolicyResponse:
        """
        @summary Queries the details about all access control policies.
        
        @description You can call the DescribeControlPolicy operation to query the details about access control policies by page.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeControlPolicyRequest
        @return: DescribeControlPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_control_policy_with_options_async(request, runtime)

    def describe_control_policy_domain_resolve_with_options(
        self,
        request: cloudfw_20171207_models.DescribeControlPolicyDomainResolveRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeControlPolicyDomainResolveResponse:
        """
        @summary 查询访问控制策略的域名解析结果
        
        @param request: DescribeControlPolicyDomainResolveRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeControlPolicyDomainResolveResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeControlPolicyDomainResolve',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeControlPolicyDomainResolveResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_control_policy_domain_resolve_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeControlPolicyDomainResolveRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeControlPolicyDomainResolveResponse:
        """
        @summary 查询访问控制策略的域名解析结果
        
        @param request: DescribeControlPolicyDomainResolveRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeControlPolicyDomainResolveResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeControlPolicyDomainResolve',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeControlPolicyDomainResolveResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_control_policy_domain_resolve(
        self,
        request: cloudfw_20171207_models.DescribeControlPolicyDomainResolveRequest,
    ) -> cloudfw_20171207_models.DescribeControlPolicyDomainResolveResponse:
        """
        @summary 查询访问控制策略的域名解析结果
        
        @param request: DescribeControlPolicyDomainResolveRequest
        @return: DescribeControlPolicyDomainResolveResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_control_policy_domain_resolve_with_options(request, runtime)

    async def describe_control_policy_domain_resolve_async(
        self,
        request: cloudfw_20171207_models.DescribeControlPolicyDomainResolveRequest,
    ) -> cloudfw_20171207_models.DescribeControlPolicyDomainResolveResponse:
        """
        @summary 查询访问控制策略的域名解析结果
        
        @param request: DescribeControlPolicyDomainResolveRequest
        @return: DescribeControlPolicyDomainResolveResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_control_policy_domain_resolve_with_options_async(request, runtime)

    def describe_created_nat_firewall_with_options(
        self,
        request: cloudfw_20171207_models.DescribeCreatedNatFirewallRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeCreatedNatFirewallResponse:
        """
        @summary 获取已经创建的 NAT 防火墙
        
        @param request: DescribeCreatedNatFirewallRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCreatedNatFirewallResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCreatedNatFirewall',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeCreatedNatFirewallResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_created_nat_firewall_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeCreatedNatFirewallRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeCreatedNatFirewallResponse:
        """
        @summary 获取已经创建的 NAT 防火墙
        
        @param request: DescribeCreatedNatFirewallRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCreatedNatFirewallResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeCreatedNatFirewall',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeCreatedNatFirewallResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_created_nat_firewall(
        self,
        request: cloudfw_20171207_models.DescribeCreatedNatFirewallRequest,
    ) -> cloudfw_20171207_models.DescribeCreatedNatFirewallResponse:
        """
        @summary 获取已经创建的 NAT 防火墙
        
        @param request: DescribeCreatedNatFirewallRequest
        @return: DescribeCreatedNatFirewallResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_created_nat_firewall_with_options(request, runtime)

    async def describe_created_nat_firewall_async(
        self,
        request: cloudfw_20171207_models.DescribeCreatedNatFirewallRequest,
    ) -> cloudfw_20171207_models.DescribeCreatedNatFirewallResponse:
        """
        @summary 获取已经创建的 NAT 防火墙
        
        @param request: DescribeCreatedNatFirewallRequest
        @return: DescribeCreatedNatFirewallResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_created_nat_firewall_with_options_async(request, runtime)

    def describe_ctrl_instance_member_accounts_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeCtrlInstanceMemberAccountsResponse:
        """
        @summary 获取成员账号列表
        
        @param request: DescribeCtrlInstanceMemberAccountsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCtrlInstanceMemberAccountsResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeCtrlInstanceMemberAccounts',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeCtrlInstanceMemberAccountsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_ctrl_instance_member_accounts_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeCtrlInstanceMemberAccountsResponse:
        """
        @summary 获取成员账号列表
        
        @param request: DescribeCtrlInstanceMemberAccountsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeCtrlInstanceMemberAccountsResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeCtrlInstanceMemberAccounts',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeCtrlInstanceMemberAccountsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_ctrl_instance_member_accounts(self) -> cloudfw_20171207_models.DescribeCtrlInstanceMemberAccountsResponse:
        """
        @summary 获取成员账号列表
        
        @return: DescribeCtrlInstanceMemberAccountsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_ctrl_instance_member_accounts_with_options(runtime)

    async def describe_ctrl_instance_member_accounts_async(self) -> cloudfw_20171207_models.DescribeCtrlInstanceMemberAccountsResponse:
        """
        @summary 获取成员账号列表
        
        @return: DescribeCtrlInstanceMemberAccountsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_ctrl_instance_member_accounts_with_options_async(runtime)

    def describe_default_ipsconfig_with_options(
        self,
        request: cloudfw_20171207_models.DescribeDefaultIPSConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeDefaultIPSConfigResponse:
        """
        @summary Queries the default intrusion prevention system (IPS) configurations.
        
        @param request: DescribeDefaultIPSConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDefaultIPSConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDefaultIPSConfig',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeDefaultIPSConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_default_ipsconfig_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeDefaultIPSConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeDefaultIPSConfigResponse:
        """
        @summary Queries the default intrusion prevention system (IPS) configurations.
        
        @param request: DescribeDefaultIPSConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDefaultIPSConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDefaultIPSConfig',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeDefaultIPSConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_default_ipsconfig(
        self,
        request: cloudfw_20171207_models.DescribeDefaultIPSConfigRequest,
    ) -> cloudfw_20171207_models.DescribeDefaultIPSConfigResponse:
        """
        @summary Queries the default intrusion prevention system (IPS) configurations.
        
        @param request: DescribeDefaultIPSConfigRequest
        @return: DescribeDefaultIPSConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_default_ipsconfig_with_options(request, runtime)

    async def describe_default_ipsconfig_async(
        self,
        request: cloudfw_20171207_models.DescribeDefaultIPSConfigRequest,
    ) -> cloudfw_20171207_models.DescribeDefaultIPSConfigResponse:
        """
        @summary Queries the default intrusion prevention system (IPS) configurations.
        
        @param request: DescribeDefaultIPSConfigRequest
        @return: DescribeDefaultIPSConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_default_ipsconfig_with_options_async(request, runtime)

    def describe_dns_firewall_policy_with_options(
        self,
        request: cloudfw_20171207_models.DescribeDnsFirewallPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeDnsFirewallPolicyResponse:
        """
        @summary 获取DNS防火墙ACL列表
        
        @param request: DescribeDnsFirewallPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDnsFirewallPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_action):
            query['AclAction'] = request.acl_action
        if not UtilClient.is_unset(request.acl_uuid):
            query['AclUuid'] = request.acl_uuid
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.destination):
            query['Destination'] = request.destination
        if not UtilClient.is_unset(request.ip_version):
            query['IpVersion'] = request.ip_version
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.release):
            query['Release'] = request.release
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDnsFirewallPolicy',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeDnsFirewallPolicyResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_dns_firewall_policy_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeDnsFirewallPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeDnsFirewallPolicyResponse:
        """
        @summary 获取DNS防火墙ACL列表
        
        @param request: DescribeDnsFirewallPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDnsFirewallPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_action):
            query['AclAction'] = request.acl_action
        if not UtilClient.is_unset(request.acl_uuid):
            query['AclUuid'] = request.acl_uuid
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.destination):
            query['Destination'] = request.destination
        if not UtilClient.is_unset(request.ip_version):
            query['IpVersion'] = request.ip_version
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.release):
            query['Release'] = request.release
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDnsFirewallPolicy',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeDnsFirewallPolicyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_dns_firewall_policy(
        self,
        request: cloudfw_20171207_models.DescribeDnsFirewallPolicyRequest,
    ) -> cloudfw_20171207_models.DescribeDnsFirewallPolicyResponse:
        """
        @summary 获取DNS防火墙ACL列表
        
        @param request: DescribeDnsFirewallPolicyRequest
        @return: DescribeDnsFirewallPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_dns_firewall_policy_with_options(request, runtime)

    async def describe_dns_firewall_policy_async(
        self,
        request: cloudfw_20171207_models.DescribeDnsFirewallPolicyRequest,
    ) -> cloudfw_20171207_models.DescribeDnsFirewallPolicyResponse:
        """
        @summary 获取DNS防火墙ACL列表
        
        @param request: DescribeDnsFirewallPolicyRequest
        @return: DescribeDnsFirewallPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_dns_firewall_policy_with_options_async(request, runtime)

    def describe_domain_resolve_with_options(
        self,
        request: cloudfw_20171207_models.DescribeDomainResolveRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeDomainResolveResponse:
        """
        @deprecated OpenAPI DescribeDomainResolve is deprecated
        
        @summary Queries Domain Name System (DNS) records.
        
        @description You can use this operation to query the DNS record of a domain name. This operation can retrieve DNS records only from Alibaba Cloud DNS. Before you can call this operation, make sure that your domain name is hosted on Alibaba Cloud DNS.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeDomainResolveRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDomainResolveResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.domain):
            query['Domain'] = request.domain
        if not UtilClient.is_unset(request.ip_version):
            query['IpVersion'] = request.ip_version
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDomainResolve',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeDomainResolveResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_domain_resolve_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeDomainResolveRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeDomainResolveResponse:
        """
        @deprecated OpenAPI DescribeDomainResolve is deprecated
        
        @summary Queries Domain Name System (DNS) records.
        
        @description You can use this operation to query the DNS record of a domain name. This operation can retrieve DNS records only from Alibaba Cloud DNS. Before you can call this operation, make sure that your domain name is hosted on Alibaba Cloud DNS.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeDomainResolveRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDomainResolveResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.domain):
            query['Domain'] = request.domain
        if not UtilClient.is_unset(request.ip_version):
            query['IpVersion'] = request.ip_version
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDomainResolve',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeDomainResolveResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_domain_resolve(
        self,
        request: cloudfw_20171207_models.DescribeDomainResolveRequest,
    ) -> cloudfw_20171207_models.DescribeDomainResolveResponse:
        """
        @deprecated OpenAPI DescribeDomainResolve is deprecated
        
        @summary Queries Domain Name System (DNS) records.
        
        @description You can use this operation to query the DNS record of a domain name. This operation can retrieve DNS records only from Alibaba Cloud DNS. Before you can call this operation, make sure that your domain name is hosted on Alibaba Cloud DNS.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeDomainResolveRequest
        @return: DescribeDomainResolveResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_domain_resolve_with_options(request, runtime)

    async def describe_domain_resolve_async(
        self,
        request: cloudfw_20171207_models.DescribeDomainResolveRequest,
    ) -> cloudfw_20171207_models.DescribeDomainResolveResponse:
        """
        @deprecated OpenAPI DescribeDomainResolve is deprecated
        
        @summary Queries Domain Name System (DNS) records.
        
        @description You can use this operation to query the DNS record of a domain name. This operation can retrieve DNS records only from Alibaba Cloud DNS. Before you can call this operation, make sure that your domain name is hosted on Alibaba Cloud DNS.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeDomainResolveRequest
        @return: DescribeDomainResolveResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_domain_resolve_with_options_async(request, runtime)

    def describe_download_task_with_options(
        self,
        request: cloudfw_20171207_models.DescribeDownloadTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeDownloadTaskResponse:
        """
        @summary Queries file download tasks, including the task information and download URLs.
        
        @param request: DescribeDownloadTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDownloadTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.task_type):
            query['TaskType'] = request.task_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDownloadTask',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeDownloadTaskResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_download_task_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeDownloadTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeDownloadTaskResponse:
        """
        @summary Queries file download tasks, including the task information and download URLs.
        
        @param request: DescribeDownloadTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDownloadTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.task_type):
            query['TaskType'] = request.task_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDownloadTask',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeDownloadTaskResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_download_task(
        self,
        request: cloudfw_20171207_models.DescribeDownloadTaskRequest,
    ) -> cloudfw_20171207_models.DescribeDownloadTaskResponse:
        """
        @summary Queries file download tasks, including the task information and download URLs.
        
        @param request: DescribeDownloadTaskRequest
        @return: DescribeDownloadTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_download_task_with_options(request, runtime)

    async def describe_download_task_async(
        self,
        request: cloudfw_20171207_models.DescribeDownloadTaskRequest,
    ) -> cloudfw_20171207_models.DescribeDownloadTaskResponse:
        """
        @summary Queries file download tasks, including the task information and download URLs.
        
        @param request: DescribeDownloadTaskRequest
        @return: DescribeDownloadTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_download_task_with_options_async(request, runtime)

    def describe_download_task_type_with_options(
        self,
        request: cloudfw_20171207_models.DescribeDownloadTaskTypeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeDownloadTaskTypeResponse:
        """
        @summary Queries the types of download tasks. The type corresponds to the TaskType fields in the download task-related operations.
        
        @param request: DescribeDownloadTaskTypeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDownloadTaskTypeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.task_type):
            query['TaskType'] = request.task_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDownloadTaskType',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeDownloadTaskTypeResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_download_task_type_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeDownloadTaskTypeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeDownloadTaskTypeResponse:
        """
        @summary Queries the types of download tasks. The type corresponds to the TaskType fields in the download task-related operations.
        
        @param request: DescribeDownloadTaskTypeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeDownloadTaskTypeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.task_type):
            query['TaskType'] = request.task_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeDownloadTaskType',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeDownloadTaskTypeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_download_task_type(
        self,
        request: cloudfw_20171207_models.DescribeDownloadTaskTypeRequest,
    ) -> cloudfw_20171207_models.DescribeDownloadTaskTypeResponse:
        """
        @summary Queries the types of download tasks. The type corresponds to the TaskType fields in the download task-related operations.
        
        @param request: DescribeDownloadTaskTypeRequest
        @return: DescribeDownloadTaskTypeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_download_task_type_with_options(request, runtime)

    async def describe_download_task_type_async(
        self,
        request: cloudfw_20171207_models.DescribeDownloadTaskTypeRequest,
    ) -> cloudfw_20171207_models.DescribeDownloadTaskTypeResponse:
        """
        @summary Queries the types of download tasks. The type corresponds to the TaskType fields in the download task-related operations.
        
        @param request: DescribeDownloadTaskTypeRequest
        @return: DescribeDownloadTaskTypeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_download_task_type_with_options_async(request, runtime)

    def describe_firewall_drop_statistics_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeFirewallDropStatisticsResponse:
        """
        @deprecated OpenAPI DescribeFirewallDropStatistics is deprecated
        
        @summary 获取防火墙DROP数据统计
        
        @param request: DescribeFirewallDropStatisticsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeFirewallDropStatisticsResponse
        Deprecated
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeFirewallDropStatistics',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeFirewallDropStatisticsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_firewall_drop_statistics_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeFirewallDropStatisticsResponse:
        """
        @deprecated OpenAPI DescribeFirewallDropStatistics is deprecated
        
        @summary 获取防火墙DROP数据统计
        
        @param request: DescribeFirewallDropStatisticsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeFirewallDropStatisticsResponse
        Deprecated
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeFirewallDropStatistics',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeFirewallDropStatisticsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_firewall_drop_statistics(self) -> cloudfw_20171207_models.DescribeFirewallDropStatisticsResponse:
        """
        @deprecated OpenAPI DescribeFirewallDropStatistics is deprecated
        
        @summary 获取防火墙DROP数据统计
        
        @return: DescribeFirewallDropStatisticsResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_firewall_drop_statistics_with_options(runtime)

    async def describe_firewall_drop_statistics_async(self) -> cloudfw_20171207_models.DescribeFirewallDropStatisticsResponse:
        """
        @deprecated OpenAPI DescribeFirewallDropStatistics is deprecated
        
        @summary 获取防火墙DROP数据统计
        
        @return: DescribeFirewallDropStatisticsResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_firewall_drop_statistics_with_options_async(runtime)

    def describe_firewall_task_with_options(
        self,
        request: cloudfw_20171207_models.DescribeFirewallTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeFirewallTaskResponse:
        """
        @summary 获取防火墙任务
        
        @param request: DescribeFirewallTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeFirewallTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.child_instance_id):
            query['ChildInstanceId'] = request.child_instance_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.task_id):
            query['TaskId'] = request.task_id
        if not UtilClient.is_unset(request.task_type):
            query['TaskType'] = request.task_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeFirewallTask',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeFirewallTaskResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_firewall_task_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeFirewallTaskRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeFirewallTaskResponse:
        """
        @summary 获取防火墙任务
        
        @param request: DescribeFirewallTaskRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeFirewallTaskResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.child_instance_id):
            query['ChildInstanceId'] = request.child_instance_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.task_id):
            query['TaskId'] = request.task_id
        if not UtilClient.is_unset(request.task_type):
            query['TaskType'] = request.task_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeFirewallTask',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeFirewallTaskResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_firewall_task(
        self,
        request: cloudfw_20171207_models.DescribeFirewallTaskRequest,
    ) -> cloudfw_20171207_models.DescribeFirewallTaskResponse:
        """
        @summary 获取防火墙任务
        
        @param request: DescribeFirewallTaskRequest
        @return: DescribeFirewallTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_firewall_task_with_options(request, runtime)

    async def describe_firewall_task_async(
        self,
        request: cloudfw_20171207_models.DescribeFirewallTaskRequest,
    ) -> cloudfw_20171207_models.DescribeFirewallTaskResponse:
        """
        @summary 获取防火墙任务
        
        @param request: DescribeFirewallTaskRequest
        @return: DescribeFirewallTaskResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_firewall_task_with_options_async(request, runtime)

    def describe_firewall_vswitch_with_options(
        self,
        request: cloudfw_20171207_models.DescribeFirewallVSwitchRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeFirewallVSwitchResponse:
        """
        @summary 获取防火墙创建的交换机
        
        @param request: DescribeFirewallVSwitchRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeFirewallVSwitchResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.firewall_id):
            query['FirewallId'] = request.firewall_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.member_uid):
            query['MemberUid'] = request.member_uid
        if not UtilClient.is_unset(request.page_no):
            query['PageNo'] = request.page_no
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_no):
            query['RegionNo'] = request.region_no
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        if not UtilClient.is_unset(request.vswitch_id):
            query['VswitchId'] = request.vswitch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeFirewallVSwitch',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeFirewallVSwitchResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_firewall_vswitch_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeFirewallVSwitchRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeFirewallVSwitchResponse:
        """
        @summary 获取防火墙创建的交换机
        
        @param request: DescribeFirewallVSwitchRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeFirewallVSwitchResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.firewall_id):
            query['FirewallId'] = request.firewall_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.member_uid):
            query['MemberUid'] = request.member_uid
        if not UtilClient.is_unset(request.page_no):
            query['PageNo'] = request.page_no
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_no):
            query['RegionNo'] = request.region_no
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        if not UtilClient.is_unset(request.vswitch_id):
            query['VswitchId'] = request.vswitch_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeFirewallVSwitch',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeFirewallVSwitchResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_firewall_vswitch(
        self,
        request: cloudfw_20171207_models.DescribeFirewallVSwitchRequest,
    ) -> cloudfw_20171207_models.DescribeFirewallVSwitchResponse:
        """
        @summary 获取防火墙创建的交换机
        
        @param request: DescribeFirewallVSwitchRequest
        @return: DescribeFirewallVSwitchResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_firewall_vswitch_with_options(request, runtime)

    async def describe_firewall_vswitch_async(
        self,
        request: cloudfw_20171207_models.DescribeFirewallVSwitchRequest,
    ) -> cloudfw_20171207_models.DescribeFirewallVSwitchResponse:
        """
        @summary 获取防火墙创建的交换机
        
        @param request: DescribeFirewallVSwitchRequest
        @return: DescribeFirewallVSwitchResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_firewall_vswitch_with_options_async(request, runtime)

    def describe_firewall_vswitch_resources_with_options(
        self,
        request: cloudfw_20171207_models.DescribeFirewallVswitchResourcesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeFirewallVswitchResourcesResponse:
        """
        @summary 获取防火墙交换机资源
        
        @param request: DescribeFirewallVswitchResourcesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeFirewallVswitchResourcesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.firewall_type):
            query['FirewallType'] = request.firewall_type
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.region_no):
            query['RegionNo'] = request.region_no
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeFirewallVswitchResources',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeFirewallVswitchResourcesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_firewall_vswitch_resources_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeFirewallVswitchResourcesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeFirewallVswitchResourcesResponse:
        """
        @summary 获取防火墙交换机资源
        
        @param request: DescribeFirewallVswitchResourcesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeFirewallVswitchResourcesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.firewall_type):
            query['FirewallType'] = request.firewall_type
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.region_no):
            query['RegionNo'] = request.region_no
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeFirewallVswitchResources',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeFirewallVswitchResourcesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_firewall_vswitch_resources(
        self,
        request: cloudfw_20171207_models.DescribeFirewallVswitchResourcesRequest,
    ) -> cloudfw_20171207_models.DescribeFirewallVswitchResourcesResponse:
        """
        @summary 获取防火墙交换机资源
        
        @param request: DescribeFirewallVswitchResourcesRequest
        @return: DescribeFirewallVswitchResourcesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_firewall_vswitch_resources_with_options(request, runtime)

    async def describe_firewall_vswitch_resources_async(
        self,
        request: cloudfw_20171207_models.DescribeFirewallVswitchResourcesRequest,
    ) -> cloudfw_20171207_models.DescribeFirewallVswitchResourcesResponse:
        """
        @summary 获取防火墙交换机资源
        
        @param request: DescribeFirewallVswitchResourcesRequest
        @return: DescribeFirewallVswitchResourcesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_firewall_vswitch_resources_with_options_async(request, runtime)

    def describe_instance_members_with_options(
        self,
        request: cloudfw_20171207_models.DescribeInstanceMembersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeInstanceMembersResponse:
        """
        @summary Queries the information about members in Cloud Firewall.
        
        @description You can use this operation to query the information about members in Cloud Firewall.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeInstanceMembersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInstanceMembersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.member_desc):
            query['MemberDesc'] = request.member_desc
        if not UtilClient.is_unset(request.member_display_name):
            query['MemberDisplayName'] = request.member_display_name
        if not UtilClient.is_unset(request.member_uid):
            query['MemberUid'] = request.member_uid
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInstanceMembers',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeInstanceMembersResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_instance_members_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeInstanceMembersRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeInstanceMembersResponse:
        """
        @summary Queries the information about members in Cloud Firewall.
        
        @description You can use this operation to query the information about members in Cloud Firewall.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeInstanceMembersRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInstanceMembersResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.member_desc):
            query['MemberDesc'] = request.member_desc
        if not UtilClient.is_unset(request.member_display_name):
            query['MemberDisplayName'] = request.member_display_name
        if not UtilClient.is_unset(request.member_uid):
            query['MemberUid'] = request.member_uid
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInstanceMembers',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeInstanceMembersResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_instance_members(
        self,
        request: cloudfw_20171207_models.DescribeInstanceMembersRequest,
    ) -> cloudfw_20171207_models.DescribeInstanceMembersResponse:
        """
        @summary Queries the information about members in Cloud Firewall.
        
        @description You can use this operation to query the information about members in Cloud Firewall.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeInstanceMembersRequest
        @return: DescribeInstanceMembersResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_instance_members_with_options(request, runtime)

    async def describe_instance_members_async(
        self,
        request: cloudfw_20171207_models.DescribeInstanceMembersRequest,
    ) -> cloudfw_20171207_models.DescribeInstanceMembersResponse:
        """
        @summary Queries the information about members in Cloud Firewall.
        
        @description You can use this operation to query the information about members in Cloud Firewall.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeInstanceMembersRequest
        @return: DescribeInstanceMembersResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_instance_members_with_options_async(request, runtime)

    def describe_instance_rd_accounts_with_options(
        self,
        request: cloudfw_20171207_models.DescribeInstanceRdAccountsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeInstanceRdAccountsResponse:
        """
        @summary 获取实例RD账号
        
        @param request: DescribeInstanceRdAccountsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInstanceRdAccountsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.member_desc):
            query['MemberDesc'] = request.member_desc
        if not UtilClient.is_unset(request.member_display_name):
            query['MemberDisplayName'] = request.member_display_name
        if not UtilClient.is_unset(request.member_uid):
            query['MemberUid'] = request.member_uid
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInstanceRdAccounts',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeInstanceRdAccountsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_instance_rd_accounts_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeInstanceRdAccountsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeInstanceRdAccountsResponse:
        """
        @summary 获取实例RD账号
        
        @param request: DescribeInstanceRdAccountsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInstanceRdAccountsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.member_desc):
            query['MemberDesc'] = request.member_desc
        if not UtilClient.is_unset(request.member_display_name):
            query['MemberDisplayName'] = request.member_display_name
        if not UtilClient.is_unset(request.member_uid):
            query['MemberUid'] = request.member_uid
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInstanceRdAccounts',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeInstanceRdAccountsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_instance_rd_accounts(
        self,
        request: cloudfw_20171207_models.DescribeInstanceRdAccountsRequest,
    ) -> cloudfw_20171207_models.DescribeInstanceRdAccountsResponse:
        """
        @summary 获取实例RD账号
        
        @param request: DescribeInstanceRdAccountsRequest
        @return: DescribeInstanceRdAccountsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_instance_rd_accounts_with_options(request, runtime)

    async def describe_instance_rd_accounts_async(
        self,
        request: cloudfw_20171207_models.DescribeInstanceRdAccountsRequest,
    ) -> cloudfw_20171207_models.DescribeInstanceRdAccountsResponse:
        """
        @summary 获取实例RD账号
        
        @param request: DescribeInstanceRdAccountsRequest
        @return: DescribeInstanceRdAccountsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_instance_rd_accounts_with_options_async(request, runtime)

    def describe_instance_risk_levels_with_options(
        self,
        request: cloudfw_20171207_models.DescribeInstanceRiskLevelsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeInstanceRiskLevelsResponse:
        """
        @summary Queries the risk levels of instances.
        
        @param request: DescribeInstanceRiskLevelsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInstanceRiskLevelsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instances):
            query['Instances'] = request.instances
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInstanceRiskLevels',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeInstanceRiskLevelsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_instance_risk_levels_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeInstanceRiskLevelsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeInstanceRiskLevelsResponse:
        """
        @summary Queries the risk levels of instances.
        
        @param request: DescribeInstanceRiskLevelsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInstanceRiskLevelsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instances):
            query['Instances'] = request.instances
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInstanceRiskLevels',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeInstanceRiskLevelsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_instance_risk_levels(
        self,
        request: cloudfw_20171207_models.DescribeInstanceRiskLevelsRequest,
    ) -> cloudfw_20171207_models.DescribeInstanceRiskLevelsResponse:
        """
        @summary Queries the risk levels of instances.
        
        @param request: DescribeInstanceRiskLevelsRequest
        @return: DescribeInstanceRiskLevelsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_instance_risk_levels_with_options(request, runtime)

    async def describe_instance_risk_levels_async(
        self,
        request: cloudfw_20171207_models.DescribeInstanceRiskLevelsRequest,
    ) -> cloudfw_20171207_models.DescribeInstanceRiskLevelsResponse:
        """
        @summary Queries the risk levels of instances.
        
        @param request: DescribeInstanceRiskLevelsRequest
        @return: DescribeInstanceRiskLevelsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_instance_risk_levels_with_options_async(request, runtime)

    def describe_internet_drop_traffic_trend_with_options(
        self,
        request: cloudfw_20171207_models.DescribeInternetDropTrafficTrendRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeInternetDropTrafficTrendResponse:
        """
        @summary 获取互联网方向删除会话趋势图
        
        @param request: DescribeInternetDropTrafficTrendRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInternetDropTrafficTrendResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.direction):
            query['Direction'] = request.direction
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_code):
            query['SourceCode'] = request.source_code
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInternetDropTrafficTrend',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeInternetDropTrafficTrendResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_internet_drop_traffic_trend_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeInternetDropTrafficTrendRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeInternetDropTrafficTrendResponse:
        """
        @summary 获取互联网方向删除会话趋势图
        
        @param request: DescribeInternetDropTrafficTrendRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInternetDropTrafficTrendResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.direction):
            query['Direction'] = request.direction
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_code):
            query['SourceCode'] = request.source_code
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInternetDropTrafficTrend',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeInternetDropTrafficTrendResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_internet_drop_traffic_trend(
        self,
        request: cloudfw_20171207_models.DescribeInternetDropTrafficTrendRequest,
    ) -> cloudfw_20171207_models.DescribeInternetDropTrafficTrendResponse:
        """
        @summary 获取互联网方向删除会话趋势图
        
        @param request: DescribeInternetDropTrafficTrendRequest
        @return: DescribeInternetDropTrafficTrendResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_internet_drop_traffic_trend_with_options(request, runtime)

    async def describe_internet_drop_traffic_trend_async(
        self,
        request: cloudfw_20171207_models.DescribeInternetDropTrafficTrendRequest,
    ) -> cloudfw_20171207_models.DescribeInternetDropTrafficTrendResponse:
        """
        @summary 获取互联网方向删除会话趋势图
        
        @param request: DescribeInternetDropTrafficTrendRequest
        @return: DescribeInternetDropTrafficTrendResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_internet_drop_traffic_trend_with_options_async(request, runtime)

    def describe_internet_open_detail_with_options(
        self,
        request: cloudfw_20171207_models.DescribeInternetOpenDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeInternetOpenDetailResponse:
        """
        @summary 获取互联网开放详情
        
        @param request: DescribeInternetOpenDetailRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInternetOpenDetailResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.assets_instance_id):
            query['AssetsInstanceId'] = request.assets_instance_id
        if not UtilClient.is_unset(request.assets_instance_name):
            query['AssetsInstanceName'] = request.assets_instance_name
        if not UtilClient.is_unset(request.assets_type):
            query['AssetsType'] = request.assets_type
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.port):
            query['Port'] = request.port
        if not UtilClient.is_unset(request.public_ip):
            query['PublicIp'] = request.public_ip
        if not UtilClient.is_unset(request.region_no):
            query['RegionNo'] = request.region_no
        if not UtilClient.is_unset(request.risk_level):
            query['RiskLevel'] = request.risk_level
        if not UtilClient.is_unset(request.service_name):
            query['ServiceName'] = request.service_name
        if not UtilClient.is_unset(request.service_name_fuzzy):
            query['ServiceNameFuzzy'] = request.service_name_fuzzy
        if not UtilClient.is_unset(request.sort_list):
            query['SortList'] = request.sort_list
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.suggest_level):
            query['SuggestLevel'] = request.suggest_level
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInternetOpenDetail',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeInternetOpenDetailResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_internet_open_detail_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeInternetOpenDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeInternetOpenDetailResponse:
        """
        @summary 获取互联网开放详情
        
        @param request: DescribeInternetOpenDetailRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInternetOpenDetailResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.assets_instance_id):
            query['AssetsInstanceId'] = request.assets_instance_id
        if not UtilClient.is_unset(request.assets_instance_name):
            query['AssetsInstanceName'] = request.assets_instance_name
        if not UtilClient.is_unset(request.assets_type):
            query['AssetsType'] = request.assets_type
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.port):
            query['Port'] = request.port
        if not UtilClient.is_unset(request.public_ip):
            query['PublicIp'] = request.public_ip
        if not UtilClient.is_unset(request.region_no):
            query['RegionNo'] = request.region_no
        if not UtilClient.is_unset(request.risk_level):
            query['RiskLevel'] = request.risk_level
        if not UtilClient.is_unset(request.service_name):
            query['ServiceName'] = request.service_name
        if not UtilClient.is_unset(request.service_name_fuzzy):
            query['ServiceNameFuzzy'] = request.service_name_fuzzy
        if not UtilClient.is_unset(request.sort_list):
            query['SortList'] = request.sort_list
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.suggest_level):
            query['SuggestLevel'] = request.suggest_level
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInternetOpenDetail',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeInternetOpenDetailResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_internet_open_detail(
        self,
        request: cloudfw_20171207_models.DescribeInternetOpenDetailRequest,
    ) -> cloudfw_20171207_models.DescribeInternetOpenDetailResponse:
        """
        @summary 获取互联网开放详情
        
        @param request: DescribeInternetOpenDetailRequest
        @return: DescribeInternetOpenDetailResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_internet_open_detail_with_options(request, runtime)

    async def describe_internet_open_detail_async(
        self,
        request: cloudfw_20171207_models.DescribeInternetOpenDetailRequest,
    ) -> cloudfw_20171207_models.DescribeInternetOpenDetailResponse:
        """
        @summary 获取互联网开放详情
        
        @param request: DescribeInternetOpenDetailRequest
        @return: DescribeInternetOpenDetailResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_internet_open_detail_with_options_async(request, runtime)

    def describe_internet_open_ip_with_options(
        self,
        request: cloudfw_20171207_models.DescribeInternetOpenIpRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeInternetOpenIpResponse:
        """
        @summary Queries the IP addresses that are open to the Internet.
        
        @param request: DescribeInternetOpenIpRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInternetOpenIpResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.assets_instance_id):
            query['AssetsInstanceId'] = request.assets_instance_id
        if not UtilClient.is_unset(request.assets_instance_name):
            query['AssetsInstanceName'] = request.assets_instance_name
        if not UtilClient.is_unset(request.assets_type):
            query['AssetsType'] = request.assets_type
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.port):
            query['Port'] = request.port
        if not UtilClient.is_unset(request.public_ip):
            query['PublicIp'] = request.public_ip
        if not UtilClient.is_unset(request.region_no):
            query['RegionNo'] = request.region_no
        if not UtilClient.is_unset(request.risk_level):
            query['RiskLevel'] = request.risk_level
        if not UtilClient.is_unset(request.service_name):
            query['ServiceName'] = request.service_name
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInternetOpenIp',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeInternetOpenIpResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_internet_open_ip_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeInternetOpenIpRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeInternetOpenIpResponse:
        """
        @summary Queries the IP addresses that are open to the Internet.
        
        @param request: DescribeInternetOpenIpRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInternetOpenIpResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.assets_instance_id):
            query['AssetsInstanceId'] = request.assets_instance_id
        if not UtilClient.is_unset(request.assets_instance_name):
            query['AssetsInstanceName'] = request.assets_instance_name
        if not UtilClient.is_unset(request.assets_type):
            query['AssetsType'] = request.assets_type
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.port):
            query['Port'] = request.port
        if not UtilClient.is_unset(request.public_ip):
            query['PublicIp'] = request.public_ip
        if not UtilClient.is_unset(request.region_no):
            query['RegionNo'] = request.region_no
        if not UtilClient.is_unset(request.risk_level):
            query['RiskLevel'] = request.risk_level
        if not UtilClient.is_unset(request.service_name):
            query['ServiceName'] = request.service_name
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInternetOpenIp',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeInternetOpenIpResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_internet_open_ip(
        self,
        request: cloudfw_20171207_models.DescribeInternetOpenIpRequest,
    ) -> cloudfw_20171207_models.DescribeInternetOpenIpResponse:
        """
        @summary Queries the IP addresses that are open to the Internet.
        
        @param request: DescribeInternetOpenIpRequest
        @return: DescribeInternetOpenIpResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_internet_open_ip_with_options(request, runtime)

    async def describe_internet_open_ip_async(
        self,
        request: cloudfw_20171207_models.DescribeInternetOpenIpRequest,
    ) -> cloudfw_20171207_models.DescribeInternetOpenIpResponse:
        """
        @summary Queries the IP addresses that are open to the Internet.
        
        @param request: DescribeInternetOpenIpRequest
        @return: DescribeInternetOpenIpResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_internet_open_ip_with_options_async(request, runtime)

    def describe_internet_open_port_with_options(
        self,
        request: cloudfw_20171207_models.DescribeInternetOpenPortRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeInternetOpenPortResponse:
        """
        @summary 获取互联网开放端口
        
        @param request: DescribeInternetOpenPortRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInternetOpenPortResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.port):
            query['Port'] = request.port
        if not UtilClient.is_unset(request.risk_level):
            query['RiskLevel'] = request.risk_level
        if not UtilClient.is_unset(request.service_name):
            query['ServiceName'] = request.service_name
        if not UtilClient.is_unset(request.service_name_fuzzy):
            query['ServiceNameFuzzy'] = request.service_name_fuzzy
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.suggest_level):
            query['SuggestLevel'] = request.suggest_level
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInternetOpenPort',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeInternetOpenPortResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_internet_open_port_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeInternetOpenPortRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeInternetOpenPortResponse:
        """
        @summary 获取互联网开放端口
        
        @param request: DescribeInternetOpenPortRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInternetOpenPortResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.port):
            query['Port'] = request.port
        if not UtilClient.is_unset(request.risk_level):
            query['RiskLevel'] = request.risk_level
        if not UtilClient.is_unset(request.service_name):
            query['ServiceName'] = request.service_name
        if not UtilClient.is_unset(request.service_name_fuzzy):
            query['ServiceNameFuzzy'] = request.service_name_fuzzy
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.suggest_level):
            query['SuggestLevel'] = request.suggest_level
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInternetOpenPort',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeInternetOpenPortResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_internet_open_port(
        self,
        request: cloudfw_20171207_models.DescribeInternetOpenPortRequest,
    ) -> cloudfw_20171207_models.DescribeInternetOpenPortResponse:
        """
        @summary 获取互联网开放端口
        
        @param request: DescribeInternetOpenPortRequest
        @return: DescribeInternetOpenPortResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_internet_open_port_with_options(request, runtime)

    async def describe_internet_open_port_async(
        self,
        request: cloudfw_20171207_models.DescribeInternetOpenPortRequest,
    ) -> cloudfw_20171207_models.DescribeInternetOpenPortResponse:
        """
        @summary 获取互联网开放端口
        
        @param request: DescribeInternetOpenPortRequest
        @return: DescribeInternetOpenPortResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_internet_open_port_with_options_async(request, runtime)

    def describe_internet_open_service_with_options(
        self,
        request: cloudfw_20171207_models.DescribeInternetOpenServiceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeInternetOpenServiceResponse:
        """
        @summary 获取互联网开放服务
        
        @param request: DescribeInternetOpenServiceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInternetOpenServiceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.port):
            query['Port'] = request.port
        if not UtilClient.is_unset(request.risk_level):
            query['RiskLevel'] = request.risk_level
        if not UtilClient.is_unset(request.service_name):
            query['ServiceName'] = request.service_name
        if not UtilClient.is_unset(request.service_name_fuzzy):
            query['ServiceNameFuzzy'] = request.service_name_fuzzy
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.suggest_level):
            query['SuggestLevel'] = request.suggest_level
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInternetOpenService',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeInternetOpenServiceResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_internet_open_service_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeInternetOpenServiceRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeInternetOpenServiceResponse:
        """
        @summary 获取互联网开放服务
        
        @param request: DescribeInternetOpenServiceRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInternetOpenServiceResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.port):
            query['Port'] = request.port
        if not UtilClient.is_unset(request.risk_level):
            query['RiskLevel'] = request.risk_level
        if not UtilClient.is_unset(request.service_name):
            query['ServiceName'] = request.service_name
        if not UtilClient.is_unset(request.service_name_fuzzy):
            query['ServiceNameFuzzy'] = request.service_name_fuzzy
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.suggest_level):
            query['SuggestLevel'] = request.suggest_level
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInternetOpenService',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeInternetOpenServiceResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_internet_open_service(
        self,
        request: cloudfw_20171207_models.DescribeInternetOpenServiceRequest,
    ) -> cloudfw_20171207_models.DescribeInternetOpenServiceResponse:
        """
        @summary 获取互联网开放服务
        
        @param request: DescribeInternetOpenServiceRequest
        @return: DescribeInternetOpenServiceResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_internet_open_service_with_options(request, runtime)

    async def describe_internet_open_service_async(
        self,
        request: cloudfw_20171207_models.DescribeInternetOpenServiceRequest,
    ) -> cloudfw_20171207_models.DescribeInternetOpenServiceResponse:
        """
        @summary 获取互联网开放服务
        
        @param request: DescribeInternetOpenServiceRequest
        @return: DescribeInternetOpenServiceResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_internet_open_service_with_options_async(request, runtime)

    def describe_internet_open_statistic_with_options(
        self,
        request: cloudfw_20171207_models.DescribeInternetOpenStatisticRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeInternetOpenStatisticResponse:
        """
        @summary 获取互联网开放统计
        
        @param request: DescribeInternetOpenStatisticRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInternetOpenStatisticResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInternetOpenStatistic',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeInternetOpenStatisticResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_internet_open_statistic_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeInternetOpenStatisticRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeInternetOpenStatisticResponse:
        """
        @summary 获取互联网开放统计
        
        @param request: DescribeInternetOpenStatisticRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInternetOpenStatisticResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInternetOpenStatistic',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeInternetOpenStatisticResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_internet_open_statistic(
        self,
        request: cloudfw_20171207_models.DescribeInternetOpenStatisticRequest,
    ) -> cloudfw_20171207_models.DescribeInternetOpenStatisticResponse:
        """
        @summary 获取互联网开放统计
        
        @param request: DescribeInternetOpenStatisticRequest
        @return: DescribeInternetOpenStatisticResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_internet_open_statistic_with_options(request, runtime)

    async def describe_internet_open_statistic_async(
        self,
        request: cloudfw_20171207_models.DescribeInternetOpenStatisticRequest,
    ) -> cloudfw_20171207_models.DescribeInternetOpenStatisticResponse:
        """
        @summary 获取互联网开放统计
        
        @param request: DescribeInternetOpenStatisticRequest
        @return: DescribeInternetOpenStatisticResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_internet_open_statistic_with_options_async(request, runtime)

    def describe_internet_service_name_list_with_options(
        self,
        request: cloudfw_20171207_models.DescribeInternetServiceNameListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeInternetServiceNameListResponse:
        """
        @summary 获取互联网服务名称列表
        
        @param request: DescribeInternetServiceNameListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInternetServiceNameListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInternetServiceNameList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeInternetServiceNameListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_internet_service_name_list_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeInternetServiceNameListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeInternetServiceNameListResponse:
        """
        @summary 获取互联网服务名称列表
        
        @param request: DescribeInternetServiceNameListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInternetServiceNameListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInternetServiceNameList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeInternetServiceNameListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_internet_service_name_list(
        self,
        request: cloudfw_20171207_models.DescribeInternetServiceNameListRequest,
    ) -> cloudfw_20171207_models.DescribeInternetServiceNameListResponse:
        """
        @summary 获取互联网服务名称列表
        
        @param request: DescribeInternetServiceNameListRequest
        @return: DescribeInternetServiceNameListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_internet_service_name_list_with_options(request, runtime)

    async def describe_internet_service_name_list_async(
        self,
        request: cloudfw_20171207_models.DescribeInternetServiceNameListRequest,
    ) -> cloudfw_20171207_models.DescribeInternetServiceNameListResponse:
        """
        @summary 获取互联网服务名称列表
        
        @param request: DescribeInternetServiceNameListRequest
        @return: DescribeInternetServiceNameListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_internet_service_name_list_with_options_async(request, runtime)

    def describe_internet_slb_with_options(
        self,
        request: cloudfw_20171207_models.DescribeInternetSlbRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeInternetSlbResponse:
        """
        @summary 获取互联网SLB
        
        @param request: DescribeInternetSlbRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInternetSlbResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.instance_name):
            query['InstanceName'] = request.instance_name
        if not UtilClient.is_unset(request.ip_protocol):
            query['IpProtocol'] = request.ip_protocol
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.port):
            query['Port'] = request.port
        if not UtilClient.is_unset(request.public_ip):
            query['PublicIp'] = request.public_ip
        if not UtilClient.is_unset(request.region_no):
            query['RegionNo'] = request.region_no
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInternetSlb',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeInternetSlbResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_internet_slb_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeInternetSlbRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeInternetSlbResponse:
        """
        @summary 获取互联网SLB
        
        @param request: DescribeInternetSlbRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInternetSlbResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.instance_name):
            query['InstanceName'] = request.instance_name
        if not UtilClient.is_unset(request.ip_protocol):
            query['IpProtocol'] = request.ip_protocol
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.port):
            query['Port'] = request.port
        if not UtilClient.is_unset(request.public_ip):
            query['PublicIp'] = request.public_ip
        if not UtilClient.is_unset(request.region_no):
            query['RegionNo'] = request.region_no
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.tag):
            query['Tag'] = request.tag
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInternetSlb',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeInternetSlbResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_internet_slb(
        self,
        request: cloudfw_20171207_models.DescribeInternetSlbRequest,
    ) -> cloudfw_20171207_models.DescribeInternetSlbResponse:
        """
        @summary 获取互联网SLB
        
        @param request: DescribeInternetSlbRequest
        @return: DescribeInternetSlbResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_internet_slb_with_options(request, runtime)

    async def describe_internet_slb_async(
        self,
        request: cloudfw_20171207_models.DescribeInternetSlbRequest,
    ) -> cloudfw_20171207_models.DescribeInternetSlbResponse:
        """
        @summary 获取互联网SLB
        
        @param request: DescribeInternetSlbRequest
        @return: DescribeInternetSlbResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_internet_slb_with_options_async(request, runtime)

    def describe_internet_time_top_with_options(
        self,
        request: cloudfw_20171207_models.DescribeInternetTimeTopRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeInternetTimeTopResponse:
        """
        @summary 获取互联网流量时间TOP
        
        @param request: DescribeInternetTimeTopRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInternetTimeTopResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.direction):
            query['Direction'] = request.direction
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.iptype):
            query['IPType'] = request.iptype
        if not UtilClient.is_unset(request.interval):
            query['Interval'] = request.interval
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.limit):
            query['Limit'] = request.limit
        if not UtilClient.is_unset(request.nat_ip):
            query['NatIP'] = request.nat_ip
        if not UtilClient.is_unset(request.order):
            query['Order'] = request.order
        if not UtilClient.is_unset(request.sort):
            query['Sort'] = request.sort
        if not UtilClient.is_unset(request.source_code):
            query['SourceCode'] = request.source_code
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.src_ip):
            query['SrcIP'] = request.src_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.traffic_time):
            query['TrafficTime'] = request.traffic_time
        if not UtilClient.is_unset(request.traffic_type):
            query['TrafficType'] = request.traffic_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInternetTimeTop',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeInternetTimeTopResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_internet_time_top_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeInternetTimeTopRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeInternetTimeTopResponse:
        """
        @summary 获取互联网流量时间TOP
        
        @param request: DescribeInternetTimeTopRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInternetTimeTopResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.direction):
            query['Direction'] = request.direction
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.iptype):
            query['IPType'] = request.iptype
        if not UtilClient.is_unset(request.interval):
            query['Interval'] = request.interval
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.limit):
            query['Limit'] = request.limit
        if not UtilClient.is_unset(request.nat_ip):
            query['NatIP'] = request.nat_ip
        if not UtilClient.is_unset(request.order):
            query['Order'] = request.order
        if not UtilClient.is_unset(request.sort):
            query['Sort'] = request.sort
        if not UtilClient.is_unset(request.source_code):
            query['SourceCode'] = request.source_code
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.src_ip):
            query['SrcIP'] = request.src_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.traffic_time):
            query['TrafficTime'] = request.traffic_time
        if not UtilClient.is_unset(request.traffic_type):
            query['TrafficType'] = request.traffic_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInternetTimeTop',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeInternetTimeTopResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_internet_time_top(
        self,
        request: cloudfw_20171207_models.DescribeInternetTimeTopRequest,
    ) -> cloudfw_20171207_models.DescribeInternetTimeTopResponse:
        """
        @summary 获取互联网流量时间TOP
        
        @param request: DescribeInternetTimeTopRequest
        @return: DescribeInternetTimeTopResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_internet_time_top_with_options(request, runtime)

    async def describe_internet_time_top_async(
        self,
        request: cloudfw_20171207_models.DescribeInternetTimeTopRequest,
    ) -> cloudfw_20171207_models.DescribeInternetTimeTopResponse:
        """
        @summary 获取互联网流量时间TOP
        
        @param request: DescribeInternetTimeTopRequest
        @return: DescribeInternetTimeTopResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_internet_time_top_with_options_async(request, runtime)

    def describe_internet_traffic_top_with_options(
        self,
        request: cloudfw_20171207_models.DescribeInternetTrafficTopRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeInternetTrafficTopResponse:
        """
        @summary 获取互联网流量TOP趋势图
        
        @param request: DescribeInternetTrafficTopRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInternetTrafficTopResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.data_type):
            query['DataType'] = request.data_type
        if not UtilClient.is_unset(request.direction):
            query['Direction'] = request.direction
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.limit):
            query['Limit'] = request.limit
        if not UtilClient.is_unset(request.rule_result):
            query['RuleResult'] = request.rule_result
        if not UtilClient.is_unset(request.rule_source):
            query['RuleSource'] = request.rule_source
        if not UtilClient.is_unset(request.show_country_name):
            query['ShowCountryName'] = request.show_country_name
        if not UtilClient.is_unset(request.sort):
            query['Sort'] = request.sort
        if not UtilClient.is_unset(request.source_code):
            query['SourceCode'] = request.source_code
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInternetTrafficTop',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeInternetTrafficTopResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_internet_traffic_top_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeInternetTrafficTopRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeInternetTrafficTopResponse:
        """
        @summary 获取互联网流量TOP趋势图
        
        @param request: DescribeInternetTrafficTopRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInternetTrafficTopResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.data_type):
            query['DataType'] = request.data_type
        if not UtilClient.is_unset(request.direction):
            query['Direction'] = request.direction
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.limit):
            query['Limit'] = request.limit
        if not UtilClient.is_unset(request.rule_result):
            query['RuleResult'] = request.rule_result
        if not UtilClient.is_unset(request.rule_source):
            query['RuleSource'] = request.rule_source
        if not UtilClient.is_unset(request.show_country_name):
            query['ShowCountryName'] = request.show_country_name
        if not UtilClient.is_unset(request.sort):
            query['Sort'] = request.sort
        if not UtilClient.is_unset(request.source_code):
            query['SourceCode'] = request.source_code
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInternetTrafficTop',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeInternetTrafficTopResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_internet_traffic_top(
        self,
        request: cloudfw_20171207_models.DescribeInternetTrafficTopRequest,
    ) -> cloudfw_20171207_models.DescribeInternetTrafficTopResponse:
        """
        @summary 获取互联网流量TOP趋势图
        
        @param request: DescribeInternetTrafficTopRequest
        @return: DescribeInternetTrafficTopResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_internet_traffic_top_with_options(request, runtime)

    async def describe_internet_traffic_top_async(
        self,
        request: cloudfw_20171207_models.DescribeInternetTrafficTopRequest,
    ) -> cloudfw_20171207_models.DescribeInternetTrafficTopResponse:
        """
        @summary 获取互联网流量TOP趋势图
        
        @param request: DescribeInternetTrafficTopRequest
        @return: DescribeInternetTrafficTopResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_internet_traffic_top_with_options_async(request, runtime)

    def describe_internet_traffic_trend_with_options(
        self,
        request: cloudfw_20171207_models.DescribeInternetTrafficTrendRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeInternetTrafficTrendResponse:
        """
        @summary Queries the trends of Internet traffic.
        
        @param request: DescribeInternetTrafficTrendRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInternetTrafficTrendResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.direction):
            query['Direction'] = request.direction
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_code):
            query['SourceCode'] = request.source_code
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.src_private_ip):
            query['SrcPrivateIP'] = request.src_private_ip
        if not UtilClient.is_unset(request.src_public_ip):
            query['SrcPublicIP'] = request.src_public_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.traffic_type):
            query['TrafficType'] = request.traffic_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInternetTrafficTrend',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeInternetTrafficTrendResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_internet_traffic_trend_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeInternetTrafficTrendRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeInternetTrafficTrendResponse:
        """
        @summary Queries the trends of Internet traffic.
        
        @param request: DescribeInternetTrafficTrendRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInternetTrafficTrendResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.direction):
            query['Direction'] = request.direction
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_code):
            query['SourceCode'] = request.source_code
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.src_private_ip):
            query['SrcPrivateIP'] = request.src_private_ip
        if not UtilClient.is_unset(request.src_public_ip):
            query['SrcPublicIP'] = request.src_public_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.traffic_type):
            query['TrafficType'] = request.traffic_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInternetTrafficTrend',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeInternetTrafficTrendResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_internet_traffic_trend(
        self,
        request: cloudfw_20171207_models.DescribeInternetTrafficTrendRequest,
    ) -> cloudfw_20171207_models.DescribeInternetTrafficTrendResponse:
        """
        @summary Queries the trends of Internet traffic.
        
        @param request: DescribeInternetTrafficTrendRequest
        @return: DescribeInternetTrafficTrendResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_internet_traffic_trend_with_options(request, runtime)

    async def describe_internet_traffic_trend_async(
        self,
        request: cloudfw_20171207_models.DescribeInternetTrafficTrendRequest,
    ) -> cloudfw_20171207_models.DescribeInternetTrafficTrendResponse:
        """
        @summary Queries the trends of Internet traffic.
        
        @param request: DescribeInternetTrafficTrendRequest
        @return: DescribeInternetTrafficTrendResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_internet_traffic_trend_with_options_async(request, runtime)

    def describe_invade_ecs_trend_with_options(
        self,
        request: cloudfw_20171207_models.DescribeInvadeEcsTrendRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeInvadeEcsTrendResponse:
        """
        @summary 获取ECS漏洞趋势
        
        @param request: DescribeInvadeEcsTrendRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInvadeEcsTrendResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInvadeEcsTrend',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeInvadeEcsTrendResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_invade_ecs_trend_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeInvadeEcsTrendRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeInvadeEcsTrendResponse:
        """
        @summary 获取ECS漏洞趋势
        
        @param request: DescribeInvadeEcsTrendRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInvadeEcsTrendResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInvadeEcsTrend',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeInvadeEcsTrendResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_invade_ecs_trend(
        self,
        request: cloudfw_20171207_models.DescribeInvadeEcsTrendRequest,
    ) -> cloudfw_20171207_models.DescribeInvadeEcsTrendResponse:
        """
        @summary 获取ECS漏洞趋势
        
        @param request: DescribeInvadeEcsTrendRequest
        @return: DescribeInvadeEcsTrendResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_invade_ecs_trend_with_options(request, runtime)

    async def describe_invade_ecs_trend_async(
        self,
        request: cloudfw_20171207_models.DescribeInvadeEcsTrendRequest,
    ) -> cloudfw_20171207_models.DescribeInvadeEcsTrendResponse:
        """
        @summary 获取ECS漏洞趋势
        
        @param request: DescribeInvadeEcsTrendRequest
        @return: DescribeInvadeEcsTrendResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_invade_ecs_trend_with_options_async(request, runtime)

    def describe_invade_event_detail_with_options(
        self,
        request: cloudfw_20171207_models.DescribeInvadeEventDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeInvadeEventDetailResponse:
        """
        @summary 获取漏洞事件详情
        
        @param request: DescribeInvadeEventDetailRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInvadeEventDetailResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.assets_instance_id):
            query['AssetsInstanceId'] = request.assets_instance_id
        if not UtilClient.is_unset(request.event_uuid):
            query['EventUuid'] = request.event_uuid
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.public_ip):
            query['PublicIP'] = request.public_ip
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInvadeEventDetail',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeInvadeEventDetailResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_invade_event_detail_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeInvadeEventDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeInvadeEventDetailResponse:
        """
        @summary 获取漏洞事件详情
        
        @param request: DescribeInvadeEventDetailRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInvadeEventDetailResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.assets_instance_id):
            query['AssetsInstanceId'] = request.assets_instance_id
        if not UtilClient.is_unset(request.event_uuid):
            query['EventUuid'] = request.event_uuid
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.public_ip):
            query['PublicIP'] = request.public_ip
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInvadeEventDetail',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeInvadeEventDetailResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_invade_event_detail(
        self,
        request: cloudfw_20171207_models.DescribeInvadeEventDetailRequest,
    ) -> cloudfw_20171207_models.DescribeInvadeEventDetailResponse:
        """
        @summary 获取漏洞事件详情
        
        @param request: DescribeInvadeEventDetailRequest
        @return: DescribeInvadeEventDetailResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_invade_event_detail_with_options(request, runtime)

    async def describe_invade_event_detail_async(
        self,
        request: cloudfw_20171207_models.DescribeInvadeEventDetailRequest,
    ) -> cloudfw_20171207_models.DescribeInvadeEventDetailResponse:
        """
        @summary 获取漏洞事件详情
        
        @param request: DescribeInvadeEventDetailRequest
        @return: DescribeInvadeEventDetailResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_invade_event_detail_with_options_async(request, runtime)

    def describe_invade_event_list_with_options(
        self,
        request: cloudfw_20171207_models.DescribeInvadeEventListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeInvadeEventListResponse:
        """
        @summary Queries the information about the breach awareness events of a firewall.
        
        @param request: DescribeInvadeEventListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInvadeEventListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.assets_ip):
            query['AssetsIP'] = request.assets_ip
        if not UtilClient.is_unset(request.assets_instance_id):
            query['AssetsInstanceId'] = request.assets_instance_id
        if not UtilClient.is_unset(request.assets_instance_name):
            query['AssetsInstanceName'] = request.assets_instance_name
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.event_key):
            query['EventKey'] = request.event_key
        if not UtilClient.is_unset(request.event_name):
            query['EventName'] = request.event_name
        if not UtilClient.is_unset(request.event_uuid):
            query['EventUuid'] = request.event_uuid
        if not UtilClient.is_unset(request.is_ignore):
            query['IsIgnore'] = request.is_ignore
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.member_uid):
            query['MemberUid'] = request.member_uid
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.process_status_list):
            query['ProcessStatusList'] = request.process_status_list
        if not UtilClient.is_unset(request.risk_level):
            query['RiskLevel'] = request.risk_level
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInvadeEventList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeInvadeEventListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_invade_event_list_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeInvadeEventListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeInvadeEventListResponse:
        """
        @summary Queries the information about the breach awareness events of a firewall.
        
        @param request: DescribeInvadeEventListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInvadeEventListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.assets_ip):
            query['AssetsIP'] = request.assets_ip
        if not UtilClient.is_unset(request.assets_instance_id):
            query['AssetsInstanceId'] = request.assets_instance_id
        if not UtilClient.is_unset(request.assets_instance_name):
            query['AssetsInstanceName'] = request.assets_instance_name
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.event_key):
            query['EventKey'] = request.event_key
        if not UtilClient.is_unset(request.event_name):
            query['EventName'] = request.event_name
        if not UtilClient.is_unset(request.event_uuid):
            query['EventUuid'] = request.event_uuid
        if not UtilClient.is_unset(request.is_ignore):
            query['IsIgnore'] = request.is_ignore
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.member_uid):
            query['MemberUid'] = request.member_uid
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.process_status_list):
            query['ProcessStatusList'] = request.process_status_list
        if not UtilClient.is_unset(request.risk_level):
            query['RiskLevel'] = request.risk_level
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInvadeEventList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeInvadeEventListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_invade_event_list(
        self,
        request: cloudfw_20171207_models.DescribeInvadeEventListRequest,
    ) -> cloudfw_20171207_models.DescribeInvadeEventListResponse:
        """
        @summary Queries the information about the breach awareness events of a firewall.
        
        @param request: DescribeInvadeEventListRequest
        @return: DescribeInvadeEventListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_invade_event_list_with_options(request, runtime)

    async def describe_invade_event_list_async(
        self,
        request: cloudfw_20171207_models.DescribeInvadeEventListRequest,
    ) -> cloudfw_20171207_models.DescribeInvadeEventListResponse:
        """
        @summary Queries the information about the breach awareness events of a firewall.
        
        @param request: DescribeInvadeEventListRequest
        @return: DescribeInvadeEventListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_invade_event_list_with_options_async(request, runtime)

    def describe_invade_event_name_list_with_options(
        self,
        request: cloudfw_20171207_models.DescribeInvadeEventNameListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeInvadeEventNameListResponse:
        """
        @summary 获取漏洞名称列表
        
        @param request: DescribeInvadeEventNameListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInvadeEventNameListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInvadeEventNameList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeInvadeEventNameListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_invade_event_name_list_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeInvadeEventNameListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeInvadeEventNameListResponse:
        """
        @summary 获取漏洞名称列表
        
        @param request: DescribeInvadeEventNameListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInvadeEventNameListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInvadeEventNameList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeInvadeEventNameListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_invade_event_name_list(
        self,
        request: cloudfw_20171207_models.DescribeInvadeEventNameListRequest,
    ) -> cloudfw_20171207_models.DescribeInvadeEventNameListResponse:
        """
        @summary 获取漏洞名称列表
        
        @param request: DescribeInvadeEventNameListRequest
        @return: DescribeInvadeEventNameListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_invade_event_name_list_with_options(request, runtime)

    async def describe_invade_event_name_list_async(
        self,
        request: cloudfw_20171207_models.DescribeInvadeEventNameListRequest,
    ) -> cloudfw_20171207_models.DescribeInvadeEventNameListResponse:
        """
        @summary 获取漏洞名称列表
        
        @param request: DescribeInvadeEventNameListRequest
        @return: DescribeInvadeEventNameListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_invade_event_name_list_with_options_async(request, runtime)

    def describe_invade_event_statistic_with_options(
        self,
        request: cloudfw_20171207_models.DescribeInvadeEventStatisticRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeInvadeEventStatisticResponse:
        """
        @summary 获取漏洞事件统计
        
        @param request: DescribeInvadeEventStatisticRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInvadeEventStatisticResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInvadeEventStatistic',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeInvadeEventStatisticResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_invade_event_statistic_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeInvadeEventStatisticRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeInvadeEventStatisticResponse:
        """
        @summary 获取漏洞事件统计
        
        @param request: DescribeInvadeEventStatisticRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeInvadeEventStatisticResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeInvadeEventStatistic',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeInvadeEventStatisticResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_invade_event_statistic(
        self,
        request: cloudfw_20171207_models.DescribeInvadeEventStatisticRequest,
    ) -> cloudfw_20171207_models.DescribeInvadeEventStatisticResponse:
        """
        @summary 获取漏洞事件统计
        
        @param request: DescribeInvadeEventStatisticRequest
        @return: DescribeInvadeEventStatisticResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_invade_event_statistic_with_options(request, runtime)

    async def describe_invade_event_statistic_async(
        self,
        request: cloudfw_20171207_models.DescribeInvadeEventStatisticRequest,
    ) -> cloudfw_20171207_models.DescribeInvadeEventStatisticResponse:
        """
        @summary 获取漏洞事件统计
        
        @param request: DescribeInvadeEventStatisticRequest
        @return: DescribeInvadeEventStatisticResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_invade_event_statistic_with_options_async(request, runtime)

    def describe_ips_private_assoc_with_options(
        self,
        request: cloudfw_20171207_models.DescribeIpsPrivateAssocRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeIpsPrivateAssocResponse:
        """
        @summary 查询IPS私网关联信息
        
        @param request: DescribeIpsPrivateAssocRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeIpsPrivateAssocResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.member_uid):
            query['MemberUid'] = request.member_uid
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.public_ip):
            query['PublicIp'] = request.public_ip
        if not UtilClient.is_unset(request.resource_id):
            query['ResourceId'] = request.resource_id
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeIpsPrivateAssoc',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeIpsPrivateAssocResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_ips_private_assoc_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeIpsPrivateAssocRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeIpsPrivateAssocResponse:
        """
        @summary 查询IPS私网关联信息
        
        @param request: DescribeIpsPrivateAssocRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeIpsPrivateAssocResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.member_uid):
            query['MemberUid'] = request.member_uid
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.public_ip):
            query['PublicIp'] = request.public_ip
        if not UtilClient.is_unset(request.resource_id):
            query['ResourceId'] = request.resource_id
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeIpsPrivateAssoc',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeIpsPrivateAssocResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_ips_private_assoc(
        self,
        request: cloudfw_20171207_models.DescribeIpsPrivateAssocRequest,
    ) -> cloudfw_20171207_models.DescribeIpsPrivateAssocResponse:
        """
        @summary 查询IPS私网关联信息
        
        @param request: DescribeIpsPrivateAssocRequest
        @return: DescribeIpsPrivateAssocResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_ips_private_assoc_with_options(request, runtime)

    async def describe_ips_private_assoc_async(
        self,
        request: cloudfw_20171207_models.DescribeIpsPrivateAssocRequest,
    ) -> cloudfw_20171207_models.DescribeIpsPrivateAssocResponse:
        """
        @summary 查询IPS私网关联信息
        
        @param request: DescribeIpsPrivateAssocRequest
        @return: DescribeIpsPrivateAssocResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_ips_private_assoc_with_options_async(request, runtime)

    def describe_isp_info_with_options(
        self,
        request: cloudfw_20171207_models.DescribeIspInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeIspInfoResponse:
        """
        @summary 获取ISP信息
        
        @param request: DescribeIspInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeIspInfoResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_code):
            query['SourceCode'] = request.source_code
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeIspInfo',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeIspInfoResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_isp_info_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeIspInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeIspInfoResponse:
        """
        @summary 获取ISP信息
        
        @param request: DescribeIspInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeIspInfoResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_code):
            query['SourceCode'] = request.source_code
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeIspInfo',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeIspInfoResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_isp_info(
        self,
        request: cloudfw_20171207_models.DescribeIspInfoRequest,
    ) -> cloudfw_20171207_models.DescribeIspInfoResponse:
        """
        @summary 获取ISP信息
        
        @param request: DescribeIspInfoRequest
        @return: DescribeIspInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_isp_info_with_options(request, runtime)

    async def describe_isp_info_async(
        self,
        request: cloudfw_20171207_models.DescribeIspInfoRequest,
    ) -> cloudfw_20171207_models.DescribeIspInfoResponse:
        """
        @summary 获取ISP信息
        
        @param request: DescribeIspInfoRequest
        @return: DescribeIspInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_isp_info_with_options_async(request, runtime)

    def describe_location_info_with_options(
        self,
        request: cloudfw_20171207_models.DescribeLocationInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeLocationInfoResponse:
        """
        @summary 获取位置信息
        
        @param request: DescribeLocationInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeLocationInfoResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_code):
            query['SourceCode'] = request.source_code
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeLocationInfo',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeLocationInfoResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_location_info_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeLocationInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeLocationInfoResponse:
        """
        @summary 获取位置信息
        
        @param request: DescribeLocationInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeLocationInfoResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_code):
            query['SourceCode'] = request.source_code
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeLocationInfo',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeLocationInfoResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_location_info(
        self,
        request: cloudfw_20171207_models.DescribeLocationInfoRequest,
    ) -> cloudfw_20171207_models.DescribeLocationInfoResponse:
        """
        @summary 获取位置信息
        
        @param request: DescribeLocationInfoRequest
        @return: DescribeLocationInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_location_info_with_options(request, runtime)

    async def describe_location_info_async(
        self,
        request: cloudfw_20171207_models.DescribeLocationInfoRequest,
    ) -> cloudfw_20171207_models.DescribeLocationInfoResponse:
        """
        @summary 获取位置信息
        
        @param request: DescribeLocationInfoRequest
        @return: DescribeLocationInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_location_info_with_options_async(request, runtime)

    def describe_log_store_info_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeLogStoreInfoResponse:
        """
        @summary Get Log Service Information
        
        @param request: DescribeLogStoreInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeLogStoreInfoResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeLogStoreInfo',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeLogStoreInfoResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_log_store_info_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeLogStoreInfoResponse:
        """
        @summary Get Log Service Information
        
        @param request: DescribeLogStoreInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeLogStoreInfoResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeLogStoreInfo',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeLogStoreInfoResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_log_store_info(self) -> cloudfw_20171207_models.DescribeLogStoreInfoResponse:
        """
        @summary Get Log Service Information
        
        @return: DescribeLogStoreInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_log_store_info_with_options(runtime)

    async def describe_log_store_info_async(self) -> cloudfw_20171207_models.DescribeLogStoreInfoResponse:
        """
        @summary Get Log Service Information
        
        @return: DescribeLogStoreInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_log_store_info_with_options_async(runtime)

    def describe_member_info_with_options(
        self,
        request: cloudfw_20171207_models.DescribeMemberInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeMemberInfoResponse:
        """
        @summary 免费版获取成员信息
        
        @param request: DescribeMemberInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeMemberInfoResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeMemberInfo',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeMemberInfoResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_member_info_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeMemberInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeMemberInfoResponse:
        """
        @summary 免费版获取成员信息
        
        @param request: DescribeMemberInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeMemberInfoResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeMemberInfo',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeMemberInfoResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_member_info(
        self,
        request: cloudfw_20171207_models.DescribeMemberInfoRequest,
    ) -> cloudfw_20171207_models.DescribeMemberInfoResponse:
        """
        @summary 免费版获取成员信息
        
        @param request: DescribeMemberInfoRequest
        @return: DescribeMemberInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_member_info_with_options(request, runtime)

    async def describe_member_info_async(
        self,
        request: cloudfw_20171207_models.DescribeMemberInfoRequest,
    ) -> cloudfw_20171207_models.DescribeMemberInfoResponse:
        """
        @summary 免费版获取成员信息
        
        @param request: DescribeMemberInfoRequest
        @return: DescribeMemberInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_member_info_with_options_async(request, runtime)

    def describe_nat_acl_page_status_with_options(
        self,
        request: cloudfw_20171207_models.DescribeNatAclPageStatusRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeNatAclPageStatusResponse:
        """
        @summary Queries the pagination status of NAT firewalls.
        
        @param request: DescribeNatAclPageStatusRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeNatAclPageStatusResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNatAclPageStatus',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeNatAclPageStatusResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_nat_acl_page_status_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeNatAclPageStatusRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeNatAclPageStatusResponse:
        """
        @summary Queries the pagination status of NAT firewalls.
        
        @param request: DescribeNatAclPageStatusRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeNatAclPageStatusResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNatAclPageStatus',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeNatAclPageStatusResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_nat_acl_page_status(
        self,
        request: cloudfw_20171207_models.DescribeNatAclPageStatusRequest,
    ) -> cloudfw_20171207_models.DescribeNatAclPageStatusResponse:
        """
        @summary Queries the pagination status of NAT firewalls.
        
        @param request: DescribeNatAclPageStatusRequest
        @return: DescribeNatAclPageStatusResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_nat_acl_page_status_with_options(request, runtime)

    async def describe_nat_acl_page_status_async(
        self,
        request: cloudfw_20171207_models.DescribeNatAclPageStatusRequest,
    ) -> cloudfw_20171207_models.DescribeNatAclPageStatusResponse:
        """
        @summary Queries the pagination status of NAT firewalls.
        
        @param request: DescribeNatAclPageStatusRequest
        @return: DescribeNatAclPageStatusResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_nat_acl_page_status_with_options_async(request, runtime)

    def describe_nat_firewall_acl_group_list_with_options(
        self,
        request: cloudfw_20171207_models.DescribeNatFirewallAclGroupListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeNatFirewallAclGroupListResponse:
        """
        @summary 查询Nat防火墙分组列表
        
        @param request: DescribeNatFirewallAclGroupListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeNatFirewallAclGroupListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNatFirewallAclGroupList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeNatFirewallAclGroupListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_nat_firewall_acl_group_list_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeNatFirewallAclGroupListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeNatFirewallAclGroupListResponse:
        """
        @summary 查询Nat防火墙分组列表
        
        @param request: DescribeNatFirewallAclGroupListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeNatFirewallAclGroupListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNatFirewallAclGroupList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeNatFirewallAclGroupListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_nat_firewall_acl_group_list(
        self,
        request: cloudfw_20171207_models.DescribeNatFirewallAclGroupListRequest,
    ) -> cloudfw_20171207_models.DescribeNatFirewallAclGroupListResponse:
        """
        @summary 查询Nat防火墙分组列表
        
        @param request: DescribeNatFirewallAclGroupListRequest
        @return: DescribeNatFirewallAclGroupListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_nat_firewall_acl_group_list_with_options(request, runtime)

    async def describe_nat_firewall_acl_group_list_async(
        self,
        request: cloudfw_20171207_models.DescribeNatFirewallAclGroupListRequest,
    ) -> cloudfw_20171207_models.DescribeNatFirewallAclGroupListResponse:
        """
        @summary 查询Nat防火墙分组列表
        
        @param request: DescribeNatFirewallAclGroupListRequest
        @return: DescribeNatFirewallAclGroupListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_nat_firewall_acl_group_list_with_options_async(request, runtime)

    def describe_nat_firewall_control_policy_with_options(
        self,
        request: cloudfw_20171207_models.DescribeNatFirewallControlPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeNatFirewallControlPolicyResponse:
        """
        @summary Queries the information about all access control policies that are created for NAT firewalls.
        
        @description You can use this operation to query the information about all access control policies that are created for NAT firewalls by page.
        
        @param request: DescribeNatFirewallControlPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeNatFirewallControlPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_action):
            query['AclAction'] = request.acl_action
        if not UtilClient.is_unset(request.acl_uuid):
            query['AclUuid'] = request.acl_uuid
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.destination):
            query['Destination'] = request.destination
        if not UtilClient.is_unset(request.direction):
            query['Direction'] = request.direction
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.proto):
            query['Proto'] = request.proto
        if not UtilClient.is_unset(request.release):
            query['Release'] = request.release
        if not UtilClient.is_unset(request.repeat_type):
            query['RepeatType'] = request.repeat_type
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNatFirewallControlPolicy',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeNatFirewallControlPolicyResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_nat_firewall_control_policy_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeNatFirewallControlPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeNatFirewallControlPolicyResponse:
        """
        @summary Queries the information about all access control policies that are created for NAT firewalls.
        
        @description You can use this operation to query the information about all access control policies that are created for NAT firewalls by page.
        
        @param request: DescribeNatFirewallControlPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeNatFirewallControlPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_action):
            query['AclAction'] = request.acl_action
        if not UtilClient.is_unset(request.acl_uuid):
            query['AclUuid'] = request.acl_uuid
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.destination):
            query['Destination'] = request.destination
        if not UtilClient.is_unset(request.direction):
            query['Direction'] = request.direction
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.proto):
            query['Proto'] = request.proto
        if not UtilClient.is_unset(request.release):
            query['Release'] = request.release
        if not UtilClient.is_unset(request.repeat_type):
            query['RepeatType'] = request.repeat_type
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNatFirewallControlPolicy',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeNatFirewallControlPolicyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_nat_firewall_control_policy(
        self,
        request: cloudfw_20171207_models.DescribeNatFirewallControlPolicyRequest,
    ) -> cloudfw_20171207_models.DescribeNatFirewallControlPolicyResponse:
        """
        @summary Queries the information about all access control policies that are created for NAT firewalls.
        
        @description You can use this operation to query the information about all access control policies that are created for NAT firewalls by page.
        
        @param request: DescribeNatFirewallControlPolicyRequest
        @return: DescribeNatFirewallControlPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_nat_firewall_control_policy_with_options(request, runtime)

    async def describe_nat_firewall_control_policy_async(
        self,
        request: cloudfw_20171207_models.DescribeNatFirewallControlPolicyRequest,
    ) -> cloudfw_20171207_models.DescribeNatFirewallControlPolicyResponse:
        """
        @summary Queries the information about all access control policies that are created for NAT firewalls.
        
        @description You can use this operation to query the information about all access control policies that are created for NAT firewalls by page.
        
        @param request: DescribeNatFirewallControlPolicyRequest
        @return: DescribeNatFirewallControlPolicyResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_nat_firewall_control_policy_with_options_async(request, runtime)

    def describe_nat_firewall_drop_traffic_trend_with_options(
        self,
        request: cloudfw_20171207_models.DescribeNatFirewallDropTrafficTrendRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeNatFirewallDropTrafficTrendResponse:
        """
        @summary 概览页-nat防火墙拦截趋势
        
        @param request: DescribeNatFirewallDropTrafficTrendRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeNatFirewallDropTrafficTrendResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNatFirewallDropTrafficTrend',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeNatFirewallDropTrafficTrendResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_nat_firewall_drop_traffic_trend_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeNatFirewallDropTrafficTrendRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeNatFirewallDropTrafficTrendResponse:
        """
        @summary 概览页-nat防火墙拦截趋势
        
        @param request: DescribeNatFirewallDropTrafficTrendRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeNatFirewallDropTrafficTrendResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNatFirewallDropTrafficTrend',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeNatFirewallDropTrafficTrendResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_nat_firewall_drop_traffic_trend(
        self,
        request: cloudfw_20171207_models.DescribeNatFirewallDropTrafficTrendRequest,
    ) -> cloudfw_20171207_models.DescribeNatFirewallDropTrafficTrendResponse:
        """
        @summary 概览页-nat防火墙拦截趋势
        
        @param request: DescribeNatFirewallDropTrafficTrendRequest
        @return: DescribeNatFirewallDropTrafficTrendResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_nat_firewall_drop_traffic_trend_with_options(request, runtime)

    async def describe_nat_firewall_drop_traffic_trend_async(
        self,
        request: cloudfw_20171207_models.DescribeNatFirewallDropTrafficTrendRequest,
    ) -> cloudfw_20171207_models.DescribeNatFirewallDropTrafficTrendResponse:
        """
        @summary 概览页-nat防火墙拦截趋势
        
        @param request: DescribeNatFirewallDropTrafficTrendRequest
        @return: DescribeNatFirewallDropTrafficTrendResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_nat_firewall_drop_traffic_trend_with_options_async(request, runtime)

    def describe_nat_firewall_list_with_options(
        self,
        request: cloudfw_20171207_models.DescribeNatFirewallListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeNatFirewallListResponse:
        """
        @summary Queries details of NAT firewalls.
        
        @param request: DescribeNatFirewallListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeNatFirewallListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.member_uid):
            query['MemberUid'] = request.member_uid
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.page_no):
            query['PageNo'] = request.page_no
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.proxy_id):
            query['ProxyId'] = request.proxy_id
        if not UtilClient.is_unset(request.proxy_name):
            query['ProxyName'] = request.proxy_name
        if not UtilClient.is_unset(request.region_no):
            query['RegionNo'] = request.region_no
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNatFirewallList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeNatFirewallListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_nat_firewall_list_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeNatFirewallListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeNatFirewallListResponse:
        """
        @summary Queries details of NAT firewalls.
        
        @param request: DescribeNatFirewallListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeNatFirewallListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.member_uid):
            query['MemberUid'] = request.member_uid
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.page_no):
            query['PageNo'] = request.page_no
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.proxy_id):
            query['ProxyId'] = request.proxy_id
        if not UtilClient.is_unset(request.proxy_name):
            query['ProxyName'] = request.proxy_name
        if not UtilClient.is_unset(request.region_no):
            query['RegionNo'] = request.region_no
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNatFirewallList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeNatFirewallListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_nat_firewall_list(
        self,
        request: cloudfw_20171207_models.DescribeNatFirewallListRequest,
    ) -> cloudfw_20171207_models.DescribeNatFirewallListResponse:
        """
        @summary Queries details of NAT firewalls.
        
        @param request: DescribeNatFirewallListRequest
        @return: DescribeNatFirewallListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_nat_firewall_list_with_options(request, runtime)

    async def describe_nat_firewall_list_async(
        self,
        request: cloudfw_20171207_models.DescribeNatFirewallListRequest,
    ) -> cloudfw_20171207_models.DescribeNatFirewallListResponse:
        """
        @summary Queries details of NAT firewalls.
        
        @param request: DescribeNatFirewallListRequest
        @return: DescribeNatFirewallListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_nat_firewall_list_with_options_async(request, runtime)

    def describe_nat_firewall_policy_prior_used_with_options(
        self,
        request: cloudfw_20171207_models.DescribeNatFirewallPolicyPriorUsedRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeNatFirewallPolicyPriorUsedResponse:
        """
        @summary Queries the priority range of access control policies that are created for a NAT firewall.
        
        @description You can use this operation to query the priority range of access control policies that are created for a NAT firewall.
        
        @param request: DescribeNatFirewallPolicyPriorUsedRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeNatFirewallPolicyPriorUsedResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.direction):
            query['Direction'] = request.direction
        if not UtilClient.is_unset(request.ip_version):
            query['IpVersion'] = request.ip_version
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNatFirewallPolicyPriorUsed',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeNatFirewallPolicyPriorUsedResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_nat_firewall_policy_prior_used_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeNatFirewallPolicyPriorUsedRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeNatFirewallPolicyPriorUsedResponse:
        """
        @summary Queries the priority range of access control policies that are created for a NAT firewall.
        
        @description You can use this operation to query the priority range of access control policies that are created for a NAT firewall.
        
        @param request: DescribeNatFirewallPolicyPriorUsedRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeNatFirewallPolicyPriorUsedResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.direction):
            query['Direction'] = request.direction
        if not UtilClient.is_unset(request.ip_version):
            query['IpVersion'] = request.ip_version
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNatFirewallPolicyPriorUsed',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeNatFirewallPolicyPriorUsedResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_nat_firewall_policy_prior_used(
        self,
        request: cloudfw_20171207_models.DescribeNatFirewallPolicyPriorUsedRequest,
    ) -> cloudfw_20171207_models.DescribeNatFirewallPolicyPriorUsedResponse:
        """
        @summary Queries the priority range of access control policies that are created for a NAT firewall.
        
        @description You can use this operation to query the priority range of access control policies that are created for a NAT firewall.
        
        @param request: DescribeNatFirewallPolicyPriorUsedRequest
        @return: DescribeNatFirewallPolicyPriorUsedResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_nat_firewall_policy_prior_used_with_options(request, runtime)

    async def describe_nat_firewall_policy_prior_used_async(
        self,
        request: cloudfw_20171207_models.DescribeNatFirewallPolicyPriorUsedRequest,
    ) -> cloudfw_20171207_models.DescribeNatFirewallPolicyPriorUsedResponse:
        """
        @summary Queries the priority range of access control policies that are created for a NAT firewall.
        
        @description You can use this operation to query the priority range of access control policies that are created for a NAT firewall.
        
        @param request: DescribeNatFirewallPolicyPriorUsedRequest
        @return: DescribeNatFirewallPolicyPriorUsedResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_nat_firewall_policy_prior_used_with_options_async(request, runtime)

    def describe_nat_firewall_precheck_detail_with_options(
        self,
        request: cloudfw_20171207_models.DescribeNatFirewallPrecheckDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeNatFirewallPrecheckDetailResponse:
        """
        @summary 查询NAT防火墙预检查结果
        
        @param request: DescribeNatFirewallPrecheckDetailRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeNatFirewallPrecheckDetailResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNatFirewallPrecheckDetail',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeNatFirewallPrecheckDetailResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_nat_firewall_precheck_detail_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeNatFirewallPrecheckDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeNatFirewallPrecheckDetailResponse:
        """
        @summary 查询NAT防火墙预检查结果
        
        @param request: DescribeNatFirewallPrecheckDetailRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeNatFirewallPrecheckDetailResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNatFirewallPrecheckDetail',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeNatFirewallPrecheckDetailResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_nat_firewall_precheck_detail(
        self,
        request: cloudfw_20171207_models.DescribeNatFirewallPrecheckDetailRequest,
    ) -> cloudfw_20171207_models.DescribeNatFirewallPrecheckDetailResponse:
        """
        @summary 查询NAT防火墙预检查结果
        
        @param request: DescribeNatFirewallPrecheckDetailRequest
        @return: DescribeNatFirewallPrecheckDetailResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_nat_firewall_precheck_detail_with_options(request, runtime)

    async def describe_nat_firewall_precheck_detail_async(
        self,
        request: cloudfw_20171207_models.DescribeNatFirewallPrecheckDetailRequest,
    ) -> cloudfw_20171207_models.DescribeNatFirewallPrecheckDetailResponse:
        """
        @summary 查询NAT防火墙预检查结果
        
        @param request: DescribeNatFirewallPrecheckDetailRequest
        @return: DescribeNatFirewallPrecheckDetailResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_nat_firewall_precheck_detail_with_options_async(request, runtime)

    def describe_nat_firewall_quota_with_options(
        self,
        request: cloudfw_20171207_models.DescribeNatFirewallQuotaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeNatFirewallQuotaResponse:
        """
        @summary 获取NAT防火墙配额
        
        @param request: DescribeNatFirewallQuotaRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeNatFirewallQuotaResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNatFirewallQuota',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeNatFirewallQuotaResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_nat_firewall_quota_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeNatFirewallQuotaRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeNatFirewallQuotaResponse:
        """
        @summary 获取NAT防火墙配额
        
        @param request: DescribeNatFirewallQuotaRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeNatFirewallQuotaResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNatFirewallQuota',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeNatFirewallQuotaResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_nat_firewall_quota(
        self,
        request: cloudfw_20171207_models.DescribeNatFirewallQuotaRequest,
    ) -> cloudfw_20171207_models.DescribeNatFirewallQuotaResponse:
        """
        @summary 获取NAT防火墙配额
        
        @param request: DescribeNatFirewallQuotaRequest
        @return: DescribeNatFirewallQuotaResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_nat_firewall_quota_with_options(request, runtime)

    async def describe_nat_firewall_quota_async(
        self,
        request: cloudfw_20171207_models.DescribeNatFirewallQuotaRequest,
    ) -> cloudfw_20171207_models.DescribeNatFirewallQuotaResponse:
        """
        @summary 获取NAT防火墙配额
        
        @param request: DescribeNatFirewallQuotaRequest
        @return: DescribeNatFirewallQuotaResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_nat_firewall_quota_with_options_async(request, runtime)

    def describe_nat_firewall_time_top_with_options(
        self,
        request: cloudfw_20171207_models.DescribeNatFirewallTimeTopRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeNatFirewallTimeTopResponse:
        """
        @summary 查询NAT防火墙时间点流量详情列表
        
        @param request: DescribeNatFirewallTimeTopRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeNatFirewallTimeTopResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNatFirewallTimeTop',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeNatFirewallTimeTopResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_nat_firewall_time_top_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeNatFirewallTimeTopRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeNatFirewallTimeTopResponse:
        """
        @summary 查询NAT防火墙时间点流量详情列表
        
        @param request: DescribeNatFirewallTimeTopRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeNatFirewallTimeTopResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNatFirewallTimeTop',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeNatFirewallTimeTopResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_nat_firewall_time_top(
        self,
        request: cloudfw_20171207_models.DescribeNatFirewallTimeTopRequest,
    ) -> cloudfw_20171207_models.DescribeNatFirewallTimeTopResponse:
        """
        @summary 查询NAT防火墙时间点流量详情列表
        
        @param request: DescribeNatFirewallTimeTopRequest
        @return: DescribeNatFirewallTimeTopResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_nat_firewall_time_top_with_options(request, runtime)

    async def describe_nat_firewall_time_top_async(
        self,
        request: cloudfw_20171207_models.DescribeNatFirewallTimeTopRequest,
    ) -> cloudfw_20171207_models.DescribeNatFirewallTimeTopResponse:
        """
        @summary 查询NAT防火墙时间点流量详情列表
        
        @param request: DescribeNatFirewallTimeTopRequest
        @return: DescribeNatFirewallTimeTopResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_nat_firewall_time_top_with_options_async(request, runtime)

    def describe_nat_firewall_traffic_trend_with_options(
        self,
        request: cloudfw_20171207_models.DescribeNatFirewallTrafficTrendRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeNatFirewallTrafficTrendResponse:
        """
        @summary 概览页-NAT流量趋势
        
        @param request: DescribeNatFirewallTrafficTrendRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeNatFirewallTrafficTrendResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNatFirewallTrafficTrend',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeNatFirewallTrafficTrendResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_nat_firewall_traffic_trend_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeNatFirewallTrafficTrendRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeNatFirewallTrafficTrendResponse:
        """
        @summary 概览页-NAT流量趋势
        
        @param request: DescribeNatFirewallTrafficTrendRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeNatFirewallTrafficTrendResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNatFirewallTrafficTrend',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeNatFirewallTrafficTrendResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_nat_firewall_traffic_trend(
        self,
        request: cloudfw_20171207_models.DescribeNatFirewallTrafficTrendRequest,
    ) -> cloudfw_20171207_models.DescribeNatFirewallTrafficTrendResponse:
        """
        @summary 概览页-NAT流量趋势
        
        @param request: DescribeNatFirewallTrafficTrendRequest
        @return: DescribeNatFirewallTrafficTrendResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_nat_firewall_traffic_trend_with_options(request, runtime)

    async def describe_nat_firewall_traffic_trend_async(
        self,
        request: cloudfw_20171207_models.DescribeNatFirewallTrafficTrendRequest,
    ) -> cloudfw_20171207_models.DescribeNatFirewallTrafficTrendResponse:
        """
        @summary 概览页-NAT流量趋势
        
        @param request: DescribeNatFirewallTrafficTrendRequest
        @return: DescribeNatFirewallTrafficTrendResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_nat_firewall_traffic_trend_with_options_async(request, runtime)

    def describe_network_instance_list_with_options(
        self,
        request: cloudfw_20171207_models.DescribeNetworkInstanceListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeNetworkInstanceListResponse:
        """
        @summary 获取网络实例列表
        
        @param request: DescribeNetworkInstanceListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeNetworkInstanceListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cen_id):
            query['CenId'] = request.cen_id
        if not UtilClient.is_unset(request.connect_type):
            query['ConnectType'] = request.connect_type
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNetworkInstanceList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeNetworkInstanceListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_network_instance_list_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeNetworkInstanceListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeNetworkInstanceListResponse:
        """
        @summary 获取网络实例列表
        
        @param request: DescribeNetworkInstanceListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeNetworkInstanceListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cen_id):
            query['CenId'] = request.cen_id
        if not UtilClient.is_unset(request.connect_type):
            query['ConnectType'] = request.connect_type
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNetworkInstanceList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeNetworkInstanceListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_network_instance_list(
        self,
        request: cloudfw_20171207_models.DescribeNetworkInstanceListRequest,
    ) -> cloudfw_20171207_models.DescribeNetworkInstanceListResponse:
        """
        @summary 获取网络实例列表
        
        @param request: DescribeNetworkInstanceListRequest
        @return: DescribeNetworkInstanceListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_network_instance_list_with_options(request, runtime)

    async def describe_network_instance_list_async(
        self,
        request: cloudfw_20171207_models.DescribeNetworkInstanceListRequest,
    ) -> cloudfw_20171207_models.DescribeNetworkInstanceListResponse:
        """
        @summary 获取网络实例列表
        
        @param request: DescribeNetworkInstanceListRequest
        @return: DescribeNetworkInstanceListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_network_instance_list_with_options_async(request, runtime)

    def describe_network_instance_relation_list_with_options(
        self,
        request: cloudfw_20171207_models.DescribeNetworkInstanceRelationListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeNetworkInstanceRelationListResponse:
        """
        @summary 获取网络实例关系列表
        
        @param request: DescribeNetworkInstanceRelationListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeNetworkInstanceRelationListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.connect_type):
            query['ConnectType'] = request.connect_type
        if not UtilClient.is_unset(request.firewall_configure_status):
            query['FirewallConfigureStatus'] = request.firewall_configure_status
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.network_instance_id):
            query['NetworkInstanceId'] = request.network_instance_id
        if not UtilClient.is_unset(request.peer_network_instance_id):
            query['PeerNetworkInstanceId'] = request.peer_network_instance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNetworkInstanceRelationList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeNetworkInstanceRelationListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_network_instance_relation_list_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeNetworkInstanceRelationListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeNetworkInstanceRelationListResponse:
        """
        @summary 获取网络实例关系列表
        
        @param request: DescribeNetworkInstanceRelationListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeNetworkInstanceRelationListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.connect_type):
            query['ConnectType'] = request.connect_type
        if not UtilClient.is_unset(request.firewall_configure_status):
            query['FirewallConfigureStatus'] = request.firewall_configure_status
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.network_instance_id):
            query['NetworkInstanceId'] = request.network_instance_id
        if not UtilClient.is_unset(request.peer_network_instance_id):
            query['PeerNetworkInstanceId'] = request.peer_network_instance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNetworkInstanceRelationList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeNetworkInstanceRelationListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_network_instance_relation_list(
        self,
        request: cloudfw_20171207_models.DescribeNetworkInstanceRelationListRequest,
    ) -> cloudfw_20171207_models.DescribeNetworkInstanceRelationListResponse:
        """
        @summary 获取网络实例关系列表
        
        @param request: DescribeNetworkInstanceRelationListRequest
        @return: DescribeNetworkInstanceRelationListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_network_instance_relation_list_with_options(request, runtime)

    async def describe_network_instance_relation_list_async(
        self,
        request: cloudfw_20171207_models.DescribeNetworkInstanceRelationListRequest,
    ) -> cloudfw_20171207_models.DescribeNetworkInstanceRelationListResponse:
        """
        @summary 获取网络实例关系列表
        
        @param request: DescribeNetworkInstanceRelationListRequest
        @return: DescribeNetworkInstanceRelationListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_network_instance_relation_list_with_options_async(request, runtime)

    def describe_network_traffic_top_ratio_with_options(
        self,
        request: cloudfw_20171207_models.DescribeNetworkTrafficTopRatioRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeNetworkTrafficTopRatioResponse:
        """
        @summary 获取网络流量TOP环比
        
        @param request: DescribeNetworkTrafficTopRatioRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeNetworkTrafficTopRatioResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.asset_ip):
            query['AssetIP'] = request.asset_ip
        if not UtilClient.is_unset(request.asset_region):
            query['AssetRegion'] = request.asset_region
        if not UtilClient.is_unset(request.data_type):
            query['DataType'] = request.data_type
        if not UtilClient.is_unset(request.direction):
            query['Direction'] = request.direction
        if not UtilClient.is_unset(request.dst_ip):
            query['DstIP'] = request.dst_ip
        if not UtilClient.is_unset(request.dst_port):
            query['DstPort'] = request.dst_port
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.ip_property):
            query['IpProperty'] = request.ip_property
        if not UtilClient.is_unset(request.isp):
            query['Isp'] = request.isp
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.location):
            query['Location'] = request.location
        if not UtilClient.is_unset(request.rule_result):
            query['RuleResult'] = request.rule_result
        if not UtilClient.is_unset(request.sort):
            query['Sort'] = request.sort
        if not UtilClient.is_unset(request.source_code):
            query['SourceCode'] = request.source_code
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.src_ip):
            query['SrcIP'] = request.src_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNetworkTrafficTopRatio',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeNetworkTrafficTopRatioResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_network_traffic_top_ratio_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeNetworkTrafficTopRatioRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeNetworkTrafficTopRatioResponse:
        """
        @summary 获取网络流量TOP环比
        
        @param request: DescribeNetworkTrafficTopRatioRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeNetworkTrafficTopRatioResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.asset_ip):
            query['AssetIP'] = request.asset_ip
        if not UtilClient.is_unset(request.asset_region):
            query['AssetRegion'] = request.asset_region
        if not UtilClient.is_unset(request.data_type):
            query['DataType'] = request.data_type
        if not UtilClient.is_unset(request.direction):
            query['Direction'] = request.direction
        if not UtilClient.is_unset(request.dst_ip):
            query['DstIP'] = request.dst_ip
        if not UtilClient.is_unset(request.dst_port):
            query['DstPort'] = request.dst_port
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.ip_property):
            query['IpProperty'] = request.ip_property
        if not UtilClient.is_unset(request.isp):
            query['Isp'] = request.isp
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.location):
            query['Location'] = request.location
        if not UtilClient.is_unset(request.rule_result):
            query['RuleResult'] = request.rule_result
        if not UtilClient.is_unset(request.sort):
            query['Sort'] = request.sort
        if not UtilClient.is_unset(request.source_code):
            query['SourceCode'] = request.source_code
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.src_ip):
            query['SrcIP'] = request.src_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeNetworkTrafficTopRatio',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeNetworkTrafficTopRatioResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_network_traffic_top_ratio(
        self,
        request: cloudfw_20171207_models.DescribeNetworkTrafficTopRatioRequest,
    ) -> cloudfw_20171207_models.DescribeNetworkTrafficTopRatioResponse:
        """
        @summary 获取网络流量TOP环比
        
        @param request: DescribeNetworkTrafficTopRatioRequest
        @return: DescribeNetworkTrafficTopRatioResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_network_traffic_top_ratio_with_options(request, runtime)

    async def describe_network_traffic_top_ratio_async(
        self,
        request: cloudfw_20171207_models.DescribeNetworkTrafficTopRatioRequest,
    ) -> cloudfw_20171207_models.DescribeNetworkTrafficTopRatioResponse:
        """
        @summary 获取网络流量TOP环比
        
        @param request: DescribeNetworkTrafficTopRatioRequest
        @return: DescribeNetworkTrafficTopRatioResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_network_traffic_top_ratio_with_options_async(request, runtime)

    def describe_open_ip_access_src_stat_with_options(
        self,
        request: cloudfw_20171207_models.DescribeOpenIpAccessSrcStatRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeOpenIpAccessSrcStatResponse:
        """
        @summary 获取公网IP通过的源状态
        
        @param request: DescribeOpenIpAccessSrcStatRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeOpenIpAccessSrcStatResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.dst_ip):
            query['DstIp'] = request.dst_ip
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeOpenIpAccessSrcStat',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeOpenIpAccessSrcStatResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_open_ip_access_src_stat_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeOpenIpAccessSrcStatRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeOpenIpAccessSrcStatResponse:
        """
        @summary 获取公网IP通过的源状态
        
        @param request: DescribeOpenIpAccessSrcStatRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeOpenIpAccessSrcStatResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.dst_ip):
            query['DstIp'] = request.dst_ip
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeOpenIpAccessSrcStat',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeOpenIpAccessSrcStatResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_open_ip_access_src_stat(
        self,
        request: cloudfw_20171207_models.DescribeOpenIpAccessSrcStatRequest,
    ) -> cloudfw_20171207_models.DescribeOpenIpAccessSrcStatResponse:
        """
        @summary 获取公网IP通过的源状态
        
        @param request: DescribeOpenIpAccessSrcStatRequest
        @return: DescribeOpenIpAccessSrcStatResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_open_ip_access_src_stat_with_options(request, runtime)

    async def describe_open_ip_access_src_stat_async(
        self,
        request: cloudfw_20171207_models.DescribeOpenIpAccessSrcStatRequest,
    ) -> cloudfw_20171207_models.DescribeOpenIpAccessSrcStatResponse:
        """
        @summary 获取公网IP通过的源状态
        
        @param request: DescribeOpenIpAccessSrcStatRequest
        @return: DescribeOpenIpAccessSrcStatResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_open_ip_access_src_stat_with_options_async(request, runtime)

    def describe_outgoing_asset_list_with_options(
        self,
        request: cloudfw_20171207_models.DescribeOutgoingAssetListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeOutgoingAssetListResponse:
        """
        @summary 获取外联资产列表
        
        @param request: DescribeOutgoingAssetListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeOutgoingAssetListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.assets_region):
            query['AssetsRegion'] = request.assets_region
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        if not UtilClient.is_unset(request.iptype):
            query['IPType'] = request.iptype
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.nat_gateway_name):
            query['NatGatewayName'] = request.nat_gateway_name
        if not UtilClient.is_unset(request.order):
            query['Order'] = request.order
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.private_ip):
            query['PrivateIP'] = request.private_ip
        if not UtilClient.is_unset(request.public_ip):
            query['PublicIP'] = request.public_ip
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        if not UtilClient.is_unset(request.security_risk):
            query['SecurityRisk'] = request.security_risk
        if not UtilClient.is_unset(request.sort):
            query['Sort'] = request.sort
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeOutgoingAssetList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeOutgoingAssetListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_outgoing_asset_list_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeOutgoingAssetListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeOutgoingAssetListResponse:
        """
        @summary 获取外联资产列表
        
        @param request: DescribeOutgoingAssetListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeOutgoingAssetListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.assets_region):
            query['AssetsRegion'] = request.assets_region
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.group_name):
            query['GroupName'] = request.group_name
        if not UtilClient.is_unset(request.iptype):
            query['IPType'] = request.iptype
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.nat_gateway_name):
            query['NatGatewayName'] = request.nat_gateway_name
        if not UtilClient.is_unset(request.order):
            query['Order'] = request.order
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.private_ip):
            query['PrivateIP'] = request.private_ip
        if not UtilClient.is_unset(request.public_ip):
            query['PublicIP'] = request.public_ip
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        if not UtilClient.is_unset(request.security_risk):
            query['SecurityRisk'] = request.security_risk
        if not UtilClient.is_unset(request.sort):
            query['Sort'] = request.sort
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeOutgoingAssetList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeOutgoingAssetListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_outgoing_asset_list(
        self,
        request: cloudfw_20171207_models.DescribeOutgoingAssetListRequest,
    ) -> cloudfw_20171207_models.DescribeOutgoingAssetListResponse:
        """
        @summary 获取外联资产列表
        
        @param request: DescribeOutgoingAssetListRequest
        @return: DescribeOutgoingAssetListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_outgoing_asset_list_with_options(request, runtime)

    async def describe_outgoing_asset_list_async(
        self,
        request: cloudfw_20171207_models.DescribeOutgoingAssetListRequest,
    ) -> cloudfw_20171207_models.DescribeOutgoingAssetListResponse:
        """
        @summary 获取外联资产列表
        
        @param request: DescribeOutgoingAssetListRequest
        @return: DescribeOutgoingAssetListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_outgoing_asset_list_with_options_async(request, runtime)

    def describe_outgoing_destination_with_options(
        self,
        request: cloudfw_20171207_models.DescribeOutgoingDestinationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeOutgoingDestinationResponse:
        """
        @summary 获取外联目的
        
        @param request: DescribeOutgoingDestinationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeOutgoingDestinationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_coverage):
            query['AclCoverage'] = request.acl_coverage
        if not UtilClient.is_unset(request.application_name):
            query['ApplicationName'] = request.application_name
        if not UtilClient.is_unset(request.category_id):
            query['CategoryId'] = request.category_id
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.dst_ip):
            query['DstIP'] = request.dst_ip
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.is_aitraffic):
            query['IsAITraffic'] = request.is_aitraffic
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.order):
            query['Order'] = request.order
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.port):
            query['Port'] = request.port
        if not UtilClient.is_unset(request.private_ip):
            query['PrivateIP'] = request.private_ip
        if not UtilClient.is_unset(request.public_ip):
            query['PublicIP'] = request.public_ip
        if not UtilClient.is_unset(request.security_suggest):
            query['SecuritySuggest'] = request.security_suggest
        if not UtilClient.is_unset(request.sort):
            query['Sort'] = request.sort
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.tag_id):
            query['TagId'] = request.tag_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeOutgoingDestination',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeOutgoingDestinationResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_outgoing_destination_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeOutgoingDestinationRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeOutgoingDestinationResponse:
        """
        @summary 获取外联目的
        
        @param request: DescribeOutgoingDestinationRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeOutgoingDestinationResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_coverage):
            query['AclCoverage'] = request.acl_coverage
        if not UtilClient.is_unset(request.application_name):
            query['ApplicationName'] = request.application_name
        if not UtilClient.is_unset(request.category_id):
            query['CategoryId'] = request.category_id
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.dst_ip):
            query['DstIP'] = request.dst_ip
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.is_aitraffic):
            query['IsAITraffic'] = request.is_aitraffic
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.order):
            query['Order'] = request.order
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.port):
            query['Port'] = request.port
        if not UtilClient.is_unset(request.private_ip):
            query['PrivateIP'] = request.private_ip
        if not UtilClient.is_unset(request.public_ip):
            query['PublicIP'] = request.public_ip
        if not UtilClient.is_unset(request.security_suggest):
            query['SecuritySuggest'] = request.security_suggest
        if not UtilClient.is_unset(request.sort):
            query['Sort'] = request.sort
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.tag_id):
            query['TagId'] = request.tag_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeOutgoingDestination',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeOutgoingDestinationResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_outgoing_destination(
        self,
        request: cloudfw_20171207_models.DescribeOutgoingDestinationRequest,
    ) -> cloudfw_20171207_models.DescribeOutgoingDestinationResponse:
        """
        @summary 获取外联目的
        
        @param request: DescribeOutgoingDestinationRequest
        @return: DescribeOutgoingDestinationResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_outgoing_destination_with_options(request, runtime)

    async def describe_outgoing_destination_async(
        self,
        request: cloudfw_20171207_models.DescribeOutgoingDestinationRequest,
    ) -> cloudfw_20171207_models.DescribeOutgoingDestinationResponse:
        """
        @summary 获取外联目的
        
        @param request: DescribeOutgoingDestinationRequest
        @return: DescribeOutgoingDestinationResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_outgoing_destination_with_options_async(request, runtime)

    def describe_outgoing_destination_category_with_options(
        self,
        request: cloudfw_20171207_models.DescribeOutgoingDestinationCategoryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeOutgoingDestinationCategoryResponse:
        """
        @summary 获取外联目的分类
        
        @param request: DescribeOutgoingDestinationCategoryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeOutgoingDestinationCategoryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.category_id):
            query['CategoryId'] = request.category_id
        if not UtilClient.is_unset(request.dst_type):
            query['DstType'] = request.dst_type
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.type_id):
            query['TypeId'] = request.type_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeOutgoingDestinationCategory',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeOutgoingDestinationCategoryResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_outgoing_destination_category_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeOutgoingDestinationCategoryRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeOutgoingDestinationCategoryResponse:
        """
        @summary 获取外联目的分类
        
        @param request: DescribeOutgoingDestinationCategoryRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeOutgoingDestinationCategoryResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.category_id):
            query['CategoryId'] = request.category_id
        if not UtilClient.is_unset(request.dst_type):
            query['DstType'] = request.dst_type
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.type_id):
            query['TypeId'] = request.type_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeOutgoingDestinationCategory',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeOutgoingDestinationCategoryResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_outgoing_destination_category(
        self,
        request: cloudfw_20171207_models.DescribeOutgoingDestinationCategoryRequest,
    ) -> cloudfw_20171207_models.DescribeOutgoingDestinationCategoryResponse:
        """
        @summary 获取外联目的分类
        
        @param request: DescribeOutgoingDestinationCategoryRequest
        @return: DescribeOutgoingDestinationCategoryResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_outgoing_destination_category_with_options(request, runtime)

    async def describe_outgoing_destination_category_async(
        self,
        request: cloudfw_20171207_models.DescribeOutgoingDestinationCategoryRequest,
    ) -> cloudfw_20171207_models.DescribeOutgoingDestinationCategoryResponse:
        """
        @summary 获取外联目的分类
        
        @param request: DescribeOutgoingDestinationCategoryRequest
        @return: DescribeOutgoingDestinationCategoryResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_outgoing_destination_category_with_options_async(request, runtime)

    def describe_outgoing_destination_ipwith_options(
        self,
        request: cloudfw_20171207_models.DescribeOutgoingDestinationIPRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeOutgoingDestinationIPResponse:
        """
        @summary Get details of outgoing destination IPs
        
        @param request: DescribeOutgoingDestinationIPRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeOutgoingDestinationIPResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.application_name):
            query['ApplicationName'] = request.application_name
        if not UtilClient.is_unset(request.category_id):
            query['CategoryId'] = request.category_id
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.dst_ip):
            query['DstIP'] = request.dst_ip
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.order):
            query['Order'] = request.order
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.port):
            query['Port'] = request.port
        if not UtilClient.is_unset(request.private_ip):
            query['PrivateIP'] = request.private_ip
        if not UtilClient.is_unset(request.public_ip):
            query['PublicIP'] = request.public_ip
        if not UtilClient.is_unset(request.sort):
            query['Sort'] = request.sort
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.tag_id_new):
            query['TagIdNew'] = request.tag_id_new
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeOutgoingDestinationIP',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeOutgoingDestinationIPResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_outgoing_destination_ipwith_options_async(
        self,
        request: cloudfw_20171207_models.DescribeOutgoingDestinationIPRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeOutgoingDestinationIPResponse:
        """
        @summary Get details of outgoing destination IPs
        
        @param request: DescribeOutgoingDestinationIPRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeOutgoingDestinationIPResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.application_name):
            query['ApplicationName'] = request.application_name
        if not UtilClient.is_unset(request.category_id):
            query['CategoryId'] = request.category_id
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.dst_ip):
            query['DstIP'] = request.dst_ip
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.order):
            query['Order'] = request.order
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.port):
            query['Port'] = request.port
        if not UtilClient.is_unset(request.private_ip):
            query['PrivateIP'] = request.private_ip
        if not UtilClient.is_unset(request.public_ip):
            query['PublicIP'] = request.public_ip
        if not UtilClient.is_unset(request.sort):
            query['Sort'] = request.sort
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.tag_id_new):
            query['TagIdNew'] = request.tag_id_new
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeOutgoingDestinationIP',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeOutgoingDestinationIPResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_outgoing_destination_ip(
        self,
        request: cloudfw_20171207_models.DescribeOutgoingDestinationIPRequest,
    ) -> cloudfw_20171207_models.DescribeOutgoingDestinationIPResponse:
        """
        @summary Get details of outgoing destination IPs
        
        @param request: DescribeOutgoingDestinationIPRequest
        @return: DescribeOutgoingDestinationIPResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_outgoing_destination_ipwith_options(request, runtime)

    async def describe_outgoing_destination_ip_async(
        self,
        request: cloudfw_20171207_models.DescribeOutgoingDestinationIPRequest,
    ) -> cloudfw_20171207_models.DescribeOutgoingDestinationIPResponse:
        """
        @summary Get details of outgoing destination IPs
        
        @param request: DescribeOutgoingDestinationIPRequest
        @return: DescribeOutgoingDestinationIPResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_outgoing_destination_ipwith_options_async(request, runtime)

    def describe_outgoing_destination_ipdetail_with_options(
        self,
        request: cloudfw_20171207_models.DescribeOutgoingDestinationIPDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeOutgoingDestinationIPDetailResponse:
        """
        @summary 获取外联目的IP详情
        
        @param request: DescribeOutgoingDestinationIPDetailRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeOutgoingDestinationIPDetailResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_coverage):
            query['AclCoverage'] = request.acl_coverage
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.dst_ip):
            query['DstIP'] = request.dst_ip
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.iptype):
            query['IPType'] = request.iptype
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.order):
            query['Order'] = request.order
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.private_ip):
            query['PrivateIP'] = request.private_ip
        if not UtilClient.is_unset(request.public_ip):
            query['PublicIP'] = request.public_ip
        if not UtilClient.is_unset(request.sort):
            query['Sort'] = request.sort
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.tag_id):
            query['TagId'] = request.tag_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeOutgoingDestinationIPDetail',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeOutgoingDestinationIPDetailResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_outgoing_destination_ipdetail_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeOutgoingDestinationIPDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeOutgoingDestinationIPDetailResponse:
        """
        @summary 获取外联目的IP详情
        
        @param request: DescribeOutgoingDestinationIPDetailRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeOutgoingDestinationIPDetailResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_coverage):
            query['AclCoverage'] = request.acl_coverage
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.dst_ip):
            query['DstIP'] = request.dst_ip
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.iptype):
            query['IPType'] = request.iptype
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.order):
            query['Order'] = request.order
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.private_ip):
            query['PrivateIP'] = request.private_ip
        if not UtilClient.is_unset(request.public_ip):
            query['PublicIP'] = request.public_ip
        if not UtilClient.is_unset(request.sort):
            query['Sort'] = request.sort
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.tag_id):
            query['TagId'] = request.tag_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeOutgoingDestinationIPDetail',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeOutgoingDestinationIPDetailResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_outgoing_destination_ipdetail(
        self,
        request: cloudfw_20171207_models.DescribeOutgoingDestinationIPDetailRequest,
    ) -> cloudfw_20171207_models.DescribeOutgoingDestinationIPDetailResponse:
        """
        @summary 获取外联目的IP详情
        
        @param request: DescribeOutgoingDestinationIPDetailRequest
        @return: DescribeOutgoingDestinationIPDetailResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_outgoing_destination_ipdetail_with_options(request, runtime)

    async def describe_outgoing_destination_ipdetail_async(
        self,
        request: cloudfw_20171207_models.DescribeOutgoingDestinationIPDetailRequest,
    ) -> cloudfw_20171207_models.DescribeOutgoingDestinationIPDetailResponse:
        """
        @summary 获取外联目的IP详情
        
        @param request: DescribeOutgoingDestinationIPDetailRequest
        @return: DescribeOutgoingDestinationIPDetailResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_outgoing_destination_ipdetail_with_options_async(request, runtime)

    def describe_outgoing_domain_with_options(
        self,
        request: cloudfw_20171207_models.DescribeOutgoingDomainRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeOutgoingDomainResponse:
        """
        @summary Queries the information about the domain names in outbound connections.
        
        @param request: DescribeOutgoingDomainRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeOutgoingDomainResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.category_id):
            query['CategoryId'] = request.category_id
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.data_type):
            query['DataType'] = request.data_type
        if not UtilClient.is_unset(request.domain):
            query['Domain'] = request.domain
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.is_aitraffic):
            query['IsAITraffic'] = request.is_aitraffic
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.order):
            query['Order'] = request.order
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.public_ip):
            query['PublicIP'] = request.public_ip
        if not UtilClient.is_unset(request.sort):
            query['Sort'] = request.sort
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.tag_id_new):
            query['TagIdNew'] = request.tag_id_new
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeOutgoingDomain',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeOutgoingDomainResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_outgoing_domain_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeOutgoingDomainRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeOutgoingDomainResponse:
        """
        @summary Queries the information about the domain names in outbound connections.
        
        @param request: DescribeOutgoingDomainRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeOutgoingDomainResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.category_id):
            query['CategoryId'] = request.category_id
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.data_type):
            query['DataType'] = request.data_type
        if not UtilClient.is_unset(request.domain):
            query['Domain'] = request.domain
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.is_aitraffic):
            query['IsAITraffic'] = request.is_aitraffic
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.order):
            query['Order'] = request.order
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.public_ip):
            query['PublicIP'] = request.public_ip
        if not UtilClient.is_unset(request.sort):
            query['Sort'] = request.sort
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.tag_id_new):
            query['TagIdNew'] = request.tag_id_new
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeOutgoingDomain',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeOutgoingDomainResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_outgoing_domain(
        self,
        request: cloudfw_20171207_models.DescribeOutgoingDomainRequest,
    ) -> cloudfw_20171207_models.DescribeOutgoingDomainResponse:
        """
        @summary Queries the information about the domain names in outbound connections.
        
        @param request: DescribeOutgoingDomainRequest
        @return: DescribeOutgoingDomainResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_outgoing_domain_with_options(request, runtime)

    async def describe_outgoing_domain_async(
        self,
        request: cloudfw_20171207_models.DescribeOutgoingDomainRequest,
    ) -> cloudfw_20171207_models.DescribeOutgoingDomainResponse:
        """
        @summary Queries the information about the domain names in outbound connections.
        
        @param request: DescribeOutgoingDomainRequest
        @return: DescribeOutgoingDomainResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_outgoing_domain_with_options_async(request, runtime)

    def describe_outgoing_domain_detail_with_options(
        self,
        request: cloudfw_20171207_models.DescribeOutgoingDomainDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeOutgoingDomainDetailResponse:
        """
        @summary 获取外联域名详情
        
        @param request: DescribeOutgoingDomainDetailRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeOutgoingDomainDetailResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_coverage):
            query['AclCoverage'] = request.acl_coverage
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.domain):
            query['Domain'] = request.domain
        if not UtilClient.is_unset(request.domain_list):
            query['DomainList'] = request.domain_list
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.iptype):
            query['IPType'] = request.iptype
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.order):
            query['Order'] = request.order
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.private_ip):
            query['PrivateIP'] = request.private_ip
        if not UtilClient.is_unset(request.public_ip):
            query['PublicIP'] = request.public_ip
        if not UtilClient.is_unset(request.sort):
            query['Sort'] = request.sort
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.tag_id):
            query['TagId'] = request.tag_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeOutgoingDomainDetail',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeOutgoingDomainDetailResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_outgoing_domain_detail_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeOutgoingDomainDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeOutgoingDomainDetailResponse:
        """
        @summary 获取外联域名详情
        
        @param request: DescribeOutgoingDomainDetailRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeOutgoingDomainDetailResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_coverage):
            query['AclCoverage'] = request.acl_coverage
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.domain):
            query['Domain'] = request.domain
        if not UtilClient.is_unset(request.domain_list):
            query['DomainList'] = request.domain_list
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.iptype):
            query['IPType'] = request.iptype
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.order):
            query['Order'] = request.order
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.private_ip):
            query['PrivateIP'] = request.private_ip
        if not UtilClient.is_unset(request.public_ip):
            query['PublicIP'] = request.public_ip
        if not UtilClient.is_unset(request.sort):
            query['Sort'] = request.sort
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.tag_id):
            query['TagId'] = request.tag_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeOutgoingDomainDetail',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeOutgoingDomainDetailResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_outgoing_domain_detail(
        self,
        request: cloudfw_20171207_models.DescribeOutgoingDomainDetailRequest,
    ) -> cloudfw_20171207_models.DescribeOutgoingDomainDetailResponse:
        """
        @summary 获取外联域名详情
        
        @param request: DescribeOutgoingDomainDetailRequest
        @return: DescribeOutgoingDomainDetailResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_outgoing_domain_detail_with_options(request, runtime)

    async def describe_outgoing_domain_detail_async(
        self,
        request: cloudfw_20171207_models.DescribeOutgoingDomainDetailRequest,
    ) -> cloudfw_20171207_models.DescribeOutgoingDomainDetailResponse:
        """
        @summary 获取外联域名详情
        
        @param request: DescribeOutgoingDomainDetailRequest
        @return: DescribeOutgoingDomainDetailResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_outgoing_domain_detail_with_options_async(request, runtime)

    def describe_outgoing_risk_domain_and_ip_count_with_options(
        self,
        request: cloudfw_20171207_models.DescribeOutgoingRiskDomainAndIpCountRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeOutgoingRiskDomainAndIpCountResponse:
        """
        @summary 获取外联风险域名与IP数
        
        @param request: DescribeOutgoingRiskDomainAndIpCountRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeOutgoingRiskDomainAndIpCountResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeOutgoingRiskDomainAndIpCount',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeOutgoingRiskDomainAndIpCountResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_outgoing_risk_domain_and_ip_count_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeOutgoingRiskDomainAndIpCountRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeOutgoingRiskDomainAndIpCountResponse:
        """
        @summary 获取外联风险域名与IP数
        
        @param request: DescribeOutgoingRiskDomainAndIpCountRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeOutgoingRiskDomainAndIpCountResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeOutgoingRiskDomainAndIpCount',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeOutgoingRiskDomainAndIpCountResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_outgoing_risk_domain_and_ip_count(
        self,
        request: cloudfw_20171207_models.DescribeOutgoingRiskDomainAndIpCountRequest,
    ) -> cloudfw_20171207_models.DescribeOutgoingRiskDomainAndIpCountResponse:
        """
        @summary 获取外联风险域名与IP数
        
        @param request: DescribeOutgoingRiskDomainAndIpCountRequest
        @return: DescribeOutgoingRiskDomainAndIpCountResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_outgoing_risk_domain_and_ip_count_with_options(request, runtime)

    async def describe_outgoing_risk_domain_and_ip_count_async(
        self,
        request: cloudfw_20171207_models.DescribeOutgoingRiskDomainAndIpCountRequest,
    ) -> cloudfw_20171207_models.DescribeOutgoingRiskDomainAndIpCountResponse:
        """
        @summary 获取外联风险域名与IP数
        
        @param request: DescribeOutgoingRiskDomainAndIpCountRequest
        @return: DescribeOutgoingRiskDomainAndIpCountResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_outgoing_risk_domain_and_ip_count_with_options_async(request, runtime)

    def describe_outgoing_risk_trend_with_options(
        self,
        request: cloudfw_20171207_models.DescribeOutgoingRiskTrendRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeOutgoingRiskTrendResponse:
        """
        @summary 获取外联风险趋势图
        
        @param request: DescribeOutgoingRiskTrendRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeOutgoingRiskTrendResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeOutgoingRiskTrend',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeOutgoingRiskTrendResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_outgoing_risk_trend_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeOutgoingRiskTrendRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeOutgoingRiskTrendResponse:
        """
        @summary 获取外联风险趋势图
        
        @param request: DescribeOutgoingRiskTrendRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeOutgoingRiskTrendResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeOutgoingRiskTrend',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeOutgoingRiskTrendResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_outgoing_risk_trend(
        self,
        request: cloudfw_20171207_models.DescribeOutgoingRiskTrendRequest,
    ) -> cloudfw_20171207_models.DescribeOutgoingRiskTrendResponse:
        """
        @summary 获取外联风险趋势图
        
        @param request: DescribeOutgoingRiskTrendRequest
        @return: DescribeOutgoingRiskTrendResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_outgoing_risk_trend_with_options(request, runtime)

    async def describe_outgoing_risk_trend_async(
        self,
        request: cloudfw_20171207_models.DescribeOutgoingRiskTrendRequest,
    ) -> cloudfw_20171207_models.DescribeOutgoingRiskTrendResponse:
        """
        @summary 获取外联风险趋势图
        
        @param request: DescribeOutgoingRiskTrendRequest
        @return: DescribeOutgoingRiskTrendResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_outgoing_risk_trend_with_options_async(request, runtime)

    def describe_outgoing_statistic_with_options(
        self,
        request: cloudfw_20171207_models.DescribeOutgoingStatisticRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeOutgoingStatisticResponse:
        """
        @summary 获取外联统计
        
        @param request: DescribeOutgoingStatisticRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeOutgoingStatisticResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeOutgoingStatistic',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeOutgoingStatisticResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_outgoing_statistic_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeOutgoingStatisticRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeOutgoingStatisticResponse:
        """
        @summary 获取外联统计
        
        @param request: DescribeOutgoingStatisticRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeOutgoingStatisticResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeOutgoingStatistic',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeOutgoingStatisticResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_outgoing_statistic(
        self,
        request: cloudfw_20171207_models.DescribeOutgoingStatisticRequest,
    ) -> cloudfw_20171207_models.DescribeOutgoingStatisticResponse:
        """
        @summary 获取外联统计
        
        @param request: DescribeOutgoingStatisticRequest
        @return: DescribeOutgoingStatisticResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_outgoing_statistic_with_options(request, runtime)

    async def describe_outgoing_statistic_async(
        self,
        request: cloudfw_20171207_models.DescribeOutgoingStatisticRequest,
    ) -> cloudfw_20171207_models.DescribeOutgoingStatisticResponse:
        """
        @summary 获取外联统计
        
        @param request: DescribeOutgoingStatisticRequest
        @return: DescribeOutgoingStatisticResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_outgoing_statistic_with_options_async(request, runtime)

    def describe_outgoing_tag_with_options(
        self,
        request: cloudfw_20171207_models.DescribeOutgoingTagRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeOutgoingTagResponse:
        """
        @summary 获取外联标签
        
        @param request: DescribeOutgoingTagRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeOutgoingTagResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dst_type):
            query['DstType'] = request.dst_type
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.tag_id):
            query['TagId'] = request.tag_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeOutgoingTag',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeOutgoingTagResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_outgoing_tag_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeOutgoingTagRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeOutgoingTagResponse:
        """
        @summary 获取外联标签
        
        @param request: DescribeOutgoingTagRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeOutgoingTagResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dst_type):
            query['DstType'] = request.dst_type
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.tag_id):
            query['TagId'] = request.tag_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeOutgoingTag',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeOutgoingTagResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_outgoing_tag(
        self,
        request: cloudfw_20171207_models.DescribeOutgoingTagRequest,
    ) -> cloudfw_20171207_models.DescribeOutgoingTagResponse:
        """
        @summary 获取外联标签
        
        @param request: DescribeOutgoingTagRequest
        @return: DescribeOutgoingTagResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_outgoing_tag_with_options(request, runtime)

    async def describe_outgoing_tag_async(
        self,
        request: cloudfw_20171207_models.DescribeOutgoingTagRequest,
    ) -> cloudfw_20171207_models.DescribeOutgoingTagResponse:
        """
        @summary 获取外联标签
        
        @param request: DescribeOutgoingTagRequest
        @return: DescribeOutgoingTagResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_outgoing_tag_with_options_async(request, runtime)

    def describe_page_documents_with_options(
        self,
        request: cloudfw_20171207_models.DescribePageDocumentsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribePageDocumentsResponse:
        """
        @deprecated OpenAPI DescribePageDocuments is deprecated
        
        @summary 获取文档
        
        @param request: DescribePageDocumentsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribePageDocumentsResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_name):
            query['PageName'] = request.page_name
        if not UtilClient.is_unset(request.source_code):
            query['SourceCode'] = request.source_code
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.tab_name):
            query['TabName'] = request.tab_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePageDocuments',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribePageDocumentsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_page_documents_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribePageDocumentsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribePageDocumentsResponse:
        """
        @deprecated OpenAPI DescribePageDocuments is deprecated
        
        @summary 获取文档
        
        @param request: DescribePageDocumentsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribePageDocumentsResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_name):
            query['PageName'] = request.page_name
        if not UtilClient.is_unset(request.source_code):
            query['SourceCode'] = request.source_code
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.tab_name):
            query['TabName'] = request.tab_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePageDocuments',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribePageDocumentsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_page_documents(
        self,
        request: cloudfw_20171207_models.DescribePageDocumentsRequest,
    ) -> cloudfw_20171207_models.DescribePageDocumentsResponse:
        """
        @deprecated OpenAPI DescribePageDocuments is deprecated
        
        @summary 获取文档
        
        @param request: DescribePageDocumentsRequest
        @return: DescribePageDocumentsResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_page_documents_with_options(request, runtime)

    async def describe_page_documents_async(
        self,
        request: cloudfw_20171207_models.DescribePageDocumentsRequest,
    ) -> cloudfw_20171207_models.DescribePageDocumentsResponse:
        """
        @deprecated OpenAPI DescribePageDocuments is deprecated
        
        @summary 获取文档
        
        @param request: DescribePageDocumentsRequest
        @return: DescribePageDocumentsResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_page_documents_with_options_async(request, runtime)

    def describe_policy_advanced_config_with_options(
        self,
        request: cloudfw_20171207_models.DescribePolicyAdvancedConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribePolicyAdvancedConfigResponse:
        """
        @summary Queries whether the strict mode is enabled for an access control policy.
        
        @description You can call the DescribePolicyAdvancedConfig operation to query whether the strict mode is enabled for an access control policy.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribePolicyAdvancedConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribePolicyAdvancedConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePolicyAdvancedConfig',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribePolicyAdvancedConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_policy_advanced_config_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribePolicyAdvancedConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribePolicyAdvancedConfigResponse:
        """
        @summary Queries whether the strict mode is enabled for an access control policy.
        
        @description You can call the DescribePolicyAdvancedConfig operation to query whether the strict mode is enabled for an access control policy.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribePolicyAdvancedConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribePolicyAdvancedConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePolicyAdvancedConfig',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribePolicyAdvancedConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_policy_advanced_config(
        self,
        request: cloudfw_20171207_models.DescribePolicyAdvancedConfigRequest,
    ) -> cloudfw_20171207_models.DescribePolicyAdvancedConfigResponse:
        """
        @summary Queries whether the strict mode is enabled for an access control policy.
        
        @description You can call the DescribePolicyAdvancedConfig operation to query whether the strict mode is enabled for an access control policy.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribePolicyAdvancedConfigRequest
        @return: DescribePolicyAdvancedConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_policy_advanced_config_with_options(request, runtime)

    async def describe_policy_advanced_config_async(
        self,
        request: cloudfw_20171207_models.DescribePolicyAdvancedConfigRequest,
    ) -> cloudfw_20171207_models.DescribePolicyAdvancedConfigResponse:
        """
        @summary Queries whether the strict mode is enabled for an access control policy.
        
        @description You can call the DescribePolicyAdvancedConfig operation to query whether the strict mode is enabled for an access control policy.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribePolicyAdvancedConfigRequest
        @return: DescribePolicyAdvancedConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_policy_advanced_config_with_options_async(request, runtime)

    def describe_policy_prior_used_with_options(
        self,
        request: cloudfw_20171207_models.DescribePolicyPriorUsedRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribePolicyPriorUsedResponse:
        """
        @summary Queries the priority range of access control policies.
        
        @description You can call this operation to query the priority range of the access control policies that match specific query conditions.
        ## [](#qps-)Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribePolicyPriorUsedRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribePolicyPriorUsedResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.direction):
            query['Direction'] = request.direction
        if not UtilClient.is_unset(request.ip_version):
            query['IpVersion'] = request.ip_version
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePolicyPriorUsed',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribePolicyPriorUsedResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_policy_prior_used_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribePolicyPriorUsedRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribePolicyPriorUsedResponse:
        """
        @summary Queries the priority range of access control policies.
        
        @description You can call this operation to query the priority range of the access control policies that match specific query conditions.
        ## [](#qps-)Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribePolicyPriorUsedRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribePolicyPriorUsedResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.direction):
            query['Direction'] = request.direction
        if not UtilClient.is_unset(request.ip_version):
            query['IpVersion'] = request.ip_version
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePolicyPriorUsed',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribePolicyPriorUsedResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_policy_prior_used(
        self,
        request: cloudfw_20171207_models.DescribePolicyPriorUsedRequest,
    ) -> cloudfw_20171207_models.DescribePolicyPriorUsedResponse:
        """
        @summary Queries the priority range of access control policies.
        
        @description You can call this operation to query the priority range of the access control policies that match specific query conditions.
        ## [](#qps-)Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribePolicyPriorUsedRequest
        @return: DescribePolicyPriorUsedResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_policy_prior_used_with_options(request, runtime)

    async def describe_policy_prior_used_async(
        self,
        request: cloudfw_20171207_models.DescribePolicyPriorUsedRequest,
    ) -> cloudfw_20171207_models.DescribePolicyPriorUsedResponse:
        """
        @summary Queries the priority range of access control policies.
        
        @description You can call this operation to query the priority range of the access control policies that match specific query conditions.
        ## [](#qps-)Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribePolicyPriorUsedRequest
        @return: DescribePolicyPriorUsedResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_policy_prior_used_with_options_async(request, runtime)

    def describe_postpay_enabled_protection_with_options(
        self,
        request: cloudfw_20171207_models.DescribePostpayEnabledProtectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribePostpayEnabledProtectionResponse:
        """
        @summary 按量付费是否开启过防护
        
        @param request: DescribePostpayEnabledProtectionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribePostpayEnabledProtectionResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePostpayEnabledProtection',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribePostpayEnabledProtectionResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_postpay_enabled_protection_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribePostpayEnabledProtectionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribePostpayEnabledProtectionResponse:
        """
        @summary 按量付费是否开启过防护
        
        @param request: DescribePostpayEnabledProtectionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribePostpayEnabledProtectionResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePostpayEnabledProtection',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribePostpayEnabledProtectionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_postpay_enabled_protection(
        self,
        request: cloudfw_20171207_models.DescribePostpayEnabledProtectionRequest,
    ) -> cloudfw_20171207_models.DescribePostpayEnabledProtectionResponse:
        """
        @summary 按量付费是否开启过防护
        
        @param request: DescribePostpayEnabledProtectionRequest
        @return: DescribePostpayEnabledProtectionResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_postpay_enabled_protection_with_options(request, runtime)

    async def describe_postpay_enabled_protection_async(
        self,
        request: cloudfw_20171207_models.DescribePostpayEnabledProtectionRequest,
    ) -> cloudfw_20171207_models.DescribePostpayEnabledProtectionResponse:
        """
        @summary 按量付费是否开启过防护
        
        @param request: DescribePostpayEnabledProtectionRequest
        @return: DescribePostpayEnabledProtectionResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_postpay_enabled_protection_with_options_async(request, runtime)

    def describe_postpay_traffic_detail_with_options(
        self,
        request: cloudfw_20171207_models.DescribePostpayTrafficDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribePostpayTrafficDetailResponse:
        """
        @summary Queries the details of traffic billed based on the pay-as-you-go billing method.
        
        @description If you use Cloud Firewall that uses the pay-as-you-go billing method, you can call this operation to query traffic details accurate to the granularity of specific resource instances. If you use Cloud Firewall that uses the subscription billing method, you can call this operation to query the overall traffic details.
        
        @param request: DescribePostpayTrafficDetailRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribePostpayTrafficDetailResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.order):
            query['Order'] = request.order
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_no):
            query['RegionNo'] = request.region_no
        if not UtilClient.is_unset(request.search_item):
            query['SearchItem'] = request.search_item
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.traffic_type):
            query['TrafficType'] = request.traffic_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePostpayTrafficDetail',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribePostpayTrafficDetailResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_postpay_traffic_detail_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribePostpayTrafficDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribePostpayTrafficDetailResponse:
        """
        @summary Queries the details of traffic billed based on the pay-as-you-go billing method.
        
        @description If you use Cloud Firewall that uses the pay-as-you-go billing method, you can call this operation to query traffic details accurate to the granularity of specific resource instances. If you use Cloud Firewall that uses the subscription billing method, you can call this operation to query the overall traffic details.
        
        @param request: DescribePostpayTrafficDetailRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribePostpayTrafficDetailResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.order):
            query['Order'] = request.order
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_no):
            query['RegionNo'] = request.region_no
        if not UtilClient.is_unset(request.search_item):
            query['SearchItem'] = request.search_item
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.traffic_type):
            query['TrafficType'] = request.traffic_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePostpayTrafficDetail',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribePostpayTrafficDetailResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_postpay_traffic_detail(
        self,
        request: cloudfw_20171207_models.DescribePostpayTrafficDetailRequest,
    ) -> cloudfw_20171207_models.DescribePostpayTrafficDetailResponse:
        """
        @summary Queries the details of traffic billed based on the pay-as-you-go billing method.
        
        @description If you use Cloud Firewall that uses the pay-as-you-go billing method, you can call this operation to query traffic details accurate to the granularity of specific resource instances. If you use Cloud Firewall that uses the subscription billing method, you can call this operation to query the overall traffic details.
        
        @param request: DescribePostpayTrafficDetailRequest
        @return: DescribePostpayTrafficDetailResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_postpay_traffic_detail_with_options(request, runtime)

    async def describe_postpay_traffic_detail_async(
        self,
        request: cloudfw_20171207_models.DescribePostpayTrafficDetailRequest,
    ) -> cloudfw_20171207_models.DescribePostpayTrafficDetailResponse:
        """
        @summary Queries the details of traffic billed based on the pay-as-you-go billing method.
        
        @description If you use Cloud Firewall that uses the pay-as-you-go billing method, you can call this operation to query traffic details accurate to the granularity of specific resource instances. If you use Cloud Firewall that uses the subscription billing method, you can call this operation to query the overall traffic details.
        
        @param request: DescribePostpayTrafficDetailRequest
        @return: DescribePostpayTrafficDetailResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_postpay_traffic_detail_with_options_async(request, runtime)

    def describe_postpay_traffic_total_with_options(
        self,
        request: cloudfw_20171207_models.DescribePostpayTrafficTotalRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribePostpayTrafficTotalResponse:
        """
        @summary Queries the total volume of traffic that is billed based on the pay-as-you-go billing method, including all firewalls within the current account.
        
        @description You can call this operation to query statistics of the current Cloud Firewall from the date of purchase.
        
        @param request: DescribePostpayTrafficTotalRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribePostpayTrafficTotalResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePostpayTrafficTotal',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribePostpayTrafficTotalResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_postpay_traffic_total_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribePostpayTrafficTotalRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribePostpayTrafficTotalResponse:
        """
        @summary Queries the total volume of traffic that is billed based on the pay-as-you-go billing method, including all firewalls within the current account.
        
        @description You can call this operation to query statistics of the current Cloud Firewall from the date of purchase.
        
        @param request: DescribePostpayTrafficTotalRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribePostpayTrafficTotalResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePostpayTrafficTotal',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribePostpayTrafficTotalResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_postpay_traffic_total(
        self,
        request: cloudfw_20171207_models.DescribePostpayTrafficTotalRequest,
    ) -> cloudfw_20171207_models.DescribePostpayTrafficTotalResponse:
        """
        @summary Queries the total volume of traffic that is billed based on the pay-as-you-go billing method, including all firewalls within the current account.
        
        @description You can call this operation to query statistics of the current Cloud Firewall from the date of purchase.
        
        @param request: DescribePostpayTrafficTotalRequest
        @return: DescribePostpayTrafficTotalResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_postpay_traffic_total_with_options(request, runtime)

    async def describe_postpay_traffic_total_async(
        self,
        request: cloudfw_20171207_models.DescribePostpayTrafficTotalRequest,
    ) -> cloudfw_20171207_models.DescribePostpayTrafficTotalResponse:
        """
        @summary Queries the total volume of traffic that is billed based on the pay-as-you-go billing method, including all firewalls within the current account.
        
        @description You can call this operation to query statistics of the current Cloud Firewall from the date of purchase.
        
        @param request: DescribePostpayTrafficTotalRequest
        @return: DescribePostpayTrafficTotalResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_postpay_traffic_total_with_options_async(request, runtime)

    def describe_postpay_user_internet_status_with_options(
        self,
        request: cloudfw_20171207_models.DescribePostpayUserInternetStatusRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribePostpayUserInternetStatusResponse:
        """
        @summary Queries the status of the Internet Firewall feature in Cloud Firewall that uses the pay-as-you-go billing method.
        
        @param request: DescribePostpayUserInternetStatusRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribePostpayUserInternetStatusResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePostpayUserInternetStatus',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribePostpayUserInternetStatusResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_postpay_user_internet_status_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribePostpayUserInternetStatusRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribePostpayUserInternetStatusResponse:
        """
        @summary Queries the status of the Internet Firewall feature in Cloud Firewall that uses the pay-as-you-go billing method.
        
        @param request: DescribePostpayUserInternetStatusRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribePostpayUserInternetStatusResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePostpayUserInternetStatus',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribePostpayUserInternetStatusResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_postpay_user_internet_status(
        self,
        request: cloudfw_20171207_models.DescribePostpayUserInternetStatusRequest,
    ) -> cloudfw_20171207_models.DescribePostpayUserInternetStatusResponse:
        """
        @summary Queries the status of the Internet Firewall feature in Cloud Firewall that uses the pay-as-you-go billing method.
        
        @param request: DescribePostpayUserInternetStatusRequest
        @return: DescribePostpayUserInternetStatusResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_postpay_user_internet_status_with_options(request, runtime)

    async def describe_postpay_user_internet_status_async(
        self,
        request: cloudfw_20171207_models.DescribePostpayUserInternetStatusRequest,
    ) -> cloudfw_20171207_models.DescribePostpayUserInternetStatusResponse:
        """
        @summary Queries the status of the Internet Firewall feature in Cloud Firewall that uses the pay-as-you-go billing method.
        
        @param request: DescribePostpayUserInternetStatusRequest
        @return: DescribePostpayUserInternetStatusResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_postpay_user_internet_status_with_options_async(request, runtime)

    def describe_postpay_user_nat_status_with_options(
        self,
        request: cloudfw_20171207_models.DescribePostpayUserNatStatusRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribePostpayUserNatStatusResponse:
        """
        @summary Queries the status of the NAT Firewall feature in Cloud Firewall that use the pay-as-you-go billing method.
        
        @param request: DescribePostpayUserNatStatusRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribePostpayUserNatStatusResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePostpayUserNatStatus',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribePostpayUserNatStatusResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_postpay_user_nat_status_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribePostpayUserNatStatusRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribePostpayUserNatStatusResponse:
        """
        @summary Queries the status of the NAT Firewall feature in Cloud Firewall that use the pay-as-you-go billing method.
        
        @param request: DescribePostpayUserNatStatusRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribePostpayUserNatStatusResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePostpayUserNatStatus',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribePostpayUserNatStatusResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_postpay_user_nat_status(
        self,
        request: cloudfw_20171207_models.DescribePostpayUserNatStatusRequest,
    ) -> cloudfw_20171207_models.DescribePostpayUserNatStatusResponse:
        """
        @summary Queries the status of the NAT Firewall feature in Cloud Firewall that use the pay-as-you-go billing method.
        
        @param request: DescribePostpayUserNatStatusRequest
        @return: DescribePostpayUserNatStatusResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_postpay_user_nat_status_with_options(request, runtime)

    async def describe_postpay_user_nat_status_async(
        self,
        request: cloudfw_20171207_models.DescribePostpayUserNatStatusRequest,
    ) -> cloudfw_20171207_models.DescribePostpayUserNatStatusResponse:
        """
        @summary Queries the status of the NAT Firewall feature in Cloud Firewall that use the pay-as-you-go billing method.
        
        @param request: DescribePostpayUserNatStatusRequest
        @return: DescribePostpayUserNatStatusResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_postpay_user_nat_status_with_options_async(request, runtime)

    def describe_postpay_user_vpc_status_with_options(
        self,
        request: cloudfw_20171207_models.DescribePostpayUserVpcStatusRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribePostpayUserVpcStatusResponse:
        """
        @summary Queries the status of the virtual private cloud (VPC) Firewall feature in Cloud Firewall that uses the pay-as-you-go billing method.
        
        @param request: DescribePostpayUserVpcStatusRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribePostpayUserVpcStatusResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePostpayUserVpcStatus',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribePostpayUserVpcStatusResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_postpay_user_vpc_status_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribePostpayUserVpcStatusRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribePostpayUserVpcStatusResponse:
        """
        @summary Queries the status of the virtual private cloud (VPC) Firewall feature in Cloud Firewall that uses the pay-as-you-go billing method.
        
        @param request: DescribePostpayUserVpcStatusRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribePostpayUserVpcStatusResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePostpayUserVpcStatus',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribePostpayUserVpcStatusResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_postpay_user_vpc_status(
        self,
        request: cloudfw_20171207_models.DescribePostpayUserVpcStatusRequest,
    ) -> cloudfw_20171207_models.DescribePostpayUserVpcStatusResponse:
        """
        @summary Queries the status of the virtual private cloud (VPC) Firewall feature in Cloud Firewall that uses the pay-as-you-go billing method.
        
        @param request: DescribePostpayUserVpcStatusRequest
        @return: DescribePostpayUserVpcStatusResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_postpay_user_vpc_status_with_options(request, runtime)

    async def describe_postpay_user_vpc_status_async(
        self,
        request: cloudfw_20171207_models.DescribePostpayUserVpcStatusRequest,
    ) -> cloudfw_20171207_models.DescribePostpayUserVpcStatusResponse:
        """
        @summary Queries the status of the virtual private cloud (VPC) Firewall feature in Cloud Firewall that uses the pay-as-you-go billing method.
        
        @param request: DescribePostpayUserVpcStatusRequest
        @return: DescribePostpayUserVpcStatusResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_postpay_user_vpc_status_with_options_async(request, runtime)

    def describe_prefix_lists_with_options(
        self,
        request: cloudfw_20171207_models.DescribePrefixListsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribePrefixListsResponse:
        """
        @summary Queries prefix lists.
        
        @param request: DescribePrefixListsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribePrefixListsResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePrefixLists',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribePrefixListsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_prefix_lists_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribePrefixListsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribePrefixListsResponse:
        """
        @summary Queries prefix lists.
        
        @param request: DescribePrefixListsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribePrefixListsResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePrefixLists',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribePrefixListsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_prefix_lists(
        self,
        request: cloudfw_20171207_models.DescribePrefixListsRequest,
    ) -> cloudfw_20171207_models.DescribePrefixListsResponse:
        """
        @summary Queries prefix lists.
        
        @param request: DescribePrefixListsRequest
        @return: DescribePrefixListsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_prefix_lists_with_options(request, runtime)

    async def describe_prefix_lists_async(
        self,
        request: cloudfw_20171207_models.DescribePrefixListsRequest,
    ) -> cloudfw_20171207_models.DescribePrefixListsResponse:
        """
        @summary Queries prefix lists.
        
        @param request: DescribePrefixListsRequest
        @return: DescribePrefixListsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_prefix_lists_with_options_async(request, runtime)

    def describe_private_dns_domain_name_list_with_options(
        self,
        request: cloudfw_20171207_models.DescribePrivateDnsDomainNameListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribePrivateDnsDomainNameListResponse:
        """
        @summary 查询私网DNS域名列表
        
        @param request: DescribePrivateDnsDomainNameListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribePrivateDnsDomainNameListResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePrivateDnsDomainNameList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribePrivateDnsDomainNameListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_private_dns_domain_name_list_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribePrivateDnsDomainNameListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribePrivateDnsDomainNameListResponse:
        """
        @summary 查询私网DNS域名列表
        
        @param request: DescribePrivateDnsDomainNameListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribePrivateDnsDomainNameListResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePrivateDnsDomainNameList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribePrivateDnsDomainNameListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_private_dns_domain_name_list(
        self,
        request: cloudfw_20171207_models.DescribePrivateDnsDomainNameListRequest,
    ) -> cloudfw_20171207_models.DescribePrivateDnsDomainNameListResponse:
        """
        @summary 查询私网DNS域名列表
        
        @param request: DescribePrivateDnsDomainNameListRequest
        @return: DescribePrivateDnsDomainNameListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_private_dns_domain_name_list_with_options(request, runtime)

    async def describe_private_dns_domain_name_list_async(
        self,
        request: cloudfw_20171207_models.DescribePrivateDnsDomainNameListRequest,
    ) -> cloudfw_20171207_models.DescribePrivateDnsDomainNameListResponse:
        """
        @summary 查询私网DNS域名列表
        
        @param request: DescribePrivateDnsDomainNameListRequest
        @return: DescribePrivateDnsDomainNameListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_private_dns_domain_name_list_with_options_async(request, runtime)

    def describe_private_dns_endpoint_detail_with_options(
        self,
        request: cloudfw_20171207_models.DescribePrivateDnsEndpointDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribePrivateDnsEndpointDetailResponse:
        """
        @summary 查询私网DNS终端节点详情
        
        @param request: DescribePrivateDnsEndpointDetailRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribePrivateDnsEndpointDetailResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePrivateDnsEndpointDetail',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribePrivateDnsEndpointDetailResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_private_dns_endpoint_detail_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribePrivateDnsEndpointDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribePrivateDnsEndpointDetailResponse:
        """
        @summary 查询私网DNS终端节点详情
        
        @param request: DescribePrivateDnsEndpointDetailRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribePrivateDnsEndpointDetailResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePrivateDnsEndpointDetail',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribePrivateDnsEndpointDetailResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_private_dns_endpoint_detail(
        self,
        request: cloudfw_20171207_models.DescribePrivateDnsEndpointDetailRequest,
    ) -> cloudfw_20171207_models.DescribePrivateDnsEndpointDetailResponse:
        """
        @summary 查询私网DNS终端节点详情
        
        @param request: DescribePrivateDnsEndpointDetailRequest
        @return: DescribePrivateDnsEndpointDetailResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_private_dns_endpoint_detail_with_options(request, runtime)

    async def describe_private_dns_endpoint_detail_async(
        self,
        request: cloudfw_20171207_models.DescribePrivateDnsEndpointDetailRequest,
    ) -> cloudfw_20171207_models.DescribePrivateDnsEndpointDetailResponse:
        """
        @summary 查询私网DNS终端节点详情
        
        @param request: DescribePrivateDnsEndpointDetailRequest
        @return: DescribePrivateDnsEndpointDetailResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_private_dns_endpoint_detail_with_options_async(request, runtime)

    def describe_private_dns_endpoint_list_with_options(
        self,
        request: cloudfw_20171207_models.DescribePrivateDnsEndpointListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribePrivateDnsEndpointListResponse:
        """
        @summary 查询私网DNS终端节点列表
        
        @param request: DescribePrivateDnsEndpointListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribePrivateDnsEndpointListResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePrivateDnsEndpointList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribePrivateDnsEndpointListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_private_dns_endpoint_list_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribePrivateDnsEndpointListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribePrivateDnsEndpointListResponse:
        """
        @summary 查询私网DNS终端节点列表
        
        @param request: DescribePrivateDnsEndpointListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribePrivateDnsEndpointListResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePrivateDnsEndpointList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribePrivateDnsEndpointListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_private_dns_endpoint_list(
        self,
        request: cloudfw_20171207_models.DescribePrivateDnsEndpointListRequest,
    ) -> cloudfw_20171207_models.DescribePrivateDnsEndpointListResponse:
        """
        @summary 查询私网DNS终端节点列表
        
        @param request: DescribePrivateDnsEndpointListRequest
        @return: DescribePrivateDnsEndpointListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_private_dns_endpoint_list_with_options(request, runtime)

    async def describe_private_dns_endpoint_list_async(
        self,
        request: cloudfw_20171207_models.DescribePrivateDnsEndpointListRequest,
    ) -> cloudfw_20171207_models.DescribePrivateDnsEndpointListResponse:
        """
        @summary 查询私网DNS终端节点列表
        
        @param request: DescribePrivateDnsEndpointListRequest
        @return: DescribePrivateDnsEndpointListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_private_dns_endpoint_list_with_options_async(request, runtime)

    def describe_private_dns_statistics_with_options(
        self,
        request: cloudfw_20171207_models.DescribePrivateDnsStatisticsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribePrivateDnsStatisticsResponse:
        """
        @summary 查询私有DNS的统计信息
        
        @param request: DescribePrivateDnsStatisticsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribePrivateDnsStatisticsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.domain_name_created_end_time):
            query['DomainNameCreatedEndTime'] = request.domain_name_created_end_time
        if not UtilClient.is_unset(request.domain_name_created_start_time):
            query['DomainNameCreatedStartTime'] = request.domain_name_created_start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePrivateDnsStatistics',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribePrivateDnsStatisticsResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_private_dns_statistics_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribePrivateDnsStatisticsRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribePrivateDnsStatisticsResponse:
        """
        @summary 查询私有DNS的统计信息
        
        @param request: DescribePrivateDnsStatisticsRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribePrivateDnsStatisticsResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.domain_name_created_end_time):
            query['DomainNameCreatedEndTime'] = request.domain_name_created_end_time
        if not UtilClient.is_unset(request.domain_name_created_start_time):
            query['DomainNameCreatedStartTime'] = request.domain_name_created_start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribePrivateDnsStatistics',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribePrivateDnsStatisticsResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_private_dns_statistics(
        self,
        request: cloudfw_20171207_models.DescribePrivateDnsStatisticsRequest,
    ) -> cloudfw_20171207_models.DescribePrivateDnsStatisticsResponse:
        """
        @summary 查询私有DNS的统计信息
        
        @param request: DescribePrivateDnsStatisticsRequest
        @return: DescribePrivateDnsStatisticsResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_private_dns_statistics_with_options(request, runtime)

    async def describe_private_dns_statistics_async(
        self,
        request: cloudfw_20171207_models.DescribePrivateDnsStatisticsRequest,
    ) -> cloudfw_20171207_models.DescribePrivateDnsStatisticsResponse:
        """
        @summary 查询私有DNS的统计信息
        
        @param request: DescribePrivateDnsStatisticsRequest
        @return: DescribePrivateDnsStatisticsResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_private_dns_statistics_with_options_async(request, runtime)

    def describe_region_info_with_options(
        self,
        request: cloudfw_20171207_models.DescribeRegionInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeRegionInfoResponse:
        """
        @summary 获取地域信息
        
        @param request: DescribeRegionInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRegionInfoResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_code):
            query['SourceCode'] = request.source_code
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRegionInfo',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeRegionInfoResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_region_info_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeRegionInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeRegionInfoResponse:
        """
        @summary 获取地域信息
        
        @param request: DescribeRegionInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRegionInfoResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_code):
            query['SourceCode'] = request.source_code
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRegionInfo',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeRegionInfoResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_region_info(
        self,
        request: cloudfw_20171207_models.DescribeRegionInfoRequest,
    ) -> cloudfw_20171207_models.DescribeRegionInfoResponse:
        """
        @summary 获取地域信息
        
        @param request: DescribeRegionInfoRequest
        @return: DescribeRegionInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_region_info_with_options(request, runtime)

    async def describe_region_info_async(
        self,
        request: cloudfw_20171207_models.DescribeRegionInfoRequest,
    ) -> cloudfw_20171207_models.DescribeRegionInfoResponse:
        """
        @summary 获取地域信息
        
        @param request: DescribeRegionInfoRequest
        @return: DescribeRegionInfoResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_region_info_with_options_async(request, runtime)

    def describe_resource_type_auto_enable_with_options(
        self,
        request: cloudfw_20171207_models.DescribeResourceTypeAutoEnableRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeResourceTypeAutoEnableResponse:
        """
        @summary 查询资产类型默认引流
        
        @param request: DescribeResourceTypeAutoEnableRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeResourceTypeAutoEnableResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeResourceTypeAutoEnable',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeResourceTypeAutoEnableResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_resource_type_auto_enable_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeResourceTypeAutoEnableRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeResourceTypeAutoEnableResponse:
        """
        @summary 查询资产类型默认引流
        
        @param request: DescribeResourceTypeAutoEnableRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeResourceTypeAutoEnableResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeResourceTypeAutoEnable',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeResourceTypeAutoEnableResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_resource_type_auto_enable(
        self,
        request: cloudfw_20171207_models.DescribeResourceTypeAutoEnableRequest,
    ) -> cloudfw_20171207_models.DescribeResourceTypeAutoEnableResponse:
        """
        @summary 查询资产类型默认引流
        
        @param request: DescribeResourceTypeAutoEnableRequest
        @return: DescribeResourceTypeAutoEnableResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_resource_type_auto_enable_with_options(request, runtime)

    async def describe_resource_type_auto_enable_async(
        self,
        request: cloudfw_20171207_models.DescribeResourceTypeAutoEnableRequest,
    ) -> cloudfw_20171207_models.DescribeResourceTypeAutoEnableResponse:
        """
        @summary 查询资产类型默认引流
        
        @param request: DescribeResourceTypeAutoEnableRequest
        @return: DescribeResourceTypeAutoEnableResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_resource_type_auto_enable_with_options_async(request, runtime)

    def describe_risk_event_group_with_options(
        self,
        request: cloudfw_20171207_models.DescribeRiskEventGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeRiskEventGroupResponse:
        """
        @summary Queries the details of intrusion events.
        
        @description You can call the DescribeRiskEventGroup operation to query and download the details of intrusion events. We recommend that you query the details of 5 to 10 intrusion events at a time. If you do not need to query the geographical information about IP addresses, you can set the NoLocation parameter to true to prevent query timeout.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeRiskEventGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRiskEventGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.attack_app):
            query['AttackApp'] = request.attack_app
        if not UtilClient.is_unset(request.attack_app_category):
            query['AttackAppCategory'] = request.attack_app_category
        if not UtilClient.is_unset(request.attack_type):
            query['AttackType'] = request.attack_type
        if not UtilClient.is_unset(request.buy_version):
            query['BuyVersion'] = request.buy_version
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.data_type):
            query['DataType'] = request.data_type
        if not UtilClient.is_unset(request.direction):
            query['Direction'] = request.direction
        if not UtilClient.is_unset(request.dst_ip):
            query['DstIP'] = request.dst_ip
        if not UtilClient.is_unset(request.dst_network_instance_id):
            query['DstNetworkInstanceId'] = request.dst_network_instance_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.event_name):
            query['EventName'] = request.event_name
        if not UtilClient.is_unset(request.firewall_type):
            query['FirewallType'] = request.firewall_type
        if not UtilClient.is_unset(request.is_only_private_assoc):
            query['IsOnlyPrivateAssoc'] = request.is_only_private_assoc
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.no_location):
            query['NoLocation'] = request.no_location
        if not UtilClient.is_unset(request.order):
            query['Order'] = request.order
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.rule_result):
            query['RuleResult'] = request.rule_result
        if not UtilClient.is_unset(request.rule_source):
            query['RuleSource'] = request.rule_source
        if not UtilClient.is_unset(request.sort):
            query['Sort'] = request.sort
        if not UtilClient.is_unset(request.src_ip):
            query['SrcIP'] = request.src_ip
        if not UtilClient.is_unset(request.src_network_instance_id):
            query['SrcNetworkInstanceId'] = request.src_network_instance_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.vul_level):
            query['VulLevel'] = request.vul_level
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRiskEventGroup',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeRiskEventGroupResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_risk_event_group_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeRiskEventGroupRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeRiskEventGroupResponse:
        """
        @summary Queries the details of intrusion events.
        
        @description You can call the DescribeRiskEventGroup operation to query and download the details of intrusion events. We recommend that you query the details of 5 to 10 intrusion events at a time. If you do not need to query the geographical information about IP addresses, you can set the NoLocation parameter to true to prevent query timeout.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeRiskEventGroupRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRiskEventGroupResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.attack_app):
            query['AttackApp'] = request.attack_app
        if not UtilClient.is_unset(request.attack_app_category):
            query['AttackAppCategory'] = request.attack_app_category
        if not UtilClient.is_unset(request.attack_type):
            query['AttackType'] = request.attack_type
        if not UtilClient.is_unset(request.buy_version):
            query['BuyVersion'] = request.buy_version
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.data_type):
            query['DataType'] = request.data_type
        if not UtilClient.is_unset(request.direction):
            query['Direction'] = request.direction
        if not UtilClient.is_unset(request.dst_ip):
            query['DstIP'] = request.dst_ip
        if not UtilClient.is_unset(request.dst_network_instance_id):
            query['DstNetworkInstanceId'] = request.dst_network_instance_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.event_name):
            query['EventName'] = request.event_name
        if not UtilClient.is_unset(request.firewall_type):
            query['FirewallType'] = request.firewall_type
        if not UtilClient.is_unset(request.is_only_private_assoc):
            query['IsOnlyPrivateAssoc'] = request.is_only_private_assoc
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.no_location):
            query['NoLocation'] = request.no_location
        if not UtilClient.is_unset(request.order):
            query['Order'] = request.order
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.rule_result):
            query['RuleResult'] = request.rule_result
        if not UtilClient.is_unset(request.rule_source):
            query['RuleSource'] = request.rule_source
        if not UtilClient.is_unset(request.sort):
            query['Sort'] = request.sort
        if not UtilClient.is_unset(request.src_ip):
            query['SrcIP'] = request.src_ip
        if not UtilClient.is_unset(request.src_network_instance_id):
            query['SrcNetworkInstanceId'] = request.src_network_instance_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.vul_level):
            query['VulLevel'] = request.vul_level
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRiskEventGroup',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeRiskEventGroupResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_risk_event_group(
        self,
        request: cloudfw_20171207_models.DescribeRiskEventGroupRequest,
    ) -> cloudfw_20171207_models.DescribeRiskEventGroupResponse:
        """
        @summary Queries the details of intrusion events.
        
        @description You can call the DescribeRiskEventGroup operation to query and download the details of intrusion events. We recommend that you query the details of 5 to 10 intrusion events at a time. If you do not need to query the geographical information about IP addresses, you can set the NoLocation parameter to true to prevent query timeout.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeRiskEventGroupRequest
        @return: DescribeRiskEventGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_risk_event_group_with_options(request, runtime)

    async def describe_risk_event_group_async(
        self,
        request: cloudfw_20171207_models.DescribeRiskEventGroupRequest,
    ) -> cloudfw_20171207_models.DescribeRiskEventGroupResponse:
        """
        @summary Queries the details of intrusion events.
        
        @description You can call the DescribeRiskEventGroup operation to query and download the details of intrusion events. We recommend that you query the details of 5 to 10 intrusion events at a time. If you do not need to query the geographical information about IP addresses, you can set the NoLocation parameter to true to prevent query timeout.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeRiskEventGroupRequest
        @return: DescribeRiskEventGroupResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_risk_event_group_with_options_async(request, runtime)

    def describe_risk_event_payload_with_options(
        self,
        request: cloudfw_20171207_models.DescribeRiskEventPayloadRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeRiskEventPayloadResponse:
        """
        @summary Queries the attack payloads of intrusion events.
        
        @param request: DescribeRiskEventPayloadRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRiskEventPayloadResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dst_ip):
            query['DstIP'] = request.dst_ip
        if not UtilClient.is_unset(request.dst_vpc_id):
            query['DstVpcId'] = request.dst_vpc_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.firewall_type):
            query['FirewallType'] = request.firewall_type
        if not UtilClient.is_unset(request.public_ip):
            query['PublicIP'] = request.public_ip
        if not UtilClient.is_unset(request.src_ip):
            query['SrcIP'] = request.src_ip
        if not UtilClient.is_unset(request.src_vpc_id):
            query['SrcVpcId'] = request.src_vpc_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.uuid):
            query['UUID'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRiskEventPayload',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeRiskEventPayloadResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_risk_event_payload_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeRiskEventPayloadRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeRiskEventPayloadResponse:
        """
        @summary Queries the attack payloads of intrusion events.
        
        @param request: DescribeRiskEventPayloadRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRiskEventPayloadResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.dst_ip):
            query['DstIP'] = request.dst_ip
        if not UtilClient.is_unset(request.dst_vpc_id):
            query['DstVpcId'] = request.dst_vpc_id
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.firewall_type):
            query['FirewallType'] = request.firewall_type
        if not UtilClient.is_unset(request.public_ip):
            query['PublicIP'] = request.public_ip
        if not UtilClient.is_unset(request.src_ip):
            query['SrcIP'] = request.src_ip
        if not UtilClient.is_unset(request.src_vpc_id):
            query['SrcVpcId'] = request.src_vpc_id
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.uuid):
            query['UUID'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRiskEventPayload',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeRiskEventPayloadResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_risk_event_payload(
        self,
        request: cloudfw_20171207_models.DescribeRiskEventPayloadRequest,
    ) -> cloudfw_20171207_models.DescribeRiskEventPayloadResponse:
        """
        @summary Queries the attack payloads of intrusion events.
        
        @param request: DescribeRiskEventPayloadRequest
        @return: DescribeRiskEventPayloadResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_risk_event_payload_with_options(request, runtime)

    async def describe_risk_event_payload_async(
        self,
        request: cloudfw_20171207_models.DescribeRiskEventPayloadRequest,
    ) -> cloudfw_20171207_models.DescribeRiskEventPayloadResponse:
        """
        @summary Queries the attack payloads of intrusion events.
        
        @param request: DescribeRiskEventPayloadRequest
        @return: DescribeRiskEventPayloadResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_risk_event_payload_with_options_async(request, runtime)

    def describe_risk_event_statistic_with_options(
        self,
        request: cloudfw_20171207_models.DescribeRiskEventStatisticRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeRiskEventStatisticResponse:
        """
        @summary 获取风险事件统计
        
        @param request: DescribeRiskEventStatisticRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRiskEventStatisticResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.attack_app):
            query['AttackApp'] = request.attack_app
        if not UtilClient.is_unset(request.attack_type):
            query['AttackType'] = request.attack_type
        if not UtilClient.is_unset(request.buy_version):
            query['BuyVersion'] = request.buy_version
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRiskEventStatistic',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeRiskEventStatisticResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_risk_event_statistic_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeRiskEventStatisticRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeRiskEventStatisticResponse:
        """
        @summary 获取风险事件统计
        
        @param request: DescribeRiskEventStatisticRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRiskEventStatisticResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.attack_app):
            query['AttackApp'] = request.attack_app
        if not UtilClient.is_unset(request.attack_type):
            query['AttackType'] = request.attack_type
        if not UtilClient.is_unset(request.buy_version):
            query['BuyVersion'] = request.buy_version
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRiskEventStatistic',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeRiskEventStatisticResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_risk_event_statistic(
        self,
        request: cloudfw_20171207_models.DescribeRiskEventStatisticRequest,
    ) -> cloudfw_20171207_models.DescribeRiskEventStatisticResponse:
        """
        @summary 获取风险事件统计
        
        @param request: DescribeRiskEventStatisticRequest
        @return: DescribeRiskEventStatisticResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_risk_event_statistic_with_options(request, runtime)

    async def describe_risk_event_statistic_async(
        self,
        request: cloudfw_20171207_models.DescribeRiskEventStatisticRequest,
    ) -> cloudfw_20171207_models.DescribeRiskEventStatisticResponse:
        """
        @summary 获取风险事件统计
        
        @param request: DescribeRiskEventStatisticRequest
        @return: DescribeRiskEventStatisticResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_risk_event_statistic_with_options_async(request, runtime)

    def describe_risk_event_top_attack_app_with_options(
        self,
        request: cloudfw_20171207_models.DescribeRiskEventTopAttackAppRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeRiskEventTopAttackAppResponse:
        """
        @summary 获取Top风险事件攻击APP
        
        @param request: DescribeRiskEventTopAttackAppRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRiskEventTopAttackAppResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.attack_app):
            query['AttackApp'] = request.attack_app
        if not UtilClient.is_unset(request.attack_type):
            query['AttackType'] = request.attack_type
        if not UtilClient.is_unset(request.buy_version):
            query['BuyVersion'] = request.buy_version
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRiskEventTopAttackApp',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeRiskEventTopAttackAppResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_risk_event_top_attack_app_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeRiskEventTopAttackAppRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeRiskEventTopAttackAppResponse:
        """
        @summary 获取Top风险事件攻击APP
        
        @param request: DescribeRiskEventTopAttackAppRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRiskEventTopAttackAppResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.attack_app):
            query['AttackApp'] = request.attack_app
        if not UtilClient.is_unset(request.attack_type):
            query['AttackType'] = request.attack_type
        if not UtilClient.is_unset(request.buy_version):
            query['BuyVersion'] = request.buy_version
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRiskEventTopAttackApp',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeRiskEventTopAttackAppResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_risk_event_top_attack_app(
        self,
        request: cloudfw_20171207_models.DescribeRiskEventTopAttackAppRequest,
    ) -> cloudfw_20171207_models.DescribeRiskEventTopAttackAppResponse:
        """
        @summary 获取Top风险事件攻击APP
        
        @param request: DescribeRiskEventTopAttackAppRequest
        @return: DescribeRiskEventTopAttackAppResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_risk_event_top_attack_app_with_options(request, runtime)

    async def describe_risk_event_top_attack_app_async(
        self,
        request: cloudfw_20171207_models.DescribeRiskEventTopAttackAppRequest,
    ) -> cloudfw_20171207_models.DescribeRiskEventTopAttackAppResponse:
        """
        @summary 获取Top风险事件攻击APP
        
        @param request: DescribeRiskEventTopAttackAppRequest
        @return: DescribeRiskEventTopAttackAppResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_risk_event_top_attack_app_with_options_async(request, runtime)

    def describe_risk_event_top_attack_asset_with_options(
        self,
        request: cloudfw_20171207_models.DescribeRiskEventTopAttackAssetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeRiskEventTopAttackAssetResponse:
        """
        @summary 获取Top风险事件资产
        
        @param request: DescribeRiskEventTopAttackAssetRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRiskEventTopAttackAssetResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.attack_app):
            query['AttackApp'] = request.attack_app
        if not UtilClient.is_unset(request.attack_type):
            query['AttackType'] = request.attack_type
        if not UtilClient.is_unset(request.buy_version):
            query['BuyVersion'] = request.buy_version
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRiskEventTopAttackAsset',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeRiskEventTopAttackAssetResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_risk_event_top_attack_asset_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeRiskEventTopAttackAssetRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeRiskEventTopAttackAssetResponse:
        """
        @summary 获取Top风险事件资产
        
        @param request: DescribeRiskEventTopAttackAssetRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRiskEventTopAttackAssetResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.attack_app):
            query['AttackApp'] = request.attack_app
        if not UtilClient.is_unset(request.attack_type):
            query['AttackType'] = request.attack_type
        if not UtilClient.is_unset(request.buy_version):
            query['BuyVersion'] = request.buy_version
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRiskEventTopAttackAsset',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeRiskEventTopAttackAssetResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_risk_event_top_attack_asset(
        self,
        request: cloudfw_20171207_models.DescribeRiskEventTopAttackAssetRequest,
    ) -> cloudfw_20171207_models.DescribeRiskEventTopAttackAssetResponse:
        """
        @summary 获取Top风险事件资产
        
        @param request: DescribeRiskEventTopAttackAssetRequest
        @return: DescribeRiskEventTopAttackAssetResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_risk_event_top_attack_asset_with_options(request, runtime)

    async def describe_risk_event_top_attack_asset_async(
        self,
        request: cloudfw_20171207_models.DescribeRiskEventTopAttackAssetRequest,
    ) -> cloudfw_20171207_models.DescribeRiskEventTopAttackAssetResponse:
        """
        @summary 获取Top风险事件资产
        
        @param request: DescribeRiskEventTopAttackAssetRequest
        @return: DescribeRiskEventTopAttackAssetResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_risk_event_top_attack_asset_with_options_async(request, runtime)

    def describe_risk_event_top_attack_type_with_options(
        self,
        request: cloudfw_20171207_models.DescribeRiskEventTopAttackTypeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeRiskEventTopAttackTypeResponse:
        """
        @summary 获取Top风险事件类型
        
        @param request: DescribeRiskEventTopAttackTypeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRiskEventTopAttackTypeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.buy_version):
            query['BuyVersion'] = request.buy_version
        if not UtilClient.is_unset(request.direction):
            query['Direction'] = request.direction
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRiskEventTopAttackType',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeRiskEventTopAttackTypeResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_risk_event_top_attack_type_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeRiskEventTopAttackTypeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeRiskEventTopAttackTypeResponse:
        """
        @summary 获取Top风险事件类型
        
        @param request: DescribeRiskEventTopAttackTypeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRiskEventTopAttackTypeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.buy_version):
            query['BuyVersion'] = request.buy_version
        if not UtilClient.is_unset(request.direction):
            query['Direction'] = request.direction
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRiskEventTopAttackType',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeRiskEventTopAttackTypeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_risk_event_top_attack_type(
        self,
        request: cloudfw_20171207_models.DescribeRiskEventTopAttackTypeRequest,
    ) -> cloudfw_20171207_models.DescribeRiskEventTopAttackTypeResponse:
        """
        @summary 获取Top风险事件类型
        
        @param request: DescribeRiskEventTopAttackTypeRequest
        @return: DescribeRiskEventTopAttackTypeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_risk_event_top_attack_type_with_options(request, runtime)

    async def describe_risk_event_top_attack_type_async(
        self,
        request: cloudfw_20171207_models.DescribeRiskEventTopAttackTypeRequest,
    ) -> cloudfw_20171207_models.DescribeRiskEventTopAttackTypeResponse:
        """
        @summary 获取Top风险事件类型
        
        @param request: DescribeRiskEventTopAttackTypeRequest
        @return: DescribeRiskEventTopAttackTypeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_risk_event_top_attack_type_with_options_async(request, runtime)

    def describe_risk_security_group_detail_with_options(
        self,
        request: cloudfw_20171207_models.DescribeRiskSecurityGroupDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeRiskSecurityGroupDetailResponse:
        """
        @deprecated OpenAPI DescribeRiskSecurityGroupDetail is deprecated
        
        @summary 获取风险安全组详情
        
        @param request: DescribeRiskSecurityGroupDetailRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRiskSecurityGroupDetailResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.instance_name):
            query['InstanceName'] = request.instance_name
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_no):
            query['PageNo'] = request.page_no
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.rule_uuid):
            query['RuleUuid'] = request.rule_uuid
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRiskSecurityGroupDetail',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeRiskSecurityGroupDetailResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_risk_security_group_detail_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeRiskSecurityGroupDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeRiskSecurityGroupDetailResponse:
        """
        @deprecated OpenAPI DescribeRiskSecurityGroupDetail is deprecated
        
        @summary 获取风险安全组详情
        
        @param request: DescribeRiskSecurityGroupDetailRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeRiskSecurityGroupDetailResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        if not UtilClient.is_unset(request.instance_name):
            query['InstanceName'] = request.instance_name
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_no):
            query['PageNo'] = request.page_no
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_id):
            query['RegionId'] = request.region_id
        if not UtilClient.is_unset(request.rule_uuid):
            query['RuleUuid'] = request.rule_uuid
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeRiskSecurityGroupDetail',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeRiskSecurityGroupDetailResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_risk_security_group_detail(
        self,
        request: cloudfw_20171207_models.DescribeRiskSecurityGroupDetailRequest,
    ) -> cloudfw_20171207_models.DescribeRiskSecurityGroupDetailResponse:
        """
        @deprecated OpenAPI DescribeRiskSecurityGroupDetail is deprecated
        
        @summary 获取风险安全组详情
        
        @param request: DescribeRiskSecurityGroupDetailRequest
        @return: DescribeRiskSecurityGroupDetailResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_risk_security_group_detail_with_options(request, runtime)

    async def describe_risk_security_group_detail_async(
        self,
        request: cloudfw_20171207_models.DescribeRiskSecurityGroupDetailRequest,
    ) -> cloudfw_20171207_models.DescribeRiskSecurityGroupDetailResponse:
        """
        @deprecated OpenAPI DescribeRiskSecurityGroupDetail is deprecated
        
        @summary 获取风险安全组详情
        
        @param request: DescribeRiskSecurityGroupDetailRequest
        @return: DescribeRiskSecurityGroupDetailResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_risk_security_group_detail_with_options_async(request, runtime)

    def describe_sdl_event_detail_with_options(
        self,
        request: cloudfw_20171207_models.DescribeSdlEventDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeSdlEventDetailResponse:
        """
        @summary 获取数据泄露的敏感数据事件列表
        
        @param request: DescribeSdlEventDetailRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSdlEventDetailResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.dst_ip):
            query['DstIp'] = request.dst_ip
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.src_ip):
            query['SrcIp'] = request.src_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSdlEventDetail',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeSdlEventDetailResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_sdl_event_detail_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeSdlEventDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeSdlEventDetailResponse:
        """
        @summary 获取数据泄露的敏感数据事件列表
        
        @param request: DescribeSdlEventDetailRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSdlEventDetailResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.dst_ip):
            query['DstIp'] = request.dst_ip
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.src_ip):
            query['SrcIp'] = request.src_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSdlEventDetail',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeSdlEventDetailResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_sdl_event_detail(
        self,
        request: cloudfw_20171207_models.DescribeSdlEventDetailRequest,
    ) -> cloudfw_20171207_models.DescribeSdlEventDetailResponse:
        """
        @summary 获取数据泄露的敏感数据事件列表
        
        @param request: DescribeSdlEventDetailRequest
        @return: DescribeSdlEventDetailResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_sdl_event_detail_with_options(request, runtime)

    async def describe_sdl_event_detail_async(
        self,
        request: cloudfw_20171207_models.DescribeSdlEventDetailRequest,
    ) -> cloudfw_20171207_models.DescribeSdlEventDetailResponse:
        """
        @summary 获取数据泄露的敏感数据事件列表
        
        @param request: DescribeSdlEventDetailRequest
        @return: DescribeSdlEventDetailResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_sdl_event_detail_with_options_async(request, runtime)

    def describe_sdl_event_list_with_options(
        self,
        request: cloudfw_20171207_models.DescribeSdlEventListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeSdlEventListResponse:
        """
        @summary 获取数据泄露事件列表
        
        @param request: DescribeSdlEventListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSdlEventListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.dst_ip):
            query['DstIp'] = request.dst_ip
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.location):
            query['Location'] = request.location
        if not UtilClient.is_unset(request.only_ai_evt):
            query['OnlyAiEvt'] = request.only_ai_evt
        if not UtilClient.is_unset(request.order):
            query['Order'] = request.order
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.sensitive_level):
            query['SensitiveLevel'] = request.sensitive_level
        if not UtilClient.is_unset(request.sort):
            query['Sort'] = request.sort
        if not UtilClient.is_unset(request.src_ip):
            query['SrcIp'] = request.src_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSdlEventList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeSdlEventListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_sdl_event_list_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeSdlEventListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeSdlEventListResponse:
        """
        @summary 获取数据泄露事件列表
        
        @param request: DescribeSdlEventListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSdlEventListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.dst_ip):
            query['DstIp'] = request.dst_ip
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.location):
            query['Location'] = request.location
        if not UtilClient.is_unset(request.only_ai_evt):
            query['OnlyAiEvt'] = request.only_ai_evt
        if not UtilClient.is_unset(request.order):
            query['Order'] = request.order
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.sensitive_level):
            query['SensitiveLevel'] = request.sensitive_level
        if not UtilClient.is_unset(request.sort):
            query['Sort'] = request.sort
        if not UtilClient.is_unset(request.src_ip):
            query['SrcIp'] = request.src_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSdlEventList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeSdlEventListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_sdl_event_list(
        self,
        request: cloudfw_20171207_models.DescribeSdlEventListRequest,
    ) -> cloudfw_20171207_models.DescribeSdlEventListResponse:
        """
        @summary 获取数据泄露事件列表
        
        @param request: DescribeSdlEventListRequest
        @return: DescribeSdlEventListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_sdl_event_list_with_options(request, runtime)

    async def describe_sdl_event_list_async(
        self,
        request: cloudfw_20171207_models.DescribeSdlEventListRequest,
    ) -> cloudfw_20171207_models.DescribeSdlEventListResponse:
        """
        @summary 获取数据泄露事件列表
        
        @param request: DescribeSdlEventListRequest
        @return: DescribeSdlEventListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_sdl_event_list_with_options_async(request, runtime)

    def describe_sdl_event_sd_list_with_options(
        self,
        request: cloudfw_20171207_models.DescribeSdlEventSdListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeSdlEventSdListResponse:
        """
        @summary 获取数据泄露的敏感数据列表
        
        @param request: DescribeSdlEventSdListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSdlEventSdListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.dst_ip):
            query['DstIp'] = request.dst_ip
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.src_ip):
            query['SrcIp'] = request.src_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSdlEventSdList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeSdlEventSdListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_sdl_event_sd_list_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeSdlEventSdListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeSdlEventSdListResponse:
        """
        @summary 获取数据泄露的敏感数据列表
        
        @param request: DescribeSdlEventSdListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSdlEventSdListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.dst_ip):
            query['DstIp'] = request.dst_ip
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.src_ip):
            query['SrcIp'] = request.src_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.uuid):
            query['Uuid'] = request.uuid
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSdlEventSdList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeSdlEventSdListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_sdl_event_sd_list(
        self,
        request: cloudfw_20171207_models.DescribeSdlEventSdListRequest,
    ) -> cloudfw_20171207_models.DescribeSdlEventSdListResponse:
        """
        @summary 获取数据泄露的敏感数据列表
        
        @param request: DescribeSdlEventSdListRequest
        @return: DescribeSdlEventSdListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_sdl_event_sd_list_with_options(request, runtime)

    async def describe_sdl_event_sd_list_async(
        self,
        request: cloudfw_20171207_models.DescribeSdlEventSdListRequest,
    ) -> cloudfw_20171207_models.DescribeSdlEventSdListResponse:
        """
        @summary 获取数据泄露的敏感数据列表
        
        @param request: DescribeSdlEventSdListRequest
        @return: DescribeSdlEventSdListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_sdl_event_sd_list_with_options_async(request, runtime)

    def describe_sdl_event_statistic_with_options(
        self,
        request: cloudfw_20171207_models.DescribeSdlEventStatisticRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeSdlEventStatisticResponse:
        """
        @summary 获取数据泄露事件统计数据
        
        @param request: DescribeSdlEventStatisticRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSdlEventStatisticResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSdlEventStatistic',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeSdlEventStatisticResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_sdl_event_statistic_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeSdlEventStatisticRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeSdlEventStatisticResponse:
        """
        @summary 获取数据泄露事件统计数据
        
        @param request: DescribeSdlEventStatisticRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSdlEventStatisticResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSdlEventStatistic',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeSdlEventStatisticResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_sdl_event_statistic(
        self,
        request: cloudfw_20171207_models.DescribeSdlEventStatisticRequest,
    ) -> cloudfw_20171207_models.DescribeSdlEventStatisticResponse:
        """
        @summary 获取数据泄露事件统计数据
        
        @param request: DescribeSdlEventStatisticRequest
        @return: DescribeSdlEventStatisticResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_sdl_event_statistic_with_options(request, runtime)

    async def describe_sdl_event_statistic_async(
        self,
        request: cloudfw_20171207_models.DescribeSdlEventStatisticRequest,
    ) -> cloudfw_20171207_models.DescribeSdlEventStatisticResponse:
        """
        @summary 获取数据泄露事件统计数据
        
        @param request: DescribeSdlEventStatisticRequest
        @return: DescribeSdlEventStatisticResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_sdl_event_statistic_with_options_async(request, runtime)

    def describe_sdl_statistic_with_options(
        self,
        request: cloudfw_20171207_models.DescribeSdlStatisticRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeSdlStatisticResponse:
        """
        @summary 获取数据泄露事件类型分布/资产TOP/目的TOP
        
        @param request: DescribeSdlStatisticRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSdlStatisticResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSdlStatistic',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeSdlStatisticResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_sdl_statistic_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeSdlStatisticRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeSdlStatisticResponse:
        """
        @summary 获取数据泄露事件类型分布/资产TOP/目的TOP
        
        @param request: DescribeSdlStatisticRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSdlStatisticResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSdlStatistic',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeSdlStatisticResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_sdl_statistic(
        self,
        request: cloudfw_20171207_models.DescribeSdlStatisticRequest,
    ) -> cloudfw_20171207_models.DescribeSdlStatisticResponse:
        """
        @summary 获取数据泄露事件类型分布/资产TOP/目的TOP
        
        @param request: DescribeSdlStatisticRequest
        @return: DescribeSdlStatisticResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_sdl_statistic_with_options(request, runtime)

    async def describe_sdl_statistic_async(
        self,
        request: cloudfw_20171207_models.DescribeSdlStatisticRequest,
    ) -> cloudfw_20171207_models.DescribeSdlStatisticResponse:
        """
        @summary 获取数据泄露事件类型分布/资产TOP/目的TOP
        
        @param request: DescribeSdlStatisticRequest
        @return: DescribeSdlStatisticResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_sdl_statistic_with_options_async(request, runtime)

    def describe_security_mode_with_options(
        self,
        request: cloudfw_20171207_models.DescribeSecurityModeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeSecurityModeResponse:
        """
        @summary 获取安全模式
        
        @param request: DescribeSecurityModeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSecurityModeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSecurityMode',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeSecurityModeResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_security_mode_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeSecurityModeRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeSecurityModeResponse:
        """
        @summary 获取安全模式
        
        @param request: DescribeSecurityModeRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSecurityModeResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSecurityMode',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeSecurityModeResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_security_mode(
        self,
        request: cloudfw_20171207_models.DescribeSecurityModeRequest,
    ) -> cloudfw_20171207_models.DescribeSecurityModeResponse:
        """
        @summary 获取安全模式
        
        @param request: DescribeSecurityModeRequest
        @return: DescribeSecurityModeResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_security_mode_with_options(request, runtime)

    async def describe_security_mode_async(
        self,
        request: cloudfw_20171207_models.DescribeSecurityModeRequest,
    ) -> cloudfw_20171207_models.DescribeSecurityModeResponse:
        """
        @summary 获取安全模式
        
        @param request: DescribeSecurityModeRequest
        @return: DescribeSecurityModeResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_security_mode_with_options_async(request, runtime)

    def describe_security_proxy_with_options(
        self,
        request: cloudfw_20171207_models.DescribeSecurityProxyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeSecurityProxyResponse:
        """
        @deprecated OpenAPI DescribeSecurityProxy is deprecated, please use Cloudfw::2017-12-07::DescribeNatFirewallList instead.
        
        @summary 获取正向代理
        
        @param request: DescribeSecurityProxyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSecurityProxyResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.member_uid):
            query['MemberUid'] = request.member_uid
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.page_no):
            query['PageNo'] = request.page_no
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.proxy_id):
            query['ProxyId'] = request.proxy_id
        if not UtilClient.is_unset(request.proxy_name):
            query['ProxyName'] = request.proxy_name
        if not UtilClient.is_unset(request.region_no):
            query['RegionNo'] = request.region_no
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSecurityProxy',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeSecurityProxyResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_security_proxy_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeSecurityProxyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeSecurityProxyResponse:
        """
        @deprecated OpenAPI DescribeSecurityProxy is deprecated, please use Cloudfw::2017-12-07::DescribeNatFirewallList instead.
        
        @summary 获取正向代理
        
        @param request: DescribeSecurityProxyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSecurityProxyResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.member_uid):
            query['MemberUid'] = request.member_uid
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.page_no):
            query['PageNo'] = request.page_no
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.proxy_id):
            query['ProxyId'] = request.proxy_id
        if not UtilClient.is_unset(request.proxy_name):
            query['ProxyName'] = request.proxy_name
        if not UtilClient.is_unset(request.region_no):
            query['RegionNo'] = request.region_no
        if not UtilClient.is_unset(request.status):
            query['Status'] = request.status
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSecurityProxy',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeSecurityProxyResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_security_proxy(
        self,
        request: cloudfw_20171207_models.DescribeSecurityProxyRequest,
    ) -> cloudfw_20171207_models.DescribeSecurityProxyResponse:
        """
        @deprecated OpenAPI DescribeSecurityProxy is deprecated, please use Cloudfw::2017-12-07::DescribeNatFirewallList instead.
        
        @summary 获取正向代理
        
        @param request: DescribeSecurityProxyRequest
        @return: DescribeSecurityProxyResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_security_proxy_with_options(request, runtime)

    async def describe_security_proxy_async(
        self,
        request: cloudfw_20171207_models.DescribeSecurityProxyRequest,
    ) -> cloudfw_20171207_models.DescribeSecurityProxyResponse:
        """
        @deprecated OpenAPI DescribeSecurityProxy is deprecated, please use Cloudfw::2017-12-07::DescribeNatFirewallList instead.
        
        @summary 获取正向代理
        
        @param request: DescribeSecurityProxyRequest
        @return: DescribeSecurityProxyResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_security_proxy_with_options_async(request, runtime)

    def describe_security_proxy_resources_with_options(
        self,
        request: cloudfw_20171207_models.DescribeSecurityProxyResourcesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeSecurityProxyResourcesResponse:
        """
        @summary 获取正向代理资源
        
        @param request: DescribeSecurityProxyResourcesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSecurityProxyResourcesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.member_uid):
            query['MemberUid'] = request.member_uid
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSecurityProxyResources',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeSecurityProxyResourcesResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_security_proxy_resources_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeSecurityProxyResourcesRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeSecurityProxyResourcesResponse:
        """
        @summary 获取正向代理资源
        
        @param request: DescribeSecurityProxyResourcesRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSecurityProxyResourcesResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.member_uid):
            query['MemberUid'] = request.member_uid
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSecurityProxyResources',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeSecurityProxyResourcesResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_security_proxy_resources(
        self,
        request: cloudfw_20171207_models.DescribeSecurityProxyResourcesRequest,
    ) -> cloudfw_20171207_models.DescribeSecurityProxyResourcesResponse:
        """
        @summary 获取正向代理资源
        
        @param request: DescribeSecurityProxyResourcesRequest
        @return: DescribeSecurityProxyResourcesResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_security_proxy_resources_with_options(request, runtime)

    async def describe_security_proxy_resources_async(
        self,
        request: cloudfw_20171207_models.DescribeSecurityProxyResourcesRequest,
    ) -> cloudfw_20171207_models.DescribeSecurityProxyResourcesResponse:
        """
        @summary 获取正向代理资源
        
        @param request: DescribeSecurityProxyResourcesRequest
        @return: DescribeSecurityProxyResourcesResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_security_proxy_resources_with_options_async(request, runtime)

    def describe_sensitive_switch_with_options(
        self,
        request: cloudfw_20171207_models.DescribeSensitiveSwitchRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeSensitiveSwitchResponse:
        """
        @summary 获取敏感数据类别开关
        
        @param request: DescribeSensitiveSwitchRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSensitiveSwitchResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.category_name):
            query['CategoryName'] = request.category_name
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.parent_category):
            query['ParentCategory'] = request.parent_category
        if not UtilClient.is_unset(request.sensitive_category):
            query['SensitiveCategory'] = request.sensitive_category
        if not UtilClient.is_unset(request.sensitive_level):
            query['SensitiveLevel'] = request.sensitive_level
        if not UtilClient.is_unset(request.switch_status):
            query['SwitchStatus'] = request.switch_status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSensitiveSwitch',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeSensitiveSwitchResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_sensitive_switch_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeSensitiveSwitchRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeSensitiveSwitchResponse:
        """
        @summary 获取敏感数据类别开关
        
        @param request: DescribeSensitiveSwitchRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSensitiveSwitchResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.category_name):
            query['CategoryName'] = request.category_name
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.parent_category):
            query['ParentCategory'] = request.parent_category
        if not UtilClient.is_unset(request.sensitive_category):
            query['SensitiveCategory'] = request.sensitive_category
        if not UtilClient.is_unset(request.sensitive_level):
            query['SensitiveLevel'] = request.sensitive_level
        if not UtilClient.is_unset(request.switch_status):
            query['SwitchStatus'] = request.switch_status
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSensitiveSwitch',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeSensitiveSwitchResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_sensitive_switch(
        self,
        request: cloudfw_20171207_models.DescribeSensitiveSwitchRequest,
    ) -> cloudfw_20171207_models.DescribeSensitiveSwitchResponse:
        """
        @summary 获取敏感数据类别开关
        
        @param request: DescribeSensitiveSwitchRequest
        @return: DescribeSensitiveSwitchResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_sensitive_switch_with_options(request, runtime)

    async def describe_sensitive_switch_async(
        self,
        request: cloudfw_20171207_models.DescribeSensitiveSwitchRequest,
    ) -> cloudfw_20171207_models.DescribeSensitiveSwitchResponse:
        """
        @summary 获取敏感数据类别开关
        
        @param request: DescribeSensitiveSwitchRequest
        @return: DescribeSensitiveSwitchResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_sensitive_switch_with_options_async(request, runtime)

    def describe_signature_lib_version_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeSignatureLibVersionResponse:
        """
        @summary Queries the information about signature library versions.
        
        @param request: DescribeSignatureLibVersionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSignatureLibVersionResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeSignatureLibVersion',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeSignatureLibVersionResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_signature_lib_version_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeSignatureLibVersionResponse:
        """
        @summary Queries the information about signature library versions.
        
        @param request: DescribeSignatureLibVersionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSignatureLibVersionResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeSignatureLibVersion',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeSignatureLibVersionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_signature_lib_version(self) -> cloudfw_20171207_models.DescribeSignatureLibVersionResponse:
        """
        @summary Queries the information about signature library versions.
        
        @return: DescribeSignatureLibVersionResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_signature_lib_version_with_options(runtime)

    async def describe_signature_lib_version_async(self) -> cloudfw_20171207_models.DescribeSignatureLibVersionResponse:
        """
        @summary Queries the information about signature library versions.
        
        @return: DescribeSignatureLibVersionResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_signature_lib_version_with_options_async(runtime)

    def describe_slr_grant_with_options(
        self,
        request: cloudfw_20171207_models.DescribeSlrGrantRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeSlrGrantResponse:
        """
        @summary 获取用户SLR授权信息
        
        @param request: DescribeSlrGrantRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSlrGrantResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSlrGrant',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeSlrGrantResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_slr_grant_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeSlrGrantRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeSlrGrantResponse:
        """
        @summary 获取用户SLR授权信息
        
        @param request: DescribeSlrGrantRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSlrGrantResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSlrGrant',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeSlrGrantResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_slr_grant(
        self,
        request: cloudfw_20171207_models.DescribeSlrGrantRequest,
    ) -> cloudfw_20171207_models.DescribeSlrGrantResponse:
        """
        @summary 获取用户SLR授权信息
        
        @param request: DescribeSlrGrantRequest
        @return: DescribeSlrGrantResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_slr_grant_with_options(request, runtime)

    async def describe_slr_grant_async(
        self,
        request: cloudfw_20171207_models.DescribeSlrGrantRequest,
    ) -> cloudfw_20171207_models.DescribeSlrGrantResponse:
        """
        @summary 获取用户SLR授权信息
        
        @param request: DescribeSlrGrantRequest
        @return: DescribeSlrGrantResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_slr_grant_with_options_async(request, runtime)

    def describe_sls_analyze_open_status_with_options(
        self,
        request: cloudfw_20171207_models.DescribeSlsAnalyzeOpenStatusRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeSlsAnalyzeOpenStatusResponse:
        """
        @summary 获取SLS开启状态
        
        @param request: DescribeSlsAnalyzeOpenStatusRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSlsAnalyzeOpenStatusResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSlsAnalyzeOpenStatus',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeSlsAnalyzeOpenStatusResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_sls_analyze_open_status_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeSlsAnalyzeOpenStatusRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeSlsAnalyzeOpenStatusResponse:
        """
        @summary 获取SLS开启状态
        
        @param request: DescribeSlsAnalyzeOpenStatusRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeSlsAnalyzeOpenStatusResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeSlsAnalyzeOpenStatus',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeSlsAnalyzeOpenStatusResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_sls_analyze_open_status(
        self,
        request: cloudfw_20171207_models.DescribeSlsAnalyzeOpenStatusRequest,
    ) -> cloudfw_20171207_models.DescribeSlsAnalyzeOpenStatusResponse:
        """
        @summary 获取SLS开启状态
        
        @param request: DescribeSlsAnalyzeOpenStatusRequest
        @return: DescribeSlsAnalyzeOpenStatusResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_sls_analyze_open_status_with_options(request, runtime)

    async def describe_sls_analyze_open_status_async(
        self,
        request: cloudfw_20171207_models.DescribeSlsAnalyzeOpenStatusRequest,
    ) -> cloudfw_20171207_models.DescribeSlsAnalyzeOpenStatusResponse:
        """
        @summary 获取SLS开启状态
        
        @param request: DescribeSlsAnalyzeOpenStatusRequest
        @return: DescribeSlsAnalyzeOpenStatusResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_sls_analyze_open_status_with_options_async(request, runtime)

    def describe_threat_intelligence_switch_with_options(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeThreatIntelligenceSwitchResponse:
        """
        @summary 查询威胁情报配置的信息
        
        @param request: DescribeThreatIntelligenceSwitchRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeThreatIntelligenceSwitchResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeThreatIntelligenceSwitch',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeThreatIntelligenceSwitchResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_threat_intelligence_switch_with_options_async(
        self,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeThreatIntelligenceSwitchResponse:
        """
        @summary 查询威胁情报配置的信息
        
        @param request: DescribeThreatIntelligenceSwitchRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeThreatIntelligenceSwitchResponse
        """
        req = open_api_models.OpenApiRequest()
        params = open_api_models.Params(
            action='DescribeThreatIntelligenceSwitch',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeThreatIntelligenceSwitchResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_threat_intelligence_switch(self) -> cloudfw_20171207_models.DescribeThreatIntelligenceSwitchResponse:
        """
        @summary 查询威胁情报配置的信息
        
        @return: DescribeThreatIntelligenceSwitchResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_threat_intelligence_switch_with_options(runtime)

    async def describe_threat_intelligence_switch_async(self) -> cloudfw_20171207_models.DescribeThreatIntelligenceSwitchResponse:
        """
        @summary 查询威胁情报配置的信息
        
        @return: DescribeThreatIntelligenceSwitchResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_threat_intelligence_switch_with_options_async(runtime)

    def describe_tr_firewall_policy_back_up_association_list_with_options(
        self,
        tmp_req: cloudfw_20171207_models.DescribeTrFirewallPolicyBackUpAssociationListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeTrFirewallPolicyBackUpAssociationListResponse:
        """
        @summary Queries information about the transit routers that are associated with a virtual private cloud (VPC) firewall created for a transit router.
        
        @param tmp_req: DescribeTrFirewallPolicyBackUpAssociationListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeTrFirewallPolicyBackUpAssociationListResponse
        """
        UtilClient.validate_model(tmp_req)
        request = cloudfw_20171207_models.DescribeTrFirewallPolicyBackUpAssociationListShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.candidate_list):
            request.candidate_list_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.candidate_list, 'CandidateList', 'json')
        query = {}
        if not UtilClient.is_unset(request.candidate_list_shrink):
            query['CandidateList'] = request.candidate_list_shrink
        if not UtilClient.is_unset(request.firewall_id):
            query['FirewallId'] = request.firewall_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.tr_firewall_route_policy_id):
            query['TrFirewallRoutePolicyId'] = request.tr_firewall_route_policy_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeTrFirewallPolicyBackUpAssociationList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeTrFirewallPolicyBackUpAssociationListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_tr_firewall_policy_back_up_association_list_with_options_async(
        self,
        tmp_req: cloudfw_20171207_models.DescribeTrFirewallPolicyBackUpAssociationListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeTrFirewallPolicyBackUpAssociationListResponse:
        """
        @summary Queries information about the transit routers that are associated with a virtual private cloud (VPC) firewall created for a transit router.
        
        @param tmp_req: DescribeTrFirewallPolicyBackUpAssociationListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeTrFirewallPolicyBackUpAssociationListResponse
        """
        UtilClient.validate_model(tmp_req)
        request = cloudfw_20171207_models.DescribeTrFirewallPolicyBackUpAssociationListShrinkRequest()
        OpenApiUtilClient.convert(tmp_req, request)
        if not UtilClient.is_unset(tmp_req.candidate_list):
            request.candidate_list_shrink = OpenApiUtilClient.array_to_string_with_specified_style(tmp_req.candidate_list, 'CandidateList', 'json')
        query = {}
        if not UtilClient.is_unset(request.candidate_list_shrink):
            query['CandidateList'] = request.candidate_list_shrink
        if not UtilClient.is_unset(request.firewall_id):
            query['FirewallId'] = request.firewall_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.tr_firewall_route_policy_id):
            query['TrFirewallRoutePolicyId'] = request.tr_firewall_route_policy_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeTrFirewallPolicyBackUpAssociationList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeTrFirewallPolicyBackUpAssociationListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_tr_firewall_policy_back_up_association_list(
        self,
        request: cloudfw_20171207_models.DescribeTrFirewallPolicyBackUpAssociationListRequest,
    ) -> cloudfw_20171207_models.DescribeTrFirewallPolicyBackUpAssociationListResponse:
        """
        @summary Queries information about the transit routers that are associated with a virtual private cloud (VPC) firewall created for a transit router.
        
        @param request: DescribeTrFirewallPolicyBackUpAssociationListRequest
        @return: DescribeTrFirewallPolicyBackUpAssociationListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_tr_firewall_policy_back_up_association_list_with_options(request, runtime)

    async def describe_tr_firewall_policy_back_up_association_list_async(
        self,
        request: cloudfw_20171207_models.DescribeTrFirewallPolicyBackUpAssociationListRequest,
    ) -> cloudfw_20171207_models.DescribeTrFirewallPolicyBackUpAssociationListResponse:
        """
        @summary Queries information about the transit routers that are associated with a virtual private cloud (VPC) firewall created for a transit router.
        
        @param request: DescribeTrFirewallPolicyBackUpAssociationListRequest
        @return: DescribeTrFirewallPolicyBackUpAssociationListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_tr_firewall_policy_back_up_association_list_with_options_async(request, runtime)

    def describe_tr_firewall_v2route_policy_list_with_options(
        self,
        request: cloudfw_20171207_models.DescribeTrFirewallV2RoutePolicyListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeTrFirewallV2RoutePolicyListResponse:
        """
        @summary Queries the routing policies of a virtual private cloud (VPC) firewall that is created for a transit router.
        
        @param request: DescribeTrFirewallV2RoutePolicyListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeTrFirewallV2RoutePolicyListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.firewall_id):
            query['FirewallId'] = request.firewall_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.policy_id):
            query['PolicyId'] = request.policy_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeTrFirewallV2RoutePolicyList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeTrFirewallV2RoutePolicyListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_tr_firewall_v2route_policy_list_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeTrFirewallV2RoutePolicyListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeTrFirewallV2RoutePolicyListResponse:
        """
        @summary Queries the routing policies of a virtual private cloud (VPC) firewall that is created for a transit router.
        
        @param request: DescribeTrFirewallV2RoutePolicyListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeTrFirewallV2RoutePolicyListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.firewall_id):
            query['FirewallId'] = request.firewall_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.policy_id):
            query['PolicyId'] = request.policy_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeTrFirewallV2RoutePolicyList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeTrFirewallV2RoutePolicyListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_tr_firewall_v2route_policy_list(
        self,
        request: cloudfw_20171207_models.DescribeTrFirewallV2RoutePolicyListRequest,
    ) -> cloudfw_20171207_models.DescribeTrFirewallV2RoutePolicyListResponse:
        """
        @summary Queries the routing policies of a virtual private cloud (VPC) firewall that is created for a transit router.
        
        @param request: DescribeTrFirewallV2RoutePolicyListRequest
        @return: DescribeTrFirewallV2RoutePolicyListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_tr_firewall_v2route_policy_list_with_options(request, runtime)

    async def describe_tr_firewall_v2route_policy_list_async(
        self,
        request: cloudfw_20171207_models.DescribeTrFirewallV2RoutePolicyListRequest,
    ) -> cloudfw_20171207_models.DescribeTrFirewallV2RoutePolicyListResponse:
        """
        @summary Queries the routing policies of a virtual private cloud (VPC) firewall that is created for a transit router.
        
        @param request: DescribeTrFirewallV2RoutePolicyListRequest
        @return: DescribeTrFirewallV2RoutePolicyListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_tr_firewall_v2route_policy_list_with_options_async(request, runtime)

    def describe_tr_firewalls_v2detail_with_options(
        self,
        request: cloudfw_20171207_models.DescribeTrFirewallsV2DetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeTrFirewallsV2DetailResponse:
        """
        @summary Queries the details of the virtual private cloud (VPC) firewalls that are created for transit routers.
        
        @param request: DescribeTrFirewallsV2DetailRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeTrFirewallsV2DetailResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.firewall_id):
            query['FirewallId'] = request.firewall_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeTrFirewallsV2Detail',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeTrFirewallsV2DetailResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_tr_firewalls_v2detail_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeTrFirewallsV2DetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeTrFirewallsV2DetailResponse:
        """
        @summary Queries the details of the virtual private cloud (VPC) firewalls that are created for transit routers.
        
        @param request: DescribeTrFirewallsV2DetailRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeTrFirewallsV2DetailResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.firewall_id):
            query['FirewallId'] = request.firewall_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeTrFirewallsV2Detail',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeTrFirewallsV2DetailResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_tr_firewalls_v2detail(
        self,
        request: cloudfw_20171207_models.DescribeTrFirewallsV2DetailRequest,
    ) -> cloudfw_20171207_models.DescribeTrFirewallsV2DetailResponse:
        """
        @summary Queries the details of the virtual private cloud (VPC) firewalls that are created for transit routers.
        
        @param request: DescribeTrFirewallsV2DetailRequest
        @return: DescribeTrFirewallsV2DetailResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_tr_firewalls_v2detail_with_options(request, runtime)

    async def describe_tr_firewalls_v2detail_async(
        self,
        request: cloudfw_20171207_models.DescribeTrFirewallsV2DetailRequest,
    ) -> cloudfw_20171207_models.DescribeTrFirewallsV2DetailResponse:
        """
        @summary Queries the details of the virtual private cloud (VPC) firewalls that are created for transit routers.
        
        @param request: DescribeTrFirewallsV2DetailRequest
        @return: DescribeTrFirewallsV2DetailResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_tr_firewalls_v2detail_with_options_async(request, runtime)

    def describe_tr_firewalls_v2list_with_options(
        self,
        request: cloudfw_20171207_models.DescribeTrFirewallsV2ListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeTrFirewallsV2ListResponse:
        """
        @summary Queries the virtual private cloud (VPC) firewalls that are created for transit routers.
        
        @param request: DescribeTrFirewallsV2ListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeTrFirewallsV2ListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cen_id):
            query['CenId'] = request.cen_id
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.firewall_id):
            query['FirewallId'] = request.firewall_id
        if not UtilClient.is_unset(request.firewall_name):
            query['FirewallName'] = request.firewall_name
        if not UtilClient.is_unset(request.firewall_switch_status):
            query['FirewallSwitchStatus'] = request.firewall_switch_status
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_no):
            query['RegionNo'] = request.region_no
        if not UtilClient.is_unset(request.route_mode):
            query['RouteMode'] = request.route_mode
        if not UtilClient.is_unset(request.transit_router_id):
            query['TransitRouterId'] = request.transit_router_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeTrFirewallsV2List',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeTrFirewallsV2ListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_tr_firewalls_v2list_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeTrFirewallsV2ListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeTrFirewallsV2ListResponse:
        """
        @summary Queries the virtual private cloud (VPC) firewalls that are created for transit routers.
        
        @param request: DescribeTrFirewallsV2ListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeTrFirewallsV2ListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cen_id):
            query['CenId'] = request.cen_id
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.firewall_id):
            query['FirewallId'] = request.firewall_id
        if not UtilClient.is_unset(request.firewall_name):
            query['FirewallName'] = request.firewall_name
        if not UtilClient.is_unset(request.firewall_switch_status):
            query['FirewallSwitchStatus'] = request.firewall_switch_status
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_no):
            query['RegionNo'] = request.region_no
        if not UtilClient.is_unset(request.route_mode):
            query['RouteMode'] = request.route_mode
        if not UtilClient.is_unset(request.transit_router_id):
            query['TransitRouterId'] = request.transit_router_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeTrFirewallsV2List',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeTrFirewallsV2ListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_tr_firewalls_v2list(
        self,
        request: cloudfw_20171207_models.DescribeTrFirewallsV2ListRequest,
    ) -> cloudfw_20171207_models.DescribeTrFirewallsV2ListResponse:
        """
        @summary Queries the virtual private cloud (VPC) firewalls that are created for transit routers.
        
        @param request: DescribeTrFirewallsV2ListRequest
        @return: DescribeTrFirewallsV2ListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_tr_firewalls_v2list_with_options(request, runtime)

    async def describe_tr_firewalls_v2list_async(
        self,
        request: cloudfw_20171207_models.DescribeTrFirewallsV2ListRequest,
    ) -> cloudfw_20171207_models.DescribeTrFirewallsV2ListResponse:
        """
        @summary Queries the virtual private cloud (VPC) firewalls that are created for transit routers.
        
        @param request: DescribeTrFirewallsV2ListRequest
        @return: DescribeTrFirewallsV2ListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_tr_firewalls_v2list_with_options_async(request, runtime)

    def describe_tr_firewalls_v2route_list_with_options(
        self,
        request: cloudfw_20171207_models.DescribeTrFirewallsV2RouteListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeTrFirewallsV2RouteListResponse:
        """
        @summary Queries the route tables of the VPC firewalls that are created for transit routers.
        
        @param request: DescribeTrFirewallsV2RouteListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeTrFirewallsV2RouteListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.firewall_id):
            query['FirewallId'] = request.firewall_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.tr_firewall_route_policy_id):
            query['TrFirewallRoutePolicyId'] = request.tr_firewall_route_policy_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeTrFirewallsV2RouteList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeTrFirewallsV2RouteListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_tr_firewalls_v2route_list_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeTrFirewallsV2RouteListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeTrFirewallsV2RouteListResponse:
        """
        @summary Queries the route tables of the VPC firewalls that are created for transit routers.
        
        @param request: DescribeTrFirewallsV2RouteListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeTrFirewallsV2RouteListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.firewall_id):
            query['FirewallId'] = request.firewall_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.tr_firewall_route_policy_id):
            query['TrFirewallRoutePolicyId'] = request.tr_firewall_route_policy_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeTrFirewallsV2RouteList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeTrFirewallsV2RouteListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_tr_firewalls_v2route_list(
        self,
        request: cloudfw_20171207_models.DescribeTrFirewallsV2RouteListRequest,
    ) -> cloudfw_20171207_models.DescribeTrFirewallsV2RouteListResponse:
        """
        @summary Queries the route tables of the VPC firewalls that are created for transit routers.
        
        @param request: DescribeTrFirewallsV2RouteListRequest
        @return: DescribeTrFirewallsV2RouteListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_tr_firewalls_v2route_list_with_options(request, runtime)

    async def describe_tr_firewalls_v2route_list_async(
        self,
        request: cloudfw_20171207_models.DescribeTrFirewallsV2RouteListRequest,
    ) -> cloudfw_20171207_models.DescribeTrFirewallsV2RouteListResponse:
        """
        @summary Queries the route tables of the VPC firewalls that are created for transit routers.
        
        @param request: DescribeTrFirewallsV2RouteListRequest
        @return: DescribeTrFirewallsV2RouteListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_tr_firewalls_v2route_list_with_options_async(request, runtime)

    def describe_traffic_log_with_options(
        self,
        request: cloudfw_20171207_models.DescribeTrafficLogRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeTrafficLogResponse:
        """
        @summary 查询日志
        
        @param request: DescribeTrafficLogRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeTrafficLogResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_pre_rule_id):
            query['AclPreRuleId'] = request.acl_pre_rule_id
        if not UtilClient.is_unset(request.acl_pre_state):
            query['AclPreState'] = request.acl_pre_state
        if not UtilClient.is_unset(request.app_dpi_state):
            query['AppDpiState'] = request.app_dpi_state
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.asset_region):
            query['AssetRegion'] = request.asset_region
        if not UtilClient.is_unset(request.attack_type):
            query['AttackType'] = request.attack_type
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.direction):
            query['Direction'] = request.direction
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.domain_url):
            query['DomainUrl'] = request.domain_url
        if not UtilClient.is_unset(request.dst_ip):
            query['DstIP'] = request.dst_ip
        if not UtilClient.is_unset(request.dst_port):
            query['DstPort'] = request.dst_port
        if not UtilClient.is_unset(request.dst_vpc_id):
            query['DstVpcId'] = request.dst_vpc_id
        if not UtilClient.is_unset(request.dst_vpc_region_no):
            query['DstVpcRegionNo'] = request.dst_vpc_region_no
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.firewall_type):
            query['FirewallType'] = request.firewall_type
        if not UtilClient.is_unset(request.flow_type):
            query['FlowType'] = request.flow_type
        if not UtilClient.is_unset(request.ip_protocol):
            query['IpProtocol'] = request.ip_protocol
        if not UtilClient.is_unset(request.ip_version):
            query['IpVersion'] = request.ip_version
        if not UtilClient.is_unset(request.isp):
            query['Isp'] = request.isp
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.location):
            query['Location'] = request.location
        if not UtilClient.is_unset(request.member_uid):
            query['MemberUid'] = request.member_uid
        if not UtilClient.is_unset(request.nat_firewall_id):
            query['NatFirewallId'] = request.nat_firewall_id
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.rule_id):
            query['RuleId'] = request.rule_id
        if not UtilClient.is_unset(request.rule_result):
            query['RuleResult'] = request.rule_result
        if not UtilClient.is_unset(request.rule_source):
            query['RuleSource'] = request.rule_source
        if not UtilClient.is_unset(request.source_code):
            query['SourceCode'] = request.source_code
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.src_ip):
            query['SrcIP'] = request.src_ip
        if not UtilClient.is_unset(request.src_port):
            query['SrcPort'] = request.src_port
        if not UtilClient.is_unset(request.src_private_ip):
            query['SrcPrivateIP'] = request.src_private_ip
        if not UtilClient.is_unset(request.src_vpc_id):
            query['SrcVpcId'] = request.src_vpc_id
        if not UtilClient.is_unset(request.src_vpc_region_no):
            query['SrcVpcRegionNo'] = request.src_vpc_region_no
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.tls_scope_id):
            query['TlsScopeId'] = request.tls_scope_id
        if not UtilClient.is_unset(request.vpc_firewall_id):
            query['VpcFirewallId'] = request.vpc_firewall_id
        if not UtilClient.is_unset(request.vul_level):
            query['VulLevel'] = request.vul_level
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeTrafficLog',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeTrafficLogResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_traffic_log_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeTrafficLogRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeTrafficLogResponse:
        """
        @summary 查询日志
        
        @param request: DescribeTrafficLogRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeTrafficLogResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_pre_rule_id):
            query['AclPreRuleId'] = request.acl_pre_rule_id
        if not UtilClient.is_unset(request.acl_pre_state):
            query['AclPreState'] = request.acl_pre_state
        if not UtilClient.is_unset(request.app_dpi_state):
            query['AppDpiState'] = request.app_dpi_state
        if not UtilClient.is_unset(request.app_id):
            query['AppId'] = request.app_id
        if not UtilClient.is_unset(request.asset_region):
            query['AssetRegion'] = request.asset_region
        if not UtilClient.is_unset(request.attack_type):
            query['AttackType'] = request.attack_type
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.direction):
            query['Direction'] = request.direction
        if not UtilClient.is_unset(request.domain_name):
            query['DomainName'] = request.domain_name
        if not UtilClient.is_unset(request.domain_url):
            query['DomainUrl'] = request.domain_url
        if not UtilClient.is_unset(request.dst_ip):
            query['DstIP'] = request.dst_ip
        if not UtilClient.is_unset(request.dst_port):
            query['DstPort'] = request.dst_port
        if not UtilClient.is_unset(request.dst_vpc_id):
            query['DstVpcId'] = request.dst_vpc_id
        if not UtilClient.is_unset(request.dst_vpc_region_no):
            query['DstVpcRegionNo'] = request.dst_vpc_region_no
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.firewall_type):
            query['FirewallType'] = request.firewall_type
        if not UtilClient.is_unset(request.flow_type):
            query['FlowType'] = request.flow_type
        if not UtilClient.is_unset(request.ip_protocol):
            query['IpProtocol'] = request.ip_protocol
        if not UtilClient.is_unset(request.ip_version):
            query['IpVersion'] = request.ip_version
        if not UtilClient.is_unset(request.isp):
            query['Isp'] = request.isp
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.location):
            query['Location'] = request.location
        if not UtilClient.is_unset(request.member_uid):
            query['MemberUid'] = request.member_uid
        if not UtilClient.is_unset(request.nat_firewall_id):
            query['NatFirewallId'] = request.nat_firewall_id
        if not UtilClient.is_unset(request.nat_gateway_id):
            query['NatGatewayId'] = request.nat_gateway_id
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.rule_id):
            query['RuleId'] = request.rule_id
        if not UtilClient.is_unset(request.rule_result):
            query['RuleResult'] = request.rule_result
        if not UtilClient.is_unset(request.rule_source):
            query['RuleSource'] = request.rule_source
        if not UtilClient.is_unset(request.source_code):
            query['SourceCode'] = request.source_code
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.src_ip):
            query['SrcIP'] = request.src_ip
        if not UtilClient.is_unset(request.src_port):
            query['SrcPort'] = request.src_port
        if not UtilClient.is_unset(request.src_private_ip):
            query['SrcPrivateIP'] = request.src_private_ip
        if not UtilClient.is_unset(request.src_vpc_id):
            query['SrcVpcId'] = request.src_vpc_id
        if not UtilClient.is_unset(request.src_vpc_region_no):
            query['SrcVpcRegionNo'] = request.src_vpc_region_no
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.tls_scope_id):
            query['TlsScopeId'] = request.tls_scope_id
        if not UtilClient.is_unset(request.vpc_firewall_id):
            query['VpcFirewallId'] = request.vpc_firewall_id
        if not UtilClient.is_unset(request.vul_level):
            query['VulLevel'] = request.vul_level
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeTrafficLog',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeTrafficLogResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_traffic_log(
        self,
        request: cloudfw_20171207_models.DescribeTrafficLogRequest,
    ) -> cloudfw_20171207_models.DescribeTrafficLogResponse:
        """
        @summary 查询日志
        
        @param request: DescribeTrafficLogRequest
        @return: DescribeTrafficLogResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_traffic_log_with_options(request, runtime)

    async def describe_traffic_log_async(
        self,
        request: cloudfw_20171207_models.DescribeTrafficLogRequest,
    ) -> cloudfw_20171207_models.DescribeTrafficLogResponse:
        """
        @summary 查询日志
        
        @param request: DescribeTrafficLogRequest
        @return: DescribeTrafficLogResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_traffic_log_with_options_async(request, runtime)

    def describe_transit_router_resources_list_with_options(
        self,
        request: cloudfw_20171207_models.DescribeTransitRouterResourcesListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeTransitRouterResourcesListResponse:
        """
        @summary 获取TR交换机资源列表
        
        @param request: DescribeTransitRouterResourcesListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeTransitRouterResourcesListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cen_id):
            query['CenId'] = request.cen_id
        if not UtilClient.is_unset(request.firewall_id):
            query['FirewallId'] = request.firewall_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.region_no):
            query['RegionNo'] = request.region_no
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        if not UtilClient.is_unset(request.transit_router_id):
            query['TransitRouterId'] = request.transit_router_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeTransitRouterResourcesList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeTransitRouterResourcesListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_transit_router_resources_list_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeTransitRouterResourcesListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeTransitRouterResourcesListResponse:
        """
        @summary 获取TR交换机资源列表
        
        @param request: DescribeTransitRouterResourcesListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeTransitRouterResourcesListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cen_id):
            query['CenId'] = request.cen_id
        if not UtilClient.is_unset(request.firewall_id):
            query['FirewallId'] = request.firewall_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.region_no):
            query['RegionNo'] = request.region_no
        if not UtilClient.is_unset(request.resource_type):
            query['ResourceType'] = request.resource_type
        if not UtilClient.is_unset(request.transit_router_id):
            query['TransitRouterId'] = request.transit_router_id
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeTransitRouterResourcesList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeTransitRouterResourcesListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_transit_router_resources_list(
        self,
        request: cloudfw_20171207_models.DescribeTransitRouterResourcesListRequest,
    ) -> cloudfw_20171207_models.DescribeTransitRouterResourcesListResponse:
        """
        @summary 获取TR交换机资源列表
        
        @param request: DescribeTransitRouterResourcesListRequest
        @return: DescribeTransitRouterResourcesListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_transit_router_resources_list_with_options(request, runtime)

    async def describe_transit_router_resources_list_async(
        self,
        request: cloudfw_20171207_models.DescribeTransitRouterResourcesListRequest,
    ) -> cloudfw_20171207_models.DescribeTransitRouterResourcesListResponse:
        """
        @summary 获取TR交换机资源列表
        
        @param request: DescribeTransitRouterResourcesListRequest
        @return: DescribeTransitRouterResourcesListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_transit_router_resources_list_with_options_async(request, runtime)

    def describe_unprotected_port_trend_with_options(
        self,
        request: cloudfw_20171207_models.DescribeUnprotectedPortTrendRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeUnprotectedPortTrendResponse:
        """
        @summary 获取未保护的端口趋势
        
        @param request: DescribeUnprotectedPortTrendRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeUnprotectedPortTrendResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeUnprotectedPortTrend',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeUnprotectedPortTrendResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_unprotected_port_trend_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeUnprotectedPortTrendRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeUnprotectedPortTrendResponse:
        """
        @summary 获取未保护的端口趋势
        
        @param request: DescribeUnprotectedPortTrendRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeUnprotectedPortTrendResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeUnprotectedPortTrend',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeUnprotectedPortTrendResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_unprotected_port_trend(
        self,
        request: cloudfw_20171207_models.DescribeUnprotectedPortTrendRequest,
    ) -> cloudfw_20171207_models.DescribeUnprotectedPortTrendResponse:
        """
        @summary 获取未保护的端口趋势
        
        @param request: DescribeUnprotectedPortTrendRequest
        @return: DescribeUnprotectedPortTrendResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_unprotected_port_trend_with_options(request, runtime)

    async def describe_unprotected_port_trend_async(
        self,
        request: cloudfw_20171207_models.DescribeUnprotectedPortTrendRequest,
    ) -> cloudfw_20171207_models.DescribeUnprotectedPortTrendResponse:
        """
        @summary 获取未保护的端口趋势
        
        @param request: DescribeUnprotectedPortTrendRequest
        @return: DescribeUnprotectedPortTrendResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_unprotected_port_trend_with_options_async(request, runtime)

    def describe_unprotected_vuln_trend_with_options(
        self,
        request: cloudfw_20171207_models.DescribeUnprotectedVulnTrendRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeUnprotectedVulnTrendResponse:
        """
        @summary 获取未保护漏洞趋势
        
        @param request: DescribeUnprotectedVulnTrendRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeUnprotectedVulnTrendResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeUnprotectedVulnTrend',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeUnprotectedVulnTrendResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_unprotected_vuln_trend_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeUnprotectedVulnTrendRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeUnprotectedVulnTrendResponse:
        """
        @summary 获取未保护漏洞趋势
        
        @param request: DescribeUnprotectedVulnTrendRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeUnprotectedVulnTrendResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeUnprotectedVulnTrend',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeUnprotectedVulnTrendResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_unprotected_vuln_trend(
        self,
        request: cloudfw_20171207_models.DescribeUnprotectedVulnTrendRequest,
    ) -> cloudfw_20171207_models.DescribeUnprotectedVulnTrendResponse:
        """
        @summary 获取未保护漏洞趋势
        
        @param request: DescribeUnprotectedVulnTrendRequest
        @return: DescribeUnprotectedVulnTrendResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_unprotected_vuln_trend_with_options(request, runtime)

    async def describe_unprotected_vuln_trend_async(
        self,
        request: cloudfw_20171207_models.DescribeUnprotectedVulnTrendRequest,
    ) -> cloudfw_20171207_models.DescribeUnprotectedVulnTrendResponse:
        """
        @summary 获取未保护漏洞趋势
        
        @param request: DescribeUnprotectedVulnTrendRequest
        @return: DescribeUnprotectedVulnTrendResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_unprotected_vuln_trend_with_options_async(request, runtime)

    def describe_user_alarm_config_with_options(
        self,
        request: cloudfw_20171207_models.DescribeUserAlarmConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeUserAlarmConfigResponse:
        """
        @summary 获取用户告警配置
        
        @param request: DescribeUserAlarmConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeUserAlarmConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeUserAlarmConfig',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeUserAlarmConfigResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_user_alarm_config_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeUserAlarmConfigRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeUserAlarmConfigResponse:
        """
        @summary 获取用户告警配置
        
        @param request: DescribeUserAlarmConfigRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeUserAlarmConfigResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeUserAlarmConfig',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeUserAlarmConfigResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_user_alarm_config(
        self,
        request: cloudfw_20171207_models.DescribeUserAlarmConfigRequest,
    ) -> cloudfw_20171207_models.DescribeUserAlarmConfigResponse:
        """
        @summary 获取用户告警配置
        
        @param request: DescribeUserAlarmConfigRequest
        @return: DescribeUserAlarmConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_user_alarm_config_with_options(request, runtime)

    async def describe_user_alarm_config_async(
        self,
        request: cloudfw_20171207_models.DescribeUserAlarmConfigRequest,
    ) -> cloudfw_20171207_models.DescribeUserAlarmConfigResponse:
        """
        @summary 获取用户告警配置
        
        @param request: DescribeUserAlarmConfigRequest
        @return: DescribeUserAlarmConfigResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_user_alarm_config_with_options_async(request, runtime)

    def describe_user_asset_iptraffic_info_with_options(
        self,
        request: cloudfw_20171207_models.DescribeUserAssetIPTrafficInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeUserAssetIPTrafficInfoResponse:
        """
        @deprecated OpenAPI DescribeUserAssetIPTrafficInfo is deprecated
        
        @summary Queries the information about the traffic of a specified asset that belongs to your Alibaba Cloud account.
        
        @param request: DescribeUserAssetIPTrafficInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeUserAssetIPTrafficInfoResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeUserAssetIPTrafficInfo',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeUserAssetIPTrafficInfoResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_user_asset_iptraffic_info_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeUserAssetIPTrafficInfoRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeUserAssetIPTrafficInfoResponse:
        """
        @deprecated OpenAPI DescribeUserAssetIPTrafficInfo is deprecated
        
        @summary Queries the information about the traffic of a specified asset that belongs to your Alibaba Cloud account.
        
        @param request: DescribeUserAssetIPTrafficInfoRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeUserAssetIPTrafficInfoResponse
        Deprecated
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeUserAssetIPTrafficInfo',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeUserAssetIPTrafficInfoResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_user_asset_iptraffic_info(
        self,
        request: cloudfw_20171207_models.DescribeUserAssetIPTrafficInfoRequest,
    ) -> cloudfw_20171207_models.DescribeUserAssetIPTrafficInfoResponse:
        """
        @deprecated OpenAPI DescribeUserAssetIPTrafficInfo is deprecated
        
        @summary Queries the information about the traffic of a specified asset that belongs to your Alibaba Cloud account.
        
        @param request: DescribeUserAssetIPTrafficInfoRequest
        @return: DescribeUserAssetIPTrafficInfoResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_user_asset_iptraffic_info_with_options(request, runtime)

    async def describe_user_asset_iptraffic_info_async(
        self,
        request: cloudfw_20171207_models.DescribeUserAssetIPTrafficInfoRequest,
    ) -> cloudfw_20171207_models.DescribeUserAssetIPTrafficInfoResponse:
        """
        @deprecated OpenAPI DescribeUserAssetIPTrafficInfo is deprecated
        
        @summary Queries the information about the traffic of a specified asset that belongs to your Alibaba Cloud account.
        
        @param request: DescribeUserAssetIPTrafficInfoRequest
        @return: DescribeUserAssetIPTrafficInfoResponse
        Deprecated
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_user_asset_iptraffic_info_with_options_async(request, runtime)

    def describe_user_buy_version_with_options(
        self,
        request: cloudfw_20171207_models.DescribeUserBuyVersionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeUserBuyVersionResponse:
        """
        @summary Queries the edition information about Cloud Firewall.
        
        @description You can call this operation to query the edition information about Cloud Firewall.
        ## [](#qps-)Limits
        You can call this operation up to 10 times per second per account. If the number of calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeUserBuyVersionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeUserBuyVersionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeUserBuyVersion',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeUserBuyVersionResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_user_buy_version_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeUserBuyVersionRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeUserBuyVersionResponse:
        """
        @summary Queries the edition information about Cloud Firewall.
        
        @description You can call this operation to query the edition information about Cloud Firewall.
        ## [](#qps-)Limits
        You can call this operation up to 10 times per second per account. If the number of calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeUserBuyVersionRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeUserBuyVersionResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.instance_id):
            query['InstanceId'] = request.instance_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeUserBuyVersion',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeUserBuyVersionResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_user_buy_version(
        self,
        request: cloudfw_20171207_models.DescribeUserBuyVersionRequest,
    ) -> cloudfw_20171207_models.DescribeUserBuyVersionResponse:
        """
        @summary Queries the edition information about Cloud Firewall.
        
        @description You can call this operation to query the edition information about Cloud Firewall.
        ## [](#qps-)Limits
        You can call this operation up to 10 times per second per account. If the number of calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeUserBuyVersionRequest
        @return: DescribeUserBuyVersionResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_user_buy_version_with_options(request, runtime)

    async def describe_user_buy_version_async(
        self,
        request: cloudfw_20171207_models.DescribeUserBuyVersionRequest,
    ) -> cloudfw_20171207_models.DescribeUserBuyVersionResponse:
        """
        @summary Queries the edition information about Cloud Firewall.
        
        @description You can call this operation to query the edition information about Cloud Firewall.
        ## [](#qps-)Limits
        You can call this operation up to 10 times per second per account. If the number of calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeUserBuyVersionRequest
        @return: DescribeUserBuyVersionResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_user_buy_version_with_options_async(request, runtime)

    def describe_user_ipswhitelist_with_options(
        self,
        request: cloudfw_20171207_models.DescribeUserIPSWhitelistRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeUserIPSWhitelistResponse:
        """
        @summary 获取用户IPS白名单
        
        @param request: DescribeUserIPSWhitelistRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeUserIPSWhitelistResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeUserIPSWhitelist',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeUserIPSWhitelistResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_user_ipswhitelist_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeUserIPSWhitelistRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeUserIPSWhitelistResponse:
        """
        @summary 获取用户IPS白名单
        
        @param request: DescribeUserIPSWhitelistRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeUserIPSWhitelistResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.source_ip):
            query['SourceIp'] = request.source_ip
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeUserIPSWhitelist',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeUserIPSWhitelistResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_user_ipswhitelist(
        self,
        request: cloudfw_20171207_models.DescribeUserIPSWhitelistRequest,
    ) -> cloudfw_20171207_models.DescribeUserIPSWhitelistResponse:
        """
        @summary 获取用户IPS白名单
        
        @param request: DescribeUserIPSWhitelistRequest
        @return: DescribeUserIPSWhitelistResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_user_ipswhitelist_with_options(request, runtime)

    async def describe_user_ipswhitelist_async(
        self,
        request: cloudfw_20171207_models.DescribeUserIPSWhitelistRequest,
    ) -> cloudfw_20171207_models.DescribeUserIPSWhitelistResponse:
        """
        @summary 获取用户IPS白名单
        
        @param request: DescribeUserIPSWhitelistRequest
        @return: DescribeUserIPSWhitelistResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_user_ipswhitelist_with_options_async(request, runtime)

    def describe_vfw_ipsconfig_list_with_options(
        self,
        request: cloudfw_20171207_models.DescribeVfwIPSConfigListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeVfwIPSConfigListResponse:
        """
        @summary VPC防火墙IP配置列表
        
        @param request: DescribeVfwIPSConfigListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeVfwIPSConfigListResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVfwIPSConfigList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeVfwIPSConfigListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vfw_ipsconfig_list_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeVfwIPSConfigListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeVfwIPSConfigListResponse:
        """
        @summary VPC防火墙IP配置列表
        
        @param request: DescribeVfwIPSConfigListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeVfwIPSConfigListResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVfwIPSConfigList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeVfwIPSConfigListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vfw_ipsconfig_list(
        self,
        request: cloudfw_20171207_models.DescribeVfwIPSConfigListRequest,
    ) -> cloudfw_20171207_models.DescribeVfwIPSConfigListResponse:
        """
        @summary VPC防火墙IP配置列表
        
        @param request: DescribeVfwIPSConfigListRequest
        @return: DescribeVfwIPSConfigListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_vfw_ipsconfig_list_with_options(request, runtime)

    async def describe_vfw_ipsconfig_list_async(
        self,
        request: cloudfw_20171207_models.DescribeVfwIPSConfigListRequest,
    ) -> cloudfw_20171207_models.DescribeVfwIPSConfigListResponse:
        """
        @summary VPC防火墙IP配置列表
        
        @param request: DescribeVfwIPSConfigListRequest
        @return: DescribeVfwIPSConfigListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_vfw_ipsconfig_list_with_options_async(request, runtime)

    def describe_vpc_firewall_access_detail_with_options(
        self,
        request: cloudfw_20171207_models.DescribeVpcFirewallAccessDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeVpcFirewallAccessDetailResponse:
        """
        @summary 获取VPC防火墙通过详情
        
        @param request: DescribeVpcFirewallAccessDetailRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeVpcFirewallAccessDetailResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.asset_ip):
            query['AssetIP'] = request.asset_ip
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.direction):
            query['Direction'] = request.direction
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.ipprotocol):
            query['IPProtocol'] = request.ipprotocol
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.order):
            query['Order'] = request.order
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.peer_asset_ip):
            query['PeerAssetIP'] = request.peer_asset_ip
        if not UtilClient.is_unset(request.peer_asset_instance_id):
            query['PeerAssetInstanceId'] = request.peer_asset_instance_id
        if not UtilClient.is_unset(request.peer_asset_instance_name):
            query['PeerAssetInstanceName'] = request.peer_asset_instance_name
        if not UtilClient.is_unset(request.peer_vpc_id):
            query['PeerVpcId'] = request.peer_vpc_id
        if not UtilClient.is_unset(request.port):
            query['Port'] = request.port
        if not UtilClient.is_unset(request.risk_level):
            query['RiskLevel'] = request.risk_level
        if not UtilClient.is_unset(request.sort):
            query['Sort'] = request.sort
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVpcFirewallAccessDetail',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeVpcFirewallAccessDetailResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vpc_firewall_access_detail_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeVpcFirewallAccessDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeVpcFirewallAccessDetailResponse:
        """
        @summary 获取VPC防火墙通过详情
        
        @param request: DescribeVpcFirewallAccessDetailRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeVpcFirewallAccessDetailResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.asset_ip):
            query['AssetIP'] = request.asset_ip
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.direction):
            query['Direction'] = request.direction
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.ipprotocol):
            query['IPProtocol'] = request.ipprotocol
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.order):
            query['Order'] = request.order
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.peer_asset_ip):
            query['PeerAssetIP'] = request.peer_asset_ip
        if not UtilClient.is_unset(request.peer_asset_instance_id):
            query['PeerAssetInstanceId'] = request.peer_asset_instance_id
        if not UtilClient.is_unset(request.peer_asset_instance_name):
            query['PeerAssetInstanceName'] = request.peer_asset_instance_name
        if not UtilClient.is_unset(request.peer_vpc_id):
            query['PeerVpcId'] = request.peer_vpc_id
        if not UtilClient.is_unset(request.port):
            query['Port'] = request.port
        if not UtilClient.is_unset(request.risk_level):
            query['RiskLevel'] = request.risk_level
        if not UtilClient.is_unset(request.sort):
            query['Sort'] = request.sort
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVpcFirewallAccessDetail',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeVpcFirewallAccessDetailResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vpc_firewall_access_detail(
        self,
        request: cloudfw_20171207_models.DescribeVpcFirewallAccessDetailRequest,
    ) -> cloudfw_20171207_models.DescribeVpcFirewallAccessDetailResponse:
        """
        @summary 获取VPC防火墙通过详情
        
        @param request: DescribeVpcFirewallAccessDetailRequest
        @return: DescribeVpcFirewallAccessDetailResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_vpc_firewall_access_detail_with_options(request, runtime)

    async def describe_vpc_firewall_access_detail_async(
        self,
        request: cloudfw_20171207_models.DescribeVpcFirewallAccessDetailRequest,
    ) -> cloudfw_20171207_models.DescribeVpcFirewallAccessDetailResponse:
        """
        @summary 获取VPC防火墙通过详情
        
        @param request: DescribeVpcFirewallAccessDetailRequest
        @return: DescribeVpcFirewallAccessDetailResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_vpc_firewall_access_detail_with_options_async(request, runtime)

    def describe_vpc_firewall_acl_group_list_with_options(
        self,
        request: cloudfw_20171207_models.DescribeVpcFirewallAclGroupListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeVpcFirewallAclGroupListResponse:
        """
        @summary Queries the information about all policy groups of access control policies that are created for virtual private cloud (VPC) firewalls.
        
        @description You can call the DescribeVpcFirewallAclGroupList operation to query the information about all policy groups of access control policies that are created for VPC firewalls.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeVpcFirewallAclGroupListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeVpcFirewallAclGroupListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.firewall_configure_status):
            query['FirewallConfigureStatus'] = request.firewall_configure_status
        if not UtilClient.is_unset(request.firewall_id):
            query['FirewallId'] = request.firewall_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVpcFirewallAclGroupList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeVpcFirewallAclGroupListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vpc_firewall_acl_group_list_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeVpcFirewallAclGroupListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeVpcFirewallAclGroupListResponse:
        """
        @summary Queries the information about all policy groups of access control policies that are created for virtual private cloud (VPC) firewalls.
        
        @description You can call the DescribeVpcFirewallAclGroupList operation to query the information about all policy groups of access control policies that are created for VPC firewalls.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeVpcFirewallAclGroupListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeVpcFirewallAclGroupListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.firewall_configure_status):
            query['FirewallConfigureStatus'] = request.firewall_configure_status
        if not UtilClient.is_unset(request.firewall_id):
            query['FirewallId'] = request.firewall_id
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVpcFirewallAclGroupList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeVpcFirewallAclGroupListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vpc_firewall_acl_group_list(
        self,
        request: cloudfw_20171207_models.DescribeVpcFirewallAclGroupListRequest,
    ) -> cloudfw_20171207_models.DescribeVpcFirewallAclGroupListResponse:
        """
        @summary Queries the information about all policy groups of access control policies that are created for virtual private cloud (VPC) firewalls.
        
        @description You can call the DescribeVpcFirewallAclGroupList operation to query the information about all policy groups of access control policies that are created for VPC firewalls.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeVpcFirewallAclGroupListRequest
        @return: DescribeVpcFirewallAclGroupListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_vpc_firewall_acl_group_list_with_options(request, runtime)

    async def describe_vpc_firewall_acl_group_list_async(
        self,
        request: cloudfw_20171207_models.DescribeVpcFirewallAclGroupListRequest,
    ) -> cloudfw_20171207_models.DescribeVpcFirewallAclGroupListResponse:
        """
        @summary Queries the information about all policy groups of access control policies that are created for virtual private cloud (VPC) firewalls.
        
        @description You can call the DescribeVpcFirewallAclGroupList operation to query the information about all policy groups of access control policies that are created for VPC firewalls.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeVpcFirewallAclGroupListRequest
        @return: DescribeVpcFirewallAclGroupListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_vpc_firewall_acl_group_list_with_options_async(request, runtime)

    def describe_vpc_firewall_asset_list_with_options(
        self,
        request: cloudfw_20171207_models.DescribeVpcFirewallAssetListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeVpcFirewallAssetListResponse:
        """
        @summary 获取VPC防火墙资产列表
        
        @param request: DescribeVpcFirewallAssetListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeVpcFirewallAssetListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.asset_ip):
            query['AssetIP'] = request.asset_ip
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.direction):
            query['Direction'] = request.direction
        if not UtilClient.is_unset(request.ecs_instance_id):
            query['EcsInstanceId'] = request.ecs_instance_id
        if not UtilClient.is_unset(request.ecs_instance_name):
            query['EcsInstanceName'] = request.ecs_instance_name
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.ipprotocol):
            query['IPProtocol'] = request.ipprotocol
        if not UtilClient.is_unset(request.is_aitraffic):
            query['IsAITraffic'] = request.is_aitraffic
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.order):
            query['Order'] = request.order
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.peer_vpc_id):
            query['PeerVpcId'] = request.peer_vpc_id
        if not UtilClient.is_unset(request.port):
            query['Port'] = request.port
        if not UtilClient.is_unset(request.risk_level):
            query['RiskLevel'] = request.risk_level
        if not UtilClient.is_unset(request.sort):
            query['Sort'] = request.sort
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVpcFirewallAssetList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeVpcFirewallAssetListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vpc_firewall_asset_list_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeVpcFirewallAssetListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeVpcFirewallAssetListResponse:
        """
        @summary 获取VPC防火墙资产列表
        
        @param request: DescribeVpcFirewallAssetListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeVpcFirewallAssetListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.app_name):
            query['AppName'] = request.app_name
        if not UtilClient.is_unset(request.asset_ip):
            query['AssetIP'] = request.asset_ip
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.direction):
            query['Direction'] = request.direction
        if not UtilClient.is_unset(request.ecs_instance_id):
            query['EcsInstanceId'] = request.ecs_instance_id
        if not UtilClient.is_unset(request.ecs_instance_name):
            query['EcsInstanceName'] = request.ecs_instance_name
        if not UtilClient.is_unset(request.end_time):
            query['EndTime'] = request.end_time
        if not UtilClient.is_unset(request.ipprotocol):
            query['IPProtocol'] = request.ipprotocol
        if not UtilClient.is_unset(request.is_aitraffic):
            query['IsAITraffic'] = request.is_aitraffic
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.order):
            query['Order'] = request.order
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.peer_vpc_id):
            query['PeerVpcId'] = request.peer_vpc_id
        if not UtilClient.is_unset(request.port):
            query['Port'] = request.port
        if not UtilClient.is_unset(request.risk_level):
            query['RiskLevel'] = request.risk_level
        if not UtilClient.is_unset(request.sort):
            query['Sort'] = request.sort
        if not UtilClient.is_unset(request.start_time):
            query['StartTime'] = request.start_time
        if not UtilClient.is_unset(request.vpc_id):
            query['VpcId'] = request.vpc_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVpcFirewallAssetList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeVpcFirewallAssetListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vpc_firewall_asset_list(
        self,
        request: cloudfw_20171207_models.DescribeVpcFirewallAssetListRequest,
    ) -> cloudfw_20171207_models.DescribeVpcFirewallAssetListResponse:
        """
        @summary 获取VPC防火墙资产列表
        
        @param request: DescribeVpcFirewallAssetListRequest
        @return: DescribeVpcFirewallAssetListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_vpc_firewall_asset_list_with_options(request, runtime)

    async def describe_vpc_firewall_asset_list_async(
        self,
        request: cloudfw_20171207_models.DescribeVpcFirewallAssetListRequest,
    ) -> cloudfw_20171207_models.DescribeVpcFirewallAssetListResponse:
        """
        @summary 获取VPC防火墙资产列表
        
        @param request: DescribeVpcFirewallAssetListRequest
        @return: DescribeVpcFirewallAssetListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_vpc_firewall_asset_list_with_options_async(request, runtime)

    def describe_vpc_firewall_asset_region_list_with_options(
        self,
        request: cloudfw_20171207_models.DescribeVpcFirewallAssetRegionListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeVpcFirewallAssetRegionListResponse:
        """
        @summary 查询VPC防火墙资产地域
        
        @param request: DescribeVpcFirewallAssetRegionListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeVpcFirewallAssetRegionListResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVpcFirewallAssetRegionList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeVpcFirewallAssetRegionListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vpc_firewall_asset_region_list_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeVpcFirewallAssetRegionListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeVpcFirewallAssetRegionListResponse:
        """
        @summary 查询VPC防火墙资产地域
        
        @param request: DescribeVpcFirewallAssetRegionListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeVpcFirewallAssetRegionListResponse
        """
        UtilClient.validate_model(request)
        query = OpenApiUtilClient.query(UtilClient.to_map(request))
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVpcFirewallAssetRegionList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='GET',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeVpcFirewallAssetRegionListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vpc_firewall_asset_region_list(
        self,
        request: cloudfw_20171207_models.DescribeVpcFirewallAssetRegionListRequest,
    ) -> cloudfw_20171207_models.DescribeVpcFirewallAssetRegionListResponse:
        """
        @summary 查询VPC防火墙资产地域
        
        @param request: DescribeVpcFirewallAssetRegionListRequest
        @return: DescribeVpcFirewallAssetRegionListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_vpc_firewall_asset_region_list_with_options(request, runtime)

    async def describe_vpc_firewall_asset_region_list_async(
        self,
        request: cloudfw_20171207_models.DescribeVpcFirewallAssetRegionListRequest,
    ) -> cloudfw_20171207_models.DescribeVpcFirewallAssetRegionListResponse:
        """
        @summary 查询VPC防火墙资产地域
        
        @param request: DescribeVpcFirewallAssetRegionListRequest
        @return: DescribeVpcFirewallAssetRegionListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_vpc_firewall_asset_region_list_with_options_async(request, runtime)

    def describe_vpc_firewall_cen_detail_with_options(
        self,
        request: cloudfw_20171207_models.DescribeVpcFirewallCenDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeVpcFirewallCenDetailResponse:
        """
        @summary Queries the details about a virtual private cloud (VPC) firewall. The VPC firewall protects access traffic between a VPC and a network instance that is attached to a Cloud Enterprise Network (CEN) instance.
        
        @description You can call the DescribeVpcFirewallCenDetail operation to query the details about a VPC firewall. The VPC firewall protects access traffic between a specified VPC and a network instance that is attached to a CEN instance. The network instance can be a VPC, a virtual border router (VBR), or a Cloud Connect Network (CCN) instance.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeVpcFirewallCenDetailRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeVpcFirewallCenDetailResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.network_instance_id):
            query['NetworkInstanceId'] = request.network_instance_id
        if not UtilClient.is_unset(request.vpc_firewall_id):
            query['VpcFirewallId'] = request.vpc_firewall_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVpcFirewallCenDetail',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeVpcFirewallCenDetailResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vpc_firewall_cen_detail_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeVpcFirewallCenDetailRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeVpcFirewallCenDetailResponse:
        """
        @summary Queries the details about a virtual private cloud (VPC) firewall. The VPC firewall protects access traffic between a VPC and a network instance that is attached to a Cloud Enterprise Network (CEN) instance.
        
        @description You can call the DescribeVpcFirewallCenDetail operation to query the details about a VPC firewall. The VPC firewall protects access traffic between a specified VPC and a network instance that is attached to a CEN instance. The network instance can be a VPC, a virtual border router (VBR), or a Cloud Connect Network (CCN) instance.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeVpcFirewallCenDetailRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeVpcFirewallCenDetailResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.network_instance_id):
            query['NetworkInstanceId'] = request.network_instance_id
        if not UtilClient.is_unset(request.vpc_firewall_id):
            query['VpcFirewallId'] = request.vpc_firewall_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVpcFirewallCenDetail',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeVpcFirewallCenDetailResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vpc_firewall_cen_detail(
        self,
        request: cloudfw_20171207_models.DescribeVpcFirewallCenDetailRequest,
    ) -> cloudfw_20171207_models.DescribeVpcFirewallCenDetailResponse:
        """
        @summary Queries the details about a virtual private cloud (VPC) firewall. The VPC firewall protects access traffic between a VPC and a network instance that is attached to a Cloud Enterprise Network (CEN) instance.
        
        @description You can call the DescribeVpcFirewallCenDetail operation to query the details about a VPC firewall. The VPC firewall protects access traffic between a specified VPC and a network instance that is attached to a CEN instance. The network instance can be a VPC, a virtual border router (VBR), or a Cloud Connect Network (CCN) instance.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeVpcFirewallCenDetailRequest
        @return: DescribeVpcFirewallCenDetailResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_vpc_firewall_cen_detail_with_options(request, runtime)

    async def describe_vpc_firewall_cen_detail_async(
        self,
        request: cloudfw_20171207_models.DescribeVpcFirewallCenDetailRequest,
    ) -> cloudfw_20171207_models.DescribeVpcFirewallCenDetailResponse:
        """
        @summary Queries the details about a virtual private cloud (VPC) firewall. The VPC firewall protects access traffic between a VPC and a network instance that is attached to a Cloud Enterprise Network (CEN) instance.
        
        @description You can call the DescribeVpcFirewallCenDetail operation to query the details about a VPC firewall. The VPC firewall protects access traffic between a specified VPC and a network instance that is attached to a CEN instance. The network instance can be a VPC, a virtual border router (VBR), or a Cloud Connect Network (CCN) instance.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeVpcFirewallCenDetailRequest
        @return: DescribeVpcFirewallCenDetailResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_vpc_firewall_cen_detail_with_options_async(request, runtime)

    def describe_vpc_firewall_cen_list_with_options(
        self,
        request: cloudfw_20171207_models.DescribeVpcFirewallCenListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeVpcFirewallCenListResponse:
        """
        @summary Queries virtual private cloud (VPC) firewalls. Each VPC firewall protects mutual access traffic between a specified VPC and a network instance that is attached to a Cloud Enterprise Network (CEN) instance.
        
        @description You can call the DescribeVpcFirewallCenList operation to query VPC firewalls. A VPC firewall protects mutual access traffic between a specified VPC and a network instance that is attached to a CEN instance. The network instance can be a VPC, a virtual border router (VBR), or a Cloud Connect Network (CCN) instance.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeVpcFirewallCenListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeVpcFirewallCenListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cen_id):
            query['CenId'] = request.cen_id
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.firewall_switch_status):
            query['FirewallSwitchStatus'] = request.firewall_switch_status
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.member_uid):
            query['MemberUid'] = request.member_uid
        if not UtilClient.is_unset(request.network_instance_id):
            query['NetworkInstanceId'] = request.network_instance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_no):
            query['RegionNo'] = request.region_no
        if not UtilClient.is_unset(request.route_mode):
            query['RouteMode'] = request.route_mode
        if not UtilClient.is_unset(request.transit_router_type):
            query['TransitRouterType'] = request.transit_router_type
        if not UtilClient.is_unset(request.vpc_firewall_id):
            query['VpcFirewallId'] = request.vpc_firewall_id
        if not UtilClient.is_unset(request.vpc_firewall_name):
            query['VpcFirewallName'] = request.vpc_firewall_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVpcFirewallCenList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeVpcFirewallCenListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vpc_firewall_cen_list_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeVpcFirewallCenListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeVpcFirewallCenListResponse:
        """
        @summary Queries virtual private cloud (VPC) firewalls. Each VPC firewall protects mutual access traffic between a specified VPC and a network instance that is attached to a Cloud Enterprise Network (CEN) instance.
        
        @description You can call the DescribeVpcFirewallCenList operation to query VPC firewalls. A VPC firewall protects mutual access traffic between a specified VPC and a network instance that is attached to a CEN instance. The network instance can be a VPC, a virtual border router (VBR), or a Cloud Connect Network (CCN) instance.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeVpcFirewallCenListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeVpcFirewallCenListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.cen_id):
            query['CenId'] = request.cen_id
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.firewall_switch_status):
            query['FirewallSwitchStatus'] = request.firewall_switch_status
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.member_uid):
            query['MemberUid'] = request.member_uid
        if not UtilClient.is_unset(request.network_instance_id):
            query['NetworkInstanceId'] = request.network_instance_id
        if not UtilClient.is_unset(request.owner_id):
            query['OwnerId'] = request.owner_id
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.region_no):
            query['RegionNo'] = request.region_no
        if not UtilClient.is_unset(request.route_mode):
            query['RouteMode'] = request.route_mode
        if not UtilClient.is_unset(request.transit_router_type):
            query['TransitRouterType'] = request.transit_router_type
        if not UtilClient.is_unset(request.vpc_firewall_id):
            query['VpcFirewallId'] = request.vpc_firewall_id
        if not UtilClient.is_unset(request.vpc_firewall_name):
            query['VpcFirewallName'] = request.vpc_firewall_name
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVpcFirewallCenList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeVpcFirewallCenListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vpc_firewall_cen_list(
        self,
        request: cloudfw_20171207_models.DescribeVpcFirewallCenListRequest,
    ) -> cloudfw_20171207_models.DescribeVpcFirewallCenListResponse:
        """
        @summary Queries virtual private cloud (VPC) firewalls. Each VPC firewall protects mutual access traffic between a specified VPC and a network instance that is attached to a Cloud Enterprise Network (CEN) instance.
        
        @description You can call the DescribeVpcFirewallCenList operation to query VPC firewalls. A VPC firewall protects mutual access traffic between a specified VPC and a network instance that is attached to a CEN instance. The network instance can be a VPC, a virtual border router (VBR), or a Cloud Connect Network (CCN) instance.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeVpcFirewallCenListRequest
        @return: DescribeVpcFirewallCenListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_vpc_firewall_cen_list_with_options(request, runtime)

    async def describe_vpc_firewall_cen_list_async(
        self,
        request: cloudfw_20171207_models.DescribeVpcFirewallCenListRequest,
    ) -> cloudfw_20171207_models.DescribeVpcFirewallCenListResponse:
        """
        @summary Queries virtual private cloud (VPC) firewalls. Each VPC firewall protects mutual access traffic between a specified VPC and a network instance that is attached to a Cloud Enterprise Network (CEN) instance.
        
        @description You can call the DescribeVpcFirewallCenList operation to query VPC firewalls. A VPC firewall protects mutual access traffic between a specified VPC and a network instance that is attached to a CEN instance. The network instance can be a VPC, a virtual border router (VBR), or a Cloud Connect Network (CCN) instance.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeVpcFirewallCenListRequest
        @return: DescribeVpcFirewallCenListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_vpc_firewall_cen_list_with_options_async(request, runtime)

    def describe_vpc_firewall_cen_summary_list_with_options(
        self,
        request: cloudfw_20171207_models.DescribeVpcFirewallCenSummaryListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeVpcFirewallCenSummaryListResponse:
        """
        @summary 获取VPC的CEN列表
        
        @param request: DescribeVpcFirewallCenSummaryListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeVpcFirewallCenSummaryListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.member_uid):
            query['MemberUid'] = request.member_uid
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.transit_router_type):
            query['TransitRouterType'] = request.transit_router_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVpcFirewallCenSummaryList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeVpcFirewallCenSummaryListResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vpc_firewall_cen_summary_list_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeVpcFirewallCenSummaryListRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeVpcFirewallCenSummaryListResponse:
        """
        @summary 获取VPC的CEN列表
        
        @param request: DescribeVpcFirewallCenSummaryListRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeVpcFirewallCenSummaryListResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.member_uid):
            query['MemberUid'] = request.member_uid
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.transit_router_type):
            query['TransitRouterType'] = request.transit_router_type
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVpcFirewallCenSummaryList',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeVpcFirewallCenSummaryListResponse(),
            await self.call_api_async(params, req, runtime)
        )

    def describe_vpc_firewall_cen_summary_list(
        self,
        request: cloudfw_20171207_models.DescribeVpcFirewallCenSummaryListRequest,
    ) -> cloudfw_20171207_models.DescribeVpcFirewallCenSummaryListResponse:
        """
        @summary 获取VPC的CEN列表
        
        @param request: DescribeVpcFirewallCenSummaryListRequest
        @return: DescribeVpcFirewallCenSummaryListResponse
        """
        runtime = util_models.RuntimeOptions()
        return self.describe_vpc_firewall_cen_summary_list_with_options(request, runtime)

    async def describe_vpc_firewall_cen_summary_list_async(
        self,
        request: cloudfw_20171207_models.DescribeVpcFirewallCenSummaryListRequest,
    ) -> cloudfw_20171207_models.DescribeVpcFirewallCenSummaryListResponse:
        """
        @summary 获取VPC的CEN列表
        
        @param request: DescribeVpcFirewallCenSummaryListRequest
        @return: DescribeVpcFirewallCenSummaryListResponse
        """
        runtime = util_models.RuntimeOptions()
        return await self.describe_vpc_firewall_cen_summary_list_with_options_async(request, runtime)

    def describe_vpc_firewall_control_policy_with_options(
        self,
        request: cloudfw_20171207_models.DescribeVpcFirewallControlPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeVpcFirewallControlPolicyResponse:
        """
        @summary Queries the information about the access control policies for a specified virtual private cloud (VPC) firewall.
        
        @description You can call the DescribeVpcFirewallControlPolicy operation to query the information about all access control policies that are created for a specified VPC firewall. Different access control policies are used when a VPC firewall is used to protect traffic between two VPCs that are connected by using a Cloud Enterprise Network (CEN) instance or an Express Connect circuit.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeVpcFirewallControlPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeVpcFirewallControlPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_action):
            query['AclAction'] = request.acl_action
        if not UtilClient.is_unset(request.acl_uuid):
            query['AclUuid'] = request.acl_uuid
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.destination):
            query['Destination'] = request.destination
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.member_uid):
            query['MemberUid'] = request.member_uid
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.proto):
            query['Proto'] = request.proto
        if not UtilClient.is_unset(request.release):
            query['Release'] = request.release
        if not UtilClient.is_unset(request.repeat_type):
            query['RepeatType'] = request.repeat_type
        if not UtilClient.is_unset(request.source):
            query['Source'] = request.source
        if not UtilClient.is_unset(request.vpc_firewall_id):
            query['VpcFirewallId'] = request.vpc_firewall_id
        req = open_api_models.OpenApiRequest(
            query=OpenApiUtilClient.query(query)
        )
        params = open_api_models.Params(
            action='DescribeVpcFirewallControlPolicy',
            version='2017-12-07',
            protocol='HTTPS',
            pathname='/',
            method='POST',
            auth_type='AK',
            style='RPC',
            req_body_type='formData',
            body_type='json'
        )
        return TeaCore.from_map(
            cloudfw_20171207_models.DescribeVpcFirewallControlPolicyResponse(),
            self.call_api(params, req, runtime)
        )

    async def describe_vpc_firewall_control_policy_with_options_async(
        self,
        request: cloudfw_20171207_models.DescribeVpcFirewallControlPolicyRequest,
        runtime: util_models.RuntimeOptions,
    ) -> cloudfw_20171207_models.DescribeVpcFirewallControlPolicyResponse:
        """
        @summary Queries the information about the access control policies for a specified virtual private cloud (VPC) firewall.
        
        @description You can call the DescribeVpcFirewallControlPolicy operation to query the information about all access control policies that are created for a specified VPC firewall. Different access control policies are used when a VPC firewall is used to protect traffic between two VPCs that are connected by using a Cloud Enterprise Network (CEN) instance or an Express Connect circuit.
        ## Limits
        You can call this operation up to 10 times per second per account. If the number of the calls per second exceeds the limit, throttling is triggered. As a result, your business may be affected. We recommend that you take note of the limit when you call this operation.
        
        @param request: DescribeVpcFirewallControlPolicyRequest
        @param runtime: runtime options for this request RuntimeOptions
        @return: DescribeVpcFirewallControlPolicyResponse
        """
        UtilClient.validate_model(request)
        query = {}
        if not UtilClient.is_unset(request.acl_action):
            query['AclAction'] = request.acl_action
        if not UtilClient.is_unset(request.acl_uuid):
            query['AclUuid'] = request.acl_uuid
        if not UtilClient.is_unset(request.current_page):
            query['CurrentPage'] = request.current_page
        if not UtilClient.is_unset(request.description):
            query['Description'] = request.description
        if not UtilClient.is_unset(request.destination):
            query['Destination'] = request.destination
        if not UtilClient.is_unset(request.lang):
            query['Lang'] = request.lang
        if not UtilClient.is_unset(request.member_uid):
            query['MemberUid'] = request.member_uid
        if not UtilClient.is_unset(request.page_size):
            query['PageSize'] = request.page_size
        if not UtilClient.is_unset(request.proto):
            query['Proto'] = request.proto
        if not UtilClient.is_unset(request.release):
        