__all__ = ('SmsPoint', 'SmsToReferralPoint')

from expressmoney.api import *

SERVICE = 'notifications'


class SmsCreateContract(Contract):
    message = serializers.CharField(min_length=1, max_length=60)


class SmsToReferralContract(Contract):
    message = serializers.CharField(max_length=130)
    phonenumber = serializers.CharField(max_length=20)


class SmsID(ID):
    _service = SERVICE
    _app = 'sms'
    _view_set = 'sms'


class SmsToReferralID(ID):
    _service = SERVICE
    _app = 'sms'
    _view_set = 'sms_to_referral'


class SmsPoint(CreatePointMixin, ContractPoint):
    _point_id = SmsID()
    _create_contract = SmsCreateContract


class SmsToReferralPoint(CreatePointMixin, ContractPoint):
    _point_id = SmsToReferralID()
    _create_contract = SmsToReferralContract
