<a id="mypy-boto3-ec2"></a>

# mypy-boto3-ec2

[![PyPI - mypy-boto3-ec2](https://img.shields.io/pypi/v/mypy-boto3-ec2.svg?color=blue)](https://pypi.org/project/mypy-boto3-ec2)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-ec2.svg?color=blue)](https://pypi.org/project/mypy-boto3-ec2)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dm/mypy-boto3-ec2?color=blue)](https://pypistats.org/packages/mypy-boto3-ec2)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.EC2 1.20.12](https://boto3.amazonaws.com/v1/documentation/api/1.20.12/reference/services/ec2.html#EC2)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 6.2.1](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-ec2 docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_ec2/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-ec2](#mypy-boto3-ec2)
  - [How to install](#how-to-install)
    - [VSCode extension](#vscode-extension)
    - [From PyPI with pip](#from-pypi-with-pip)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

<a id="vscode-extension"></a>

### VSCode extension

Add
[AWS Boto3](https://marketplace.visualstudio.com/items?itemName=Boto3typed.boto3-ide)
extension to your VSCode and run `AWS boto3: Quick Start` command.

Click `Modify` and select `boto3 common` and `EC2`.

<a id="from-pypi-with-pip"></a>

### From PyPI with pip

Install `boto3-stubs` for `EC2` service.

```bash
python -m pip install boto3-stubs[ec2]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[ec2]` in your environment:
  `python -m pip install 'boto3-stubs[ec2]'`

Both type checking and auto-complete should work for `EC2` service. No explicit
type annotations required, write your `boto3` code as usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[ec2]` in your environment:
  `python -m pip install 'boto3-stubs[ec2]'`

Both type checking and auto-complete should work for `EC2` service. No explicit
type annotations required, write your `boto3` code as usual. Auto-complete can
be slow on big projects or if you have a lot of installed `boto3-stubs`
submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE supports `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[ec2]` in your environment:
  `python -m pip install 'boto3-stubs[ec2]'`
- Run `mypy` as usual

Type checking should work for `EC2` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[ec2]` in your environment:
  `python -m pip install 'boto3-stubs[ec2]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `EC2` service. No explicit type annotations
required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`EC2Client` provides annotations for `boto3.client("ec2")`.

```python
import boto3

from mypy_boto3_ec2 import EC2Client

client: EC2Client = boto3.client("ec2")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: EC2Client = session.client("ec2")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_ec2.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_ec2 import EC2Client
from mypy_boto3_ec2.paginator import (
    DescribeAddressesAttributePaginator,
    DescribeByoipCidrsPaginator,
    DescribeCapacityReservationFleetsPaginator,
    DescribeCapacityReservationsPaginator,
    DescribeCarrierGatewaysPaginator,
    DescribeClassicLinkInstancesPaginator,
    DescribeClientVpnAuthorizationRulesPaginator,
    DescribeClientVpnConnectionsPaginator,
    DescribeClientVpnEndpointsPaginator,
    DescribeClientVpnRoutesPaginator,
    DescribeClientVpnTargetNetworksPaginator,
    DescribeCoipPoolsPaginator,
    DescribeDhcpOptionsPaginator,
    DescribeEgressOnlyInternetGatewaysPaginator,
    DescribeExportImageTasksPaginator,
    DescribeFastSnapshotRestoresPaginator,
    DescribeFleetsPaginator,
    DescribeFlowLogsPaginator,
    DescribeFpgaImagesPaginator,
    DescribeHostReservationOfferingsPaginator,
    DescribeHostReservationsPaginator,
    DescribeHostsPaginator,
    DescribeIamInstanceProfileAssociationsPaginator,
    DescribeImportImageTasksPaginator,
    DescribeImportSnapshotTasksPaginator,
    DescribeInstanceCreditSpecificationsPaginator,
    DescribeInstanceEventWindowsPaginator,
    DescribeInstanceStatusPaginator,
    DescribeInstanceTypeOfferingsPaginator,
    DescribeInstanceTypesPaginator,
    DescribeInstancesPaginator,
    DescribeInternetGatewaysPaginator,
    DescribeIpv6PoolsPaginator,
    DescribeLaunchTemplateVersionsPaginator,
    DescribeLaunchTemplatesPaginator,
    DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPaginator,
    DescribeLocalGatewayRouteTableVpcAssociationsPaginator,
    DescribeLocalGatewayRouteTablesPaginator,
    DescribeLocalGatewayVirtualInterfaceGroupsPaginator,
    DescribeLocalGatewayVirtualInterfacesPaginator,
    DescribeLocalGatewaysPaginator,
    DescribeManagedPrefixListsPaginator,
    DescribeMovingAddressesPaginator,
    DescribeNatGatewaysPaginator,
    DescribeNetworkAclsPaginator,
    DescribeNetworkInsightsAnalysesPaginator,
    DescribeNetworkInsightsPathsPaginator,
    DescribeNetworkInterfacePermissionsPaginator,
    DescribeNetworkInterfacesPaginator,
    DescribePrefixListsPaginator,
    DescribePrincipalIdFormatPaginator,
    DescribePublicIpv4PoolsPaginator,
    DescribeReplaceRootVolumeTasksPaginator,
    DescribeReservedInstancesModificationsPaginator,
    DescribeReservedInstancesOfferingsPaginator,
    DescribeRouteTablesPaginator,
    DescribeScheduledInstanceAvailabilityPaginator,
    DescribeScheduledInstancesPaginator,
    DescribeSecurityGroupRulesPaginator,
    DescribeSecurityGroupsPaginator,
    DescribeSnapshotsPaginator,
    DescribeSpotFleetInstancesPaginator,
    DescribeSpotFleetRequestsPaginator,
    DescribeSpotInstanceRequestsPaginator,
    DescribeSpotPriceHistoryPaginator,
    DescribeStaleSecurityGroupsPaginator,
    DescribeStoreImageTasksPaginator,
    DescribeSubnetsPaginator,
    DescribeTagsPaginator,
    DescribeTrafficMirrorFiltersPaginator,
    DescribeTrafficMirrorSessionsPaginator,
    DescribeTrafficMirrorTargetsPaginator,
    DescribeTransitGatewayAttachmentsPaginator,
    DescribeTransitGatewayConnectPeersPaginator,
    DescribeTransitGatewayConnectsPaginator,
    DescribeTransitGatewayMulticastDomainsPaginator,
    DescribeTransitGatewayPeeringAttachmentsPaginator,
    DescribeTransitGatewayRouteTablesPaginator,
    DescribeTransitGatewayVpcAttachmentsPaginator,
    DescribeTransitGatewaysPaginator,
    DescribeTrunkInterfaceAssociationsPaginator,
    DescribeVolumeStatusPaginator,
    DescribeVolumesPaginator,
    DescribeVolumesModificationsPaginator,
    DescribeVpcClassicLinkDnsSupportPaginator,
    DescribeVpcEndpointConnectionNotificationsPaginator,
    DescribeVpcEndpointConnectionsPaginator,
    DescribeVpcEndpointServiceConfigurationsPaginator,
    DescribeVpcEndpointServicePermissionsPaginator,
    DescribeVpcEndpointServicesPaginator,
    DescribeVpcEndpointsPaginator,
    DescribeVpcPeeringConnectionsPaginator,
    DescribeVpcsPaginator,
    GetAssociatedIpv6PoolCidrsPaginator,
    GetGroupsForCapacityReservationPaginator,
    GetInstanceTypesFromInstanceRequirementsPaginator,
    GetManagedPrefixListAssociationsPaginator,
    GetManagedPrefixListEntriesPaginator,
    GetSpotPlacementScoresPaginator,
    GetTransitGatewayAttachmentPropagationsPaginator,
    GetTransitGatewayMulticastDomainAssociationsPaginator,
    GetTransitGatewayPrefixListReferencesPaginator,
    GetTransitGatewayRouteTableAssociationsPaginator,
    GetTransitGatewayRouteTablePropagationsPaginator,
    GetVpnConnectionDeviceTypesPaginator,
    SearchLocalGatewayRoutesPaginator,
    SearchTransitGatewayMulticastGroupsPaginator,
)

client: EC2Client = boto3.client("ec2")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_addresses_attribute_paginator: DescribeAddressesAttributePaginator = client.get_paginator("describe_addresses_attribute")
describe_byoip_cidrs_paginator: DescribeByoipCidrsPaginator = client.get_paginator("describe_byoip_cidrs")
describe_capacity_reservation_fleets_paginator: DescribeCapacityReservationFleetsPaginator = client.get_paginator("describe_capacity_reservation_fleets")
describe_capacity_reservations_paginator: DescribeCapacityReservationsPaginator = client.get_paginator("describe_capacity_reservations")
describe_carrier_gateways_paginator: DescribeCarrierGatewaysPaginator = client.get_paginator("describe_carrier_gateways")
describe_classic_link_instances_paginator: DescribeClassicLinkInstancesPaginator = client.get_paginator("describe_classic_link_instances")
describe_client_vpn_authorization_rules_paginator: DescribeClientVpnAuthorizationRulesPaginator = client.get_paginator("describe_client_vpn_authorization_rules")
describe_client_vpn_connections_paginator: DescribeClientVpnConnectionsPaginator = client.get_paginator("describe_client_vpn_connections")
describe_client_vpn_endpoints_paginator: DescribeClientVpnEndpointsPaginator = client.get_paginator("describe_client_vpn_endpoints")
describe_client_vpn_routes_paginator: DescribeClientVpnRoutesPaginator = client.get_paginator("describe_client_vpn_routes")
describe_client_vpn_target_networks_paginator: DescribeClientVpnTargetNetworksPaginator = client.get_paginator("describe_client_vpn_target_networks")
describe_coip_pools_paginator: DescribeCoipPoolsPaginator = client.get_paginator("describe_coip_pools")
describe_dhcp_options_paginator: DescribeDhcpOptionsPaginator = client.get_paginator("describe_dhcp_options")
describe_egress_only_internet_gateways_paginator: DescribeEgressOnlyInternetGatewaysPaginator = client.get_paginator("describe_egress_only_internet_gateways")
describe_export_image_tasks_paginator: DescribeExportImageTasksPaginator = client.get_paginator("describe_export_image_tasks")
describe_fast_snapshot_restores_paginator: DescribeFastSnapshotRestoresPaginator = client.get_paginator("describe_fast_snapshot_restores")
describe_fleets_paginator: DescribeFleetsPaginator = client.get_paginator("describe_fleets")
describe_flow_logs_paginator: DescribeFlowLogsPaginator = client.get_paginator("describe_flow_logs")
describe_fpga_images_paginator: DescribeFpgaImagesPaginator = client.get_paginator("describe_fpga_images")
describe_host_reservation_offerings_paginator: DescribeHostReservationOfferingsPaginator = client.get_paginator("describe_host_reservation_offerings")
describe_host_reservations_paginator: DescribeHostReservationsPaginator = client.get_paginator("describe_host_reservations")
describe_hosts_paginator: DescribeHostsPaginator = client.get_paginator("describe_hosts")
describe_iam_instance_profile_associations_paginator: DescribeIamInstanceProfileAssociationsPaginator = client.get_paginator("describe_iam_instance_profile_associations")
describe_import_image_tasks_paginator: DescribeImportImageTasksPaginator = client.get_paginator("describe_import_image_tasks")
describe_import_snapshot_tasks_paginator: DescribeImportSnapshotTasksPaginator = client.get_paginator("describe_import_snapshot_tasks")
describe_instance_credit_specifications_paginator: DescribeInstanceCreditSpecificationsPaginator = client.get_paginator("describe_instance_credit_specifications")
describe_instance_event_windows_paginator: DescribeInstanceEventWindowsPaginator = client.get_paginator("describe_instance_event_windows")
describe_instance_status_paginator: DescribeInstanceStatusPaginator = client.get_paginator("describe_instance_status")
describe_instance_type_offerings_paginator: DescribeInstanceTypeOfferingsPaginator = client.get_paginator("describe_instance_type_offerings")
describe_instance_types_paginator: DescribeInstanceTypesPaginator = client.get_paginator("describe_instance_types")
describe_instances_paginator: DescribeInstancesPaginator = client.get_paginator("describe_instances")
describe_internet_gateways_paginator: DescribeInternetGatewaysPaginator = client.get_paginator("describe_internet_gateways")
describe_ipv6_pools_paginator: DescribeIpv6PoolsPaginator = client.get_paginator("describe_ipv6_pools")
describe_launch_template_versions_paginator: DescribeLaunchTemplateVersionsPaginator = client.get_paginator("describe_launch_template_versions")
describe_launch_templates_paginator: DescribeLaunchTemplatesPaginator = client.get_paginator("describe_launch_templates")
describe_local_gateway_route_table_virtual_interface_group_associations_paginator: DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPaginator = client.get_paginator("describe_local_gateway_route_table_virtual_interface_group_associations")
describe_local_gateway_route_table_vpc_associations_paginator: DescribeLocalGatewayRouteTableVpcAssociationsPaginator = client.get_paginator("describe_local_gateway_route_table_vpc_associations")
describe_local_gateway_route_tables_paginator: DescribeLocalGatewayRouteTablesPaginator = client.get_paginator("describe_local_gateway_route_tables")
describe_local_gateway_virtual_interface_groups_paginator: DescribeLocalGatewayVirtualInterfaceGroupsPaginator = client.get_paginator("describe_local_gateway_virtual_interface_groups")
describe_local_gateway_virtual_interfaces_paginator: DescribeLocalGatewayVirtualInterfacesPaginator = client.get_paginator("describe_local_gateway_virtual_interfaces")
describe_local_gateways_paginator: DescribeLocalGatewaysPaginator = client.get_paginator("describe_local_gateways")
describe_managed_prefix_lists_paginator: DescribeManagedPrefixListsPaginator = client.get_paginator("describe_managed_prefix_lists")
describe_moving_addresses_paginator: DescribeMovingAddressesPaginator = client.get_paginator("describe_moving_addresses")
describe_nat_gateways_paginator: DescribeNatGatewaysPaginator = client.get_paginator("describe_nat_gateways")
describe_network_acls_paginator: DescribeNetworkAclsPaginator = client.get_paginator("describe_network_acls")
describe_network_insights_analyses_paginator: DescribeNetworkInsightsAnalysesPaginator = client.get_paginator("describe_network_insights_analyses")
describe_network_insights_paths_paginator: DescribeNetworkInsightsPathsPaginator = client.get_paginator("describe_network_insights_paths")
describe_network_interface_permissions_paginator: DescribeNetworkInterfacePermissionsPaginator = client.get_paginator("describe_network_interface_permissions")
describe_network_interfaces_paginator: DescribeNetworkInterfacesPaginator = client.get_paginator("describe_network_interfaces")
describe_prefix_lists_paginator: DescribePrefixListsPaginator = client.get_paginator("describe_prefix_lists")
describe_principal_id_format_paginator: DescribePrincipalIdFormatPaginator = client.get_paginator("describe_principal_id_format")
describe_public_ipv4_pools_paginator: DescribePublicIpv4PoolsPaginator = client.get_paginator("describe_public_ipv4_pools")
describe_replace_root_volume_tasks_paginator: DescribeReplaceRootVolumeTasksPaginator = client.get_paginator("describe_replace_root_volume_tasks")
describe_reserved_instances_modifications_paginator: DescribeReservedInstancesModificationsPaginator = client.get_paginator("describe_reserved_instances_modifications")
describe_reserved_instances_offerings_paginator: DescribeReservedInstancesOfferingsPaginator = client.get_paginator("describe_reserved_instances_offerings")
describe_route_tables_paginator: DescribeRouteTablesPaginator = client.get_paginator("describe_route_tables")
describe_scheduled_instance_availability_paginator: DescribeScheduledInstanceAvailabilityPaginator = client.get_paginator("describe_scheduled_instance_availability")
describe_scheduled_instances_paginator: DescribeScheduledInstancesPaginator = client.get_paginator("describe_scheduled_instances")
describe_security_group_rules_paginator: DescribeSecurityGroupRulesPaginator = client.get_paginator("describe_security_group_rules")
describe_security_groups_paginator: DescribeSecurityGroupsPaginator = client.get_paginator("describe_security_groups")
describe_snapshots_paginator: DescribeSnapshotsPaginator = client.get_paginator("describe_snapshots")
describe_spot_fleet_instances_paginator: DescribeSpotFleetInstancesPaginator = client.get_paginator("describe_spot_fleet_instances")
describe_spot_fleet_requests_paginator: DescribeSpotFleetRequestsPaginator = client.get_paginator("describe_spot_fleet_requests")
describe_spot_instance_requests_paginator: DescribeSpotInstanceRequestsPaginator = client.get_paginator("describe_spot_instance_requests")
describe_spot_price_history_paginator: DescribeSpotPriceHistoryPaginator = client.get_paginator("describe_spot_price_history")
describe_stale_security_groups_paginator: DescribeStaleSecurityGroupsPaginator = client.get_paginator("describe_stale_security_groups")
describe_store_image_tasks_paginator: DescribeStoreImageTasksPaginator = client.get_paginator("describe_store_image_tasks")
describe_subnets_paginator: DescribeSubnetsPaginator = client.get_paginator("describe_subnets")
describe_tags_paginator: DescribeTagsPaginator = client.get_paginator("describe_tags")
describe_traffic_mirror_filters_paginator: DescribeTrafficMirrorFiltersPaginator = client.get_paginator("describe_traffic_mirror_filters")
describe_traffic_mirror_sessions_paginator: DescribeTrafficMirrorSessionsPaginator = client.get_paginator("describe_traffic_mirror_sessions")
describe_traffic_mirror_targets_paginator: DescribeTrafficMirrorTargetsPaginator = client.get_paginator("describe_traffic_mirror_targets")
describe_transit_gateway_attachments_paginator: DescribeTransitGatewayAttachmentsPaginator = client.get_paginator("describe_transit_gateway_attachments")
describe_transit_gateway_connect_peers_paginator: DescribeTransitGatewayConnectPeersPaginator = client.get_paginator("describe_transit_gateway_connect_peers")
describe_transit_gateway_connects_paginator: DescribeTransitGatewayConnectsPaginator = client.get_paginator("describe_transit_gateway_connects")
describe_transit_gateway_multicast_domains_paginator: DescribeTransitGatewayMulticastDomainsPaginator = client.get_paginator("describe_transit_gateway_multicast_domains")
describe_transit_gateway_peering_attachments_paginator: DescribeTransitGatewayPeeringAttachmentsPaginator = client.get_paginator("describe_transit_gateway_peering_attachments")
describe_transit_gateway_route_tables_paginator: DescribeTransitGatewayRouteTablesPaginator = client.get_paginator("describe_transit_gateway_route_tables")
describe_transit_gateway_vpc_attachments_paginator: DescribeTransitGatewayVpcAttachmentsPaginator = client.get_paginator("describe_transit_gateway_vpc_attachments")
describe_transit_gateways_paginator: DescribeTransitGatewaysPaginator = client.get_paginator("describe_transit_gateways")
describe_trunk_interface_associations_paginator: DescribeTrunkInterfaceAssociationsPaginator = client.get_paginator("describe_trunk_interface_associations")
describe_volume_status_paginator: DescribeVolumeStatusPaginator = client.get_paginator("describe_volume_status")
describe_volumes_paginator: DescribeVolumesPaginator = client.get_paginator("describe_volumes")
describe_volumes_modifications_paginator: DescribeVolumesModificationsPaginator = client.get_paginator("describe_volumes_modifications")
describe_vpc_classic_link_dns_support_paginator: DescribeVpcClassicLinkDnsSupportPaginator = client.get_paginator("describe_vpc_classic_link_dns_support")
describe_vpc_endpoint_connection_notifications_paginator: DescribeVpcEndpointConnectionNotificationsPaginator = client.get_paginator("describe_vpc_endpoint_connection_notifications")
describe_vpc_endpoint_connections_paginator: DescribeVpcEndpointConnectionsPaginator = client.get_paginator("describe_vpc_endpoint_connections")
describe_vpc_endpoint_service_configurations_paginator: DescribeVpcEndpointServiceConfigurationsPaginator = client.get_paginator("describe_vpc_endpoint_service_configurations")
describe_vpc_endpoint_service_permissions_paginator: DescribeVpcEndpointServicePermissionsPaginator = client.get_paginator("describe_vpc_endpoint_service_permissions")
describe_vpc_endpoint_services_paginator: DescribeVpcEndpointServicesPaginator = client.get_paginator("describe_vpc_endpoint_services")
describe_vpc_endpoints_paginator: DescribeVpcEndpointsPaginator = client.get_paginator("describe_vpc_endpoints")
describe_vpc_peering_connections_paginator: DescribeVpcPeeringConnectionsPaginator = client.get_paginator("describe_vpc_peering_connections")
describe_vpcs_paginator: DescribeVpcsPaginator = client.get_paginator("describe_vpcs")
get_associated_ipv6_pool_cidrs_paginator: GetAssociatedIpv6PoolCidrsPaginator = client.get_paginator("get_associated_ipv6_pool_cidrs")
get_groups_for_capacity_reservation_paginator: GetGroupsForCapacityReservationPaginator = client.get_paginator("get_groups_for_capacity_reservation")
get_instance_types_from_instance_requirements_paginator: GetInstanceTypesFromInstanceRequirementsPaginator = client.get_paginator("get_instance_types_from_instance_requirements")
get_managed_prefix_list_associations_paginator: GetManagedPrefixListAssociationsPaginator = client.get_paginator("get_managed_prefix_list_associations")
get_managed_prefix_list_entries_paginator: GetManagedPrefixListEntriesPaginator = client.get_paginator("get_managed_prefix_list_entries")
get_spot_placement_scores_paginator: GetSpotPlacementScoresPaginator = client.get_paginator("get_spot_placement_scores")
get_transit_gateway_attachment_propagations_paginator: GetTransitGatewayAttachmentPropagationsPaginator = client.get_paginator("get_transit_gateway_attachment_propagations")
get_transit_gateway_multicast_domain_associations_paginator: GetTransitGatewayMulticastDomainAssociationsPaginator = client.get_paginator("get_transit_gateway_multicast_domain_associations")
get_transit_gateway_prefix_list_references_paginator: GetTransitGatewayPrefixListReferencesPaginator = client.get_paginator("get_transit_gateway_prefix_list_references")
get_transit_gateway_route_table_associations_paginator: GetTransitGatewayRouteTableAssociationsPaginator = client.get_paginator("get_transit_gateway_route_table_associations")
get_transit_gateway_route_table_propagations_paginator: GetTransitGatewayRouteTablePropagationsPaginator = client.get_paginator("get_transit_gateway_route_table_propagations")
get_vpn_connection_device_types_paginator: GetVpnConnectionDeviceTypesPaginator = client.get_paginator("get_vpn_connection_device_types")
search_local_gateway_routes_paginator: SearchLocalGatewayRoutesPaginator = client.get_paginator("search_local_gateway_routes")
search_transit_gateway_multicast_groups_paginator: SearchTransitGatewayMulticastGroupsPaginator = client.get_paginator("search_transit_gateway_multicast_groups")
```

<a id="waiters-annotations"></a>

### Waiters annotations

`mypy_boto3_ec2.waiter` module contains type annotations for all waiters.

```python
from mypy_boto3_ec2 import EC2Client
from mypy_boto3_ec2.waiter import (
    BundleTaskCompleteWaiter,
    ConversionTaskCancelledWaiter,
    ConversionTaskCompletedWaiter,
    ConversionTaskDeletedWaiter,
    CustomerGatewayAvailableWaiter,
    ExportTaskCancelledWaiter,
    ExportTaskCompletedWaiter,
    ImageAvailableWaiter,
    ImageExistsWaiter,
    InstanceExistsWaiter,
    InstanceRunningWaiter,
    InstanceStatusOkWaiter,
    InstanceStoppedWaiter,
    InstanceTerminatedWaiter,
    KeyPairExistsWaiter,
    NatGatewayAvailableWaiter,
    NetworkInterfaceAvailableWaiter,
    PasswordDataAvailableWaiter,
    SecurityGroupExistsWaiter,
    SnapshotCompletedWaiter,
    SpotInstanceRequestFulfilledWaiter,
    SubnetAvailableWaiter,
    SystemStatusOkWaiter,
    VolumeAvailableWaiter,
    VolumeDeletedWaiter,
    VolumeInUseWaiter,
    VpcAvailableWaiter,
    VpcExistsWaiter,
    VpcPeeringConnectionDeletedWaiter,
    VpcPeeringConnectionExistsWaiter,
    VpnConnectionAvailableWaiter,
    VpnConnectionDeletedWaiter,
)

client: EC2Client = boto3.client("ec2")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
bundle_task_complete_waiter: BundleTaskCompleteWaiter = client.get_waiter("bundle_task_complete")
conversion_task_cancelled_waiter: ConversionTaskCancelledWaiter = client.get_waiter("conversion_task_cancelled")
conversion_task_completed_waiter: ConversionTaskCompletedWaiter = client.get_waiter("conversion_task_completed")
conversion_task_deleted_waiter: ConversionTaskDeletedWaiter = client.get_waiter("conversion_task_deleted")
customer_gateway_available_waiter: CustomerGatewayAvailableWaiter = client.get_waiter("customer_gateway_available")
export_task_cancelled_waiter: ExportTaskCancelledWaiter = client.get_waiter("export_task_cancelled")
export_task_completed_waiter: ExportTaskCompletedWaiter = client.get_waiter("export_task_completed")
image_available_waiter: ImageAvailableWaiter = client.get_waiter("image_available")
image_exists_waiter: ImageExistsWaiter = client.get_waiter("image_exists")
instance_exists_waiter: InstanceExistsWaiter = client.get_waiter("instance_exists")
instance_running_waiter: InstanceRunningWaiter = client.get_waiter("instance_running")
instance_status_ok_waiter: InstanceStatusOkWaiter = client.get_waiter("instance_status_ok")
instance_stopped_waiter: InstanceStoppedWaiter = client.get_waiter("instance_stopped")
instance_terminated_waiter: InstanceTerminatedWaiter = client.get_waiter("instance_terminated")
key_pair_exists_waiter: KeyPairExistsWaiter = client.get_waiter("key_pair_exists")
nat_gateway_available_waiter: NatGatewayAvailableWaiter = client.get_waiter("nat_gateway_available")
network_interface_available_waiter: NetworkInterfaceAvailableWaiter = client.get_waiter("network_interface_available")
password_data_available_waiter: PasswordDataAvailableWaiter = client.get_waiter("password_data_available")
security_group_exists_waiter: SecurityGroupExistsWaiter = client.get_waiter("security_group_exists")
snapshot_completed_waiter: SnapshotCompletedWaiter = client.get_waiter("snapshot_completed")
spot_instance_request_fulfilled_waiter: SpotInstanceRequestFulfilledWaiter = client.get_waiter("spot_instance_request_fulfilled")
subnet_available_waiter: SubnetAvailableWaiter = client.get_waiter("subnet_available")
system_status_ok_waiter: SystemStatusOkWaiter = client.get_waiter("system_status_ok")
volume_available_waiter: VolumeAvailableWaiter = client.get_waiter("volume_available")
volume_deleted_waiter: VolumeDeletedWaiter = client.get_waiter("volume_deleted")
volume_in_use_waiter: VolumeInUseWaiter = client.get_waiter("volume_in_use")
vpc_available_waiter: VpcAvailableWaiter = client.get_waiter("vpc_available")
vpc_exists_waiter: VpcExistsWaiter = client.get_waiter("vpc_exists")
vpc_peering_connection_deleted_waiter: VpcPeeringConnectionDeletedWaiter = client.get_waiter("vpc_peering_connection_deleted")
vpc_peering_connection_exists_waiter: VpcPeeringConnectionExistsWaiter = client.get_waiter("vpc_peering_connection_exists")
vpn_connection_available_waiter: VpnConnectionAvailableWaiter = client.get_waiter("vpn_connection_available")
vpn_connection_deleted_waiter: VpnConnectionDeletedWaiter = client.get_waiter("vpn_connection_deleted")
```

<a id="service-resource-annotations"></a>

### Service Resource annotations

`EC2ServiceResource` provides annotations for `boto3.resource("ec2")`.

```python
from mypy_boto3_ec2 import EC2ServiceResource

resource: EC2ServiceResource = boto3.resource("ec2")

# now resource usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_resource: EC2ServiceResource = session.resource("ec2")
```

<a id="other-resources-annotations"></a>

### Other resources annotations

`mypy_boto3_ec2.service_resource` module contains type annotations for all
resources.

```python
from mypy_boto3_ec2 import EC2ServiceResource
from mypy_boto3_ec2.service_resource import (
    ClassicAddress,
    DhcpOptions,
    Image,
    Instance,
    InternetGateway,
    KeyPair,
    KeyPairInfo,
    NetworkAcl,
    NetworkInterface,
    NetworkInterfaceAssociation,
    PlacementGroup,
    Route,
    RouteTable,
    RouteTableAssociation,
    SecurityGroup,
    Snapshot,
    Subnet,
    Tag,
    Volume,
    Vpc,
    VpcPeeringConnection,
    VpcAddress,
)

resource: EC2ServiceResource = boto3.resource("ec2")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
my_classic_address: ClassicAddress = resource.ClassicAddress(...)
my_dhcp_options: DhcpOptions = resource.DhcpOptions(...)
my_image: Image = resource.Image(...)
my_instance: Instance = resource.Instance(...)
my_internet_gateway: InternetGateway = resource.InternetGateway(...)
my_key_pair: KeyPair = resource.KeyPair(...)
my_key_pair_info: KeyPairInfo = resource.KeyPairInfo(...)
my_network_acl: NetworkAcl = resource.NetworkAcl(...)
my_network_interface: NetworkInterface = resource.NetworkInterface(...)
my_network_interface_association: NetworkInterfaceAssociation = resource.NetworkInterfaceAssociation(...)
my_placement_group: PlacementGroup = resource.PlacementGroup(...)
my_route: Route = resource.Route(...)
my_route_table: RouteTable = resource.RouteTable(...)
my_route_table_association: RouteTableAssociation = resource.RouteTableAssociation(...)
my_security_group: SecurityGroup = resource.SecurityGroup(...)
my_snapshot: Snapshot = resource.Snapshot(...)
my_subnet: Subnet = resource.Subnet(...)
my_tag: Tag = resource.Tag(...)
my_volume: Volume = resource.Volume(...)
my_vpc: Vpc = resource.Vpc(...)
my_vpc_peering_connection: VpcPeeringConnection = resource.VpcPeeringConnection(...)
my_vpc_address: VpcAddress = resource.VpcAddress(...)
```

<a id="collections-annotations"></a>

### Collections annotations

`mypy_boto3_ec2.service_resource` module contains type annotations for all
`EC2ServiceResource` collections.

```python
from mypy_boto3_ec2 import EC2ServiceResource
from mypy_boto3_ec2.service_resource import (
    ServiceResourceClassicAddressesCollection,
    ServiceResourceDhcpOptionsSetsCollection,
    ServiceResourceImagesCollection,
    ServiceResourceInstancesCollection,
    ServiceResourceInternetGatewaysCollection,
    ServiceResourceKeyPairsCollection,
    ServiceResourceNetworkAclsCollection,
    ServiceResourceNetworkInterfacesCollection,
    ServiceResourcePlacementGroupsCollection,
    ServiceResourceRouteTablesCollection,
    ServiceResourceSecurityGroupsCollection,
    ServiceResourceSnapshotsCollection,
    ServiceResourceSubnetsCollection,
    ServiceResourceVolumesCollection,
    ServiceResourceVpcAddressesCollection,
    ServiceResourceVpcPeeringConnectionsCollection,
    ServiceResourceVpcsCollection,
)

resource: EC2ServiceResource = boto3.resource("ec2")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
classic_addresses: ec2_resources.ServiceResourceClassicAddressesCollection = resource.classic_addresses
dhcp_options_sets: ec2_resources.ServiceResourceDhcpOptionsSetsCollection = resource.dhcp_options_sets
images: ec2_resources.ServiceResourceImagesCollection = resource.images
instances: ec2_resources.ServiceResourceInstancesCollection = resource.instances
internet_gateways: ec2_resources.ServiceResourceInternetGatewaysCollection = resource.internet_gateways
key_pairs: ec2_resources.ServiceResourceKeyPairsCollection = resource.key_pairs
network_acls: ec2_resources.ServiceResourceNetworkAclsCollection = resource.network_acls
network_interfaces: ec2_resources.ServiceResourceNetworkInterfacesCollection = resource.network_interfaces
placement_groups: ec2_resources.ServiceResourcePlacementGroupsCollection = resource.placement_groups
route_tables: ec2_resources.ServiceResourceRouteTablesCollection = resource.route_tables
security_groups: ec2_resources.ServiceResourceSecurityGroupsCollection = resource.security_groups
snapshots: ec2_resources.ServiceResourceSnapshotsCollection = resource.snapshots
subnets: ec2_resources.ServiceResourceSubnetsCollection = resource.subnets
volumes: ec2_resources.ServiceResourceVolumesCollection = resource.volumes
vpc_addresses: ec2_resources.ServiceResourceVpcAddressesCollection = resource.vpc_addresses
vpc_peering_connections: ec2_resources.ServiceResourceVpcPeeringConnectionsCollection = resource.vpc_peering_connections
vpcs: ec2_resources.ServiceResourceVpcsCollection = resource.vpcs
```

<a id="literals"></a>

### Literals

`mypy_boto3_ec2.literals` module contains literals extracted from shapes that
can be used in user code for type checking.

```python
from mypy_boto3_ec2.literals import (
    AcceleratorManufacturerType,
    AcceleratorNameType,
    AcceleratorTypeType,
    AccountAttributeNameType,
    ActivityStatusType,
    AddressAttributeNameType,
    AffinityType,
    AllocationStateType,
    AllocationStrategyType,
    AllowsMultipleInstanceTypesType,
    AnalysisStatusType,
    ApplianceModeSupportValueType,
    ArchitectureTypeType,
    ArchitectureValuesType,
    AssociatedNetworkTypeType,
    AssociationStatusCodeType,
    AttachmentStatusType,
    AutoAcceptSharedAssociationsValueType,
    AutoAcceptSharedAttachmentsValueType,
    AutoPlacementType,
    AvailabilityZoneOptInStatusType,
    AvailabilityZoneStateType,
    BareMetalType,
    BatchStateType,
    BgpStatusType,
    BootModeTypeType,
    BootModeValuesType,
    BundleTaskCompleteWaiterName,
    BundleTaskStateType,
    BurstablePerformanceType,
    ByoipCidrStateType,
    CancelBatchErrorCodeType,
    CancelSpotInstanceRequestStateType,
    CapacityReservationFleetStateType,
    CapacityReservationInstancePlatformType,
    CapacityReservationPreferenceType,
    CapacityReservationStateType,
    CapacityReservationTenancyType,
    CarrierGatewayStateType,
    ClientCertificateRevocationListStatusCodeType,
    ClientVpnAuthenticationTypeType,
    ClientVpnAuthorizationRuleStatusCodeType,
    ClientVpnConnectionStatusCodeType,
    ClientVpnEndpointAttributeStatusCodeType,
    ClientVpnEndpointStatusCodeType,
    ClientVpnRouteStatusCodeType,
    ConnectionNotificationStateType,
    ConnectionNotificationTypeType,
    ConnectivityTypeType,
    ContainerFormatType,
    ConversionTaskCancelledWaiterName,
    ConversionTaskCompletedWaiterName,
    ConversionTaskDeletedWaiterName,
    ConversionTaskStateType,
    CopyTagsFromSourceType,
    CpuManufacturerType,
    CurrencyCodeValuesType,
    CustomerGatewayAvailableWaiterName,
    DatafeedSubscriptionStateType,
    DefaultRouteTableAssociationValueType,
    DefaultRouteTablePropagationValueType,
    DefaultTargetCapacityTypeType,
    DeleteFleetErrorCodeType,
    DeleteQueuedReservedInstancesErrorCodeType,
    DescribeAddressesAttributePaginatorName,
    DescribeByoipCidrsPaginatorName,
    DescribeCapacityReservationFleetsPaginatorName,
    DescribeCapacityReservationsPaginatorName,
    DescribeCarrierGatewaysPaginatorName,
    DescribeClassicLinkInstancesPaginatorName,
    DescribeClientVpnAuthorizationRulesPaginatorName,
    DescribeClientVpnConnectionsPaginatorName,
    DescribeClientVpnEndpointsPaginatorName,
    DescribeClientVpnRoutesPaginatorName,
    DescribeClientVpnTargetNetworksPaginatorName,
    DescribeCoipPoolsPaginatorName,
    DescribeDhcpOptionsPaginatorName,
    DescribeEgressOnlyInternetGatewaysPaginatorName,
    DescribeExportImageTasksPaginatorName,
    DescribeFastSnapshotRestoresPaginatorName,
    DescribeFleetsPaginatorName,
    DescribeFlowLogsPaginatorName,
    DescribeFpgaImagesPaginatorName,
    DescribeHostReservationOfferingsPaginatorName,
    DescribeHostReservationsPaginatorName,
    DescribeHostsPaginatorName,
    DescribeIamInstanceProfileAssociationsPaginatorName,
    DescribeImportImageTasksPaginatorName,
    DescribeImportSnapshotTasksPaginatorName,
    DescribeInstanceCreditSpecificationsPaginatorName,
    DescribeInstanceEventWindowsPaginatorName,
    DescribeInstanceStatusPaginatorName,
    DescribeInstanceTypeOfferingsPaginatorName,
    DescribeInstanceTypesPaginatorName,
    DescribeInstancesPaginatorName,
    DescribeInternetGatewaysPaginatorName,
    DescribeIpv6PoolsPaginatorName,
    DescribeLaunchTemplateVersionsPaginatorName,
    DescribeLaunchTemplatesPaginatorName,
    DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsPaginatorName,
    DescribeLocalGatewayRouteTableVpcAssociationsPaginatorName,
    DescribeLocalGatewayRouteTablesPaginatorName,
    DescribeLocalGatewayVirtualInterfaceGroupsPaginatorName,
    DescribeLocalGatewayVirtualInterfacesPaginatorName,
    DescribeLocalGatewaysPaginatorName,
    DescribeManagedPrefixListsPaginatorName,
    DescribeMovingAddressesPaginatorName,
    DescribeNatGatewaysPaginatorName,
    DescribeNetworkAclsPaginatorName,
    DescribeNetworkInsightsAnalysesPaginatorName,
    DescribeNetworkInsightsPathsPaginatorName,
    DescribeNetworkInterfacePermissionsPaginatorName,
    DescribeNetworkInterfacesPaginatorName,
    DescribePrefixListsPaginatorName,
    DescribePrincipalIdFormatPaginatorName,
    DescribePublicIpv4PoolsPaginatorName,
    DescribeReplaceRootVolumeTasksPaginatorName,
    DescribeReservedInstancesModificationsPaginatorName,
    DescribeReservedInstancesOfferingsPaginatorName,
    DescribeRouteTablesPaginatorName,
    DescribeScheduledInstanceAvailabilityPaginatorName,
    DescribeScheduledInstancesPaginatorName,
    DescribeSecurityGroupRulesPaginatorName,
    DescribeSecurityGroupsPaginatorName,
    DescribeSnapshotsPaginatorName,
    DescribeSpotFleetInstancesPaginatorName,
    DescribeSpotFleetRequestsPaginatorName,
    DescribeSpotInstanceRequestsPaginatorName,
    DescribeSpotPriceHistoryPaginatorName,
    DescribeStaleSecurityGroupsPaginatorName,
    DescribeStoreImageTasksPaginatorName,
    DescribeSubnetsPaginatorName,
    DescribeTagsPaginatorName,
    DescribeTrafficMirrorFiltersPaginatorName,
    DescribeTrafficMirrorSessionsPaginatorName,
    DescribeTrafficMirrorTargetsPaginatorName,
    DescribeTransitGatewayAttachmentsPaginatorName,
    DescribeTransitGatewayConnectPeersPaginatorName,
    DescribeTransitGatewayConnectsPaginatorName,
    DescribeTransitGatewayMulticastDomainsPaginatorName,
    DescribeTransitGatewayPeeringAttachmentsPaginatorName,
    DescribeTransitGatewayRouteTablesPaginatorName,
    DescribeTransitGatewayVpcAttachmentsPaginatorName,
    DescribeTransitGatewaysPaginatorName,
    DescribeTrunkInterfaceAssociationsPaginatorName,
    DescribeVolumeStatusPaginatorName,
    DescribeVolumesModificationsPaginatorName,
    DescribeVolumesPaginatorName,
    DescribeVpcClassicLinkDnsSupportPaginatorName,
    DescribeVpcEndpointConnectionNotificationsPaginatorName,
    DescribeVpcEndpointConnectionsPaginatorName,
    DescribeVpcEndpointServiceConfigurationsPaginatorName,
    DescribeVpcEndpointServicePermissionsPaginatorName,
    DescribeVpcEndpointServicesPaginatorName,
    DescribeVpcEndpointsPaginatorName,
    DescribeVpcPeeringConnectionsPaginatorName,
    DescribeVpcsPaginatorName,
    DestinationFileFormatType,
    DeviceTypeType,
    DiskImageFormatType,
    DiskTypeType,
    DnsNameStateType,
    DnsSupportValueType,
    DomainTypeType,
    EbsEncryptionSupportType,
    EbsNvmeSupportType,
    EbsOptimizedSupportType,
    ElasticGpuStateType,
    ElasticGpuStatusType,
    EnaSupportType,
    EndDateTypeType,
    EphemeralNvmeSupportType,
    EventCodeType,
    EventTypeType,
    ExcessCapacityTerminationPolicyType,
    ExportEnvironmentType,
    ExportTaskCancelledWaiterName,
    ExportTaskCompletedWaiterName,
    ExportTaskStateType,
    FastSnapshotRestoreStateCodeType,
    FleetActivityStatusType,
    FleetCapacityReservationTenancyType,
    FleetCapacityReservationUsageStrategyType,
    FleetEventTypeType,
    FleetExcessCapacityTerminationPolicyType,
    FleetInstanceMatchCriteriaType,
    FleetOnDemandAllocationStrategyType,
    FleetReplacementStrategyType,
    FleetStateCodeType,
    FleetTypeType,
    FlowLogsResourceTypeType,
    FpgaImageAttributeNameType,
    FpgaImageStateCodeType,
    GatewayAssociationStateType,
    GatewayTypeType,
    GetAssociatedIpv6PoolCidrsPaginatorName,
    GetGroupsForCapacityReservationPaginatorName,
    GetInstanceTypesFromInstanceRequirementsPaginatorName,
    GetManagedPrefixListAssociationsPaginatorName,
    GetManagedPrefixListEntriesPaginatorName,
    GetSpotPlacementScoresPaginatorName,
    GetTransitGatewayAttachmentPropagationsPaginatorName,
    GetTransitGatewayMulticastDomainAssociationsPaginatorName,
    GetTransitGatewayPrefixListReferencesPaginatorName,
    GetTransitGatewayRouteTableAssociationsPaginatorName,
    GetTransitGatewayRouteTablePropagationsPaginatorName,
    GetVpnConnectionDeviceTypesPaginatorName,
    HostRecoveryType,
    HostTenancyType,
    HostnameTypeType,
    HttpTokensStateType,
    HypervisorTypeType,
    IamInstanceProfileAssociationStateType,
    Igmpv2SupportValueType,
    ImageAttributeNameType,
    ImageAvailableWaiterName,
    ImageExistsWaiterName,
    ImageStateType,
    ImageTypeValuesType,
    InstanceAttributeNameType,
    InstanceEventWindowStateType,
    InstanceExistsWaiterName,
    InstanceGenerationType,
    InstanceHealthStatusType,
    InstanceInterruptionBehaviorType,
    InstanceLifecycleType,
    InstanceLifecycleTypeType,
    InstanceMatchCriteriaType,
    InstanceMetadataEndpointStateType,
    InstanceMetadataOptionsStateType,
    InstanceMetadataProtocolStateType,
    InstanceRunningWaiterName,
    InstanceStateNameType,
    InstanceStatusOkWaiterName,
    InstanceStoppedWaiterName,
    InstanceStorageEncryptionSupportType,
    InstanceTerminatedWaiterName,
    InstanceTypeHypervisorType,
    InstanceTypeType,
    InterfacePermissionTypeType,
    InterfaceProtocolTypeType,
    Ipv6SupportValueType,
    KeyPairExistsWaiterName,
    KeyTypeType,
    LaunchTemplateErrorCodeType,
    LaunchTemplateHttpTokensStateType,
    LaunchTemplateInstanceMetadataEndpointStateType,
    LaunchTemplateInstanceMetadataOptionsStateType,
    LaunchTemplateInstanceMetadataProtocolIpv6Type,
    ListingStateType,
    ListingStatusType,
    LocalGatewayRouteStateType,
    LocalGatewayRouteTypeType,
    LocalStorageType,
    LocalStorageTypeType,
    LocationTypeType,
    LogDestinationTypeType,
    MarketTypeType,
    MembershipTypeType,
    ModifyAvailabilityZoneOptInStatusType,
    MonitoringStateType,
    MoveStatusType,
    MulticastSupportValueType,
    NatGatewayAvailableWaiterName,
    NatGatewayStateType,
    NetworkInterfaceAttributeType,
    NetworkInterfaceAvailableWaiterName,
    NetworkInterfaceCreationTypeType,
    NetworkInterfacePermissionStateCodeType,
    NetworkInterfaceStatusType,
    NetworkInterfaceTypeType,
    OfferingClassTypeType,
    OfferingTypeValuesType,
    OnDemandAllocationStrategyType,
    OperationTypeType,
    PartitionLoadFrequencyType,
    PasswordDataAvailableWaiterName,
    PaymentOptionType,
    PermissionGroupType,
    PlacementGroupStateType,
    PlacementGroupStrategyType,
    PlacementStrategyType,
    PlatformValuesType,
    PrefixListStateType,
    PrincipalTypeType,
    ProductCodeValuesType,
    ProtocolType,
    ProtocolValueType,
    RIProductDescriptionType,
    RecurringChargeFrequencyType,
    ReplaceRootVolumeTaskStateType,
    ReplacementStrategyType,
    ReportInstanceReasonCodesType,
    ReportStatusTypeType,
    ReservationStateType,
    ReservedInstanceStateType,
    ResetFpgaImageAttributeNameType,
    ResetImageAttributeNameType,
    ResourceTypeType,
    RootDeviceTypeType,
    RouteOriginType,
    RouteStateType,
    RouteTableAssociationStateCodeType,
    RuleActionType,
    SearchLocalGatewayRoutesPaginatorName,
    SearchTransitGatewayMulticastGroupsPaginatorName,
    SecurityGroupExistsWaiterName,
    SelfServicePortalType,
    ServiceStateType,
    ServiceTypeType,
    ShutdownBehaviorType,
    SnapshotAttributeNameType,
    SnapshotCompletedWaiterName,
    SnapshotStateType,
    SpotAllocationStrategyType,
    SpotInstanceInterruptionBehaviorType,
    SpotInstanceRequestFulfilledWaiterName,
    SpotInstanceStateType,
    SpotInstanceTypeType,
    StateType,
    StaticSourcesSupportValueType,
    StatusNameType,
    StatusType,
    StatusTypeType,
    SubnetAvailableWaiterName,
    SubnetCidrBlockStateCodeType,
    SubnetCidrReservationTypeType,
    SubnetStateType,
    SummaryStatusType,
    SystemStatusOkWaiterName,
    TargetCapacityUnitTypeType,
    TelemetryStatusType,
    TenancyType,
    TrafficDirectionType,
    TrafficMirrorFilterRuleFieldType,
    TrafficMirrorNetworkServiceType,
    TrafficMirrorRuleActionType,
    TrafficMirrorSessionFieldType,
    TrafficMirrorTargetTypeType,
    TrafficTypeType,
    TransitGatewayAssociationStateType,
    TransitGatewayAttachmentResourceTypeType,
    TransitGatewayAttachmentStateType,
    TransitGatewayConnectPeerStateType,
    TransitGatewayMulitcastDomainAssociationStateType,
    TransitGatewayMulticastDomainStateType,
    TransitGatewayPrefixListReferenceStateType,
    TransitGatewayPropagationStateType,
    TransitGatewayRouteStateType,
    TransitGatewayRouteTableStateType,
    TransitGatewayRouteTypeType,
    TransitGatewayStateType,
    TransportProtocolType,
    TunnelInsideIpVersionType,
    UnlimitedSupportedInstanceFamilyType,
    UnsuccessfulInstanceCreditSpecificationErrorCodeType,
    UsageClassTypeType,
    VirtualizationTypeType,
    VolumeAttachmentStateType,
    VolumeAttributeNameType,
    VolumeAvailableWaiterName,
    VolumeDeletedWaiterName,
    VolumeInUseWaiterName,
    VolumeModificationStateType,
    VolumeStateType,
    VolumeStatusInfoStatusType,
    VolumeStatusNameType,
    VolumeTypeType,
    VpcAttributeNameType,
    VpcAvailableWaiterName,
    VpcCidrBlockStateCodeType,
    VpcEndpointTypeType,
    VpcExistsWaiterName,
    VpcPeeringConnectionDeletedWaiterName,
    VpcPeeringConnectionExistsWaiterName,
    VpcPeeringConnectionStateReasonCodeType,
    VpcStateType,
    VpcTenancyType,
    VpnConnectionAvailableWaiterName,
    VpnConnectionDeletedWaiterName,
    VpnEcmpSupportValueType,
    VpnProtocolType,
    VpnStateType,
    VpnStaticRouteSourceType,
    WeekDayType,
    scopeType,
    ServiceName,
    PaginatorName,
    WaiterName,
)

def check_value(value: AcceleratorManufacturerType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_ec2.type_defs` module contains structures and shapes assembled to
typed dictionaries for additional type checking.

```python
from mypy_boto3_ec2.type_defs import (
    AcceleratorCountRequestTypeDef,
    AcceleratorCountTypeDef,
    AcceleratorTotalMemoryMiBRequestTypeDef,
    AcceleratorTotalMemoryMiBTypeDef,
    AcceptReservedInstancesExchangeQuoteRequestRequestTypeDef,
    AcceptReservedInstancesExchangeQuoteResultTypeDef,
    AcceptTransitGatewayMulticastDomainAssociationsRequestRequestTypeDef,
    AcceptTransitGatewayMulticastDomainAssociationsResultTypeDef,
    AcceptTransitGatewayPeeringAttachmentRequestRequestTypeDef,
    AcceptTransitGatewayPeeringAttachmentResultTypeDef,
    AcceptTransitGatewayVpcAttachmentRequestRequestTypeDef,
    AcceptTransitGatewayVpcAttachmentResultTypeDef,
    AcceptVpcEndpointConnectionsRequestRequestTypeDef,
    AcceptVpcEndpointConnectionsResultTypeDef,
    AcceptVpcPeeringConnectionRequestRequestTypeDef,
    AcceptVpcPeeringConnectionRequestVpcPeeringConnectionTypeDef,
    AcceptVpcPeeringConnectionResultTypeDef,
    AccountAttributeTypeDef,
    AccountAttributeValueTypeDef,
    ActiveInstanceTypeDef,
    AddPrefixListEntryTypeDef,
    AddressAttributeTypeDef,
    AddressTypeDef,
    AdvertiseByoipCidrRequestRequestTypeDef,
    AdvertiseByoipCidrResultTypeDef,
    AllocateAddressRequestRequestTypeDef,
    AllocateAddressResultTypeDef,
    AllocateHostsRequestRequestTypeDef,
    AllocateHostsResultTypeDef,
    AllowedPrincipalTypeDef,
    AlternatePathHintTypeDef,
    AnalysisAclRuleTypeDef,
    AnalysisComponentTypeDef,
    AnalysisLoadBalancerListenerTypeDef,
    AnalysisLoadBalancerTargetTypeDef,
    AnalysisPacketHeaderTypeDef,
    AnalysisRouteTableRouteTypeDef,
    AnalysisSecurityGroupRuleTypeDef,
    ApplySecurityGroupsToClientVpnTargetNetworkRequestRequestTypeDef,
    ApplySecurityGroupsToClientVpnTargetNetworkResultTypeDef,
    AssignIpv6AddressesRequestRequestTypeDef,
    AssignIpv6AddressesResultTypeDef,
    AssignPrivateIpAddressesRequestNetworkInterfaceTypeDef,
    AssignPrivateIpAddressesRequestRequestTypeDef,
    AssignPrivateIpAddressesResultTypeDef,
    AssignedPrivateIpAddressTypeDef,
    AssociateAddressRequestClassicAddressTypeDef,
    AssociateAddressRequestRequestTypeDef,
    AssociateAddressRequestVpcAddressTypeDef,
    AssociateAddressResultTypeDef,
    AssociateClientVpnTargetNetworkRequestRequestTypeDef,
    AssociateClientVpnTargetNetworkResultTypeDef,
    AssociateDhcpOptionsRequestDhcpOptionsTypeDef,
    AssociateDhcpOptionsRequestRequestTypeDef,
    AssociateDhcpOptionsRequestVpcTypeDef,
    AssociateEnclaveCertificateIamRoleRequestRequestTypeDef,
    AssociateEnclaveCertificateIamRoleResultTypeDef,
    AssociateIamInstanceProfileRequestRequestTypeDef,
    AssociateIamInstanceProfileResultTypeDef,
    AssociateInstanceEventWindowRequestRequestTypeDef,
    AssociateInstanceEventWindowResultTypeDef,
    AssociateRouteTableRequestRequestTypeDef,
    AssociateRouteTableRequestRouteTableTypeDef,
    AssociateRouteTableResultTypeDef,
    AssociateSubnetCidrBlockRequestRequestTypeDef,
    AssociateSubnetCidrBlockResultTypeDef,
    AssociateTransitGatewayMulticastDomainRequestRequestTypeDef,
    AssociateTransitGatewayMulticastDomainResultTypeDef,
    AssociateTransitGatewayRouteTableRequestRequestTypeDef,
    AssociateTransitGatewayRouteTableResultTypeDef,
    AssociateTrunkInterfaceRequestRequestTypeDef,
    AssociateTrunkInterfaceResultTypeDef,
    AssociateVpcCidrBlockRequestRequestTypeDef,
    AssociateVpcCidrBlockResultTypeDef,
    AssociatedRoleTypeDef,
    AssociatedTargetNetworkTypeDef,
    AssociationStatusTypeDef,
    AthenaIntegrationTypeDef,
    AttachClassicLinkVpcRequestInstanceTypeDef,
    AttachClassicLinkVpcRequestRequestTypeDef,
    AttachClassicLinkVpcRequestVpcTypeDef,
    AttachClassicLinkVpcResultTypeDef,
    AttachInternetGatewayRequestInternetGatewayTypeDef,
    AttachInternetGatewayRequestRequestTypeDef,
    AttachInternetGatewayRequestVpcTypeDef,
    AttachNetworkInterfaceRequestNetworkInterfaceTypeDef,
    AttachNetworkInterfaceRequestRequestTypeDef,
    AttachNetworkInterfaceResultTypeDef,
    AttachVolumeRequestInstanceTypeDef,
    AttachVolumeRequestRequestTypeDef,
    AttachVolumeRequestVolumeTypeDef,
    AttachVpnGatewayRequestRequestTypeDef,
    AttachVpnGatewayResultTypeDef,
    AttributeBooleanValueTypeDef,
    AttributeValueTypeDef,
    AuthorizationRuleTypeDef,
    AuthorizeClientVpnIngressRequestRequestTypeDef,
    AuthorizeClientVpnIngressResultTypeDef,
    AuthorizeSecurityGroupEgressRequestRequestTypeDef,
    AuthorizeSecurityGroupEgressRequestSecurityGroupTypeDef,
    AuthorizeSecurityGroupEgressResultTypeDef,
    AuthorizeSecurityGroupIngressRequestRequestTypeDef,
    AuthorizeSecurityGroupIngressRequestSecurityGroupTypeDef,
    AuthorizeSecurityGroupIngressResultTypeDef,
    AvailabilityZoneMessageTypeDef,
    AvailabilityZoneTypeDef,
    AvailableCapacityTypeDef,
    BaselineEbsBandwidthMbpsRequestTypeDef,
    BaselineEbsBandwidthMbpsTypeDef,
    BlobAttributeValueTypeDef,
    BlockDeviceMappingTypeDef,
    BundleInstanceRequestRequestTypeDef,
    BundleInstanceResultTypeDef,
    BundleTaskErrorTypeDef,
    BundleTaskTypeDef,
    ByoipCidrTypeDef,
    CancelBundleTaskRequestRequestTypeDef,
    CancelBundleTaskResultTypeDef,
    CancelCapacityReservationFleetErrorTypeDef,
    CancelCapacityReservationFleetsRequestRequestTypeDef,
    CancelCapacityReservationFleetsResultTypeDef,
    CancelCapacityReservationRequestRequestTypeDef,
    CancelCapacityReservationResultTypeDef,
    CancelConversionRequestRequestTypeDef,
    CancelExportTaskRequestRequestTypeDef,
    CancelImportTaskRequestRequestTypeDef,
    CancelImportTaskResultTypeDef,
    CancelReservedInstancesListingRequestRequestTypeDef,
    CancelReservedInstancesListingResultTypeDef,
    CancelSpotFleetRequestsErrorItemTypeDef,
    CancelSpotFleetRequestsErrorTypeDef,
    CancelSpotFleetRequestsRequestRequestTypeDef,
    CancelSpotFleetRequestsResponseTypeDef,
    CancelSpotFleetRequestsSuccessItemTypeDef,
    CancelSpotInstanceRequestsRequestRequestTypeDef,
    CancelSpotInstanceRequestsResultTypeDef,
    CancelledSpotInstanceRequestTypeDef,
    CapacityReservationFleetCancellationStateTypeDef,
    CapacityReservationFleetTypeDef,
    CapacityReservationGroupTypeDef,
    CapacityReservationOptionsRequestTypeDef,
    CapacityReservationOptionsTypeDef,
    CapacityReservationSpecificationResponseTypeDef,
    CapacityReservationSpecificationTypeDef,
    CapacityReservationTargetResponseTypeDef,
    CapacityReservationTargetTypeDef,
    CapacityReservationTypeDef,
    CarrierGatewayTypeDef,
    CertificateAuthenticationRequestTypeDef,
    CertificateAuthenticationTypeDef,
    CidrAuthorizationContextTypeDef,
    CidrBlockTypeDef,
    ClassicLinkDnsSupportTypeDef,
    ClassicLinkInstanceTypeDef,
    ClassicLoadBalancerTypeDef,
    ClassicLoadBalancersConfigTypeDef,
    ClientCertificateRevocationListStatusTypeDef,
    ClientConnectOptionsTypeDef,
    ClientConnectResponseOptionsTypeDef,
    ClientDataTypeDef,
    ClientVpnAuthenticationRequestTypeDef,
    ClientVpnAuthenticationTypeDef,
    ClientVpnAuthorizationRuleStatusTypeDef,
    ClientVpnConnectionStatusTypeDef,
    ClientVpnConnectionTypeDef,
    ClientVpnEndpointAttributeStatusTypeDef,
    ClientVpnEndpointStatusTypeDef,
    ClientVpnEndpointTypeDef,
    ClientVpnRouteStatusTypeDef,
    ClientVpnRouteTypeDef,
    CoipAddressUsageTypeDef,
    CoipPoolTypeDef,
    ConfirmProductInstanceRequestRequestTypeDef,
    ConfirmProductInstanceResultTypeDef,
    ConnectionLogOptionsTypeDef,
    ConnectionLogResponseOptionsTypeDef,
    ConnectionNotificationTypeDef,
    ConversionTaskTypeDef,
    CopyFpgaImageRequestRequestTypeDef,
    CopyFpgaImageResultTypeDef,
    CopyImageRequestRequestTypeDef,
    CopyImageResultTypeDef,
    CopySnapshotRequestRequestTypeDef,
    CopySnapshotRequestSnapshotTypeDef,
    CopySnapshotResultTypeDef,
    CpuOptionsRequestTypeDef,
    CpuOptionsTypeDef,
    CreateCapacityReservationFleetRequestRequestTypeDef,
    CreateCapacityReservationFleetResultTypeDef,
    CreateCapacityReservationRequestRequestTypeDef,
    CreateCapacityReservationResultTypeDef,
    CreateCarrierGatewayRequestRequestTypeDef,
    CreateCarrierGatewayResultTypeDef,
    CreateClientVpnEndpointRequestRequestTypeDef,
    CreateClientVpnEndpointResultTypeDef,
    CreateClientVpnRouteRequestRequestTypeDef,
    CreateClientVpnRouteResultTypeDef,
    CreateCustomerGatewayRequestRequestTypeDef,
    CreateCustomerGatewayResultTypeDef,
    CreateDefaultSubnetRequestRequestTypeDef,
    CreateDefaultSubnetResultTypeDef,
    CreateDefaultVpcRequestRequestTypeDef,
    CreateDefaultVpcResultTypeDef,
    CreateDhcpOptionsRequestRequestTypeDef,
    CreateDhcpOptionsRequestServiceResourceTypeDef,
    CreateDhcpOptionsResultTypeDef,
    CreateEgressOnlyInternetGatewayRequestRequestTypeDef,
    CreateEgressOnlyInternetGatewayResultTypeDef,
    CreateFleetErrorTypeDef,
    CreateFleetInstanceTypeDef,
    CreateFleetRequestRequestTypeDef,
    CreateFleetResultTypeDef,
    CreateFlowLogsRequestRequestTypeDef,
    CreateFlowLogsResultTypeDef,
    CreateFpgaImageRequestRequestTypeDef,
    CreateFpgaImageResultTypeDef,
    CreateImageRequestInstanceTypeDef,
    CreateImageRequestRequestTypeDef,
    CreateImageResultTypeDef,
    CreateInstanceEventWindowRequestRequestTypeDef,
    CreateInstanceEventWindowResultTypeDef,
    CreateInstanceExportTaskRequestRequestTypeDef,
    CreateInstanceExportTaskResultTypeDef,
    CreateInternetGatewayRequestRequestTypeDef,
    CreateInternetGatewayRequestServiceResourceTypeDef,
    CreateInternetGatewayResultTypeDef,
    CreateKeyPairRequestRequestTypeDef,
    CreateKeyPairRequestServiceResourceTypeDef,
    CreateLaunchTemplateRequestRequestTypeDef,
    CreateLaunchTemplateResultTypeDef,
    CreateLaunchTemplateVersionRequestRequestTypeDef,
    CreateLaunchTemplateVersionResultTypeDef,
    CreateLocalGatewayRouteRequestRequestTypeDef,
    CreateLocalGatewayRouteResultTypeDef,
    CreateLocalGatewayRouteTableVpcAssociationRequestRequestTypeDef,
    CreateLocalGatewayRouteTableVpcAssociationResultTypeDef,
    CreateManagedPrefixListRequestRequestTypeDef,
    CreateManagedPrefixListResultTypeDef,
    CreateNatGatewayRequestRequestTypeDef,
    CreateNatGatewayResultTypeDef,
    CreateNetworkAclEntryRequestNetworkAclTypeDef,
    CreateNetworkAclEntryRequestRequestTypeDef,
    CreateNetworkAclRequestRequestTypeDef,
    CreateNetworkAclRequestServiceResourceTypeDef,
    CreateNetworkAclRequestVpcTypeDef,
    CreateNetworkAclResultTypeDef,
    CreateNetworkInsightsPathRequestRequestTypeDef,
    CreateNetworkInsightsPathResultTypeDef,
    CreateNetworkInterfacePermissionRequestRequestTypeDef,
    CreateNetworkInterfacePermissionResultTypeDef,
    CreateNetworkInterfaceRequestRequestTypeDef,
    CreateNetworkInterfaceRequestServiceResourceTypeDef,
    CreateNetworkInterfaceRequestSubnetTypeDef,
    CreateNetworkInterfaceResultTypeDef,
    CreatePlacementGroupRequestRequestTypeDef,
    CreatePlacementGroupRequestServiceResourceTypeDef,
    CreatePlacementGroupResultTypeDef,
    CreateReplaceRootVolumeTaskRequestRequestTypeDef,
    CreateReplaceRootVolumeTaskResultTypeDef,
    CreateReservedInstancesListingRequestRequestTypeDef,
    CreateReservedInstancesListingResultTypeDef,
    CreateRestoreImageTaskRequestRequestTypeDef,
    CreateRestoreImageTaskResultTypeDef,
    CreateRouteRequestRequestTypeDef,
    CreateRouteRequestRouteTableTypeDef,
    CreateRouteResultTypeDef,
    CreateRouteTableRequestRequestTypeDef,
    CreateRouteTableRequestServiceResourceTypeDef,
    CreateRouteTableRequestVpcTypeDef,
    CreateRouteTableResultTypeDef,
    CreateSecurityGroupRequestRequestTypeDef,
    CreateSecurityGroupRequestServiceResourceTypeDef,
    CreateSecurityGroupRequestVpcTypeDef,
    CreateSecurityGroupResultTypeDef,
    CreateSnapshotRequestRequestTypeDef,
    CreateSnapshotRequestServiceResourceTypeDef,
    CreateSnapshotRequestVolumeTypeDef,
    CreateSnapshotsRequestRequestTypeDef,
    CreateSnapshotsResultTypeDef,
    CreateSpotDatafeedSubscriptionRequestRequestTypeDef,
    CreateSpotDatafeedSubscriptionResultTypeDef,
    CreateStoreImageTaskRequestRequestTypeDef,
    CreateStoreImageTaskResultTypeDef,
    CreateSubnetCidrReservationRequestRequestTypeDef,
    CreateSubnetCidrReservationResultTypeDef,
    CreateSubnetRequestRequestTypeDef,
    CreateSubnetRequestServiceResourceTypeDef,
    CreateSubnetRequestVpcTypeDef,
    CreateSubnetResultTypeDef,
    CreateTagsRequestDhcpOptionsTypeDef,
    CreateTagsRequestImageTypeDef,
    CreateTagsRequestInstanceTypeDef,
    CreateTagsRequestInternetGatewayTypeDef,
    CreateTagsRequestNetworkAclTypeDef,
    CreateTagsRequestNetworkInterfaceTypeDef,
    CreateTagsRequestRequestTypeDef,
    CreateTagsRequestRouteTableTypeDef,
    CreateTagsRequestSecurityGroupTypeDef,
    CreateTagsRequestServiceResourceTypeDef,
    CreateTagsRequestSnapshotTypeDef,
    CreateTagsRequestSubnetTypeDef,
    CreateTagsRequestVolumeTypeDef,
    CreateTagsRequestVpcTypeDef,
    CreateTrafficMirrorFilterRequestRequestTypeDef,
    CreateTrafficMirrorFilterResultTypeDef,
    CreateTrafficMirrorFilterRuleRequestRequestTypeDef,
    CreateTrafficMirrorFilterRuleResultTypeDef,
    CreateTrafficMirrorSessionRequestRequestTypeDef,
    CreateTrafficMirrorSessionResultTypeDef,
    CreateTrafficMirrorTargetRequestRequestTypeDef,
    CreateTrafficMirrorTargetResultTypeDef,
    CreateTransitGatewayConnectPeerRequestRequestTypeDef,
    CreateTransitGatewayConnectPeerResultTypeDef,
    CreateTransitGatewayConnectRequestOptionsTypeDef,
    CreateTransitGatewayConnectRequestRequestTypeDef,
    CreateTransitGatewayConnectResultTypeDef,
    CreateTransitGatewayMulticastDomainRequestOptionsTypeDef,
    CreateTransitGatewayMulticastDomainRequestRequestTypeDef,
    CreateTransitGatewayMulticastDomainResultTypeDef,
    CreateTransitGatewayPeeringAttachmentRequestRequestTypeDef,
    CreateTransitGatewayPeeringAttachmentResultTypeDef,
    CreateTransitGatewayPrefixListReferenceRequestRequestTypeDef,
    CreateTransitGatewayPrefixListReferenceResultTypeDef,
    CreateTransitGatewayRequestRequestTypeDef,
    CreateTransitGatewayResultTypeDef,
    CreateTransitGatewayRouteRequestRequestTypeDef,
    CreateTransitGatewayRouteResultTypeDef,
    CreateTransitGatewayRouteTableRequestRequestTypeDef,
    CreateTransitGatewayRouteTableResultTypeDef,
    CreateTransitGatewayVpcAttachmentRequestOptionsTypeDef,
    CreateTransitGatewayVpcAttachmentRequestRequestTypeDef,
    CreateTransitGatewayVpcAttachmentResultTypeDef,
    CreateVolumePermissionModificationsTypeDef,
    CreateVolumePermissionTypeDef,
    CreateVolumeRequestRequestTypeDef,
    CreateVolumeRequestServiceResourceTypeDef,
    CreateVpcEndpointConnectionNotificationRequestRequestTypeDef,
    CreateVpcEndpointConnectionNotificationResultTypeDef,
    CreateVpcEndpointRequestRequestTypeDef,
    CreateVpcEndpointResultTypeDef,
    CreateVpcEndpointServiceConfigurationRequestRequestTypeDef,
    CreateVpcEndpointServiceConfigurationResultTypeDef,
    CreateVpcPeeringConnectionRequestRequestTypeDef,
    CreateVpcPeeringConnectionRequestServiceResourceTypeDef,
    CreateVpcPeeringConnectionRequestVpcTypeDef,
    CreateVpcPeeringConnectionResultTypeDef,
    CreateVpcRequestRequestTypeDef,
    CreateVpcRequestServiceResourceTypeDef,
    CreateVpcResultTypeDef,
    CreateVpnConnectionRequestRequestTypeDef,
    CreateVpnConnectionResultTypeDef,
    CreateVpnConnectionRouteRequestRequestTypeDef,
    CreateVpnGatewayRequestRequestTypeDef,
    CreateVpnGatewayResultTypeDef,
    CreditSpecificationRequestTypeDef,
    CreditSpecificationTypeDef,
    CustomerGatewayTypeDef,
    DeleteCarrierGatewayRequestRequestTypeDef,
    DeleteCarrierGatewayResultTypeDef,
    DeleteClientVpnEndpointRequestRequestTypeDef,
    DeleteClientVpnEndpointResultTypeDef,
    DeleteClientVpnRouteRequestRequestTypeDef,
    DeleteClientVpnRouteResultTypeDef,
    DeleteCustomerGatewayRequestRequestTypeDef,
    DeleteDhcpOptionsRequestDhcpOptionsTypeDef,
    DeleteDhcpOptionsRequestRequestTypeDef,
    DeleteEgressOnlyInternetGatewayRequestRequestTypeDef,
    DeleteEgressOnlyInternetGatewayResultTypeDef,
    DeleteFleetErrorItemTypeDef,
    DeleteFleetErrorTypeDef,
    DeleteFleetSuccessItemTypeDef,
    DeleteFleetsRequestRequestTypeDef,
    DeleteFleetsResultTypeDef,
    DeleteFlowLogsRequestRequestTypeDef,
    DeleteFlowLogsResultTypeDef,
    DeleteFpgaImageRequestRequestTypeDef,
    DeleteFpgaImageResultTypeDef,
    DeleteInstanceEventWindowRequestRequestTypeDef,
    DeleteInstanceEventWindowResultTypeDef,
    DeleteInternetGatewayRequestInternetGatewayTypeDef,
    DeleteInternetGatewayRequestRequestTypeDef,
    DeleteKeyPairRequestKeyPairInfoTypeDef,
    DeleteKeyPairRequestKeyPairTypeDef,
    DeleteKeyPairRequestRequestTypeDef,
    DeleteLaunchTemplateRequestRequestTypeDef,
    DeleteLaunchTemplateResultTypeDef,
    DeleteLaunchTemplateVersionsRequestRequestTypeDef,
    DeleteLaunchTemplateVersionsResponseErrorItemTypeDef,
    DeleteLaunchTemplateVersionsResponseSuccessItemTypeDef,
    DeleteLaunchTemplateVersionsResultTypeDef,
    DeleteLocalGatewayRouteRequestRequestTypeDef,
    DeleteLocalGatewayRouteResultTypeDef,
    DeleteLocalGatewayRouteTableVpcAssociationRequestRequestTypeDef,
    DeleteLocalGatewayRouteTableVpcAssociationResultTypeDef,
    DeleteManagedPrefixListRequestRequestTypeDef,
    DeleteManagedPrefixListResultTypeDef,
    DeleteNatGatewayRequestRequestTypeDef,
    DeleteNatGatewayResultTypeDef,
    DeleteNetworkAclEntryRequestNetworkAclTypeDef,
    DeleteNetworkAclEntryRequestRequestTypeDef,
    DeleteNetworkAclRequestNetworkAclTypeDef,
    DeleteNetworkAclRequestRequestTypeDef,
    DeleteNetworkInsightsAnalysisRequestRequestTypeDef,
    DeleteNetworkInsightsAnalysisResultTypeDef,
    DeleteNetworkInsightsPathRequestRequestTypeDef,
    DeleteNetworkInsightsPathResultTypeDef,
    DeleteNetworkInterfacePermissionRequestRequestTypeDef,
    DeleteNetworkInterfacePermissionResultTypeDef,
    DeleteNetworkInterfaceRequestNetworkInterfaceTypeDef,
    DeleteNetworkInterfaceRequestRequestTypeDef,
    DeletePlacementGroupRequestPlacementGroupTypeDef,
    DeletePlacementGroupRequestRequestTypeDef,
    DeleteQueuedReservedInstancesErrorTypeDef,
    DeleteQueuedReservedInstancesRequestRequestTypeDef,
    DeleteQueuedReservedInstancesResultTypeDef,
    DeleteRouteRequestRequestTypeDef,
    DeleteRouteRequestRouteTypeDef,
    DeleteRouteTableRequestRequestTypeDef,
    DeleteRouteTableRequestRouteTableTypeDef,
    DeleteSecurityGroupRequestRequestTypeDef,
    DeleteSecurityGroupRequestSecurityGroupTypeDef,
    DeleteSnapshotRequestRequestTypeDef,
    DeleteSnapshotRequestSnapshotTypeDef,
    DeleteSpotDatafeedSubscriptionRequestRequestTypeDef,
    DeleteSubnetCidrReservationRequestRequestTypeDef,
    DeleteSubnetCidrReservationResultTypeDef,
    DeleteSubnetRequestRequestTypeDef,
    DeleteSubnetRequestSubnetTypeDef,
    DeleteTagsRequestRequestTypeDef,
    DeleteTagsRequestTagTypeDef,
    DeleteTrafficMirrorFilterRequestRequestTypeDef,
    DeleteTrafficMirrorFilterResultTypeDef,
    DeleteTrafficMirrorFilterRuleRequestRequestTypeDef,
    DeleteTrafficMirrorFilterRuleResultTypeDef,
    DeleteTrafficMirrorSessionRequestRequestTypeDef,
    DeleteTrafficMirrorSessionResultTypeDef,
    DeleteTrafficMirrorTargetRequestRequestTypeDef,
    DeleteTrafficMirrorTargetResultTypeDef,
    DeleteTransitGatewayConnectPeerRequestRequestTypeDef,
    DeleteTransitGatewayConnectPeerResultTypeDef,
    DeleteTransitGatewayConnectRequestRequestTypeDef,
    DeleteTransitGatewayConnectResultTypeDef,
    DeleteTransitGatewayMulticastDomainRequestRequestTypeDef,
    DeleteTransitGatewayMulticastDomainResultTypeDef,
    DeleteTransitGatewayPeeringAttachmentRequestRequestTypeDef,
    DeleteTransitGatewayPeeringAttachmentResultTypeDef,
    DeleteTransitGatewayPrefixListReferenceRequestRequestTypeDef,
    DeleteTransitGatewayPrefixListReferenceResultTypeDef,
    DeleteTransitGatewayRequestRequestTypeDef,
    DeleteTransitGatewayResultTypeDef,
    DeleteTransitGatewayRouteRequestRequestTypeDef,
    DeleteTransitGatewayRouteResultTypeDef,
    DeleteTransitGatewayRouteTableRequestRequestTypeDef,
    DeleteTransitGatewayRouteTableResultTypeDef,
    DeleteTransitGatewayVpcAttachmentRequestRequestTypeDef,
    DeleteTransitGatewayVpcAttachmentResultTypeDef,
    DeleteVolumeRequestRequestTypeDef,
    DeleteVolumeRequestVolumeTypeDef,
    DeleteVpcEndpointConnectionNotificationsRequestRequestTypeDef,
    DeleteVpcEndpointConnectionNotificationsResultTypeDef,
    DeleteVpcEndpointServiceConfigurationsRequestRequestTypeDef,
    DeleteVpcEndpointServiceConfigurationsResultTypeDef,
    DeleteVpcEndpointsRequestRequestTypeDef,
    DeleteVpcEndpointsResultTypeDef,
    DeleteVpcPeeringConnectionRequestRequestTypeDef,
    DeleteVpcPeeringConnectionRequestVpcPeeringConnectionTypeDef,
    DeleteVpcPeeringConnectionResultTypeDef,
    DeleteVpcRequestRequestTypeDef,
    DeleteVpcRequestVpcTypeDef,
    DeleteVpnConnectionRequestRequestTypeDef,
    DeleteVpnConnectionRouteRequestRequestTypeDef,
    DeleteVpnGatewayRequestRequestTypeDef,
    DeprovisionByoipCidrRequestRequestTypeDef,
    DeprovisionByoipCidrResultTypeDef,
    DeregisterImageRequestImageTypeDef,
    DeregisterImageRequestRequestTypeDef,
    DeregisterInstanceEventNotificationAttributesRequestRequestTypeDef,
    DeregisterInstanceEventNotificationAttributesResultTypeDef,
    DeregisterInstanceTagAttributeRequestTypeDef,
    DeregisterTransitGatewayMulticastGroupMembersRequestRequestTypeDef,
    DeregisterTransitGatewayMulticastGroupMembersResultTypeDef,
    DeregisterTransitGatewayMulticastGroupSourcesRequestRequestTypeDef,
    DeregisterTransitGatewayMulticastGroupSourcesResultTypeDef,
    DescribeAccountAttributesRequestRequestTypeDef,
    DescribeAccountAttributesResultTypeDef,
    DescribeAddressesAttributeRequestRequestTypeDef,
    DescribeAddressesAttributeResultTypeDef,
    DescribeAddressesRequestRequestTypeDef,
    DescribeAddressesResultTypeDef,
    DescribeAggregateIdFormatRequestRequestTypeDef,
    DescribeAggregateIdFormatResultTypeDef,
    DescribeAvailabilityZonesRequestRequestTypeDef,
    DescribeAvailabilityZonesResultTypeDef,
    DescribeBundleTasksRequestRequestTypeDef,
    DescribeBundleTasksResultTypeDef,
    DescribeByoipCidrsRequestRequestTypeDef,
    DescribeByoipCidrsResultTypeDef,
    DescribeCapacityReservationFleetsRequestRequestTypeDef,
    DescribeCapacityReservationFleetsResultTypeDef,
    DescribeCapacityReservationsRequestRequestTypeDef,
    DescribeCapacityReservationsResultTypeDef,
    DescribeCarrierGatewaysRequestRequestTypeDef,
    DescribeCarrierGatewaysResultTypeDef,
    DescribeClassicLinkInstancesRequestRequestTypeDef,
    DescribeClassicLinkInstancesResultTypeDef,
    DescribeClientVpnAuthorizationRulesRequestRequestTypeDef,
    DescribeClientVpnAuthorizationRulesResultTypeDef,
    DescribeClientVpnConnectionsRequestRequestTypeDef,
    DescribeClientVpnConnectionsResultTypeDef,
    DescribeClientVpnEndpointsRequestRequestTypeDef,
    DescribeClientVpnEndpointsResultTypeDef,
    DescribeClientVpnRoutesRequestRequestTypeDef,
    DescribeClientVpnRoutesResultTypeDef,
    DescribeClientVpnTargetNetworksRequestRequestTypeDef,
    DescribeClientVpnTargetNetworksResultTypeDef,
    DescribeCoipPoolsRequestRequestTypeDef,
    DescribeCoipPoolsResultTypeDef,
    DescribeConversionTasksRequestRequestTypeDef,
    DescribeConversionTasksResultTypeDef,
    DescribeCustomerGatewaysRequestRequestTypeDef,
    DescribeCustomerGatewaysResultTypeDef,
    DescribeDhcpOptionsRequestRequestTypeDef,
    DescribeDhcpOptionsResultTypeDef,
    DescribeEgressOnlyInternetGatewaysRequestRequestTypeDef,
    DescribeEgressOnlyInternetGatewaysResultTypeDef,
    DescribeElasticGpusRequestRequestTypeDef,
    DescribeElasticGpusResultTypeDef,
    DescribeExportImageTasksRequestRequestTypeDef,
    DescribeExportImageTasksResultTypeDef,
    DescribeExportTasksRequestRequestTypeDef,
    DescribeExportTasksResultTypeDef,
    DescribeFastSnapshotRestoreSuccessItemTypeDef,
    DescribeFastSnapshotRestoresRequestRequestTypeDef,
    DescribeFastSnapshotRestoresResultTypeDef,
    DescribeFleetErrorTypeDef,
    DescribeFleetHistoryRequestRequestTypeDef,
    DescribeFleetHistoryResultTypeDef,
    DescribeFleetInstancesRequestRequestTypeDef,
    DescribeFleetInstancesResultTypeDef,
    DescribeFleetsInstancesTypeDef,
    DescribeFleetsRequestRequestTypeDef,
    DescribeFleetsResultTypeDef,
    DescribeFlowLogsRequestRequestTypeDef,
    DescribeFlowLogsResultTypeDef,
    DescribeFpgaImageAttributeRequestRequestTypeDef,
    DescribeFpgaImageAttributeResultTypeDef,
    DescribeFpgaImagesRequestRequestTypeDef,
    DescribeFpgaImagesResultTypeDef,
    DescribeHostReservationOfferingsRequestRequestTypeDef,
    DescribeHostReservationOfferingsResultTypeDef,
    DescribeHostReservationsRequestRequestTypeDef,
    DescribeHostReservationsResultTypeDef,
    DescribeHostsRequestRequestTypeDef,
    DescribeHostsResultTypeDef,
    DescribeIamInstanceProfileAssociationsRequestRequestTypeDef,
    DescribeIamInstanceProfileAssociationsResultTypeDef,
    DescribeIdFormatRequestRequestTypeDef,
    DescribeIdFormatResultTypeDef,
    DescribeIdentityIdFormatRequestRequestTypeDef,
    DescribeIdentityIdFormatResultTypeDef,
    DescribeImageAttributeRequestImageTypeDef,
    DescribeImageAttributeRequestRequestTypeDef,
    DescribeImagesRequestRequestTypeDef,
    DescribeImagesResultTypeDef,
    DescribeImportImageTasksRequestRequestTypeDef,
    DescribeImportImageTasksResultTypeDef,
    DescribeImportSnapshotTasksRequestRequestTypeDef,
    DescribeImportSnapshotTasksResultTypeDef,
    DescribeInstanceAttributeRequestInstanceTypeDef,
    DescribeInstanceAttributeRequestRequestTypeDef,
    DescribeInstanceCreditSpecificationsRequestRequestTypeDef,
    DescribeInstanceCreditSpecificationsResultTypeDef,
    DescribeInstanceEventNotificationAttributesRequestRequestTypeDef,
    DescribeInstanceEventNotificationAttributesResultTypeDef,
    DescribeInstanceEventWindowsRequestRequestTypeDef,
    DescribeInstanceEventWindowsResultTypeDef,
    DescribeInstanceStatusRequestRequestTypeDef,
    DescribeInstanceStatusResultTypeDef,
    DescribeInstanceTypeOfferingsRequestRequestTypeDef,
    DescribeInstanceTypeOfferingsResultTypeDef,
    DescribeInstanceTypesRequestRequestTypeDef,
    DescribeInstanceTypesResultTypeDef,
    DescribeInstancesRequestRequestTypeDef,
    DescribeInstancesResultTypeDef,
    DescribeInternetGatewaysRequestRequestTypeDef,
    DescribeInternetGatewaysResultTypeDef,
    DescribeIpv6PoolsRequestRequestTypeDef,
    DescribeIpv6PoolsResultTypeDef,
    DescribeKeyPairsRequestRequestTypeDef,
    DescribeKeyPairsResultTypeDef,
    DescribeLaunchTemplateVersionsRequestRequestTypeDef,
    DescribeLaunchTemplateVersionsResultTypeDef,
    DescribeLaunchTemplatesRequestRequestTypeDef,
    DescribeLaunchTemplatesResultTypeDef,
    DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsRequestRequestTypeDef,
    DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociationsResultTypeDef,
    DescribeLocalGatewayRouteTableVpcAssociationsRequestRequestTypeDef,
    DescribeLocalGatewayRouteTableVpcAssociationsResultTypeDef,
    DescribeLocalGatewayRouteTablesRequestRequestTypeDef,
    DescribeLocalGatewayRouteTablesResultTypeDef,
    DescribeLocalGatewayVirtualInterfaceGroupsRequestRequestTypeDef,
    DescribeLocalGatewayVirtualInterfaceGroupsResultTypeDef,
    DescribeLocalGatewayVirtualInterfacesRequestRequestTypeDef,
    DescribeLocalGatewayVirtualInterfacesResultTypeDef,
    DescribeLocalGatewaysRequestRequestTypeDef,
    DescribeLocalGatewaysResultTypeDef,
    DescribeManagedPrefixListsRequestRequestTypeDef,
    DescribeManagedPrefixListsResultTypeDef,
    DescribeMovingAddressesRequestRequestTypeDef,
    DescribeMovingAddressesResultTypeDef,
    DescribeNatGatewaysRequestRequestTypeDef,
    DescribeNatGatewaysResultTypeDef,
    DescribeNetworkAclsRequestRequestTypeDef,
    DescribeNetworkAclsResultTypeDef,
    DescribeNetworkInsightsAnalysesRequestRequestTypeDef,
    DescribeNetworkInsightsAnalysesResultTypeDef,
    DescribeNetworkInsightsPathsRequestRequestTypeDef,
    DescribeNetworkInsightsPathsResultTypeDef,
    DescribeNetworkInterfaceAttributeRequestNetworkInterfaceTypeDef,
    DescribeNetworkInterfaceAttributeRequestRequestTypeDef,
    DescribeNetworkInterfaceAttributeResultTypeDef,
    DescribeNetworkInterfacePermissionsRequestRequestTypeDef,
    DescribeNetworkInterfacePermissionsResultTypeDef,
    DescribeNetworkInterfacesRequestRequestTypeDef,
    DescribeNetworkInterfacesResultTypeDef,
    DescribePlacementGroupsRequestRequestTypeDef,
    DescribePlacementGroupsResultTypeDef,
    DescribePrefixListsRequestRequestTypeDef,
    DescribePrefixListsResultTypeDef,
    DescribePrincipalIdFormatRequestRequestTypeDef,
    DescribePrincipalIdFormatResultTypeDef,
    DescribePublicIpv4PoolsRequestRequestTypeDef,
    DescribePublicIpv4PoolsResultTypeDef,
    DescribeRegionsRequestRequestTypeDef,
    DescribeRegionsResultTypeDef,
    DescribeReplaceRootVolumeTasksRequestRequestTypeDef,
    DescribeReplaceRootVolumeTasksResultTypeDef,
    DescribeReservedInstancesListingsRequestRequestTypeDef,
    DescribeReservedInstancesListingsResultTypeDef,
    DescribeReservedInstancesModificationsRequestRequestTypeDef,
    DescribeReservedInstancesModificationsResultTypeDef,
    DescribeReservedInstancesOfferingsRequestRequestTypeDef,
    DescribeReservedInstancesOfferingsResultTypeDef,
    DescribeReservedInstancesRequestRequestTypeDef,
    DescribeReservedInstancesResultTypeDef,
    DescribeRouteTablesRequestRequestTypeDef,
    DescribeRouteTablesResultTypeDef,
    DescribeScheduledInstanceAvailabilityRequestRequestTypeDef,
    DescribeScheduledInstanceAvailabilityResultTypeDef,
    DescribeScheduledInstancesRequestRequestTypeDef,
    DescribeScheduledInstancesResultTypeDef,
    DescribeSecurityGroupReferencesRequestRequestTypeDef,
    DescribeSecurityGroupReferencesResultTypeDef,
    DescribeSecurityGroupRulesRequestRequestTypeDef,
    DescribeSecurityGroupRulesResultTypeDef,
    DescribeSecurityGroupsRequestRequestTypeDef,
    DescribeSecurityGroupsResultTypeDef,
    DescribeSnapshotAttributeRequestRequestTypeDef,
    DescribeSnapshotAttributeRequestSnapshotTypeDef,
    DescribeSnapshotAttributeResultTypeDef,
    DescribeSnapshotsRequestRequestTypeDef,
    DescribeSnapshotsResultTypeDef,
    DescribeSpotDatafeedSubscriptionRequestRequestTypeDef,
    DescribeSpotDatafeedSubscriptionResultTypeDef,
    DescribeSpotFleetInstancesRequestRequestTypeDef,
    DescribeSpotFleetInstancesResponseTypeDef,
    DescribeSpotFleetRequestHistoryRequestRequestTypeDef,
    DescribeSpotFleetRequestHistoryResponseTypeDef,
    DescribeSpotFleetRequestsRequestRequestTypeDef,
    DescribeSpotFleetRequestsResponseTypeDef,
    DescribeSpotInstanceRequestsRequestRequestTypeDef,
    DescribeSpotInstanceRequestsResultTypeDef,
    DescribeSpotPriceHistoryRequestRequestTypeDef,
    DescribeSpotPriceHistoryResultTypeDef,
    DescribeStaleSecurityGroupsRequestRequestTypeDef,
    DescribeStaleSecurityGroupsResultTypeDef,
    DescribeStoreImageTasksRequestRequestTypeDef,
    DescribeStoreImageTasksResultTypeDef,
    DescribeSubnetsRequestRequestTypeDef,
    DescribeSubnetsResultTypeDef,
    DescribeTagsRequestRequestTypeDef,
    DescribeTagsResultTypeDef,
    DescribeTrafficMirrorFiltersRequestRequestTypeDef,
    DescribeTrafficMirrorFiltersResultTypeDef,
    DescribeTrafficMirrorSessionsRequestRequestTypeDef,
    DescribeTrafficMirrorSessionsResultTypeDef,
    DescribeTrafficMirrorTargetsRequestRequestTypeDef,
    DescribeTrafficMirrorTargetsResultTypeDef,
    DescribeTransitGatewayAttachmentsRequestRequestTypeDef,
    DescribeTransitGatewayAttachmentsResultTypeDef,
    DescribeTransitGatewayConnectPeersRequestRequestTypeDef,
    DescribeTransitGatewayConnectPeersResultTypeDef,
    DescribeTransitGatewayConnectsRequestRequestTypeDef,
    DescribeTransitGatewayConnectsResultTypeDef,
    DescribeTransitGatewayMulticastDomainsRequestRequestTypeDef,
    DescribeTransitGatewayMulticastDomainsResultTypeDef,
    DescribeTransitGatewayPeeringAttachmentsRequestRequestTypeDef,
    DescribeTransitGatewayPeeringAttachmentsResultTypeDef,
    DescribeTransitGatewayRouteTablesRequestRequestTypeDef,
    DescribeTransitGatewayRouteTablesResultTypeDef,
    DescribeTransitGatewayVpcAttachmentsRequestRequestTypeDef,
    DescribeTransitGatewayVpcAttachmentsResultTypeDef,
    DescribeTransitGatewaysRequestRequestTypeDef,
    DescribeTransitGatewaysResultTypeDef,
    DescribeTrunkInterfaceAssociationsRequestRequestTypeDef,
    DescribeTrunkInterfaceAssociationsResultTypeDef,
    DescribeVolumeAttributeRequestRequestTypeDef,
    DescribeVolumeAttributeRequestVolumeTypeDef,
    DescribeVolumeAttributeResultTypeDef,
    DescribeVolumeStatusRequestRequestTypeDef,
    DescribeVolumeStatusRequestVolumeTypeDef,
    DescribeVolumeStatusResultTypeDef,
    DescribeVolumesModificationsRequestRequestTypeDef,
    DescribeVolumesModificationsResultTypeDef,
    DescribeVolumesRequestRequestTypeDef,
    DescribeVolumesResultTypeDef,
    DescribeVpcAttributeRequestRequestTypeDef,
    DescribeVpcAttributeRequestVpcTypeDef,
    DescribeVpcAttributeResultTypeDef,
    DescribeVpcClassicLinkDnsSupportRequestRequestTypeDef,
    DescribeVpcClassicLinkDnsSupportResultTypeDef,
    DescribeVpcClassicLinkRequestRequestTypeDef,
    DescribeVpcClassicLinkResultTypeDef,
    DescribeVpcEndpointConnectionNotificationsRequestRequestTypeDef,
    DescribeVpcEndpointConnectionNotificationsResultTypeDef,
    DescribeVpcEndpointConnectionsRequestRequestTypeDef,
    DescribeVpcEndpointConnectionsResultTypeDef,
    DescribeVpcEndpointServiceConfigurationsRequestRequestTypeDef,
    DescribeVpcEndpointServiceConfigurationsResultTypeDef,
    DescribeVpcEndpointServicePermissionsRequestRequestTypeDef,
    DescribeVpcEndpointServicePermissionsResultTypeDef,
    DescribeVpcEndpointServicesRequestRequestTypeDef,
    DescribeVpcEndpointServicesResultTypeDef,
    DescribeVpcEndpointsRequestRequestTypeDef,
    DescribeVpcEndpointsResultTypeDef,
    DescribeVpcPeeringConnectionsRequestRequestTypeDef,
    DescribeVpcPeeringConnectionsResultTypeDef,
    DescribeVpcsRequestRequestTypeDef,
    DescribeVpcsResultTypeDef,
    DescribeVpnConnectionsRequestRequestTypeDef,
    DescribeVpnConnectionsResultTypeDef,
    DescribeVpnGatewaysRequestRequestTypeDef,
    DescribeVpnGatewaysResultTypeDef,
    DestinationOptionsRequestTypeDef,
    DestinationOptionsResponseTypeDef,
    DetachClassicLinkVpcRequestInstanceTypeDef,
    DetachClassicLinkVpcRequestRequestTypeDef,
    DetachClassicLinkVpcRequestVpcTypeDef,
    DetachClassicLinkVpcResultTypeDef,
    DetachInternetGatewayRequestInternetGatewayTypeDef,
    DetachInternetGatewayRequestRequestTypeDef,
    DetachInternetGatewayRequestVpcTypeDef,
    DetachNetworkInterfaceRequestNetworkInterfaceTypeDef,
    DetachNetworkInterfaceRequestRequestTypeDef,
    DetachVolumeRequestInstanceTypeDef,
    DetachVolumeRequestRequestTypeDef,
    DetachVolumeRequestVolumeTypeDef,
    DetachVpnGatewayRequestRequestTypeDef,
    DhcpConfigurationTypeDef,
    DhcpOptionsTypeDef,
    DirectoryServiceAuthenticationRequestTypeDef,
    DirectoryServiceAuthenticationTypeDef,
    DisableEbsEncryptionByDefaultRequestRequestTypeDef,
    DisableEbsEncryptionByDefaultResultTypeDef,
    DisableFastSnapshotRestoreErrorItemTypeDef,
    DisableFastSnapshotRestoreStateErrorItemTypeDef,
    DisableFastSnapshotRestoreStateErrorTypeDef,
    DisableFastSnapshotRestoreSuccessItemTypeDef,
    DisableFastSnapshotRestoresRequestRequestTypeDef,
    DisableFastSnapshotRestoresResultTypeDef,
    DisableImageDeprecationRequestRequestTypeDef,
    DisableImageDeprecationResultTypeDef,
    DisableSerialConsoleAccessRequestRequestTypeDef,
    DisableSerialConsoleAccessResultTypeDef,
    DisableTransitGatewayRouteTablePropagationRequestRequestTypeDef,
    DisableTransitGatewayRouteTablePropagationResultTypeDef,
    DisableVgwRoutePropagationRequestRequestTypeDef,
    DisableVpcClassicLinkDnsSupportRequestRequestTypeDef,
    DisableVpcClassicLinkDnsSupportResultTypeDef,
    DisableVpcClassicLinkRequestRequestTypeDef,
    DisableVpcClassicLinkRequestVpcTypeDef,
    DisableVpcClassicLinkResultTypeDef,
    DisassociateAddressRequestClassicAddressTypeDef,
    DisassociateAddressRequestNetworkInterfaceAssociationTypeDef,
    DisassociateAddressRequestRequestTypeDef,
    DisassociateClientVpnTargetNetworkRequestRequestTypeDef,
    DisassociateClientVpnTargetNetworkResultTypeDef,
    DisassociateEnclaveCertificateIamRoleRequestRequestTypeDef,
    DisassociateEnclaveCertificateIamRoleResultTypeDef,
    DisassociateIamInstanceProfileRequestRequestTypeDef,
    DisassociateIamInstanceProfileResultTypeDef,
    DisassociateInstanceEventWindowRequestRequestTypeDef,
    DisassociateInstanceEventWindowResultTypeDef,
    DisassociateRouteTableRequestRequestTypeDef,
    DisassociateRouteTableRequestRouteTableAssociationTypeDef,
    DisassociateRouteTableRequestServiceResourceTypeDef,
    DisassociateSubnetCidrBlockRequestRequestTypeDef,
    DisassociateSubnetCidrBlockResultTypeDef,
    DisassociateTransitGatewayMulticastDomainRequestRequestTypeDef,
    DisassociateTransitGatewayMulticastDomainResultTypeDef,
    DisassociateTransitGatewayRouteTableRequestRequestTypeDef,
    DisassociateTransitGatewayRouteTableResultTypeDef,
    DisassociateTrunkInterfaceRequestRequestTypeDef,
    DisassociateTrunkInterfaceResultTypeDef,
    DisassociateVpcCidrBlockRequestRequestTypeDef,
    DisassociateVpcCidrBlockResultTypeDef,
    DiskImageDescriptionTypeDef,
    DiskImageDetailTypeDef,
    DiskImageTypeDef,
    DiskImageVolumeDescriptionTypeDef,
    DiskInfoTypeDef,
    DnsEntryTypeDef,
    DnsServersOptionsModifyStructureTypeDef,
    EbsBlockDeviceTypeDef,
    EbsInfoTypeDef,
    EbsInstanceBlockDeviceSpecificationTypeDef,
    EbsInstanceBlockDeviceTypeDef,
    EbsOptimizedInfoTypeDef,
    EfaInfoTypeDef,
    EgressOnlyInternetGatewayTypeDef,
    ElasticGpuAssociationTypeDef,
    ElasticGpuHealthTypeDef,
    ElasticGpuSpecificationResponseTypeDef,
    ElasticGpuSpecificationTypeDef,
    ElasticGpusTypeDef,
    ElasticInferenceAcceleratorAssociationTypeDef,
    ElasticInferenceAcceleratorTypeDef,
    EnableEbsEncryptionByDefaultRequestRequestTypeDef,
    EnableEbsEncryptionByDefaultResultTypeDef,
    EnableFastSnapshotRestoreErrorItemTypeDef,
    EnableFastSnapshotRestoreStateErrorItemTypeDef,
    EnableFastSnapshotRestoreStateErrorTypeDef,
    EnableFastSnapshotRestoreSuccessItemTypeDef,
    EnableFastSnapshotRestoresRequestRequestTypeDef,
    EnableFastSnapshotRestoresResultTypeDef,
    EnableImageDeprecationRequestRequestTypeDef,
    EnableImageDeprecationResultTypeDef,
    EnableSerialConsoleAccessRequestRequestTypeDef,
    EnableSerialConsoleAccessResultTypeDef,
    EnableTransitGatewayRouteTablePropagationRequestRequestTypeDef,
    EnableTransitGatewayRouteTablePropagationResultTypeDef,
    EnableVgwRoutePropagationRequestRequestTypeDef,
    EnableVolumeIORequestRequestTypeDef,
    EnableVolumeIORequestVolumeTypeDef,
    EnableVpcClassicLinkDnsSupportRequestRequestTypeDef,
    EnableVpcClassicLinkDnsSupportResultTypeDef,
    EnableVpcClassicLinkRequestRequestTypeDef,
    EnableVpcClassicLinkRequestVpcTypeDef,
    EnableVpcClassicLinkResultTypeDef,
    EnclaveOptionsRequestTypeDef,
    EnclaveOptionsTypeDef,
    EventInformationTypeDef,
    ExplanationTypeDef,
    ExportClientVpnClientCertificateRevocationListRequestRequestTypeDef,
    ExportClientVpnClientCertificateRevocationListResultTypeDef,
    ExportClientVpnClientConfigurationRequestRequestTypeDef,
    ExportClientVpnClientConfigurationResultTypeDef,
    ExportImageRequestRequestTypeDef,
    ExportImageResultTypeDef,
    ExportImageTaskTypeDef,
    ExportTaskS3LocationRequestTypeDef,
    ExportTaskS3LocationTypeDef,
    ExportTaskTypeDef,
    ExportToS3TaskSpecificationTypeDef,
    ExportToS3TaskTypeDef,
    ExportTransitGatewayRoutesRequestRequestTypeDef,
    ExportTransitGatewayRoutesResultTypeDef,
    FailedCapacityReservationFleetCancellationResultTypeDef,
    FailedQueuedPurchaseDeletionTypeDef,
    FederatedAuthenticationRequestTypeDef,
    FederatedAuthenticationTypeDef,
    FilterTypeDef,
    FleetCapacityReservationTypeDef,
    FleetDataTypeDef,
    FleetLaunchTemplateConfigRequestTypeDef,
    FleetLaunchTemplateConfigTypeDef,
    FleetLaunchTemplateOverridesRequestTypeDef,
    FleetLaunchTemplateOverridesTypeDef,
    FleetLaunchTemplateSpecificationRequestTypeDef,
    FleetLaunchTemplateSpecificationTypeDef,
    FleetSpotCapacityRebalanceRequestTypeDef,
    FleetSpotCapacityRebalanceTypeDef,
    FleetSpotMaintenanceStrategiesRequestTypeDef,
    FleetSpotMaintenanceStrategiesTypeDef,
    FlowLogTypeDef,
    FpgaDeviceInfoTypeDef,
    FpgaDeviceMemoryInfoTypeDef,
    FpgaImageAttributeTypeDef,
    FpgaImageStateTypeDef,
    FpgaImageTypeDef,
    FpgaInfoTypeDef,
    GetAssociatedEnclaveCertificateIamRolesRequestRequestTypeDef,
    GetAssociatedEnclaveCertificateIamRolesResultTypeDef,
    GetAssociatedIpv6PoolCidrsRequestRequestTypeDef,
    GetAssociatedIpv6PoolCidrsResultTypeDef,
    GetCapacityReservationUsageRequestRequestTypeDef,
    GetCapacityReservationUsageResultTypeDef,
    GetCoipPoolUsageRequestRequestTypeDef,
    GetCoipPoolUsageResultTypeDef,
    GetConsoleOutputRequestInstanceTypeDef,
    GetConsoleOutputRequestRequestTypeDef,
    GetConsoleOutputResultTypeDef,
    GetConsoleScreenshotRequestRequestTypeDef,
    GetConsoleScreenshotResultTypeDef,
    GetDefaultCreditSpecificationRequestRequestTypeDef,
    GetDefaultCreditSpecificationResultTypeDef,
    GetEbsDefaultKmsKeyIdRequestRequestTypeDef,
    GetEbsDefaultKmsKeyIdResultTypeDef,
    GetEbsEncryptionByDefaultRequestRequestTypeDef,
    GetEbsEncryptionByDefaultResultTypeDef,
    GetFlowLogsIntegrationTemplateRequestRequestTypeDef,
    GetFlowLogsIntegrationTemplateResultTypeDef,
    GetGroupsForCapacityReservationRequestRequestTypeDef,
    GetGroupsForCapacityReservationResultTypeDef,
    GetHostReservationPurchasePreviewRequestRequestTypeDef,
    GetHostReservationPurchasePreviewResultTypeDef,
    GetInstanceTypesFromInstanceRequirementsRequestRequestTypeDef,
    GetInstanceTypesFromInstanceRequirementsResultTypeDef,
    GetLaunchTemplateDataRequestRequestTypeDef,
    GetLaunchTemplateDataResultTypeDef,
    GetManagedPrefixListAssociationsRequestRequestTypeDef,
    GetManagedPrefixListAssociationsResultTypeDef,
    GetManagedPrefixListEntriesRequestRequestTypeDef,
    GetManagedPrefixListEntriesResultTypeDef,
    GetPasswordDataRequestInstanceTypeDef,
    GetPasswordDataRequestRequestTypeDef,
    GetPasswordDataResultTypeDef,
    GetReservedInstancesExchangeQuoteRequestRequestTypeDef,
    GetReservedInstancesExchangeQuoteResultTypeDef,
    GetSerialConsoleAccessStatusRequestRequestTypeDef,
    GetSerialConsoleAccessStatusResultTypeDef,
    GetSpotPlacementScoresRequestRequestTypeDef,
    GetSpotPlacementScoresResultTypeDef,
    GetSubnetCidrReservationsRequestRequestTypeDef,
    GetSubnetCidrReservationsResultTypeDef,
    GetTransitGatewayAttachmentPropagationsRequestRequestTypeDef,
    GetTransitGatewayAttachmentPropagationsResultTypeDef,
    GetTransitGatewayMulticastDomainAssociationsRequestRequestTypeDef,
    GetTransitGatewayMulticastDomainAssociationsResultTypeDef,
    GetTransitGatewayPrefixListReferencesRequestRequestTypeDef,
    GetTransitGatewayPrefixListReferencesResultTypeDef,
    GetTransitGatewayRouteTableAssociationsRequestRequestTypeDef,
    GetTransitGatewayRouteTableAssociationsResultTypeDef,
    GetTransitGatewayRouteTablePropagationsRequestRequestTypeDef,
    GetTransitGatewayRouteTablePropagationsResultTypeDef,
    GetVpnConnectionDeviceSampleConfigurationRequestRequestTypeDef,
    GetVpnConnectionDeviceSampleConfigurationResultTypeDef,
    GetVpnConnectionDeviceTypesRequestRequestTypeDef,
    GetVpnConnectionDeviceTypesResultTypeDef,
    GpuDeviceInfoTypeDef,
    GpuDeviceMemoryInfoTypeDef,
    GpuInfoTypeDef,
    GroupIdentifierTypeDef,
    HibernationOptionsRequestTypeDef,
    HibernationOptionsTypeDef,
    HistoryRecordEntryTypeDef,
    HistoryRecordTypeDef,
    HostInstanceTypeDef,
    HostOfferingTypeDef,
    HostPropertiesTypeDef,
    HostReservationTypeDef,
    HostTypeDef,
    IKEVersionsListValueTypeDef,
    IKEVersionsRequestListValueTypeDef,
    IamInstanceProfileAssociationTypeDef,
    IamInstanceProfileSpecificationTypeDef,
    IamInstanceProfileTypeDef,
    IcmpTypeCodeTypeDef,
    IdFormatTypeDef,
    ImageAttributeTypeDef,
    ImageDiskContainerTypeDef,
    ImageTypeDef,
    ImportClientVpnClientCertificateRevocationListRequestRequestTypeDef,
    ImportClientVpnClientCertificateRevocationListResultTypeDef,
    ImportImageLicenseConfigurationRequestTypeDef,
    ImportImageLicenseConfigurationResponseTypeDef,
    ImportImageRequestRequestTypeDef,
    ImportImageResultTypeDef,
    ImportImageTaskTypeDef,
    ImportInstanceLaunchSpecificationTypeDef,
    ImportInstanceRequestRequestTypeDef,
    ImportInstanceResultTypeDef,
    ImportInstanceTaskDetailsTypeDef,
    ImportInstanceVolumeDetailItemTypeDef,
    ImportKeyPairRequestRequestTypeDef,
    ImportKeyPairRequestServiceResourceTypeDef,
    ImportKeyPairResultTypeDef,
    ImportSnapshotRequestRequestTypeDef,
    ImportSnapshotResultTypeDef,
    ImportSnapshotTaskTypeDef,
    ImportVolumeRequestRequestTypeDef,
    ImportVolumeResultTypeDef,
    ImportVolumeTaskDetailsTypeDef,
    InferenceAcceleratorInfoTypeDef,
    InferenceDeviceInfoTypeDef,
    InstanceAttributeTypeDef,
    InstanceBlockDeviceMappingSpecificationTypeDef,
    InstanceBlockDeviceMappingTypeDef,
    InstanceCapacityTypeDef,
    InstanceCountTypeDef,
    InstanceCreditSpecificationRequestTypeDef,
    InstanceCreditSpecificationTypeDef,
    InstanceDeleteTagsRequestTypeDef,
    InstanceEventWindowAssociationRequestTypeDef,
    InstanceEventWindowAssociationTargetTypeDef,
    InstanceEventWindowDisassociationRequestTypeDef,
    InstanceEventWindowStateChangeTypeDef,
    InstanceEventWindowTimeRangeRequestTypeDef,
    InstanceEventWindowTimeRangeTypeDef,
    InstanceEventWindowTypeDef,
    InstanceExportDetailsTypeDef,
    InstanceFamilyCreditSpecificationTypeDef,
    InstanceIpv4PrefixTypeDef,
    InstanceIpv6AddressRequestTypeDef,
    InstanceIpv6AddressTypeDef,
    InstanceIpv6PrefixTypeDef,
    InstanceMarketOptionsRequestTypeDef,
    InstanceMetadataOptionsRequestTypeDef,
    InstanceMetadataOptionsResponseTypeDef,
    InstanceMonitoringTypeDef,
    InstanceNetworkInterfaceAssociationTypeDef,
    InstanceNetworkInterfaceAttachmentTypeDef,
    InstanceNetworkInterfaceSpecificationTypeDef,
    InstanceNetworkInterfaceTypeDef,
    InstancePrivateIpAddressTypeDef,
    InstanceRequirementsRequestTypeDef,
    InstanceRequirementsTypeDef,
    InstanceRequirementsWithMetadataRequestTypeDef,
    InstanceSpecificationTypeDef,
    InstanceStateChangeTypeDef,
    InstanceStateTypeDef,
    InstanceStatusDetailsTypeDef,
    InstanceStatusEventTypeDef,
    InstanceStatusSummaryTypeDef,
    InstanceStatusTypeDef,
    InstanceStorageInfoTypeDef,
    InstanceTagNotificationAttributeTypeDef,
    InstanceTypeDef,
    InstanceTypeInfoFromInstanceRequirementsTypeDef,
    InstanceTypeInfoTypeDef,
    InstanceTypeOfferingTypeDef,
    InstanceUsageTypeDef,
    IntegrateServicesTypeDef,
    InternetGatewayAttachmentTypeDef,
    InternetGatewayTypeDef,
    IpPermissionTypeDef,
    IpRangeTypeDef,
    Ipv4PrefixSpecificationRequestTypeDef,
    Ipv4PrefixSpecificationResponseTypeDef,
    Ipv4PrefixSpecificationTypeDef,
    Ipv6CidrAssociationTypeDef,
    Ipv6CidrBlockTypeDef,
    Ipv6PoolTypeDef,
    Ipv6PrefixSpecificationRequestTypeDef,
    Ipv6PrefixSpecificationResponseTypeDef,
    Ipv6PrefixSpecificationTypeDef,
    Ipv6RangeTypeDef,
    KeyPairInfoTypeDef,
    KeyPairTypeDef,
    LastErrorTypeDef,
    LaunchPermissionModificationsTypeDef,
    LaunchPermissionTypeDef,
    LaunchSpecificationTypeDef,
    LaunchTemplateAndOverridesResponseTypeDef,
    LaunchTemplateBlockDeviceMappingRequestTypeDef,
    LaunchTemplateBlockDeviceMappingTypeDef,
    LaunchTemplateCapacityReservationSpecificationRequestTypeDef,
    LaunchTemplateCapacityReservationSpecificationResponseTypeDef,
    LaunchTemplateConfigTypeDef,
    LaunchTemplateCpuOptionsRequestTypeDef,
    LaunchTemplateCpuOptionsTypeDef,
    LaunchTemplateEbsBlockDeviceRequestTypeDef,
    LaunchTemplateEbsBlockDeviceTypeDef,
    LaunchTemplateElasticInferenceAcceleratorResponseTypeDef,
    LaunchTemplateElasticInferenceAcceleratorTypeDef,
    LaunchTemplateEnclaveOptionsRequestTypeDef,
    LaunchTemplateEnclaveOptionsTypeDef,
    LaunchTemplateHibernationOptionsRequestTypeDef,
    LaunchTemplateHibernationOptionsTypeDef,
    LaunchTemplateIamInstanceProfileSpecificationRequestTypeDef,
    LaunchTemplateIamInstanceProfileSpecificationTypeDef,
    LaunchTemplateInstanceMarketOptionsRequestTypeDef,
    LaunchTemplateInstanceMarketOptionsTypeDef,
    LaunchTemplateInstanceMetadataOptionsRequestTypeDef,
    LaunchTemplateInstanceMetadataOptionsTypeDef,
    LaunchTemplateInstanceNetworkInterfaceSpecificationRequestTypeDef,
    LaunchTemplateInstanceNetworkInterfaceSpecificationTypeDef,
    LaunchTemplateLicenseConfigurationRequestTypeDef,
    LaunchTemplateLicenseConfigurationTypeDef,
    LaunchTemplateOverridesTypeDef,
    LaunchTemplatePlacementRequestTypeDef,
    LaunchTemplatePlacementTypeDef,
    LaunchTemplatePrivateDnsNameOptionsRequestTypeDef,
    LaunchTemplatePrivateDnsNameOptionsTypeDef,
    LaunchTemplateSpecificationTypeDef,
    LaunchTemplateSpotMarketOptionsRequestTypeDef,
    LaunchTemplateSpotMarketOptionsTypeDef,
    LaunchTemplateTagSpecificationRequestTypeDef,
    LaunchTemplateTagSpecificationTypeDef,
    LaunchTemplateTypeDef,
    LaunchTemplateVersionTypeDef,
    LaunchTemplatesMonitoringRequestTypeDef,
    LaunchTemplatesMonitoringTypeDef,
    LicenseConfigurationRequestTypeDef,
    LicenseConfigurationTypeDef,
    LoadBalancersConfigTypeDef,
    LoadPermissionModificationsTypeDef,
    LoadPermissionRequestTypeDef,
    LoadPermissionTypeDef,
    LocalGatewayRouteTableTypeDef,
    LocalGatewayRouteTableVirtualInterfaceGroupAssociationTypeDef,
    LocalGatewayRouteTableVpcAssociationTypeDef,
    LocalGatewayRouteTypeDef,
    LocalGatewayTypeDef,
    LocalGatewayVirtualInterfaceGroupTypeDef,
    LocalGatewayVirtualInterfaceTypeDef,
    ManagedPrefixListTypeDef,
    MemoryGiBPerVCpuRequestTypeDef,
    MemoryGiBPerVCpuTypeDef,
    MemoryInfoTypeDef,
    MemoryMiBRequestTypeDef,
    MemoryMiBTypeDef,
    ModifyAddressAttributeRequestRequestTypeDef,
    ModifyAddressAttributeResultTypeDef,
    ModifyAvailabilityZoneGroupRequestRequestTypeDef,
    ModifyAvailabilityZoneGroupResultTypeDef,
    ModifyCapacityReservationFleetRequestRequestTypeDef,
    ModifyCapacityReservationFleetResultTypeDef,
    ModifyCapacityReservationRequestRequestTypeDef,
    ModifyCapacityReservationResultTypeDef,
    ModifyClientVpnEndpointRequestRequestTypeDef,
    ModifyClientVpnEndpointResultTypeDef,
    ModifyDefaultCreditSpecificationRequestRequestTypeDef,
    ModifyDefaultCreditSpecificationResultTypeDef,
    ModifyEbsDefaultKmsKeyIdRequestRequestTypeDef,
    ModifyEbsDefaultKmsKeyIdResultTypeDef,
    ModifyFleetRequestRequestTypeDef,
    ModifyFleetResultTypeDef,
    ModifyFpgaImageAttributeRequestRequestTypeDef,
    ModifyFpgaImageAttributeResultTypeDef,
    ModifyHostsRequestRequestTypeDef,
    ModifyHostsResultTypeDef,
    ModifyIdFormatRequestRequestTypeDef,
    ModifyIdentityIdFormatRequestRequestTypeDef,
    ModifyImageAttributeRequestImageTypeDef,
    ModifyImageAttributeRequestRequestTypeDef,
    ModifyInstanceAttributeRequestInstanceTypeDef,
    ModifyInstanceAttributeRequestRequestTypeDef,
    ModifyInstanceCapacityReservationAttributesRequestRequestTypeDef,
    ModifyInstanceCapacityReservationAttributesResultTypeDef,
    ModifyInstanceCreditSpecificationRequestRequestTypeDef,
    ModifyInstanceCreditSpecificationResultTypeDef,
    ModifyInstanceEventStartTimeRequestRequestTypeDef,
    ModifyInstanceEventStartTimeResultTypeDef,
    ModifyInstanceEventWindowRequestRequestTypeDef,
    ModifyInstanceEventWindowResultTypeDef,
    ModifyInstanceMetadataOptionsRequestRequestTypeDef,
    ModifyInstanceMetadataOptionsResultTypeDef,
    ModifyInstancePlacementRequestRequestTypeDef,
    ModifyInstancePlacementResultTypeDef,
    ModifyLaunchTemplateRequestRequestTypeDef,
    ModifyLaunchTemplateResultTypeDef,
    ModifyManagedPrefixListRequestRequestTypeDef,
    ModifyManagedPrefixListResultTypeDef,
    ModifyNetworkInterfaceAttributeRequestNetworkInterfaceTypeDef,
    ModifyNetworkInterfaceAttributeRequestRequestTypeDef,
    ModifyPrivateDnsNameOptionsRequestRequestTypeDef,
    ModifyPrivateDnsNameOptionsResultTypeDef,
    ModifyReservedInstancesRequestRequestTypeDef,
    ModifyReservedInstancesResultTypeDef,
    ModifySecurityGroupRulesRequestRequestTypeDef,
    ModifySecurityGroupRulesResultTypeDef,
    ModifySnapshotAttributeRequestRequestTypeDef,
    ModifySnapshotAttributeRequestSnapshotTypeDef,
    ModifySpotFleetRequestRequestRequestTypeDef,
    ModifySpotFleetRequestResponseTypeDef,
    ModifySubnetAttributeRequestRequestTypeDef,
    ModifyTrafficMirrorFilterNetworkServicesRequestRequestTypeDef,
    ModifyTrafficMirrorFilterNetworkServicesResultTypeDef,
    ModifyTrafficMirrorFilterRuleRequestRequestTypeDef,
    ModifyTrafficMirrorFilterRuleResultTypeDef,
    ModifyTrafficMirrorSessionRequestRequestTypeDef,
    ModifyTrafficMirrorSessionResultTypeDef,
    ModifyTransitGatewayOptionsTypeDef,
    ModifyTransitGatewayPrefixListReferenceRequestRequestTypeDef,
    ModifyTransitGatewayPrefixListReferenceResultTypeDef,
    ModifyTransitGatewayRequestRequestTypeDef,
    ModifyTransitGatewayResultTypeDef,
    ModifyTransitGatewayVpcAttachmentRequestOptionsTypeDef,
    ModifyTransitGatewayVpcAttachmentRequestRequestTypeDef,
    ModifyTransitGatewayVpcAttachmentResultTypeDef,
    ModifyVolumeAttributeRequestRequestTypeDef,
    ModifyVolumeAttributeRequestVolumeTypeDef,
    ModifyVolumeRequestRequestTypeDef,
    ModifyVolumeResultTypeDef,
    ModifyVpcAttributeRequestRequestTypeDef,
    ModifyVpcAttributeRequestVpcTypeDef,
    ModifyVpcEndpointConnectionNotificationRequestRequestTypeDef,
    ModifyVpcEndpointConnectionNotificationResultTypeDef,
    ModifyVpcEndpointRequestRequestTypeDef,
    ModifyVpcEndpointResultTypeDef,
    ModifyVpcEndpointServiceConfigurationRequestRequestTypeDef,
    ModifyVpcEndpointServiceConfigurationResultTypeDef,
    ModifyVpcEndpointServicePermissionsRequestRequestTypeDef,
    ModifyVpcEndpointServicePermissionsResultTypeDef,
    ModifyVpcPeeringConnectionOptionsRequestRequestTypeDef,
    ModifyVpcPeeringConnectionOptionsResultTypeDef,
    ModifyVpcTenancyRequestRequestTypeDef,
    ModifyVpcTenancyResultTypeDef,
    ModifyVpnConnectionOptionsRequestRequestTypeDef,
    ModifyVpnConnectionOptionsResultTypeDef,
    ModifyVpnConnectionRequestRequestTypeDef,
    ModifyVpnConnectionResultTypeDef,
    ModifyVpnTunnelCertificateRequestRequestTypeDef,
    ModifyVpnTunnelCertificateResultTypeDef,
    ModifyVpnTunnelOptionsRequestRequestTypeDef,
    ModifyVpnTunnelOptionsResultTypeDef,
    ModifyVpnTunnelOptionsSpecificationTypeDef,
    MonitorInstancesRequestInstanceTypeDef,
    MonitorInstancesRequestRequestTypeDef,
    MonitorInstancesResultTypeDef,
    MonitoringTypeDef,
    MoveAddressToVpcRequestRequestTypeDef,
    MoveAddressToVpcResultTypeDef,
    MovingAddressStatusTypeDef,
    NatGatewayAddressTypeDef,
    NatGatewayTypeDef,
    NetworkAclAssociationTypeDef,
    NetworkAclEntryTypeDef,
    NetworkAclTypeDef,
    NetworkCardInfoTypeDef,
    NetworkInfoTypeDef,
    NetworkInsightsAnalysisTypeDef,
    NetworkInsightsPathTypeDef,
    NetworkInterfaceAssociationTypeDef,
    NetworkInterfaceAttachmentChangesTypeDef,
    NetworkInterfaceAttachmentTypeDef,
    NetworkInterfaceCountRequestTypeDef,
    NetworkInterfaceCountTypeDef,
    NetworkInterfaceIpv6AddressTypeDef,
    NetworkInterfacePermissionStateTypeDef,
    NetworkInterfacePermissionTypeDef,
    NetworkInterfacePrivateIpAddressTypeDef,
    NetworkInterfaceTypeDef,
    NewDhcpConfigurationTypeDef,
    OnDemandOptionsRequestTypeDef,
    OnDemandOptionsTypeDef,
    PaginatorConfigTypeDef,
    PathComponentTypeDef,
    PciIdTypeDef,
    PeeringAttachmentStatusTypeDef,
    PeeringConnectionOptionsRequestTypeDef,
    PeeringConnectionOptionsTypeDef,
    PeeringTgwInfoTypeDef,
    Phase1DHGroupNumbersListValueTypeDef,
    Phase1DHGroupNumbersRequestListValueTypeDef,
    Phase1EncryptionAlgorithmsListValueTypeDef,
    Phase1EncryptionAlgorithmsRequestListValueTypeDef,
    Phase1IntegrityAlgorithmsListValueTypeDef,
    Phase1IntegrityAlgorithmsRequestListValueTypeDef,
    Phase2DHGroupNumbersListValueTypeDef,
    Phase2DHGroupNumbersRequestListValueTypeDef,
    Phase2EncryptionAlgorithmsListValueTypeDef,
    Phase2EncryptionAlgorithmsRequestListValueTypeDef,
    Phase2IntegrityAlgorithmsListValueTypeDef,
    Phase2IntegrityAlgorithmsRequestListValueTypeDef,
    PlacementGroupInfoTypeDef,
    PlacementGroupTypeDef,
    PlacementResponseTypeDef,
    PlacementTypeDef,
    PoolCidrBlockTypeDef,
    PortRangeTypeDef,
    PrefixListAssociationTypeDef,
    PrefixListEntryTypeDef,
    PrefixListIdTypeDef,
    PrefixListTypeDef,
    PriceScheduleSpecificationTypeDef,
    PriceScheduleTypeDef,
    PricingDetailTypeDef,
    PrincipalIdFormatTypeDef,
    PrivateDnsDetailsTypeDef,
    PrivateDnsNameConfigurationTypeDef,
    PrivateDnsNameOptionsOnLaunchTypeDef,
    PrivateDnsNameOptionsRequestTypeDef,
    PrivateDnsNameOptionsResponseTypeDef,
    PrivateIpAddressSpecificationTypeDef,
    ProcessorInfoTypeDef,
    ProductCodeTypeDef,
    PropagatingVgwTypeDef,
    ProvisionByoipCidrRequestRequestTypeDef,
    ProvisionByoipCidrResultTypeDef,
    ProvisionedBandwidthTypeDef,
    PtrUpdateStatusTypeDef,
    PublicIpv4PoolRangeTypeDef,
    PublicIpv4PoolTypeDef,
    PurchaseHostReservationRequestRequestTypeDef,
    PurchaseHostReservationResultTypeDef,
    PurchaseRequestTypeDef,
    PurchaseReservedInstancesOfferingRequestRequestTypeDef,
    PurchaseReservedInstancesOfferingResultTypeDef,
    PurchaseScheduledInstancesRequestRequestTypeDef,
    PurchaseScheduledInstancesResultTypeDef,
    PurchaseTypeDef,
    RebootInstancesRequestInstanceTypeDef,
    RebootInstancesRequestRequestTypeDef,
    RecurringChargeTypeDef,
    ReferencedSecurityGroupTypeDef,
    RegionTypeDef,
    RegisterImageRequestRequestTypeDef,
    RegisterImageRequestServiceResourceTypeDef,
    RegisterImageResultTypeDef,
    RegisterInstanceEventNotificationAttributesRequestRequestTypeDef,
    RegisterInstanceEventNotificationAttributesResultTypeDef,
    RegisterInstanceTagAttributeRequestTypeDef,
    RegisterTransitGatewayMulticastGroupMembersRequestRequestTypeDef,
    RegisterTransitGatewayMulticastGroupMembersResultTypeDef,
    RegisterTransitGatewayMulticastGroupSourcesRequestRequestTypeDef,
    RegisterTransitGatewayMulticastGroupSourcesResultTypeDef,
    RejectTransitGatewayMulticastDomainAssociationsRequestRequestTypeDef,
    RejectTransitGatewayMulticastDomainAssociationsResultTypeDef,
    RejectTransitGatewayPeeringAttachmentRequestRequestTypeDef,
    RejectTransitGatewayPeeringAttachmentResultTypeDef,
    RejectTransitGatewayVpcAttachmentRequestRequestTypeDef,
    RejectTransitGatewayVpcAttachmentResultTypeDef,
    RejectVpcEndpointConnectionsRequestRequestTypeDef,
    RejectVpcEndpointConnectionsResultTypeDef,
    RejectVpcPeeringConnectionRequestRequestTypeDef,
    RejectVpcPeeringConnectionRequestVpcPeeringConnectionTypeDef,
    RejectVpcPeeringConnectionResultTypeDef,
    ReleaseAddressRequestClassicAddressTypeDef,
    ReleaseAddressRequestRequestTypeDef,
    ReleaseAddressRequestVpcAddressTypeDef,
    ReleaseHostsRequestRequestTypeDef,
    ReleaseHostsResultTypeDef,
    RemovePrefixListEntryTypeDef,
    ReplaceIamInstanceProfileAssociationRequestRequestTypeDef,
    ReplaceIamInstanceProfileAssociationResultTypeDef,
    ReplaceNetworkAclAssociationRequestNetworkAclTypeDef,
    ReplaceNetworkAclAssociationRequestRequestTypeDef,
    ReplaceNetworkAclAssociationResultTypeDef,
    ReplaceNetworkAclEntryRequestNetworkAclTypeDef,
    ReplaceNetworkAclEntryRequestRequestTypeDef,
    ReplaceRootVolumeTaskTypeDef,
    ReplaceRouteRequestRequestTypeDef,
    ReplaceRouteRequestRouteTypeDef,
    ReplaceRouteTableAssociationRequestRequestTypeDef,
    ReplaceRouteTableAssociationRequestRouteTableAssociationTypeDef,
    ReplaceRouteTableAssociationResultTypeDef,
    ReplaceTransitGatewayRouteRequestRequestTypeDef,
    ReplaceTransitGatewayRouteResultTypeDef,
    ReportInstanceStatusRequestInstanceTypeDef,
    ReportInstanceStatusRequestRequestTypeDef,
    RequestLaunchTemplateDataTypeDef,
    RequestSpotFleetRequestRequestTypeDef,
    RequestSpotFleetResponseTypeDef,
    RequestSpotInstancesRequestRequestTypeDef,
    RequestSpotInstancesResultTypeDef,
    RequestSpotLaunchSpecificationTypeDef,
    ReservationFleetInstanceSpecificationTypeDef,
    ReservationResponseMetadataTypeDef,
    ReservationTypeDef,
    ReservationValueTypeDef,
    ReservedInstanceLimitPriceTypeDef,
    ReservedInstanceReservationValueTypeDef,
    ReservedInstancesConfigurationTypeDef,
    ReservedInstancesIdTypeDef,
    ReservedInstancesListingTypeDef,
    ReservedInstancesModificationResultTypeDef,
    ReservedInstancesModificationTypeDef,
    ReservedInstancesOfferingTypeDef,
    ReservedInstancesTypeDef,
    ResetAddressAttributeRequestRequestTypeDef,
    ResetAddressAttributeResultTypeDef,
    ResetEbsDefaultKmsKeyIdRequestRequestTypeDef,
    ResetEbsDefaultKmsKeyIdResultTypeDef,
    ResetFpgaImageAttributeRequestRequestTypeDef,
    ResetFpgaImageAttributeResultTypeDef,
    ResetImageAttributeRequestImageTypeDef,
    ResetImageAttributeRequestRequestTypeDef,
    ResetInstanceAttributeRequestInstanceTypeDef,
    ResetInstanceAttributeRequestRequestTypeDef,
    ResetNetworkInterfaceAttributeRequestNetworkInterfaceTypeDef,
    ResetNetworkInterfaceAttributeRequestRequestTypeDef,
    ResetSnapshotAttributeRequestRequestTypeDef,
    ResetSnapshotAttributeRequestSnapshotTypeDef,
    ResponseErrorTypeDef,
    ResponseLaunchTemplateDataTypeDef,
    ResponseMetadataTypeDef,
    RestoreAddressToClassicRequestRequestTypeDef,
    RestoreAddressToClassicResultTypeDef,
    RestoreManagedPrefixListVersionRequestRequestTypeDef,
    RestoreManagedPrefixListVersionResultTypeDef,
    RevokeClientVpnIngressRequestRequestTypeDef,
    RevokeClientVpnIngressResultTypeDef,
    RevokeSecurityGroupEgressRequestRequestTypeDef,
    RevokeSecurityGroupEgressRequestSecurityGroupTypeDef,
    RevokeSecurityGroupEgressResultTypeDef,
    RevokeSecurityGroupIngressRequestRequestTypeDef,
    RevokeSecurityGroupIngressRequestSecurityGroupTypeDef,
    RevokeSecurityGroupIngressResultTypeDef,
    RouteTableAssociationStateTypeDef,
    RouteTableAssociationTypeDef,
    RouteTableTypeDef,
    RouteTypeDef,
    RunInstancesMonitoringEnabledTypeDef,
    RunInstancesRequestRequestTypeDef,
    RunInstancesRequestServiceResourceTypeDef,
    RunInstancesRequestSubnetTypeDef,
    RunScheduledInstancesRequestRequestTypeDef,
    RunScheduledInstancesResultTypeDef,
    S3ObjectTagTypeDef,
    S3StorageTypeDef,
    ScheduledInstanceAvailabilityTypeDef,
    ScheduledInstanceRecurrenceRequestTypeDef,
    ScheduledInstanceRecurrenceTypeDef,
    ScheduledInstanceTypeDef,
    ScheduledInstancesBlockDeviceMappingTypeDef,
    ScheduledInstancesEbsTypeDef,
    ScheduledInstancesIamInstanceProfileTypeDef,
    ScheduledInstancesIpv6AddressTypeDef,
    ScheduledInstancesLaunchSpecificationTypeDef,
    ScheduledInstancesMonitoringTypeDef,
    ScheduledInstancesNetworkInterfaceTypeDef,
    ScheduledInstancesPlacementTypeDef,
    ScheduledInstancesPrivateIpAddressConfigTypeDef,
    SearchLocalGatewayRoutesRequestRequestTypeDef,
    SearchLocalGatewayRoutesResultTypeDef,
    SearchTransitGatewayMulticastGroupsRequestRequestTypeDef,
    SearchTransitGatewayMulticastGroupsResultTypeDef,
    SearchTransitGatewayRoutesRequestRequestTypeDef,
    SearchTransitGatewayRoutesResultTypeDef,
    SecurityGroupIdentifierTypeDef,
    SecurityGroupReferenceTypeDef,
    SecurityGroupRuleDescriptionTypeDef,
    SecurityGroupRuleRequestTypeDef,
    SecurityGroupRuleTypeDef,
    SecurityGroupRuleUpdateTypeDef,
    SecurityGroupTypeDef,
    SendDiagnosticInterruptRequestRequestTypeDef,
    ServiceConfigurationTypeDef,
    ServiceDetailTypeDef,
    ServiceResourceClassicAddressRequestTypeDef,
    ServiceResourceDhcpOptionsRequestTypeDef,
    ServiceResourceImageRequestTypeDef,
    ServiceResourceInstanceRequestTypeDef,
    ServiceResourceInternetGatewayRequestTypeDef,
    ServiceResourceKeyPairRequestTypeDef,
    ServiceResourceNetworkAclRequestTypeDef,
    ServiceResourceNetworkInterfaceAssociationRequestTypeDef,
    ServiceResourceNetworkInterfaceRequestTypeDef,
    ServiceResourcePlacementGroupRequestTypeDef,
    ServiceResourceRouteRequestTypeDef,
    ServiceResourceRouteTableAssociationRequestTypeDef,
    ServiceResourceRouteTableRequestTypeDef,
    ServiceResourceSecurityGroupRequestTypeDef,
    ServiceResourceSnapshotRequestTypeDef,
    ServiceResourceSubnetRequestTypeDef,
    ServiceResourceTagRequestTypeDef,
    ServiceResourceVolumeRequestTypeDef,
    ServiceResourceVpcAddressRequestTypeDef,
    ServiceResourceVpcPeeringConnectionRequestTypeDef,
    ServiceResourceVpcRequestTypeDef,
    ServiceTypeDetailTypeDef,
    SlotDateTimeRangeRequestTypeDef,
    SlotStartTimeRangeRequestTypeDef,
    SnapshotDetailTypeDef,
    SnapshotDiskContainerTypeDef,
    SnapshotInfoTypeDef,
    SnapshotResponseMetadataTypeDef,
    SnapshotTaskDetailTypeDef,
    SnapshotTypeDef,
    SpotCapacityRebalanceTypeDef,
    SpotDatafeedSubscriptionTypeDef,
    SpotFleetLaunchSpecificationTypeDef,
    SpotFleetMonitoringTypeDef,
    SpotFleetRequestConfigDataTypeDef,
    SpotFleetRequestConfigTypeDef,
    SpotFleetTagSpecificationTypeDef,
    SpotInstanceRequestTypeDef,
    SpotInstanceStateFaultTypeDef,
    SpotInstanceStatusTypeDef,
    SpotMaintenanceStrategiesTypeDef,
    SpotMarketOptionsTypeDef,
    SpotOptionsRequestTypeDef,
    SpotOptionsTypeDef,
    SpotPlacementScoreTypeDef,
    SpotPlacementTypeDef,
    SpotPriceTypeDef,
    StaleIpPermissionTypeDef,
    StaleSecurityGroupTypeDef,
    StartInstancesRequestInstanceTypeDef,
    StartInstancesRequestRequestTypeDef,
    StartInstancesResultTypeDef,
    StartNetworkInsightsAnalysisRequestRequestTypeDef,
    StartNetworkInsightsAnalysisResultTypeDef,
    StartVpcEndpointServicePrivateDnsVerificationRequestRequestTypeDef,
    StartVpcEndpointServicePrivateDnsVerificationResultTypeDef,
    StateReasonTypeDef,
    StopInstancesRequestInstanceTypeDef,
    StopInstancesRequestRequestTypeDef,
    StopInstancesResultTypeDef,
    StorageLocationTypeDef,
    StorageTypeDef,
    StoreImageTaskResultTypeDef,
    SubnetAssociationTypeDef,
    SubnetCidrBlockStateTypeDef,
    SubnetCidrReservationTypeDef,
    SubnetIpv6CidrBlockAssociationTypeDef,
    SubnetTypeDef,
    SuccessfulInstanceCreditSpecificationItemTypeDef,
    SuccessfulQueuedPurchaseDeletionTypeDef,
    TagDescriptionTypeDef,
    TagSpecificationTypeDef,
    TagTypeDef,
    TargetCapacitySpecificationRequestTypeDef,
    TargetCapacitySpecificationTypeDef,
    TargetConfigurationRequestTypeDef,
    TargetConfigurationTypeDef,
    TargetGroupTypeDef,
    TargetGroupsConfigTypeDef,
    TargetNetworkTypeDef,
    TargetReservationValueTypeDef,
    TerminateClientVpnConnectionsRequestRequestTypeDef,
    TerminateClientVpnConnectionsResultTypeDef,
    TerminateConnectionStatusTypeDef,
    TerminateInstancesRequestInstanceTypeDef,
    TerminateInstancesRequestRequestTypeDef,
    TerminateInstancesResultTypeDef,
    TotalLocalStorageGBRequestTypeDef,
    TotalLocalStorageGBTypeDef,
    TrafficMirrorFilterRuleTypeDef,
    TrafficMirrorFilterTypeDef,
    TrafficMirrorPortRangeRequestTypeDef,
    TrafficMirrorPortRangeTypeDef,
    TrafficMirrorSessionTypeDef,
    TrafficMirrorTargetTypeDef,
    TransitGatewayAssociationTypeDef,
    TransitGatewayAttachmentAssociationTypeDef,
    TransitGatewayAttachmentBgpConfigurationTypeDef,
    TransitGatewayAttachmentPropagationTypeDef,
    TransitGatewayAttachmentTypeDef,
    TransitGatewayConnectOptionsTypeDef,
    TransitGatewayConnectPeerConfigurationTypeDef,
    TransitGatewayConnectPeerTypeDef,
    TransitGatewayConnectRequestBgpOptionsTypeDef,
    TransitGatewayConnectTypeDef,
    TransitGatewayMulticastDeregisteredGroupMembersTypeDef,
    TransitGatewayMulticastDeregisteredGroupSourcesTypeDef,
    TransitGatewayMulticastDomainAssociationTypeDef,
    TransitGatewayMulticastDomainAssociationsTypeDef,
    TransitGatewayMulticastDomainOptionsTypeDef,
    TransitGatewayMulticastDomainTypeDef,
    TransitGatewayMulticastGroupTypeDef,
    TransitGatewayMulticastRegisteredGroupMembersTypeDef,
    TransitGatewayMulticastRegisteredGroupSourcesTypeDef,
    TransitGatewayOptionsTypeDef,
    TransitGatewayPeeringAttachmentTypeDef,
    TransitGatewayPrefixListAttachmentTypeDef,
    TransitGatewayPrefixListReferenceTypeDef,
    TransitGatewayPropagationTypeDef,
    TransitGatewayRequestOptionsTypeDef,
    TransitGatewayRouteAttachmentTypeDef,
    TransitGatewayRouteTableAssociationTypeDef,
    TransitGatewayRouteTablePropagationTypeDef,
    TransitGatewayRouteTableTypeDef,
    TransitGatewayRouteTypeDef,
    TransitGatewayTypeDef,
    TransitGatewayVpcAttachmentOptionsTypeDef,
    TransitGatewayVpcAttachmentTypeDef,
    TrunkInterfaceAssociationTypeDef,
    TunnelOptionTypeDef,
    UnassignIpv6AddressesRequestRequestTypeDef,
    UnassignIpv6AddressesResultTypeDef,
    UnassignPrivateIpAddressesRequestNetworkInterfaceTypeDef,
    UnassignPrivateIpAddressesRequestRequestTypeDef,
    UnmonitorInstancesRequestInstanceTypeDef,
    UnmonitorInstancesRequestRequestTypeDef,
    UnmonitorInstancesResultTypeDef,
    UnsuccessfulInstanceCreditSpecificationItemErrorTypeDef,
    UnsuccessfulInstanceCreditSpecificationItemTypeDef,
    UnsuccessfulItemErrorTypeDef,
    UnsuccessfulItemTypeDef,
    UpdateSecurityGroupRuleDescriptionsEgressRequestRequestTypeDef,
    UpdateSecurityGroupRuleDescriptionsEgressResultTypeDef,
    UpdateSecurityGroupRuleDescriptionsIngressRequestRequestTypeDef,
    UpdateSecurityGroupRuleDescriptionsIngressResultTypeDef,
    UserBucketDetailsTypeDef,
    UserBucketTypeDef,
    UserDataTypeDef,
    UserIdGroupPairTypeDef,
    VCpuCountRangeRequestTypeDef,
    VCpuCountRangeTypeDef,
    VCpuInfoTypeDef,
    ValidationErrorTypeDef,
    ValidationWarningTypeDef,
    VgwTelemetryTypeDef,
    VolumeAttachmentResponseMetadataTypeDef,
    VolumeAttachmentTypeDef,
    VolumeDetailTypeDef,
    VolumeModificationTypeDef,
    VolumeResponseMetadataTypeDef,
    VolumeStatusActionTypeDef,
    VolumeStatusAttachmentStatusTypeDef,
    VolumeStatusDetailsTypeDef,
    VolumeStatusEventTypeDef,
    VolumeStatusInfoTypeDef,
    VolumeStatusItemTypeDef,
    VolumeTypeDef,
    VpcAttachmentTypeDef,
    VpcCidrBlockAssociationTypeDef,
    VpcCidrBlockStateTypeDef,
    VpcClassicLinkTypeDef,
    VpcEndpointConnectionTypeDef,
    VpcEndpointTypeDef,
    VpcIpv6CidrBlockAssociationTypeDef,
    VpcPeeringConnectionOptionsDescriptionTypeDef,
    VpcPeeringConnectionStateReasonTypeDef,
    VpcPeeringConnectionTypeDef,
    VpcPeeringConnectionVpcInfoTypeDef,
    VpcTypeDef,
    VpnConnectionDeviceTypeTypeDef,
    VpnConnectionOptionsSpecificationTypeDef,
    VpnConnectionOptionsTypeDef,
    VpnConnectionTypeDef,
    VpnGatewayTypeDef,
    VpnStaticRouteTypeDef,
    VpnTunnelOptionsSpecificationTypeDef,
    WaiterConfigTypeDef,
    WithdrawByoipCidrRequestRequestTypeDef,
    WithdrawByoipCidrResultTypeDef,
)

def get_structure() -> AcceleratorCountRequestTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-ec2` version is the same as related `boto3` version and follows
[PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-ec2 docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_ec2/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
