import * as cdk from '@aws-cdk/core';
import * as cfn_parse from '@aws-cdk/core/lib/cfn-parse';
/**
 * Properties for defining a `AWS::LicenseManager::Grant`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html
 * @external
 */
export interface CfnGrantProps {
    /**
     * `AWS::LicenseManager::Grant.AllowedOperations`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html#cfn-licensemanager-grant-allowedoperations
     * @external
     */
    readonly allowedOperations?: string[];
    /**
     * `AWS::LicenseManager::Grant.GrantName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html#cfn-licensemanager-grant-grantname
     * @external
     */
    readonly grantName?: string;
    /**
     * `AWS::LicenseManager::Grant.HomeRegion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html#cfn-licensemanager-grant-homeregion
     * @external
     */
    readonly homeRegion?: string;
    /**
     * `AWS::LicenseManager::Grant.LicenseArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html#cfn-licensemanager-grant-licensearn
     * @external
     */
    readonly licenseArn?: string;
    /**
     * `AWS::LicenseManager::Grant.Principals`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html#cfn-licensemanager-grant-principals
     * @external
     */
    readonly principals?: string[];
    /**
     * `AWS::LicenseManager::Grant.Status`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html#cfn-licensemanager-grant-status
     * @external
     */
    readonly status?: string;
}
/**
 * A CloudFormation `AWS::LicenseManager::Grant`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html
 * @external
 * @cloudformationResource AWS::LicenseManager::Grant
 */
export declare class CfnGrant extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::LicenseManager::Grant";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnGrant;
    /**
     * @external
     * @cloudformationAttribute GrantArn
     */
    readonly attrGrantArn: string;
    /**
     * @external
     * @cloudformationAttribute Version
     */
    readonly attrVersion: string;
    /**
     * `AWS::LicenseManager::Grant.AllowedOperations`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html#cfn-licensemanager-grant-allowedoperations
     * @external
     */
    allowedOperations: string[] | undefined;
    /**
     * `AWS::LicenseManager::Grant.GrantName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html#cfn-licensemanager-grant-grantname
     * @external
     */
    grantName: string | undefined;
    /**
     * `AWS::LicenseManager::Grant.HomeRegion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html#cfn-licensemanager-grant-homeregion
     * @external
     */
    homeRegion: string | undefined;
    /**
     * `AWS::LicenseManager::Grant.LicenseArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html#cfn-licensemanager-grant-licensearn
     * @external
     */
    licenseArn: string | undefined;
    /**
     * `AWS::LicenseManager::Grant.Principals`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html#cfn-licensemanager-grant-principals
     * @external
     */
    principals: string[] | undefined;
    /**
     * `AWS::LicenseManager::Grant.Status`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-grant.html#cfn-licensemanager-grant-status
     * @external
     */
    status: string | undefined;
    /**
     * Create a new `AWS::LicenseManager::Grant`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnGrantProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::LicenseManager::License`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html
 * @external
 */
export interface CfnLicenseProps {
    /**
     * `AWS::LicenseManager::License.ConsumptionConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-consumptionconfiguration
     * @external
     */
    readonly consumptionConfiguration: CfnLicense.ConsumptionConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::LicenseManager::License.Entitlements`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-entitlements
     * @external
     */
    readonly entitlements: Array<CfnLicense.EntitlementProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::LicenseManager::License.HomeRegion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-homeregion
     * @external
     */
    readonly homeRegion: string;
    /**
     * `AWS::LicenseManager::License.Issuer`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-issuer
     * @external
     */
    readonly issuer: CfnLicense.IssuerDataProperty | cdk.IResolvable;
    /**
     * `AWS::LicenseManager::License.LicenseName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-licensename
     * @external
     */
    readonly licenseName: string;
    /**
     * `AWS::LicenseManager::License.ProductName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-productname
     * @external
     */
    readonly productName: string;
    /**
     * `AWS::LicenseManager::License.Validity`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-validity
     * @external
     */
    readonly validity: CfnLicense.ValidityDateFormatProperty | cdk.IResolvable;
    /**
     * `AWS::LicenseManager::License.Beneficiary`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-beneficiary
     * @external
     */
    readonly beneficiary?: string;
    /**
     * `AWS::LicenseManager::License.LicenseMetadata`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-licensemetadata
     * @external
     */
    readonly licenseMetadata?: Array<CfnLicense.MetadataProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::LicenseManager::License.ProductSKU`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-productsku
     * @external
     */
    readonly productSku?: string;
    /**
     * `AWS::LicenseManager::License.Status`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-status
     * @external
     */
    readonly status?: string;
}
/**
 * A CloudFormation `AWS::LicenseManager::License`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html
 * @external
 * @cloudformationResource AWS::LicenseManager::License
 */
export declare class CfnLicense extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::LicenseManager::License";
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope: cdk.Construct, id: string, resourceAttributes: any, options: cfn_parse.FromCloudFormationOptions): CfnLicense;
    /**
     * @external
     * @cloudformationAttribute LicenseArn
     */
    readonly attrLicenseArn: string;
    /**
     * @external
     * @cloudformationAttribute Version
     */
    readonly attrVersion: string;
    /**
     * `AWS::LicenseManager::License.ConsumptionConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-consumptionconfiguration
     * @external
     */
    consumptionConfiguration: CfnLicense.ConsumptionConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::LicenseManager::License.Entitlements`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-entitlements
     * @external
     */
    entitlements: Array<CfnLicense.EntitlementProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::LicenseManager::License.HomeRegion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-homeregion
     * @external
     */
    homeRegion: string;
    /**
     * `AWS::LicenseManager::License.Issuer`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-issuer
     * @external
     */
    issuer: CfnLicense.IssuerDataProperty | cdk.IResolvable;
    /**
     * `AWS::LicenseManager::License.LicenseName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-licensename
     * @external
     */
    licenseName: string;
    /**
     * `AWS::LicenseManager::License.ProductName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-productname
     * @external
     */
    productName: string;
    /**
     * `AWS::LicenseManager::License.Validity`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-validity
     * @external
     */
    validity: CfnLicense.ValidityDateFormatProperty | cdk.IResolvable;
    /**
     * `AWS::LicenseManager::License.Beneficiary`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-beneficiary
     * @external
     */
    beneficiary: string | undefined;
    /**
     * `AWS::LicenseManager::License.LicenseMetadata`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-licensemetadata
     * @external
     */
    licenseMetadata: Array<CfnLicense.MetadataProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::LicenseManager::License.ProductSKU`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-productsku
     * @external
     */
    productSku: string | undefined;
    /**
     * `AWS::LicenseManager::License.Status`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html#cfn-licensemanager-license-status
     * @external
     */
    status: string | undefined;
    /**
     * Create a new `AWS::LicenseManager::License`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnLicenseProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::LicenseManager::License`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html
 * @external
 * @cloudformationResource AWS::LicenseManager::License
 */
export declare namespace CfnLicense {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-borrowconfiguration.html
     * @external
     */
    interface BorrowConfigurationProperty {
        /**
         * `CfnLicense.BorrowConfigurationProperty.AllowEarlyCheckIn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-borrowconfiguration.html#cfn-licensemanager-license-borrowconfiguration-allowearlycheckin
         * @external
         */
        readonly allowEarlyCheckIn: boolean | cdk.IResolvable;
        /**
         * `CfnLicense.BorrowConfigurationProperty.MaxTimeToLiveInMinutes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-borrowconfiguration.html#cfn-licensemanager-license-borrowconfiguration-maxtimetoliveinminutes
         * @external
         */
        readonly maxTimeToLiveInMinutes: number;
    }
}
/**
 * A CloudFormation `AWS::LicenseManager::License`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html
 * @external
 * @cloudformationResource AWS::LicenseManager::License
 */
export declare namespace CfnLicense {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-consumptionconfiguration.html
     * @external
     */
    interface ConsumptionConfigurationProperty {
        /**
         * `CfnLicense.ConsumptionConfigurationProperty.BorrowConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-consumptionconfiguration.html#cfn-licensemanager-license-consumptionconfiguration-borrowconfiguration
         * @external
         */
        readonly borrowConfiguration?: CfnLicense.BorrowConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnLicense.ConsumptionConfigurationProperty.ProvisionalConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-consumptionconfiguration.html#cfn-licensemanager-license-consumptionconfiguration-provisionalconfiguration
         * @external
         */
        readonly provisionalConfiguration?: CfnLicense.ProvisionalConfigurationProperty | cdk.IResolvable;
        /**
         * `CfnLicense.ConsumptionConfigurationProperty.RenewType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-consumptionconfiguration.html#cfn-licensemanager-license-consumptionconfiguration-renewtype
         * @external
         */
        readonly renewType?: string;
    }
}
/**
 * A CloudFormation `AWS::LicenseManager::License`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html
 * @external
 * @cloudformationResource AWS::LicenseManager::License
 */
export declare namespace CfnLicense {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-entitlement.html
     * @external
     */
    interface EntitlementProperty {
        /**
         * `CfnLicense.EntitlementProperty.AllowCheckIn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-entitlement.html#cfn-licensemanager-license-entitlement-allowcheckin
         * @external
         */
        readonly allowCheckIn?: boolean | cdk.IResolvable;
        /**
         * `CfnLicense.EntitlementProperty.MaxCount`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-entitlement.html#cfn-licensemanager-license-entitlement-maxcount
         * @external
         */
        readonly maxCount?: number;
        /**
         * `CfnLicense.EntitlementProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-entitlement.html#cfn-licensemanager-license-entitlement-name
         * @external
         */
        readonly name: string;
        /**
         * `CfnLicense.EntitlementProperty.Overage`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-entitlement.html#cfn-licensemanager-license-entitlement-overage
         * @external
         */
        readonly overage?: boolean | cdk.IResolvable;
        /**
         * `CfnLicense.EntitlementProperty.Unit`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-entitlement.html#cfn-licensemanager-license-entitlement-unit
         * @external
         */
        readonly unit: string;
        /**
         * `CfnLicense.EntitlementProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-entitlement.html#cfn-licensemanager-license-entitlement-value
         * @external
         */
        readonly value?: string;
    }
}
/**
 * A CloudFormation `AWS::LicenseManager::License`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html
 * @external
 * @cloudformationResource AWS::LicenseManager::License
 */
export declare namespace CfnLicense {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-issuerdata.html
     * @external
     */
    interface IssuerDataProperty {
        /**
         * `CfnLicense.IssuerDataProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-issuerdata.html#cfn-licensemanager-license-issuerdata-name
         * @external
         */
        readonly name: string;
        /**
         * `CfnLicense.IssuerDataProperty.SignKey`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-issuerdata.html#cfn-licensemanager-license-issuerdata-signkey
         * @external
         */
        readonly signKey?: string;
    }
}
/**
 * A CloudFormation `AWS::LicenseManager::License`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html
 * @external
 * @cloudformationResource AWS::LicenseManager::License
 */
export declare namespace CfnLicense {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-metadata.html
     * @external
     */
    interface MetadataProperty {
        /**
         * `CfnLicense.MetadataProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-metadata.html#cfn-licensemanager-license-metadata-name
         * @external
         */
        readonly name: string;
        /**
         * `CfnLicense.MetadataProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-metadata.html#cfn-licensemanager-license-metadata-value
         * @external
         */
        readonly value: string;
    }
}
/**
 * A CloudFormation `AWS::LicenseManager::License`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html
 * @external
 * @cloudformationResource AWS::LicenseManager::License
 */
export declare namespace CfnLicense {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-provisionalconfiguration.html
     * @external
     */
    interface ProvisionalConfigurationProperty {
        /**
         * `CfnLicense.ProvisionalConfigurationProperty.MaxTimeToLiveInMinutes`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-provisionalconfiguration.html#cfn-licensemanager-license-provisionalconfiguration-maxtimetoliveinminutes
         * @external
         */
        readonly maxTimeToLiveInMinutes: number;
    }
}
/**
 * A CloudFormation `AWS::LicenseManager::License`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-licensemanager-license.html
 * @external
 * @cloudformationResource AWS::LicenseManager::License
 */
export declare namespace CfnLicense {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-validitydateformat.html
     * @external
     */
    interface ValidityDateFormatProperty {
        /**
         * `CfnLicense.ValidityDateFormatProperty.Begin`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-validitydateformat.html#cfn-licensemanager-license-validitydateformat-begin
         * @external
         */
        readonly begin: string;
        /**
         * `CfnLicense.ValidityDateFormatProperty.End`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-licensemanager-license-validitydateformat.html#cfn-licensemanager-license-validitydateformat-end
         * @external
         */
        readonly end: string;
    }
}
