/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.common.chunkio;

import java.io.IOException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.function.Consumer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.chunk.storage.AnvilChunkLoader;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.chunkio.QueuedChunk;
import org.spongepowered.common.SpongeImpl;
import org.spongepowered.server.mixin.chunkio.ChunkProviderServerAccessor_Vanilla;
import org.spongepowered.server.mixin.core.world.chunk.storage.AnvilChunkLoaderAccessor_Vanilla;
import org.spongepowered.server.world.chunkio.AsyncAnvilChunkLoader;

class ChunkIOProvider
implements Runnable {
    private final QueuedChunk chunkInfo;
    private final AnvilChunkLoader loader;
    private final ChunkProviderServer provider;
    private Chunk chunk;
    private NBTTagCompound nbt;
    private final ConcurrentLinkedQueue<Consumer<Chunk>> callbacks = new ConcurrentLinkedQueue();
    private boolean ran = false;

    ChunkIOProvider(QueuedChunk chunk, AnvilChunkLoader loader, ChunkProviderServer provider) {
        this.chunkInfo = chunk;
        this.loader = loader;
        this.provider = provider;
    }

    public void addCallback(Consumer<Chunk> callback) {
        this.callbacks.add(callback);
    }

    public void removeCallback(Consumer<Chunk> callback) {
        this.callbacks.remove(callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ChunkIOProvider chunkIOProvider = this;
        synchronized (chunkIOProvider) {
            try {
                this.nbt = AsyncAnvilChunkLoader.read(this.loader, this.chunkInfo.x, this.chunkInfo.z);
                if (this.nbt != null) {
                    this.chunk = ((AnvilChunkLoaderAccessor_Vanilla)this.loader).accessor$checkedReadChunkFromNBT(this.chunkInfo.world, this.chunkInfo.x, this.chunkInfo.z, this.nbt);
                }
            }
            catch (IOException e) {
                SpongeImpl.getLogger().error("Could not load chunk in {} @ ({}, {})", (Object)this.chunkInfo.world, (Object)this.chunkInfo.x, (Object)this.chunkInfo.z, (Object)e);
            }
            this.ran = true;
            this.notifyAll();
        }
    }

    public void syncCallback() {
        if (this.chunk == null) {
            this.runCallbacks();
            return;
        }
        AsyncAnvilChunkLoader.loadEntities(this.chunkInfo.world, this.chunk, this.nbt);
        ChunkProviderServerAccessor_Vanilla accessor = (ChunkProviderServerAccessor_Vanilla)this.provider;
        this.chunk.func_177432_b(accessor.chunkIOAccessor$getWorld().func_82737_E());
        accessor.chunkIOAccessor$getChunkGenerator().func_180514_a(this.chunk, this.chunkInfo.x, this.chunkInfo.z);
        accessor.chunkIOAccessor$getLoadedChunks().put(ChunkPos.func_77272_a((int)this.chunkInfo.x, (int)this.chunkInfo.z), (Object)this.chunk);
        this.chunk.func_76631_c();
        this.chunk.func_186030_a((IChunkProvider)this.provider, accessor.chunkIOAccessor$getChunkGenerator());
        this.runCallbacks();
    }

    public Chunk getChunk() {
        return this.chunk;
    }

    public boolean runFinished() {
        return this.ran;
    }

    public boolean hasCallback() {
        return this.callbacks.size() > 0;
    }

    public void runCallbacks() {
        for (Consumer<Chunk> r : this.callbacks) {
            r.accept(this.chunk);
        }
        this.callbacks.clear();
    }
}

