/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.data;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.spongepowered.api.data.value.immutable.ImmutableValue;
import org.spongepowered.api.util.ResettableBuilder;

public final class DataTransactionResult {
    private static final DataTransactionResult SUCCESS_NODATA = DataTransactionResult.builder().result(Type.SUCCESS).build();
    private static final DataTransactionResult FAIL_NODATA = DataTransactionResult.builder().result(Type.FAILURE).build();
    final Type type;
    private final ImmutableList<ImmutableValue<?>> rejected;
    private final ImmutableList<ImmutableValue<?>> replaced;
    private final ImmutableList<ImmutableValue<?>> success;

    public static Builder builder() {
        return new Builder();
    }

    public static DataTransactionResult successNoData() {
        return SUCCESS_NODATA;
    }

    public static DataTransactionResult successResult(ImmutableValue<?> value) {
        return DataTransactionResult.builder().success(value).result(Type.SUCCESS).build();
    }

    public static DataTransactionResult successReplaceResult(ImmutableValue<?> successful, ImmutableValue<?> replaced) {
        return DataTransactionResult.builder().result(Type.SUCCESS).success(successful).replace(replaced).build();
    }

    public static DataTransactionResult successReplaceResult(Collection<ImmutableValue<?>> successful, Collection<ImmutableValue<?>> replaced) {
        return DataTransactionResult.builder().success(successful).replace(replaced).result(Type.SUCCESS).build();
    }

    public static DataTransactionResult successRemove(Collection<ImmutableValue<?>> removed) {
        return DataTransactionResult.builder().replace(removed).result(Type.SUCCESS).build();
    }

    public static DataTransactionResult successRemove(ImmutableValue<?> removed) {
        return DataTransactionResult.builder().replace(removed).result(Type.SUCCESS).build();
    }

    public static DataTransactionResult failResult(ImmutableValue<?> value) {
        return DataTransactionResult.builder().reject(value).result(Type.FAILURE).build();
    }

    public static DataTransactionResult failResult(Iterable<ImmutableValue<?>> values) {
        return DataTransactionResult.builder().reject(values).result(Type.FAILURE).build();
    }

    public static DataTransactionResult failNoData() {
        return FAIL_NODATA;
    }

    public static DataTransactionResult errorResult(ImmutableValue<?> value) {
        return DataTransactionResult.builder().result(Type.ERROR).reject(value).build();
    }

    DataTransactionResult(Builder builder) {
        this.type = builder.resultType;
        this.rejected = builder.rejected != null ? ImmutableList.copyOf(builder.rejected) : ImmutableList.of();
        this.replaced = builder.replaced != null ? ImmutableList.copyOf(builder.replaced) : ImmutableList.of();
        this.success = builder.successful != null ? ImmutableList.copyOf(builder.successful) : ImmutableList.of();
    }

    public Type getType() {
        return this.type;
    }

    public boolean isSuccessful() {
        return this.getType() == Type.SUCCESS;
    }

    public List<ImmutableValue<?>> getSuccessfulData() {
        return this.success;
    }

    public List<ImmutableValue<?>> getRejectedData() {
        return this.rejected;
    }

    public List<ImmutableValue<?>> getReplacedData() {
        return this.replaced;
    }

    public void ifSuccessful(Consumer<List<ImmutableValue<?>>> consumer) {
        if (this.isSuccessful()) {
            consumer.accept((List<ImmutableValue<?>>)this.success);
        }
    }

    @Deprecated
    public void ifSucessful(Consumer<List<ImmutableValue<?>>> consumer) {
        this.ifSuccessful(consumer);
    }

    public <E extends Exception> void ifNotSuccessful(Supplier<E> supplier) throws E {
        if (!this.isSuccessful()) {
            throw (Exception)supplier.get();
        }
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("resultType", (Object)this.type).add("rejectedData", this.rejected).add("replacedData", this.replaced).add("successfulData", this.success).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DataTransactionResult that = (DataTransactionResult)o;
        return this.type == that.type && Objects.equal(this.rejected, that.rejected) && Objects.equal(this.replaced, that.replaced) && Objects.equal(this.success, that.success);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.type, this.rejected, this.replaced, this.success});
    }

    public static final class Builder
    implements ResettableBuilder<DataTransactionResult, Builder> {
        List<ImmutableValue<?>> rejected;
        List<ImmutableValue<?>> replaced;
        List<ImmutableValue<?>> successful;
        Type resultType;

        Builder() {
        }

        public Builder result(Type type) {
            this.resultType = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type)));
            return this;
        }

        public Builder replace(ImmutableValue<?> value) {
            if (this.replaced == null) {
                this.replaced = Lists.newArrayList();
            }
            this.replaced.add((ImmutableValue<?>)Preconditions.checkNotNull(value));
            return this;
        }

        public Builder replace(Iterable<ImmutableValue<?>> values) {
            for (ImmutableValue<?> value : values) {
                this.replace((ImmutableValue)Preconditions.checkNotNull(value));
            }
            return this;
        }

        public Builder reject(ImmutableValue<?> value) {
            if (this.rejected == null) {
                this.rejected = Lists.newArrayList();
            }
            this.rejected.add((ImmutableValue<?>)Preconditions.checkNotNull(value));
            return this;
        }

        public Builder reject(Iterable<ImmutableValue<?>> values) {
            for (ImmutableValue<?> value : values) {
                this.reject((ImmutableValue)Preconditions.checkNotNull(value));
            }
            return this;
        }

        public Builder success(ImmutableValue<?> value) {
            if (this.successful == null) {
                this.successful = Lists.newArrayList();
            }
            this.successful.add((ImmutableValue<?>)Preconditions.checkNotNull(value));
            return this;
        }

        public Builder success(Iterable<ImmutableValue<?>> values) {
            for (ImmutableValue<?> value : values) {
                this.success((ImmutableValue)Preconditions.checkNotNull(value));
            }
            return this;
        }

        public Builder absorbResult(DataTransactionResult result) {
            if (this.resultType == null) {
                this.resultType = result.getType();
            } else if (this.resultType.compareTo(result.getType()) < 0) {
                this.resultType = result.getType();
            }
            ArrayList newSuccessful = Lists.newArrayList();
            ArrayList newReplaced = Lists.newArrayList();
            ArrayList newRejected = Lists.newArrayList();
            if (this.successful != null) {
                block0: for (ImmutableValue<?> value : this.successful) {
                    for (ImmutableValue<?> immutableValue : result.getRejectedData()) {
                        if (!value.getKey().equals(immutableValue.getKey())) continue;
                        newRejected.add(immutableValue);
                        continue block0;
                    }
                    for (ImmutableValue<Object> immutableValue : result.getReplacedData()) {
                        if (!value.getKey().equals(immutableValue.getKey())) continue;
                        newReplaced.add(value);
                        continue block0;
                    }
                    for (ImmutableValue<Object> immutableValue : result.getSuccessfulData()) {
                        if (!value.getKey().equals(immutableValue.getKey())) continue;
                        newSuccessful.add(immutableValue);
                        continue block0;
                    }
                    newSuccessful.add(value);
                }
            }
            if (this.replaced != null) {
                block4: for (ImmutableValue<?> value : this.replaced) {
                    for (ImmutableValue<Object> immutableValue : result.getRejectedData()) {
                        if (!value.getKey().equals(immutableValue.getKey())) continue;
                        newRejected.add(immutableValue);
                        continue block4;
                    }
                    for (ImmutableValue<Object> immutableValue : result.getReplacedData()) {
                        if (!value.getKey().equals(immutableValue.getKey())) continue;
                        newReplaced.add(value);
                        continue block4;
                    }
                    for (ImmutableValue<Object> immutableValue : result.getSuccessfulData()) {
                        if (!value.getKey().equals(immutableValue.getKey())) continue;
                        newSuccessful.add(immutableValue);
                        continue block4;
                    }
                    newReplaced.add(value);
                }
            }
            if (this.rejected != null) {
                block8: for (ImmutableValue<?> value : this.rejected) {
                    for (ImmutableValue<Object> immutableValue : result.getRejectedData()) {
                        if (!value.getKey().equals(immutableValue.getKey())) continue;
                        newRejected.add(immutableValue);
                        continue block8;
                    }
                    for (ImmutableValue<Object> immutableValue : result.getReplacedData()) {
                        if (!value.getKey().equals(immutableValue.getKey())) continue;
                        newReplaced.add(value);
                        continue block8;
                    }
                    for (ImmutableValue<Object> immutableValue : result.getSuccessfulData()) {
                        if (!value.getKey().equals(immutableValue.getKey())) continue;
                        newSuccessful.add(immutableValue);
                        continue block8;
                    }
                    newRejected.add(value);
                }
            }
            block12: for (ImmutableValue<?> value : result.getSuccessfulData()) {
                for (ImmutableValue<Object> immutableValue : newRejected) {
                    if (!value.getKey().equals(immutableValue.getKey())) continue;
                    continue block12;
                }
                for (ImmutableValue<Object> immutableValue : newReplaced) {
                    if (!value.getKey().equals(immutableValue.getKey())) continue;
                    continue block12;
                }
                for (ImmutableValue<Object> immutableValue : newSuccessful) {
                    if (!value.getKey().equals(immutableValue.getKey())) continue;
                    continue block12;
                }
                newSuccessful.add(value);
            }
            block16: for (ImmutableValue<?> value : result.getRejectedData()) {
                for (ImmutableValue<Object> immutableValue : newRejected) {
                    if (!value.getKey().equals(immutableValue.getKey())) continue;
                    continue block16;
                }
                for (ImmutableValue<Object> immutableValue : newReplaced) {
                    if (!value.getKey().equals(immutableValue.getKey())) continue;
                    continue block16;
                }
                for (ImmutableValue<Object> immutableValue : newSuccessful) {
                    if (!value.getKey().equals(immutableValue.getKey())) continue;
                    continue block16;
                }
                newRejected.add(value);
            }
            block20: for (ImmutableValue<?> value : result.getReplacedData()) {
                for (ImmutableValue<Object> immutableValue : newRejected) {
                    if (!value.getKey().equals(immutableValue.getKey())) continue;
                    continue block20;
                }
                for (ImmutableValue<Object> immutableValue : newReplaced) {
                    if (!value.getKey().equals(immutableValue.getKey())) continue;
                    continue block20;
                }
                for (ImmutableValue<Object> immutableValue : newSuccessful) {
                    if (!value.getKey().equals(immutableValue.getKey())) continue;
                    continue block20;
                }
                newReplaced.add(value);
            }
            this.replaced = newReplaced;
            this.rejected = newRejected;
            this.successful = newSuccessful;
            return this;
        }

        public DataTransactionResult build() {
            Preconditions.checkState((this.resultType != null ? 1 : 0) != 0);
            return new DataTransactionResult(this);
        }

        @Override
        public Builder from(DataTransactionResult value) {
            this.resultType = value.type;
            this.rejected = new ArrayList(value.getRejectedData());
            this.replaced = new ArrayList(value.getReplacedData());
            this.successful = new ArrayList(value.getSuccessfulData());
            return this;
        }

        @Override
        public Builder reset() {
            this.rejected = null;
            this.replaced = null;
            this.successful = null;
            this.resultType = null;
            return this;
        }
    }

    public static enum Type {
        UNDEFINED,
        SUCCESS,
        FAILURE,
        ERROR,
        CANCELLED;

    }
}

