/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.data.manipulator.mutable.common;

import com.google.common.base.Preconditions;
import java.util.Comparator;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.data.key.Key;
import org.spongepowered.api.data.manipulator.DataManipulator;
import org.spongepowered.api.data.manipulator.ImmutableDataManipulator;
import org.spongepowered.api.data.manipulator.mutable.common.AbstractSingleData;
import org.spongepowered.api.data.value.mutable.MutableBoundedValue;

public abstract class AbstractBoundedComparableData<T extends Comparable<T>, M extends DataManipulator<M, I>, I extends ImmutableDataManipulator<I, M>>
extends AbstractSingleData<T, M, I> {
    protected final Comparator<T> comparator;
    protected final T lowerBound;
    protected final T upperBound;
    protected final T defaultValue;

    @Deprecated
    protected AbstractBoundedComparableData(T value, Key<MutableBoundedValue<T>> usedKey, Comparator<T> comparator, T lowerBound, T upperBound, T defaultValue) {
        this(usedKey, value, defaultValue, lowerBound, upperBound, comparator);
    }

    protected AbstractBoundedComparableData(Key<MutableBoundedValue<T>> usedKey, T value, T lowerBound, T upperBound, Comparator<T> comparator) {
        this(usedKey, value, value, lowerBound, upperBound, comparator);
    }

    protected AbstractBoundedComparableData(Key<MutableBoundedValue<T>> usedKey, T value, T defaultValue, T lowerBound, T upperBound, Comparator<T> comparator) {
        super(usedKey, value, defaultValue);
        this.comparator = (Comparator)Preconditions.checkNotNull(comparator, (Object)"comparator");
        this.lowerBound = (Comparable)Preconditions.checkNotNull(lowerBound, (Object)"lowerBound");
        this.upperBound = (Comparable)Preconditions.checkNotNull(upperBound, (Object)"upperBound");
        this.checkValue(value, "value");
        this.checkValue(defaultValue, "defaultValue");
        this.defaultValue = defaultValue;
    }

    private void checkValue(T value, String name) {
        Preconditions.checkArgument((this.comparator.compare(this.lowerBound, value) <= 0 ? 1 : 0) != 0, (String)"%s %s is lesser than the lower bound %s", (Object)name, value, this.lowerBound);
        Preconditions.checkArgument((this.comparator.compare(this.upperBound, value) >= 0 ? 1 : 0) != 0, (String)"%s %s is greater than the upper bound %s", (Object)name, value, this.upperBound);
    }

    @Override
    protected MutableBoundedValue<T> getValueGetter() {
        return Sponge.getRegistry().getValueFactory().createBoundedValueBuilder(this.usedKey).defaultValue(this.defaultValue).comparator(this.comparator).minimum(this.lowerBound).maximum(this.upperBound).actualValue(this.getValue()).build();
    }

    @Override
    public M setValue(T value) {
        this.checkValue(value, "value");
        return super.setValue(value);
    }

    @Override
    public DataContainer toContainer() {
        return super.toContainer();
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 31 * hash + this.lowerBound.hashCode();
        hash = 31 * hash + this.upperBound.hashCode();
        hash = 31 * hash + this.comparator.hashCode();
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        AbstractBoundedComparableData other = (AbstractBoundedComparableData)obj;
        return other.upperBound.equals(this.upperBound) && other.lowerBound.equals(this.lowerBound) && other.comparator.equals(this.comparator);
    }
}

