/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.effect.potion;

import org.spongepowered.api.Sponge;
import org.spongepowered.api.data.DataSerializable;
import org.spongepowered.api.data.persistence.DataBuilder;
import org.spongepowered.api.data.property.PropertyHolder;
import org.spongepowered.api.effect.potion.PotionEffectType;

public interface PotionEffect
extends DataSerializable,
PropertyHolder {
    public static Builder builder() {
        return Sponge.getRegistry().createBuilder(Builder.class);
    }

    public static PotionEffect of(PotionEffectType type, int amplifier, int duration) {
        return PotionEffect.builder().potionType(type).amplifier(amplifier).duration(duration).build();
    }

    public PotionEffectType getType();

    public int getDuration();

    public int getAmplifier();

    public boolean isAmbient();

    public boolean getShowParticles();

    public static interface Builder
    extends DataBuilder<PotionEffect> {
        @Override
        public Builder from(PotionEffect var1);

        public Builder potionType(PotionEffectType var1);

        public Builder duration(int var1);

        public Builder amplifier(int var1) throws IllegalArgumentException;

        public Builder ambience(boolean var1);

        public Builder particles(boolean var1);

        public PotionEffect build() throws IllegalStateException;

        @Override
        public Builder reset();
    }
}

