/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.item.inventory.property;

import com.flowpowered.math.vector.Vector2i;
import org.spongepowered.api.data.Property;
import org.spongepowered.api.item.inventory.property.AbstractInventoryProperty;
import org.spongepowered.api.util.Coerce;

public class SlotPos
extends AbstractInventoryProperty<String, Vector2i> {
    public SlotPos(Vector2i value) {
        super(value);
    }

    public SlotPos(int x, int y) {
        super(new Vector2i(x, y));
    }

    public SlotPos(Vector2i value, Property.Operator operator) {
        super(value, operator);
    }

    public SlotPos(int x, int y, Property.Operator operator) {
        super(new Vector2i(x, y), operator);
    }

    public SlotPos(Object value, Property.Operator operator) {
        super(Coerce.toVector2i(value), operator);
    }

    public int getX() {
        return ((Vector2i)this.getValue()).getX();
    }

    public int getY() {
        return ((Vector2i)this.getValue()).getY();
    }

    @Override
    public int compareTo(Property<?, ?> other) {
        if (other == null) {
            return 1;
        }
        return ((Vector2i)this.getValue()).compareTo(Coerce.toVector2i(other.getValue()));
    }

    public static SlotPos of(Object value) {
        return new SlotPos(value, Property.Operator.EQUAL);
    }

    public static SlotPos of(int x, int y) {
        return new SlotPos(new Vector2i(x, y), Property.Operator.EQUAL);
    }

    public static SlotPos not(Object value) {
        return new SlotPos(value, Property.Operator.NOTEQUAL);
    }

    public static SlotPos greaterThan(Object value) {
        return new SlotPos(value, Property.Operator.GREATER);
    }

    public static SlotPos greaterThanOrEqual(Object value) {
        return new SlotPos(value, Property.Operator.GEQUAL);
    }

    public static SlotPos lessThan(Object value) {
        return new SlotPos(value, Property.Operator.LESS);
    }

    public static SlotPos lessThanOrEqual(Object value) {
        return new SlotPos(value, Property.Operator.LEQUAL);
    }
}

