/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.profile;

import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import org.spongepowered.api.profile.GameProfile;

public interface GameProfileCache {
    default public boolean add(GameProfile profile) {
        return this.add(profile, (Instant)null);
    }

    @Deprecated
    default public boolean add(GameProfile profile, @Nullable Date expiry) {
        return this.add(profile, expiry == null ? null : expiry.toInstant());
    }

    default public boolean add(GameProfile profile, @Nullable Instant expiry) {
        return this.add(profile, false, expiry);
    }

    @Deprecated
    default public boolean add(GameProfile profile, boolean overwrite, @Nullable Date expiry) {
        return this.add(profile, overwrite, expiry == null ? null : expiry.toInstant());
    }

    public boolean add(GameProfile var1, boolean var2, @Nullable Instant var3);

    public boolean remove(GameProfile var1);

    public Collection<GameProfile> remove(Iterable<GameProfile> var1);

    public void clear();

    public Optional<GameProfile> getById(UUID var1);

    public Map<UUID, Optional<GameProfile>> getByIds(Iterable<UUID> var1);

    public Optional<GameProfile> lookupById(UUID var1);

    public Map<UUID, Optional<GameProfile>> lookupByIds(Iterable<UUID> var1);

    public Optional<GameProfile> getOrLookupById(UUID var1);

    public Map<UUID, Optional<GameProfile>> getOrLookupByIds(Iterable<UUID> var1);

    public Optional<GameProfile> getByName(String var1);

    public Map<String, Optional<GameProfile>> getByNames(Iterable<String> var1);

    public Optional<GameProfile> lookupByName(String var1);

    public Map<String, Optional<GameProfile>> lookupByNames(Iterable<String> var1);

    public Optional<GameProfile> getOrLookupByName(String var1);

    public Map<String, Optional<GameProfile>> getOrLookupByNames(Iterable<String> var1);

    default public Optional<GameProfile> fillProfile(GameProfile profile) {
        return this.fillProfile(profile, false);
    }

    public Optional<GameProfile> fillProfile(GameProfile var1, boolean var2);

    public Collection<GameProfile> getProfiles();

    public Collection<GameProfile> match(String var1);
}

