/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.service.pagination;

import com.google.common.base.Preconditions;
import java.util.Optional;
import javax.annotation.Nullable;
import org.spongepowered.api.Sponge;
import org.spongepowered.api.service.pagination.PaginationService;
import org.spongepowered.api.text.Text;
import org.spongepowered.api.text.channel.MessageReceiver;
import org.spongepowered.api.util.ResettableBuilder;

public interface PaginationList {
    public static Builder builder() {
        return Sponge.getServiceManager().provideUnchecked(PaginationService.class).builder();
    }

    public Iterable<Text> getContents();

    public Optional<Text> getTitle();

    public Optional<Text> getHeader();

    public Optional<Text> getFooter();

    public Text getPadding();

    public int getLinesPerPage();

    default public void sendTo(MessageReceiver receiver) {
        this.sendTo(receiver, 1);
    }

    public void sendTo(MessageReceiver var1, int var2);

    default public void sendTo(Iterable<MessageReceiver> receivers) {
        this.sendTo(receivers, 1);
    }

    default public void sendTo(Iterable<MessageReceiver> receivers, int page) {
        Preconditions.checkNotNull(receivers, (Object)"The iterable of receivers cannot be null!");
        for (MessageReceiver receiver : receivers) {
            this.sendTo(receiver, page);
        }
    }

    public static interface Builder
    extends ResettableBuilder<PaginationList, Builder> {
        public Builder contents(Iterable<Text> var1);

        public Builder contents(Text ... var1);

        public Builder title(@Nullable Text var1);

        public Builder header(@Nullable Text var1);

        public Builder footer(@Nullable Text var1);

        public Builder padding(Text var1);

        public Builder linesPerPage(int var1);

        public PaginationList build();

        default public PaginationList sendTo(MessageReceiver receiver) {
            PaginationList list = this.build();
            list.sendTo(receiver);
            return list;
        }

        default public PaginationList sendTo(Iterable<MessageReceiver> receivers) {
            Preconditions.checkNotNull(receivers, (Object)"The iterable of receivers cannot be null!");
            PaginationList list = this.build();
            for (MessageReceiver r : receivers) {
                list.sendTo(r);
            }
            return list;
        }
    }
}

