/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.text;

import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.spongepowered.api.text.Text;

final class TextIterator
implements Iterator<Text> {
    private final Text text;
    @Nullable
    private Iterator<Text> children;
    @Nullable
    private Iterator<Text> currentChildIterator;

    TextIterator(Text text) {
        this.text = text;
    }

    @Override
    public boolean hasNext() {
        return this.children == null || this.currentChildIterator != null && this.currentChildIterator.hasNext() || this.children.hasNext();
    }

    @Override
    public Text next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        if (this.children == null) {
            this.children = this.text.children.iterator();
            return this.text;
        }
        if (this.currentChildIterator == null || !this.currentChildIterator.hasNext()) {
            this.currentChildIterator = this.children.next().childrenIterable.iterator();
        }
        return this.currentChildIterator.next();
    }
}

