/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.api.util;

import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public final class CollectionUtils {
    public static <K, V> Map<K, V> copyMap(Map<? extends K, ? extends V> map) {
        try {
            if (map instanceof HashMap) {
                return (Map)((HashMap)map).clone();
            }
            if (map instanceof IdentityHashMap) {
                return (Map)((IdentityHashMap)map).clone();
            }
            if (map instanceof EnumMap) {
                return ((EnumMap)map).clone();
            }
            if (map instanceof TreeMap) {
                return (Map)((TreeMap)map).clone();
            }
            if (map instanceof ConcurrentHashMap) {
                return new ConcurrentHashMap<K, V>(map);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new HashMap<K, V>(map);
    }

    public static <T> List<T> copyList(List<? extends T> list) {
        try {
            if (list instanceof ArrayList) {
                return (List)((ArrayList)list).clone();
            }
            if (list instanceof LinkedList) {
                return (List)((LinkedList)list).clone();
            }
            if (list instanceof CopyOnWriteArrayList) {
                return (List)((CopyOnWriteArrayList)list).clone();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new ArrayList<T>(list);
    }

    private CollectionUtils() {
        throw new AssertionError((Object)"You should not be attempting to instantiate this class.");
    }
}

