/*
 * Decompiled with CFR 0.152.
 */
package org.spongepowered.common.block;

import com.google.common.base.MoreObjects;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.spongepowered.api.block.BlockSnapshot;
import org.spongepowered.api.block.BlockState;
import org.spongepowered.api.block.tileentity.TileEntityArchetype;
import org.spongepowered.api.block.tileentity.TileEntityType;
import org.spongepowered.api.data.DataContainer;
import org.spongepowered.api.world.BlockChangeFlags;
import org.spongepowered.api.world.Location;
import org.spongepowered.common.block.SpongeBlockSnapshotBuilder;
import org.spongepowered.common.block.SpongeTileEntityArchetypeBuilder;
import org.spongepowered.common.data.AbstractArchetype;
import org.spongepowered.common.data.nbt.NbtDataType;
import org.spongepowered.common.data.nbt.NbtDataTypes;
import org.spongepowered.common.data.nbt.validation.ValidationType;
import org.spongepowered.common.data.nbt.validation.Validations;
import org.spongepowered.common.data.persistence.NbtTranslator;
import org.spongepowered.common.util.Constants;
import org.spongepowered.common.util.VecHelper;

public class SpongeTileEntityArchetype
extends AbstractArchetype<TileEntityType, BlockSnapshot, org.spongepowered.api.block.tileentity.TileEntity>
implements TileEntityArchetype {
    final BlockState blockState;

    SpongeTileEntityArchetype(SpongeTileEntityArchetypeBuilder builder) {
        super(builder.tileEntityType, NbtTranslator.getInstance().translateData(builder.tileData));
        this.blockState = builder.blockState;
    }

    @Override
    public BlockState getState() {
        return this.blockState;
    }

    @Override
    public TileEntityType getTileEntityType() {
        return (TileEntityType)this.type;
    }

    @Override
    public DataContainer getTileData() {
        return NbtTranslator.getInstance().translateFrom(this.data);
    }

    @Override
    public Optional<org.spongepowered.api.block.tileentity.TileEntity> apply(Location<org.spongepowered.api.world.World> location) {
        BlockState currentState = location.getBlock();
        Block currentBlock = ((IBlockState)currentState).func_177230_c();
        Block newBlock = ((IBlockState)this.blockState).func_177230_c();
        World minecraftWorld = (World)location.getExtent();
        BlockPos blockpos = VecHelper.toBlockPos(location);
        if (currentBlock != newBlock) {
            ((org.spongepowered.api.world.World)minecraftWorld).setBlock(blockpos.func_177958_n(), blockpos.func_177956_o(), blockpos.func_177952_p(), this.blockState, BlockChangeFlags.ALL);
        }
        NBTTagCompound compound = this.data.func_74737_b();
        TileEntity tileEntity = minecraftWorld.func_175625_s(blockpos);
        if (tileEntity == null) {
            return Optional.empty();
        }
        compound.func_74768_a("x", blockpos.func_177958_n());
        compound.func_74768_a("y", blockpos.func_177956_o());
        compound.func_74768_a("z", blockpos.func_177952_p());
        tileEntity.func_145839_a(compound);
        tileEntity.func_70296_d();
        return Optional.of((org.spongepowered.api.block.tileentity.TileEntity)tileEntity);
    }

    @Override
    public BlockSnapshot toSnapshot(Location<org.spongepowered.api.world.World> location) {
        SpongeBlockSnapshotBuilder builder = SpongeBlockSnapshotBuilder.pooled();
        builder.blockState = this.blockState;
        builder.compound = this.data.func_74737_b();
        builder.worldUuid = location.getExtent().getUniqueId();
        builder.coords = location.getBlockPosition();
        return builder.build();
    }

    @Override
    public int getContentVersion() {
        return 1;
    }

    @Override
    public DataContainer toContainer() {
        return DataContainer.createNew().set(Constants.Sponge.TileEntityArchetype.TILE_TYPE, (Object)this.type).set(Constants.Sponge.TileEntityArchetype.BLOCK_STATE, (Object)this.blockState).set(Constants.Sponge.TileEntityArchetype.TILE_DATA, (Object)this.getTileData());
    }

    @Override
    protected NbtDataType getDataType() {
        return NbtDataTypes.TILE_ENTITY;
    }

    @Override
    protected ValidationType getValidationType() {
        return Validations.TILE_ENTITY;
    }

    @Override
    public TileEntityArchetype copy() {
        SpongeTileEntityArchetypeBuilder builder = new SpongeTileEntityArchetypeBuilder();
        builder.tileEntityType = (TileEntityType)this.type;
        builder.tileData = NbtTranslator.getInstance().translate(this.data);
        builder.blockState = this.blockState;
        return builder.build();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        SpongeTileEntityArchetype that = (SpongeTileEntityArchetype)o;
        return this.blockState.equals(that.blockState);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.blockState);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("state", (Object)this.blockState).add("data", (Object)this.data).toString();
    }
}

